/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeSwitchPowerCommand
extends MicroBladeCommand {
    @Override
    public void execute() throws Exception {
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            this.statusCode = 145;
            return;
        }
        if (this.getParameters() == null) {
            this.printUsage();
        } else if (this.getParameters().length == 1) {
            int sIndex = SwitchInfo.getIndex(this.getParameters()[0]);
            if (sIndex < 0) {
                MOut.G(this).println("The Switch index must be A1-A2 or B1-B2");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            SwitchInfo switchInfo = ipmiMicroBladeOEMCommand.getSwitch((byte)sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            byte result = ipmiMicroBladeOEMCommand.getSwitchPowerStatus(sIndex + 1);
            String s = "Unknown";
            if (result == 0) {
                s = "Off";
            } else if (result == 1) {
                s = "On";
            }
            this.printUsage();
            MOut.G(this).println(this.getParameters()[0] + " power is " + s);
        } else if (this.getParameters().length == 2) {
            int sIndex = SwitchInfo.getIndex(this.getParameters()[0]);
            if (sIndex < 0) {
                MOut.G(this).println("The Switch index must be A1-A2 or B1-B2");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            SwitchInfo switchInfo = ipmiMicroBladeOEMCommand.getSwitch((byte)sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            ++sIndex;
            boolean result = false;
            if (this.getParameters()[1].equalsIgnoreCase("on")) {
                result = ipmiMicroBladeOEMCommand.setSwitchPowerStatus(sIndex, (byte)1);
            } else if (this.getParameters()[1].equalsIgnoreCase("off")) {
                result = ipmiMicroBladeOEMCommand.setSwitchPowerStatus(sIndex, (byte)0);
            } else if (this.getParameters()[1].equalsIgnoreCase("reset")) {
                result = ipmiMicroBladeOEMCommand.setSwitchPowerReset(sIndex);
            } else {
                this.printUsage();
            }
            if (result) {
                this.statusCode = 0;
                MOut.G(this).println("Done");
            } else {
                this.statusCode = 149;
            }
        } else {
            this.printUsage();
        }
        this.statusCode = 0;
        sessionController.closeSession();
    }

    public void printUsage() {
        MOut.G(this).println("Usage: microBlade switch power <switch index> [option]");
        MOut.G(this).println("       For options: Reset\n");
    }
}

