unit Amd;

interface
uses
  SysUtils,hda;


procedure AMD_SB_Cfg_Azalia_Delay; export;
procedure AMD_fixed_delay1ms; export;
procedure AMD_fixed_delay(delay:longint); export;
function AMD_immediat_Command_Output_Interface(value:longint):shortint; export;
function  ATI_IC_GET(codecid:byte;command:longint):longint;export;
function wait_for_stupid:shortint;export;
function acknowledge_validation:byte;
implementation



{This is how AMD does a 30 uSec delay}
procedure AMD_fixed_delay(delay:longint);
begin
 while (delay>0) do begin
  while (port[$61] and 16)=16 do begin {wait till port $61 changes}  end;
 delay:=delay-1;
  while (port[$61] and 16)=0 do begin {wait till port $61 changes}  end;
end;
end;

{This is how AMD does a 1 mSec delay}
procedure AMD_fixed_delay1ms; begin
AMD_fixed_delay(1000 div 15);
end;


{This is how AMD waits approx 4*7 uSec? (or is it 4*7*30 uSec?)}
procedure AMD_SB_Cfg_Azalia_Delay; begin
AMD_fixed_delay(4);
end;

{This is how AMD sends Verbs}
function AMD_immediat_Command_Output_Interface(value:longint):shortint;
var L:longint;
begin
L:=$FFFF;
result:=-1;
while ((wstr(mpch)^.test[$68 div 2] and 1)=0)and(L>0) do begin {Wait till IC not busy}end;
if(L>0)then result:=0;{no error}
lstr(mpch)^[$60 div 4]:=longint(value or longint(longint(longint(audio_pci.codec_index) and $0F) shl 28));
AMD_SB_Cfg_Azalia_Delay;
end;


function wait_for_valid:shortint;
var timeout:integer;
var word32:longint;
begin
result:=-1;
timeout:=$3FFF;
 while timeout>0 do begin
 word32:=hda_INL($68);
   if((word32 and 3)=2)then begin result:=0;timeout:=0;{validated!}end else
 AMD_fixed_delay(2);{60us?}
 timeout:=timeout-1;
 end;
end;

{Wait 50usec for the codec to indicate it is ready
No response would imply that the codec is non-operative}
function wait_for_ready:shortint;
var timeout:integer;
var word32:longint;
begin
result:=-1;
timeout:=5000;
 while timeout>0 do begin
 word32:=hda_INL($68);
   if not((word32 and 1)=1)then begin result:=0;timeout:=0;{Not busy!}end else
 begin AMD_fixed_delay(3);{60us?}end;
 timeout:=timeout-1;
 end;
end;



{Wait 50usec for the codec to indicate it is stupid
No response would imply that the codec is non-operative}
function wait_for_stupid:shortint;
var timeout:integer;
var word32:longint;
begin
result:=-1;
timeout:=50;
 while timeout>0 do begin
 word32:=hda_INL($68);
   if ((word32 and 3)=3)then begin {Codec busy and ready!}hda_OUTL($68,word32 or 2);end else
   if ((word32 and 1)=1)then begin {Codec busy!}hda_OUTL($68,word32 or 2);end else
   if ((word32 and 2)=2)then begin {Codec ready!}hda_OUTL($68,word32 or 2);end else
   if ((word32 and 3)=0)then begin result:=0;timeout:=0;{Codec is OK!}end else
   begin {CODEC}end;
 AMD_fixed_delay(4);{+60us?}
 timeout:=timeout-1;
 end;
end;

function acknowledge_validation:byte;
var word32:longint;
var timeout:integer;
begin
 word32:=hda_INL($68);
 HDA_OUTL($68,word32 or 2);
 result:=wait_for_stupid;
end;



function ATI_IC_GET(codecid:byte;command:longint):longint;
begin
result:=$FFFFFFFF;
 if(wait_for_ready=0)then begin
  {AMD_immediat_Command_Output_Interface(command);}
  HDA_OUTL($60,longint(command or longint(longint(longint(codecid) shl 28))));
{  AMD_SB_Cfg_Azalia_Delay;}
    if(wait_for_valid=0)then begin
     result:=hda_INL($64);
    end else begin
     result:=$0BADFEED;
    end;
 end else begin
  result:=longint($BADC0DEC);
 end;

end;

end.
