/*
    filename:  video.h
    owner:     Michel Pelletier

COPYRIGHT (c) 1990  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

typedef struct {
	DWORD laddr;           /* first invalid local ram address */
	WORD  scrw;            /* visible screen width in pixels */
	WORD  scrh;            /* visible screen height in pixels */
	WORD  ncolors;         /* number of simultaneous colors on screen */
	WORD  nluts;           /* number of luts */
	WORD  maxred;          /* maximum red intensity */
	WORD  maxgreen;        /* maximum green intensity */
	WORD  maxblue;         /* maximum blue intensity */
	WORD  fbwidth;         /* frame buffer width in pixels */
	WORD  fbheight;        /* frame buffer height in scan lines */
	WORD  fbpitch;         /* frame buffer pitch in bits */
	BYTE  bitspix;         /* frame buffer format: bits per pixel */
	BYTE  nplanes;         /* frame buffer format: planes in frame buff */
	DWORD topleft;         /* address of frame buffer top-left corner */
	WORD  fbshift;         /* shift count value for FB width */
	WORD  boardtype:8;     /* board type */
	WORD  hosttype:8;      /* host computer type */
	WORD  version;         /* version number */
	WORD  hesync;          /* horizontal sync end */
	WORD  heblnk;          /* horizontal blank end */
	WORD  hsblnk;          /* horizontal blank start */
	WORD  htotal;          /* horizontal total */
	WORD  vesync;          /* vertical sync end */
	WORD  veblnk;          /* vertical blank end */
	WORD  vsblnk;          /* vertical blank start */
	WORD  vtotal;          /* vertical total */
	WORD  dpystrt;         /* display start address */
	WORD  dpyint;          /* display interrupt location */
	WORD  psize;           /* pixel size */
	union	{		/* bit encoded configuration value */
		struct	{
			WORD  sync_format:3;
			WORD  interlaced:1;
			WORD  european:1;
			WORD  vga_switch:1;
			WORD  reserved:10;
			} im_1280;
		struct	{
			WORD  sync_format:3;
			WORD  interlaced:1;
			WORD  european:1;
			WORD  vga_switch:1;
			WORD  reserved:10;
			} im_640;
		struct	{
			WORD  sync_format:3;
			WORD  interlaced:1;
			WORD  european:1;
			WORD  vga_switch:3;
			WORD  vga_comp:1;
			WORD  clk_div:2;
			WORD  clk_pan:2;
			WORD  compatibility:1;
			WORD  crystal:1;
			WORD  reserved:1;
			} im_lc;
		} dpytap;
	WORD  control;         /* control register */
	WORD  intenb;          /* interrupt enable */
	WORD  dpyctl;          /* display control */
	union	{
		WORD  unused;
		struct	{
			WORD  vsetup:1;        /* system control register */
			WORD  ecblnk:1;
			WORD  esync:1;
			WORD  edclk:1;
			WORD  sahsync:1;
			WORD  sablnk:1;
			WORD  dpolh:1;
			WORD  dpolv:1;
			WORD  apolh:1;
			WORD  apolv:1;
			WORD  reserved:6;
			} imlc;
		} sysctl;
	union	{
		WORD  pll_div;		/* IM-640 output PLL division factor */
		struct	{
			WORD  m_factor:7;
			WORD  p_factor:2;
			WORD  n_factor:7;
			} lc;			/* IM-LC synthesizer control */
		} bigamode;
	} VIDPARMS ;

char *sysdef_name[] = {	
			"laddr",
			"scrw",
			"scrh",
			"ncolors",
			"nluts",
			"maxred",
			"maxgreen",
			"maxblue",
			"fbwidth",
			"fbheight",
			"fbpitch",
			"bitspix",
			"nplanes",
			"topleft",
			"fbshift",
			"boardtype",
			"version" };

int sysdef_len[] = {
			sizeof( DWORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( BYTE ),
			sizeof( BYTE ),
			sizeof( DWORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ) };

char *sysdef_expl[] = {	
			"first invalid local ram adress",
			"visible screen width in pixels",
			"visible screen height in pixels",
			"number of simultaneous colors on screen",
			"number of physical LUTs",
			"maximum red intensity",
			"maximum green intensity",
			"maximum blue intensity",
			"frame buffer width in pixels",
			"frame buffer height in scan lines",
			"frame buffer pitch in bits",
			"number of contiguous bits per pixel",
			"number of planes in frame buffer",
			"address of frame buffer top-left corner",
			"frame buffer width",
			"board type",
			"version stamp" };

char *vidparm_name[] = {
			"hesync",
			"heblnk",
			"hsblnk",
			"htotal",
			"vesync",
			"veblnk",
			"vsblnk",
			"vtotal",
			"dpystrt",
			"dpyint",
			"psize",
			"dpytap",
			"control",
			"intenb",
			"dpyctl",
			"sysctl",
			"bigamode" };

int vidparm_len[] = {
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ),
			sizeof( WORD ) };

char *vidparm_expl[] ={	
			"horizontal sync end",
			"horizontal blank end",
			"horizontal blank start",
			"horizontal total",
			"vertical sync end",
			"vertical blank end",
			"vertical blank start",
			"vertical total",
			"display start address",
			"display interrupt location",
			"pixel size",
			"display tap point",
			"control register",
			"interrupt enable", 
			"display control",
			"system control register", 
			"biga mode control register" };
