/*****************************************************************/
/*                             INIT.C                            */
/*****************************************************************/
/*
*  By:		Michel Pelletier
*		Matrox Electronic Systems ltd.
*
*  Date:	May 3rd, 1993
*
*  Synopsys:	This file contains functions for initializing the
*		Image-Series board-set.
*
*  Copyright (C) 1993.  Matrox Electronic Systems, Ltd.
*  All rights reserved
*/
/*****************************************************************/

/************************/
/* Inclusion statements */
/************************/
#include <grabtest.h>

/***********/
/* Globals */
/***********/
extern	unsigned short	OVR_lutreddata[], OVR_lutgreendata[], OVR_lutbluedata[];
extern 	int		OVRLocation, grab_source, grab_destination, handle;
extern 	short		screen_w, screen_h, roix, roiy, roi_posx, roi_posy, interlace;
extern 	short		board_type, asd_quantity, rtp_quantity, alu_quantity, opt_memory;
extern 	short		vga_ovrmode, logcam;
extern 	signed long	blackref;
extern 	signed long	whiteref;
extern	unsigned long	gain;
extern	int		xmem_size, ymem_size, grabbing_mode;
extern	int		xdisp_zoom, ydisp_zoom;
extern	int		xovr_zoom, yovr_zoom;
extern	int		xdisp_pos, ydisp_pos;
extern	long		exposure, transfer;
extern	unsigned short	i_v_factable[];

void init_image_series( void )
{
/****************************/
/* Halt any ongoing process */
/****************************/
pchlprocqueue( 0 );
HostWait4Gsp;

/*******************************/
/* Reset processing parameters */
/*******************************/
pcslprocmode( I_QUEUED + I_PROCESSING_ORIENTED );
HostWait4Proc;
pcstbinarize( I_SRC1, 0xffff, I_DONT_BINARIZE, 0 );
pcstbinarize( I_SRC2, 0xffff, I_DONT_BINARIZE, 0 );
pcstoverscan( I_REPLACE, 0 );
pcstsrcmsk( I_SRC1, 0xffff );
pcstsrcmsk( I_SRC2, 0xffff );
pcstdstmsk( 0xffffffffL );
pcstlattice( I_RECT );
pcstooi( 0, 0, 0, I_EVERYWHERE );
pcstformat( I_UNSIGNED_8, I_UNSIGNED_8, I_UNSIGNED_8 );
pcstsubsamp( 1 );
pcstdir( I_NORMAL, I_NORMAL );

/*************************/
/* Select Logical Camera */
/*************************/
pcsllogcam( logcam );
HostWait4All;

/***********************************************/
/* Validate the current hardware configuration */
/***********************************************/
pciqsys( I_IQ_BOARD_TYPE, &board_type );
board_type &= 0x00ff;
pciqsys( I_IQ_ASD_QTY, &asd_quantity );
pciqsys( I_IQ_RTP_QTY, &rtp_quantity );
pciqsys( I_IQ_OPT_MEM, &opt_memory );
if( !asd_quantity )
	{
	printf( "This program requires an Asynchronous Digitizer.\n" );
	iorlmemdevice( handle );
	iocldevice( handle );
	exit( -1 );
	}
if( !rtp_quantity )
	{
	if( board_type == IMAGE_LC )
		{
		printf( "This program requires a Real-Time Processor board.\n" );
		}
	else
		{
		printf( "This program requires the Neighberhood Processor option.\n" );
		}
	iorlmemdevice( handle );
	iocldevice( handle );
	exit( -1 );
	}

/**************************************/
/* Initialise and clear frame buffers */
/**************************************/
switch( board_type )
	{
	case IMAGE_1280:
	OVRLocation = IM_OVERLAY;	/* Draw in overlay buffer */
	init_overlay_luts();
	pcstfborg( I_FB1X2KX2KX8 );
	HostWait4Proc;
	lsdcstdmode( I_FB03_2K_2K_8 );
	xmem_size = 2048;
	ymem_size = 2048;
	krhwsclipr( 0, 0, xmem_size - 1, ymem_size - 1 );
	grab_source = I_DIG_8 + I_ROI1;
	grab_destination = I_FB0 + I_ROI2;	/* Grab into FB0 */
	lsdcstrdmask( 0x3ff, 0x3ff, 0x3ff, 0x3ff, 0x3ff, 0x3ff );
	lsdcstvgamode( I_NOVGA );
	krhwslcsurf( I_OVL_SURF );
	krhwcclr( 0x0 );
	lsdcstopal( 0 );
	lsdcstmsbsource( I_FBPAL );
	break;

	case IMAGE_640:
	OVRLocation = IM_OVERLAY;	/* Draw in overlay buffer */
	init_overlay_luts();
	i_v_factable[7] = 1;		/* This is for iordfbarea() to work properly */
	if( opt_memory == 0 )
		{
		pcstfborg( I_FB1X2KX2KX8 );	/* With optionnal memory */
		HostWait4Proc;
		lsdcstdmode( I_FB03_2K_2K_8 );
		xmem_size = 2048;
		ymem_size = 2048;
		}
	else
		{
		pcstfborg( I_FB1X2KX2KX8 );	/* Without optionnal memory */
		HostWait4Proc;
		lsdcstdmode( I_FB03_2K_1K_8 );
		xmem_size = 2048;
		ymem_size = 1024;
		}
	krhwsclipr( 0, 0, xmem_size - 1, ymem_size - 1 );
	grab_source = I_DIG_8 + I_ROI1;
	grab_destination = I_FB0 + I_ROI2;	/* Grab into FB0 */
	lsdcstrdmask( 0x3ff, 0x3ff, 0x3ff, 0x3ff, 0x3ff, 0x3ff );
	lsdcstvgamode( I_NOVGA );
	krhwslcsurf( I_OVL_SURF );
	krhwcclr( 0x0 );
	lsdcstopal( 0 );
	lsdcstmsbsource( I_FBPAL );
	if( !(i_glob.imghra->dpyctl & 0x4000) )	/* If base-board is an  */
		{				/* IM-640 and video out */
		xdisp_zoom *= 2;		/* is interlaced, then  */
		xovr_zoom *= 2;			/* hzoom must be 2.     */
		}
	break;

	case IMAGE_LC:
	OVRLocation = VGA_OVERLAY;	/* Draw in VGA buffer */
	pcstfborg( I_FB4X1KX1KX8 );
	HostWait4Proc;
	grab_source = I_DIG_8 + I_ROI1;
	grab_destination = I_FB2 + I_ROI2;	/* Grab into FB2 */
	lsdcstdmode( I_FB2_1K_1K_8 );
	xmem_size = 1024;
	ymem_size = 1024;
	krhwsclipr( 0, 0, xmem_size - 1, ymem_size - 1 );
	lsdcstrdmask( 0x3ff, 0x3ff, 0x3ff, 0, 0, 0 );
	pciqsys( I_IQ_VGA_STAT, &vga_ovrmode );
	if( _setvideomode( _VRES16COLOR ) == 0 )
		{
		printf( "Error:  Your display adapter must be a VGA capable of\n" );
		printf( "displaying 640x480 16 color graphics mode (mode %xh).\n", _VRES16COLOR );
		iorlmemdevice( handle );
		iocldevice( handle );
		exit( -1 );
		}
	if( vga_ovrmode != I_NOVGA )
		{
		lsdcstcolkey( OVR_TRANSPARENT, 0x0f, I_VGA_NEQUAL );
		lsdcstvgamode( I_COLOR );
		}
	break;
	}
krhwslcsurf( I_FB_SURF0 );
krhwcclr( 0 );
utlmgnlut( 0L, I_LUT_OUTL_MONO, 256L, I_PHYRAMP );

/*********************/
/* ROI specification */
/*********************/
pciqsys( I_IQ_CAMW, &roix ); 	/* Get ROI size from logical camera     */
pciqsys( I_IQ_CAMH, &roiy );
roix = min( xmem_size, roix );	/* ROI size must not exceed */
roiy = min( ymem_size, roiy );	/* frame buffer dimensions. */
roix &= 0xfffc;			/* Must be multiple of 4 */
pcstroisiz( roix, roiy );	/* Set ROI size */
HostWait4Proc;

pciqsys( I_IQ_SCRW, &screen_w );	/* Get screen dimensions */
pciqsys( I_IQ_SCRH, &screen_h );

roi_posx = max( 0, (((signed)screen_w) - ((signed)roix)) / 2 );	/* Put roi in middle */
roi_posy = max( 0, (((signed)screen_h) - ((signed)roiy)) / 2 );	/* of visible screen */
roi_posx &= 0xfffc;	/* Must be multiple of 4 */

pcstroipos( I_ROI1, 0, 0 );  			/* Set source roi position      */
pcstroipos( I_ROI2, roi_posx, roi_posy );	/* Set destination roi position */
HostWait4Proc;

pciqsys( I_IQ_CAM_TYPE, &interlace );	/* Get scan mode from logical */
interlace &= 0x0001;			/* camera.                    */
pcstcond( 0, I_FOR, 1 + interlace );

/*=============================*/
/* Set references and exposure */
/*=============================*/
distrefwhite( whiteref );
distrefblack( blackref );
dislgain( gain );
switch( grabbing_mode )
	{
	case NORMAL:
	break;

	case SOFTTRIG:
	distexposure( I_SOFTTRIG, exposure, transfer );
	break;

	case TTL_HARDTRIG:
	case OPTO_HARDTRIG:
	if( board_type == IMAGE_LC )
		{
		if( grabbing_mode == TTL_HARDTRIG )
			{
			distexposure( I_HARDTRIG + I_TTLTRIG, exposure, transfer );
			}
		else
			{
			distexposure( I_HARDTRIG + I_OPTOTRIG, exposure, transfer );
			}
		}
	else
		{
		distexposure( I_HARDTRIG, exposure, transfer );
		}
	break;
	}

/*=====================*/
/* Set zoom and scroll */
/*=====================*/
lsdcstpzscroll( I_VDO_MFB, (long)xdisp_pos, (long)ydisp_pos, 
	xdisp_zoom, ydisp_zoom, I_VDO_NOMOS );
lsdcstpzscroll( I_VDO_OVR, (long)xdisp_pos, (long)ydisp_pos, 
	xovr_zoom, yovr_zoom, I_VDO_NOMOS );

HostWait4All;
}

/*-----------------------------------------------------------------*/
/* This function is for initializing the overlay Look-Up-Tables,   */
/* on the Image-640 and the Image-1280.                            */

void init_overlay_luts( void )
{
lslmwrlut( I_LUT_OVRL_RED, 16L );
ioputbuf( OVR_lutreddata, 16 );
lslmwrlut( I_LUT_OVRL_GREEN, 16L );
ioputbuf( OVR_lutgreendata, 16 );
lslmwrlut( I_LUT_OVRL_BLUE, 16L );
ioputbuf( OVR_lutbluedata, 16 );
}

