/*/  Function name:   scolpline
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputmbuf:  send multiple buffers of words to the board.
*
*    Uses:  PHCOORD data structure.
*
*    Return value:   None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;
IMPORT  unsigned short _I_PTYPE *i_buffers[];
IMPORT  unsigned short i_ns[];

#define BUFFER_SIZE 2    /* parameters buffer size in words */

#ifdef ANSI
void FTYPE scolpline(unsigned short nvert, PHCOORD _I_PTYPE *vertptr)
#else
FTYPE scolpline(nvert, vertptr)
unsigned short  nvert;
PHCOORD  _I_PTYPE *vertptr;
#endif

    {
	unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;

    /* set buffer for parameters */
	ptrbuff = buff;

    *ptrbuff++ = 0x003C;
    *ptrbuff = nvert;

    /* set buffer for buffers */
	buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short _I_PTYPE *)buff;
    /* then the structure values */
    *buffers = (unsigned short _I_PTYPE *)vertptr;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = (unsigned short) BUFFER_SIZE;
    /* structure size ( in words ) */
    *ns = nvert << 1;

    /* send buffers */
    ioputmbuf(i_buffers, i_ns, 2);

    }


