/*/  Function name:  lsrlwrrst
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*
*    Uses:  None
*
*    Return value:  -1: if the routine is not able to open the file
*                    0: otherwise
*/

#include  <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#if defined(I_MS_DOS) || defined(I_OS2)

#include  <io.h>

#endif

#define   TEMPBUFFSIZE   1024
/*        Size of a disk cluster, 1024Kwords or 2048Kbytes */

IMPORT unsigned short  tempbuff[];
/*        This buffer is also declared in lsrdrst() */

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;

#ifdef ANSI
short FTYPE lsrlwrrst(short left, short top, short right, short bottom,
                      char _I_PTYPE *src_filename)
#else
short FTYPE lsrlwrrst(left, top, right, bottom, src_filename)
short  left, top, right, bottom;
char  _I_PTYPE *src_filename;
#endif

    {
    FILE    _I_PTYPE *fpr;                          /* Input file pointer */
    unsigned long  length;
    unsigned short  numread;

    ptrbuff = buff;

    *ptrbuff++ = 0x0036;
    *ptrbuff++ = left;
    *ptrbuff++ = top;
    *ptrbuff++ = right;
    *ptrbuff = bottom;

    ioputbuf(buff, 5);

    if ((fpr = fopen(src_filename, "rb")) == NULL)
        return(-1);

    length = filelength(fileno(fpr)) >> 1;  /* source file length in words */

    while (length)
        {
        if (length > TEMPBUFFSIZE)
            {
            numread = TEMPBUFFSIZE;
            length -= TEMPBUFFSIZE;
            }
        else
            {
            numread = (unsigned short) length;
            length = 0;
            }

        fread((char *)tempbuff, sizeof(short), numread, fpr);

        ioputbuf((short *) tempbuff, numread);
        }

    fclose(fpr);

    return(0);
    }



