/*/  Function name:  lsdapat
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputmbuf:  send multiple buffers of words to the board.
*
*    Uses:  BITMAP data structure.
*
*    Return value:  None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;
IMPORT  unsigned short _I_PTYPE *i_buffers[];
IMPORT  unsigned short i_ns[];

#define BUFFER_SIZE 2    /* parameters buffer size in words */

#define STRUCT_SIZE 4    /* structure size in words */

#define DEFAULT_LENGTH 2 /* length by default for buffer in structure */

#ifdef ANSI
void FTYPE lsdapat(unsigned short fillpat_id, BITMAP _I_PTYPE *fillpat_ptr)
#else
FTYPE lsdapat(fillpat_id, fillpat_ptr)
unsigned short  fillpat_id;
BITMAP  _I_PTYPE *fillpat_ptr;
#endif

    {
	unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;

    /* set buffer for parameters */
	ptrbuff = buff;

    *ptrbuff++ = 0x0058;
    *ptrbuff = fillpat_id;

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short _I_PTYPE *)buff;
    /* then the structure values */
    *buffers++ = (unsigned short _I_PTYPE *) fillpat_ptr;

    /* data buffer in structure */
	*buffers = (unsigned short _I_PTYPE *) fillpat_ptr->tl;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = (unsigned short) BUFFER_SIZE;
    /* structure size ( in words ) */
    *ns++ = (unsigned short) STRUCT_SIZE;

    /* conditional length of buffer in structure */
    if (fillpat_ptr->pitch)
		*ns = (unsigned short) (fillpat_ptr->h * fillpat_ptr->pitch);
    else
		*ns = (unsigned short) DEFAULT_LENGTH;

    /* send buffers */
    ioputmbuf ( i_buffers, i_ns, 3 );

    }


