/*
    filename :  ioputfbu.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

extern  I_IMGLOB    i_glob;

/*/     Function:   ioputfbuf()
*       Synopsis:   This routine writes a buffer of float to the FIFO.
*       Date:       January 23rd 1990
*       param:      --- none ---
*                                               
*       returns:    word
**/

#ifdef ANSI
void FTYPE ioputfbuf(float _I_PTYPE *buffer, unsigned short nfloats)
#else
FTYPE ioputfbuf( buffer, nfloats )
float _I_PTYPE *buffer;
unsigned short nfloats;
#endif
    {
    register short  free_space;
    register float  val;

    do  {

        /* Evaluate the amount of long that can readily be send.    */

        free_space = (WRITE_FIFO_SIZE - IOwrite_count) >> 1;


        /* Put as many as possible, up to a maximum of nfloats. */

        free_space = ( (unsigned short) free_space < nfloats ) ?
                     free_space : nfloats;


        /* Keep track of the amount being send. */

        nfloats -= free_space;


        /* Transmit words to FIFO.  */

        while ( free_space-- )
            {

            /* Convert into short */

            val = *buffer++ * FLOATfactor;


            /* Sends LOW word first, then the HIGH word. */

            IOwrite = (short)  val;
            IOwrite = (short) ( (unsigned long) val >> 16 );
            }

        }   while ( nfloats );  /* Loop until all done. */

    }   /* ioputfbuf()  */
