             .386


; This assembles code compatible to Watcom 32 bit near model
; ----------------------------------------------------------
IFDEF WATCOM


  _TEXT	segment word public 'CODE'
  _TEXT	ends

  _DATA	segment word public 'DATA'
  _DATA	ends

  	DGROUP	GROUP  _DATA

  	assume cs:_TEXT, ds:DGROUP

  _TEXT	segment word public 'CODE'

  public	__i_movmem386

  ;
  ;  void FTYPE _i_s_movmem386 ( void far *src, void far * dst,
  ;             unsigned short count, unsigned short sizefactor );
  ;

  __i_movmem386 proc near

  	push	ebp
  	mov	    ebp, esp
  	push	esi

  	push	ecx
  	push	ds
  	push	es
  	push	edi

IFDEF WIN_NT
  	mov     esi, [ebp+8]	; src : source pointer
    push    ds
    pop     es
  	mov	    edi, [ebp+12]	; dst : destination pointer
  	movzx	eax, word ptr [ebp+16]	; count
  	movzx	ecx, word ptr [ebp+20]	; xstart
ELSE
  	lds	    esi, [ebp+8]	; src : source pointer
  	les	    edi, [ebp+16]	; dst : destination pointer
  	movzx	eax, word ptr [ebp+24]	; count
  	movzx	ecx, word ptr [ebp+28]	; xstart
ENDIF

  	; set direction flag
  	cld

  	; first bytes
  	and	    ecx, 3
  	neg	    ecx
  	add	    ecx, 4
  	and	    ecx, 3
  	sub	    eax, ecx

  	jge	    @0001

  	movzx	ecx, word ptr [ebp+24]          ; count
  	xor	    eax, eax

  @0001:
  	rep     movsb

  	; last bytes in ax
  	mov	    ecx, eax
  	and	    eax, 3

  	; move long words
  	sar	    ecx, 2
  	rep     movsd

  	; last bytes

  	mov	    ecx, eax
  	rep	    movsb

  	pop	    edi
  	pop	    es
  	pop	    ds
  	pop	    ecx

  	pop	    esi
  	pop	    ebp

  	ret


  __i_movmem386 endp

  _TEXT	ends


; Assemble for linkage to MSC large memory model code.
; ----------------------------------------------------
ELSE


  IMOV386_TEXT      segment byte public 'CODE' USE16
  IMOV386_TEXT      ends

  DGROUP      group  _DATA,_BSS
              assume cs:IMOV386_TEXT,ds:DGROUP
  _DATA       segment word public 'DATA' USE16
  d@          label  byte
  d@w         label  word
  _DATA       ends
  _BSS        segment word public 'BSS' USE16
  b@          label  byte
  b@w         label  word
  _BSS        ends
  IMOV386_TEXT      segment byte public 'CODE' USE16

  ;       Modified: SHey 92/10/29 Sometime in the universe, the last
  ;                               last two parameters needed to be changed for
  ;                               a long when called! But God forgot to update
  ;                               the function itself.. So I had to do it
  ;
  ;           void _i_movmem386 ( void * src, void * dst, unsigned long count, unsigned long xstart )
  ;
              assume cs:IMOV386_TEXT

  IFDEF I_PASCAL     ; use pascal calling convention
   _I_MOVMEM386  proc   far
  ELSE
   __i_movmem386 proc   far
  ENDIF

              push   bp
              mov    bp,sp
              push   si

              push   cx
              push   ds
              push   di

  IFDEF I_PASCAL     ; use pascal calling convention
              lds    si,dword ptr ss:[bp+18]         ; src : source pointer
              les    di,dword ptr ss:[bp+14]         ; dst : destination pointer
              mov    ax,word ptr ss:[bp+10]          ; count
              mov    cx,word ptr ss:[bp+6]           ; xstart
  ELSE
              lds    si,dword ptr [bp+6]          ; src : source pointer
              les    di,dword ptr [bp+10]         ; dst : destination pointer
              mov    ax,word ptr [bp+14]          ; count
              mov    cx,word ptr [bp+18]          ; xstart
  ENDIF

              ; set direction flag
              cld

              ; first bytes
              and    cx, 3
              neg    cx
              add    cx, 4
              and    cx, 3
              sub    ax, cx

              jge    @0001

  IFDEF I_PASCAL
              mov    cx,word ptr [bp+10]          ; count
  ELSE
              mov    cx,word ptr [bp+14]          ; count
  ENDIF

              xor    ax, ax

  @0001:

              rep    movsb

              ; last bytes in ax
              mov    cx, ax
              and    ax, 3

              ; move long words
              sar    cx, 2
              rep    movsd

              ; last bytes

              mov    cx, ax
              rep    movsb

              pop    di
              pop    ds
              pop    cx

              pop    si
              pop    bp

  IFDEF I_PASCAL
              ret    16
   _I_MOVMEM386  endp
  ELSE
              ret
   __i_movmem386 endp
  ENDIF

  IMOV386_TEXT      ends

  _DATA       segment word public 'DATA'
  s@          label  byte
  _DATA       ends
  IMOV386_TEXT      segment byte public 'CODE'
  IMOV386_TEXT      ends

  IFDEF I_PASCAL
              public _I_MOVMEM386
  ELSE
              public __i_movmem386
  ENDIF


; End of the "IFDEF WATCOM"
; -------------------------
ENDIF

            end

