/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import java.util.HashSet;
import scala.actors.threadpool.AbstractExecutorService;
import scala.actors.threadpool.AtomicInteger;
import scala.actors.threadpool.BlockingQueue;
import scala.actors.threadpool.RejectedExecutionException;
import scala.actors.threadpool.RejectedExecutionHandler;
import scala.actors.threadpool.ThreadFactory;
import scala.actors.threadpool.TimeUnit;
import scala.actors.threadpool.locks.Condition;
import scala.actors.threadpool.locks.ReentrantLock;

public final class ThreadPoolExecutor
extends AbstractExecutorService {
    private final AtomicInteger ctl;
    private final BlockingQueue workQueue;
    public final ReentrantLock mainLock;
    public final HashSet workers;
    private final Condition termination;
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final RuntimePermission shutdownPerm;

    private static boolean runStateLessThan(int c, int s2) {
        return c < 0x20000000;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean runStateAtLeast(int c, int s2) {
        void var1_1;
        return c >= var1_1;
    }

    private static boolean isRunning(int c) {
        return c < 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean compareAndDecrementWorkerCount(int expect) {
        void var1_1;
        return this.ctl.compareAndSet(expect, (int)(var1_1 - true));
    }

    private void decrementWorkerCount() {
        while (!this.compareAndDecrementWorkerCount(this.ctl.get())) {
        }
    }

    private void advanceRunState(int targetState) {
        int n;
        int n2;
        int c;
        while (!ThreadPoolExecutor.runStateAtLeast(c = this.ctl.get(), targetState) && !this.ctl.compareAndSet(c, (n2 = targetState) | (n = n2 & 0x1FFFFFFF))) {
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryTerminate() {
        int n;
        int c;
        while (!(ThreadPoolExecutor.isRunning(c = this.ctl.get()) || ThreadPoolExecutor.runStateAtLeast(c, 0x40000000) || ((n = c) & 0xE0000000) == 0 && !this.workQueue.isEmpty())) {
            n = c;
            if ((n & 0x1FFFFFFF) != 0) {
                this.interruptIdleWorkers(true);
                return;
            }
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                int n2 = 0;
                n = 0x40000000;
                if (this.ctl.compareAndSet(n2, 0x40000000 | n2)) {
                    n2 = 0;
                    n = 0x60000000;
                    this.ctl.set(0x60000000 | n2);
                    this.termination.signalAll();
                    mainLock.unlock();
                    return;
                }
                mainLock.unlock();
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.unlock();
                throw throwable;
            }
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private void checkShutdownAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(shutdownPerm);
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                for (Worker w : this.workers) {
                    security.checkAccess(w.thread);
                }
                mainLock.unlock();
                return;
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void interruptIdleWorkers(boolean onlyOne) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                Thread t = w.thread;
                if (!t.isInterrupted() && w.tryLock()) {
                    try {
                        t.interrupt();
                    }
                    catch (SecurityException securityException) {
                    }
                    finally {
                        w.unlock();
                    }
                }
                if (!onlyOne) continue;
            }
            mainLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var2_4;
            var2_4.unlock();
            throw throwable;
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    /*
     * WARNING - void declaration
     */
    private void reject(Runnable command) {
        void var1_1;
        this.handler.rejectedExecution((Runnable)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    private boolean addWorker(Runnable firstTask, boolean core) {
        block4: while (true) {
            int c22;
            int n = c22 = this.ctl.get();
            int rs = c22 & 0xE0000000;
            if (rs >= 0 && (rs != 0 || firstTask != null || this.workQueue.isEmpty())) {
                return false;
            }
            while (true) {
                int wc;
                if ((wc = (n = c22) & 0x1FFFFFFF) >= 0x1FFFFFFF || wc >= (core ? this.corePoolSize : this.maximumPoolSize)) {
                    return false;
                }
                wc = c22;
                ThreadPoolExecutor c22 = this;
                if (c22.ctl.compareAndSet(wc, wc + 1)) break block4;
                n = c22 = this.ctl.get();
                if ((c22 & 0xE0000000) != rs) continue block4;
            }
            break;
        }
        Worker w = new Worker(this, firstTask);
        Thread t = w.thread;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            void var3_8;
            void var2_6;
            int n = core = this.ctl.get();
            int rs = core & 0xE0000000;
            if (t == null || rs >= 0 && (var2_6 != false || firstTask != null)) {
                this.decrementWorkerCount();
                this.tryTerminate();
                return false;
            }
            this.workers.add(var3_8);
            int s2 = this.workers.size();
            if (s2 > this.largestPoolSize) {
                void var1_2;
                this.largestPoolSize = var1_2;
            }
        }
        finally {
            mainLock.unlock();
        }
        t.start();
        int n = this.ctl.get();
        if ((n & 0xE0000000) == 0x20000000 && !t.isInterrupted()) {
            t.interrupt();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void processWorkerExit(Worker w2, boolean completedAbruptly) {
        if (completedAbruptly) {
            this.decrementWorkerCount();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += w2.completedTasks;
            this.workers.remove(w2);
            mainLock.unlock();
        }
        catch (Throwable w2) {
            void var3_5;
            var3_5.unlock();
            throw w2;
        }
        this.tryTerminate();
        int c = this.ctl.get();
        if (ThreadPoolExecutor.runStateLessThan(c, 0x20000000)) {
            if (!completedAbruptly) {
                void var2_4;
                void var1_3;
                int min = this.corePoolSize;
                if (min == 0 && !this.workQueue.isEmpty()) {
                    min = 1;
                }
                if ((var1_3 & 0x1FFFFFFF) >= var2_4) {
                    return;
                }
            }
            this.addWorker(null, false);
        }
    }

    private Runnable getTask() {
        boolean timedOut = false;
        block2: while (true) {
            int timed;
            int c;
            int n = c = this.ctl.get();
            int rs = c & 0xE0000000;
            if (rs >= 0 && (rs >= 0x20000000 || this.workQueue.isEmpty())) {
                this.decrementWorkerCount();
                return null;
            }
            while (true) {
                int wc;
                int n2 = timed = (wc = (n = c) & 0x1FFFFFFF) > this.corePoolSize ? 1 : 0;
                if (wc <= this.maximumPoolSize && (!timedOut || timed == 0)) break;
                if (this.compareAndDecrementWorkerCount(c)) {
                    return null;
                }
                timed = c = this.ctl.get();
                if ((c & 0xE0000000) != rs) continue block2;
            }
            try {
                Runnable r = timed != 0 ? (Runnable)this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : (Runnable)this.workQueue.take();
                if (r != null) {
                    return r;
                }
                timedOut = true;
                continue;
            }
            catch (InterruptedException interruptedException) {
                timedOut = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void runWorker(Worker w) {
        Object task = w.firstTask;
        w.firstTask = null;
        try {
            while (task != null || (task = this.getTask()) != null) {
                w.lock();
                ThreadPoolExecutor threadPoolExecutor = this;
                if (ThreadPoolExecutor.runStateLessThan(threadPoolExecutor.ctl.get(), 0x20000000) && Thread.interrupted() && ThreadPoolExecutor.runStateAtLeast(threadPoolExecutor.ctl.get(), 0x20000000)) {
                    Thread.currentThread().interrupt();
                }
                try {
                    Thread cfr_ignored_0 = w.thread;
                    try {
                        task.run();
                    }
                    catch (RuntimeException runtimeException) {
                        task = runtimeException;
                        throw runtimeException;
                    }
                    catch (Error error2) {
                        task = error2;
                        throw error2;
                    }
                    catch (Throwable x) {
                        void var2_3;
                        throw new Error((Throwable)var2_3);
                    }
                    Object var2_2 = null;
                    ++w.completedTasks;
                }
                catch (Throwable throwable) {
                    ++w.completedTasks;
                    w.unlock();
                    throw throwable;
                }
                w.unlock();
            }
            this.processWorkerExit(w, false);
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            this.processWorkerExit((Worker)var1_1, true);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        void var2_2;
        void var1_1;
        int n = 0;
        int n2 = -536870912;
        this.ctl = new AtomicInteger(0xE0000000 | n);
        this.mainLock = new ReentrantLock();
        this.workers = new HashSet();
        this.termination = this.mainLock.newCondition();
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || 60000L < 0L) {
            throw new IllegalArgumentException();
        }
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = var1_1;
        this.maximumPoolSize = var2_2;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(60000L);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void execute(Runnable command) {
        void var1_1;
        int c;
        if (command == null) {
            throw new NullPointerException();
        }
        int n = c = this.ctl.get();
        if ((c & 0x1FFFFFFF) < this.corePoolSize) {
            if (this.addWorker(command, true)) {
                return;
            }
            c = this.ctl.get();
        }
        if (ThreadPoolExecutor.isRunning(c) && this.workQueue.offer(command)) {
            void var2_2;
            int recheck = this.ctl.get();
            if (!ThreadPoolExecutor.isRunning(recheck)) {
                Runnable runnable = command;
                ThreadPoolExecutor threadPoolExecutor = this;
                boolean bl = threadPoolExecutor.workQueue.remove(runnable);
                threadPoolExecutor.tryTerminate();
                if (bl) {
                    this.reject(command);
                    return;
                }
            }
            if (((n = var2_2) & 0x1FFFFFFF) != 0) return;
            this.addWorker(null, false);
            return;
        }
        if (this.addWorker(command, false)) return;
        this.reject((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void shutdown() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            ThreadPoolExecutor threadPoolExecutor = this;
            threadPoolExecutor.interruptIdleWorkers(false);
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
        this.tryTerminate();
    }

    public final boolean isShutdown() {
        return !ThreadPoolExecutor.isRunning(this.ctl.get());
    }

    protected final void finalize() {
        this.shutdown();
    }

    public final ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        int delta = corePoolSize - this.corePoolSize;
        this.corePoolSize = corePoolSize;
        int n = this.ctl.get();
        if ((n & 0x1FFFFFFF) > corePoolSize) {
            this.interruptIdleWorkers();
            return;
        }
        if (delta > 0) {
            void var2_2;
            int k = Math.min((int)var2_2, this.workQueue.size());
            while (k-- > 0 && this.addWorker(null, true) && !this.workQueue.isEmpty()) {
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            void var2_2;
            int n = 0;
            for (Worker worker : this.workers) {
                if (!worker.isLocked()) continue;
                ++n;
            }
            void var3_5 = var2_2;
            mainLock.unlock();
            return (int)var3_5;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    static {
        new AbortPolicy();
        shutdownPerm = new RuntimePermission("modifyThread");
    }

    public static final class AbortPolicy
    implements RejectedExecutionHandler {
        @Override
        public final void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static final class CallerRunsPolicy
    implements RejectedExecutionHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        public final void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                void var1_1;
                var1_1.run();
            }
        }
    }

    public final class Worker
    extends ReentrantLock
    implements Runnable {
        public final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;
        private /* synthetic */ ThreadPoolExecutor this$0;

        /*
         * WARNING - void declaration
         */
        Worker(ThreadPoolExecutor threadPoolExecutor, Runnable firstTask) {
            void var2_2;
            this.this$0 = threadPoolExecutor;
            this.firstTask = var2_2;
            this.thread = threadPoolExecutor.getThreadFactory().newThread(this);
        }

        @Override
        public final void run() {
            this.this$0.runWorker(this);
        }
    }
}

