/***************************************************************************/
/*                   PS/1 Device Specific Functions                        */
/*                                                                         */
/*    DevInit()            Initialize Device, hook ints, etc.              */
/*    DevOpen()            Open device                                     */
/*    DevClose()           Close device                                    */
/*    DevNoteOn()                                                          */
/*    DevNoteOff()                                                         */
/*    DevAllNotesOff()     Make sure all notes are off                     */
/*    DevAfterTouch()                                                      */
/*    DevControlChange                                                     */
/*    DevProgramChange                                                     */
/*    DevChannelPressure()                                                 */
/*    DevPitchBend                                                         */
/*    DevMTC()                                                             */
/*    DevSysEx()                                                           */
/*    SetClock()           Called when Tempo or PPQN changes               */
/*    DevInt()             (optional)                                      */
/*    TimerInt()           (optional)                                      */
/*    DevIOCTLinit(dptr)   Process IOCTL init functions                    */
/*    DevIOCTLstatus(dptr) Return status                                   */
/*    DevIOCTLload()       Load DSP module                                 */
/*    DevIOCTLread8()      diagnostic read byte from ACPA port             */
/*    DevIOCTLwrite8()     diagnostic write byte to ACPA port              */
/*    DevIOCTLread16()     diagnostic read word from ACPA port             */
/*    DevIOCTLwrite16()    diagnostic write word to ACPA port              */
/*  PS/1 Interrupt Handler and device specific routines                    */
/*  This routine is invoked by Receive and Timer Interrupts.               */
/*  It will update position, perform any pending synchronized output, and  */
/*  read any input data.                                                   */
/*  DHH1014   added support for best fit and so that the default mode would*/
/*            be pcm8k8b on the best fit if k12 driver                     */
/*  DHH911017 Fixed Posistion and reorganized play routine for more eff. op*/
/*            The pcm play routine was almost completely rewritten         */
/*            removed variables that were not being used                   */
/*            removed the body of code in the devint not called at all     */
/***************************************************************************/
#define IS_PS1  1
#include <conio.h>
#include <stdlib.h>
#define NUM_TRACKS 1
#include <audiodd.h>
#include <audproto.h>
#include <auddef.h>
#include <audiodd2.h>
#include <audmsg.h>

#define TRK     0

/* PS/1 port definitions */
#define  ADC_PORT          0x200    /* ADC data register                   */
#define  SOUND_GEN         0x205    /* Sound Generator                     */
#define  MIDI_DATA         0x330    /* MIDI Data Register                  */
#define  MIDI_CONTROL      0x331    /* MIDI Interrupt Control              */
#define  MIDI_THRU         0x10     /* Enables MIDI-Thru port (vs. 2nd Out)*/
#define  MIDI_TX_INT_EN    2        /* Enable xmit interrupt               */
#define  MIDI_REC_INT_EN   1        /* Enable rec interrupt                */
#define  MIDI_INT_STATUS   0x332    /* MIDI Interrupt Status register      */
#define  MIDI_INT_PEND     1        /* Interrupt is pending                */
#define  MIDI_STATUS       0x335    /* MIDI Status register                */
#define  MIDI_TX_EMPTY     0x20     /* Transmit buffer empty               */
#define  MIDI_FRAME_ERR    8        /* Framing error                       */
#define  MIDI_OVERRUN      2        /* Overrun error                       */
#define  MIDI_REC_READY    1        /* Receive data available              */
#define  FIFO_TIMER        0x203    /* FIFO Timer count/reload value       */
#define  FIFO_CONTROL      0x202    /* FIFO Control register               */
#define  FIFO_INT_EN       1        /* Enable interrupt                    */
#define  FIFO_INTR         0x10    /* FIFO int pending                    */
#define  ADC_READY         0x10    /* byte ready in adc */
#define  FIFO_EMPTY        0x04
#define  FIFO_FULL         0x08
#define  TIMER             0x40


/* External data references */
#if IS_OS2                                      /* BRR6 - 6/27/91 - begin */
extern unsigned int GDTselector1[],GDTselector2[],GDTselector3[],GDTselector4[];
extern int rmswitch;                                                 /*61991*/
#endif                                          /* BRR6 - 6/27/91 - end */

extern unsigned int MIDIFLAGS,TIMINGFLAGS;
extern int INITFLAGS,MODE_G;
extern int PPQNCNTR,PPQNDIV;
extern struct vscb RECIO,XMITIO,RECBUF,XMITBUF;
extern unsigned char *PRVTIMEMSG,*PRVTIMECOUNTHI,*PRVTIMECOUNTLO;
extern long OPERATION_G;
extern unsigned int LAST_REC_HEAD_SEGNUM;
extern unsigned int LAST_XMIT_TAIL_SEGNUM;
extern char far *SRHEAD;           /* Shadow (usable) pointers*/
extern char far *SXTAIL;
extern long delay;

/* Device Specific Data */
unsigned char qcaps_sysex[10] = { 0xf0,0,0,0x3a,5,1,0,0x10,0,0xf7 };
unsigned char qid_sysex[10] = { 0xf0,0,0,0x3a,5,4,'P','S','1',0xf7 };
#define ADC_FIFO_LEN    2000
#define ADC_REC_RELOAD 10
#define ADC_PLAY_RELOAD 100

#define  NUM_MODES   4
#define  CLAIM_HDWR_MODE   1
#define  PCM8K8b        2
#define  PCM11K8b       3

#define  UNKNOWN_MODE      NUM_MODES
#define  DUMMY 0
int   num_modes = NUM_MODES;
struct mode_data mode_table[NUM_MODES] = {
   MIDI,0,0,8,8,0,0,0,0,1,DATAFLAGS+BPS+SRATE+CHANNELS+BSIZE,      /* MIDI_MODE   */
   CLAIM_HDWR,0,0,0,0,0,0,0,0,0,DATAFLAGS+BPS+SRATE+CHANNELS+BSIZE, /* Get hardware*/
   PCM,0x3e,0,8,8,8000,8000,1,2,0,BSIZE,                 /* 8k 8b PCM      */
   PCM,0x3e,0,8,8,11025,11025,1,2,0,BSIZE,               /* 11k 8b PCM     */

};
char point1,point2,point3,point4,point5,point6;
int pcm_rate_table[NUM_MODES] = {0,0,125,90};/* this is the rate to set the FIFO timer  for in microseconds */
int pcm_bytes_table[NUM_MODES] = {0,0,8,11};/* this is the number of bytes per second */
int PCM_timer_rate =0x12a4;   /*normal 4a9 1000 per sec  0x952 500 per sec timer DHH*/
                  /*0x12a4 250 per sec 0x2548 125 per sec */
/* results of slowing down clock */
/* at 125 11k8 breaks for reload */
int bytes_per_millisecond;
unsigned long total_milliseconds_written;
char buffer_full,writebyte,readbyte,loop_count;
unsigned ps1_contrl_flg = 0;
char  *cur_ADC_head;
char  *top_of_ADCFIFO;
char  *bot_of_ADCFIFO;
char  adc_fifo[ADC_FIFO_LEN];
char  *cur_ADC_tail;
char  pcm_underun;
unsigned bytes_written;
unsigned devint_nothooked = 0;
unsigned ADC_reload;
unsigned char adc_stoped = 1;
int fifo_rate;
unsigned long internal_pos;
int pcm_temp_byte_count;
char milli_run; /* this is the run flag for the position code */
unsigned long wcount;
/****************************/
/* Device Interrupt Handler */
/****************************/
int DevInt()                        /* Invoked by MIDI receive interrupt */
{       /* this code is never called in the ps1 driver all of this is handled */
        /* in the dosdd interrupt handler  removed DHH911017 */
   return(0);
}

/***************************/
/* Timer Interrupt Handler */
/***************************/
int TimerInt()                /* Invoked by the Timer 0 interrupt handler  */
{
 unsigned  check_it;
 int current_msecs = 0;
 char far *top_of_buff;
#if NOT_K12
 aud_control(TRK);
#endif
if(MODE_G == MIDI){
#if NOT_K12
   if(!is_running(0)){                  /* If we're not running,            */
      return(0);                          /* then don't do anything           */
   }
   if(--PPQNCNTR == 0){              /* Prescale ppqn counter            */
      PPQNCNTR = PPQNDIV;
      ((IOB)XMITIO.Ptr)->position++;            /* increment system time      */
      ((IOB)RECIO.Ptr)->position++;             /*  in both buffers           */
      if( (((IOB)XMITIO.Ptr)->count)            /* Has xmit buffer been updated?*/
      && !(MIDIFLAGS & OUTSYNC)){            /*  without us knowing?       */
         MIDIFLAGS |= OUTSYNC;               /* If so, then make sure that */
         DELAY = 1;                          /*  we process it             */
      }
      if(MIDIFLAGS & OUTSYNC){               /* Is output synch pending?   */
         if(--DELAY <= 0){
            DoOutput(0);
#if IS_OS2
            /* If thread is blocked on room in xmit buffer,                   */
            if(MIDIFLAGS & OUTPUT_WAITING){  /* then unblock it            */
               DevHlp_Run((long)((char far *)&MIDIFLAGS));
            }
            /* If thread is blocked on AUDIO_WAIT                          */
            if(INITFLAGS & WAITING){   /* then unblock it            */
               DevHlp_Run((long)((char far *)&XMITIO));
            }
#endif
         }
      }
   }
   if(TIMINGFLAGS & 0x1000){           /* Are input timing clocks enabled? */
      if(TIMINGFLAGS & 0x400){         /* Is timing compression enabled?   */
         QTimeSX(0);                   /*  if so, go queue a timeing sysex */
      }else{
         *((IOB)RECIO.Ptr)->head = 0xf8;               /* Queue a MIDI timing clock       */
               check_wrap((IOB)RECIO.Ptr,1,TRK,HEAD,RX);
                     if (LAST_REC_HEAD_SEGNUM) {
#if IS_OS2
                        /* Now map new GDT */
                        PhysToGDTselector(RECBUF.Phys,
                               (unsigned)RECBUF.length,
                               GDTselector4[TRK]);
#endif
                                                   /* BRR6 - 6/25/91 - end   */
                        ((IOB)RECIO.Ptr)->head = RECBUF.Virt;
                        if(++((IOB)RECIO.Ptr)->count >= ((IOB)RECIO.Ptr)->size){
                           ((IOB)RECIO.Ptr)->count = ((IOB)RECIO.Ptr)->size;
                        }
                        ((IOB)RECIO.Ptr)->head = RECBUF.Ptr;
                     }else{
                        ((IOB)RECIO.Ptr)->head++;     /* BRR6 - 6/26/91 */
                        if(++((IOB)RECIO.Ptr)->count >= ((IOB)RECIO.Ptr)->size){
                           ((IOB)RECIO.Ptr)->count = ((IOB)RECIO.Ptr)->size;
                        }
                     }


      }
   }
   if(TIMINGFLAGS & 0x2000){         /* Are output clocks enabled?      */
      DevWrite(0xf8,0);                   /*  if so, go write one            */
   }
#endif
}/* end of mode MIDI */
else
                {
if(OPERATION_G == PLAY){
       if(adc_stoped && (((IOB)XMITIO.Ptr)->runflags & STARTED)        /*  and xmit started             */
                        && !(((IOB)XMITIO.Ptr)->runflags & PAUSED) ){      /*  and xmit not paused          */
                                                   outp(FIFO_TIMER,fifo_rate);/* set the fifo reload timer */
                                                        _asm{
                                                               mov    dx,200h                  ;load the port address of the adc
                                                         in     al,dx               ;read the adc port to make sure interrupts start
                                                                  }
                                                        adc_stoped = 0;
                                                        }
       if(!adc_stoped && (((IOB)XMITIO.Ptr)->runflags & STARTED)        /*  and xmit started             */
                        && (((IOB)XMITIO.Ptr)->runflags & PAUSED) ){      /*  and xmit not paused          */
                                                   outp(FIFO_TIMER,0);/* set the fifo reload timer */
                                                        adc_stoped = 1;
                                                        }
/* back fill the fifo */
                                ps1_contrl_flg = 0;
                                check_it = 0;
                                buffer_full = 0;
                                                                                  pcm_underun = 0;
                                        _asm{ /* this is the write byte routine */

                                                mov  dx,FIFO_CONTROL
                                                in   ax,dx                                        ;check to see if bytes available
                                                and  ax,FIFO_EMPTY
                                                jz  not_empty
                                                mov pcm_underun,1
not_empty:
                                }
                if(pcm_underun && !adc_stoped && milli_run)
                                                ((IOB)XMITIO.Ptr)->runflags |= IOB_UNDERRUN;

                                        _asm{ /* set the fifo full flag for the load routine */

                                                mov  dx,FIFO_CONTROL
                                                in   ax,dx                                        ;check to see if bytes available
                                                and  ax,FIFO_FULL
                                                jz  more_bytes2a
                                                mov buffer_full,1

more_bytes2a:

                                        }
       top_of_buff = XMITBUF.Virt+(unsigned long)(IOB)XMITBUF.length;
       internal_pos = 0; /* reset the temporary byte count */

                                while(((IOB)XMITIO.Ptr)->count  > 0 && !buffer_full )
                                {

                        _asm cli;
                   ((IOB)XMITIO.Ptr)->tail++;
                        --((IOB)XMITIO.Ptr)->count ;
                        writebyte=*SXTAIL++;
                 if(pcm_temp_byte_count++ >= bytes_per_millisecond)
                                        {
                        internal_pos++;
                                                pcm_temp_byte_count = 1;
                                         }

                                        if(SXTAIL >= top_of_buff){
                         check_wrap((IOB)XMITIO.Ptr,2,TRK,TAIL,TX);
      if (LAST_XMIT_TAIL_SEGNUM) {
#if IS_OS2
         /* Now map new GDT */
         PhysToGDTselector(XMITBUF.Phys,
                           (unsigned)XMITBUF.length,
                           GDTselector3[TRK]);
#endif
                                                  /* BRR6 - 6/25/91 - end   */
         SXTAIL = XMITBUF.Ptr;
         ((IOB)XMITIO.Ptr)->tail = XMITBUF.Virt;
       top_of_buff = XMITBUF.Virt+(unsigned long)(IOB)XMITBUF.length;

                        }
}
                _asm sti;


                        _asm{
                                                mov al,byte ptr writebyte
                                                mov dx,ADC_PORT
                                                out dx,al
                                  }
                                        _asm{ /* this is the write byte routine */

                                                mov  dx,FIFO_CONTROL
                                                in   ax,dx                                        ;check to see if bytes available
                                                and  ax,FIFO_FULL
                                                jz  more_bytes2
                                                mov buffer_full,1

more_bytes2:

                                        }

                        } /* end of the while count > 0 and ! buffer full */
                        wcount = wcount + internal_pos;
                                        if(milli_run){
                                                                      ((IOB)XMITIO.Ptr)->position=((IOB)XMITIO.Ptr)->position+internal_pos;
                                                                      ((IOB)RECIO.Ptr)->position=((IOB)RECIO.Ptr)->position+internal_pos;
                                                                         }
                                        if(pcm_underun && milli_run)
                                                                        {
                                                                      ((IOB)XMITIO.Ptr)->position=wcount;            /* increment system time      */
                                                                      ((IOB)RECIO.Ptr)->position=wcount;             /*  in both buffers           */
                             milli_run = 0;
                                                                        }
                                 if(!adc_stoped && !pcm_underun)milli_run = 1;

                  }else {

       if(adc_stoped && (((IOB)RECIO.Ptr)->runflags & STARTED)        /*  and xmit started             */
                        && !(((IOB)RECIO.Ptr)->runflags & PAUSED) ){      /*  and xmit not paused          */
                                                   outp(FIFO_TIMER,fifo_rate);/* set the fifo reload timer */
                                              outp(FIFO_CONTROL,0); /*turn on the external interrurpts */
                                                   outp(FIFO_CONTROL,1); /*turn on the external interrurpts */
                                               top_of_ADCFIFO =(char near *) ((unsigned long)RECBUF.Virt+(unsigned long)(IOB)RECBUF.length);
                                                        pcm_underun = 0;
                                                        _asm{
                                                               mov    dx,200h                  ;load the port address of the adc
                                                         in     al,dx               ;read the adc port to make sure interrupts start
                                                                  }
                                                        adc_stoped = 0;
                                                        }
       if(!adc_stoped && (((IOB)RECIO.Ptr)->runflags & STARTED)        /*  and xmit started             */
                        && (((IOB)RECIO.Ptr)->runflags & PAUSED) ){      /*  and xmit not paused          */
                                                   outp(FIFO_TIMER,0);/* set the fifo reload timer */
                                                        adc_stoped = 1;
                                                        }
                  }
pcm_underun = 0;
    return(0);
}
}

/***********/
/* Note On */
/***********/
void DevNoteOn(chan,key,vel)
char  chan,key,vel;
{
   DevWrite(0x90+chan,0);
   DevWrite(key,0);
   DevWrite(vel,0);
}

/************/
/* Note Off */
/************/
void DevNoteOff(chan,key,velocity)
char  chan,key,velocity;
{
   DevWrite(0x90+chan,0);
   DevWrite(key,0);
   DevWrite(0,0);
}

/*****************/
/* All Notes Off */
/*****************/
void DevAllNotesOff()
{
   int chan;

   for(chan=0; chan<16; chan++){
      DevWrite(0xb0+chan,0);       /* Issue All Notes Off */
      DevWrite(123,0);
      DevWrite(0,0);
   }
}

/*******************/
/* ChannelPressure */
/*******************/
void  DevChannelPressure(chan,press)
char  chan,press;
{
   DevWrite(0xa0+chan,0);
   DevWrite(press,0);
}

/******************/
/* Control Change */
/******************/
void  DevControlChange(chan,cnum,cval)
char  chan,cnum,cval;
{
   DevWrite(0xb0+chan,0);
   DevWrite(cnum,0);
   DevWrite(cval,0);
}

/******************/
/* Program Change */
/******************/
void  DevProgramChange(chan,prog)
char  chan,prog;
{
   DevWrite(0xc0+chan,0);
   DevWrite(prog,0);
}

/**************/
/* AfterTouch */
/**************/
void  DevAfterTouch(chan,key,press)
char  chan,key,press;
{
   DevWrite(0xd0+chan,0);
   DevWrite(key,0);
   DevWrite(press,0);
}

/*************/
/* PitchBend */
/*************/
void  DevPitchBend(chan,lsb,msb)
char  chan,lsb,msb;
{
   DevWrite(0xe0+chan,0);
   DevWrite(lsb,0);
   DevWrite(msb,0);
}

/*************/
/* MTC       */
/*************/
void  DevMTC(byte1,byte2)
char  byte1,byte2;
{
   DevWrite(0xf2,0);
   DevWrite(byte1,0);
   DevWrite(byte2,0);
}

/**************************/
/* Device Dependent SysEx */
/**************************/
void DevDepSX(d1,d2,d3)
char d1,d2,d3;
{
   return;
}

/************************/
/* Generic Voice Select */
/************************/
void DevVoiceSel(inst,type,sel)
char inst,type,sel;
{
   return;
}

/**************************/
/* Query Timbre Parameter */
/**************************/
void DevQTimbreParm(parmid)
long parmid;
{
   return;
}

/************************/
/* Set Timbre Parameter */
/************************/
void DevSetTimbreParm(parmid,parmval)
long parmid;
int parmval;
{
   return;
}

/************************/
/* Request Timbre Block */
/************************/
void DevReqTimbreBlk(blknum)
int blknum;
{
   return;
}

/**********************/
/* Write Timbre Block */
/**********************/
void DevWriteTimbreBlk(blknum,len,blk)
int blknum,len;
unsigned char *blk;
{
   return;
}

/****************/
/* Track Volume */
/****************/
void DevTrkVolume(level,duration,trk)
int level,duration,trk;
{
   return;
}

/*****************/
/* Track Balance */
/*****************/
void DevTrkBalance(balance,duration,trk)
int balance,duration,trk;
{
   return;
}

/*****************/
/* Master Volume */
/*****************/
void DevMstVolume(level,duration,trk)
int duration,trk;
unsigned int level;
{
   return;
}


/********************/
/* Set Clock values */
/********************/
void SetClock(trk)
int trk;
{
#if NOT_K12
   extern int TEMPO[],PPQN[];
   extern unsigned int INT1C_COUNTER[],INT1C_FASTER,INT1C_ORIGINAL;
        extern long INT1C_DIVISOR[]; /* the int1c divisor is now a 32 bit number*/
   int ttempo,tppqn,tdiv;

   ttempo = TEMPO[trk];
   tppqn = PPQN[trk];
        if(INT1C_ORIGINAL > 0xff00)INT1C_ORIGINAL = 0xffff;

   _asm{
      mov   dx,ttempo
      mov   ax,tppqn
      mul   dx          ; dx:ax = tempo*PPQN
      mov   bx,600
      div   bx          ; ax = (tempo*PPQN)/600
      mov   cx,ax       ;save our rate into the cx register
      cmp   INT1C_ORIGINAL,0xffff           ;is the rate 18.2
      je    eighteen
      mov   dx,18       ;dx:ax = 1183100
      mov   ax,13532
      mov   bx,INT1C_ORIGINAL   ;get the current setting of the clock
      div   bx                  ;the current rate is now in the ax register
      push  ax                  ;save the original rate to the stack for future use
      cmp   cx,ax               ;which rate is greater  ax = orig rate cx = our rate
      jg    ours_faster         ;cx > ax
      xor   dx,dx               ;clear the dx register
      div   cx                  ;our_rate/their rate
      mov   word ptr INT1C_DIVISOR+2,ax    ;save the msb to the devisor
      mov   word ptr INT1C_DIVISOR,dx    ;save the remainder to the lsb of the divisor
      mov   tdiv,ax             ;the rate divisor for our call theirs faster
      mov   INT1C_FASTER,1      ;set the flag to tell the main handler to call
      pop   ax                  ;remove ax from the state before exit
      jmp   out_timer           ;only every tdiv interrurpts

eighteen:
      mov   ax,182
      push  ax                  ;put the default rate onto the stack
      jmp   no_mult             ;don not multiply by 10 already done

ours_faster:
      pop   ax                  ;get the rate off the state
      mov   bx,10               ;multiplay by ten
      mul   bx
      push  ax                  ;save back onto the stack
no_mult:
      mov   bx,cx       ;put our rate into bx for dividing
      mov   dx,18       ; dx:ax = 1193180
      mov   ax,13532
      div   bx          ; ax = Timer Divisor
      push  bx
      mov   bx,ax

      mov   AL,36H       ; Set timer 0 mode 3
      out   TIMER+3,AL
      jmp   $+2
      mov   AL,BL
      out   TIMER+0,AL   ;  Set divisor LSB
      jmp   $+2
      mov   AL,BH
      out   TIMER+0,AL    ;  and MSB
                pop   bx
      mov   ax,10
      mul   bx            ; dx:ax = FO_RATE*10
      pop   cx            ; get the original rate off the stack
      div   cx            ; ax = fo_rate*10 / 182
      mov   word ptr INT1C_DIVISOR+2,ax
      mov   word ptr INT1C_DIVISOR,dx
      mov   tdiv,ax
out_timer:
   }
   INT1C_COUNTER[trk] = tdiv;
#endif
}


/***************/
/* Device Open */
/***************/
int DevOpen(trk)
int trk;
{
   adc_stoped = 1;
   GetTimerInt();
   GetDevInt(7);
   return(0);
}

/****************/
/* Device Close */
/****************/
int DevClose(trk)
int trk;
{
   FreeDevInt();
   FreeTimerInt();
   outp(MIDI_CONTROL,0);                /* Disable REC interrupt            */
   while(!(inp(FIFO_CONTROL)& FIFO_EMPTY));
   outp(FIFO_TIMER,0);                  /* Disable Fifo timer */
   outp(FIFO_CONTROL,0);                /* Disable The FIFO external interrupt */
   return(0);
}

/************/
/* DevStart */
/************/
void DevStart(trk)
int trk;
{
   /* nothing to do */
}

/************/
/* DevPause */
/************/
void DevPause(trk)
int trk;
{
   /* nothing to do */
}

/*************/
/* DevResume */
/*************/
void DevResume(trk)
int trk;
{
   /* nothing to do */
}

/***********/
/* DevStop */
/***********/
void DevStop(trk)
int trk;
{
   /* nothing to do */
}

/**********/
/* DeInit */
/**********/
void DevDeInit(trk)                        /* Process deinit requests   */
int trk;
{
   /* nothing to do */
}


/*****************************************************************************/
/* DevNotify                                                                 */
/*****************************************************************************/
char DevNotify(pos,trk)
unsigned long pos;
int trk;
{
   /* Nothing to do */
   return(0);
}
/*************/
/* DevChange */
/*************/
//int DevChange(long in,long out,long mon,long vol,long voldly,long bal, /* BRR31 */
//              long baldly,long treb,long bass,long pitch,unsigned int far * devp,
//              int any_dev_info, struct devid far *inlist, struct devid far *outlist,
//              int trk)
int DevChange(changes, dev_info, any_dev_info, mode_info, any_mode_info, trk) /* BRR105*/
struct audio_change far *changes;                                   /* BRR96 */
int *dev_info;                                                      /* BRR96 */
char any_dev_info;
int *mode_info;                                                     /* BRR105*/
char any_mode_info;                                                 /* BRR105*/
int trk;
{
   int   rc=0;                                                     /* BRR31 */
   short x;                                                        /* BRR31 */


   if(changes->input >= 0 && OPERATION_G==RECORD)   /* No-Change if -1               */
      if (changes->input == INPUTS_LISTED) {                           /* BRR31 - begin */
         changes->input = 0;
         for (x=0; x<8; x++) {
            switch(changes->input_list[x].devtype) {
               case NULL_INPUT:
                    x = 8;
                    break;
               case STEREO_LINE_INPUT:
                       rc = INVALID_INPUT_LIST;
                    break;
               case LEFT_LINE_INPUT:
                       rc = INVALID_INPUT_LIST;
                    break;
               case RIGHT_LINE_INPUT:
                       rc = INVALID_INPUT_LIST;
                    break;
               case MIC_INPUT:
                    if (changes->input == 0) {
                    } else {
                       rc = INVALID_INPUT_LIST;
                    } /* endif */
                    break;
               case BOOSTED_MIC_INPUT:
                       rc = INVALID_INPUT_LIST;
                    break;
               default:
                    rc = INVALID_INPUT_LIST;
            } /* end switch */
            if (changes->input_list[x].devnum > DEVICE_1) rc = -1;
         } /* endfor */
      } /* endif */                                        /* BRR31 - end   */
   if(changes->output >= 0){                          /* Output selection               */
      if (changes->output == OUTPUTS_LISTED) {                         /* BRR31 - begin */
         for (x=0; x<8; x++) {
            if (changes->output_list[x].devtype == SPEAKER_OUTPUT) {
            } else if ((changes->output_list[x].devtype == NULL_OUTPUT) ||
            (changes->output_list[x].devtype == PHONE_LINE_OUTPUT) ||
                       (changes->output_list[x].devtype == HANDSET_OUTPUT)) {
               rc = INVALID_OUTPUT_LIST;
            } /* endif */
            if (changes->output_list[x].devnum > DEVICE_1) rc = -1;
         } /* end for */
      } /* endif */                                                /* BRR31 */
   }

#if NOT_K12                                                        /* BRR105*/
   if (any_mode_info) {
      if (MODE_G==MIDI) {
//       acpa_out(??????,mode_info[0]);
//       acpa_out(??????,mode_info[1]);
//       acpa_out(??????,mode_info[2]);
      } /* endif */
   } /* endif */
#endif

   return(rc);                                                    /* BRR31 */
}

/*********************/
/* Device init IOCTL */
/*********************/
int DevIOCTLinit(dptr,index,trk)              /* Process ioctl init requests   */
AIP   dptr;
int   index,trk;
{

   switch(index){
   default:
#if IS_K12                                                              /*61491*/
      index=PCM8K8b;
#else
      index=MIDI_MODE;
                                                         /* BRR 10 - 7/16/91 */
#endif
      /* BRR 10 - 7/16/91 - moved here from AUDIODD.c */
      /* added 10/14/91 to support best fit in the ps1 DHH1014*/
      dptr->flags &= ~(mode_table[index].flags_mask);
      dptr->flags |= mode_table[index].flags | BESTFIT_PROVIDED;
      dptr->mode = mode_table[index].mode;
      /* needs to be set up for compares done at end of switch statement */
      MODE_G = dptr->mode;                                        //BRR90
      dptr->srate = mode_table[index].srate_low;
      dptr->bits_per_sample = mode_table[index].bps_low;
      dptr->bsize = mode_table[index].bsize;
      dptr->channels = mode_table[index].channels_low;
      /* Fall through */
#if NOT_K12
   case MIDI_MODE:

        SetClock(TRK);
/*   outp(MIDI_CONTROL,MIDI_REC_INT_EN + MIDI_THRU);*/ /* Enable REC int       */
        outp(MIDI_CONTROL,MIDI_REC_INT_EN); /* Enable REC int                   */

      dptr->flags |= OUTPUT;
      break;
#endif
        case PCM8K8b:
        case PCM11K8b:
        outp(FIFO_TIMER,0); /* turn of the fifo timer incase not zero */
        fifo_rate = pcm_rate_table[index];
        bytes_per_millisecond = pcm_bytes_table[index];
        pcm_temp_byte_count = 0;
        wcount = 0;
        milli_run=0;
        adc_stoped = 1;
        internal_pos = 0;
             pcm_underun = 0;
        bot_of_ADCFIFO = adc_fifo;
                 ((IOB)XMITIO.Ptr)->runflags &= ~IOB_UNDERRUN;
                 ((IOB)RECIO.Ptr)->runflags &= ~IOB_OVERRUN;

//   top_of_ADCFIFO = adc_fifo + ADC_FIFO_LEN;
top_of_ADCFIFO = (char near *)((unsigned long)RECBUF.Virt+(unsigned long)(IOB)RECBUF.length);

        cur_ADC_head = cur_ADC_tail = adc_fifo; /* reset the fifo pointers */
    if(OPERATION_G == RECORD)
                {ADC_reload = ADC_REC_RELOAD;
                 outp(FIFO_CONTROL,1); /*turn on the external interrurpts */
                }

        break;
   case CLAIM_HDWR_MODE:              /* moved to effect default settings */
      break;

   }/*switch*/

   dptr->rc = 0;                          /*  set rc = 0                   */
   dptr->slot_number = 0;
   dptr->device_id = PS1;                 /* Set device ID number          */

   return(index);
}

/****************/
/* Status IOCTL */
/****************/
void DevIOCTLstatus(dptr,trk)
ASP dptr;
int trk;
{
#if NOT_K12
   extern int TEMPO;
#endif
   struct audio_change far *cptr;
   struct track_info far *tptr;

   dptr->mode = MIDI;                        /*    MIDI mode               */
   dptr->srate = 0;                 /*    rate = tempo            */
   dptr->BITS_PER_SAMPLE_G = 8;                /*    byte data               */
   dptr->BSIZE_G = 1;                          /*    block size = 1          */
   dptr->CHANNELS_G = 1;                       /*    1 channel               */
   dptr->flags = 0;                          /*    flags                   */
   dptr->OPERATION_G = OPERATION_G;         /*    operation               */
   cptr = &(dptr->change);
   cptr->input = 0;                          /*    input                   */
   cptr->output = OUTPUT_1;                  /* output                     */
   cptr->monitor = 0;                        /*    monitor                 */
   cptr->volume = 0x7fff;
   cptr->volume_delay = 0;
   cptr->balance = 0x7fff;
   cptr->balance_delay = 0;
   cptr->treble = 0;
   cptr->bass = 0;
   cptr->pitch = 0;
   if(tptr = cptr->dev_info){                /*    dev_info                */
      /* not defined for PS/1 */
   }
}


/*********************/
/* Device load IOCTL */
/*********************/
void DevIOCTLload(buf,size,flags,trk)
unsigned char far *buf;
unsigned long size,flags;
int trk;
{
   return;                                /* Nothing to do for PS/1        */
}

/*********************/
/* Diagnostic IOCTLs */
/*********************/
void DevIOCTLread8(dptr)
DR8 dptr;
{
   dptr->data=(unsigned char)inp(0x200+dptr->offset); /* Read data from reg*/
}

void DevIOCTLwrite8(dptr)
DR8 dptr;
{
   outp(0x200+dptr->offset,dptr->data);   /* Write data to port            */
}

void DevIOCTLread16(dptr)
DR16 dptr;
{
   dptr->data=inpw(0x200+dptr->offset);   /* Read data from reg            */
}

void DevIOCTLwrite16(dptr)
DR16 dptr;
{
   outpw(0x200+dptr->offset,dptr->data);  /* Write data to port            */
}

/*************************/
/* Device Initialization */
/*************************/
DevInit(parms)
char far *parms;
{
   /* Nothing to do */
   return(0);
}

/*************************************************************/
/* Device Write - Wait for Xmit Rdy, then write word in ax   */
/* Leaves with WIE disabled when done, ax=0                  */
/*************************************************************/
int DevWrite(data,trk)
int data,trk;
{
   int   x;

   /* Wait for transmit ready */
   for(x=0; x<10000 && !(inp(MIDI_STATUS) & MIDI_TX_EMPTY); x++){
        /* just wait */
   }
   if(x==10000){
      return(-1);                      /* Not ready, return -1             */
   }
   outp(MIDI_DATA,data);               /* Write the data                   */
   return(0);
}
/***************************************************************/
/* Device wait -wait for the current operation to complete     */
/***************************************************************/
void DevIOCTLwait(int trk)
{
        while(!pcm_underun);
}







