
/********************* START OF SPECIFICATIONS *********************
*
* SOURCE FILE NAME:      MMEINTR.C
*
* DESCRIPTIVE NAME:      MME Specific interrupt routines
*
* STATUS: OS/2 Release 2.0
*
* FUNCTION: This module contains the main routines
*
*
*    DEPENDENCIES: NONE
*    RESTRICTIONS: NONE
*
* EXTERNAL ENTRY POINTS:    _get_next_buf
*
*
* INTERNAL ENTRY POINTS:
*
*
*
*
* EXTERNAL REFERENCES (system):
*       pStream
*       usActiveStreamIndex
*
* MODIFICATION HISTORY:
* DATE      DEVELOPER         CHANGE DESCRIPTION
* 05/10/91  Brian Czako       Original creation
* 08/02/91  C Dinallo         Changes to SHD interface MME.05
* 08/16/91  C Dinallo         Changes to SHD interface MME.07 return position
* 09/13/91  CAD/BC            MME.11 Do not get/ret buffers if stopped.
* 10/09/91  BRR123            If stream not in stream table then don't return.
* 11/04/91  BRR175-763-897    Copy DELAY in Get_next_buf routines (NOT position)
* 11/13/91  BRR187            Reset midi_clock_counter in DDCMD_STOP
* 11/18/91  BRR192-992        Copy runflags at get_next_xbuf time
* 12/11/91  BRR209            Combine set_xhpi and set_rhpi into set_hpi
* 01/10/92  BRR226            Don't use CLEAR_IOB_UNDERRUN/OVERRUN
* 01/17/92  BRR224            Add AUDIO_NOTIFY support - cumulative time
* 01/24/92  BRR240            Fix problems with record-stop-start not working
* 01/30/92  BRR249            Add rollover_time into calculations
* 02/12/92  BRR266            Tweek position calculations
* 03/04/92  BRR294            Copy head/tail segnums to new buffer
* 03/11/92  BRR306            Check to see if there are any more buffers before
*                             switching to next buffer in the list
* 04/07/92  BRR365            Don't add ROLLOVER_TIME to CUMULATIVE_TIME
* 04/11/92  BRR374            Send back data actually processed, not size of
*                             buffer in ulStatus.
* 04/14/92  BRR379            Fix roundoff bug in position reporting
* 05/19/92  BRR???            Change iobuf->delay to iobuf->moreflags
*********************** END OF SPECIFICATIONS **********************/


/*****************************************************************************
*                      I N C L U D E S
******************************************************************************/

#define         INCL_NOPMAPI
#define         INCL_DOS
#define         INCL_DOSDEVICES
#define         INCL_ERRORS
#include        <os2.h>

typedef ULONG   RC ;
typedef ULONG   HSTREAM ;

#include        <stdio.h>
#include        <audiodd.h>
#include        <auddef.h>
#include        <audproto.h>
#include        <audiodd2.h>
#include        <os2medef.h>
#include        <meerror.h>     // Multimedia error return codes
#include        <ssm.h>
#include        <shdd.h>
#include        <mme.h>
#include        <mmddcmds.h>    // Multimedia IDC commands

#include        <memory.h>

#if NUM_TRACKS > 1
#define REPORTED_TIME reported_time[trk]
#else
#define REPORTED_TIME reported_time
#endif

/*****************************************************************************
*                       E X T E R N S
******************************************************************************/

extern  ACPAMME AcpaMME;
extern  USHORT  usActiveStreamIndex;
extern  USHORT  StreamNumber ;
extern  trk_array[];
extern  SHORT mode[];
extern  void ReportPTraceError(unsigned int);           /* call to os2dd.asm */

#if NUM_TRACKS > 1
extern  ULONG reported_time[];
#else
extern  ULONG reported_time;
#endif

/********************* START OF SPECIFICATIONS *********************
*
* SUBROUTINE NAME:          get_next_buf
*
* DESCRIPTIVE NAME:
*
* FUNCTION:
*
* NOTES:        Called at interrupt time from DD.
*               Increments current index
*               Writes/Reads current buffer to/from DD     (set_hpi)
*               Reports interrupt to SH -- return the last buffer used
*
*
*
*
* ENTRY POINTS:
*     LINKAGE:
*
* INPUT:
*
* EXIT-NORMAL:  NO_ERROR
*
* EXIT_ERROR:
*
* EFFECTS:
*
* INTERNAL REFERENCES:
*
* EXTERNAL REFERENCES:
*
*********************** END OF SPECIFICATIONS **********************/

void    get_next_buf(IOB buffer,int trk,char op_type)
{

    PSTREAM         pStream;
    ULONG           ulrc;
    USHORT          Current ;
    USHORT          no_more_buffers;
    SHD_REPORTINT   ShdInt ;

    pStream = AcpaMME.paStream;
    if (ulrc = GetStreamBasedOnTrack(&pStream, trk) == -1) return;

    /* Do not call stream handler OR get any new buffers
       if stream was/is stopped by handler               */

    if (pStream->ulFlags & STREAM_STOPPED)
        return;

    Current = pStream->usCurrIOBuffIndex;
    if ((++Current == MAXIOBUFFS))   Current =  0 ;

    /* Check to see if there is another buffer there or not.... */
    if (Current != pStream->usNextIOBuffIndex) {

       /******************************
         Send the next buffer to DD
        ******************************/

       set_hpi (&pStream->Iobuff[Current], trk, 1, op_type);
       REPORTED_TIME = TimeOfCurrentBuffer(trk);
       pStream->Iobuff[Current].position = buffer->position;
       pStream->Iobuff[Current].moreflags = buffer->moreflags;
       pStream->Iobuff[Current].runflags = buffer->runflags & ~IOB_UNDERRUN;
       pStream->Iobuff[Current].runflags = buffer->runflags & ~IOB_OVERRUN;
       pStream->Iobuff[Current].head_segnum = buffer->head_segnum;
       pStream->Iobuff[Current].tail_segnum = buffer->tail_segnum;

       pStream->usCurrIOBuffIndex = Current;
       no_more_buffers = 0;

    } else {

       no_more_buffers = 1;
       ReportPTraceError(1);                   /* call to os2dd.asm */

    } /* endif */

    /***********************
        Call SHDReportInt
     ***********************/

    /* Don't return a null buffer - if null means that this buffer was */
    /* returned previously and we are here waiting for a new buffer to */
    /* be sent down.                                                   */

    if (buffer->buf[0].Virt) {

       ShdInt.ulFunction = SHD_REPORT_INT ;
       ShdInt.hStream    = pStream->hStream;
       ShdInt.pBuffer    = buffer->buf[0].Phys;

       if (op_type == 0) {  /* Playing */
          ShdInt.ulFlag     = SHD_WRITE_COMPLETE ;
          /* Want to return amount of data actually played.      */
          if (no_more_buffers) {
             ShdInt.ulStatus = buffer->buf[0].length - buffer->count;
          } else { /* Recording */
             ShdInt.ulStatus = buffer->buf[0].length;
          } /* endif */
       } else {
          ShdInt.ulFlag     = SHD_READ_COMPLETE ;
          ShdInt.ulStatus   = buffer->count;
       } /* endif */

       ShdInt.ulStreamTime = buffer->position ;

    //*****************************************
    // If overrun or underrun flags are set,
    // return error code to SHD, set ERROR flag
    //*****************************************
    //************************************
    // If pBuffer is NULL, report UNDERRUN
    // to ADSH, so he can shut me down
    //************************************

       if ((buffer->runflags & IOB_UNDERRUN ) ||
           (ShdInt.pBuffer == NULL)) {
            buffer->runflags &= ~IOB_UNDERRUN;
            ShdInt.ulFlag |= ERROR;
            ShdInt.ulStatus = ERROR_DEVICE_UNDERRUN;
       }
       if (buffer->runflags & IOB_OVERRUN) {
            buffer->runflags &= ~IOB_OVERRUN;
            ShdInt.ulFlag |= ERROR;
            ShdInt.ulStatus = ERROR_DEVICE_OVERRUN;
       }

       ((PSHDFN)pStream->ADSHEntry)(&ShdInt);

    } /* endif */

    //***************************
    // Reset values in pXiobuffer
    //***************************
    buffer->buf[0].Virt = NULL;
    buffer->buf[0].Phys = NULL;

       /* Don't set size to zero until we are no longer pointing to this */
       /* buffer so that DevInt doesn't get confused.                    */
    if (((op_type == 0) && (!no_more_buffers)) ||
        (op_type == 1)) {
       buffer->size = 0;
    } /* endif */

    return ;

} /* end get_next_buf */

/********************* START OF SPECIFICATIONS *********************
* SUBROUTINE NAME: GetStreamBasedOnTrack
* DESCRIPTIVE NAME: Get the stream table entry.
* FUNCTION: To search the stream table finding a match with the given parm.
* NOTES: This routine is called internally.
* ENTRY POINTS:
*     LINKAGE:   CALL near
*
* INPUT: pointer to stream table, stream handle to find
* EXIT-NORMAL: NO_ERROR
* EXIT_ERROR: ERROR_INVALID_STREAM if stream not found in table
* INTERNAL REFERENCES: none
* EXTERNAL REFERENCES: none
*********************** END OF SPECIFICATIONS **********************/
RC        GetStreamBasedOnTrack(PSTREAM far *ppStream, SHORT trk)
{
        USHORT  j;
        PSTREAM pStream;
        BOOL    bFound = FALSE;

        pStream = *ppStream;
        for (j=0; j<AcpaMME.usMaxNumStreams; j++) {
                if (((ULONG)trk_array[trk] == pStream->usSysFileNum)
                    && (pStream->ulFlags & STREAM_STREAMING))     {
                        bFound = TRUE;
                        break;
                        }
                pStream++;
        } /* end for */
        *ppStream = pStream;

        if (!bFound) return(-1);
        else return(0);
}
