
/********************* START OF SPECIFICATIONS *********************
*
* SOURCE FILE NAME:      MMDDCMDS.C
*
* DESCRIPTIVE NAME:      ACPA IDC HANDLER
*
* STATUS: OS/2 Release 2.0
*
* FUNCTION: This module contains the main routines
*
*
*    DEPENDENCIES: NONE
*    RESTRICTIONS: NONE
*
* EXTERNAL ENTRY POINTS:    DDCMDInternalEntryPoint - called from OS2DD.ASM
*
*
*
* INTERNAL ENTRY POINTS:
*
*
*
*
* EXTERNAL REFERENCES (system):
*   operation - PLAY, RECORD, or PLAY_AND_RECORD defined at AUDIO_INIT
*
*
* MODIFICATION HISTORY:
* DATE      DEVELOPER         CHANGE DESCRIPTION
* 02/18/91  Brian Czako       Original creation
* 06/19/91  BMCz              MME.01 -- Modifications
* 06/24/91  BMCz              MME.02 -- added stream instances
* 08/02/91  C Dinallo         MME.05 -- change ddcmd interface
* 08/08/91  C Dinallo         MME.06 -- bug on invalid sequence
* 08/18/91  C Dinallo         MME.07 -- implement SysFileNumber
* 08/30/91  C Dinallo         MME.08 -- check for null SysFileNumber
* 09/13/91  CAD / BC          MME.11 -- Trash all IOBuffs on a STOP command
* 09/18/91  CAD / BC          MME.12 -- Make sure stream is paused before resuming
* 10/12/91  CAD               MME.13 -- Reset current & next buff indexes, after a stop
*                                       this allows a re-start to start at the 1st buffer.
* 10/09/91  BRR123            Clear the STARTED bit in all IOBufs
* 10/11/91  BRR124            Clear the PAUSE bit when a STOP cmd comes through
* 10/15/91  BRR135            Allow RESUME even if not PAUSED - but is STARTED
* 11/04/91  BRR173-1174       Return ERROR_HNDLR_REGISTERED if sysfilenum already registered
* 11/04/91  BRR174-1173       Error with fix for BRR124 - clearing [Current] instead of [i] in DDCMD_STOP
* 11/04/91  BRR175-763-897    Don't copy POSITION and DELAY in DDCMD_Write/DDCMD_Read
* 11/06/91  BRR179-763-897    Change some buffer sizes in Protocol Table
* 11/13/91  BRR187            Reset midi_clock_counter in DDCMD_STOP
* 11/14/91  BRR188            Change MIDI and CDXA buffer sizes in Protocol Table
* 11/18/91  BRR192-992        Clear WAS_RUNNING bit on a DDCMD_Stop
* 12/10/91  BRR209            Change set_$hpi to set_hpi
* 12/18/91  BRR213            Don't unPAUSE in DDCMD_RESUME until after set_hpi
*                             and set trk from trk_array not stream table
* 12/18/91  BRR214            Add CDXA mono modes
*  1/10/92  BRR226            Don't use CLEAR_IOB_UNDERRUN/OVERRUN
*  1/15/92  BRR224            Add AUDIO_NOTIFY support
*  1/16/92  BRR229            Send position back for AUDIO_STOP/AUDIO_PAUSE
*  1/16/92  BRR230            Send position back for AUDIO_STATUS request
*  1/21/92  MME.15            Send Cumulative time back for AUDIO_STATUS request
*  1/28/92  BRR246            Wait for underrun when DDCMD_STOP comes down
*  1/30/92  BRR249            Implement rollover_time into calculations
*  2/06/92  BRR256            Check rc from set_hpi to see if valid buffer size
*  2/06/92  BRR258            Change RECORD to STREAM_OPERATION_PRODUCE
*  2/12/92  BRR266            Tweek position calcaulations
*  2/20/92  BRR280            Check pSetUpParm for NULL value in DDCMD_Setup
*  2/24/92  BRR281            Don't divide by SRATE_G to get time for MIDI
*  2/27/92  BRR284            Purge queue on DDCMD_STOP and dequeue request
*  3/03/92  BRR291            Send error back if request for unINITed track comes in
*  3/04/92  BRR293            Init head/tail segnum to 0.
*  3/12/92  BRR307            Don't call aud_control when queueing notify events
*                             because this is called during an interrupt when we
*                             are in the middle of aud_control already.
*  3/16/92  BRR316            Re-init rollover_time and pos_buffer_count during
*                             setup.
* 04/07/92  BRR365            Don't add ROLLOVER_TIME to CUMULATIVE_TIME
* 04/14/92  BRR379            Fix position rollover bug - drop cumulative_time
* 04/21/92  BRR412            Clear STREAM_PAUSE on a resume in ulFlags
* 05/19/92  BRR???            Change iobuf->delay to iobuf->moreflags
* 05/20/92  BRR???            Move Position calculations into subroutines
*********************** END OF SPECIFICATIONS **********************/


/*****************************************************************************
*                      I N C L U D E S
******************************************************************************/

#define         INCL_NOPMAPI
#define         INCL_BASE
#define         INCL_DOS
#define         INCL_DOSDEVICES
#define         INCL_ERRORS
#include        <os2.h>

typedef         ULONG   RC ;
typedef         ULONG   HSTREAM ;

#include        <stdio.h>
#include        <audiodd.h>
#include        <auddef.h>
#include        <audproto.h>
#include        <audiodd2.h>
#include        <os2medef.h>    // MME
#include        <meerror.h>     // Multimedia error return codes
#include        <ssm.h>
#include        <shdd.h>        // MME IDC interface
#include        <mme.h>
#include        <mmddcmds.h>    // Multimedia IDC commands

#include        <memory.h>
/*****************************************************************************
*                       E X T E R N S
******************************************************************************/


#if NUM_TRACKS > 1
#define  INITFLAGS initflags[trk]
#define  LAST_REPORTED_TIME last_reported_time[trk]
#define  REPORTED_TIME reported_time[trk]
#else
#define  INITFLAGS initflags
#define  LAST_REPORTED_TIME last_reported_time
#define  REPORTED_TIME reported_time
#endif


#if NUM_TRACKS > 1
extern ULONG  operation[] ;
extern int    trk_array[];
extern SHORT  mode[];
extern struct vscb xmitio[NUM_TRACKS];
extern struct vscb recio[NUM_TRACKS];
extern USHORT initflags[];              /* 1=INITED, 2=WAITING        */
#else
extern ULONG  operation;
extern int    trk_array;
extern SHORT  mode;
extern struct vscb xmitio;
extern struct vscb recio;
extern USHORT initflags;                /* 1=INITED, 2=WAITING        */
#endif

/*****************************************************************************
*               G L O B A L   D A T A    D E C L A R A T I O N S
******************************************************************************/

#if NUM_TRACKS > 1
unsigned long reported_time[NUM_TRACKS];
unsigned long last_reported_time[NUM_TRACKS];
#else
unsigned long reported_time;
unsigned long last_reported_time;
#endif
unsigned short trk;

ACPAMME AcpaMME = {
                       NULL,                  // paStream dynamically allocated
                       DEFAULTSTREAMS};       // number of streams

PROTOCOLTABLE   ProtocolTable[NPROTOCOLS] = {
                    { DATATYPE_MIDI,      SUBTYPE_NONE,        512L,  3, 0,     0, 0},
                    { DATATYPE_ADPCM_AVC, ADPCM_AVC_VOICE,  16128L,   3, 0,     0, 0},
                    { DATATYPE_ADPCM_AVC, ADPCM_AVC_MUSIC,  32712L,   3, 0,     0, 0},
                    { DATATYPE_ADPCM_AVC, ADPCM_AVC_STEREO, 31584L,   3, 0,     0, 0},
                    { DATATYPE_ADPCM_AVC, ADPCM_AVC_HQ,     32712L,   3, 0,     0, 0},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1M08, 4*1024L,  3, 11025, 1, 8},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1S08, 8*1024L,  3, 11025, 2, 8},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1M16, 8*1024L,  4, 11025, 1, 16},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1S16, 16*1024L, 4, 11025, 2, 16},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2M08, 8*1024L,  3, 22050, 1, 8},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2S08, 16*1024L, 4, 22050, 2, 8},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2M16, 16*1024L, 4, 22050, 1, 16},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2S16, 32*1024L, 4, 22050, 2, 16},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4M08, 16*1024L, 4, 44100, 1, 8},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4S08, 32*1024L, 4, 44100, 2, 8},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4M16, 32*1024L, 4, 44100, 1, 16},
                    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4S16, 60*1024L, 6, 44100, 2, 16},
                    { DATATYPE_MULAW,     MULAW_8B8KS,      60*1024L, 6, 8000,  2, 8}, /* 8k 8b Mu-Law   */
                    { DATATYPE_MULAW,     MULAW_8B11KS,     60*1024L, 6, 11025, 2, 8}, /* 11K */
                    { DATATYPE_MULAW,     MULAW_8B22KS,     60*1024L, 6, 22050, 2, 8}, /* 22k 8b Mu-Law  */
                    { DATATYPE_MULAW,     MULAW_8B44KS,     60*1024L, 6, 44100, 2, 8}, /* 44k 8b Mu-Law  */
                    { DATATYPE_ALAW,      ALAW_8B8KS,       60*1024L, 6, 8000,  2, 8},  /* 8k 8b Mu-Law   */
                    { DATATYPE_ALAW,      ALAW_8B11KS,      60*1024L, 6, 11025, 2, 8},  /* 11k 8b Mu-Law  */
                    { DATATYPE_ALAW,      ALAW_8B22KS,      60*1024L, 6, 22050, 2, 8},  /* 22k 8b Mu-Law  */
                    { DATATYPE_ALAW,      ALAW_8B44KS,      60*1024L, 6, 44100, 2, 8},  /* 44k 8b Mu-Law  */
                    { DATATYPE_NULL,      SUBTYPE_NONE,     60*1024L, 6, 0,     2, 16},  /* Get hdwr */
                    { DATATYPE_SPV2,      SPV2_BPCM,        60*1024L, 6, 14700, 2, 16},  /* SPV/2 BCPCM    */
                    { DATATYPE_SPV2,      SPV2_PCM,         60*1024L, 6, 14700, 2, 16},  /* SPV/2 16b PCM  */
                    { DATATYPE_SPV2,      SPV2_NONE,        60*1024L, 6, 0,     2, 16}, /* SPV/2 NONE */
                    { DATATYPE_CDXA_AUDIO, CDXA_LEVELC,     39984L, 3, 18900, 2, 16},  /* CD ROM XA Lvl C */
                    { DATATYPE_CDXA_AUDIO, CDXA_LEVELB,     39984L, 3, 37800, 2,  16},  /* CD ROM XA Lvl B */
                    { DATATYPE_CDXA_AUDIO, CDXA_LEVELC_MONO,39984L, 3, 18900, 1, 16},  /* CD ROM XA Lvl C */
                    { DATATYPE_CDXA_AUDIO, CDXA_LEVELB_MONO,39984L, 3, 37800, 1,  16}   /* CD ROM XA Lvl B */
                };

/*****************************************************************************
*                          C O D E
******************************************************************************/


/********************* START OF SPECIFICATIONS *********************
*
* SUBROUTINE NAME:          DDCMDInternalEntryPoint
*
* DESCRIPTIVE NAME: Entry point enabling ADSH to communicate with ACPA.
*
* FUNCTION: To execute the command requested by ADSH.
*
* NOTES:    This routine is called from the IDCEntry routine located
*           in the  OS2DD.ASM  file.
*
*
*
*
* ENTRY POINTS:     DDCmdInternalEntryPoint()
*     LINKAGE:      CALL FAR
*
* INPUT:        Pointer to command-dependent parameter structure.
*
* EXIT-NORMAL:  NO_ERROR
*
* EXIT_ERROR:   ERROR_INVALID_FUNCTION
*
* EFFECTS:
*
* INTERNAL REFERENCES:
*
* EXTERNAL REFERENCES:
*
*********************** END OF SPECIFICATIONS **********************/

//*********************************
// Process DDCMDs requested by ADSH
//*********************************
RC  far DDCMDInternalEntryPoint( PDDCMDCOMMON pCommon )
{
    RC     rc;

    if (pCommon==NULL)      return (ERROR_INVALID_BLOCK) ;

    if (rc = FindTrackForStream(pCommon))
        return(rc);

    switch( pCommon->ulFunction )
    {

        case DDCMD_SETUP:
                        return DDCmdSetup((PDDCMDSETUP)pCommon);


        case DDCMD_READ:
                        return DDCmdReadWrite((PDDCMDREADWRITE)pCommon,1);


        case DDCMD_WRITE:
                        return DDCmdReadWrite((PDDCMDREADWRITE)pCommon,0);


        case DDCMD_STATUS:
                        return DDCmdStatus((PDDCMDSTATUS)pCommon);


        case DDCMD_CONTROL:
                        return DDCmdControl((PDDCMDCONTROL)pCommon);

        case DDCMD_REG_STREAM:
                        return DDCmdRegister((PDDCMDREGISTER)pCommon);

        case DDCMD_DEREG_STREAM:
                        return DDCmdDeRegister((PDDCMDDEREGISTER)pCommon);



        default:
                        return( ERROR_INVALID_FUNCTION ) ;

    }

}


/********************* START OF SPECIFICATIONS *********************
*
* SUBROUTINE NAME:              DDCmdSetup
*
* DESCRIPTIVE NAME:     Sets up the audio device
*
* NOTES:        Match hStream parameter that ADSH will pass.
*               Ensure that the ACPA card is set up with the
*               correct DSP module, using the operation field
                of the structure matching hStream.
*
*
* EXIT-NORMAL:  NO_ERROR
*
* EXIT_ERROR:   ERROR_INVALID_STREAM
*               ERROR_INVALID_REQUEST
*               ERROR_INVALID_FUNCTION
*
********************************************************************
*
*       INPUTS:
*               ulFunction              DDCMD_SETUP
*               hStream                 Stream handle to set up
*               pSetupParm              Not used
*               ulSetupParmSize         Not used
*
*********************** END OF SPECIFICATIONS **********************/

RC      DDCmdSetup( PDDCMDSETUP pSetup )
{
    PSTREAM pStream;    // pointer to Stream table
    RC      rc;
    USHORT  i;

    //***********************************************
    // Search stream table for matching stream handle
    //***********************************************
    pStream = AcpaMME.paStream;
    if (rc = GetStreamEntry(&pStream, pSetup->hStream))
        return(rc);

    // How do I check which DSP module operation is set up??
    // Also, if Stream 1 is set up for MIDI, and Stream 2 is PCM, do
    // we LOAD the DSP module???
    switch (OPERATION_G)     {

        case PLAY:
            if (pStream->ulOperation != STREAM_OPERATION_CONSUME)      {
                return (ERROR_INVALID_REQUEST) ;
            }

            break ;


        case RECORD:
            if (pStream->ulOperation != STREAM_OPERATION_PRODUCE)    {
                return (ERROR_INVALID_REQUEST) ;
            }

            break ;


        case PLAY_AND_RECORD:       /* Do nothing for now */
            break ;


        default:
            return (ERROR_INVALID_FUNCTION) ;       /* Stream not initialized */
    }

    for (i=0; i<AcpaMME.usMaxNumStreams; i++) {
            if (AcpaMME.paStream[i].hStream != -1) {                              // check for only valid streams
                    if ((AcpaMME.paStream[i].ulFlags & STREAM_STREAMING)          // is stream running?
                       && (AcpaMME.paStream[i].hStream != pStream->hStream)       // is running stream the stream to context switch?
                       && (AcpaMME.paStream[i].usTrackNum == pStream->usTrackNum))  // is running stream using the same channel as the context switch stream?
                            return(ERROR_STREAM_NOT_STOP);                        // yes, so return error
            }
    }

    //************************************************************************
    // Stream handler needs to adjust our CumTime when doing a setup, this is
    // because the SH might have been seeked and all events that he sends will
    // be relative to the seeked time.
    //************************************************************************* */
    if (pSetup->pSetupParm) {
       pStream->ulCumTime = *((unsigned long far *)pSetup->pSetupParm);
       InitPosition(pStream->ulCumTime,trk);
    } else {
       return(ERROR_INVALID_BLOCK);
    } /* endif */

    return (NO_ERROR);
}

/********************* START OF SPECIFICATIONS *********************
*
* SUBROUTINE NAME:      DDCmdReadWrite
*
* DESCRIPTIVE NAME:     Do processeing for DDCMD_Read and DDCMD_Write
*
* NOTES:
*               This routine is called at interrupt and non-interrupt time.
*
*
* ENTRY POINTS:
*     LINKAGE:
*
* INPUT:
*
* EXIT-NORMAL:  NO_ERROR
*
* EXIT_ERROR:   ERROR_INVALID_STREAM
*               ERROR_INVALID_BLOCK
*               ERROR_STREAM_NOT_ACTIVE
*
********************************************************************
*
*
*********************** END OF SPECIFICATIONS **********************/
RC  DDCmdReadWrite(PDDCMDREADWRITE buffer, char op_type)
{

    USHORT  Current, Next, Previous ;            /* indexes */
    PSTREAM pStream;
    RC      rc;

    //*********************************
    // Cannot execute read/write until active
    // stream, is set via DDCmdSetup
    //*********************************
    if (!(INITFLAGS & INITED))  {
            return (ERROR_STREAM_NOT_ACTIVE);
    }

    if (buffer->pBuffer==NULL)   {
            return (ERROR_INVALID_BLOCK) ;
    }

    //***********************************************
    // Search stream table for matching stream handle
    //***********************************************
    pStream = AcpaMME.paStream;
    if (rc = GetStreamEntry(&pStream, buffer->hStream))
        return(rc);

    //************
    // Set indexes
    //************
    Current = pStream->usCurrIOBuffIndex;
    Next = pStream->usNextIOBuffIndex;

    /**************************************************
        Copy buffer pointer to "next"

        pBufPhys - Physical address is sent from ADSH

        Buffer   - Physical address to virtual
     **************************************************/

    //*************************************************
    // Fill buffer with data from buffer - size of data,
    // address, runflags, and place it in the queue.
    //*************************************************
    pStream->Iobuff[Next].size  = buffer->ulBufferSize;
    pStream->Iobuff[Next].buf[0].Phys = (char far *)buffer->pBuffer;
    pStream->Iobuff[Next].buf[0].Virt =
       PhysToVirt ((char far *)buffer->pBuffer, (unsigned)buffer->ulBufferSize);
    pStream->Iobuff[Next].buf[0].length = buffer->ulBufferSize;
    pStream->Iobuff[Next].tail_segnum = 0;
    pStream->Iobuff[Next].head_segnum = 0;
    pStream->Iobuff[Next].position  = 0;
    pStream->Iobuff[Next].moreflags = 0;

    if (op_type == 0) { /* Write */

       pStream->Iobuff[Next].count = buffer->ulBufferSize;
       pStream->Iobuff[Next].tail      = pStream->Iobuff[Next].buf[0].Virt;
       pStream->Iobuff[Next].head      =
            pStream->Iobuff[Next].tail + buffer->ulBufferSize;
       pStream->Iobuff[Next].runflags  = pStream->Iobuff[Current].runflags
                                         & ~IOB_UNDERRUN;
       if (Current!=Next) {        /* There is a previous buffer */
           if (Next == 0) {
               Previous = MAXIOBUFFS - 1 ;
           } else {
               Previous = Next - 1 ;
           } /* endif */
           pStream->Iobuff[Previous].count += buffer->ulBufferSize;
       }

    } else { /* Read */

       pStream->Iobuff[Next].count = 0;
       pStream->Iobuff[Next].head      = pStream->Iobuff[Next].buf[0].Virt;
       pStream->Iobuff[Next].tail      =
            pStream->Iobuff[Next].head + buffer->ulBufferSize;
       pStream->Iobuff[Next].runflags  = pStream->Iobuff[Current].runflags
                                         & ~IOB_OVERRUN;
    } /* endif */


    //***********************************************
    // Increment next buffer index and check for wrap
    //***********************************************
    if ((++Next == MAXIOBUFFS))
        Next = 0 ;
    pStream->usNextIOBuffIndex = Next;

    return( NO_ERROR );

} /* AddIOBuf */

/********************* START OF SPECIFICATIONS *********************
*
* SUBROUTINE NAME:          DDCmdStatus
*
* DESCRIPTIVE NAME:     Querey current position
*
* FUNCTION:     Allows the ADSH to get the current position value.
*
* NOTES:
*               This routine will currently only return the current
*               position value of the buffer.
*
*               This routine is called at interrupt and non-interrupt time.
*
*
* ENTRY POINTS:
*     LINKAGE:
*
* INPUT:
*
* EXIT-NORMAL:  NO_ERROR
*
* EXIT_ERROR:   ERROR_INVALID_STREAM
*
********************************************************************
*
*       INPUTS:
*               ulFunction              DDCMD_STATUS
*               hStream                 Stream handle
*
*********************** END OF SPECIFICATIONS **********************/

RC      DDCmdStatus(PDDCMDSTATUS pStatus )
{
    PSTREAM pStream;
    RC      rc;


    pStream = AcpaMME.paStream;
    if (rc = GetStreamEntry(&pStream, pStatus->hStream))
        return(rc);

    /* Get the current position                      */
    REPORTED_TIME = LAST_REPORTED_TIME = CurrentPosition(trk);

    pStatus->ulStatusSize = sizeof(REPORTED_TIME);
    pStatus->pStatus = &REPORTED_TIME;

    return( NO_ERROR );
}


/********************* START OF SPECIFICATIONS *********************
*
* SUBROUTINE NAME:          DDCmdControl
*
* DESCRIPTIVE NAME:
*
* FUNCTION:     Handles the AUDIO_CONTROL IOCTLs
*
* NOTES:    Since the entire routine uses the AUDIO_HPI calls,
*           Just set the current buffer's runflags to the right command
*
*
*
* ENTRY POINTS:
*     LINKAGE:
*
* INPUT:
*
* EXIT-NORMAL:  NO_ERROR
*
* EXIT_ERROR:   ERROR_INVALID_FUNCTION
*               ERROR_STREAM_NOT_ACTIVE
*               ERROR_INVALID_SEQUENCE
*               ERROR_INVALID_STREAM
*               ERROR_INSUFF_BUFFER
*
********************************************************************
*
*       INPUTS:
*               ulFunction              DDCMD_CONTROL
*               hStream                 Stream handle
*               ulCmd                   Specific control command
*               pParm                   Not used
*               ulParmSize              Not used
*
*********************** END OF SPECIFICATIONS **********************/

RC  DDCmdControl(PDDCMDCONTROL pControl)
{

    USHORT Current, i ;
    PSTREAM pStream;
    RC      rc;
    ULONG   pos;
    USHORT  x,y;
    struct request_block *req,*prv,*freed;
    #if NUM_TRACKS > 1
    extern int   num_reqs[];                  /* # of requests currently in queue */
    extern struct request_block *free_req[];  /* ptr to first free req_q block    */
    extern struct request_block *req_q_head[];/* ptr to first req_q block in Q    */
    extern int queue_lock[];                  /* Serializes access to request queue  */
    #else
    extern int   num_reqs;                    /* # of requests currently in queue */
    extern struct request_block *free_req;    /* ptr to first free req_q block    */
    extern struct request_block *req_q_head;  /* ptr to first req_q block in Q    */
    extern int queue_lock;                    /* Serializes access to request queue  */
    #endif
    #if NOT_K12
       #if NUM_TRACKS > 1
          extern long delay[];
       #else
          extern long delay;
       #endif
    #endif

    //******************************************
    // Cannot execute any control functions
    // until active stream is set via DDCmdSetup
    //******************************************
    if (!(INITFLAGS & INITED))  {
            return (ERROR_STREAM_NOT_ACTIVE);
    }

    pStream = AcpaMME.paStream;
    if (rc = GetStreamEntry(&pStream, pControl->hStream))
        return(rc);
    Current = pStream->usCurrIOBuffIndex;


    //****************************************
    // Perform specific DDCMD_CONTROL function
    //****************************************
    switch (pControl->ulCmd)    {


        default:
                return (ERROR_INVALID_FUNCTION) ;


        case    DDCMD_START:

                //*********************************************
                // ... PAUSE - START ... is an invalid sequence
                //*********************************************
                if (pStream->Iobuff[Current].runflags & PAUSED) {
                        return (ERROR_INVALID_SEQUENCE);
                }

                //*******************************************
                // SH told us to start and we have enough
                // full buffers, so send this buffer to the
                // audio card.  If operation is PLAY, the
                // routine will output the contents of the
                // buffer to the card.  If operation is RECORD
                // the routine will fill the buffer with data
                // from the card's input jack.
                //******************************************** */
                if (OPERATION_G == PLAY) {
                   if (set_hpi (&pStream->Iobuff[Current],trk,1,0))
                      return(ERROR_INVALID_BLOCK);
                } else {
                   if (set_hpi (&pStream->Iobuff[Current],trk,1,1))
                      return(ERROR_INVALID_BLOCK);
                }
                InitPosition(pStream->ulCumTime,trk);
                pStream->ulFlags |= STREAM_STREAMING;
                pStream->ulFlags &= ~STREAM_STOPPED;

                //*************************
                // Set all Iobuffs to START
                //*************************
                for (i=0; i<MAXIOBUFFS; i++) {
                        pStream->Iobuff[i].runflags |= STARTED;
                }
                break ;


           case DDCMD_STOP:

                // because we always write to the "next" buffer and play
                // from the "current" buffer, reset the indexes to point
                // at the same packet. So when a re-start comes in we will
                // not play a null buffer.

                Current = pStream->usCurrIOBuffIndex = pStream->usNextIOBuffIndex = 0;

                pStream->ulFlags |= STREAM_STOPPED;
                pStream->ulFlags &= ~STREAM_STREAMING;
                pStream->ulFlags &= ~STREAM_PAUSED;

                /* Get the current position                      */
                REPORTED_TIME = CurrentPosition(trk)+PositionNotCountedYet(trk);

                /************************************************
                 Do this so that PDD does not return an old buffer
                 to handler after handler received a STOP-DISCARD.
                 ************************************************/
                ClearAllIOBufs(pStream);
                pControl->pParm = &REPORTED_TIME;
                pControl->ulParmSize = sizeof(REPORTED_TIME);

                break ;


        case    DDCMD_PAUSE:

                //********************************************
                // trying to PAUSE a non-started stream = error
                //********************************************
                if (!(pStream->Iobuff[Current].runflags & STARTED))     {
                        return (ERROR_STREAM_NOT_STARTED);
                }

                pStream->Iobuff[Current].runflags |= PAUSED;
                pStream->ulFlags |= STREAM_PAUSED;
                pStream->ulFlags &= ~STREAM_STREAMING;

                /* Get the current position                      */
                REPORTED_TIME = LAST_REPORTED_TIME =
                    CurrentPosition(trk)+PositionNotCountedYet(trk);

                pControl->pParm = &REPORTED_TIME;
                pStream->ulCumTime = REPORTED_TIME;
                pControl->ulParmSize = sizeof(REPORTED_TIME);

                break ;


        case    DDCMD_RESUME:

                //*********************************************
                // trying to RESUME a stoped/non-paused stream = error
                //*********************************************
                if (!(pStream->Iobuff[Current].runflags & STARTED))    {
                        return (ERROR_INVALID_SEQUENCE);
                }

                InitPosition(pStream->ulCumTime,trk);

                //****************************************************
                // PhysToVirt returns 188:0, which will restore buffer
                // Then restore the iobuff structure via set_hpi
                //****************************************************
                PhysToVirt((char far *)pStream->Iobuff[Current].buf[0].Phys,
                           (unsigned)pStream->Iobuff[Current].buf[0].length);

                if (OPERATION_G == PLAY) {
                        set_hpi (&pStream->Iobuff[Current],trk,1,0);
                }
                else    set_hpi (&pStream->Iobuff[Current],trk,1,1);

                pStream->Iobuff[Current].runflags &= ~PAUSED;
                pStream->ulFlags |= STREAM_STREAMING;
                pStream->ulFlags &= ~STREAM_PAUSED;

                break ;


        case    DDCMD_ENABLE_EVENT:

                pos = *((unsigned long far *)pControl->pParm);
                if(queue_request(AUDIO_NOTIFY,      /* Request type         */
                      pos,                          /* position #           */
                      (void far *)pControl->hEvent, /* event handle         */
                      trk) < 0){
                      return (ERROR_TOO_MANY_EVENTS);
                }

                break ;

        case    DDCMD_DISABLE_EVENT:

                QUEUE_LOCK++;
                /* Loop through all of the requests looking for ones with */
                /* the specified event handle                             */
                req = REQ_Q_HEAD;
                prv = REQ_Q_HEAD;
                y = NUM_REQS;
                for (x=1; x<=y; x++) {
                   /* Does this one match? */
                   if (req->req_notify_hEvent == pControl->hEvent) {
                      freed = req;
                      if (req==REQ_Q_HEAD) {
                         req = prv = REQ_Q_HEAD = req->req_next;
                      } else {
                         req = req->req_next;
                         prv->req_next = req;
                      } /* endif */
                      /* Now put this request block onto the free chain */
                      freed->req_next = FREE_REQ;
                      FREE_REQ = freed;
                      NUM_REQS--;
                   } else { /* didn't match */
                      prv = req;
                      req = req->req_next;
                   } /* endif */
                } /* endfor */
                QUEUE_LOCK--;

                break ;


    }     /* switch */

    return( NO_ERROR );
}


/********************* START OF SPECIFICATIONS *********************
*
* SUBROUTINE NAME:          DDCmdRegister
*
* DESCRIPTIVE NAME:
*
* FUNCTION:
*
* NOTES:    Will receive the handler ID, handle of stream instance,
*           address of entry point from ADSH.
*           Set waiting flag (waiting for data)
*           Set runflags = 0
*           Set No_circular_buffer flag (0x80)
*           Set protocol info for ADSH
*           Set Address type to Physical
*
* ENTRY POINTS:
*     LINKAGE:
*
* INPUT:
*
* EXIT-NORMAL:  NO_ERROR
*
* EXIT-ERROR:   ERROR_INVALID_STREAM
*               ERROR_HNDLR_REGISTERED
*               ERROR_INVALID_FUNCTION
*               ERROR_INVALID_SPCBKEY
*
***********************************************************************************************
*
*       INPUTS:
*               ulFunction              DDCMD_REG_STREAM
*               hStream                 Stream handle
*               usSysFileNum            Device handle so PDD can map device instance to hStream
*               pSHDEntryPoint          Stream handler entry point
*               ulStreamOperation       Record (PRODUCE) or Play (CONSUME)
*               spcbkey                 Protocol info which determines outputs
*
*       OUTPUTS:
*               ulBufSize               Buffer size in bytes for SPCB
*               ulNumBufs               # of buffers for SPCB
*               ulAddressType           Address type of data buffer
*               ulBytesPerUnit          Bytes per unit
*               mmtimePerUnit           MMTIME per unit
*
*********************** END OF SPECIFICATIONS **********************/

RC  DDCmdRegister(PDDCMDREGISTER pRegister)
{

    USHORT      i;
    PSTREAM     pStream;
    BOOL        bFound;
    RC          rc;

    if (pRegister->hStream == -1)
        return (ERROR_INVALID_STREAM) ;    /*   Stream handle invalid   */

    if (pRegister->ulSysFileNum == DATATYPE_NULL)
        return(ERROR_INITIALIZATION);

    if ((pRegister->ulStreamOperation != STREAM_OPERATION_CONSUME) &&
        (pRegister->ulStreamOperation != STREAM_OPERATION_PRODUCE))
                return (ERROR_INVALID_FUNCTION);


    //******************************************
    // Do protocol table lookup, using DataType,
    // DataSubType as keys and return ulBufSize,
    // ulNumBufs, ulAddressType, mmtimePerUnit;
    //******************************************
    for ( i=0; i<NPROTOCOLS; i++ )  {

        if (ProtocolTable[i].ulDataType == pRegister->spcbkey.ulDataType) {
            if (ProtocolTable[i].ulDataSubType == pRegister->spcbkey.ulDataSubType) {
                //**********************************************
                // We found a match for data type, data sub type
                //**********************************************
                break ;
            }
        }
    }


    //***************
    // No match found
    //***************
    if (i==NPROTOCOLS) {
        return (ERROR_INVALID_SPCBKEY) ;
    }

    //***************************
    // Match found:
    //   Set up output parameters
    //***************************
    else {                                  /* Match found */
        pRegister->ulBufSize       = ProtocolTable[i].ulBufSize ;
        pRegister->ulNumBufs       = ProtocolTable[i].ulNumBufs ;
        pRegister->mmtimePerUnit   = 1;

        //****************************************************
        // Bytes per unit =
        //
        //  Samples     Channels     Bits      Byte     Sec
        //  -------  *           *  ------  *  ---- *  ------
        //    Sec                   Sample     Bits    MMTIME
        //****************************************************
        pRegister->ulBytesPerUnit  = ((ProtocolTable[i].ulSampleRate * ProtocolTable[i].usChannels
                                     * ProtocolTable[i].usBitsPerSample) / 8) /3;

    }
    //********************************************************************
    // Tell stream handler what type of data buffer pointer to reference
    //********************************************************************
    pRegister->ulAddressType = ADDRESS_TYPE_PHYSICAL ;

    //*************************************************************
    // Set the track in use by matching the sysfilenumber with the
    // sysfilenumbers that are in the trk_array.
    //*************************************************************
    bFound = FALSE;
    for (i=0; i<NUM_TRACKS; i++)
#if NUM_TRACKS > 1
            if ((ULONG)trk_array[i] == pRegister->ulSysFileNum) {
#else
            if ((ULONG)trk_array == pRegister->ulSysFileNum) {
#endif
                bFound = TRUE;
                trk = i;
            }
    if (!bFound)
        return(ERROR_INVALID_STREAM);

    //*************************************************************
    // Initialize pStream to point at the first entry for track trk
    //************************************************************* */
    pStream = AcpaMME.paStream;
    if (!(rc = GetStreamEntry(&pStream, pRegister->hStream)))
                return(ERROR_HNDLR_REGISTERED);
    pStream = AcpaMME.paStream;                      // no match, so create stream
    i=0;
    while(pStream->hStream != -1) {                     // find an empty stream entry
                if (++i >= AcpaMME.usMaxNumStreams)
                        return(ERROR_STREAM_CREATION);
                pStream++;
        }

    //**************************************
    // Found empty stream entry, so use it
    // Fill Stream structure
    //**************************************
    ClearAllIOBufs(pStream);

    //********************************
    // Save register info in structure
    //********************************
    pStream->hStream        = pRegister->hStream;
    pStream->ulFlags        = STREAM_REGISTERED;
    pStream->ulOperation    = pRegister->ulStreamOperation;
    pStream->usSysFileNum   = TRK_ARRAY;
    pStream->usTrackNum     = trk;
    pStream->usCurrIOBuffIndex = 0;
    pStream->usNextIOBuffIndex = 0;
    (PSHDFN)pStream->ADSHEntry = pRegister->pSHDEntryPoint;

    return( NO_ERROR );
}


/********************* START OF SPECIFICATIONS *********************
*
* SUBROUTINE NAME:          DDCmdDeRegister
*
* DESCRIPTIVE NAME:
*
* FUNCTION:
*
* NOTES:        Will remove the handle from the table by reassigning
*               the handle to -1 -- the check used by the other DDCmds
*
*
*
* ENTRY POINTS:
*     LINKAGE:
*
* INPUT:
*
* EXIT-NORMAL:  NO_ERROR
*
* EXIT_ERROR:   ERROR_INVALID_STREAM
*
***********************************************************************************************
*
*       INPUTS:
*               ulFunction              DDCMD_DEREG_STREAM
*               hStream                 Stream handle
*
*********************** END OF SPECIFICATIONS **********************/

RC  DDCmdDeRegister(PDDCMDDEREGISTER pDeRegister)
{
    USHORT  i ;
    PSTREAM pStream;
    RC          rc;


    //**************************************************************
    // Check table to see if stream is registered and a valid handle
    //**************************************************************
    pStream = AcpaMME.paStream;
    if (rc = GetStreamEntry(&pStream, pDeRegister->hStream))
                return(rc);

    //************************
    // De-activate this stream
    // and clear all flags
    //************************

    pStream->hStream = -1;                      // trash this stream
    pStream->ulFlags = 0;                       // clear flags

    for (i=0; i<MAXIOBUFFS; i++)    {
            pStream->Iobuff[i].runflags = 0;
    }

    return( NO_ERROR );
}

/********************* START OF SPECIFICATIONS *********************
* SUBROUTINE NAME:   FindTrackForStream()
* DESCRIPTIVE NAME:
* FUNCTION:  Given the stream handle find the track it is using by matching
*            the SysFileNumber in the trk_array.
*
* ENTRY POINTS:
*     LINKAGE:
*
* INPUT: Pointer to DDCMDCOMMON structure
*
* EXIT-NORMAL:  trk is set and NO_ERROR
*
* EXIT_ERROR:   ERROR_INVALID_STREAM
*
* EFFECTS:   NONE
* INTERNAL REFERENCES: NONE
* EXTERNAL REFERENCES: NONE
* 8/18/91      CD      Add this routine
*********************** END OF SPECIFICATIONS **********************/
RC FindTrackForStream(PDDCMDCOMMON pCommon)
{
        USHORT  j;
        BOOL    bFound = FALSE;
        PSTREAM pStream;
        RC      rc = NO_ERROR;

        //*************************************************
        // do only if NOT registering a stream
        //*************************************************
        if (pCommon->ulFunction != DDCMD_REG_STREAM) {
           pStream = AcpaMME.paStream;
           for (j=0; j<AcpaMME.usMaxNumStreams; j++) {
              if (pStream->hStream == pCommon->hStream) {    //find entry in stream table
                 //**************************
                 // Set global trk variable
                 //**************************
                 trk = pStream->usTrackNum;
                 bFound = TRUE;
                 break;
              }
              pStream++;
           }                       // end for
           if (!bFound)
              rc = ERROR_INVALID_STREAM;
        }                               // end if
        return(rc);
}

/********************* START OF SPECIFICATIONS *********************
* SUBROUTINE NAME: GetStreamEntry
* DESCRIPTIVE NAME: Get the stream table entry.
* FUNCTION: To search the stream table finding a match with the given parm.
* NOTES: This routine is called internally.
* ENTRY POINTS:
*     LINKAGE:   CALL near
*
* INPUT: pointer to stream table, stream handle to find
* EXIT-NORMAL: NO_ERROR
* EXIT_ERROR: ERROR_INVALID_STREAM if stream not found in table
* INTERNAL REFERENCES: none
* EXTERNAL REFERENCES: none
*********************** END OF SPECIFICATIONS **********************/
RC      GetStreamEntry(PSTREAM far *ppStream, HSTREAM hStream)
{
        USHORT  i;
        PSTREAM pStream;

        i=0;
        pStream = *ppStream;
        while(pStream->hStream != hStream) {            // find stream entry
                if (++i >= AcpaMME.usMaxNumStreams)
                        return(ERROR_INVALID_STREAM);
                pStream++;
        };
        *ppStream = pStream;
        return(NO_ERROR);
}

/********************* START OF SPECIFICATIONS *********************
* SUBROUTINE NAME: ClearAllIOBufs
* DESCRIPTIVE NAME: Zero out all the iobufs for a given stream.
* FUNCTION:
* NOTES: This routine is called internally.
* ENTRY POINTS:
*     LINKAGE:   CALL near
*
* INPUT: pStream
* EXIT-NORMAL: NO_ERROR
* EXIT_ERROR:
* INTERNAL REFERENCES: none
* EXTERNAL REFERENCES: none
*********************** END OF SPECIFICATIONS **********************/
void    ClearAllIOBufs(pStream)
PSTREAM     pStream;
{
   unsigned int i,x;
   char far *io;

   for ( i=0; i<MAXIOBUFFS; i++ )  {
      io = (char far *)&pStream->Iobuff[i];
      for (x=0; x<sizeof(struct iobuf); x++) {
         *io++ = 0;
      } /* endfor */
   }

} /* end ClearAllIOBufs */
