#define TRACE_ON 0
/*****************************************************************************/
/*                     ACPA Device Specific Non-MIDI Functions               */
/*                                                                           */
/*    DevInt()             (optional)                                        */
/*    TimerInt()           (optional)                                        */
/*                                                                           */
/* 5/04/92 BRR???  Creation of this file. Split out of ACPA.C.               */
/* 5/18/92 BRR???  Check INITFLAGS instead of TRK_ARRAY to determine if      */
/*                 trk should be processed. TRK_ARRAY gets set before the    */
/*                 trk is initialized and ready to be processed. (Getting    */
/*                 TRAP 0 - because mode=0 and srate=0)                      */
/* 5/20/92 BRR???  Move all position calculations into subroutines.          */
/*****************************************************************************/

/*****************************************************************************/
/* DEFINES                                                                   */
/*****************************************************************************/

/* Host Status reg equates                                                   */
#define  HSTREQ         2              /* 1 = int pending from C25           */

/*****************************************************************************/
/* Include DEFINEs                                                           */
/*****************************************************************************/

#if IS_OS2
#define  INCL_DOS
#define  INCL_DOSINFOSEG
#include <os2.h>
#endif

/*****************************************************************************/
/* Include Files                                                             */
/*****************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>

#include "acpadef.h"
#include "audiodd.h"
#include "auddef.h"
#include "audproto.h"
#include "audiodd2.h"

/*****************************************************************************/
/* External Function declarations                                            */
/*****************************************************************************/

extern void          acpa_command       (char newctrlval);
extern unsigned int  acpa_in            (unsigned int addr);
extern void          acpa_out           (unsigned int addr, unsigned int data);
extern int           acpa_status        (void);
extern void          CheckRolloverCount (int);
extern void          relink             (void);
extern void          ReportPTraceError  (unsigned int);
extern unsigned long UpdatePosition     (int);


/* NOT K12 Specific External Function declarations                           */
#if NOT_K12
extern unsigned long UpdateMIDIPosition (int);
#endif

#if TRACE_ON
   void       trace        (unsigned char trace_point);
#endif

/*****************************************************************************/
/* Internal Function declarations                                            */
/*****************************************************************************/

/* none */

/*****************************************************************************/
/* Device Interrupt Handler                                                  */
/*****************************************************************************/
int DevInt()
{

   /**************************************************************************/
   /* External Variable declarations                                         */
   /**************************************************************************/

   /* Track Independent External Variable Declarations                       */
   extern char          ctrlval;
   extern unsigned int  hostbase;
   extern IOB           iobuf;
   extern int           irqnum;
   extern int           mailbox[2];
   extern int           mastercb;
   extern unsigned char os2_version;
   extern int           pcmcb[2];
   extern int           revtrk;
   extern int           rmswitch;
   extern int           trackcb[2];

   /* Track Dependent External Variable Declarations                         */
   #if NUM_TRACKS > 1
      extern void           (far * callback_func[])(void);
      extern long           cb_status[];
      extern unsigned       clrchar[];
      extern unsigned char  data_processed[];
      extern unsigned int   GDTselector1[];
      extern unsigned int   GDTselector2[];
      extern unsigned int   GDTselector3[];
      extern unsigned int   GDTselector4[];
      extern int            host_buffer_count[]; /* # of buffers written by host     */
      extern int            hpilock[];
      extern int            initflags[];
      extern unsigned int   last_rec_head_segnum[];
      extern unsigned int   last_xmit_tail_segnum[];
      extern unsigned long  max_buffer_count[];
      extern int            mode[];
      extern int            numblocks[];         /* # of TMS data blocks             */
      extern long           operation[];
      extern unsigned int   pblocksize[];        /* Size of ADPCM play data blocks   */
      extern int            pbufstart[];         /* Beginning of play data buffers   */
      extern unsigned long  pos_buffer_count[];
      extern unsigned long  prev_recio_count[];
      extern unsigned long  prev_xmitio_count[];
      extern int            prv_buffer_count[];  /* Previous # TMS buffers played    */
      extern unsigned int   rblocksize[];        /* Size of ADPCM record data blocks */
      extern int            rbufstart[];         /* Beginning of record data buffers */
      extern struct vscb    recbuf[];
      extern struct vscb    recio[];
      extern unsigned long  rollover_time[];
      extern long           srate[];
      extern char far      *Srhead[];
      extern char far      *Sxtail[];
      extern unsigned long  time_per_block[];
      extern int            trk_array[];
      extern struct vscb    xmitbuf[];
      extern struct vscb    xmitio[];
   #else
      extern void           (far * callback_func)(void);
      extern long           cb_status;
      extern unsigned       clrchar;
      extern unsigned char  data_processed;
      extern unsigned int   GDTselector1;
      extern unsigned int   GDTselector2;
      extern unsigned int   GDTselector3;
      extern unsigned int   GDTselector4;
      extern int            host_buffer_count; /* # of buffers written by host     */
      extern int            hpilock;
      extern int            initflags;
      extern unsigned int   last_rec_head_segnum;
      extern unsigned int   last_xmit_tail_segnum;
      extern unsigned long  max_buffer_count;
      extern int            mode;
      extern int            numblocks;         /* # of TMS data blocks             */
      extern long           operation;
      extern unsigned int   pblocksize;        /* Size of ADPCM play data blocks   */
      extern int            pbufstart;         /* Beginning of play data buffers   */
      extern unsigned long  pos_buffer_count;
      extern unsigned long  prev_recio_count;
      extern unsigned long  prev_xmitio_count;
      extern int            prv_buffer_count;  /* Previous # TMS buffers played    */
      extern unsigned int   rblocksize;        /* Size of ADPCM record data blocks */
      extern int            rbufstart;         /* Beginning of record data buffers */
      extern struct vscb    recbuf;
      extern struct vscb    recio;
      extern unsigned long  rollover_time;
      extern long           srate;
      extern char far      *Srhead;
      extern char far      *Sxtail;
      extern unsigned long  time_per_block;
      extern int            trk_array;
      extern struct vscb    xmitbuf;
      extern struct vscb    xmitio;
   #endif


   /* OS/2 Specific External Variable Declarations                           */
   #if IS_OS2
      #if NUM_TRACKS > 1
        extern HSEM          callback_sem[];
        extern unsigned long trk_hvdm[];
        extern unsigned char trk_mode[];
        extern unsigned long VCB_Hndl[];
      #else
        extern HSEM          callback_sem;
        extern unsigned long trk_hvdm;
        extern unsigned char trk_mode;
        extern unsigned long VCB_Hndl;
      #endif
   #endif

   /* NOT K12 Specific External Variable Declarations                        */
   #if NOT_K12

      extern unsigned int    timing_prescaler;
      extern int             do_relink;

      #if NUM_TRACKS > 1
         extern long         delay[];
         extern unsigned int midiflags[];
         extern int          ppqncntr[];
         extern int          ppqndiv[];
      #else
         extern long         delay;
         extern unsigned int midiflags;
         extern int          ppqncntr;
         extern int          ppqndiv;
      #endif

   #endif

   /* AVC Specific External Variable Declarations                            */
   #if IS_AVC103
      extern int             avc103_mode;
      extern HSEM            SemHndl1;
   #endif

   /**************************************************************************/
   /* Internal Variable declarations                                         */
   /**************************************************************************/
   unsigned int  addr;
   int           again;
   int           at_curr_buffer;         /* Host current buffer              */
   int           at_mail;                /* Host mail (0,5)                  */
   int           tms_buffer_count;       /* # TMS buffers played             */
   char          finished;
   unsigned      first_track;
   unsigned long len;
   char          no_more_buffers;
   unsigned      pad;
   unsigned      silence;
   int           sofar;
   char          still_running;
   unsigned long tlen;
   int           tms_curr_buffer;        /* TMS current buffer               */
   int           trk;
   int           wasur;

   /* NOT K12 Specific Internal Variable Declarations                        */
   #if NOT_K12
      int intsrc;
      int loop_value;
      int ni;
      int numints;
   #endif

   /* OS2 Specific Internal Variable Declarations                            */
   #if IS_OS2
      char far *recioSave;
      char far *SrheadSave;
      char far *SxtailSave;
      char far *xmitioSave;
      int      wasrm;
   #endif

   /**************************************************************************/
   /* Start of Code                                                          */
   /**************************************************************************/
   #if TRACE_ON
   trace(0x00);
   #endif
   if(!(acpa_status() & HSTREQ)){         /* Is ACPA interrupting us?      */
     eoi(irqnum);                         /* Reset Interrupt Controller KOB   */
#if NOT_OS2
     if(irqnum==7) global_rearm(7);       /*   and issue IRQ7 global-rearm 71291 KOB*/
#endif
      return(-1);                         /* If not, return -1             */
   }

#if IS_OS2
   wasrm = rmswitch;                /* Save current realmode setting    61991*/
   _asm{                /* Determine if we're currently in Real Mode   */
      smsw  ax             ; get current msw
      rcr   ax,1           ; Protect bit into C
      mov   ax,0           ; Set AX = 0
      jc    is_protmode    ; Skip if protect mode
      mov   ax,1           ; Set AX = 1 if Real Mode
   is_protmode:
      mov   rmswitch,ax                                                 /*61991*/
   }

   if(rmswitch){                    /* Are we currently in Real Mode?         */
      RealToProt();                 /*    so switch back to protect mode   */

   }
#endif

#if NOT_K12
   numints = -1;
#endif

#if IS_OS2
   if (avc103_mode) {
      first_track = 1;
   } else {
#endif
      first_track = 0;
#if IS_OS2
   } /* endif */
#endif

   for(trk=first_track; trk<NUM_TRACKS; trk++){

      if(HPILOCK                       /* Is xmitio or recio being updated?   */
                                       /* or possibly changing dsp code       */
      || (!(INITFLAGS&INITED))){       /* Is this track in initialized yet?   */
         continue;
      }

#if IS_OS2
      xmitioSave = XMITIO.Ptr;
      recioSave = RECIO.Ptr;
      SxtailSave = SXTAIL;
      SrheadSave = SRHEAD;
      XMITIO.Ptr = XMITIO.GDT;      /*  and use GDT selectors              */
      XMITBUF.Ptr = XMITBUF.GDT;
      RECIO.Ptr = RECIO.GDT;
      RECBUF.Ptr = RECBUF.GDT;
      SXTAIL = XMITBUF.Ptr + (((IOB)XMITIO.Ptr)->tail - XMITBUF.Virt);
      SRHEAD = RECBUF.Ptr + (((IOB)RECIO.Ptr)->head - RECBUF.Virt);
#else
      SXTAIL = ((IOB)XMITIO.Ptr)->tail;
      SRHEAD = ((IOB)RECIO.Ptr)->head;
#endif
      check_if_stopped(trk);
#if NOT_DOS_K12
      aud_control(trk);
#endif
#if NOT_K12
      if(MODE_G == MIDI){                       /* Is MIDI running?           */
         iobuf = (IOB)XMITIO.Ptr;
         if(numints == -1){                     /* Do this only once          */
            numints = acpa_in(0x1ffc);          /* Read ACPA SYSTIM field     */
            numints &= 0x1f;                    /*  Limit # to 15             */
            numints *= timing_prescaler;
            acpa_out(0x1ffc,0);                 /* Now clear # ints           */
            intsrc = acpa_in(0x1fed);           /* Read INTSRC                */
            acpa_out(0x1fed,0);                 /*  now clear it              */
         }

         if(!is_running(trk)){               /* If neither rec or xmit started*/
            ni = 0;                          /*  then there's nothing to do   */
            DevAllNotesOff();
         }else { /* is running */
#if NUM_TRACKS > 1
            data_processed[trk] = 1;
#endif
            ni=numints;

            if (DELAY) {
               if ((long)ni <= DELAY) {
                  loop_value = ni - 1;
               } else {
                  loop_value = (int)(DELAY - 1);
               } /* endif */
               ni -= loop_value;
               DELAY -= loop_value;
            } else {
               loop_value = 0;
            } /* endif */
            while(--ni >= 0){
               #if TRACE_ON
               trace(0x0A);
               #endif
               if(--PPQNCNTR==0){           /* Prescale counter           */
                  PPQNCNTR = PPQNDIV;       /*  reload counter            */
                  if(iobuf->count) {    /* Has xmit buffer been updated? */
                     if (!(MIDIFLAGS & OUTSYNC)){   /*  without us knowing?       */
                        MIDIFLAGS |= OUTSYNC;       /* If so, then make sure that */
                        DELAY = 1;                  /*  we process it        */
                     }
                  }
                  if(MIDIFLAGS & OUTSYNC){    /* output sync waiting?       */
                     POS_BUFFER_COUNT += loop_value + 1;
                     if (POS_BUFFER_COUNT > MAX_BUFFER_COUNT) {
                        ROLLOVER_TIME += ((MAX_BUFFER_COUNT-40) * 600000)/TIME_PER_BLOCK;
                        POS_BUFFER_COUNT -= MAX_BUFFER_COUNT-40;
                     } /* endif */
                     iobuf->position = UpdateMIDIPosition(trk);
                     if(--DELAY==0){
                        DoOutput(trk);             /*                            */
#if IS_OS2
                        /* If thread is blocked on room in xmit buffer,       */
                        if(MIDIFLAGS & OUTPUT_WAITING){  /* then unblock it   */
                           #if TRACE_ON
                           trace(0x04);
                           #endif
                           DevHlp_Run((long)((char far *)&MIDIFLAGS));
                           #if TRACE_ON
                           trace(0x14);
                           #endif
                        }
                        /* If thread is blocked on AUDIO_WAIT,                */
                        if(initflags[0] & WAITING){
                           #if TRACE_ON
                           trace(0x05);
                           #endif
                           DevHlp_Run((long)((char far *)&XMITIO));   /* then unblock it*/
                           #if TRACE_ON
                           trace(0x15);
                           #endif
                        }
#endif
                     }
                  }
#if IS_OS2
                  else  if((iobuf->runflags & CHAIN_BUFFERS)
                        && (iobuf->buf[0].Phys != NULL))  {
                              get_next_buf((IOB)XMITIO.Virt,trk,0);
                  }
#endif
               }
               loop_value = 0;
            }/*while numints*/
            #if TRACE_ON
            trace(0x1A);
            #endif
         } /* endif */

#if IS_AVC103
         if(avc103_mode){
            if(SemHndl1){                       /*  If not null,              */
               SemClear(SemHndl1);        /*         post semaphore     */
            }
         }
      }else if(avc103_mode){
         if(SemHndl1){                       /*  If not null,              */
            SemClear(SemHndl1);              /*         post semaphore     */
         }

#endif

      }else{   /************* WAVEFORM or SPV2 ********************************/
#endif                                                               /*61491*/


         at_mail = acpa_in(mailbox[trk^revtrk]+2);
         tms_buffer_count = acpa_in(mailbox[trk^revtrk]+4);
         tms_curr_buffer = acpa_in(mailbox[trk^revtrk]+1);
         at_curr_buffer = acpa_in(mailbox[trk^revtrk]+3);

         /* Prevent counts from exceeding 'int' range */
         if(tms_buffer_count>32020 && HOST_BUFFER_COUNT>32020) {
            tms_buffer_count=tms_buffer_count-32000+NUMBLOCKS;
            acpa_out(mailbox[trk^revtrk]+4,tms_buffer_count);
            HOST_BUFFER_COUNT=HOST_BUFFER_COUNT-32000+NUMBLOCKS;
            acpa_out(trackcb[trk^revtrk]+6,HOST_BUFFER_COUNT);
            PRV_BUFFER_COUNT=PRV_BUFFER_COUNT-32000+NUMBLOCKS;
         }

         if(at_mail==0) {
                wasur = 1;                                 /*6691*/
                #if IS_OS2
                if (is_running(trk)) {             /* only if streaming data */
                   ReportPTraceError(0);           /* call to os2dd.asm */
                } /* endif */
                #endif
         } else
                wasur = 0;

                                                     /* Note changed all */
                                                     /* bufstart -> rbufstart */
                                                     /* blocksize -> rblocksize*/
                                                     /* in the RECORD portion*/
         if(OPERATION_G != PLAY) {

            iobuf = (IOB)RECIO.Ptr;

            if (!(iobuf->runflags & IOBUF_LOCK)) {
               iobuf->count += PREV_RECIO_COUNT;
               PREV_RECIO_COUNT = 0;
            } /* endif */

            do{
               again=0;
               /* If we're not started, or we're paused                       */
               if( !rec_running(trk)){
                  /* Update our DSP pointer to keep record going              */
                  /* If not started, then write 0 to TMS so monitor is turned */
                  /* off when application says stop - don't keep it going to  */
                  /* get an overrun eventually                                */
                  acpa_out(mailbox[trk^revtrk]+3,tms_curr_buffer);
                  acpa_out(mailbox[trk^revtrk]+4,0);  /*Zero out TMS count*/
                  HOST_BUFFER_COUNT = 0;         /* and our count    */
                  acpa_out(trackcb[trk^revtrk]+6,HOST_BUFFER_COUNT);
                  break;
               }

               /* Prevent positions from rollover errors                   */
               CheckRolloverCount(trk);

#if NUM_TRACKS > 1
               data_processed[trk] = 1;
#endif
               if(at_mail==0){                      /* Have we over-run?    */
                  /* Process over-run */
                  iobuf->runflags |= IOB_OVERRUN;
                  /* Check if callback should be called                    */
                  if (iobuf->runflags & CBUNDERRUN)
                     CB_STATUS |= CBUNDERRUN;
               }
               /* Is there any more data?                                     */
               if(HOST_BUFFER_COUNT < tms_buffer_count){
                  /* Is there room in i/o buffer?                                */
                  if((iobuf->count+(RBLOCKSIZE*2) <=
                      iobuf->size) ||
                     ((iobuf->runflags & CHAIN_BUFFERS) &&
                      iobuf->size)) {


                     /* Check if callback should be called                    */
                     if (iobuf->runflags & CBBLOCK)
                        CB_STATUS |= CBBLOCK;
                     if (iobuf->runflags & CBDATA)
                        CB_STATUS |= CBDATA;

                     /* Loop until all data was written * */
                     finished = 0;
                     tlen = RBLOCKSIZE*2;
                     sofar = 0;
                     no_more_buffers = 0;
                     while (!(finished)) {
                        /* Does block need to wrap around our I/O buffer?           */
                        len = check_wrap((IOB)RECIO.Ptr,tlen,trk,HEAD,RX);
                        if (LAST_REC_HEAD_SEGNUM) {

                           /* Copy data up to end of I/O buffer                     */
                           if (OPERATION_G == RECORD) {
                              acpa_rblock(RBUFSTART+(at_curr_buffer*RBLOCKSIZE)+sofar,
                                 SRHEAD,(unsigned int)len/2);
                           } else { /* SPV2 Compute operation - only 1 buffer */
                              acpa_rblock(RBUFSTART+sofar,SRHEAD,(unsigned int)len/2);
                           } /* endif */
                           sofar += len/2;

                           if (iobuf->runflags & IOBUF_LOCK) {
                              PREV_RECIO_COUNT += len;
                           } else {
                              iobuf->count += len;
                           } /* endif */
#if IS_OS2
                           if(iobuf->runflags & CHAIN_BUFFERS){

                              get_next_buf((IOB)RECIO.Virt,trk,1);

                              /* Might want to check if really given another buffer?! CHRIS */
                              if((iobuf->count+((RBLOCKSIZE*2)-len))
                                              > iobuf->size) {
                                 finished = 1;
                                 no_more_buffers = 1;
                                 #if IS_OS2
                                    ReportPTraceError(1);  /* call to os2dd.asm */
                                 #endif
                              }

                           }else{  /* Not chained - but still wrapped */

                              /* Now that write has been done, map new GDT */
                              AddrToGDTselector(RECBUF.Phys,
                                     (unsigned)RECBUF.length,
                                     GDTSELECTOR4);

                           } /* endif */
#endif
                           /* update head pointer                           */
                           iobuf->head = RECBUF.Virt;
                           SRHEAD = RECBUF.Ptr;

                           /* if not data left then we're all done */
                           tlen -= len;
                           if (tlen == 0)
                              finished = 1;

                        } else {  /* didn't wrap */

                           if (OPERATION_G == RECORD) {

                              acpa_rblock(RBUFSTART+(at_curr_buffer*RBLOCKSIZE)+sofar,
                                 SRHEAD,(unsigned int)len/2);

                           } else { /* SPV2 Compute operation - only 1 buffer */

                              acpa_rblock(RBUFSTART+sofar,SRHEAD,
                                          (unsigned int)len/2);

                           } /* endif */

                           iobuf->head += len;
                           SRHEAD += len;
                           finished = 1;

                           if (iobuf->runflags & IOBUF_LOCK) {
                              PREV_RECIO_COUNT += len;
                           } else {
                              iobuf->count += len;
                           } /* endif */

                        }

                     } /* endwhile */

                     if(++at_curr_buffer >= NUMBLOCKS){ /* Update TMS pointers */
                        at_curr_buffer = 0;
                     }
                     acpa_out(mailbox[trk^revtrk]+3,at_curr_buffer);
                     if (!no_more_buffers)
                        again = 1;            /* and loop for more data  */
                     HOST_BUFFER_COUNT++;     /* Update our counter      */
                     iobuf->position = UpdatePosition(trk);
                     acpa_out(trackcb[trk^revtrk]+6,HOST_BUFFER_COUNT);
                     tms_buffer_count = acpa_in(mailbox[trk^revtrk]+4);
                  }else{                           /* Process OVERRUN    */
                     if(tms_buffer_count == HOST_BUFFER_COUNT+NUMBLOCKS-1){
                        iobuf->runflags |= IOB_OVERRUN;
                        /* Check if callback should be called                    */
                        CB_STATUS |= (iobuf->runflags & CBUNDERRUN);
                        if (iobuf->runflags & CBUNDERRUN)
                           CB_STATUS |= CBUNDERRUN;
                        /* Update our DSP ptr so DSP doesn't overrun      */
                        if(++at_curr_buffer >= NUMBLOCKS){
                           at_curr_buffer = 0;
                        }
                        acpa_out(mailbox[trk^revtrk]+3,at_curr_buffer);
                        /* Update our buffer count, and position       */
                        HOST_BUFFER_COUNT++;     /* Update our counter      */
                        iobuf->position = UpdatePosition(trk);
                        acpa_out(trackcb[trk^revtrk]+6,HOST_BUFFER_COUNT);
                     } else {
                        if (iobuf->size < RBLOCKSIZE*2) {
                           iobuf->runflags |= IOB_OVERRUN;
                           /* Check if callback should be called                    */
                           if (iobuf->runflags & CBUNDERRUN)
                              CB_STATUS |= CBUNDERRUN;
                        } /* endif */
#if IS_OS2
                        if ((iobuf->runflags & CHAIN_BUFFERS) &&
                           (iobuf->size < (RBLOCKSIZE*2))){
                              get_next_buf((IOB)RECIO.Virt,trk,1);
                        }
#endif
                     }
                  }

               } else {
#if IS_OS2
                  /* should report OVERRUN to MMPM if that's what happened */
                  if ((at_mail == 0) &&
                      (iobuf->runflags & CHAIN_BUFFERS)) {
                     get_next_buf((IOB)RECIO.Virt,trk,1);
                  } /* endif */
#endif
               }
            }while(again);
         } /* endif */
         /************************* PLAYBACK or COMPUTE **********************/

                                                     /* Note changed all */
                                                     /* bufstart -> pbufstart */
                                                     /* blocksize -> pblocksize*/
                                                     /* in the PLAYBACK portion*/
         if(OPERATION_G != RECORD) {                 /* Are we playing?      */

            iobuf = (IOB)XMITIO.Ptr;

            if (!(iobuf->runflags & IOBUF_LOCK)) {
               iobuf->count += PREV_XMITIO_COUNT;
               PREV_XMITIO_COUNT = 0;
            } /* endif */

            /* Make sure we're started, and not paused                        */
            if(!xmit_running(trk)){
               /* ACPA could still be playing data, even though we stopped */
               while (PRV_BUFFER_COUNT < tms_buffer_count) {
                  PRV_BUFFER_COUNT++;
                  iobuf->position = UpdatePosition(trk);
                  /* Check if callback should be called                  */
                  if (iobuf->runflags & CBBLOCK)
                     CB_STATUS |= (long)CBBLOCK << 16;
                  if (iobuf->runflags & CBDATA)
                     CB_STATUS |= (long)CBDATA << 16;

               }
               /* Clear flag for next int to say we weren't running prev and */
               /* that's why you got the underrun, so don't report it */
               iobuf->runflags &= ~WAS_RUNNING;


            }else{ /* xmit_running */

               /* Prevent positions from rollover errors                   */
               CheckRolloverCount(trk);

#if NUM_TRACKS > 1
              data_processed[trk] = 1;
#endif
              if (OPERATION_G == PLAY) {
                 while (tms_buffer_count < NUMBLOCKS)
                    tms_buffer_count = acpa_in(mailbox[trk^revtrk]+4);
              } /* endif */

              still_running = 1;
              do{
               again=0;
               /* Any empty ACPA buffers?                                     */
               if(HOST_BUFFER_COUNT < tms_buffer_count+NUMBLOCKS-1){
                  pad = 0;
                  /* Do we have enough data to fill a block?                  */
                  if(iobuf->count >= PBLOCKSIZE*2){
                     tlen = PBLOCKSIZE*2;
                  } else if ((INITFLAGS & WAITING) ||
                             (iobuf->runflags & PADIT)) {
                     tlen = iobuf->count;
                     pad = PBLOCKSIZE - (unsigned int)tlen/2;
                  } else {
                     tlen = 0;
                  } /* endif */
                  if (tlen) {

                     /* Check if callback should be called                    */
                     if (iobuf->runflags & CBBLOCK)
                        CB_STATUS |= (long)CBBLOCK << 16;
                     if (iobuf->runflags & CBDATA)
                        CB_STATUS |= (long)CBDATA << 16;

                     /* Loop until all data was written * */
                     finished = 0;
                     sofar = 0;
                     while ((!(finished)) && still_running) {
                        /* Does block need to wrap around our I/O Buffer?           */
                        len = check_wrap((IOB)XMITIO.Ptr,tlen,trk,TAIL,TX);
                        if (LAST_XMIT_TAIL_SEGNUM) {
                           /* Copy data up to end of I/O Buffer                     */
                           if (OPERATION_G == PLAY) {
                              acpa_wblock(PBUFSTART+(at_curr_buffer*PBLOCKSIZE)+sofar,
                                       SXTAIL,(unsigned int)len/2);
                           } else { /* SPV2 compute operation - only 1 buffer */
                              acpa_wblock(PBUFSTART+sofar,SXTAIL,(unsigned int)len/2);
                           } /* endif */
                           sofar += (unsigned int)len/2;

                           if (iobuf->runflags & IOBUF_LOCK) {
                              PREV_XMITIO_COUNT -= len;
                           } else {
                              iobuf->count -= len;
                           } /* endif */
#if IS_OS2
                           if(iobuf->runflags & CHAIN_BUFFERS){

                              get_next_buf((IOB)XMITIO.Virt,trk,0);
                              /* MME may have stopped us in get_next_buf and */
                              /* taken back all of its buffers.....     */
                              if (!(iobuf->runflags & STARTED)) {
                                 still_running = 0;
                              } /* endif */

                           }else{  /* Not chained - but still wrapped */

                              /* Now that write has been done, map new GDT */
                              AddrToGDTselector(XMITBUF.Phys,
                                     (unsigned)XMITBUF.length,
                                     GDTSELECTOR3);

                           } /* endif */
#endif

                           /* update tail pointer                           */
                           iobuf->tail = XMITBUF.Virt;
                           SXTAIL = XMITBUF.Ptr;

                           /* if not data left then we're all done */
                           tlen -= len;
                           if (tlen == 0) finished = 1;

                        } else {  /* didn't wrap */

                           if (OPERATION_G == PLAY) {

                              acpa_wblock(PBUFSTART+(at_curr_buffer*PBLOCKSIZE)
                                            +sofar, SXTAIL, (unsigned int)len/2);

                           } else { /* SPV2 compute operation - only 1 buffer */

                              acpa_wblock(PBUFSTART+sofar,SXTAIL,
                                          (unsigned int)len/2);

                           } /* endif */

                           iobuf->tail += len;
                           SXTAIL += len;
                           finished = 1;
                           if (iobuf->runflags & IOBUF_LOCK) {
                              PREV_XMITIO_COUNT -= len;
                           } else {
                              iobuf->count -= len;
                           } /* endif */

                        }

                     } /* endwhile */

                     if (still_running) {
                        if (pad) {
                           _asm mov   dx,hostbase
                           silence = CLRCHAR;
                           addr = PBUFSTART+((at_curr_buffer+1)*PBLOCKSIZE)-pad;
                           while (pad) {
                              _asm {
                              add   dl,4
                              mov   ax,addr  /* Set address                      */
                              out   dx,ax
                              sub   dl,4
                              mov   ax,silence
                              out   dx,ax
                              }
                              addr++;
                              pad--;
                           } /* endwhile */
                        } else {
                           again = 1;
                        } /* endif */

                        if(++at_curr_buffer >= NUMBLOCKS){   /* Update TMS ptr    */
                           at_curr_buffer = 0;
                        }
                        HOST_BUFFER_COUNT++;     /* Update our count    */
                        if(!wasur || MODE_G != ADPCM) {
                           acpa_out(mailbox[trk^revtrk]+3,at_curr_buffer);
                           acpa_out(trackcb[trk^revtrk]+6,HOST_BUFFER_COUNT);
                        } /* endif */
                        tms_buffer_count = acpa_in(mailbox[trk^revtrk]+4);
                     } /* endif */

                  } else {
                        iobuf->runflags |= IOB_UNDERRUN;
                        /* Check if callback should be called                    */
                        if (iobuf->runflags & CBUNDERRUN)
                           CB_STATUS |= (long)CBUNDERRUN << 16;
#if IS_OS2
                     if(iobuf->runflags & CHAIN_BUFFERS)  // call ADSH after last buffer played.
                        get_next_buf((IOB)XMITIO.Virt,trk,0);          // Did hardware play last partial buffer? Should we pad it and force a play?
#endif

                  }
                  if(PRV_BUFFER_COUNT < tms_buffer_count){
                     PRV_BUFFER_COUNT++;
                     iobuf->position = UpdatePosition(trk);
                  }
               }

              }while(again);
              /* If we were underrun, then restart playback if we can         */
              if (wasur && (iobuf->runflags & WAS_RUNNING)){
                 iobuf->runflags |= IOB_UNDERRUN;
                 /* Check if callback should be called                    */
                 if (iobuf->runflags & CBUNDERRUN)
                    CB_STATUS |= (long)CBUNDERRUN << 16;
              }

              /* update mailbox if not done above                 */
              if (wasur && MODE_G==ADPCM) {
                 acpa_out(mailbox[trk^revtrk]+3,at_curr_buffer);
                 acpa_out(trackcb[trk^revtrk]+6,HOST_BUFFER_COUNT);
              } /* endif */

              /* Set flag for next int to say we were running prev and */
              /* if you get an underrun, report it                     */
              iobuf->runflags |= WAS_RUNNING;

            } /* endif xmit_running */
         }
#if NOT_K12
      }
#endif
#if IS_OS2
      XMITIO.Ptr = xmitioSave;             /*  and restore pointers         */
      RECIO.Ptr = recioSave;
      SXTAIL = SxtailSave;
      SRHEAD = SrheadSave;
#endif


   }

#if NOT_K12
   /* Relink if needed */
   if (do_relink) relink();
#endif

#if IS_OS2
   if(rmswitch){
      ProtToReal();                          /*  the back to real mode      */
   }

   for(trk=0; trk<NUM_TRACKS; trk++){     /* Loop for each track        */
      /* Do callback to application if one was specified       */
         if (TRK_MODE == REALMODE) {
            if (((long)CALLBACK_FUNC != 0) && (CB_STATUS != 0)) {
                  ((IOB)RECIO.Ptr)->moreflags |= CB_STATUS & 0x0000FFFF;
                  ((IOB)XMITIO.Ptr)->moreflags |= CB_STATUS >> 16;
                  if ( os2_version < 20 ) {
                     if(rmswitch) {
                        /* Call the routine */
                        _asm pushf;             // prepare for IRET
                        CALLBACK_FUNC();
                     }
                  } else {
                     VirtCallBack(VCB_HNDL, TRK_HVDM);
                  }
                  CB_STATUS = 0; /* clear out status so we know     */
                                      /* that it was reported */
            } /* endif */
         } else {
            if ((CALLBACK_SEM != 0) &&
                (CB_STATUS != 0)) {
                  ((IOB)RECIO.Ptr)->moreflags |= CB_STATUS & 0x0000FFFF;
                  ((IOB)XMITIO.Ptr)->moreflags |= CB_STATUS >> 16;
                  /* Clear the semaphore */
                  SemClear(CALLBACK_SEM);
                  CB_STATUS = 0; /* clear out status so we know     */
                                      /* that it was reported */
            } /* endif */
         } /* endif */
   } /* end for */


   rmswitch = wasrm;                         /* Restore previous setting      */
#else
/* DOS MODE */
   for(trk=0; trk<NUM_TRACKS; trk++){     /* Loop for each track       */
      /* Call the routine */
      if (((long)CALLBACK_FUNC != 0) &&
                (CB_STATUS != 0)) {
         ((IOB)RECIO.Ptr)->moreflags |= CB_STATUS & 0x0000FFFF;
         ((IOB)XMITIO.Ptr)->moreflags |= CB_STATUS >> 16;
         _asm pushf;                 // prepare for IRET
         CALLBACK_FUNC();
         CB_STATUS = 0;
      } /* endif */
   } /* end for */
#endif

   acpa_command((char)(ctrlval & 0xfd));     /* Clear int from ACPA  (HREQACK)*/
   eoi(irqnum);                              /* Reset Interrupt Controller    */
#if NOT_OS2
   if(irqnum==7) global_rearm(7);            /*   and issue IRQ7 global-rearm */
#endif

   #if TRACE_ON
   trace(0xFF);
   #endif
   return(0);                                /* and return 0                  */
}


#if NOT_K12
/*****************************************************************************/
/* Dummy TimerInt routine                                                    */
/*****************************************************************************/
int TimerInt()
{
   /* Nothing to do */
   return(0);
}
#endif
