/*
 *  stdlib.h    Standard Library functions
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988-1992.  All rights reserved.
 */
#ifndef _STDLIB_H_INCLUDED
#pragma pack(1);

#ifndef _SIZE_T_DEFINED_
#define _SIZE_T_DEFINED_
typedef unsigned size_t;
#endif

#ifndef _WCHAR_T_DEFINED_
 #define _WCHAR_T_DEFINED_
 typedef unsigned short wchar_t;
#endif

#ifndef NULL
 #if defined(__SMALL__) || defined(__MEDIUM__) || defined(__386__)
  #define NULL   0
 #else
  #define NULL   0L
 #endif
#endif


#define RAND_MAX        32767u
#define EXIT_SUCCESS    0
#define EXIT_FAILURE    0xff
#define MB_CUR_MAX      1

typedef struct  {
        int     quot;
        int     rem;
} div_t;

typedef struct  {
        long    quot;
        long    rem;
} ldiv_t;

#ifdef  __INLINE_FUNCTIONS__
 int      abs(int __j);
 div_t    div(int __numer,int __denom);
 long int labs(long int __j);
 #ifdef __386__
  ldiv_t        ldiv(long __numer,long __denom);
  #define ldiv(n,d)   _inline_ldiv(n,d)
 #endif
 #define abs(x)     _inline_abs(x)
 #define div(x,y)   _inline_div(x,y)
 #define labs(x)    _inline_labs(x)
#endif

void             abort( void );
int              abs( int __j );
int              atexit( void ( *__func )( void ) );
double           atof( const char *__nptr );
int              atoi( const char *__nptr );
long int         atol( const char *__nptr );
void            *bsearch( const void *__key, const void *__base,
                    size_t __nmemb, size_t __size,
                    int ( *__compar )( const void *__pkey, const void *__pbase ) );
void            *calloc( size_t __n, size_t __size );
div_t            div( int __numer, int __denom );
void             exit( int __status );
void             free( void *__ptr );
char            *getenv( const char *__name );
long int         labs( long int __j );
ldiv_t           ldiv( long int __numer, long int __denom );
void            *malloc( size_t __size );
int              mblen( const char *__s, size_t __n );
size_t           mbstowcs( wchar_t *__pwcs, const char *__s, size_t __n );
int              mbtowc( wchar_t *__pwc, const char *__s, size_t __n );
void             qsort( void *__base, size_t __nmemb, size_t __size,
                    int (*__compar)( const void *, const void * ) );
int              rand( void );
void            *realloc( void *__ptr, size_t __size );
void             srand( unsigned int __seed );
double           strtod( const char *__nptr, char **__endptr );
long int         strtol( const char *__nptr, char **__endptr, int __base );
unsigned long    strtoul( const char *__nptr, char **__endptr, int __base );
int              system( const char *__string );
size_t           wcstombs( char *__s, const wchar_t *__pwcs, size_t __n );
int              wctomb( char *__s, wchar_t __wchar );

#pragma aux     abort   aborts;
#pragma aux     exit    aborts;

#define atof(p)  strtod(p,(char **)NULL)


#if !defined(NO_EXT_KEYS) /* extensions enabled */

#ifdef  __INLINE_FUNCTIONS__
 unsigned int _rotl(unsigned int __value,unsigned int __shift);
 unsigned int _rotr(unsigned int __value,unsigned int __shift);
 #ifdef __386__
  unsigned long _lrotl(unsigned long __value,unsigned int __shift);
  unsigned long _lrotr(unsigned long __value,unsigned int __shift);
  #define _lrotl(x,n) _inline__lrotl(x,n)
  #define _lrotr(x,n) _inline__lrotr(x,n)
 #endif
 #define _rotl(x,n) _inline__rotl(x,n)
 #define _rotr(x,n) _inline__rotr(x,n)
#endif

unsigned         atoh( const char *__nptr );
char            *ecvt( double __val, int __ndig, int *__dec, int *__sign );
void	         _exit( int __status );
#pragma aux      _exit   aborts;
char            *fcvt( double __val, int __ndig, int *__dec, int *__sign );
char            *_fullpath( char *__buf,const char *__path,size_t __size );
char            *gcvt( double __val, int __ndig, char *__buf );
char            *itoa( int __value, char *__buf, int __radix );
unsigned long    _lrotl( unsigned long __value, unsigned int __shift );
unsigned long    _lrotr( unsigned long __value, unsigned int __shift );
char            *ltoa( long int __value, char *__buf, int __radix );
void             _makepath( char *__path, const char *__drive,
		    const char *__dir, const char *__fname, 
		    const char *__ext );
int              putenv( const char *__string );
unsigned int 	 _rotl( unsigned int __value, unsigned int __shift );
unsigned int 	 _rotr( unsigned int __value, unsigned int __shift );
void             _searchenv( const char *__name, const char *__env_var,
                    char *__buf );
void             _splitpath2( const char *__inp, char *__outp,
                    char **__drive, char **__dir, char **__fn, char **__ext );
void             _splitpath( const char *__path, char *__drive,
                    char *__dir, char *__fname, char *__ext );
void             swab( char *__src, char *__dest, int __num );
char            *ultoa( unsigned long int __value, char *__buf, int __radix );
char            *utoa( unsigned int __value, char *__buf, int __radix );

/* min and max macros */
#define max(a,b)  (((a) > (b)) ? (a) : (b))
#define min(a,b)  (((a) < (b)) ? (a) : (b))

/*
 * The following sizes are the maximum sizes of buffers used by the _makepath()
 * and _splitpath() functions. They include space for the '\0' terminator.
 */
#if defined(__OS2__)
#define _MAX_PATH   260 /* maximum length of full pathname */
#define _MAX_DRIVE   3  /* maximum length of drive component */
#define _MAX_DIR    256 /* maximum length of path component */
#define _MAX_FNAME  256 /* maximum length of file name component */
#define _MAX_EXT    256 /* maximum length of extension component */
#else
#define _MAX_PATH   144 /* maximum length of full pathname */
#define _MAX_DRIVE   3  /* maximum length of drive component */
#define _MAX_DIR    130 /* maximum length of path component */
#define _MAX_FNAME   9  /* maximum length of file name component */
#define _MAX_EXT     5  /* maximum length of extension component */
#endif

#define _MAX_PATH2 (_MAX_PATH+3) /* maximum size of output buffer for
				    _splitpath2() */

extern char **__near environ;   /*  pointer to environment table        */



#define errno (*__get_errno_ptr())
extern volatile int errno;              /*  ANSI error number               */
extern  int             _doserrno;      /* DOS system error code value */
extern  unsigned __near _psp;           /* Program Segment Prefix */
#define DOS_MODE 0                      /* Real Address Mode */
#define OS2_MODE 1                      /* Protected Address Mode */
extern  unsigned char __near _osmode;   /* DOS_MODE or OS2_MODE */
extern  int     __near  _fmode;         /* default file translation mode */
extern char *           sys_errlist[];  /* strerror error message table */
extern int      __near  sys_nerr;       /* # of entries on sys_errlist array */
extern unsigned __near	__minreal;	/* DOS4GW var for WLINK MINREAL option*/
extern unsigned long __near __win_alloc_flags; /* Windows allocation flags */
extern unsigned long __near __win_realloc_flags;/* Windows reallocation flags */
extern unsigned char __near _osmajor;   /*  O/S version #                   */
extern unsigned char __near _osminor;   /*  O/S version #                   */
extern unsigned __near      _amblksiz;  /*  mallocs done in multiples of    */

 void __near *__brk(unsigned __new_brk_value);
 void __near *sbrk(int __increment);
 typedef void (*onexit_t)();
 onexit_t onexit(onexit_t __func);
#endif

#pragma pack();
#define _STDLIB_H_INCLUDED
#endif
