	TITLE	SIDT_BLD 06/10/83 PROTECTED MODE INTERRUPT TABLE
;
;	SIDT_BLD Include files
;
;		INCLUDE SYSDATA.INC
;		INCLUDE ACCESS.INC
;
;		INCLUDE SYSDATA.MAC
;		INCLUDE IAPX286.MAC
;
	.XLIST
		INCLUDE SYSDATA.INC
		INCLUDE SYSDATA.MAC
		INCLUDE IAPX286.MAC
	.LIST

INCLUDE SEGMENT.SRC

		ASSUME	CS:CODE
		ASSUME	SS:NOTHING
		ASSUME	DS:NOTHING
		ASSUME	ES:NOTHING

		PUBLIC	SIDT_BLD
SIDT_BLD	PROC	NEAR

;
;	BUILD THE IDT.	THE IDT WILL CONTAIN VECTORS FOR
;	EXCEPTION HANDLERS

	MOV	SI,OFFSET SYS_IDT_OFFSETS  ; MAKE DS:SI POINT TO
	MOV	AX,CS		      ;        INTERRUPT ENTRY POINTS
	MOV	DS,AX		      ;
	MOV	DI,SYS_IDT_LOC	      ; POINT TO SYS_IDT_LOC
	SUB	AX,AX
	MOV	ES,AX		      ;       WHERE THE IDT WILL BE.

	MOV	BX,SYS_ROM_CS	      ; CS IS THE SAME FOR ALL INTERRUPTS
	MOV	DH,TRAP_GATE	      ; ACCESS RIGHTS BYTE FOR THE GATE
	MOV	DL,0		      ; THE WORD COUNT FIELD IS UNUSED

	MOV	CX,32		      ; THERE ARE 32 RESERVED INTERRUPTS

LOW_IDT:			      ; THIS LOOP BUILDS 32 DESCRIPTORS IN THE
				      ;   IDT FOR THE RESERVED INTERRUPTS
	MOVSW			      ; GET A ROUTINE ENTRY POINT
				      ;   AND PUT IT IN THE OFFSET FIELD
	MOV	AX,BX		      ; GET THE SYSTEM CODE SEGMENT SELECTOR
	STOSW			      ;   AND PUT IT IN THE SELECTOR FIELD
	MOV	AX,DX		      ; GET THE INTERRUPT GATE BYTE
	STOSW			      ;   AND PUT IT IN THE ACCESS RIGHTS FIELD
	MOV	AX,0		      ; ZERO OUT
	STOSW			      ;   THE RESERVED POSITIONS
	LOOP	LOW_IDT 	      ;     AND REPEAT AS DIRECTED

	MOV	CX,256-32	      ; 256 TOTAL - 32 DONE = WHATEVER IS LEFT
	MOV	BP,OFFSET FREE_INTS   ; THERE IS A COPY OF AN UNINITIALIZED
				      ;   INTERRUPT DESCRIPTOR AT FREE_INTS

PAGE

HIGH_IDT:

	MOV	SI,BP		      ; DS:SI --> FREE DESCRIPTOR
				      ; (ES:DI LEFT OFF AT INT 32)
	MOVSW			      ; MOVE THE OFFSET OF THE IRET INSTRUCTION
	MOVSW			      ; MOVE THE CS SELECTOR
	MOVSW			      ; MOVE THE ACCESS RIGHTS BYTE
	STOSW			      ; ZERO OUT THE RESERVED WORD
	LOOP	HIGH_IDT	      ; FILL THE REMAINDER OF THE TABLE
;
;
;	INITIALIZE THE ENTRY POINTS FOR POST TEST
;
	MOV	ES:(SYS_IDT_LOC+(032*DESC_LEN).ENTRY_POINT),OFFSET SYS_32

	MOV	ES:(SYS_IDT_LOC+(033*DESC_LEN).ENTRY_POINT),OFFSET SYS_33

	MOV	ES:(SYS_IDT_LOC+(034*DESC_LEN).ENTRY_POINT),OFFSET SYS_34

	MOV	ES:(SYS_IDT_LOC+(035*DESC_LEN).ENTRY_POINT),OFFSET SYS_35

	MOV	ES:(SYS_IDT_LOC+(036*DESC_LEN).ENTRY_POINT),OFFSET SYS_36

	MOV	ES:(SYS_IDT_LOC+(037*DESC_LEN).ENTRY_POINT),OFFSET SYS_37

	MOV	ES:(SYS_IDT_LOC+(038*DESC_LEN).ENTRY_POINT),OFFSET SYS_38

	RET	0

PAGE

IRET_ADDR	LABEL	WORD		; FOR UNINITIALIZED INTERRUPTS

		IRET

;
;	EXTRNS FOR THE FIRST 32 SYSTEM INTERRUPTS
;
	EXTRN	EXC_00:NEAR
	EXTRN	EXC_01:NEAR
	EXTRN	EXC_02:NEAR
	EXTRN	EXC_03:NEAR
	EXTRN	EXC_04:NEAR
	EXTRN	EXC_05:NEAR
	EXTRN	EXC_06:NEAR
	EXTRN	EXC_07:NEAR
	EXTRN	EXC_08:NEAR
	EXTRN	EXC_09:NEAR
	EXTRN	EXC_10:NEAR
	EXTRN	EXC_11:NEAR
	EXTRN	EXC_12:NEAR
	EXTRN	EXC_13:NEAR
	EXTRN	EXC_14:NEAR
	EXTRN	EXC_15:NEAR
	EXTRN	EXC_16:NEAR
	EXTRN	EXC_17:NEAR
	EXTRN	EXC_18:NEAR
	EXTRN	EXC_19:NEAR
	EXTRN	EXC_20:NEAR
	EXTRN	EXC_21:NEAR
	EXTRN	EXC_22:NEAR
	EXTRN	EXC_23:NEAR
	EXTRN	EXC_24:NEAR
	EXTRN	EXC_25:NEAR
	EXTRN	EXC_26:NEAR
	EXTRN	EXC_27:NEAR
	EXTRN	EXC_28:NEAR
	EXTRN	EXC_29:NEAR
	EXTRN	EXC_30:NEAR
	EXTRN	EXC_31:NEAR

	EXTRN	SYS_32:NEAR
	EXTRN	SYS_33:NEAR
	EXTRN	SYS_34:NEAR
	EXTRN	SYS_35:NEAR
	EXTRN	SYS_36:NEAR
	EXTRN	SYS_37:NEAR
	EXTRN	SYS_38:NEAR
PAGE
;
;	Entry points for the first 32 system interrupts
;
SYS_IDT_OFFSETS 	LABEL	WORD
					; INTERRUPTS AS DEFINED

	DW	OFFSET EXC_00		; EXCPT 00 - DIVIDE ERROR
	DW	OFFSET EXC_01		; EXCPT 01 - SINGLE STEP
	DW	OFFSET EXC_02		; EXCPT 02 - NMI, SYS REQ FOR D1
	DW	OFFSET EXC_03		; EXCPT 03 - BREAKPOINT
	DW	OFFSET EXC_04		; EXCPT 04 - INTO DETECT
	DW	OFFSET EXC_05		; EXCPT 05 - BOUND
	DW	OFFSET EXC_06		; EXCPT 06 - INVALID OPCODE
	DW	OFFSET EXC_07		; EXCPT 07 - PROCESSOR EXT NOT AVAIL
	DW	OFFSET EXC_08		; EXCPT 08 - DOUBLE EXCEPTION
	DW	OFFSET EXC_09		; EXCPT 09 - PROCESSOR EXT SEGMENT ERR
	DW	OFFSET EXC_10		; EXCPT 10 - STK PL BAD IN GATE TRANSFER
	DW	OFFSET EXC_11		; EXCPT 11 - SEGMENT NOT PRESENT
	DW	OFFSET EXC_12		; EXCPT 12 - STACK SEGMENT NOT PRESENT
	DW	OFFSET EXC_13		; EXCPT 13 - GENERAL PROTECTION
	DW	OFFSET EXC_14
	DW	OFFSET EXC_15
	DW	OFFSET EXC_16		; EXCPT 16 - PROCESSOR EXTENSION ERROR
	DW	OFFSET EXC_17
	DW	OFFSET EXC_18
	DW	OFFSET EXC_19
	DW	OFFSET EXC_20
	DW	OFFSET EXC_21
	DW	OFFSET EXC_22
	DW	OFFSET EXC_23
	DW	OFFSET EXC_24
	DW	OFFSET EXC_25
	DW	OFFSET EXC_26
	DW	OFFSET EXC_27
	DW	OFFSET EXC_28
	DW	OFFSET EXC_29
	DW	OFFSET EXC_30
	DW	OFFSET EXC_31
PAGE
;
;	FORMAT INTERRUPT DESCRIPTORS (GATES) 32 - 255
;
FREE_INTS	DW	OFFSET IRET_ADDR	; DESTINATION OFFSET
		DW	SYS_ROM_CS		; DESTINATION SEGMENT
		DB	0,INT_GATE		; UNUSED BYTE, ACCESS RIGHTS BYTE
SIDT_BLD	ENDP
CODE		ENDS

	END
