uses crt,dos,maus,neumod,variab,WinDos;

Type  Noten = record
        Notenvalue : word;
        Notentext  : string[3];
        Instnr     : byte;
        Effekt     : byte;
        Operand    : byte;
       end;

      Setup_typ = record
         Sam_Rate : byte;
         IRQ      : byte;
         DMA      : byte;
         Maus     : byte;
         Main     : string;
         Modpfad  : string;
         Samppfad : string;
         Pattpfad : string;
         Trkpfad  : string
       end;


const Rec_aufhoeren : boolean = false;
      setup : Setup_typ =
              (Sam_Rate : 8;
               IRQ      : 5;
               DMA      : 1;
               Maus     : 1;
               Main     : '';
               Modpfad  : '';
               samppfad : '';
               Pattpfad : '';
               Trkpfad  : '');

      Inst_Samp_Freq : byte = 166;
      im_recordinginterrupt : boolean = true;
      Programmende : boolean = false;
      MIDI         : boolean = false;
      song_loaded  : boolean = false;
      steplimit    : word = 6;
      Edit_Oktave  : byte = 0;
      Inst_Akt     : byte = 1;
      Screen_Akt   : byte = 1;
      Edit_Arrang  : integer = 1;
      edit_zeile   : integer = -7;
      highest_track : byte = 0;
      edit_track  : byte    = 1;
      Edit_value  : byte    = 1;
      Pattern_edited : boolean = false;
      help_context : word = 1;
      Fenster_active : byte = 1;

      edoff : array[1..6] of byte = (8,11,12,14,15,16);
      midi_track : array[1..16] of byte =
      (1,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8);

      notenvalues   : array[0..4,1..12] of word =
(
 (1712,1616,1525,1440,1359,1283,1211,1143,
  1078,1018, 961, 907),
 ( 856, 808, 763, 720, 679, 641, 605, 571,
   539, 509, 480, 453),
 ( 428, 404, 381, 360, 340, 321, 303, 286,
   270, 254, 240, 227),
 ( 214, 202, 191, 180, 170, 160, 151, 143,
   135, 127, 120, 113),
 ( 107, 101,  95,  90,  85,  80,  76,  71,
    67,  64,  60,  57)
);
      Notennames : array[1..12]
       of string[2] =
('C-','C#','D-','D#','E-','F-','F#','G-',
 'G#','A-','A#','B-');


Var Akpt : array[1..64,1..8] of Noten;
    lsongname : string;
var actual_Pattern : array[1..64,1..8,1..4] of byte;
    Puffer_Pattern : array[1..64,1..8,1..4] of byte;
    Puffer_Track   : array[1..64,1..4] of byte;
    cpr : char;
    sond : char;
    swapkey : char;
    filenames : array[1..512] of string[12];
    tickcount : byte;
    vorzaehlen : word;
var inp : byte;
    playing_ready : boolean;
    block : pointer;


procedure rahmen(rt: byte;startx,starty,dx,dy : integer);
const frames : array[1..2,1..6] of char =
 (('','','','','',''),
  ('','','','','',''));
var lx,ly : integer;
    s : string;
    helpc : char;
begin;
  { obere Zeile }
  s := frames[rt,1];
  for lx := 1 to dx-2 do s := s + frames[rt,5];
  s := s + frames[rt,2];
  gotoxy(startx,starty);
  write(s);
  { mittleren Zeilen }
  for ly := 1 to dy-2 do begin;
    s := frames[rt,6];
    for lx := 1 to dx-2 do s := s + ' ';
    s := s + frames[rt,6];
    gotoxy(startx,starty+ly);
    write(s);
  end;
  { untere Zeile }
  s := frames[rt,4];
  for lx := 1 to dx-2 do s := s + frames[rt,5];
  s := s + frames[rt,3];
  gotoxy(startx,starty+dy-1);
  write(s);
end;

procedure cursor_Off; assembler;
asm
  xor ax,ax
  mov ah,01h
  mov cx,2020h
  int 10h
end;

procedure cursor_on; assembler;
asm
 mov ah,01h
 mov cx,0407h
 int 10h
end;

procedure norm_cursor; assembler;
asm
  mov ah,01;
  mov cx,0607h
  int 10h
end;

procedure save_screen;
var Screen : array[1..4,1..8000] of byte absolute $b800:0000;
begin;
  MausPfeilAus;
  if Screen_Akt <= 4 then begin;
    inc(Screen_Akt);
    move(screen[1],screen[Screen_Akt],8000);
  end;
  MausPfeilEin;
end;

procedure restore_screen;
var Screen : array[1..4,1..8000] of byte absolute $b800:0000;
begin;
  MausPfeilAus;
  if Screen_Akt >= 2 then begin;
    move(screen[Screen_Akt],screen[1],8000);
    dec(Screen_Akt);
  end;
  MausPfeilEin;
end;

procedure writexy(x,y : integer; s : string);
begin;
  gotoxy(x,y);
  write(s);
end;

procedure locate_cursor;
begin;
  if Fenster_active = 1 then begin;
    if edit_track < 5 then
      gotoxy(edoff[edit_value]+(edit_track-1)*15-3,23)
    else
      gotoxy(edoff[edit_value]+(edit_track-5)*15-3,42);
  end;
  if Fenster_active = 2 then begin;
    gotoxy(62,14+Inst_akt);
  end;
  if Fenster_active = 3 then begin;
    gotoxy(70,48);
  end;
end;

Procedure Fenster(x,y,dx,dy : integer; s : string;rcol,bcol : byte);
var tlaeng : byte;
    deltx,tstartpos : byte;
begin;
  tlaeng := length(s);
  tstartpos := x + ((dx-Tlaeng) SHR 1);
  textcolor(rcol);
  textbackground(bcol);
  rahmen(1,x,y,dx,dy);
  writexy(tstartpos,y,s);
  locate_cursor;
end;


Procedure warnung(s1,s2,s3,s4,s5 : string);
begin;
  save_screen;
  Fenster(24,10,32,10,' Warnung ! ',4,7);
  textcolor(black);
  writexy(27,12,s1);
  writexy(27,13,s2);
  writexy(27,14,s3);
  writexy(27,15,s4);
  writexy(27,16,s5);
  writexy(25,18,'weiter mit Maus / Tastendruck');
  repeat until keypressed or (mauskey <> 0);
  while keypressed do readkey;
  while mauskey <> 0 do;
  restore_screen;
end;


procedure lade_setup;
var cf : file;
begin;
 {$I-}
 assign(cf,'vised.cfg');
 reset(cf,1);
 if ioresult <> 0 then begin;
   warnung('  Setup nicht gefunden !',
           '',
           '  Bitte configurieren Sie ',
           '  VISED ber Alt-C !   ',
           '');
 end else begin;
   blockread(cf,setup,sizeof(setup));
   close(cf);

   if setup.irq = 244 then begin;
     force_irq := false;
   end else begin;
     force_irq := true;
     dsp_irq := setup.irq;
   end;

   dma_ch := setup.dma;

   chdir(setup.main);
   if ioresult <> 0 then warnung(
     ' Haupt - Pfad nicht gefunden','',
     '  Bitte configurieren Sie','  VISED ber Alt-C !','');
   chdir(setup.modpfad);
   if ioresult <> 0 then warnung(
     ' Moddatei-Pfad nicht gefunden','',
     '  Bitte configurieren Sie','  VISED ber Alt-C !','');
   chdir(setup.samppfad);
   if ioresult <> 0 then warnung(
     ' Sampel-Pfad nicht gefunden','',
     '  Bitte configurieren Sie','  VISED ber Alt-C !','');
   chdir(setup.Pattpfad);
   if ioresult <> 0 then warnung(
     ' Pattern-Pfad nicht gefunden','',
     '  Bitte configurieren Sie','  VISED ber Alt-C !','');
   chdir(setup.Trkpfad);
   if ioresult <> 0 then warnung(
     ' Track - Pfad nicht gefunden','',
     '  Bitte configurieren Sie','  VISED ber Alt-C !','');
 end;
 if setup.maus = 1 then begin; { Microsoft }
   Mausgrenze(0,0,635,200);
   Maustyp := 1;
 end else begin;  { Logitech }
   Mausgrenze(0,0,635,395);
   Maustyp := 2;
 end;
end;

procedure initialisiere_Variablen;
begin;
  XMS := false;
  fillchar(AkPt,64*8*9,0);
  chdir(setup.main);
  Lade_Moddatei('vised.dat',AUTO,AUTO,Setup.Sam_Rate);
  pat_anz := 1;
  for i := 0 to 63 do begin;
    getmem(rm[i],2048);
    fillchar(rm[i]^,2048,0);
  end;
  fillchar(actual_Pattern,2048,0);
  locate_cursor;
  force_mono := false;
end;

procedure write_scroll;
begin;
 write(' ');
 textcolor(white);
 textbackground(4);
 write('< >');
 textcolor(black);
 textbackground(7);
 locate_cursor;
end;

procedure reset_Noten;
begin;
  Note1 := 0;
  Note2 := 0;
  Note3 := 0;
  Note4 := 0;
  Note5 := 0;
  Note6 := 0;
  Note7 := 0;
  Note8 := 0;
end;

procedure save_Inst(nr : byte); forward;

procedure delete_in_pattern(start : byte);
var li : integer;
    help : array[1..4] of byte;
begin;
  for li := start to 63 do begin;
    help[1] := actual_Pattern[li+1,edit_track,1];
    help[2] := actual_Pattern[li+1,edit_track,2];
    help[3] := actual_Pattern[li+1,edit_track,3];
    help[4] := actual_Pattern[li+1,edit_track,4];
    actual_Pattern[li,edit_track,1] := help[1];
    actual_Pattern[li,edit_track,2] := help[2];
    actual_Pattern[li,edit_track,3] := help[3];
    actual_Pattern[li,edit_track,4] := help[4];
  end;
  actual_Pattern[64,edit_track,1] := 0;
  actual_Pattern[64,edit_track,2] := 0;
  actual_Pattern[64,edit_track,3] := 0;
  actual_Pattern[64,edit_track,4] := 0;
end;

procedure insert_in_pattern(start : byte);
var li : integer;
    help : array[1..4] of byte;
begin;
  for li := 63 downto start do begin;
    help[1] := actual_Pattern[li,edit_track,1];
    help[2] := actual_Pattern[li,edit_track,2];
    help[3] := actual_Pattern[li,edit_track,3];
     help[4] := actual_Pattern[li,edit_track,4];
    actual_Pattern[li+1,edit_track,1] := help[1];
    actual_Pattern[li+1,edit_track,2] := help[2];
    actual_Pattern[li+1,edit_track,3] := help[3];
    actual_Pattern[li+1,edit_track,4] := help[4];
  end;
  actual_Pattern[start,edit_track,1] := 0;
  actual_Pattern[start,edit_track,2] := 0;
  actual_Pattern[start,edit_track,3] := 0;
  actual_Pattern[start,edit_track,4] := 0;
end;

procedure sort_filenames(start,ende : integer);
{
 Hier sollte fr grere Verzeichnise Quick-Sort eingebaut werden !
}
var hilfe : string;
    l1,l2 : integer;
begin;
  for l1 := start to ende-1 do begin;
    for l2 := start to ende-1 do begin;
      if filenames[l2] > filenames[l2+1] then begin;
        hilfe := filenames[l2];
        filenames[l2] := filenames[l2+1];
        filenames[l2+1] := hilfe;
      end;
    end;
  end;
end;

function select_datei(dir : string;mask : pchar;mtext,comment: string) : string;
const  zeile : byte = 1;
  spalte : byte = 0;
var
  DirInfo: TSearchRec;
  count : integer;
  Nullpos : byte;
var li,lj : integer;
    inp : char;
    retval : string;
    kasten_gefunden : boolean;
    select : byte;
    changed : boolean;
    Start_fndisp : word;
    End_fndisp : word;
begin
  Start_fndisp := 0;

  chdir(setup.main);
  chdir(dir);
  {$I+}
  for li := 1 to 512 do filenames[li] := ' - - -';
  count := 1;
  FindFirst(mask, faArchive, DirInfo);
  while DosError = 0 do
  begin
    filenames[count] := (DirInfo.Name);
    Nullpos := pos(#0,filenames[count]);
    if Nullpos <> 0 then
      filenames[count] := copy(filenames[count],0,Nullpos-1);
    inc(count);
    FindNext(DirInfo);
  end;
  {$I-}

  sort_filenames(1,count-1);

  save_screen;
  Fenster(5,4,72,16,comment,black,7);
  textcolor(1);
  writexy(21,5,'         Bitte Datei auswhlen');
  textcolor(black);
  while mauskey <> 0 do;
  inp := #255;
  changed := true;
  repeat
    textcolor(black);
    if changed then begin;
      changed := false;
      for lj := 0 to 4 do begin;
        for li := 1 to 12 do begin;
          writexy(7+lj*14,5+li,'            ');
          writexy(7+lj*14,5+li,filenames[lj*12+li+Start_fndisp]);
        end;
      end;
      textcolor(14);
      writexy(7+Spalte*14,5+Zeile,filenames[Spalte*12+Zeile+Start_fndisp]);
    end;
    if keypressed then inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      32,
      13: begin;
            inp := #13;
            changed := true;
            if (pos('- - -',filenames[Spalte*12+Zeile+Start_fndisp]) = 0) then
              retval := filenames[Spalte*12+Zeile+Start_fndisp]
            else
              retval := 'xxxx';
          end;
      27: begin;
            inp := #27;
            changed := true;
            retval := 'xxxx';
          end;
      71: begin; { Pos 1 }
            inp := #255;
            Zeile  := 1;
            Spalte := 0;
            changed := true;
          end;
      72: begin; { Pfeil up }
            inp := #255;
            changed := true;
            if not ((Zeile = 1) and (Spalte = 0)) then
              dec(Zeile);
            if Zeile = 0 then begin;
              dec(Spalte);
              Zeile := 12;
            end;
          end;
      73: begin; { Page UP }
            if Start_fndisp >= 12 then
              dec(Start_fndisp,12)
            else begin;
              Start_fndisp := 0;
              Zeile := 1;
            end;
            inp := #255;
            changed := true;
          end;
      81: begin; { Page Down }
            if ((Spalte+1)*12+Start_fndisp < count) and
            (Start_fndisp < 500) then
              inc(Start_fndisp,12)
            else
              Start_fndisp := count-11;
            inp := #255;
            changed := true;
          end;
      75: begin; { Pfeil links }
            inp := #255;
            changed := true;
            if Spalte = 0 then begin;
              if Start_fndisp >= 12 then dec(Start_fndisp,12);
            end else begin;
              if Spalte > 0 then dec(Spalte);
            end;
          end;
      77: begin; { Pfeil rechts }
            inp := #255;
            changed := true;
            if Spalte = 4 then begin;
              if ((Spalte+1)*12+Start_fndisp < count) and
              (Start_fndisp < 500) then inc(Start_fndisp,12);
            end else begin;
            if (Spalte < 4) and
              (Zeile+(Spalte+1)*12+Start_fndisp < count) then
                inc(Spalte);
            end;
          end;
      79: begin; { End }
            inp := #255;
            changed := true;
            Spalte := (count-Start_fndisp-12) div 12;
            Zeile := (count-Start_fndisp) - Spalte*12 -1;
          end;
      80: begin; { Pfeil down }
            inp := #255;
            changed := true;
            if ((Zeile = 12) and (Spalte = 4)) then begin;
              if (Start_fndisp+Zeile+Spalte*12 < count-1) then begin;
                inc(Start_fndisp,1);
              end;
            end else begin;
              if (Start_fndisp+Zeile+Spalte*12 < count-1) then
                inc(Zeile);
             end;
            if Zeile > 12 then begin;
              inc(Spalte);
              Zeile := 1;
            end;
          end;
      82 : begin;
            changed := true;
             save_screen;
             textcolor(black);
             rahmen(2,16,9,45,5);
             writexy(20,10,' Dateinamen eingeben ('+mtext+')');
             writexy(20,12,'Name: ');
             readln(retval);
             if retval = '' then retval := 'xxxx';
             restore_screen;
           end;
     end;
  until (inp = #13) or (inp = #27) or (inp = #32)
     or (inp = #82) or (mauskey <> 0);
  if mauskey <> 0 then begin;
    kasten_gefunden := false;

    while not kasten_gefunden do begin;
    select := 0;
    lj := 0;
    while (lj <= 4) and not kasten_gefunden do begin;
      li := 1;
      while (li <= 12) and not kasten_gefunden do begin;
        inc(select);
        if MausIn(7+lj*14,5+li,6+(lj+1)*14,5+li) then
          kasten_gefunden := true;
        inc(li);
      end;
      inc(lj);
    end;
    end;
    if kasten_gefunden and (pos('- - -',filenames[select+Start_fndisp]) = 0)
      then retval := filenames[select+Start_fndisp]
    else retval := 'xxxx';
  end;
  restore_screen;
  textcolor(black);
  select_datei := retval;
  locate_cursor;
end;

procedure Play_the_Mod(s : string);
{
 Ld eine .MOD-Datei in den Speicher, Ausgabe kann ber periodisch_on
 gestartet werden
}
var error : integer;
begin;
 error := lade_moddatei(s,AUTO,AUTO,Setup.Sam_Rate);
 if error <> 0 then begin;
   textmode(3);
   writeln('Fehler beim Laden der  MOD-Datei ! ');
   if error = -2 then writeln('Initialisierung fehlerhaft !');
   if error = -1 then writeln('Datei nicht gefunden !');
    halt(0);
 end;
 mli := 0;
 mlj := 0;
end;

function Notenname(val : word) : string;
var Oktave,Note : byte;
    gefunden : boolean;
    hs : string;
begin;
  hs := '---';
  gefunden := false;
  Oktave := 0;
  Note := 1;
  while (Oktave < 5) and not gefunden
  do begin;
    if val > Notenvalues[Oktave,Note] then begin;
      str(Oktave,hs);
      if Note = 1 then Note := 13;
      hs := Notennames[Note-1]+hs+'';
      gefunden := true;
    end;
    inc(Note);
    if Note > 12 then begin;
      inc(Oktave);
      Note := 1;
    end;
  end;
  Notenname := hs;
end;

procedure Schreibe_Pattern(start : integer);
{
 Gibt das momentane Pattern ab der in start bergebenen Position auf dem
 Bildschirm aus
}
const hexcar : array[0..15] of char =
 ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
var lz,ls : integer;
    azeile : byte;
    n,s,z,ef,op1,op2 : string;
    tonhoehe : word;
    instrum : byte;
    effekt : byte;
    opperanden : word;
    li : integer;
begin;
  cursor_off;
  azeile := 0;
  for lz := start to start+15 do begin;
    inc(azeile);
    if (lz > 0) and (lz <= 64) then begin;
      if lz = start+8 then begin;
        textbackground(14);
      end else begin;
        textbackground(7);
      end;
      for ls := 1 to 4 do begin;
        gotoxy(2+(ls-1)*15,14+azeile);
        tonhoehe := (actual_Pattern[lz,ls,1] and $0F) * 256 + actual_Pattern[lz,ls,2];
        instrum := (actual_Pattern[lz,ls,1] and $F0) + ((actual_Pattern[lz,ls,3] and $F0) shr 4);
        effekt := actual_Pattern[lz,ls,3] and $0F;
        opperanden := actual_Pattern[lz,ls,4];
        if tonhoehe = 0 then n := '---' else n := Notenname(tonhoehe);
        str(instrum:2,s);
        str(lz-1:2,z);
        ef := hexcar[effekt];
        op1 := hexcar[opperanden shr 4];
        op2 := hexcar[opperanden AND $0F];
        write(z+' '+n+s+' '+ef+op1+op2);
      end;
      for ls := 5 to 8 do begin;
        gotoxy(2+(ls-5)*15,33+azeile);
        tonhoehe := (actual_Pattern[lz,ls,1] and $0F) * 256 + actual_Pattern[lz,ls,2];
        instrum := (actual_Pattern[lz,ls,1] and $F0) + ((actual_Pattern[lz,ls,3] and $F0) shr 4);
        effekt := actual_Pattern[lz,ls,3] and $0F;
        opperanden := actual_Pattern[lz,ls,4];
        if tonhoehe = 0 then n := '---' else n := Notenname(tonhoehe);
        str(instrum:2,s);
        str(lz-1:2,z);
        ef := hexcar[effekt];
        op1 := hexcar[opperanden shr 4];
        op2 := hexcar[opperanden AND $0F];
        write(z+' '+n+s+' '+ef+op1+op2);
      end;
    end else begin;
      if lz = start+8 then begin;
        textbackground(14);
      end else begin;
        textbackground(7);
      end;
      for ls := 1 to 4 do begin;
        gotoxy(2+(ls-1)*15,14+azeile);
          write('            ');
    end;
      for ls := 5 to 8 do begin;
        gotoxy(2+(ls-5)*15,33+azeile);
        write('            ');
      end;
    end;
  end;
  cursor_on;
  locate_cursor;
end;

procedure write_Arrangement(start : integer);
{
 Gibt das Arrangement ab der in start bergebenen Position
 auf dem Bildschirm aus
}
var zeilen : byte;
begin;
  if start > liedlaenge then liedlaenge := start;
  textcolor(black);
  dec(start,2);
  zeilen := 0;
  while (start <= 130) and (zeilen < 5)
  do begin;
    if zeilen = 2 then
      textbackground(14)
    else
      textbackground(7);
    if (start > 0) and (start <= 128)
    then begin;
      if zeilen = 2 then writexy(62+zeilen*3,48,'   ');
      gotoxy(62+zeilen*3,47);
      write(start:3);
      gotoxy(62+zeilen*3,49);
      write(lied[start]:3);
    end else begin;
      if zeilen = 2 then writexy(62+zeilen*3,48,'   ');
      gotoxy(62+zeilen*3,47);
      write('   ');
      gotoxy(62+zeilen*3,49);
      write('   ');
    end;
    inc(start);
    inc(zeilen);
  end;
  dec(start,3);
  locate_cursor;
end;

procedure Zeichne_Desktop;
var helps : string;
begin;
  cursor_off;
  TextMode(Co80+Font8x8);
  textbackground(black);
  textcolor(white);
  clrscr;
  Textcolor(11);
  writexy(1,1,'VISION FACTORY MOD-Editor 2.0   (c)1993 by DATA BECKER  Autor: Boris Bertelsons');
  Fenster(01,03,79,10,'',black,7);
  writexy(3,4,'Volume    : '); write(outvolume:2); Write_Scroll;
  writexy(3,6,'Stimmen   : '); write(Stimmen:2); Write_Scroll;
  writexy(3,8,'Midi Speed: '); write(Steplimit:2); Write_Scroll;
  writexy(3,10,'Oktave    : '); write(Edit_Oktave:2); Write_Scroll;

  writexy(25,4,'Songname   : '); write(Songname);
  writexy(25,6,'Gre      : '); write(Sam_l[Inst_akt]:5);
  writexy(25,7,'Loop Start : '); write(Loop_s[Inst_akt]:5); Write_Scroll;
  writexy(25,8,'Loop Lnge : '); write(Loop_l[Inst_akt]:5); Write_Scroll;
  writexy(25,9,'Lautstrke : '); write(Inst_vol[Inst_akt]:5); Write_Scroll;
  writexy(25,10,'Sampelname : '); write(Instnamen[Inst_akt]);

  Fenster(01,14,14,18,' Stimme 1 ',black,7);
  Fenster(16,14,14,18,' Stimme 2 ',black,7);
  Fenster(31,14,14,18,' Stimme 3 ',black,7);
  Fenster(46,14,14,18,' Stimme 4 ',black,7);
  Fenster( 1,33,14,18,' Stimme 5 ',black,7);
  Fenster(16,33,14,18,' Stimme 6 ',black,7);
  Fenster(31,33,14,18,' Stimme 7 ',black,7);
  Fenster(46,33,14,18,' Stimme 8 ',black,7);
  Fenster(61,14,19,37,' Instrumente ',black,7);
  writexy(61,46,' Arrangement Ĵ');
  for i := 1 to 31 do begin;
    gotoxy(62,14+i);
    write(i:2,'. ');
    helps := copy(instnamen[i],1,16);
  end;

  textbackground(4);
  textcolor(white);
  writexy(60,4,'<   .MOD Laden   >');
  writexy(60,5,'< .MOD Speichern >');
  writexy(60,6,'<  Sampel Laden  >');
  writexy(60,7,'<Sampel Speichern>');
  writexy(60,8,'<  Pattern Laden >');
  writexy(60,9,'<Patten Speichern>');
  writexy(60,10,'<  Track Laden   >');
  writexy(60,11,'<Track Speichern >');

  writexy(50,5,'< Help >');
  writexy(50,6,'< Copy >');
  writexy(50,7,'< Midi >');
  writexy(50,8,'< Play >');
  writexy(50,9,'< Ende >');

  writexy(62,48,'<');
  writexy(78,48,'>');

  textbackground(7);
  textcolor(black);

  write_arrangement(edit_arrang);

  MausPfeilEin;
  Schreibe_Pattern(edit_zeile);
  Cursor_on;
  locate_cursor;
end;

function which_kasten : word;
{
 Maus-Handling Funktion. Sie liefert die Nummer des Bereiches, in dem
 sich die Maus beim Klick befunden hat.
}
const Kdefined : word = 117;
      Borders : array[1..117,1..4] of integer =
                (
                 (49,05,57,05),       { 01 Hilfe                          }
                 (49,09,57,09),       { 02 Ende                           }
                 (00,00,00,00),       { - - -                             }
                 (16,06,16,06),       { 04 Dec. Stimmen                   }
                 (18,06,18,06),       { 05 Inc. Stimmen                   }
                 (16,08,16,08),       { 06 Dec. Midi-Speed                }
                 (18,08,18,08),       { 07 Inc. Midi-Speed                }
                 (16,10,16,10),       { 08 Dec. Octave                    }
                 (18,10,18,10),       { 09 Inc. Oktave                    }
                 (60,04,77,04),       { 10 Mod laden                      }
                 (60,05,77,05),       { 11 Mod speichern                  }
                 (60,06,77,06),       { 12 Sampel laden                   }
                 (60,07,77,07),       { 13 Sampel speichern               }
                 (60,08,77,08),       { 14 Pattern laden                  }
                 (60,09,77,09),       { 15 Pattern speichern              }
                 (60,10,77,10),       { 16 Track laden                    }
                 (60,11,77,11),       { 17 Track speichern                }
                 (25,04,58,04),       { 18 Songname                       }

                 (23,07,41,07),       { 19 Loop Start direkt eingeben     }
                 (42,07,42,07),       { 20 Dec. Loop-Start                }
                 (44,07,44,07),       { 21 Inc. Loop-Start                }

                 (23,08,41,08),       { 22 Loop Lnge direkt              }
                 (42,08,42,08),       { 23 Dec. Loop Lnge                }
                 (44,08,44,08),       { 24 Inc. Loop Lnge                }

                 (23,09,41,09),       { 25 Volume direkt                  }
                 (42,09,42,09),       { 26 Dec. Volume                    }
                 (44,09,44,09),       { 27 Inc. Volume                    }

                 (23,10,59,10),       { 28 Sampel-Name                    }

                 (03,15,05,31),       { 29 Note Stimme 1                  }
                 (06,15,06,31),       { 30 Instrument Stimme 1            }
                 (08,15,09,31),       { 31 Effekt Stimme 1                }
                 (10,15,10,31),       { 32 Operand Stimme 1               }

                 (18,15,20,31),       { 33 Note Stimme 2                  }
                 (21,15,21,31),       { 34 Instrument Stimme 2            }
                 (23,15,24,31),       { 35 Effekt Stimme 2                }
                 (25,15,25,31),       { 36 Operand Stimme 2               }

                 (33,15,35,31),       { 37 Note Stimme 3                  }
                 (36,15,36,31),       { 38 Instrument Stimme 3            }
                 (38,15,39,31),       { 39 Effekt Stimme 3                }
                 (40,15,40,31),       { 40 Operand Stimme 3               }

                 (48,15,50,31),       { 41 Note Stimme 4                  }
                 (51,15,51,31),       { 42 Instrument Stimme 4            }
                 (53,15,54,31),       { 43 Effekt Stimme 4                }
                 (55,15,55,31),       { 44 Operand Stimme 4               }

                 (03,34,05,49),       { 45 Note Stimme 5                  }
                 (06,34,06,49),       { 46 Instrument Stimme 5            }
                 (08,34,09,49),       { 47 Effekt Stimme 5                }
                 (10,34,10,49),       { 48 Operand Stimme 5               }

                 (18,34,20,49),       { 49 Note Stimme 6                  }
                 (21,34,21,49),       { 50 Instrument Stimme 6            }
                 (23,34,24,49),       { 51 Effekt Stimme 6                }
                 (25,34,25,49),       { 52 Operand Stimme 6               }

                 (33,34,35,49),       { 53 Note Stimme 7                  }
                 (36,34,36,49),       { 54 Instrument Stimme 7            }
                 (38,34,39,49),       { 55 Effekt Stimme 7                }
                 (40,34,40,49),       { 56 Operand Stimme 7               }

                 (48,34,50,49),       { 57 Note Stimme 8                  }
                 (51,34,51,49),       { 58 Instrument Stimme 8            }
                 (53,34,54,49),       { 59 Effekt Stimme 8                }
                 (55,34,55,49),       { 60 Operand Stimme 8               }

                 (62,15,79,15),       { 61 Instrument Nr. 01              }
                 (62,16,79,16),       { 62 Instrument Nr. 02              }
                 (62,17,79,17),       { 63 Instrument Nr. 03              }
                 (62,18,79,18),       { 64 Instrument Nr. 04              }
                 (62,19,79,19),       { 65 Instrument Nr. 05              }
                 (62,20,79,20),       { 66 Instrument Nr. 06              }
                 (62,21,79,21),       { 67 Instrument Nr. 07              }
                 (62,22,79,22),       { 68 Instrument Nr. 08              }
                 (62,23,79,23),       { 69 Instrument Nr. 09              }
                 (62,24,79,24),       { 70 Instrument Nr. 10              }
                 (62,25,79,25),       { 71 Instrument Nr. 11              }
                 (62,26,79,26),       { 72 Instrument Nr. 12              }
                 (62,27,79,27),       { 73 Instrument Nr. 13              }
                 (62,28,79,28),       { 74 Instrument Nr. 14              }
                 (62,29,79,29),       { 75 Instrument Nr. 15              }
                 (62,30,79,30),       { 76 Instrument Nr. 16              }
                 (62,31,79,31),       { 77 Instrument Nr. 17              }
                 (62,32,79,32),       { 78 Instrument Nr. 18              }
                 (62,33,79,33),       { 79 Instrument Nr. 19              }
                 (62,34,79,34),       { 80 Instrument Nr. 20              }
                 (62,35,79,35),       { 81 Instrument Nr. 21              }
                 (62,36,79,36),       { 82 Instrument Nr. 22              }
                 (62,37,79,37),       { 83 Instrument Nr. 23              }
                 (62,38,79,38),       { 84 Instrument Nr. 24              }
                 (62,39,79,39),       { 85 Instrument Nr. 25              }
                 (62,40,79,40),       { 86 Instrument Nr. 26              }
                 (62,41,79,41),       { 87 Instrument Nr. 27              }
                 (62,42,79,42),       { 88 Instrument Nr. 28              }
                 (62,43,79,43),       { 89 Instrument Nr. 29              }
                 (62,44,79,44),       { 90 Instrument Nr. 30              }
                 (60,45,79,45),       { 91 Instrument Nr. 31              }

                 (49,06,57,06),       { 92 Copy                           }
                 (49,07,57,07),       { 93 Midi                           }
                 (49,08,57,08),       { 94 Play                           }
                 (60,48,60,48),       { 95 Dec. Arrangement               }
                 (76,48,76,48),       { 96 Inc. Arrangement               }
                 (66,47,68,49),       { 97 Edit Arrangement               }
                 (00,00,00,00),       { 98 Play Instrument                }
                 (03,04,15,04),       { 99 Ausgabe Volume direct          }

                 (07,15,07,31),       {100 Instrument Stimme 1 Einer      }
                 (22,15,22,31),       {101 Instrument Stimme 2   "        }
                 (37,15,37,31),       {102 Instrument Stimme 3   "        }
                 (52,15,52,31),       {103 Instrument Stimme 4   "        }
                 (07,34,07,49),       {104 Instrument Stimme 5   "        }
                 (22,34,22,49),       {105 Instrument Stimme 6   "        }
                 (37,34,37,49),       {106 Instrument Stimme 7   "        }
                 (52,34,52,49),       {107 Instrument Stimme 8   "        }
                 (11,15,11,31),       {108 Operand Stimme 1      "        }
                 (26,15,26,31),       {109 Operand Stimme 2      "        }
                 (41,15,41,31),       {110 Operand Stimme 3      "        }
                 (56,15,56,31),       {111 Operand Stimme 4      "        }
                 (11,34,11,49),       {112 Operand Stimme 5      "        }
                 (26,34,26,49),       {113 Operand Stimme 6      "        }
                 (41,34,41,49),       {114 Operand Stimme 7      "        }
                 (56,34,56,49),       {115 Operand Stimme 8      "        }

                 (16,04,16,04),       {116 Dec. Volume                    }
                 (18,04,18,04)        {117 Inc. Volume                    }
                );
var pruefidx : word;
    gefunden : boolean;
begin;
  pruefidx := 0;
  gefunden := false;
  while (pruefidx < Kdefined) and not gefunden do begin
    inc(pruefidx);
    if MausIn(Borders[Pruefidx,1],Borders[Pruefidx,2],
              Borders[Pruefidx,3],Borders[Pruefidx,4]) then begin
      gefunden := true;
    end;
  end;
  if gefunden then which_kasten := pruefidx else which_kasten := 65000;
end;

procedure Instrument_in_Pattern(zeile,track : byte; Wert : byte);
{
 Fgt ein Instrument in das Patern ein
}
var hbyte,lobyte : byte;
begin;
  if Wert <> 255 then begin;
    hbyte  := Wert AND $F0;
    lobyte := Wert AND $0F;
    lobyte := lobyte shl 4;
    actual_Pattern[zeile,track,1] := actual_Pattern[zeile,track,1] AND $0F;
    actual_Pattern[zeile,track,1] := actual_Pattern[zeile,track,1] + Hbyte;
    actual_Pattern[zeile,track,3] := actual_Pattern[zeile,track,3] AND $0F;
    actual_Pattern[zeile,track,3] := actual_Pattern[zeile,track,3] + Lobyte;
  end;
end;

procedure Instrument_aus_Pattern(zeile,track : byte; var Wert : byte);
var hbyte,lobyte : byte;
begin;
  Wert := actual_Pattern[zeile,track,1] AND $F0 +
         (actual_Pattern[zeile,track,3] AND $F0) SHR 4;
end;

procedure Tonhoehe_in_Pattern(zeile,track : byte;Wert : word);
var hibits,lobits : byte;
begin;
  if Wert <> 9999 then begin;
    Hibits := hi(Wert);
    lobits := lo(Wert);
    Hibits := Hibits AND $0F;
    actual_Pattern[zeile,track,1] := actual_Pattern[zeile,track,1] AND $F0;
    actual_Pattern[zeile,track,1] := actual_Pattern[zeile,track,1] + Hibits;
    actual_Pattern[zeile,track,2] := lobits;
  end;
end;

function Note_choice : word;
{
 Diese Funktion wird ber SPACE im Noten-Auswahlbereich aufgerufen
}
const texte : array[0..4,1..12]
of string[30] =
(('C 0','C#0','D 0','D#0','E 0','F 0',
 'F#0','G 0','G#0','A 0','A#0','B 0'),
 ('C 1','C#1','D 1','D#1','E 1','F 1',
 'F#1','G 1','G#1','A 1','A#1','B 1'),
 ('C 2','C#2','D 2','D#2','E 2','F 2',
 'F#2','G 2','G#2','A 2','A#2','B 2'),
 ('C 3','C#3','D 3','D#3','E 3','F 3',
 'F#3','G 3','G#3','A 3','A#0','B 3'),
 ('C 4','C#4','D 4','D#4','E 4','F 4',
 'F#4','G 4','G#4','A 4','A#4','   '));
  Zeile  : byte = 1;
  Spalte : byte = 2;
var li,lj : integer;
    inp : char;
    retval : word;
begin;
  save_screen;
  rahmen(2,25,4,26,16);
  writexy(26,5,'  Bitte Note auswhlen');
  repeat
    textcolor(black);
    for lj := 0 to 4 do begin;
      for li := 1 to 12 do begin;
        writexy(26+lj*5,6+li,texte[lj,li]);
      end;
    end;
    textcolor(14);
    writexy(26+Spalte*5,6+Zeile,
    texte[Spalte,Zeile]);
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      32,
      13: begin; { Enter }
            retval := Notenvalues[Spalte,Zeile];
          end;
      27: begin; { Abbruch }
            retval := 9999;
          end;
      71: begin; { Pos 1 }
            Zeile  := 1;
            Spalte := 0;
          end;
      72: begin; { Pfeil up }
            if not ((Zeile = 1) and
            (Spalte = 0)) then  dec(Zeile);
            if Zeile = 0 then begin;
              dec(Spalte);
              Zeile := 12;
            end;
          end;
      75: begin; { Pfeil links }
            if Spalte > 0 then dec(Spalte);
          end;
      77: begin; { Pfeil rechts }
            if Spalte < 4 then inc(Spalte);
          end;
      79: begin; { End }
            Zeile := 12;
            Spalte := 4;
          end;
      80: begin; { Pfeil down }
            if not ((Zeile = 12) and (Spalte = 4)) then inc(Zeile);
            if Zeile > 12 then begin;
              inc(Spalte);
              Zeile := 1;
            end;
          end;
     end;
  until (inp = #13) or (inp = #27) or (inp = #32);
  restore_screen;
  textcolor(black);
  Note_choice := retval;
end;

procedure Note_edit;
const tonleiter : string = 'q2w3er5t6zu8i9o0p';
var notenpos : byte;
    hilfe : word;
begin;
  Pattern_edited := true;
  if cpr = #255 then begin; { Aufruf durch Mauskey }
    while not keypressed and (mauskey = 0) do; { Auf Eingabe Warten }
    if not keypressed then { Maus woanders hin ... }
    cpr := #254;
  end;

  if cpr = #255 then cpr := readkey;
  notenpos := pos(cpr,tonleiter);
  if notenpos <> 0 then begin;
    if (notenpos > 12) then begin;
      if edit_oktave < 4 then begin;
        Tonhoehe_in_pattern(edit_zeile+8,edit_track,
          notenvalues[edit_Oktave+1,notenpos-12]);
          Instrument_in_Pattern(edit_zeile+8,edit_track,inst_akt);
        if edit_zeile < 56 then inc(edit_zeile);
        schreibe_Pattern(edit_zeile);
      end;
    end else begin;
      Tonhoehe_in_pattern(edit_zeile+8,edit_track,
        notenvalues[edit_Oktave,notenpos]);
      Instrument_in_Pattern(edit_zeile+8,edit_track,inst_akt);
      if edit_zeile < 56 then inc(edit_zeile);
      schreibe_Pattern(edit_zeile);
    end;
  end else begin;
    if cpr = #32 then begin;
      hilfe := note_choice;
      if hilfe > 57 then begin;
        Tonhoehe_in_pattern(edit_zeile+8,edit_track,hilfe);
        Instrument_in_Pattern(edit_zeile+8,edit_track,inst_akt);
        if edit_zeile < 56 then inc(edit_zeile);
        schreibe_Pattern(edit_zeile);
      end;
    end;
  end;
  locate_cursor;
end;

function lies_string(laenge: integer;vorgabe : string) : string;
var lae,axp,ayp : integer;
    nch,snc : char;
    editstr : string;
    code : integer;
    changed : boolean;
    ende : boolean;
begin;
  while keypressed do;
  changed := true;
  ende := false;
  axp := wherex;
  ayp := wherey;
  editstr := vorgabe;
  nch := #255;
  repeat
    if keypressed then nch := readkey;
    case nch of
     ':','\','!',
     'A'..'Z',
     'a'..'z',
     '0'..'9' : begin;
                  if length(editstr) < laenge then
                    editstr := editstr + nch
                  else
                    editstr[laenge] := nch;
                  nch := #255;
                  changed := true;
                end;
           #8 : begin;
                  editstr := copy(editstr,1,length(editstr)-1);
                  nch := #255;
                  changed := true;
                end;
           #27 : begin;
                   ende := true;
                 end;
           #32,
           #13 : begin;
                   ende := true;
                 end;
    end;
    if changed then begin;
      gotoxy(axp,ayp);
      write(editstr);
      gotoxy(axp+length(editstr),ayp);
      for lae := laenge downto length(editstr) do write(' ');
      gotoxy(axp+length(editstr),ayp);
      changed := false;
    end;
  until ende or (mauskey <> 0);
  if nch <> #27 then begin;
    vorgabe := editstr;
  end;
  lies_string := vorgabe;
end;

function lies_inst_einz(laenge,vorgabe : integer) : integer;
{
 Einer-Stelle des Instruments eingeben
}
var axp,ayp : integer;
    nch,snc : char;
    editstr : string;
    code : integer;
    changed : boolean;
    ende : boolean;
begin;
  changed := true;
  ende := false;
  axp := wherex;
  ayp := wherey;
  if vorgabe > 0 then
    str(vorgabe,editstr)
  else editstr := '';
  nch := cpr;
  repeat
    if keypressed then nch := readkey;
    case nch of
     '0'..'9' : begin;
                  ende := true;
                  if length(editstr) < laenge then
                    editstr := editstr + nch
                  else
                    editstr[laenge] := nch;
                  nch := #255;
                  changed := true;
                end;
           #8 : begin;
                  editstr := copy(editstr,1,length(editstr)-1);
                  nch := #255;
                  changed := true;
                end;
           #27 : begin;
                   ende := true;
                 end;
           #32,
           #13 : begin;
                   ende := true;
                 end;
           #00 : begin;
                   cpr  := #0;
                   sond := #254;
                   ende := true;
                 end;
    end;
    if changed then begin;
      if edit_track < 5 then
        gotoxy(9+(edit_track-1)*15,23)
      else
        gotoxy(9+(edit_track-5)*15,33);
      write(editstr:laenge);
      gotoxy(10+(edit_track-1)*15,23);
      changed := false;
    end;
  until ende or (mauskey <> 0);
  if nch <> #27 then begin;
    if length(editstr) = 0 then
      vorgabe := 0
    else
      val(editstr,vorgabe,code);
  end;
  lies_inst_einz := vorgabe;
end;

function lies_inst_zehn(laenge,vorgabe : integer) : integer;
{
 Zehner-Stelle des Instruments eingeben
}
var axp,ayp : integer;
    nch,snc : char;
    editstr : string;
    code : integer;
    changed : boolean;
    ende : boolean;
begin;
  changed := true;
  ende := false;
  axp := wherex;
  ayp := wherey;
  if vorgabe > 0 then
    str(vorgabe,editstr)
  else editstr := '';
  nch := cpr;
  repeat
    if keypressed then nch := readkey;
    case nch of
     '0'..'9' : begin;
                  ende := true;
                  if length(editstr) < laenge then
                    editstr := editstr + nch
                  else
                    editstr[laenge] := nch;
                  nch := #255;
                  changed := true;
                end;
           #8 : begin;
                  editstr := copy(editstr,1,length(editstr)-1);
                  nch := #255;
                  changed := true;
                end;
           #27 : begin;
                   ende := true;
                 end;
           #32,
           #13 : begin;
                   ende := true;
                 end;
           #00 : begin;
                   cpr  := #0;
                   sond := #254;
                   ende := true;
                 end;
    end;
    if changed then begin;
      if edit_track < 5 then
        gotoxy(8+(edit_track-1)*15,23)
      else
        gotoxy(8+(edit_track-5)*15,33);
      write(editstr:laenge);
      gotoxy(9+(edit_track-1)*15,23);
      changed := false;
    end;
  until ende or (mauskey <> 0);
  if nch <> #27 then begin;
    if length(editstr) = 0 then
      vorgabe := 0
    else
      val(editstr,vorgabe,code);
  end;
  lies_inst_zehn := vorgabe;
end;

procedure Instrument_einz_eing;
Var nummer : byte;
    helpnr : byte;
begin;
  Pattern_edited := true;
  if cpr = #255 then begin; { Aufruf durch Mauskey }
    while not keypressed and (mauskey = 0) do; { Auf Eingabe Warten }
    if (mauskey <> 0) then { Maus woanders hin ... }
      cpr := #254;
  end;
 if cpr <> #254 then begin;
   Instrument_aus_Pattern(edit_zeile+8,edit_track,Nummer);
   Helpnr := nummer - (Nummer DIV 10 * 10);
   Helpnr := lies_inst_einz(1,Helpnr);
   Nummer := (Nummer DIV 10 * 10) + Helpnr;
   Instrument_in_Pattern(edit_zeile+8,edit_track,Nummer);
   schreibe_Pattern(edit_zeile);
   locate_cursor;
 end;
end;

procedure Instrument_zehn_eing;
Var Einer,Zehner,
nummer : byte;
begin;
  Pattern_edited := true;
  if cpr = #255 then begin; { Aufruf durch Mauskey }
    while not keypressed and (mauskey = 0) do; { Auf Eingabe Warten }
    if (mauskey <> 0) then { Maus woanders hin ... }
      cpr := #254;
  end;
 if cpr <> #254 then begin;
   Instrument_aus_Pattern(edit_zeile+8,edit_track,Nummer);
   Einer  := Nummer - (Nummer DIV 10 * 10);
   Zehner := Nummer DIV 10;
   Zehner := lies_inst_zehn(1,Zehner);
   Nummer := (Zehner * 10) + Einer;
   Instrument_in_Pattern(edit_zeile+8,edit_track,Nummer);
   schreibe_Pattern(edit_zeile);
   while keypressed do readkey;
   locate_cursor;
 end;
end;

function lies_op_zehn(laenge,vorgabe : integer) : integer;
const hexstring = '0123456789ABCDEF';
      hexcar : array[0..15] of char =
 ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
var axp,ayp : integer;
    nch,snc : char;
    editstr : string;
    code : integer;
    changed : boolean;
    ende : boolean;
begin;
  changed := true;
  ende := false;
  axp := wherex;
  ayp := wherey;
  if (vorgabe shr 4) > 0 then
    editstr := hexcar[vorgabe shr 4] + hexcar[vorgabe AND $0F]
  else
    if (vorgabe AND $0F) > 0 then
      editstr := hexcar[vorgabe AND $0F]
    else
      editstr := '';
  nch := cpr;
  repeat
    if keypressed then nch := readkey;
    case nch of
     'A'..'F',
     'a'..'f',
     '0'..'9' : begin;
                  ende := true;
                  if length(editstr) < laenge then
                    editstr := editstr + upcase(nch)
                  else
                    editstr[laenge] := upcase(nch);
                  nch := #255;
                  changed := true;
                end;
           #8 : begin;
                  editstr := copy(editstr,1,length(editstr)-1);
                  nch := #255;
                  changed := true;
                end;
           #27 : begin;
                   ende := true;
                 end;
           #32,
           #13 : begin;
                   ende := true;
                 end;
           #00 : begin;
                   cpr  := #0;
                   sond := #254;
                   ende := true;
                 end;
    end;
    if changed then begin;
      if edit_track < 5 then
        gotoxy(12+(edit_track-1)*15,23)
      else
        gotoxy(12+(edit_track-5)*15,33);
      write(editstr:laenge);
      gotoxy(13+(edit_track-1)*15,23);
      changed := false;
    end;
  until ende or (mauskey <> 0);
  if nch <> #27 then begin;
    if length(editstr) = 1 then
      vorgabe := pos(editstr[1],hexstring)-1
    else
      vorgabe := (pos(editstr[1],hexstring)-1)*16+pos(editstr[2],hexstring)-1;
  end;
  lies_op_zehn := vorgabe;
end;

function lies_op_einz(laenge,vorgabe : integer) : integer;
const hexstring = '0123456789ABCDEF';
      hexcar : array[0..15] of char =
 ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
var axp,ayp : integer;
    nch,snc : char;
    editstr : string;
    code : integer;
    changed : boolean;
    ende : boolean;
begin;
  changed := true;
  ende := false;
  axp := wherex;
  ayp := wherey;
  if (vorgabe shr 4) > 0 then
    editstr := hexcar[vorgabe shr 4] + hexcar[vorgabe AND $0F]
  else
    if (vorgabe AND $0F) > 0 then
      editstr := hexcar[vorgabe AND $0F]
    else
      editstr := '';
  nch := cpr;
  repeat
    if keypressed then nch := readkey;
    case nch of
     'A'..'F',
     'a'..'f',
     '0'..'9' : begin;
                  ende := true;
                  if length(editstr) < laenge then
                    editstr := editstr + upcase(nch)
                  else
                    editstr[laenge] := upcase(nch);
                  nch := #255;
                  changed := true;
                end;
           #8 : begin;
                  editstr := copy(editstr,1,length(editstr)-1);
                  nch := #255;
                  changed := true;
                end;
           #27 : begin;
                   ende := true;
                 end;
           #32,
           #13 : begin;
                   ende := true;
                 end;
           #00 : begin;
                   cpr  := #0;
                   sond := #254;
                   ende := true;
                 end;
    end;
    if changed then begin;
      if edit_track < 5 then
        gotoxy(13+(edit_track-1)*15,23)
      else
        gotoxy(13+(edit_track-5)*15,33);
      write(editstr:laenge);
      gotoxy(14+(edit_track-1)*15,23);
      changed := false;
    end;
  until ende or (mauskey <> 0);
  if nch <> #27 then begin;
    if length(editstr) = 1 then
      vorgabe := pos(editstr[1],hexstring)-1
    else
      vorgabe := (pos(editstr[1],hexstring)-1)*16+pos(editstr[2],hexstring)-1;
  end;
  lies_op_einz := vorgabe;
end;

procedure Operanden_in_Pattern(zeile,track,Wert : byte);
begin;
  actual_Pattern[zeile,track,4] := Wert;
end;

procedure Operanden_aus_Pattern(zeile,track : byte;var Wert : byte);
begin;
  Wert := actual_Pattern[zeile,track,4];
end;

function eff_choice  : byte;
{
 Zur Auswahl des Gewnschten Effekts. Kann noch ergnzt werden.
}
const texte : array[1..20] of string[40] =
  (' 0   Arpreggio                   xx',
   ' 1   Portamento Up               xx',
   ' 2   Portamento Down             xx',
   ' 3   Portamento to Note          xx',
   ' 4   Vibrato                     xy',
   ' 5   Portamento + Vol. Sliding   xy',
   ' 6   Vibrato + Vol. Sliding      xy',
   ' 7   Tremolo                     xy',
   ' A   Volume Slide                x0/0x',
   ' B   Position Jump               xx',
   ' C   Set Note Volume             xx',
   ' D   Pattern Break               xx',
   ' E1  Fineslide Up                 x',
   ' E2  Fineslide Down               x',
   ' E6  Pattern Loop                 x',
   ' EA  Fine Volumesliding Up        x',
   ' EB  Fine Volumesliding Down      x',
   ' EC  Note Stop                    x',
   ' F   Song Speed                  xx',
   ' X   Kein Effekt'
  );
  selectvalues : array[1..20] of byte =
  (0,1,2,3,4,5,6,7,10,11,12,13,51,52,56,60,61,62,15,0);
  selected : byte = 1;
var li : integer;
    inp : char;
    retval : byte;
begin;
  save_screen;
  rahmen(2,15,4,42,25);
  writexy(21,5,' Bitte Effekt auswhlen');
  writexy(21,7,'    Effekt              Opperanden');
  repeat
    textcolor(black);
    for li := 1 to 20 do begin;
      writexy(16,7+li,texte[li]);
    end;
    textcolor(14);
    writexy(16,7+selected,
    texte[selected]);
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      13: begin;
            retval := selectvalues[selected];
          end;
      27: begin;
            retval := selectvalues[20];
          end;
      71: begin;
            selected := 1;
          end;
      72: begin;
            if selected > 1 then
              dec(selected);
          end;
      79: begin;
            selected := 20;
          end;
      80: begin;
            if selected < 20 then
              inc(selected);
          end;
     end;
  until (inp = #13) or (inp = #27) or (mauskey <> 0) or (inp = #32);
  restore_screen;
  textcolor(black);
  eff_choice := retval;
end;

function lies_eff(laenge,vorgabe : integer) : integer;
const hexcar : array[0..15] of char =
 ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
      hexstr : string = '0123456789ABCDEF';
var axp,ayp : integer;
    nch,snc : char;
    editstr : string;
    code : integer;
    changed : boolean;
    ende : boolean;
    choice : byte;
    ext_nr : byte;
begin;
  changed := true;
  ende := false;
  axp := wherex;
  ayp := wherey;
  editstr := hexcar[Vorgabe];
  nch := cpr;
  repeat
    if keypressed then nch := readkey;
    case nch of
     'A'..'F',
     'a'..'f',
     '0'..'9' : begin;
                  editstr := upcase(nch);
                  nch := #255;
                  changed := true;
                end;
           #8 : begin;
                  editstr := '0';
                  nch := #255;
                  changed := true;
                end;
           #27 : begin;
                   ende := true;
                 end;
           #13 : begin;
                   ende := true;
                 end;
           #32 : begin;
                   choice := eff_choice;
                   if choice > 40 then begin;
                     Ext_Nr := choice - 50;
                     choice := $0E;
                   end;
                   editstr := hexcar[choice];
                   nch := #255;
                   ende := true;
                   changed := true;
                 end;
           #00 : begin;
                   cpr  := #0;
                   sond := #254;
                   ende := true;
                 end;
    end;
    if changed then begin;
      if edit_track < 5 then
        gotoxy(10+(edit_track-1)*15,23)
      else
        gotoxy(10+(edit_track-5)*15,33);
      write(editstr:laenge);
      gotoxy(11+(edit_track-1)*15,23);
      changed := false;
    end;
  until ende or (mauskey <> 0);
  if nch <> #27 then begin;
    vorgabe := pos(editstr,hexstr)-1;
  end;
  if (vorgabe = 14) then begin;
    Operanden_aus_Pattern(edit_zeile+8,edit_track,choice);
    choice := choice AND $0F;
    Ext_nr := Ext_nr shl 4;
    choice := Ext_nr + choice;
    Operanden_in_Pattern(edit_zeile+8,edit_track,choice);
  end;
  lies_eff := vorgabe;
end;

procedure Effekt_in_Pattern(zeile,track : byte; Wert : byte);
begin;
  Wert := Wert and $0F;
  actual_Pattern[zeile,track,3] := actual_Pattern[zeile,track,3] AND $F0;
  actual_Pattern[zeile,track,3] := actual_Pattern[zeile,track,3] + Wert;
end;

procedure Effekt_aus_Pattern(zeile,track : byte;VAR Wert : byte);
begin;
  Wert := actual_Pattern[zeile,track,3] AND $0F;
end;

procedure Effekt_eing;
Var nummer : byte;
begin;
  Pattern_edited := true;
  if cpr = #255 then begin; { Aufruf durch Mauskey }
    while not keypressed and (mauskey = 0) do; { Auf Eingabe Warten }
    if (mauskey <> 0) then { Maus woanders hin ... }
      cpr := #254;
  end;
 if cpr <> #254 then begin;
   Effekt_aus_Pattern(edit_zeile+8,edit_track,Nummer);
   Nummer := lies_eff(2,Nummer);
   Effekt_in_Pattern(edit_zeile+8,edit_track,Nummer);
   schreibe_Pattern(edit_zeile);
   locate_cursor;
 end;
end;

procedure Operand_zehn_eing;
var nummer : byte;
    Einer,zehner : byte;
begin;
  Pattern_edited := true;
  if cpr = #255 then begin; { Aufruf durch Mauskey }
    while not keypressed and (mauskey = 0) do; { Auf Eingabe Warten }
    if (mauskey <> 0) then { Maus woanders hin ... }
      cpr := #254;
  end;
 if cpr <> #254 then begin;
   Operanden_aus_Pattern(edit_zeile+8,edit_track,Nummer);
   Einer := Nummer - (Nummer div 16 * 16);
   Zehner := Nummer div 16;
   Zehner := lies_op_zehn(1,Zehner);
   Nummer := (Zehner * 16) + Einer;
   Operanden_in_Pattern(edit_zeile+8,edit_track,Nummer);
   schreibe_Pattern(edit_zeile);
   locate_cursor;
 end;
end;

procedure Operand_einz_eing;
var nummer : byte;
    Einer,Zehner : byte;
begin;
  Pattern_edited := true;
  if cpr = #255 then begin; { Aufruf durch Mauskey }
    while not keypressed and (mauskey = 0) do; { Auf Eingabe Warten }
    if mauskey <> 0 then { Maus woanders hin ... }
      cpr := #254;
  end;
 if cpr <> #254 then begin;
   Operanden_aus_Pattern(edit_zeile+8,edit_track,Nummer);
   Einer := Nummer - (Nummer div 16 * 16);
   Zehner := Nummer div 16;
   Einer := lies_op_einz(1,Einer);
   Nummer := (Zehner * 16) + Einer;
   Operanden_in_Pattern(edit_zeile+8,edit_track,Nummer);
   schreibe_Pattern(edit_zeile);
   locate_cursor;
 end;
end;

procedure schreibe_inst(selected : byte);
var li : integer;
    hst : string;
begin;
  cursor_off;
  MausPfeilAus;
  for li := 1 to 31 do begin;
    hst := copy(instnamen[li],1,14);
    while length(hst) < 14 do hst := hst + ' ';
    if li = selected then
      textbackground(14)
    else
      textbackground(7);
    gotoxy(62,14+li);
    write(li:2,'.',hst);
  end;
  textbackground(7);
  MausPfeilEin;
  cursor_on;
end;

procedure write_instinfo;
begin;
  Cursor_off;
  MausPfeilAus;
  writexy(25,4,'Songname   : '); write(Songname);
  writexy(25,6,'Gre      : '); write(Sam_l[Inst_akt]:5);
  writexy(25,7,'Loop Start : '); write(Loop_s[Inst_akt]:5); Write_Scroll;
  writexy(25,8,'Loop Lnge : '); write(Loop_l[Inst_akt]:5); Write_Scroll;
  writexy(25,9,'Lautstrke : '); write(Inst_vol[Inst_akt]:5); Write_Scroll;
  writexy(25,10,'Sampelname : '); write(Instnamen[Inst_akt]);
  MausPfeilEin;
  Cursor_on;
  locate_cursor;
end;

procedure Neues_Instrument(nr : byte; name : string);
var sf : file;
begin;
  if Sam_l[nr] <> 0 then freemem(Samp[nr],Sam_l[nr]);
  assign(sf,name);
  reset(sf,1);
  Sam_l[nr] := filesize(sf);
  inst_vol[nr] := 63;
  loop_s[nr] := 0;
  loop_l[nr] := 0;
   if XMS then begin;
     getmem(Samp[nr],Sam_l[nr]);
     getmem_Xms(nr,(sam_l[nr] DIV 1024)+1);
     blockread(sf,Samp[nr]^,sam_l[nr]);
     Ram_2_Xms(Samp[nr],sam_l[nr],nr);
     freemem(Samp[nr],Sam_l[nr]);
   end else begin;
     getmem(Samp[nr],Sam_l[nr]);
     blockread(sf,Samp[nr]^,sam_l[nr]);
   end;
  close(sf);
  Instnamen[nr] := name;
end;

procedure entferne_Instrument(nr : byte);
var sf : file;
begin;
  freemem(Samp[nr],Sam_l[nr]);
  Sam_l[nr] := 0;
  Loop_s[nr] := 0;
  Loop_l[nr] := 0;
  Inst_vol[nr] := 63;
  Instnamen[nr] := '';
end;

procedure event098; forward;

procedure Lade_Instrument(Nr : byte);
const austexte : array[1..5] of string[30] =
  (
   'Instrument Laden    ',
   'Instrument Speichern',
   'Instrument Entfernen',
   'Instrument Spielen  ',
   'Abbrechen           '
  );
var dname : string;
    ch : char;
    son : char;
    selected : byte;
    ende : boolean;
    changed : boolean;
    li : integer;
begin;
  cursor_off;
  selected := 1;
  ende := false;
  changed := true;
  save_screen;
  rahmen(1,18,18,25,7);
  ch := #255;
  while mauskey <> 0 do;
  repeat
    if keypressed then ch := readkey;
    if changed then begin;
      changed := false;
      textbackground(7);
      for li := 1 to 5 do begin;
        writexy(20,18+li,austexte[li]);
      end;
      textbackground(11);
      writexy(20,18+selected,austexte[selected]);
    end;
    case ch of
      #27 : begin;
              selected := 5;
              ende := true;
            end;
      #32,
      #13 : begin;
              ende := true;
            end;
       #0 : begin;
              sond := readkey;
              case sond of
                #72 : begin;  { Pfeil up }
                        if selected > 1 then dec(selected);
                        changed := true;
                        ch := #255;
                      end;
                #80 : begin;
                        if selected < 5 then inc(selected);
                        changed := true;
                        ch := #255;
                      end;
              end;
            end;
    end;
  until ende or (mauskey <> 0);

  if mauskey <> 0 then begin;  { Exit durch Mausdruck }
    if MausIn(19,19,38,19) then selected := 1;
    if MausIn(19,20,38,20) then selected := 2;
    if MausIn(19,21,38,21) then selected := 3;
    if MausIn(19,22,38,22) then selected := 4;
    if MausIn(19,23,38,23) then selected := 5;
  end;

  if selected = 1 then begin; { Neu laden }
    dname := select_datei(setup.samppfad,'*.*','*.*',' Instrument laden ');
    if dname <> 'xxxx'then neues_Instrument(nr,dname);
  end;

  if selected = 2 then begin;
    Save_Inst(nr);
  end;

  if selected = 3 then begin;
    entferne_Instrument(nr);
  end;

  if selected = 4 then begin;
    event098;
  end;

  restore_screen;
  cursor_on;
  textbackground(7);
  locate_cursor;
end;

procedure Save_Mod(ueberg : string);
var dname : string;
    stringarray : array[1..22] of char;
    chan,li,lj : integer;
    mof : file;
    helpw : word;
    helpb : byte;
    Pattern4 : array[1..64,1..4,1..4]
    of byte;
    Pattern8 : array[1..64,1..8,1..4]
    of byte;
begin;
  move(actual_Pattern,rm[Lied[edit_arrang]]^,2048);
  if ueberg = '' then
  dname := select_datei(setup.modpfad,'*.mod','*.mod',' Speichere .MOD-Datei ')
  else dname := ueberg;
  if dname <> 'xxxx' then begin;
    assign(mof,dname);
    rewrite(mof,1);
    for li := 1 to length(songname) do { Song-Namen schreiben }
      stringarray[li] := songname[li];
    stringarray[li+1] := #0;
    blockwrite(mof,stringarray,20);

    { Instrument - Infos }
    for lj := 1 to 31 do begin;                     { Instrumentname }
      if length(instnamen[lj]) > 0 then begin;
        for li := 1 to length(instnamen[lj]) do
          stringarray[li] := instnamen[lj,li];
        stringarray[li+1] := #0;
      end else begin;
        stringarray[1] := #0;
      end;

      blockwrite(mof,stringarray,22);
      helpw := Sam_l[lj] ;
      helpw := helpw DIV 2;
      helpw := swap(helpw);
      blockwrite(mof,helpw,2);{ Sample - Lnge }

      helpb := 0;
      blockwrite(mof,helpb,1); { Fine Tune (NICHT UNTERSTTZT !) }

      blockwrite(mof,Inst_vol[lj],1); { Noten - Volumen }

      helpw := Loop_s[lj];
      helpw := helpw DIV 2;
      helpw := swap(helpw);
      blockwrite(mof,helpw,2);         { Loop - Start }

      helpw := Loop_l[lj];
      helpw := helpw DIV 2;
      helpw := swap(helpw);
      blockwrite(mof,helpw,2);         { Loop - Lnge }
    end;
    blockwrite(mof,liedlaenge,1);  { Lied - Lnge ( im Arrangement ) }

    blockwrite(mof,liedlaenge,1); { CIAA-Speed -> Mll schreiben da AMIGA-Spezifisch }

    blockwrite(mof,Lied,128);  { Arrangement }

    if Stimmen = 8 then begin;  { Kennung }
      stringarray[1] := '8';
      stringarray[2] := 'C';
      stringarray[3] := 'H';
      stringarray[4] := 'N';
    end else begin;
      stringarray[1] := 'M';
      stringarray[2] := '.';
      stringarray[3] := 'K';
      stringarray[4] := '.';
    end;
    blockwrite(mof,stringarray,4);

    for lj := 0 to Highest_track do begin;
      if Stimmen = 4 then begin;
        move(rm[lj]^,Pattern8,2048);
        for li := 1 to 64 do begin;
          for chan := 1 to 4 do begin;
            Pattern4[li,chan,1] :=  Pattern8[li,chan,1];
            Pattern4[li,chan,2] :=  Pattern8[li,chan,2];
            Pattern4[li,chan,3] :=  Pattern8[li,chan,3];
            Pattern4[li,chan,4] :=  Pattern8[li,chan,4];
          end;
        end;
        blockwrite(mof,Pattern4,1024);
      end else begin;
        blockwrite(mof,rm[lj]^,2048);
      end;
    end;

    for lj := 1 to 31 do begin;
      blockwrite(mof,Samp[lj]^,Sam_l[lj]);
    end;

    close(mof);
  end;

  schreibe_pattern(edit_Zeile);
  locate_cursor;
end;

procedure Speicher_Instrument(nr : byte; name : string);
var sf : file;
begin;
  assign(sf,name);
  rewrite(sf,1);
  blockwrite(sf,Samp[nr]^,Sam_l[nr]);
  close(sf);
end;

procedure save_Inst(nr : byte);
var dname : string;
begin;
  save_screen;
  rahmen(1,12,6,43,5);
  writexy(14,7,'Dateinamen eingeben (Enter for select)');
  writexy(14,9,'Name: ');
  readln(dname);
  if (dname = '') or (pos('*',dname) <> 0) then
  dname := select_datei(setup.samppfad,'*.*','*.*',' Speichere Instrument ');
  chdir(setup.main);
  chdir(setup.samppfad);
  if dname <> 'xxxx'then
    Speicher_Instrument(nr,dname);
  restore_screen;
  locate_cursor;
end;

procedure copy_pattern;
begin;
  move(Actual_Pattern,Puffer_Pattern,2048);
  Pattern_edited := true;
end;

procedure Paste_Pattern;
begin;
  move(Puffer_Pattern,Actual_Pattern,2048);
  Pattern_edited := true;
end;

procedure save_Pattern;
var dname : string;
    tf : file;
begin;
  dname := select_datei(setup.pattpfad,'*.PTN','*.PTN',' Speicher Pattern ');
  if dname <> 'xxxx' then begin;
    assign(tf,dname);
    rewrite(tf,1);
    blockwrite(tf,Puffer_Pattern,sizeof(Puffer_Pattern));
    close(tf);
  end;
end;

procedure load_Pattern;
var dname : string;
    tf : file;
begin;
  dname := select_datei(setup.pattpfad,'*.PTN','*.PTN',' Lade Pattern ');
  if dname <> 'xxxx' then begin;
    assign(tf,dname);
    reset(tf,1);
    blockread(tf,Puffer_Pattern,
    sizeof(Puffer_Pattern));
    close(tf);
  end;
end;

procedure Copy_Track(nr : byte);
var zeilen : byte;
begin;
  for zeilen := 1 to 64 do begin;
    Puffer_Track[zeilen,1] := Actual_Pattern[zeilen,nr,1];
    Puffer_Track[zeilen,2] := Actual_Pattern[zeilen,nr,2];
    Puffer_Track[zeilen,3] := Actual_Pattern[zeilen,nr,3];
    Puffer_Track[zeilen,4] := Actual_Pattern[zeilen,nr,4];
  end;
  Pattern_edited := true;
end;

procedure Paste_Track(nr : byte);
var zeilen : byte;
begin;
  for zeilen := 1 to 64 do begin;
    Actual_Pattern[zeilen,nr,1] := Puffer_Track[zeilen,1];
    Actual_Pattern[zeilen,nr,2] := Puffer_Track[zeilen,2];
    Actual_Pattern[zeilen,nr,3] := Puffer_Track[zeilen,3];
    Actual_Pattern[zeilen,nr,4] := Puffer_Track[zeilen,4];
  end;
  Pattern_edited := true;
end;

procedure save_track;
var dname : string;
    tf : file;
begin;
  dname := select_datei(setup.trkpfad,'*.trk','*.trk',' Speicher Track ');
  if dname <> 'xxxx' then begin;
    assign(tf,dname);
    rewrite(tf,1);
    blockwrite(tf,Puffer_Track,sizeof(Puffer_Track));
    close(tf);
  end;
end;

procedure load_track;
var dname : string;
    tf : file;
begin;
  dname := select_datei(setup.trkpfad,'*.trk','*.trk',' Lade Track ');
  if dname <> 'xxxx' then begin;
    assign(tf,dname);
    reset(tf,1);
    blockread(tf,Puffer_Track,sizeof(Puffer_Track));
    close(tf);
  end;
end;


procedure select_copy;
var dname : string;
    ch : char;
    son : char;
    selected : byte;
    ende : boolean;
    changed : boolean;
begin;
  cursor_off;
  selected := 1;
  ende := false;
  changed := true;
  mausPfeilAus;
  save_screen;
  mausPfeilEin;
  rahmen(1,27,8,20,7);
  ch := #255;
  while mauskey <> 0 do;
  repeat
    if keypressed then ch := readkey;
    if changed then begin;
      changed := false;
      case selected of
        1 : begin;
              textbackground(11);
              writexy(29, 9,'Track kopieren  ');
              textbackground(7);
              writexy(29,10,'Track einfgen  ');
              writexy(29,11,'Pattern kopiern ');
              writexy(29,12,'Pattern einfgen');
              writexy(29,13,'Abbrechen       ');
            end;
        2 : begin;
              textbackground(11);
              writexy(29,10,'Track einfgen  ');
              textbackground(7);
              writexy(29, 9,'Track kopieren  ');
              writexy(29,11,'Pattern kopiern ');
              writexy(29,12,'Pattern einfgen');
              writexy(29,13,'Abbrechen       ');
            end;
        3 : begin;
              textbackground(11);
              writexy(29,11,'Pattern kopiern ');
              textbackground(7);
              writexy(29, 9,'Track kopieren  ');
              writexy(29,10,'Track einfgen  ');
              writexy(29,12,'Pattern einfgen');
              writexy(29,13,'Abbrechen       ');
            end;
        4 : begin;
              textbackground(11);
              writexy(29,12,'Pattern einfgen');
              textbackground(7);
              writexy(29, 9,'Track kopieren  ');
              writexy(29,10,'Track einfgen  ');
              writexy(29,11,'Pattern kopiern ');
              writexy(29,13,'Abbrechen       ');
            end;
        5 : begin;
              textbackground(11);
              writexy(29,13,'Abbrechen       ');
              textbackground(7);
              writexy(29, 9,'Track kopieren  ');
              writexy(29,10,'Track einfgen  ');
              writexy(29,11,'Pattern kopiern ');
              writexy(29,12,'Pattern einfgen');
            end;
      end;
    end;
    case ch of
      #27 : begin;
              ende := true;
            end;
      #32,
      #13 : begin;
              ende := true;
            end;
       #0 : begin;
              sond := readkey;
              case sond of
                #72 : begin;  { Pfeil up }
                        if selected > 1 then dec(selected);
                        changed := true;
                        ch := #255;
                      end;
                #80 : begin;
                        if selected < 5 then inc(selected);
                        changed := true;
                        ch := #255;
                      end;
              end;
            end;
    end;
  until ende or (mauskey <> 0);

  if mauskey <> 0 then begin;  { Exit durch Mausdruck }
    if MausIn(29,09,48,09) then selected := 1;
    if MausIn(29,10,48,10) then selected := 2;
    if MausIn(29,11,48,11) then selected := 3;
    if MausIn(29,12,48,12) then selected := 4;
    if MausIn(29,13,48,13) then selected := 4;
  end;

  if selected = 1 then begin;
    Copy_Track(edit_track);
  end;

  if selected = 2 then begin;
    Paste_Track(edit_track);
  end;

  if selected = 3 then begin;
    Copy_Pattern;
  end;

  if selected = 4 then begin;
    Paste_Pattern;
  end;

  mausPfeilAus;
  restore_screen;
  mausPfeilEin;
  schreibe_pattern(edit_zeile);
  cursor_on;
  locate_cursor;
end;

procedure recording_interrupt; interrupt;
{
 Wird 50 mal pro Sekunde im MIDI Realtime Recording Modus aufgerufen
}
begin;
  im_recordinginterrupt := true;
  inc(tickcount);
  nosound;
  if keypressed or (mauskey <> 0) then begin;
    asm cli end;
    rec_aufhoeren := true;
  end;
  if tickcount = Steplimit then begin;
    tickcount := 0;
    inc(vorzaehlen);
    if vorzaehlen MOD 4 = 0 then sound(400);
    if (vorzaehlen >= 20) and (edit_zeile <= 56) then inc(edit_zeile);
    schreibe_pattern(edit_zeile);
    if edit_zeile >= 56 then begin;
      move(actual_Pattern,rm[Lied[edit_arrang]]^,2048);
      Pattern_edited := true;
      if Edit_Arrang < 128 then inc(Edit_Arrang);
      if edit_arrang > liedlaenge then begin; { Neues Pattern einfgen }
        inc(liedlaenge);
        inc(highest_track);
        lied[edit_arrang] := highest_track;
      end;
      fillchar(actual_Pattern,2048,0);
      move(rm[Lied[Edit_arrang]]^,actual_Pattern,2048);
      write_arrangement(Edit_arrang);
      edit_zeile := -7;
    end;
  end;
  im_recordinginterrupt := false;
  Port[$20] := $20;
end;

function MIDI_Note(note : byte) : word;
var Oktave,zeile : byte;
begin;
  dec(note,35);
  Oktave := note DIV 12;
  zeile := note - 12*Oktave;
  MIDI_NOTE  := notenvalues[Oktave,zeile];
end;

procedure starte_Realtime;
const Timing_clock_message = 248;
var Die_Note,dynamic : byte;
    izaehler : word;
    oldv : pointer;
    midikanal : byte;
label I_hate_labels;
begin;
  tickcount := 0;
  vorzaehlen := 1;
  edit_zeile := -7;
	wr_dsp_sb16($30);                { MIDI-Modus einschalten           }
  while keypressed do readkey;
  while mauskey <> 0 do;

  asm cli end;
  izaehler := 1193180 DIV 50;      { Timer auf 50 Aufrufe Pro Sekunde }
  Port[$43] := $36;
  Port[$40] := Lo(IZaehler);
  Port[$40] := Hi(IZaehler);
  GetIntVec(8,OldV);
  SetIntVec(8,@recording_interrupt);
  asm sti end;

  repeat
    while not (((port[dsp_adr+$E]) and 128) <> 0) do { Liegen Daten an ? }
    if rec_aufhoeren then begin;
      goto I_hate_labels;
    end;
   	inp := port[dsp_adr+$A];                            { Daten einlesen }
	  if(inp <> $FE) and (inp <> Timing_clock_message) then	begin
      if ((inp shr 4) = 9) or ( inp < 128) then begin;
                       { 9 = Befehl fr Anschlag, Wert < 128 = Datenbyte }
        dynamic := 0;
        if inp >= 128 then begin;
          midikanal := inp AND $0F+1;
     	    while not (((port[dsp_adr+$E]) and 128) <> 0) do;
  	  	  Die_Note := port[dsp_adr+$A];
        end else
           Die_Note := inp;
        while (((port[dsp_adr+$E]) and 128) = 0) do;
   			Dynamic := port[dsp_adr+$A];
        if Dynamic <> 0 then begin;
          if midi_track[midikanal] <= 15 then begin;
            Tonhoehe_in_pattern(edit_zeile+8,midi_track[midikanal],
              MIDI_NOTE(Die_Note));
            Instrument_in_Pattern(edit_zeile+8,midi_track[midikanal],
            inst_akt);
          end;
        end;
      end;
    end;
  until rec_aufhoeren;

I_hate_labels:

  nosound;         { Wegn. Ticken im Takt, Lautsprecher evtl. noch an }

  asm cli end;
  port[$43] := $36;                             { Timer zurck setzen }
  Port[$40] := 0;
  Port[$40] := 0;
  SetIntVec(8,OldV);
  asm sti end;

  PORT[dsp_adr+$6] := 1;                { dsp_adr+$6 = Resettfunktion }
  FOR izaehler := 1 TO 100 DO;
  PORT[dsp_adr+$6] := 0;
  sb16_outputlaenge := 0;

  Pattern_edited := true;

  set_Timeconst_sb16(Sampling_Rate);
  edit_zeile := -7;
  rec_aufhoeren := false;
  schreibe_pattern(edit_zeile);
  locate_cursor;
end;

procedure starte_step;
const Timing_clock_message = 248;
var Die_Note,dynamic : byte;
    iz : byte;
    midikanal : byte;
label I_hate_labels;
begin;
	wr_dsp_sb16($30);
  while keypressed do readkey;
  while mauskey <> 0 do;
  repeat
    while not (((port[dsp_adr+$E]) and 128) <> 0) do
      if keypressed or (mauskey <> 0) then goto I_hate_labels;
  	inp := port[dsp_adr+$A];
	  if(inp <> $FE) and (inp <> Timing_clock_message) then	begin
      if ((inp shr 4) = 9) or ( inp < 128) then begin;
        dynamic := 0;
        if inp >= 128 then begin;
          midikanal := inp AND $0F+1;
     	    while not (((port[dsp_adr+$E]) and 128) <> 0) do;
  	  	  Die_Note := port[dsp_adr+$A];
        end else
           Die_Note := inp;

        while (((port[dsp_adr+$E]) and 128) = 0) do;
   			Dynamic := port[dsp_adr+$A];
        if Dynamic <> 0 then begin;
          if midi_track[midikanal] <= 15 then begin;
            Tonhoehe_in_pattern(edit_zeile+8,midi_track[midikanal],
              MIDI_NOTE(Die_Note));
            Instrument_in_Pattern(edit_zeile+8,midi_track[midikanal],
            inst_akt);
          end;
          inc(edit_zeile);
          schreibe_pattern(edit_zeile);
          locate_cursor;
        end;
      end;
    end;
  until (edit_zeile >= 56) or keypressed or (mauskey <> 0);

I_hate_labels:
  while keypressed do readkey;


  PORT[dsp_adr+$6] := 1;                { dsp_adr+$6 = Resettfunktion}
  FOR iz := 1 TO 100 DO;
  PORT[dsp_adr+$6] := 0;
  sb16_outputlaenge := 0;
  Pattern_edited := true;
  locate_cursor;
end;

function midi_values : byte;
const texte : array[1..9] of string[10] =
  (' Track 1',
   ' Track 2',
   ' Track 3',
   ' Track 4',
   ' Track 5',
   ' Track 6',
   ' Track 7',
   ' Track 8',
   ' Keiner '
  );
  selectvalues : array[1..9] of byte =
  (1,2,3,4,5,6,7,8,255);
  selected : byte = 1;
var li : integer;
    inp : char;
    retval : byte;
begin;
  save_screen;
  rahmen(2,55,4,13,14);
  writexy(57,5,' Select');
  repeat
    textcolor(black);
    for li := 1 to 9 do begin;
      writexy(57,7+li,texte[li]);
    end;
    textcolor(14);
    writexy(57,7+selected,
    texte[selected]);
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      32,
      13: begin;
            retval := selectvalues[selected];
          end;
      27: begin;
            retval := 123;
          end;
      71: begin;
            selected := 1;
          end;
      72: begin;
            if selected > 1 then
              dec(selected);
          end;
      79: begin;
            selected := 9;
          end;
      80: begin;
            if selected < 9 then
              inc(selected);
          end;
     end;
  until (inp = #13) or (inp = #27) or (mauskey <> 0) or (inp = #32);
  restore_screen;
  textcolor(black);
  midi_values := retval;
end;

procedure save_midisetup;
var midf : file;
begin;
  chdir(setup.main);
  assign(midf,'midiset.up');
  rewrite(midf,1);
  blockwrite(midf,Midi_track,16);
  close(midf);
end;

procedure load_midisetup;
var midf : file;
begin;
  chdir(setup.main);
  assign(midf,'midiset.up');
  reset(midf,1);
  blockread(midf,Midi_track,16);
  close(midf);
end;

procedure Midi_setup;
const texte : array[1..19] of string[30] =
  (' Midi  Kanal  0 : ',
   ' Midi  Kanal  1 : ',
   ' Midi  Kanal  2 : ',
   ' Midi  Kanal  3 : ',
   ' Midi  Kanal  4 : ',
   ' Midi  Kanal  5 : ',
   ' Midi  Kanal  6 : ',
   ' Midi  Kanal  7 : ',
   ' Midi  Kanal  8 : ',
   ' Midi  Kanal  9 : ',
   ' Midi  Kanal 10 : ',
   ' Midi  Kanal 11 : ',
   ' Midi  Kanal 12 : ',
   ' Midi  Kanal 13 : ',
   ' Midi  Kanal 14 : ',
   ' Midi  Kanal 15 : ',
   ' Speicher Setup   ',
   ' Lade Setup       ',
   ' Fertig           '
  );
  selected : byte = 1;
var li : integer;
    inp : char;
    retval : byte;
    ende : boolean;
    hs : string;
    hilfe : byte;
begin;
  ende := false;
  save_screen;
  rahmen(1,20,10,34,26);
  writexy(21,12,'    Zuweisung Midi - Track');
  repeat
    textcolor(black);
    for li := 1 to 19 do begin;
      if li <= 16 then begin;
        if midi_track[li] <= 16 then begin;
          str(midi_track[li]:2,hs);
          writexy(22,14+li,texte[li]+'Track '+hs+'    ');
        end else begin;
          hs := 'Keiner';
          writexy(22,14+li,texte[li]+'Track '+hs);
        end;
      end else
        writexy(22,14+li,texte[li]);
    end;
    textcolor(14);
      if selected <= 16 then begin;
        if midi_track[selected] <= 16 then begin;
          str(midi_track[selected]:2,hs);
          writexy(22,14+selected,texte[selected]+'Track '+hs+'    ');
        end else begin;
          hs := 'Keiner';
          writexy(22,14+selected,texte[selected]+'Track '+hs);
        end;
      end else
        writexy(22,14+selected,texte[selected]);
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      13: begin;
            if selected = 17 then save_midisetup;
            if selected = 18 then load_midisetup;
            if selected = 19 then ende := true;
          end;
      27: begin;
            ende := true;
          end;
      32: begin;
            hilfe := midi_values;
            if hilfe <> 123 then
              Midi_track[selected] := hilfe;
          end;
      71: begin;
            selected := 1;
          end;
      72: begin;
            if selected > 1 then
              dec(selected);
          end;
      79: begin;
            selected := 19;
          end;
      80: begin;
            if selected < 19 then
              inc(selected);
          end;
     end;
  until ende or (mauskey <> 0);
  restore_screen;
  textcolor(black);
  locate_cursor;
end;

procedure MIDI_Select;
var dname : string;
    ch : char;
    son : char;
    selected : byte;
    ende : boolean;
    changed : boolean;
begin;
  cursor_off;
  selected := 1;
  ende := false;
  changed := true;
  save_screen;
  rahmen(1,17,8,22,6);
  ch := #255;
  while mauskey <> 0 do;
{  if keypressed then ch := readkey;}
  repeat
    if keypressed then ch := readkey;
    if changed then begin;
      changed := false;
      case selected of
        1 : begin;
              textbackground(11);
              writexy(19, 9,'Setup             ');
              textbackground(7);
              writexy(19,10,'Step by Step Mode ');
              writexy(19,11,'Realtime Recording');
              writexy(19,12,'Abbrechen         ');
            end;
        2 : begin;
              textbackground(11);
              writexy(19,10,'Step by Step Mode ');
              textbackground(7);
              writexy(19, 9,'Setup             ');
              writexy(19,11,'Realtime Recording');
              writexy(19,12,'Abbrechen         ');
            end;
        3 : begin;
              textbackground(11);
              writexy(19,11,'Realtime Recording');
              textbackground(7);
              writexy(19, 9,'Setup             ');
              writexy(19,10,'Step by Step Mode ');
              writexy(19,12,'Abbrechen         ');
            end;
        4 : begin;
              textbackground(11);
              writexy(19,12,'Abbrechen         ');
              textbackground(7);
              writexy(19, 9,'Setup             ');
              writexy(19,10,'Step by Step Mode ');
              writexy(19,11,'Realtime Recording');
            end;
      end;
    end;
    case ch of
      #27 : begin;
              selected := 4;
              ende := true;
            end;
      #32,
      #13 : begin;
              ende := true;
            end;
       #0 : begin;
              sond := readkey;
              case sond of
                #72 : begin;  { Pfeil up }
                        if selected > 1 then dec(selected);
                        changed := true;
                        ch := #255;
                      end;
                #80 : begin;
                        if selected < 4 then inc(selected);
                        changed := true;
                        ch := #255;
                      end;
              end;
            end;
    end;
  until ende or (mauskey <> 0);

  if mauskey <> 0 then begin;  { Exit durch Mausdruck }
    if MausIn(19,09,38,09) then selected := 1;
    if MausIn(19,10,38,10) then selected := 2;
    if MausIn(19,11,38,11) then selected := 3;
    if MausIn(19,12,38,12) then selected := 4;
  end;

  restore_screen;

  if selected = 1 then begin;
    Midi_setup;
  end;

  if selected = 2 then begin;
    Starte_Step;
  end;

  if selected = 3 then begin;
    Starte_Realtime;
  end;

  cursor_on;
  locate_cursor;
end;

procedure convert_sampel(p : pt;l : word); assembler;
asm
  push ds
  mov si,p.sgm
  mov es,si
  mov ds,si
  mov si,p.ofs
  mov di,si
  mov cx,l   { Werte in Register laden }
@swap_schleife:
  lodsb
  sub al,128
  shr al,1                      { Lautstrke-Anpassung an .MOD-Player }
  stosb
  loop @swap_schleife
  pop ds
end;

procedure spiele_Instrument(nr : byte);
const ticon : byte = 180;
var l : longint;
    ct,pn,offs,segm,dsize : word;
    alts : boolean;
begin;
  dsp_rdy_sb16 := false;
  getmem(block,sam_l[nr]);
  move(samp[nr]^,block^,sam_l[nr]);
  convert_sampel(pt(block),sam_l[nr]);
  set_Timeconst_sb16(166);
  l := 16*longint(pt(block).sgm)+pt(block).ofs;
  pn := pt(l).sgm;
  offs := pt(l).ofs;
  alts := stereo;
  stereo := false;
  letzte_ausgabe := true;
  if Sb16Detected then
    Spiele_Sb16(pn,offs,sam_l[nr])
  else
    Spiele_Sb(pn,offs,sam_l[nr]);
  stereo := alts;

  while not dsp_rdy_sb16 do;

  freemem(block,sam_l[nr]);
  set_Timeconst_sb16(Sampling_Rate);
end;

procedure ende_ausfuehren;
var aus : char;
begin;
  save_screen;
  rahmen(1,30,18,16,3);
  textcolor(4);
  writexy(32,19,'Ende (J/N) ');
  readln(aus);
  restore_screen;
  if upcase(aus) = 'J' then begin;
    programmende := true;
  end;
  textcolor(black);
  locate_cursor;
end;

procedure restart_scratch;
var aus : char;
    li : byte;
begin;
  save_screen;
  rahmen(1,22,18,32,3);
  textcolor(4);
  writexy(24,19,'Wirklich neu starten (J/N) ');
  readln(aus);
  restore_screen;
  if Upcase(aus) = 'J' then begin;
    for i := 0 to 63 do begin;
      fillchar(rm[i]^,2048,0);
    end;
    fillchar(actual_Pattern,2048,0);

    if song_loaded then begin;
      ende_mod;
    end;
    song_loaded := false;
    lsongname := 'vised.dat';
    mod_SetSpeed(66);
    dsp_rdy_sb16 := true;
    chdir(setup.main);
    lade_moddatei(lsongname,AUTO,AUTO,Setup.Sam_Rate);
    song_loaded := true;
    mli := 0;
    mlj := 0;
    edit_zeile := -7;
    edit_arrang := 1;
    Zeichne_Desktop;
    highest_track := 0;
    for li := 1 to 128 do
      if lied[li] > highest_track then highest_track := lied[li];
    end;
    fillchar(actual_Pattern,2048,0);
    move(rm[Lied[edit_arrang]]^,actual_Pattern,2048);
    schreibe_pattern(edit_zeile);
    schreibe_Inst(Inst_akt);
    locate_cursor;
    locate_cursor;
  textcolor(black);
  schreibe_pattern(edit_zeile);
  schreibe_inst(inst_akt);
  locate_cursor;
end;

procedure schreibe_help(nr : byte);
const helptexte : array[1..26,1..12] of string[36] =
 (
  ('        Dec / Inc Stimmen           ',
   '                                    ',
   ' Eine .MOD-Datei kann entweder      ',
   ' 4  oder  8  Stimmen   haben.       ',
   ' 6-Stimmige .MOD-Dateien werden     ',
   ' nicht untersttzt. Wenn mglich,   ',
   ' erstellen Sie 4-Stimmige .MOD-     ',
   ' Dateien. Zum  Abspielen  einer     ',
   ' 8-Stimmigen  Datei  wird   die     ',
   ' doppelte Rechenzeit bentigt !     ',
   '                                    ',
   '                                    '),
  ('          Arrangement               ',
   '                                    ',
   'Im Arrangement ist gespeichert, in  ',
   'welcher Folge die Pattern abgespielt',
   'werden.  Zulssige  Werte  fr  die ',
   'Pattern liegen zwischen  0  und  63.',
   'In ihm knnen Sie  sich mittels der ',
   'Maus oder ber die Tasten           ',
   'Alt-F9  zum Scrollen nach links     ',
   'Alt-F10 zum Scrollen nach rechts    ',
   'Alt-A   zum Editieren               ',
   'bewegen.                            '),
  ('         E f f e k t e              ',
   '                                    ',
   'Sie knnen einer Note durch den    ',
   'Einsatz von Effekten zustzliche   ',
   'Eigenschaften geben. Entweder geben ',
   'Sie die Nummer direkt ein, oder     ',
   'whlen Sie ber < Space > aus.      ',
   'Beachten Sie, da bei den E-Effekten',
   'die oberen 4 Bit des Operanden mit  ',
   'zum Effekt gehren !                ',
   '                                    ',
   '                                    '),
  ('    I n s t r u m e n t e  1        ',
   '                                    ',
   'Die Instrumente eines .MOD-Files    ',
   'sind Sampels. Um ein Instrument zu  ',
   'aktivieren, klicken Sie mit der     ',
   'linken Maustaste im Instrumentenfeld',
   'auf das gewnschte Instrument. Wenn ',
   'Sie die rechte Taste bettigen, er-  ',
   'halten Sie ein Auswahlmenue, in dem ',
   'Sie ein Instrument laden, speichern ',
   'oder aus dem Speicher entfernen     ',
   'knnen.                             '),
  ('    I n s t r u m e n t e  2        ',
   '                                    ',
   'Um sich ein Instrument anzuhren,   ',
   'drcken Sie die Tastenkombination   ',
   'Alt-I. Das Sampel wird mit 11KHz    ',
   'abgespielt. Die Parameter des akti- ',
   'ven Instruments werden im oberen    ',
   'Fenster angezeigt. Sie knnen dort  ',
   'diese Parameter editieren. Weitere  ',
   'Informationen finden Sie bei den    ',
   'entsprechenden Parametern           ',
   '                                    '),
  ('       Kopier - Funktionen          ',
   '                                    ',
   'Mit den Kopier-Funktionen knnen Sie',
   'ein Track oder Pattern kopieren.    ',
   'Folgende Tasten sind definiert:     ',
   'F6 = kopiere aktiven Track          ',
   'F7 = fge kopierten Track ein       ',
   'F8 = kopiere Pattern                ',
   'F9 = fge Pattern ein               ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('       M I D I  - Recording         ',
   '                                    ',
   'Im Midi-Recording Modus knnen Sie  ',
   'Daten von angeschlossenen MIDI-     ',
   'Gerten aufnehmen. Die eintreffenden',
   'Daten werden in die im Midi-Setup   ',
   'eingestellen Stimmen geschrieben.   ',
   'Die Geschwindigkeit in Ticks kann im',
   'Feld Midi-Speed eingestellt werden. ',
   'Ein Tick ist 0.02 Sekunden lang. Ist',
   'ein Pattern am Ende angelangt, so   ',
   'wird in das nchste gesprungen.     '),
  ('       M I D I  -  Setup            ',
   '                                    ',
   'Im Midi-Setup editieren Sie die     ',
   'Zuweisung der Midi-Kanle an die   ',
   'einzelnen Stimmen. Dies hat den Vor-',
   'teil, da Sie z.B. nur eine Stimme  ',
   'aufnehmen. Desweiteren knnen Sie   ',
   'eine mit einem anderen Gert abge-  ',
   'spielte MIDI-Datei aufnehmen ...    ',
   'Ihre hufigste Einstellung knnen   ',
   'Sie auerdem speichern / laden.     ',
   '                                    '),
  ('       M I D I  -  Speed            ',
   '                                    ',
   'Die Aufnahme-Geschwindigkeit hngt  ',
   'vom hier eingestellten Wert ein.    ',
   'Der Wert bezeichnet die Ticks, die  ',
   'vergehen, bis das Pattern eine Zeile',
   'weiter scrollt. Ein Tick ist dabei  ',
   '0.02 Sekunden lang. Sie knnen einen',
   'Wert zwuschen 2 und 12 einstellen.  ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('      M I D I  Step by Step         ',
   '                                    ',
   'Der Step by Step Modus wird auch    ',
   'durch die im MIDI-Setup eingestell- ',
   'ten Werte gesteuert. Jedoch luft   ',
   'in ihm nicht das Pattern in einer   ',
   'konstanten Geschwindigkeit durch,   ',
   'sondern die Noten knnen nacheinan- ',
   'der eingegeben werden ...           ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('      .MOD laden / speichern        ',
   '                                    ',
   'Whlen Sie die gewnschte Datei aus ',
   'der Auswahlbox ber Mausklick oder  ',
   'ber die Tasten aus. Den Namen einer',
   'nicht aufgelisteten Datei knnen Sie',
   'ber die Taste <Einfg> einfgen.    ',
   'Dieser Name darf auch eine Pfad-    ',
   'Angabe enthalten, sollte jedoch die ',
   'Endung .MOD tragen. Beim laden ist  ',
   'darauf zu achten, eine korrekte .MOD',
   'Datei zu laden !                    '),
  ('         .MOD abspielen             ',
   '                                    ',
   'Die momentan geladene Datei knnen  ',
   'Sie ber die Auswahl des Punktes    ',
   'Play oder durch die Tastenkombina-  ',
   'tionen   Alt-F8                     ',
   '         Alt-P   abspielen. Die Aus-',
   'gabe erfolgt in der im Setup einge- ',
   'stelletn Sampelrate. Folgende       ',
   'Sampelraten sind zu empfehlen:      ',
   '386sx:  8-10 KHz  386dx: 10-13 KHz  ',
   '486sx: 13-16 KHz  486dx: 16-22 KHz  '),
  ('          Note eingeben             ',
   '                                    ',
   'Die Eingabe der Noten erfolgt entwe-',
   'der ber Midi oder aber ber die    ',
   'Tastatur. Dort knnen Sie entweder  ',
   'die Noten direkt eingeben (q = C,   ',
   '2 = C#  w = D  etc), oder aber ber ',
   '< Space > auswhlen.                ',
   '                                    ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('           O k t a v e              ',
   '                                    ',
   'Die momentan eingestellte Oktave hat',
   'fr dierekte Eingabe der Noten ber ',
   'die Tastatur bedeutung. Der einge-  ',
   'stellte Wert bezeichnet den Oktaven-',
   'Wert der Taste q                    ',
   'Beispiel: Wert = 1  -> q = C1       ',
   '          Wert = 3  -> w = D3       ',
   'Den Wert verndern Sie ber die     ',
   'Tasten < + >  und  < - > oder mit   ',
   'der Maus.                           '),
  ('        Operand eingeben            ',
   '                                    ',
   'Den Operanden eines Befehls geben   ',
   'Sie im jeweils letzte Feld eines    ',
   'Tracks ein. Beachten Sie, da einige',
   'Effekte einen Teil des Operanden    ',
   'als Kennung mit benutzen.           ',
   '                                    ',
   '                                    ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('    Pattern laden / speichern       ',
   '                                    ',
   'ber die Tasten Alt-F6 / Alt-F7 oder',
   'mittels der Maus knnen Sie ein     ',
   'Pattern laden bzw. speichern. Dabei ',
   'wird das sich momentan im Copy -    ',
   'Buffer befindliche Pattern gespei-  ',
   'chert bzw. das Pattern in den Copy- ',
   'Buffer geladen.                     ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('    Sampel speichern / laden        ',
   '                                    ',
   'Mittels der Tasten Alt-F2 / Alt-F3  ',
   'oder ber die Maus knnen Sie ein   ',
   'Sampel speichern / laden. Whlen Sie',
   'dazu eine Datei aus der Auswahlbox  ',
   'oder geben Sie den Dateinamen ber  ',
   '< einfg > ein. Es werden nur die    ',
   'reinen Sampel-Daten und nicht die   ',
   'Parameter gespeichert / geladen !   ',
   '                                    ',
   '                                    '),
  ('          Sampel Looping            ',
   '                                    ',
   'Ein Sampel kann in einer Schleife   ',
   'wiederholt werden. Dies ist z.B. bei',
   'Streichern blich. Die Schleife wird',
   'durch ihren Start-Wert und ihre     ',
   'Lnge in Bytes festgelegt. Diese    ',
   'knnen im oberen Fenster editiert   ',
   'werden.                             ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('            Sampel Name             ',
   '                                    ',
   'Jedes Sampel kann eine Namen mit der',
   'maximalen Lnge von 21 Zeichen er-  ',
   'halten. Diesen knnen Sie eingeben, ',
   'indem Sie mit der Maus auf das      ',
   'Namensfeld im oberen Fenster klicken',
   '                                    ',
   '                                    ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('             Song Name              ',
   '                                    ',
   'Dem Lied knnen Sie einen Tietel von',
   'maximal 19 Zeichen geben. Diesen    ',
   'Tietel knnen Sie eingeben, indem   ',
   'Sie mit der Maus auf das Feld des   ',
   'Tietels klicken.                    ',
   '                                    ',
   '                                    ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('    Tastaturbelegung  1             ',
   '                                    ',
   ' F01 = Hilfe                        ',
   ' F02 = Speicher MOD                 ',
   ' F03 = Lade MOD                     ',
   ' F04 = Midi im Realtime Mode        ',
   ' F05 = Midi im Step by Step Mode    ',
   ' F06 = Copy Track                   ',
   ' F07 = Paste Track                  ',
   ' F08 = Copy Pattern                 ',
   ' F09 = Paste Pattern                ',
   ' F10 = Ende                         '),
  ('    Tastaturbelegung  2             ',
   '                                    ',
   'Alt-F01 = Copyright                 ',
   'Alt-F02 = Sampel Speichern          ',
   'Alt-F03 = Sampel Laden              ',
   'Alt-F04 = Track Speichern           ',
   'Alt-F05 = Track Laden               ',
   'Alt-F06 = Pattern Speichern         ',
   'Alt-F07 = Pattern Laden             ',
   'Alt-F08 = Play Song                 ',
   'TAB     = Springen zwischen Pattern,',
   '          Instrumenten & Arrang.    '),
  ('    Tastaturbelegung  3             ',
   '                                    ',
   'Alt-I = Spiele Instrument mit 11KHz ',
   'Alt-P = Play Song                   ',
   'Alt-A = Edit Arrangement            ',
   'Alt-S = Speichere MOD               ',
   'Alt-L = Lade MOD                    ',
   'Alt-X = Ende                        ',
   'Alt-C = Configuration ndern        ',
   '    M = Midi Setup                  ',
   '    N = Neustart, Memory clear      ',
   '                                    '),
  ('    Tastaturbelegung  4             ',
   '                                    ',
   'space = Auswahl                     ',
   '  -   = Oktave verringern           ',
   '  +   = Oktave erhhen              ',
   'einf  = Einfgen (Track / Arrang.)  ',
   'entf  = Entfernen (Track / Arrang.) ',
   'Strg-Pfeil = Zwischen den Tracks    ',
   '             herspringen            ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('      Track laden / speichern       ',
   '                                    ',
   'ber die Tasten Alt-F4 / Alt-F5 oder',
   'mittels der Maus knnen Sie einen   ',
   'Track laden bzw. speichern. Dabei   ',
   'wird der  sich  momentan  im Copy - ',
   'Buffer befindliche Track gespeichert',
   'chert bzw. der Track  in den Copy- ',
   'Buffer geladen.                     ',
   '                                    ',
   '                                    ',
   '                                    '),
  ('            V o l u m e             ',
   '                                    ',
   'Die Lautstrke eines Instruments    ',
   'knnen Sie im Volume-Feld ndern.   ',
   'Erlaubte Werte liegen zwischen 0    ',
   'fr absolute Stille bis 63 fr die  ',
   'maximale Lautstrke.                ',
   '                                    ',
   '                                    ',
   '                                    ',
   '                                    ',
   '                                    '));
var li : integer;
begin;
  save_screen;
  while mauskey <> 0 do;

  fenster(18,10,40,18,' H i l f e ',1,7);
  textcolor(black);
  for li := 1 to 12 do begin;
    writexy(20,10+li,helptexte[nr,li]);
  end;
  writexy(20,26,'       Mausklick / Tastendruck = Ende');
  repeat until keypressed or (mauskey <> 0);
  if keypressed then readkey;
  while mauskey <> 0 do;

  restore_screen;
  locate_cursor;
end;

procedure Display_Help;
const texte : array[1..27] of string[40] =
  (
   ' Anzahl Stimmen           ',
   ' Arrangement              ',
   ' Effekt auswhlen         ',
   ' Instrumente 1            ',
   ' Instrumente 2            ',
   ' Kopier - Funktionen      ',
   ' Midi Recording           ',
   ' Midi Setup               ',
   ' Midi Speed               ',
   ' Midi Step by Step        ',
   ' MOD laden / speichern    ',
   ' MOD abspielen            ',
   ' Noten eingeben           ',
   ' Oktave                   ',
   ' Operand eingeben         ',
   ' Pattern laden / speichern',
   ' Sampel laden / speichern ',
   ' Sampel Looping           ',
   ' Sampel Name              ',
   ' Songname                 ',
   ' Tastaturbelegung  1      ',
   ' Tastaturbelegung  2      ',
   ' Tastaturbelegung  3      ',
   ' Tastaturbelegung  4      ',
   ' Track laden / speichern  ',
   ' Volume                   ',
   ' Ende                     '
  );
  selected : byte = 1;
var li : integer;
    inp : char;
    retval : byte;
    ende : boolean;
    hs : string;
    hilfe : byte;
    geaendert : boolean;
begin;
  ende := false;
  geaendert := true;
  save_screen;
  cursor_off;
  rahmen(1,20,10,34,34);
  writexy(21,12,'  Hilfe - Auswahlmenue');
  while mauskey <> 0 do;
  inp := #255;
  repeat
    if geaendert then begin;
      geaendert := false;
      textcolor(black);
      for li := 1 to 27 do begin;
        writexy(22,14+li,texte[li]);
      end;
      textcolor(14);
      writexy(22,14+selected,texte[selected]);
    end;
    if keypressed then begin;
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      13: begin;
            if selected < 27 then schreibe_help(selected);
            if selected = 27 then ende := true;
          end;
      27: begin;
            ende := true;
          end;
      71: begin;
            selected := 1;
            geaendert := true;
            inp := #255;
          end;
      72: begin;
            geaendert := true;
            inp := #255;
            if selected > 1 then
              dec(selected);
          end;
      79: begin;
            geaendert := true;
            inp := #255;
            selected := 27;
          end;
      80: begin;
            geaendert := true;
            inp := #255;
            if selected < 27 then
              inc(selected);
          end;
     end;
    end;
    if mauskey <> 0 then begin;
      if MausIn(21,15,45,15) then schreibe_help(1);
      if MausIn(21,16,45,16) then schreibe_help(2);
      if MausIn(21,17,45,17) then schreibe_help(3);
      if MausIn(21,18,45,18) then schreibe_help(4);
      if MausIn(21,19,45,19) then schreibe_help(5);
      if MausIn(21,20,45,20) then schreibe_help(6);
      if MausIn(21,21,45,21) then schreibe_help(7);
      if MausIn(21,22,45,22) then schreibe_help(8);
      if MausIn(21,23,45,23) then schreibe_help(9);
      if MausIn(21,24,45,24) then schreibe_help(10);
      if MausIn(21,25,45,25) then schreibe_help(11);
      if MausIn(21,26,45,26) then schreibe_help(12);
      if MausIn(21,27,45,27) then schreibe_help(13);
      if MausIn(21,28,45,28) then schreibe_help(14);
      if MausIn(21,29,45,29) then schreibe_help(15);
      if MausIn(21,30,45,30) then schreibe_help(16);
      if MausIn(21,31,45,31) then schreibe_help(17);
      if MausIn(21,32,45,32) then schreibe_help(18);
      if MausIn(21,33,45,33) then schreibe_help(19);
      if MausIn(21,34,45,34) then schreibe_help(20);
      if MausIn(21,35,45,35) then schreibe_help(21);
      if MausIn(21,36,45,36) then schreibe_help(22);
      if MausIn(21,37,45,37) then schreibe_help(23);
      if MausIn(21,38,45,38) then schreibe_help(24);
      if MausIn(21,39,45,39) then schreibe_help(25);
      if MausIn(21,40,45,40) then schreibe_help(26);
      if MausIn(21,41,45,41) then ende := true;
    end;
  until ende;
  restore_screen;
  textcolor(black);
  cursor_on;
  locate_cursor;
end;


procedure display_copyright;
begin;
  save_screen;
  cursor_off;
  MausPfeilEin;
  rahmen(1,10,10,60,30);
  writexy(12,12,'Der   V I S I O N  -  F A C T O R Y    MOD - EDITOR  2.0');
  writexy(12,13,'                                                        ');
  writexy(12,14,'       (c) 1993  by   D A T A   B E C K E R             ');
  writexy(12,15,'                                                        ');
  writexy(12,16,'      Autor:  B o r i s   B e r t e l s o n s           ');
  writexy(12,17,'                                                        ');
  writexy(12,18,' Mit dem vorliegenden .MOD-Editor knnen Sie 4- und 8-   ');
  writexy(12,19,' stimmige .MOD-Files erstellen. Die erzeugten Dateien   ');
  writexy(12,20,' sind kompatibel zum TRITON Fasttracker.                ');
  writexy(12,21,'                                                        ');
  writexy(12,22,' Neben umfangreichen Hilfefunktionen und Auswahlmens   ');
  writexy(12,23,' bietet Ihnen dieser Editor die Mglichkeit, ber MIDI  ');
  writexy(12,24,' Daten einzuspielen. Desweiteren habe Sie die Mglchkeit');
  writexy(12,25,' Tracks und Pattern einzeln zu speichern & laden !      ');
  writexy(12,26,'                                                        ');
  writexy(12,27,' Drcken Sie F1, um die Hilfe-Funktion zu aktivieren !  ');
  writexy(12,28,'                                                        ');
  writexy(12,29,' F3 = Datei laden      Alt-F8 = Datei abspielen         ');
  writexy(12,30,'                                                        ');
  writexy(12,31,'                                                        ');
  writexy(12,32,' Dieser Editor benutzt die Unit  U S E M O D  aus dem   ');
  writexy(12,33,'                                                        ');
  writexy(12,34,'                                                        ');
  writexy(12,35,'  >  S o u n d b l a s t e r  -  S u p e r b u c h  <   ');
  writexy(12,36,'                                                        ');
  writexy(12,37,'                                                        ');
  writexy(12,38,'        - weiter mit Tastendruck / Mausklick -          ');
  repeat until keypressed or (mauskey <> 0);
  if keypressed then readkey;
  while mauskey <> 0 do;
  cursor_on;
  restore_screen;
  locate_cursor;
end;

procedure save_configuration;
var cf : file;
begin;
  chdir(setup.main);
  assign(cf,'vised.cfg');
  rewrite(cf,1);
  blockwrite(cf,setup,sizeof(setup));
  close(cf);
  save_screen;
  Fenster(14,20,34,10,' I n f o ',1,7);
  writexy(16,22,' VISION FACTOTY Mod-Editor ');
  writexy(16,24,' Setup erfolgreich gespeichert');
  writexy(16,26,' Taste / Klick fr weiter ...');
  repeat until keypressed or (mauskey <> 0);
  while keypressed do readkey;
  while mauskey <> 0 do;
  restore_screen;
end;

function inp_sampelrate : byte;
const texte : array[1..5] of string[10] =
  ('  8 KHz',
   ' 10 KHz',
   ' 13 KHz',
   ' 16 KHz',
   ' 22 KHz'
  );
  selectvalues : array[1..5] of byte =
  (8,10,13,16,22);
  selected : byte = 1;
var li : integer;
    inp : char;
    retval : byte;
    ende : boolean;
    geaendert : boolean;
begin;
  ende := false;
  geaendert := true;
  save_screen;
  rahmen(2,55,4,13,10);
  writexy(57,5,' Select');
  repeat
    if geaendert then begin;
      geaendert := false;
      textcolor(black);
      for li := 1 to 5 do begin;
        writexy(57,7+li,texte[li]);
      end;
      textcolor(14);
      writexy(57,7+selected,texte[selected]);
    end;
    if keypressed then begin;
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      13: begin;
            retval := selectvalues[selected];
            ende := true;
          end;
      27: begin;
            retval := 123;
            ende := true;
          end;
      71: begin;
            selected := 1;
            geaendert := true;
          end;
      72: begin;
            geaendert := true;
            if selected > 1 then
              dec(selected);
          end;
      79: begin;
            geaendert := true;
            selected := 5;
          end;
      80: begin;
            geaendert := true;
            if selected < 5 then
              inc(selected);
          end;
     end;
     end;
     if mauskey <> 0 then begin;
       if MausIn(57,8,65,8) then begin;
         retval := selectvalues[1];
         ende := true;
       end;

       if MausIn(57,9,65,9) then begin;
         retval := selectvalues[2];
         ende := true;
       end;

       if MausIn(57,10,65,10) then begin;
         retval := selectvalues[3];
         ende := true;
       end;

       if MausIn(57,11,65,11) then begin;
         retval := selectvalues[4];
         ende := true;
       end;

       if MausIn(57,12,65,12) then begin;
         retval := selectvalues[5];
         ende := true;
       end;

     end;
  until ende;
  restore_screen;
  textcolor(black);
  inp_sampelrate := retval;
end;

function inp_pfad(wohin : string) : string;
var retval : string;
begin;
  save_screen;
  cursor_on;
  textcolor(14);
  rahmen(2,12,30,56,6);
  textcolor(black);
  writexy(22,31,'Bitte den Vollstndigen Pfad eingeben !');
  gotoxy(15,33);
  if wohin = '' then begin;
    getdir(0,retval);
  end else
    retval := wohin;
  retval := lies_string(47,retval);
  restore_screen;
  textcolor(black);
  cursor_off;
  inp_pfad := retval;
end;

function inp_irq : byte;
const texte : array[1..7] of string[10] =
  (' IRQ  2',
   ' IRQ  3',
   ' IRQ  5',
   ' IRQ  7',
   ' IRQ  9',
   ' IRQ 10',
   ' Detect'
  );
  selectvalues : array[1..7] of byte =
  (2,3,5,7,9,10,244);
  selected : byte = 1;
var li : integer;
    inp : char;
    retval : byte;
    ende : boolean;
    geaendert : boolean;
begin;
  ende := false;
  geaendert := true;
  save_screen;
  rahmen(2,55,4,13,12);
  writexy(57,5,' Select');
  repeat
    if geaendert then begin;
      geaendert := false;
      textcolor(black);
      for li := 1 to 7 do begin;
        writexy(57,7+li,texte[li]);
      end;
      textcolor(14);
      writexy(57,7+selected,texte[selected]);
    end;
    if keypressed then begin;
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      13: begin;
            retval := selectvalues[selected];
            ende := true;
          end;
      27: begin;
            retval := 123;
            ende := true;
          end;
      71: begin;
            selected := 1;
            geaendert := true;
          end;
      72: begin;
            geaendert := true;
            if selected > 1 then
              dec(selected);
          end;
      79: begin;
            geaendert := true;
            selected := 7;
          end;
      80: begin;
            geaendert := true;
            if selected < 7 then
              inc(selected);
          end;
     end;
     end;
     if mauskey <> 0 then begin;
       if MausIn(57,8,65,8) then begin;
         retval := selectvalues[1];
         ende := true;
       end;

       if MausIn(57,9,65,9) then begin;
         retval := selectvalues[2];
         ende := true;
       end;

       if MausIn(57,10,65,10) then begin;
         retval := selectvalues[3];
         ende := true;
       end;

       if MausIn(57,11,65,11) then begin;
         retval := selectvalues[4];
         ende := true;
       end;

       if MausIn(57,12,65,12) then begin;
         retval := selectvalues[5];
         ende := true;
       end;

       if MausIn(57,13,65,13) then begin;
         retval := selectvalues[6];
         ende := true;
       end;

       if MausIn(57,14,65,14) then begin;
         retval := selectvalues[7];
         ende := true;
       end;

     end;
  until ende;
  restore_screen;
  textcolor(black);
  inp_irq := retval;
end;

function inp_dma : byte;
const texte : array[1..3] of string[20] =
  (' DMA-Kanal 0',
   ' DMA-Kanal 1',
   ' DMA-Kanal 3'
  );
  selectvalues : array[1..3] of byte =
  (0,1,3);
  selected : byte = 1;
var li : integer;
    inp : char;
    retval : byte;
    ende : boolean;
    geaendert : boolean;
begin;
  ende := false;
  geaendert := true;
  save_screen;
  rahmen(2,55,4,15,08);
  writexy(59,5,' Select');
  repeat
    if geaendert then begin;
      geaendert := false;
      textcolor(black);
      for li := 1 to 3 do begin;
        writexy(56,7+li,texte[li]);
      end;
      textcolor(14);
      writexy(56,7+selected,texte[selected]);
    end;
    if keypressed then begin;
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      13: begin;
            retval := selectvalues[selected];
            ende := true;
          end;
      27: begin;
            retval := 123;
            ende := true;
          end;
      71: begin;
            selected := 1;
            geaendert := true;
          end;
      72: begin;
            geaendert := true;
            if selected > 1 then
              dec(selected);
          end;
      79: begin;
            geaendert := true;
            selected := 3;
          end;
      80: begin;
            geaendert := true;
            if selected < 3 then
              inc(selected);
          end;
     end;
     end;
     if mauskey <> 0 then begin;
       if MausIn(56,8,65,8) then begin;
         retval := selectvalues[1];
         ende := true;
       end;

       if MausIn(56,9,65,9) then begin;
         retval := selectvalues[2];
         ende := true;
       end;

       if MausIn(56,10,65,10) then begin;
         retval := selectvalues[3];
         ende := true;
       end;

     end;
  until ende;
  restore_screen;
  textcolor(black);
  inp_dma := retval;
end;

function inp_maustyp : byte;
const texte : array[1..2] of string[20] =
  (' Microsoft Maus',
   ' Andere Maus   '
  );
  selectvalues : array[1..2] of byte = (1,2);
  selected : byte = 1;
var li : integer;
    inp : char;
    retval : byte;
    ende : boolean;
    geaendert : boolean;
begin;
  ende := false;
  geaendert := true;
  save_screen;
  rahmen(2,55,4,18,08);
  writexy(59,5,' Select');
  repeat
    if geaendert then begin;
      geaendert := false;
      textcolor(black);
      for li := 1 to 2 do begin;
        writexy(56,7+li,texte[li]);
      end;
      textcolor(14);
      writexy(56,7+selected,texte[selected]);
    end;
    if keypressed then begin;
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      13: begin;
            retval := selectvalues[selected];
            ende := true;
          end;
      27: begin;
            retval := 123;
            ende := true;
          end;
      71: begin;
            selected := 1;
            geaendert := true;
          end;
      72: begin;
            geaendert := true;
            if selected > 1 then
              dec(selected);
          end;
      79: begin;
            geaendert := true;
            selected := 2;
          end;
      80: begin;
            geaendert := true;
            if selected < 2 then
              inc(selected);
          end;
     end;
     end;
     if mauskey <> 0 then begin;
       if MausIn(56,8,65,8) then begin;
         retval := selectvalues[1];
         ende := true;
       end;

       if MausIn(56,9,65,9) then begin;
         retval := selectvalues[2];
         ende := true;
       end;

     end;
  until ende;
  restore_screen;
  textcolor(black);
  Maustyp := retval;
  inp_maustyp := retval;
end;

procedure editor_configuration;
const texte : array[1..11] of string[30] =
  (' Sampelrate     ',
   ' IRQ            ',
   ' DMA-Kanal      ',
   ' Hauptpfad      ',
   ' Mod-Pfad       ',
   ' Sampel-Pfad    ',
   ' Pattern-Pfad   ',
   ' Track-Pfad     ',
   ' Maus-Typ       ',
   ' Speicher Setup ',
   ' Fertig         '
  );
  selected : byte = 1;
var li : integer;
    inp : char;
    retval : byte;
    ende : boolean;
    hs : string;
    hilfe : byte;
    geaendert : boolean;
begin;
  ende := false;
  geaendert := true;
  save_screen;
  cursor_off;
  rahmen(1,20,10,19,17);
  writexy(21,12,'  Editor - Setup');
  repeat
    if geaendert then begin;
      geaendert := false;
      textcolor(black);
      for li := 1 to 11 do begin;
        writexy(22,13+li,texte[li]);
      end;
      textcolor(14);
      writexy(22,13+selected,texte[selected]);
    end;
    if keypressed then begin;
    inp := readkey;
    if ord(inp) = 0 then inp := readkey;
    case ord(inp) of
      27: begin;
            ende := true;
          end;
      13,
      32: begin;
            if selected = 1 then begin;
              Setup.Sam_Rate := inp_sampelrate;
              mod_Samplefreq(Setup.Sam_Rate);
              set_timeconst_sb16(Sampling_Rate);
            end;
            if selected = 2 then begin;
              Setup.IRQ := inp_IRQ;
              if setup.irq = 244 then begin;
                force_irq := false;
              end else begin;
                force_irq := true;
                dsp_irq := setup.irq;
              end;
            end;
            if selected = 3 then begin;
              Setup.DMA := inp_DMA;
              dma_ch := Setup.DMA;
            end;
            if selected = 4 then begin;
              Setup.Main := inp_pfad(Setup.Main);
            end;
            if selected = 5 then begin;
              Setup.Modpfad := inp_pfad(Setup.Modpfad);
            end;
            if selected = 6 then begin;
              Setup.Samppfad := inp_pfad(Setup.Samppfad);
            end;
            if selected = 7 then begin;
              Setup.Pattpfad := inp_pfad(Setup.Pattpfad);
            end;
            if selected = 8 then begin;
              Setup.Trkpfad := inp_pfad(Setup.Trkpfad);
            end;
            if selected = 9 then Setup.Maus := inp_Maustyp;
            if selected = 10 then save_configuration;
            if selected = 11 then ende := true;
          end;
      71: begin;
            selected := 1;
            geaendert := true;
          end;
      72: begin;
            geaendert := true;
            if selected > 1 then
              dec(selected);
          end;
      79: begin;
            geaendert := true;
            selected := 11;
          end;
      80: begin;
            geaendert := true;
            if selected < 11 then
              inc(selected);
          end;
     end;
     end;
     if mauskey <> 0 then begin;
       if MausIn(22,14,38,14) then begin;
         Setup.Sam_Rate := inp_sampelrate;
         mod_Samplefreq(Setup.Sam_Rate);
         set_timeconst_sb16(Sampling_Rate);
       end;

       if MausIn(22,15,38,15) then begin;
         Setup.Main := inp_pfad(Setup.Main);
       end;

       if MausIn(22,16,38,16) then begin;
         Setup.irq := inp_irq;
       end;

       if MausIn(22,17,38,17) then begin;
         Setup.dma := inp_dma;
       end;

       if MausIn(22,18,38,18) then begin;
         Setup.Modpfad := inp_pfad(Setup.Modpfad);
       end;

       if MausIn(22,19,38,19) then begin;
         Setup.Samppfad := inp_pfad(Setup.Samppfad);
       end;

       if MausIn(22,20,38,20) then begin;
         Setup.Pattpfad := inp_pfad(Setup.Pattpfad);
       end;

       if MausIn(22,21,38,21) then begin;
         Setup.Trkpfad := inp_pfad(Setup.Trkpfad);
       end;

       if MausIn(22,22,38,22) then begin;
         Setup.Maus := inp_Maustyp;
       end;

       if MausIn(22,23,38,23) then begin;
         save_configuration;
       end;

       if MausIn(22,24,38,24) then begin;
         ende := true;
       end;
     end;
  until ende;
  if setup.Maus = 1 then begin;
    Mausgrenze(0,0,635,200);
    Maustyp := 1;
  end else begin;
    Mausgrenze(0,0,635,395);
    Maustyp := 2;
  end;
  cursor_on;
  restore_screen;
  textcolor(black);
  locate_cursor;
end;


procedure Event001;
{ Hilfe - Button}
begin;
  display_help;
  locate_cursor;
end;

procedure Event002;
{ Programm - Ende }
begin;
  ende_ausfuehren;
  locate_cursor;
end;

procedure Event003;
{ Editor Configurieren }
begin;
  Editor_configuration;
  locate_cursor;
end;

procedure Event004;
{ Dec. Stimmen }
begin;
  help_context := 2;
  if Stimmen > 4 then Stimmen := 4;
  writexy(3,6,'Stimmen   : '); write(Stimmen:2); Write_Scroll;
  locate_cursor;
end;

procedure Event005;
{ Inc. Stimmen }
begin;
  help_context := 2;
  if Stimmen < 8 then Stimmen := 8;
  writexy(3,6,'Stimmen   : '); write(Stimmen:2); Write_Scroll;
  locate_cursor;
end;

procedure Event006;
{ Dec. MIDI-Speed }
begin;
  if Steplimit > 2 then dec(Steplimit);
  writexy(3,8,'Midi Speed: '); write(Steplimit:2); Write_Scroll;
  locate_cursor;
end;

procedure Event007;
{ Inc. MIDI-Speed }
begin;
  if Steplimit < 12 then inc(Steplimit);
  writexy(3,8,'Midi Speed: '); write(Steplimit:2); Write_Scroll;
  locate_cursor;
end;

procedure Event008;
{ Dec. Octave }
begin;
  if Edit_Oktave > 0 then dec(Edit_Oktave);
  writexy(3,10,'Oktave    : '); write(Edit_Oktave:2); Write_Scroll;
  locate_cursor;
end;

procedure Event009;
{ Inc. Octave }
begin;
  if Edit_Oktave < 4 then inc(Edit_Oktave);
  writexy(3,10,'Oktave    : '); write(Edit_Oktave:2); Write_Scroll;
  locate_cursor;
end;

procedure Event010;
{ MOD laden }
VAR li : integer;
begin;
  if song_loaded then begin;
    ende_mod;
  end;
  song_loaded := false;
  lsongname := select_datei(setup.modpfad,'*.mod','*.mod',' Lade .MOD-Datei ');
  if lsongname <> 'xxxx' then begin;
    mod_SetSpeed(66);
    mod_Samplefreq(Setup.Sam_Rate);
    dsp_rdy_sb16 := true;
    lade_moddatei(lsongname,AUTO,AUTO,Setup.Sam_Rate);
    song_loaded := true;
    mli := 0;
    mlj := 0;
    edit_zeile := -7;
    edit_arrang := 1;
    Zeichne_Desktop;
    highest_track := 0;
    for li := 1 to 128 do
      if lied[li] > highest_track then highest_track := lied[li];
  end;
  fillchar(actual_Pattern,2048,0);
  move(rm[Lied[edit_arrang]]^,actual_Pattern,2048);
  schreibe_pattern(edit_zeile);
  schreibe_Inst(Inst_akt);
  locate_cursor;
end;

procedure Event011;
{ MOD speichern }
begin;
  Save_Mod('');
  locate_cursor;
end;

procedure Event012;
{ Sampel laden }
var dname : string;
begin;
  dname := select_datei(setup.samppfad,'*.*','*.*',' Lade Instrument ');
  if dname <> 'xxxx'then neues_Instrument(Inst_akt,dname);
  locate_cursor;
end;

procedure Event013;
{ Sampel speichern }
begin;
  save_Inst(Inst_akt);
  locate_cursor;
end;

procedure Event014;
{ Pattern laden }
begin;
  load_pattern;
  schreibe_pattern(edit_zeile);
  locate_cursor;
end;

procedure Event015;
{ Pattern speichern }
begin;
  save_pattern;
  schreibe_pattern(edit_zeile);
  locate_cursor;
end;

procedure Event016;
{ Track laden }
begin;
  load_track;
  schreibe_pattern(edit_zeile);
  locate_cursor;
end;

procedure Event017;
{ Track speichern }
begin;
  save_track;
  schreibe_pattern(edit_zeile);
  locate_cursor;
end;

procedure Event018;
{ Songname editieren }
begin;
  save_screen;
  textcolor(black);
  rahmen(2,16,9,45,5);
  writexy(20,10,' Song-Namen eingeben');
  writexy(20,12,'Name : ');
  readln(songname);
  restore_screen;
  write_instinfo;
  locate_cursor;
end;

procedure Event019;
{ Loop Start direkt eingeben }
begin;
  save_screen;
  textcolor(black);
  rahmen(2,16,9,45,5);
  writexy(20,10,' Loop - Start eingeben');
  writexy(20,12,'Start : ');
  readln(Loop_s[inst_akt]);
  if Loop_s[inst_akt] > Sam_l[inst_akt]-Loop_l[inst_akt] then
    Loop_s[inst_akt] := Sam_l[inst_akt]-Loop_l[inst_akt];
  restore_screen;
  write_instinfo;
  locate_cursor;
end;

procedure Event020;
{ Loop Start Dec. }
begin;
  if Loop_s[inst_akt] > 1 then dec(loop_s[inst_akt]);
  write_instinfo;
  locate_cursor;
end;

procedure Event021;
{ Loop Start Inc. }
begin;
 if Loop_s[inst_akt] < Sam_l[inst_akt]-Loop_l[inst_akt] then
   inc(loop_s[inst_akt]);
 write_instinfo;
 locate_cursor;
end;

procedure Event022;
{ Loop Lnge direkt eingeben }
begin;
  save_screen;
  textcolor(black);
  rahmen(2,16,9,45,5);
  writexy(20,10,' Loop - Lnge eingeben');
  writexy(20,12,'Lnge : ');
  readln(Loop_l[inst_akt]);
  if Loop_l[inst_akt] > Sam_l[inst_akt]-Loop_s[inst_akt] then
    Loop_l[inst_akt] := Sam_l[inst_akt]-Loop_s[inst_akt];
  restore_screen;
  write_instinfo;
  locate_cursor;
end;

procedure Event023;
{ Dec. Loop Lnge }
begin;
  if Loop_l[inst_akt] > 1 then dec(loop_l[inst_akt]);
  write_instinfo;
  locate_cursor;
end;

procedure Event024;
{ Inc. Loop Lnge }
begin;
 if Loop_l[inst_akt]+Loop_s[inst_akt] <= Sam_l[inst_akt] then
   inc(loop_l[inst_akt]);
 write_instinfo;
 locate_cursor;
end;

procedure Event025;
{ Volume direkt eingeben }
begin;
  save_screen;
  textcolor(black);
  rahmen(2,16,9,45,5);
  writexy(20,10,' Instrumenten-Lautstrke eingeben');
  writexy(20,12,'Volume : ');
  readln(Inst_vol[inst_akt]);
  restore_screen;
  write_instinfo;
  locate_cursor;
end;

procedure Event026;
{ Dec. Volume }
begin;
  if Inst_vol[inst_akt] > 1 then dec(Inst_vol[inst_akt]);
  write_instinfo;
  locate_cursor;
end;

procedure Event027;
{ Inc. Volume }
begin;
  if Inst_vol[inst_akt] < 64 then inc(Inst_vol[inst_akt]);
  write_instinfo;
  locate_cursor;
end;

procedure Event028;
{ Sampel Namen eingeben }
begin;
  save_screen;
  textcolor(black);
  rahmen(2,16,9,45,5);
  writexy(20,10,' Instrumenten-Namen eingeben');
  writexy(20,12,'Name : ');
  Instnamen[inst_akt] := '                      ';
  readln(Instnamen[inst_akt]);
  restore_screen;
  write_instinfo;
  schreibe_inst(inst_akt);
  locate_cursor;
end;

procedure Event029;
{ Note Stimme 1 }
begin;
  edit_track := 1;
  edit_value := 1;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Note_edit;
end;

procedure Event030;
{ Instument Zehner Stimme 1 }
begin;
  edit_track := 1;
  edit_value := 2;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_zehn_eing;
end;

procedure Event100;
{ Instument Einer Stimme 1 }
begin;
  edit_track := 1;
  edit_value := 3;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_einz_eing;
end;

procedure Event031;
{ Effekt Stimme 1 }
begin;
  edit_track := 1;
  edit_value := 4;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Effekt_eing;
end;

procedure Event032;
{ Operand Zehner Stimme 1 }
begin;
  edit_track := 1;
  edit_value := 5;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_zehn_eing;
end;

procedure Event108;
{ Operand Einer Stimme 1 }
begin;
  edit_track := 1;
  edit_value := 6;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_einz_eing;
end;

procedure Event033;
begin;
  edit_track := 2;
  edit_value := 1;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Note_edit;
end;

procedure Event034;
begin;
  edit_track := 2;
  edit_value := 2;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_zehn_eing;
end;

procedure Event101;
begin;
  edit_track := 2;
  edit_value := 3;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_einz_eing;
end;

procedure Event035;
begin;
  edit_track := 2;
  edit_value := 4;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Effekt_eing;
end;

procedure Event036;
begin;
  edit_track := 2;
  edit_value := 5;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_zehn_eing;
end;

procedure Event109;
begin;
  edit_track := 2;
  edit_value := 6;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_einz_eing;
end;

procedure Event037;
begin;
  edit_track := 3;
  edit_value := 1;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Note_edit;
end;

procedure Event038;
begin;
  edit_track := 3;
  edit_value := 2;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_zehn_eing;
end;

procedure Event102;
begin;
  edit_track := 3;
  edit_value := 3;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_einz_eing;
end;

procedure Event039;
begin;
  edit_track := 3;
  edit_value := 4;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Effekt_eing;
end;

procedure Event040;
begin;
  edit_track := 3;
  edit_value := 5;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_zehn_eing;
end;

procedure Event110;
begin;
  edit_track := 3;
  edit_value := 6;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_einz_eing;
end;

procedure Event041;
begin;
  edit_track := 4;
  edit_value := 1;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Note_edit;
end;

procedure Event042;
begin;
  edit_track := 4;
  edit_value := 2;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_zehn_eing;
end;

procedure Event103;
begin;
  edit_track := 4;
  edit_value := 3;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_einz_eing;
end;

procedure Event043;
begin;
  edit_track := 3;
  edit_value := 4;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Effekt_eing;
end;

procedure Event044;
begin;
  edit_track := 4;
  edit_value := 5;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_zehn_eing;
end;

procedure Event111;
begin;
  edit_track := 4;
  edit_value := 6;
  inc(edit_zeile,(Mausy shr 3) - 22);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_einz_eing;
end;

procedure Event045;
begin;
  edit_track := 5;
  edit_value := 1;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Note_edit;
end;

procedure Event046;
begin;
  edit_track := 5;
  edit_value := 2;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_zehn_eing;
end;

procedure Event104;
begin;
  edit_track := 5;
  edit_value := 3;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_einz_eing;
end;

procedure Event047;
begin;
  edit_track := 5;
  edit_value := 4;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Effekt_eing;
end;

procedure Event048;
begin;
  edit_track := 5;
  edit_value := 5;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_zehn_eing;
end;

procedure Event112;
begin;
  edit_track := 5;
  edit_value := 6;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_einz_eing;
end;

procedure Event049;
begin;
  edit_track := 6;
  edit_value := 1;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Note_edit;
end;

procedure Event050;
begin;
  edit_track := 6;
  edit_value := 2;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_zehn_eing;
end;

procedure Event105;
begin;
  edit_track := 6;
  edit_value := 3;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_einz_eing;
end;

procedure Event051;
begin;
  edit_track := 6;
  edit_value := 4;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Effekt_eing;
end;

procedure Event052;
begin;
  edit_track := 6;
  edit_value := 5;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_zehn_eing;
end;

procedure Event113;
begin;
  edit_track := 6;
  edit_value := 6;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_einz_eing;
end;

procedure Event053;
begin;
  edit_track := 7;
  edit_value := 1;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Note_edit;
end;

procedure Event054;
begin;
  edit_track := 7;
  edit_value := 2;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_zehn_eing;
end;

procedure Event106;
begin;
  edit_track := 7;
  edit_value := 3;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_einz_eing;
end;

procedure Event055;
begin;
  edit_track := 7;
  edit_value := 4;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Effekt_eing;
end;

procedure Event056;
begin;
  edit_track := 7;
  edit_value := 5;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_zehn_eing;
end;

procedure Event114;
begin;
  edit_track := 7;
  edit_value := 6;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_einz_eing;
end;

procedure Event057;
begin;
  edit_track := 8;
  edit_value := 1;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Note_edit;
end;

procedure Event058;
begin;
  edit_track := 8;
  edit_value := 2;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_zehn_eing;
end;

procedure Event107;
begin;
  edit_track := 8;
  edit_value := 3;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Instrument_einz_eing;
end;

procedure Event059;
begin;
  edit_track := 8;
  edit_value := 4;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Effekt_eing;
end;

procedure Event060;
begin;
  edit_track := 8;
  edit_value := 5;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_zehn_eing;
end;

procedure Event115;
begin;
  edit_track := 8;
  edit_value := 6;
  inc(edit_zeile,(Mausy shr 3) - 41);
  if edit_zeile > 56 then edit_zeile := 56;
  if edit_zeile < -7 then edit_zeile := -7;
  schreibe_Pattern(edit_zeile);
  locate_cursor;
  Operand_einz_eing;
end;

procedure Event061;
{ Instrument Nr. 01 }
begin;
  Fenster_active := 2;
  Inst_akt := 1;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event062;
{ Instrument Nr. 02 }
begin;
  Fenster_active := 2;
  Inst_akt := 2;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event063;
{ Instrument Nr. 03 }
begin;
  Fenster_active := 2;
  Inst_akt := 3;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event064;
{ Instrument Nr. 04 }
begin;
  Fenster_active := 2;
  Inst_akt := 4;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event065;
{ Instrument Nr. 05 }
begin;
  Fenster_active := 2;
  Inst_akt := 5;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event066;
{ Instrument Nr. 06 }
begin;
  Fenster_active := 2;
  Inst_akt := 6;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event067;
{ Instrument Nr. 07 }
begin;
  Fenster_active := 2;
  Inst_akt := 7;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event068;
{ Instrument Nr. 08 }
begin;
  Fenster_active := 2;
  Inst_akt := 8;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event069;
{ Instrument Nr. 09 }
begin;
  Fenster_active := 2;
  Inst_akt := 9;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event070;
{ Instrument Nr. 10 }
begin;
  Fenster_active := 2;
  Inst_akt := 10;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event071;
{ Instrument Nr. 11 }
begin;
  Fenster_active := 2;
  Inst_akt := 11;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event072;
{ Instrument Nr. 12 }
begin;
  Fenster_active := 2;
  Inst_akt := 12;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event073;
{ Instrument Nr. 13 }
begin;
  Fenster_active := 2;
  Inst_akt := 13;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event074;
{ Instrument Nr. 14 }
begin;
  Fenster_active := 2;
  Inst_akt := 14;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event075;
{ Instrument Nr. 15 }
begin;
  Fenster_active := 2;
  Inst_akt := 15;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event076;
{ Instrument Nr. 16 }
begin;
  Fenster_active := 2;
  Inst_akt := 16;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event077;
{ Instrument Nr. 17 }
begin;
  Fenster_active := 2;
  Inst_akt := 17;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event078;
{ Instrument Nr. 18 }
begin;
  Fenster_active := 2;
  Inst_akt := 18;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event079;
{ Instrument Nr. 19 }
begin;
  Fenster_active := 2;
  Inst_akt := 19;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event080;
{ Instrument Nr. 20 }
begin;
  Fenster_active := 2;
  Inst_akt := 20;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event081;
{ Instrument Nr. 21 }
begin;
  Fenster_active := 2;
  Inst_akt := 21;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event082;
{ Instrument Nr. 22 }
begin;
  Fenster_active := 2;
  Inst_akt := 22;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event083;
{ Instrument Nr. 23 }
begin;
  Fenster_active := 2;
  Inst_akt := 23;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event084;
{ Instrument Nr. 24 }
begin;
  Fenster_active := 2;
  Inst_akt := 24;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event085;
{ Instrument Nr. 25 }
begin;
  Fenster_active := 2;
  Inst_akt := 25;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event086;
{ Instrument Nr. 26 }
begin;
  Fenster_active := 2;
  Inst_akt := 26;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event087;
{ Instrument Nr. 27 }
begin;
  Fenster_active := 2;
  Inst_akt := 27;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event088;
{ Instrument Nr. 28 }
begin;
  Fenster_active := 2;
  Inst_akt := 28;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event089;
{ Instrument Nr. 29 }
begin;
  Fenster_active := 2;
  Inst_akt := 29;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event090;
{ Instrument Nr. 30 }
begin;
  Fenster_active := 2;
  Inst_akt := 30;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event091;
{ Instrument Nr. 31 }
begin;
  Fenster_active := 2;
  Inst_akt := 31;
  Schreibe_Inst(Inst_akt);
  write_Instinfo;
  if Mauskey = right then begin;  { Inst laden }
    Lade_Instrument(Inst_akt);
  end;
  locate_cursor;
end;

procedure Event092;
{ Copy - Men }
begin;
  select_copy;
  locate_cursor;
end;

procedure Event093;
{ Midi - Men }
begin;
  Midi_select;
  locate_cursor;
end;

procedure Event094;
{ Play }
begin;
  while mauskey <> 0 do;
  Cursor_off;
  mlj := edit_arrang-1;
  mli := 0;
  if Pattern_edited then begin;
    move(actual_Pattern,rm[Lied[edit_arrang]]^,2048);
    Pattern_edited := false;
  end;
  periodisch_on;
  repeat
    if mli = 1 then begin;
      edit_Arrang := mlj;
      fillchar(actual_Pattern,2048,0);
      move(rm[Lied[edit_arrang]]^,actual_Pattern,2048);
      write_Arrangement(edit_arrang);
    end;
    Schreibe_Pattern(mli-8);
  until keypressed or (mauskey <> 0);
  while keypressed do readkey;
  periodisch_off;
  locate_cursor;
  cursor_on;
end;

procedure Event095;
{ Arrangement Pfeil nach links  }
begin;
  if Pattern_edited then begin;
    move(actual_Pattern,rm[Lied[edit_arrang]]^,2048);
  end;
  Pattern_edited := true;
  if Edit_Arrang > 1 then dec(Edit_Arrang);
   fillchar(actual_Pattern,2048,0);
  move(rm[Lied[Edit_arrang]]^,actual_Pattern,2048);
  Schreibe_Pattern(mli-8);
  write_arrangement(Edit_arrang);
  locate_cursor;
end;

procedure Event096;
{ Arrangement Pfeil nach rechts }
begin;
  if Pattern_edited then begin;
    move(actual_Pattern,rm[Lied[edit_arrang]]^,2048);
  end;
  Pattern_edited := true;
  if Edit_Arrang < 128 then inc(Edit_Arrang);
  fillchar(actual_Pattern,2048,0);
  move(rm[Lied[Edit_arrang]]^,actual_Pattern,2048);
  Schreibe_Pattern(mli-8);
  write_arrangement(Edit_arrang);
  locate_cursor;
end;

function lies_arr(laenge,vorgabe : integer) : integer;
var axp,ayp : integer;
    nch,snc : char;
    editstr : string;
    code,ar : integer;
    changed : boolean;
    ende : boolean;
begin;
  changed := true;
  ende := false;
  axp := wherex;
  ayp := wherey;
  if vorgabe > 0 then
    str(vorgabe,editstr)
  else editstr := '';
  while keypressed do readkey;
  nch := #255;
  repeat
    if keypressed then nch := readkey;
    case nch of
     '0'..'9' : begin;
                  changed := true;
                  if length(editstr) < laenge then
                    editstr := editstr + nch
                  else
                    editstr[laenge] := nch;
                  nch := #255;
                end;
           #8 : begin;
                  editstr := copy(editstr,1,length(editstr)-1);
                  nch := #255;
                  changed := true;
                end;
           #27 : begin;
                   ende := true;
                 end;
           #32,
           #13 : begin;
                   ende := true;
                 end;
    end;
    if changed then begin;
      changed := false;
      write_arrangement(Edit_arrang);
      gotoxy(axp,ayp);
      write(editstr:laenge);
    end;
  until ende{ or (mauskey <> 0)};
  if nch <> #27 then begin;
    if length(editstr) = 0 then
      vorgabe := 0
    else
      val(editstr,vorgabe,code);
  end;
  lies_arr := vorgabe;
end;

procedure Event097;
{ Edit Arrangement }
var hilfe : byte;
begin;
  save_screen;
  move(actual_Pattern,rm[Lied[edit_arrang]]^,2048); { Pat. sichern !}
  textcolor(black);
  rahmen(2,16,9,45,5);
  writexy(20,10,' Nummer des Patterns eingeben');
  writexy(20,12,'Pattern : ');
  hilfe := lies_arr(3,Lied[edit_arrang]);

  if hilfe > highest_track then highest_track := hilfe;
  lied[edit_arrang] := hilfe;
  restore_screen;
  fillchar(actual_Pattern,2048,0);
  move(rm[Lied[Edit_arrang]]^,actual_Pattern,2048);
  Schreibe_Pattern(mli-8);
  write_arrangement(Edit_arrang);
  locate_cursor;
end;

procedure Event098;
{ Play Instrument }
begin;
  if sam_l[Inst_akt] > 10 then
    Spiele_Instrument(Inst_Akt);
  locate_cursor;
end;

procedure Event099;
{ Volume direkt ndern }
begin;
  save_screen;
  textcolor(black);
  rahmen(2,16,9,45,5);
  writexy(20,10,' Ausgabe Volume eingeben');
  writexy(20,12,'Volume : ');
  readln(outvolume);
  if outvolume > 63 then outvolume := 63;
  restore_screen;
  writexy(3,4,'Volume    : ');
  write(outvolume:2);
  locate_cursor;
end;

procedure Event116;
{ Dec. Volume }
begin;
  if outvolume > 1 then dec(Outvolume);
  writexy(3,4,'Volume    : ');
  write(outvolume:2);
end;

procedure Event117;
{ Inc. Volume }
begin;
  if outvolume < 64 then inc(Outvolume);
  writexy(3,4,'Volume    : ');
  write(outvolume:2);
end;

procedure interprete_event;
var evnr,ar : word;
begin;
  evnr := 65000;
  if keypressed then begin;  { Taste gedrckt }
    if Sond < #250 then
      cpr := readkey;
    case cpr of
      'q','2','w','3','e','r','5','t','6','z','u','8','i','9','o',
      '0' : begin;
              if Fenster_active = 1 then begin;
                Pattern_edited := true;
                if edit_value = 1 then Note_edit;
                if edit_value = 2 then Instrument_zehn_eing;
                if edit_value = 3 then Instrument_einz_eing;
                if edit_value = 4 then Effekt_eing;
                if edit_value = 5 then Operand_zehn_eing;
                if edit_value = 6 then Operand_einz_eing;
              end;
            end;
       '1','4',
       '7': begin;
              if Fenster_active = 1 then begin;
                Pattern_edited := true;
                if edit_value = 2 then Instrument_zehn_eing;
                if edit_value = 3 then Instrument_einz_eing;
                if edit_value = 4 then Effekt_eing;
                if edit_value = 5 then Operand_zehn_eing;
                if edit_value = 6 then Operand_einz_eing;
              end;
            end;
       'A','B','C','D','E','F','a','b','c','d',
       'f': begin;
              if Fenster_active = 1 then begin;
                Pattern_edited := true;
                if edit_value = 4 then Effekt_eing;
                if edit_value = 5 then Operand_zehn_eing;
                if edit_value = 6 then Operand_einz_eing;
              end;
            end;
       '-': begin;
              Event008;
            end;
       '+': begin;
              Event009;
            end;
      'm',
      'M' : begin; { M  = Play Inst }
              midi_setup;
             end;
      'n',
      'N' : begin; { N = Play Inst }
              restart_scratch;
             end;
       #9 : begin;
              case Fenster_active of
                3 : begin;
                      Fenster_active := 1;
                      Schreibe_Pattern(edit_zeile);
                    end;
                2 : begin;
                      Fenster_active := 3;
                      write_arrangement(edit_arrang);
                    end;
                1 : begin;
                      Fenster_active := 2;
                      schreibe_inst(inst_akt);
                    end;
              end;
              locate_cursor;
            end;
       #32: begin; { Space }
              if Fenster_active = 1 then begin;
                Pattern_edited := true;
                if edit_value = 1 then Note_edit;
                if edit_value = 2 then Instrument_zehn_eing;
                if edit_value = 3 then Instrument_einz_eing;
                if edit_value = 4 then Effekt_eing;
                if edit_value = 5 then Operand_zehn_eing;
                if edit_value = 6 then Operand_einz_eing;
              end;
              if Fenster_active = 2 then begin;
                Lade_Instrument(Inst_akt);
                schreibe_Inst(Inst_akt);
                write_Instinfo;
                locate_cursor;
              end;
              if Fenster_active = 3 then begin;
                Event097;
              end;
            end;
       #13: begin;
              if Fenster_active = 2 then begin;
                Lade_Instrument(Inst_akt);
                schreibe_Inst(Inst_akt);
                write_Instinfo;
                locate_cursor;
              end;
              if Fenster_active = 3 then begin;
                Event097;
              end;
            end;
       #0 : begin;
               sond := readkey;
               case sond of
                #23 : begin; { Alt-I Play Inst }
                        event098;
                      end;
                #25 : begin; { Alt-P = Play Song }
                        event094;
                      end;
                #30 : begin; { Alt-A Arrangement }
                        event097;
                      end;
                #31 : begin; { Alt-S = Save MOD }
                        Event011;
                      end;
                #38 : begin; { Alt-L = Lade Mod }
                        Event010;
                      end;
                #40 : begin; { Alt-X = Ende }
                        event002;
                      end;
                #46 : begin; { Alt-C = Configure }
                        event003;
                      end;
                #59 : begin; { F1 = Hilfe }
                        display_help;
                      end;
                #60 : begin; { F2 = Save MOD }
                        Event011;
                      end;
                #61 : begin; { F3 = Lade Mod }
                        Event010;
                      end;
                #62 : begin; { F4 = Midi Realtime }
                        starte_realtime;
                      end;
                #63 : begin; { F5 = Midi Step by Step }
                        starte_step;
                      end;
                #64 : begin; { F6 = Copy Track }
                        copy_track(edit_track);
                        schreibe_Pattern(edit_zeile);
                        locate_cursor;
                      end;
                #65 : begin; { F7 = Paste Track }
                        paste_track(edit_track);
                        schreibe_Pattern(edit_zeile);
                        locate_cursor;
                      end;
                #66 : begin; { F8 = Copy Pattern }
                        copy_pattern;
                        schreibe_Pattern(edit_zeile);
                        locate_cursor;
                      end;
                #67 : begin; { F9 = Paste Pattern }
                        paste_pattern;
                        schreibe_Pattern(edit_zeile);
                        locate_cursor;
                      end;
                #68 : begin; { F10 = Ende }
                        event002;
                      end;
                #71 : begin; { Pos 1 }
                        if Fenster_active = 1 then begin;
                          edit_zeile := -7;
                          schreibe_Pattern(edit_zeile);
                        end else begin;
                          inst_akt := 1;
                          schreibe_inst(Inst_akt);
                        end;
                        locate_cursor;
                        sond := #0;
                      end;
                #72 : begin; { Pfeil nach oben }
                        if Fenster_active = 1 then begin;
                          if edit_zeile > -7 then dec(edit_zeile);
                          schreibe_Pattern(edit_zeile);
                        end else begin;
                          if inst_akt > 1 then dec(Inst_akt);
                          schreibe_inst(Inst_akt);
                        end;
                        locate_cursor;
                        sond := #0;
                      end;
                #73 : begin; { Bild nach oben }
                        if Fenster_active = 1 then begin;
                          if edit_zeile > 3 then
                            dec(edit_zeile,10)
                          else
                            edit_zeile := -7;
                          schreibe_Pattern(edit_zeile);
                        end else begin;
                          if inst_akt > 11 then dec(inst_akt,10)
                          else inst_akt := 1;
                          schreibe_inst(Inst_akt);
                        end;
                        locate_cursor;
                        sond := #0;
                      end;
                #75 : begin;  { Pfeil nach links }
                        if Fenster_active = 1 then begin;
                          if edit_value > 1 then dec(edit_value)
                          else edit_value := 6;
                          gotoxy(60,1);
                          write(edit_value);
                        end;
                        if Fenster_active = 3 then begin;
                          event095;
                        end;
                        locate_cursor;
                        sond := #0;
                      end;
                #77 : begin;  { Pfeil nach rechts }
                        if Fenster_active = 1 then begin;
                          if edit_value < 6 then inc(edit_value)
                          else edit_value := 1;
                          gotoxy(60,1);
                          write(edit_value);
                        end;
                        if Fenster_active = 3 then begin;
                          event096;
                        end;
                        locate_cursor;
                        sond := #0;
                      end;
                #79 : begin; { Ende }
                        if Fenster_active = 1 then begin;
                          edit_zeile := 56;
                          schreibe_Pattern(edit_zeile);
                        end;
                        if Fenster_active = 2 then begin;
                          inst_akt := 31;
                          schreibe_inst(Inst_akt);
                        end;
                        locate_cursor;
                        sond := #0;
                      end;
                #80 : begin; { Pfeil nach unten}
                        if Fenster_active = 1 then begin;
                          if edit_zeile < 56 then inc(edit_zeile);
                          schreibe_Pattern(edit_zeile);
                        end;
                        if Fenster_active = 2 then begin;
                          if inst_akt < 31 then inc(Inst_akt);
                          schreibe_inst(Inst_akt);
                        end;
                        locate_cursor;
                        sond := #0;
                      end;
                #81 : begin; { Bild nach unten}
                        if Fenster_active = 1 then begin;
                          if edit_zeile < 46 then
                            inc(edit_zeile,10)
                          else
                            edit_zeile := 56;
                          schreibe_Pattern(edit_zeile);
                        end;
                        if Fenster_active = 2 then begin;
                          if inst_akt < 21 then inc(inst_akt,10)
                          else inst_akt := 31;
                          schreibe_inst(Inst_akt);
                        end;
                        locate_cursor;
                        sond := #0;
                      end;
                #82 : begin; { einf}
                        if Fenster_active = 1 then begin;
                          Pattern_edited := true;
                          if edit_value <= 6 then begin;
                            Insert_in_Pattern(edit_zeile+8);
                            schreibe_Pattern(edit_zeile);
                            locate_cursor;
                          end;
                        end;
                        if Fenster_active = 3 then begin;
                          move(actual_Pattern,rm[Lied[edit_arrang]]^,2048);
                          for ar := 127 downto edit_arrang do
                            lied[ar+1] := lied[ar];
                          inc(Liedlaenge);
                          fillchar(actual_Pattern,2048,0);
                          move(rm[Lied[Edit_arrang]]^,actual_Pattern,2048);
                          write_arrangement(edit_arrang);
                          locate_cursor;
                        end;
                       end;
                #83 : begin; { entf}
                        case Fenster_active of
                          1 : begin;
                                Pattern_edited := true;
                                if edit_value <= 6 then begin;
                                  Delete_in_Pattern(edit_zeile+8);
                                  schreibe_Pattern(edit_zeile);
                                  locate_cursor;
                                end;
                              end;
                          3 : begin;
                                move(actual_Pattern,rm[Lied[edit_arrang]]^,2048);
                                { Pat. sichern !}
                                for ar := edit_arrang to 127 do
                                lied[ar] := lied[ar+1];
                                lied[128] := 0;
                                fillchar(actual_Pattern,2048,0);
                                move(rm[Lied[Edit_arrang]]^,actual_Pattern,2048);
                                write_arrangement(edit_arrang);
                                schreibe_Pattern(edit_zeile);
                                locate_cursor;
                              end;
                          end;
                      end;
               #104 : begin; { F1 = Copyright }
                        display_copyright;
                      end;
               #105 : begin; { F2 = Sampel Speichern }
                        event013;
                      end;
               #106 : begin; { F3 = Sampel Laden }
                        event012;
                      end;
               #107 : begin; { F4 = Track Speichern }
                        event017;
                      end;
               #108 : begin; { F5 = Track Laden }
                        event016;
                      end;
               #109 : begin; { F6 = Pattern Speichern }
                        event015;
                      end;
               #110 : begin; { F7 = Pattern Laden }
                        event014;
                      end;
               #111 : begin; { F8 = Play Song }
                        event094;
                      end;
               #112 : begin; { F9 =  }
                        event095;
                      end;
              #113 : begin; { F10 =  }
                        event096;
                    end;
              #115 : begin; { Strg-Pfeil nach links }
                        if edit_track > 1 then dec(edit_track)
                        else edit_track := 8;
                        locate_cursor;
                        sond := #0;
                      end;
               #116 : begin; { Strg-Pfeil nach rechts }
                        if edit_track < 8 then inc(edit_track)
                        else edit_track := 1;
                        locate_cursor;
                        sond := #0;
                      end;
              end;
            end;
      end;
  end else begin;            { Maus gedrckt  }
    evnr := which_kasten;
  end;
  if evnr < 65000 then begin;
    cpr := #255;
    case evnr of
      001 : begin; Event001; end;
      002 : begin; Event002; end;
      003 : begin; Event003; end;
      004 : begin; Event004; end;
      005 : begin; Event005; end;
      006 : begin; Event006; end;
      007 : begin; Event007; end;
      008 : begin; Event008; end;
      009 : begin; Event009; end;
      010 : begin; Event010; end;
      011 : begin; Event011; end;
      012 : begin; Event012; end;
      013 : begin; Event013; end;
      014 : begin; Event014; end;
      015 : begin; Event015; end;
      016 : begin; Event016; end;
      017 : begin; Event017; end;
      018 : begin; Event018; end;
      019 : begin; Event019; end;
      020 : begin; Event020; end;
      021 : begin; Event021; end;
      022 : begin; Event022; end;
      023 : begin; Event023; end;
      024 : begin; Event024; end;
      025 : begin; Event025; end;
      026 : begin; Event026; end;
      027 : begin; Event027; end;
      028 : begin; Event028; end;
      029 : begin; Event029; end;
      030 : begin; Event030; end;
      031 : begin; Event031; end;
      032 : begin; Event032; end;
      033 : begin; Event033; end;
      034 : begin; Event034; end;
      035 : begin; Event035; end;
      036 : begin; Event036; end;
      037 : begin; Event037; end;
      038 : begin; Event038; end;
      039 : begin; Event039; end;
      040 : begin; Event040; end;
      041 : begin; Event041; end;
      042 : begin; Event042; end;
      043 : begin; Event043; end;
      044 : begin; Event044; end;
      045 : begin; Event045; end;
      046 : begin; Event046; end;
      047 : begin; Event047; end;
      048 : begin; Event048; end;
      049 : begin; Event049; end;
      050 : begin; Event050; end;
      051 : begin; Event051; end;
      052 : begin; Event052; end;
      053 : begin; Event053; end;
      054 : begin; Event054; end;
      055 : begin; Event055; end;
      056 : begin; Event056; end;
      057 : begin; Event057; end;
      058 : begin; Event058; end;
      059 : begin; Event059; end;
      060 : begin; Event060; end;
      061 : begin; Event061; end;
      062 : begin; Event062; end;
      063 : begin; Event063; end;
      064 : begin; Event064; end;
      065 : begin; Event065; end;
      066 : begin; Event066; end;
      067 : begin; Event067; end;
      068 : begin; Event068; end;
      069 : begin; Event069; end;
      070 : begin; Event070; end;
      071 : begin; Event071; end;
      072 : begin; Event072; end;
      073 : begin; Event073; end;
      074 : begin; Event074; end;
      075 : begin; Event075; end;
      076 : begin; Event076; end;
      077 : begin; Event077; end;
      078 : begin; Event078; end;
      079 : begin; Event079; end;
      080 : begin; Event080; end;
      081 : begin; Event081; end;
      082 : begin; Event082; end;
      083 : begin; Event083; end;
      084 : begin; Event084; end;
      085 : begin; Event085; end;
      086 : begin; Event086; end;
      087 : begin; Event087; end;
      088 : begin; Event088; end;
      089 : begin; Event089; end;
      090 : begin; Event090; end;
      091 : begin; Event091; end;
      092 : begin; Event092; end;
      093 : begin; Event093; end;
      094 : begin; Event094; end;
      095 : begin; Event095; end;
      096 : begin; Event096; end;
      097 : begin; Event097; end;
      098 : begin; Event098; end;
      099 : begin; Event099; end;
      100 : begin; Event100; end;
      101 : begin; Event101; end;
      102 : begin; Event102; end;
      103 : begin; Event103; end;
      104 : begin; Event104; end;
      105 : begin; Event105; end;
      106 : begin; Event106; end;
      107 : begin; Event107; end;
      108 : begin; Event108; end;
      109 : begin; Event109; end;
      110 : begin; Event110; end;
      111 : begin; Event111; end;
      112 : begin; Event112; end;
      113 : begin; Event113; end;
      114 : begin; Event114; end;
      115 : begin; Event115; end;
      116 : begin; Event116; end;
      117 : begin; Event117; end;
    end;
    delay(200);
  end;
end;

Procedure Handle_Events;
begin;
  repeat
    if (MausKey <> 0) or keypressed then
      interprete_event;
  until Programmende;
end;

procedure Ende_all;
begin;
  MausPfeilAus;
end;

begin;
  Init_the_mod;
  initialisiere_Variablen;
  Zeichne_Desktop;
  display_copyright;
  lade_setup;
  Handle_Events;
  Ende_all;
  chdir(setup.main);
  textmode(3);
  norm_cursor;
  ende_mod;
end.

