unit neumod;

interface uses crt,dos,variab;

{ $define seffects}
{ $define fdebug}



const block_activ : byte = 1;
var   fgr : longint;
      blk1,blk2 : pointer;
    intpointer : pointer;
var dsp_rdy_voc : boolean;
    blockgr : word;
    PLAYING_MOD : boolean;
    PLAYING_VOC : boolean;
    dummarray : array[1..20] of byte;
    lastone : boolean;

    inread : array[1..25] of byte;
    vocsstereo : boolean;
    Mod_zu_ende : boolean;

    performance : longint;
    perfcount : word;


 procedure init_sb;
 {
  Die Procedure init_sb initialisiert die Soundblaster-Karte. Sie
  erkennt automatisch Base-Adress und IRQ, prft, um welche Sound-
  blasterversion es sich handelt und setzt entsprechende globale
  Variablen, die z.B. mittels write_sbConfig ausgegeben werden knnen
 }

 procedure dsp_block_sb16(gr : word;bk : pointer;b1,b2 : boolean);
 {
  Spielt den ber blk adressierten Block via DMA ab
 }

 procedure mod_waitretrace(num : byte);
 {
  Das Warten auf einen Bildschirm-Retrace sollte mit dieser Procedure
  erfolgen, wenn MOD's abgespielt werden (sonst Ruckeln)
 }

 procedure mod_autodetect(what : boolean);
 {
  Setzt die Speed-Erkennung ON/OFF
 }

 procedure mod_SetSpeed(msp : word);
 {
  Setzt die Variable "Speed"
 }

 procedure mod_SetLoop(msl : word);
 {
  Setzt die Variable "Sound_Schleifen"
 }

 procedure MODExitProc;

 procedure mod_SetLoopflag(loopen : boolean);
 {
  Setzt ON/OFF, ob eine zu Ende abgespielte Moddatei wieder von
  Anfang an abgespielt wird
 }

 procedure mod_transpose(transposerwert : integer);
 {
  Setzt den Transposer-Wert. Evtl. fr Soundeffekte zu gebrauchen,
  um einen Ton hoch- oder runterzuziehen. Sonst NICHT verndern.
 }

 procedure mod_Samplefreq(Rate : integer);
 {
  Setzt die Samplefrequenz fr die Ausgabe. Wert*1000 = Frequenz.
  Zulssige Werte sind 8,10,16,22
 }

 function lade_moddatei(modname : string;ispeed,iloop : integer;freq : byte) : integer;
 {
  Ld die unter modname angegebene Moddatei. Mittels ispeed und iloop
  knnen die Variablen "Speed" und "Sound_Schleifen" vorgegeben
  werden, sinnvoller ist jedoch die Angabe AUTO fr beide Werte
 }

 procedure ende_mod;
 {
  Beendet das Abspielen einer Mod-Datei und entfernt sie aus
  dem Speicher
 }

 procedure periodisch_on;
 {
  Schaltet das Abspielen einer MOD-Datei ein. Mu zum Starten
  aufgerufen werden
 }

 procedure periodisch_off;
 {
  Hlt das Abspielen einer MOD-Datei an. Die MOD-Datei bleibt im
  Speicher und kann ber periodisch_on wieder gestartet werden
 }

 procedure write_sbConfig;
 {
  Gibt die gefundene Konfiguration aus (Textmodus !). Alternativ:
  Direkter Zugriff auf die entsprechenden Variablen.
 }

 procedure getmem_XMS(Hdlidx : byte;groesse : word);
 {
  Reserviert "groesse" KB XMS-Speicher, der ber Hdlidx indiziert
  wird
 }

 procedure dispose_XMS(Hdlidx : byte);
 {
  Gibt den ber Hdlidx indizierten XMS-Speicherbereich frei
 }

 procedure Ram_2_XMS(Sorce : pointer;Laenge : longint;Hdlidx : byte);
 {
  Kopiert Laenge Byte aus dem Ram (Adresse: Source) in den ber
  Hdlidx indizierten XMS-Speicherbereich
 }

 procedure XMS_2_Ram(Hdlidx : byte;Laenge : longint;Dest : pointer);
 {
  Kopiert Laenge Byte aus dem ber Hdlidx indizierten XMS-
  Speicherbereich in das Ram (Adresse: Dest)
 }

 function  pruefe_Minxms(minw : word) : integer;
 {
  Prft, ob wenigstens minw KB freier XMS-Speicher vorhanden ist
 }

 function Lade_Soundeffekt(s : string;var ef : effect_type) : integer;
 {
  Ld den in String bergebenen Soundeffekt, der Effekt-Handle wird in
  ef geschrieben
 }

 procedure dispose_Soundeffekt(ef : effect_type);
 {
  Gibt den von einem Soundeffekt belegten Speicher wieder frei
 }

 procedure Starte_Soundeffekt(ef:effect_type;frequenz,Vol,styp : word);
 {
  Startet die Ausgabe des in ef bergebenen Soundeffekts. Fr Frequenz
  kann die Frequenz in Hz oder DETECT bergeben werdem, wenn eine .VOC-
  Datei geladen wurde.
 }

 procedure calculate_music;
 {
  Berechnet ein Teilstck Musik. Wird Periodisch oder in einer Schleife
  aufgerufen
 }

 procedure Filter_Ein;
 {
  Schaltet den XBass-Filter ein
 }

 procedure Filter_MID;
 {
  Schaltet den Filter auf Normalbetrieb
 }
 procedure Filter_Aus;
 {
  Schaltet den Filter auf Hhen-Hervorhebung
 }

 procedure Set_Balance(Wert : byte);
 {
  Die Procedure Setzt die Balance entsprechend dem bergebenen Wert.
  Dabei steht 0 fr ganz links, 12 fr Mitte und 24 fr ganz rechts
 }

 procedure Set_Volume(Wert : byte);
 {
  Die Procedure setzt die Lautstrke fr die generelle (!) Ausgabe
  (Master Volume). Erlaubte Werte liegen zwischen 0 und 31
 }

 procedure wr_dsp_sb16(v : byte);
 {
  Schreibt den bergebenen Wert in das Soundblaster-Register
 }

 function init_The_Mod : boolean;
 {
  Initiatisiert die .MOD-Routienen. Resettet den SB und setzt bentigte
  Variablen
 }

 FUNCTION Reset_sb16 : BOOLEAN;
 {
  Resettet die SB-Karte. Liefert TURE, wenn erfolgreich
 }

 procedure Set_Timeconst_sb16(tc : byte);
 {
  Setzt die Timer-Konstante die nach der Formel
  tc := 256-(1.000.000 / Frequenz) berechnet wird
 }

 procedure Fade_Musix_out;
 {
  Zieht die Lautstrke langsam runter. Z.B fr Programmende einsetzten
 }

 procedure Spiele_Sb(Segm,Offs,dsize : word);
 {
  Spielt den adressierten Block ber DMA ab. Fr SB / SB Pro
 }

 procedure Spiele_Sb16(Segm,Offs,dsize : word);
 {
  Spielt den adressierten Block ber DMA ab. Fr SB 16
 }

 procedure init_data;
 {
  Initialisiert die Variablen der Unit
 }


var SaveExitProc : Pointer;             { Ntig, da eigene Exitproc  }
 mycli : byte;                          { Flag, ob Soundberechnung   }
                                        { aktiv                      }
 music_played : boolean;                { Flag, TRUE wenn Musik ge-  }
                                        { spielt wurde               }
implementation

type
 Hex        = string[4];                { Hexadezimalstring          }
 xregisters = record                    { Typdeklaration Parameter   }
                 ax,                    { fr XMS-Fkt.-aufrufe       }
                 bx,
                 dx,
                 si : word;
               end;

 transfer   = record                    { fr XMS                    }
                Blocklen   : longint;
                SrcHandle  : word;
                SrcOffset  : pointer;
                DestHandle : word;
                DestOffset : pointer;
              end;
const
 Speed3 : word = 58;                    { Zum modifizieren von Speed }
 Loop3  : word = 42;                    { fr XMS-Fkt.-aufrufe       }

Var
 XMSDrv     : pointer;                  { XMM-Einsprungadresse       }
 XReg,XRegs : xregisters;               { fr Mpx-Int- und XMM-Auf-  }
                                        { rufe                       }
 XMSExists,                             { true: XMS installiert      }
 HMAExists  : boolean;                  { true: HMA vorhanden        }
 XMSVersion,                            { XMS-Version (BCD-kodiert)  }
 XMMVersion : word;                     { XMM-Version (BCD-kodiert)  }
 XMSResult,                             { im Assemblerteil deklariert}
 EMSResult  : byte;
 EMBParam   : Transfer;
 tonhoehe : word;                       { Der Wert der Tonhhe, wie  }
                                        { er in der MOD-Datei steht  }
 ziel : pt;                             { Abspielpuffer im pt-Format }
 Modp  : pointer;                       { Pointer auf Rm_Song        }
 note1,note2,                           { Aktives Instument der      }
 note3,note4,                           { Stimme                     }
 note5,note6,
 note7,note8 :byte;
 lax,lbx,lcx,ldx,                       { Hilfsvariablen zur Siche-  }
 lsi,ldi,les,lds : word;                { rung der Register          }
 yax,ybx,ycx,ydx,                       { Hiyfsvariabyen zur Siche-  }
 ysi,ydi,yes,yds : word;                { rung der Register          }
 altx,alty : integer;



{$L modasm2}
procedure MPXCall(var XRegs : xregisters); external;
procedure XMSCall(var XRegs : xregisters); external;

procedure wr_dsp_sb16(v : byte);
{
 Wartet, bis der DSP zum Schreiben bereit ist, und schreibt dann das
 in "v" bergebene Byte in den DSP
}
begin;
  while port[dsp_adr+$c] >= 128 do ;
  port[dsp_adr+$c] := v;
end;

FUNCTION SbReadByte : BYTE;
{
 Die Function wartet, bis der DSP gelesen werden kann und liefert den
 gelesenen Wert zurck
}
begin;
  while port[dsp_adr+$a] = $AA do ;     { warten, bis DSP ready      }
  SbReadByte := port[dsp_adr+$a];       { Wert schreiben             }
end;

procedure SBreset;
VAR bt,ct, stat : BYTE;
begin;
  PORT[dsp_adr+$6] := 1;                { dsp_adr+$6 = Resettfunktion}
  FOR ct := 1 TO 100 DO;
  PORT[dsp_adr+$6] := 0;
  bt := 0;
  repeat
    ct := 0;
    repeat
      stat := port[dsp_adr + $E];
    until (ct > 8000) or (stat >= 128);
    inc(bt);
  until (bt > 100) or (port[dsp_adr + $A] = $AA);
end;

FUNCTION Reset_sb16 : BOOLEAN;
{
 Die Function resetet den DSP. War das Resetten erfolgreich, wird
 TRUE zurckgeliefert, ansonsten FALSE
}
CONST  ready = $AA;
VAR ct, stat : BYTE;
BEGIN
  PORT[dsp_adr+$6] := 1;                { dsp_adr+$6 = Resettfunktion}
  FOR ct := 1 TO 100 DO;
  PORT[dsp_adr+$6] := 0;
  stat := 0;
  ct   := 0;                            { Der Vergleich ct < 100, da }
  WHILE (stat <> ready)                 { die Initialisierung ca.    }
  AND   (ct < 100)      DO BEGIN        { 100ms dauert               }
    stat := PORT[dsp_adr+$E];
    stat := PORT[dsp_adr+$a];
    INC(ct);
  END;
  Reset_sb16 := (stat = ready);
END;

FUNCTION Detect_Reg_sb16 : BOOLEAN;
{
 Die Funktion liefert TRUE zurck, wenn ein Soundblaster initialisiert
 werden konnte, ansonsten FALSE. Die Variable dsp_adr wird auf die
 Base-Adresse des SB gesetzt.
}
VAR
  Port, Lst : WORD;
BEGIN
 Detect_Reg_sb16 := SbRegDetected;
 IF SbRegDetected THEN EXIT;            { Exit, wenn initialisiert   }
 Port := Startport;                     { Mgliche SB-Adressen zwi-  }
 Lst  := Endport;                       { schen $210 und $280 !      }
 WHILE (NOT SbRegDetected)
 AND   (Port <= Lst)  DO BEGIN
   dsp_adr := Port;
   SbRegDetected := Reset_sb16;
   IF NOT SbRegDetected THEN
     INC(Port, $10);
 END;
 Detect_Reg_sb16 := SbRegDetected;
END;

PROCEDURE Write_Mixer(Reg, Val: BYTE);
{
 Schreibt den in Val bergebenen Wert an das in Reg angegebene
 Register des Mixer - Chips
}
begin;
 Port[dsp_adr+$4] := Reg;
 Port[dsp_adr+$5] := Val;
END;


FUNCTION Read_Mixer(Reg: BYTE) : BYTE;
{
 Die Function liefert den Inhalt des ber Reg indizierten Registers
 des Mixer-Chips
}
begin;
  Port[dsp_adr+$4] := Reg;
  Read_Mixer := Port[dsp_adr+$5];
end;

procedure Filter_Ein;
{
 Diese Procedure Stellt den Tiefen Filter ein bzw. regelt das
 Bass/Treble Register entsprechend
}
var hilfe : byte;
begin;
 if sb16detected then begin;
   write_Mixer(68,64);                  { Treble runter              }
   write_Mixer(69,64);
   write_Mixer(70,255);                 { Bass voll Power !          }
   write_Mixer(71,255);                 { Bass voll Power !          }
 end else begin;
   hilfe := read_Mixer($0c);            { Tiefer Filter              }
   hilfe := hilfe or 8;
   Write_Mixer($0c,hilfe);
   hilfe := read_Mixer($0e);            { Filter einschalten         }
   hilfe := hilfe AND 2;
   write_Mixer($0e,hilfe);
 end;
end;

procedure Filter_MID;
{
 Diese Procedure Stellt den Tiefen Filter ein bzw. regelt das
 Bass/Treble Register entsprechend
}
var hilfe : byte;
begin;
 if sb16detected then begin;
   write_Mixer(68,160);                  { Treble runter              }
   write_Mixer(69,160);
   write_Mixer(70,192);                 { Bass voll Power !          }
   write_Mixer(71,192);                 { Bass voll Power !          }
 end else begin;
   hilfe := read_Mixer($0e);            { Filter ausschalten         }
   hilfe := hilfe OR 32;
   write_Mixer($0e,hilfe);
 end;
end;

procedure Filter_aus;
var hilfe : byte;
begin;
 if sb16detected then begin;
   write_Mixer(68,192);                 { zurck auf default         }
   write_Mixer(69,192);
   write_Mixer(70,160);
   write_Mixer(71,160);
 end else begin;
   hilfe := read_Mixer($0c);            { Hhen-Filter               }
   hilfe := hilfe OR 247;
   Write_Mixer($0c,hilfe);
   hilfe := read_Mixer($0e);            { Filter einschalten         }
   hilfe := hilfe AND 2;
   write_Mixer($0e,hilfe);
 end;
end;

procedure Set_Balance(Wert : byte);
{
 Die Procedure Setzt die Balance entsprechend dem bergebenen Wert.
 Dabei steht 0 fr ganz links, 12 fr Mitte und 24 fr ganz rechts
}
Var left,right : byte;
begin;
 if Sb16Detected then begin;
   left  := 12;
   right := 12;
   if Wert < 12 then right := wert;
   if Wert > 12 then left  := 24-Wert;
   write_Mixer(50,(left  shl 4));
   write_Mixer(51,(right shl 4));
 end else begin;
  Wert := Wert SHR 1;
  case Wert of
     0..6 : begin;
               write_Mixer(02,(7 shl 5)+(Wert shl 1));
             end;
       07 : begin;
               write_Mixer(02,(7 shl 5)+(7 shl 1));
             end;
	  08..13 : begin;
               write_Mixer(02,((13-Wert) shl 5)+(7 shl 1));
	           end;
	 end;
 end;
end;

procedure Set_Volume(Wert : byte);
{
 Zum Setzen der Abspiel-Lautstrke. Zulssige Werte von 0 bis 31
}
begin;
  if sb16detected then begin;
    write_Mixer(48,(Wert shl 3));
    write_Mixer(49,(Wert shl 3));
  end else begin;
    if MixerDetected then begin;
      Wert := Wert Shr 2;
      write_Mixer($22,(wert shl 5) + (wert shl 1));
    end else begin;
      outvolume := Wert shl 1;
    end;
  end;
end;

procedure reset_Mixer; assembler;
{
 Resettet den Mixer Chip auf seine Default - Werte
}
asm
  mov dx,dsp_adr+$4
  mov al,0
  out dx,al
  mov cx,50
@loop:
  loop @loop
  inc dx
  out dx,al
end;

FUNCTION Detect_Mixer_sb16 : BOOLEAN;
{
 Function zu Erkennung des Mixer-Chips. TRUE, wenn der Mixer gefunden
 wurde, ansonsten FALSE
}
VAR SaveReg : WORD;
    NewReg  : WORD;
BEGIN
  Detect_Mixer_sb16 := MixerDetected;
  IF (NOT SbRegDetected)                { Abbruch, wenn keine Sound- }
  OR MixerDetected THEN EXIT;           { blaster-Karte vorhanden    }
                                        { oder Mixer-Chip schon      }
                                        { initalisiert               }
  Reset_Mixer;
  SaveReg := Read_Mixer($22);           { Register sichern           }
  Write_Mixer($22, 243);                { Wenn der geschribene wert  }
  NewReg  := Read_Mixer($22);           { mit dem zurckgelesenen    }
                                        { bereinstimmt, so ist ein  }
                                        { Zugriff mglich und somit  }
                                        { ein Mixer vorhanden        }
  IF NewReg = 243 THEN begin;
    MixerDetected := TRUE;
    STEREO := True;
  end;
  Write_Mixer($22, SaveReg);            { Altes Register zurck      }
  Detect_Mixer_sb16 := MixerDetected;
END;

PROCEDURE SbGetDSPVersion;
VAR i : WORD;
    t : WORD;
    s : STRING[2];
BEGIN
  wr_dsp_sb16($E1);                     { $E1 = Versionsabfrage      }
  SbVersMaj := SbReadByte;
  SbVersMin := SbReadByte;
  str(SbVersMaj, SbVersStr);
  SbVersStr := SbVersStr + '.';
  str(SbVersMin, s);
  if SbVersMin > 9 then
    SbVersStr := SbVersStr +       s
  else
    SbVersStr := SbVersStr + '0' + s;
END;

function wrt_dsp_adr_sb16 : string;
{
 Liefert die Base-Adresse des SB als String zurck
}
begin;
  case dsp_adr of
    $210 : wrt_dsp_adr_sb16 := '210';
    $220 : wrt_dsp_adr_sb16 := '220';
    $230 : wrt_dsp_adr_sb16 := '230';
    $240 : wrt_dsp_adr_sb16 := '240';
    $250 : wrt_dsp_adr_sb16 := '250';
    $260 : wrt_dsp_adr_sb16 := '260';
    $270 : wrt_dsp_adr_sb16 := '270';
    $270 : wrt_dsp_adr_sb16 := '280';
   END;
end;

function wrt_dsp_irq : string;
{
 Liefert den IRQ des SB als String zurck
}
begin;
  case dsp_irq of
     $2 : wrt_dsp_irq := '2 h';
     $3 : wrt_dsp_irq := '3 h';
     $5 : wrt_dsp_irq := '5 h';
     $7 : wrt_dsp_irq := '7 h';
    $10 : wrt_dsp_irq := '10 h';
   END;
end;

procedure Set_Timeconst_sb16(tc : byte);
{
 Procedure zum setzen der Time-Konstanten. Sie berechnet sich nach der
 Formel  tc := 256 - (1000000 / Frequenz).
}
begin;
  wr_dsp_sb16($40);                     { $40 = Setze Sample Rate    }
  wr_dsp_sb16(tc);
end;

procedure test_uebertragung;
begin;
   getmem(blk,3000);
   fillchar(blk^,3000,127);
   blockgroesse := 2000;
   letzte_ausgabe := true;
   Sampling_Rate := 211;
   dsp_block_sb16(blockgroesse,blk,true,false);
   delay(100);
   freemem(blk,3000);
end;

procedure write_sbConfig;
{
 Die Procedure gibt die gefundene Konfiguration auf dem Bildschirm
 aus. Sie dient vornehmlich als Beispiel, wie die Informationen
 verwendet werden knnen
}
begin;
  clrscr;
  if SbRegDetected then begin;
    writeln('Soundkarte an Base ',wrt_dsp_adr_sb16,'h mit IRQ ',
    wrt_dsp_irq,' gefunden.');
  end else begin;
    writeln('Keine Soundblaster-kompatibele Karte gefunden !');
  end;
  if MixerDetected then begin;
    writeln('Mixer - Chip gefunden');
    if SbVersMaj < 4 then
      writeln('Die gefundene Karte ist',
			' ein Soundblaster Pro oder kompatibel')
    else
      writeln('Die gefundene Karte ist',
      ' ein Soundblaster 16 ASP oder kompatibel');
  end else begin;
    writeln('Die gefundene Karte ist',
    ' ein Soundblaster oder kompatibel');
  end;
  writeln('Die Versionsnummer lautet ',SbVersStr);
end;

procedure Exit_Sb16;
{
 Diese Prozedur wir beim Beenden des Programms aufgerufen und setzt
 den verbogenen DMA-Interrupt auf seinen Ausgangswert
}
begin;
  setintvec($8+dsp_irq,oldint);         { Alten Interrupt wieder her-}
  port[$21] := Port[$21] or irqmsk;     { stellen und Maskierung auf }
  port[dsp_adr+$c] := $d3;              { alten Wert zurck          }
  Port[$20] := $20;
  wr_dsp_sb16($D0);
end;

procedure Spiele_Sb16(Segm,Offs,dsize : word);
{
 Diese Procedure spielt den ber Segm:Offs adressierten Block mit der
 Gre dsize ab. Es ist darauf zu achten, das der DMA-Controller NICHT
 Seitenbergreifend arbeiten kann ...
}
var li : word;
begin;
  port[$0A] := dma_ch+4;                { DMA-Kanal sperren          }
  Port[$0c] := 0;                       { Adresse des Puffers (blk)  }
  Port[$0B] := $49;                     { fr Soundausgabe           }
  Port[dma_adr[dma_ch]] := Lo(offs);    { an DMA-Controller          }
  Port[dma_adr[dma_ch]] := Hi(offs);
  Port[dma_wc[dma_ch]] := Lo(dsize-1);  { Gre des Blockes (block-  }
  Port[dma_wc[dma_ch]] := Hi(dsize-1);  { groesse) an DMA-Controller }
  Port[dma_page[dma_ch]] := Segm;
  if sb16_outputlaenge <> dsize then begin;
    wr_dsp_sb16($C6);                   { DSP-Befehl 8-Bit ber DMA  }
    if stereo then                      { fr SB16 Nur zum Starten ! }
      wr_dsp_sb16($20)
    else
      wr_dsp_sb16($00);
    wr_dsp_sb16(Lo(dsize-1));           { Gre des Blockes an       }
    wr_dsp_sb16(Hi(dsize-1));           { den DSP                    }
    sb16_outputlaenge := dsize;
  end else begin;
    wr_dsp_sb16($45);                   { DMA Continue SB16 8-Bit    }
  end;
  Port[$0A] := dma_ch;                  { DMA-Kanal freigeben        }
end;

procedure Spiele_Sb(Segm,Offs,dsize : word);
{
 Diese Procedure spielt den ber Segm:Offs adressierten Block mit der
 Gre dsize ab. Es ist darauf zu achten, das der DMA-Controller NICHT
 Seitenbergreifend arbeiten kann ...
}
var li : word;
begin;
  port[$0A] := dma_ch+4;                { DMA-Kanal sperren          }
  Port[$0c] := 0;                       { Adresse des Puffers (blk)  }
  Port[$0B] := $49;                     { fr Soundausgabe           }
  Port[dma_adr[dma_ch]] := Lo(offs);    { an DMA-Controller          }
  Port[dma_adr[dma_ch]] := Hi(offs);
  Port[dma_wc[dma_ch]] := Lo(dsize-1);  { Gre des Blockes (block-  }
  Port[dma_wc[dma_ch]] := Hi(dsize-1);  { groesse) an DMA-Controller }
  Port[dma_page[dma_ch]] := Segm;
  wr_dsp_sb16($14);
  wr_dsp_sb16(Lo(dsize-1));             { Gre des Blockes an       }
  wr_dsp_sb16(Hi(dsize-1));             { den DSP                    }
  Port[$0A] := dma_ch;                  { DMA-Kanal freigeben        }
end;

procedure Spiele_SbPro(Segm,Offs,dsize : word);
{
 Diese Procedure spielt den ber Segm:Offs adressierten Block mit der
 Gre dsize ab. Es ist darauf zu achten, das der DMA-Controller NICHT
 Seitenbergreifend arbeiten kann ...
}
var li : word;
begin;
  port[$0A] := dma_ch+4;                { DMA-Kanal sperren          }
  Port[$0c] := 0;                       { Adresse des Puffers (blk)  }
  Port[$0B] := $49;                     { fr Soundausgabe           }
  Port[dma_adr[dma_ch]] := Lo(offs);    { an DMA-Controller          }
  Port[dma_adr[dma_ch]] := Hi(offs);
  Port[dma_wc[dma_ch]] := Lo(dsize-1);  { Gre des Blockes (block-  }
  Port[dma_wc[dma_ch]] := Hi(dsize-1);  { groesse) an DMA-Controller }
  Port[dma_page[dma_ch]] := Segm;

  wr_dsp_sb16($48);
  wr_dsp_sb16(Lo(dsize-1));             { Gre des Blockes an       }
  wr_dsp_sb16(Hi(dsize-1));             { den DSP                    }
  wr_dsp_sb16($91);
  Port[$0A] := dma_ch;                  { DMA-Kanal freigeben        }
end;

procedure dsp_block_sb16(gr : word;bk : pointer;b1,b2 : boolean);
{
 Diese Procedure startet die Ausgabe des Daten-Blocks blk mit der
 Gre blockgroesse ber DMA
}
var l : longint;
    pn,offs : word;
    hbyte : byte;
    a : word;
    OldV,NewV,Hilfe : byte;
    stereoreg : byte;
    sr : word;
    samps : byte;
begin;
  PLAYING_MOD := b1;
  PLAYING_VOC := b2;

  dsp_rdy_sb16 := false;
  l := 16*longint(pt(bk).sgm)+pt(bk).ofs;
  pn := pt(l).sgm;
  offs := pt(l).ofs;

  if PLAYING_MOD then begin;
    set_timeconst_sb16(Sampling_Rate);
    if sb16Detected then begin;
      if stereo then
        Spiele_Sb16(pn,offs,gr*2)
      else
        Spiele_Sb16(pn,offs,gr);
    end else begin;
      if stereo then begin;
        SR := word(-1000000 DIV (Sampling_Rate-256));
        SR := SR * 2;
        Samps := 256 - (1000000 DIV SR);
        set_timeconst_sb16(Samps);
        Spiele_SbPro(pn,offs,gr*2);
      end else
        Spiele_Sb(pn,offs,gr);
    end;
  end;

end;

procedure memmovew(q,d : pt;anzahl : word); assembler;
{
 Procedure zum schnellen kopieren von zwei Speicherbereichen.
 berlappungen werden nicht bercksichtigt
}
asm
  push ds
  mov si,q.sgm
  mov ds,si
  mov si,q.ofs
  mov di,d.sgm
  mov es,di
  mov di,d.ofs
  mov cx,anzahl
  rep movsw
  pop ds
end;

procedure sreg; assembler;
{
 Sichert die Register in die Variablen lax bis ldi
 Eigene Procedure weil Pusha / Popa Probleme bereitet !
}
asm
 mov lax,ax
 mov lbx,bx
 mov lcx,cx
 mov ldx,dx
 mov lsi,si
 mov ldi,di
 mov ax,es
 mov les,ax
 mov ax,ds
 mov lds,ax
end;

procedure rreg; assembler;
{
 Stellt die Register mit den Werten aus lax bis ldi wieder her
 Eigene Procedure weil Pusha / Popa Probleme bereitet !
}
asm
 mov bx,lbx
 mov cx,lcx
 mov dx,ldx
 mov si,lsi
 mov di,ldi
 mov ax,les
 mov es,ax
 mov ax,lds
 mov ds,ax
 mov ax,lax
end;

procedure syreg; assembler;
{
 Sichert die Register in die Variablen lax bis ldi
 Eigene Procedure weil Pusha / Popa Probleme bereitet !
}
asm
 mov yax,ax
 mov ybx,bx
 mov ycx,cx
 mov ydx,dx
 mov ysi,si
 mov ydi,di
 mov ax,es
 mov yes,ax
 mov ax,ds
 mov yds,ax
end;

procedure ryreg; assembler;
{
 Steyyt die Register mit den Werten aus yax bis ydi wieder her
 Eigene Procedure weil Pusha / Popa Probleme bereitet !
}
asm
 mov bx,ybx
 mov cx,ycx
 mov dx,ydx
 mov si,ysi
 mov di,ydi
 mov ax,yes
 mov es,ax
 mov ax,yds
 mov ds,ax
 mov ax,yax
end;

procedure get_pctune(hoehe : word;Var vk : word;VAR nk,dif : byte);
{
 Die Procedure ermittelt aus der bergebenen Tonhhe (so wie sie in
 der MOD-Datei steht) die fr die Frequenz-Manipulation bentigten
 Vor- und Nachkommastellen.
}
var nct : byte;
    gefunden : boolean;
begin;
 nct := 1;
 gefunden := false;
 while (nct < 60) and not gefunden do   { Bis gefunden oder letzter  }
 begin;                                 { Wert in Tabelle            }
   if hoehe > Modoktave[nct] then
     gefunden := true;
   inc(nct);
 end;
 if gefunden then begin;
   dif := ndiff[nct-tpw+12];
   vk  := vkt[nct-tpw+12];              { Werte aus Tabelle holen.   }
   nk  := nkt[nct-tpw+12];              { Tuning ber die tpw        }
 end;
end;

procedure innen_schleife_4; assembler;
{
 Hier erfolgt die eigentliche Vermischung der Daten. Der Puffer
 blk wird dabei mit den berechneten Daten gefllt. Dies ist die
 MONO-Version der Routine.
}
Var Output : word;
asm
  mov cx,Sound_Schleifen
@Die_Schleife:
    push cx
    xor ax,ax
    xor dx,dx
    mov Output,ax
    mov bx,in1l
    sub bx,in1p
    cmp bx,1
    ja  @Nochn_label1                   { Ton holen, da alles normal }
    cmp ll1,10               { Wenn Loopen, dann Loopproc und weiter }
    jae @Ton_St1_no
    mov Vk1,0
    mov Nk1,0
@Nochn_label1:
    mov bx,i1.sgm
    mov es,bx
    mov bx,Inst1vk
    mov al,es:[bx]
    sub al,128
    mul Notvol1
    shr ax,6
    jmp @Weiter_Stimme_1
@Ton_St1_no:
    mov ax,ls1
    mov in1p,ax
    mov Inst1vk,ax
    jmp @Nochn_label1
@Weiter_Stimme_1:
    mov bx,Vk1
    add Inst1vk,bx
    add in1p,bx
    mov bl,Inst1nk
    mov dl,Nk1
    add bl,dl
@CheckPermUp_1:
    cmp PermUp_1,0
    je  @CheckPermDo_1
    inc nk1
    dec Dif1                            { Dec Dif                    }
    jnz @ueberlauf_1
    mov PermUp_1,0                      { Wenn Dif = 0 => PerUp = 0  }
    jmp @ueberlauf_1
@CheckPermDo_1:
    cmp PermDo_1,0
    je  @ueberlauf_1
    dec nk1
    dec Dif1
    jnz @ueberlauf_1
    mov PermDo_1,0
@ueberlauf_1:
    cmp bl,100
    jna @Inst1_weiter
    sub bl,100
    inc Inst1vk
    inc in1p
    jmp @ueberlauf_1
@Inst1_weiter:
    mov Inst1nk,bl

@Stimme_2:
    mov Output,ax
    mov bx,in2l
    sub bx,in2p
    cmp bx,1
    ja  @Nochn_label2
    cmp ll2,10
    jae @Ton_St2_no
    mov Vk2,0
    mov Nk2,0
@Nochn_label2:
    mov bx,i2.sgm
    mov es,bx
    mov bx,Inst2vk
    mov al,es:[bx]
    sub al,128
    mul Notvol2
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_2
@Ton_St2_no:
    mov bx,ls2
    mov in2p,bx
    mov Inst2vk,bx
    jmp @Nochn_label2
@Weiter_Stimme_2:
    mov bx,Vk2
    add Inst2vk,bx
    add in2p,bx
    mov bl,Inst2nk
    mov dl,Nk2
    add bl,dl
@CheckPermUp_2:
    cmp PermUp_2,0
    je  @CheckPermDo_2
    inc nk2
    dec Dif2
    jnz @ueberlauf_2
    mov PermUp_2,0
    jmp @ueberlauf_2
@CheckPermDo_2:
    cmp PermDo_2,0
    je  @ueberlauf_2
    dec nk2
    dec Dif2
    jnz @ueberlauf_2
    mov PermDo_2,0
@ueberlauf_2:
    cmp bl,100
    jna @Inst2_weiter
    sub bl,100
    inc Inst2vk
    inc in2p
    jmp @ueberlauf_2
@Inst2_weiter:
    mov Inst2nk,bl

@Stimme_3:
    mov bx,in3l
    sub bx,in3p
    cmp bx,1
    ja  @Nochn_label3
    cmp ll3,10
    jae @Ton_St3_no
    mov Vk3,0
    mov Nk3,0
@Nochn_label3:
    mov bx,i3.sgm
    mov es,bx
    mov bx,Inst3vk
    mov al,es:[bx]
    sub al,128
    mul Notvol3
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_3
@Ton_St3_no:
    mov bx,ls3
    mov in3p,bx
    mov Inst3vk,bx
    jmp @Nochn_label3
@Weiter_Stimme_3:
    mov bx,Vk3
    add Inst3vk,bx
    add in3p,bx
    mov bl,Inst3nk
    mov dl,Nk3
    add bl,dl
@CheckPermUp_3:
    cmp PermUp_3,0
    je  @CheckPermDo_3
    inc nk3
    dec Dif3
    jnz @ueberlauf_3
    mov PermUp_3,0
    jmp @ueberlauf_3
@CheckPermDo_3:
    cmp PermDo_3,0
    je  @ueberlauf_3
    dec nk3
    dec Dif3
    jnz @ueberlauf_3
    mov PermDo_3,0
@ueberlauf_3:
    cmp bl,100
    jna @Inst3_weiter
    sub bl,100
    inc Inst3vk
    inc in3p
    jmp @ueberlauf_3
@Inst3_weiter:
    mov Inst3nk,bl

@Stimme_4:
    mov bx,in4l
    sub bx,in4p
    cmp bx,1
    ja  @Nochn_label4
    cmp ll4,10
    jae @Ton_St4_no
    mov Vk4,0
    mov Nk4,0
@Nochn_label4:
    mov bx,i4.sgm
    mov es,bx
    mov bx,Inst4vk
    mov al,es:[bx]
    sub al,128
    mul Notvol4
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_4
@Ton_St4_no:
    mov bx,ls4
    mov in4p,bx
    mov Inst4vk,bx
    jmp @Nochn_label4
@Weiter_Stimme_4:
    mov bx,Vk4
    add Inst4vk,bx
    add in4p,bx
    mov bl,Inst4nk
    mov dl,Nk4
    add bl,dl
@CheckPermUp_4:
    cmp PermUp_4,0
    je  @CheckPermDo_4
    inc nk4
    dec Dif4
    jnz @ueberlauf_4
    mov PermUp_4,0
    jmp @ueberlauf_4
@CheckPermDo_4:
    cmp PermDo_4,0
    je  @ueberlauf_4
    dec nk4
    dec Dif4
    jnz @ueberlauf_4
    mov PermDo_4,0
@ueberlauf_4:
    cmp bl,100
    jna @Inst4_weiter
    sub bl,100
    inc Inst4vk
    inc in4p
    jmp @ueberlauf_4
@Inst4_weiter:
    mov Inst4nk,bl
@Weiter_Ziel:
    {$ifdef seffects}
    cmp playeffect,1                    { Effekt abspielen ?         }
    jne @effekt_ende
    mov bx,Effekt.sgm
    mov es,bx
    mov bx,Effistvk
    mov ah,0
    mov al,es:[bx]
    cmp converteff,1
    jne @PC_Format                      { Fr PC/AMIGA Format        }
    sub al,128
@PC_Format:
    mul effectvolume                    { Lautstrke berechnen       }
		shr ax,6
    add Output,ax
    add Output,ax
    add Output,ax
    add Output,ax
    shr Output,3
    mov bx,effektgroesse
    sub bx,effektposi
    cmp bx,5                            { Effekt 5 vor Ende anhalten }
    ja   @Sound_moves
    jmp  @Sound_raus
@Sound_moves:
    mov bx,Effvk
    add Effistvk,bx
    add Effektposi,bx
    mov bl,Effistnk
    mov dl,Effnk
    add bl,dl
@ueberlauf_E:
    cmp bl,100                          { Nachkomma - Behandlung     }
    jna @Effekt_weiter
    sub bl,100
    inc Effistvk
    inc Effektposi
    jmp @ueberlauf_E
@effekt_weiter:
    mov Effistnk,bl
    mov bx,effektgroesse
    sub bx,effektposi
    cmp bx,0
    ja  @Sound_raus
    mov playeffect,0
    jmp @Sound_raus
@effekt_Ende:
    shr Output,3
    {$else}
    shr Output,2
    {$endif}
@Sound_raus:
    mov bx,ziel.sgm   							    { Byte ins Ziel schreiben    }
    mov es,bx
    mov bx,ziel.ofs
    mov ax,Output
    mul outvolume
    shr ax,6
    mov es:[bx],al
    inc ziel.ofs

    pop cx
    dec cx
    cmp cx,0
    ja  @Die_Schleife
end;

procedure innen_schleife_4_stereo; assembler;
{
 Hier erfolgt die eigentliche Vermischung der Daten. Der Puffer
 blk wird dabei mit den berechneten Daten gefllt. Dies ist die
 Stereo-Version der Routine.
}
Var left,right : word;
asm
  mov cx,Sound_Schleifen
@Die_Schleife:
    push cx             { Schleifenzhler sichern                         }
    xor ax,ax           { Register auf 0                                  }
    xor dx,dx
    mov left,ax         { Variable auf 0 setzen                           }
    mov right,ax
    mov bx,in1l         { noch zu spielende Anzahl von Bytes ermitteln    }
    sub bx,in1p
    cmp bx,1
    ja  @Alles_Normal1
    cmp ll1,10          { Ist die Loop-Lnge > 10 ?                       }
    jae @Ton_St1_loop
    mov Vk1,0           { Bewegung auf 0  =  kein Ton !                   }
    mov Nk1,0
@Alles_Normal1:
    mov bx,i1.sgm       { Pointer auf Sample-Daten der Stimme             }
    mov es,bx
    mov bx,Inst1vk
    mov al,es:[bx]      { Sampelwert laden                                }
    sub al,128          { ins PC - Format bringen                         }
    mul Notvol1         { Lautstrke berechnen                            }
    shr ax,6
    jmp @Weiter_Stimme_1
@Ton_St1_loop:
    mov ax,ls1          { Position im Sampel auf Loop-Startwert setzen    }
    mov in1p,ax
    mov Inst1vk,ax      { VK der Instrumenten-Position auch !             }
    jmp @Alles_Normal1
@Weiter_Stimme_1:
    mov bx,Vk1          { Ganzzahlige Schrittweite nach bx                }
    add Inst1vk,bx      { VK der Instr.-Pos weitersetzen                  }
    add in1p,bx
    mov bl,Inst1nk      { Nachkomma - Position in bl laden                }
    mov dl,Nk1          { Nachkomma - Schritte in dl laden                }
    add bl,dl           { Nachkomma-Pos weitersetzen                      }
@CheckPermUp_1:
    cmp PermUp_1,0      { Weitermachen, wenn Portamento Up  (Wert <> 0    }
    je  @CheckPermDo_1
    inc nk1             { Nachkomma - Position erhhen                    }
    dec Dif1            { Dif = Anzahl der Bytes, um die noch erhht
                          werden mu                                      }
    jnz @ueberlauf_1    { Wenn nicht 0, dann Effekt weiterhin aktiv       }
    mov PermUp_1,0      { Dif = 0 => Effekt zu Ende, Flag setzen          }
    jmp @ueberlauf_1
@CheckPermDo_1:
    cmp PermDo_1,0      { Weitermachen, wenn Portamento Down  (Wert <> 0  }
    je  @ueberlauf_1
    dec nk1             { Nachkomma - Position herunterzhlen             }
    dec Dif1            { Dif = Anzahl der Bytes, um die noch
		                      decrementiert werden mu                        }
    jnz @ueberlauf_1    { Wenn nicht 0, dann Effekt weiterhin aktiv       }
    mov PermDo_1,0      { Dif = 0 => Effekt zu Ende, Flag setzen          }
@ueberlauf_1:
    cmp bl,100          { Wenn bl > 100, dann "berlauf"                  }
    jna @Inst1_weiter
    sub bl,100          { Wert - 100; NK 100 = VK 1                       }
    inc Inst1vk         { VK-Wert und Position um 1 weitersetzen          }
    inc in1p
    jmp @ueberlauf_1    { erneut prfen, da auch Werte > 200 mglich !    }
@Inst1_weiter:
    mov Inst1nk,bl      { Nachkomma-Wert zurck                           }

@Stimme_2:
    mov left,ax
    mov bx,in2l         { noch zu spielende Anzahl von Bytes ermitteln    }
    sub bx,in2p
    cmp bx,1
    ja  @Alles_Normal2
    cmp ll2,10          { Ist die Loop-Lnge > 10 ?                       }
    jae @Ton_St2_loop
    mov Vk2,0           { Bewegung auf 0  =  kein Ton !                   }
    mov Nk2,0
@Alles_Normal2:
    mov bx,i2.sgm       { Pointer auf Sample-Daten der Stimme             }
    mov es,bx
    mov bx,Inst2vk
    mov al,es:[bx]      { Sampelwert laden                                }
    sub al,128          { ins PC - Format bringen                         }
    mul Notvol2         { Lautstrke berechnen                            }
    shr ax,6
    add right,ax
    jmp @Weiter_Stimme_2
@Ton_St2_loop:
    mov bx,ls2          { Position im Sampel auf Loop-Startwert setzen    }
    mov in2p,bx
    mov Inst2vk,bx      { VK der Instrumenten-Position auch !             }
    jmp @Alles_Normal2
@Weiter_Stimme_2:
    mov bx,Vk2          { Ganzzahlige Schrittweite nach bx                }
    add Inst2vk,bx      { VK der Instr.-Pos weitersetzen                  }
    add in2p,bx
    mov bl,Inst2nk      { Nachkomma - Position in bl laden                }
    mov dl,Nk2          { Nachkomma - Schritte in dl laden                }
    add bl,dl           { Nachkomma-Pos weitersetzen                      }
@CheckPermUp_2:
    cmp PermUp_2,0      { Weitermachen, wenn Portamento Up  (Wert <> 0    }
    je  @CheckPermDo_2
    inc nk2             { Nachkomma - Position erhhen                    }
    dec Dif2            { Dif = Anzahl der Bytes, um die noch erhht
                          werden mu                                      }
    jnz @ueberlauf_2    { Wenn nicht 0, dann Effekt weiterhin aktiv       }
    mov PermUp_2,0      { Dif = 0 => Effekt zu Ende, Flag setzen          }
    jmp @ueberlauf_2
@CheckPermDo_2:
    cmp PermDo_2,0      { Weitermachen, wenn Portamento Down  (Wert <> 0  }
    je  @ueberlauf_2
    dec nk2             { Nachkomma - Position herunterzhlen             }
    dec Dif2            { Dif = Anzahl der Bytes, um die noch
		                      decrementiert werden mu                        }
    jnz @ueberlauf_2    { Wenn nicht 0, dann Effekt weiterhin aktiv       }
    mov PermDo_2,0      { Dif = 0 => Effekt zu Ende, Flag setzen          }
@ueberlauf_2:
    cmp bl,100          { Wenn bl > 100, dann "berlauf"                  }
    jna @Inst2_weiter
    sub bl,100          { Wert - 100; NK 100 = VK 1                       }
    inc Inst2vk         { VK-Wert und Position um 1 weitersetzen          }
    inc in2p
    jmp @ueberlauf_2    { erneut prfen, da auch Werte > 200 mglich !    }
@Inst2_weiter:
    mov Inst2nk,bl      { Nachkomma-Wert zurck                           }

@Stimme_3:
    mov bx,in3l         { noch zu spielende Anzahl von Bytes ermitteln    }
    sub bx,in3p
    cmp bx,1
    ja  @Alles_Normal3
    cmp ll3,10          { Ist die Loop-Lnge > 10 ?                       }
    jae @Ton_St3_loop
    mov Vk3,0           { Bewegung auf 0  =  kein Ton !                   }
    mov Nk3,0
@Alles_Normal3:
    mov bx,i3.sgm       { Pointer auf Sample-Daten der Stimme             }
    mov es,bx
    mov bx,Inst3vk
    mov al,es:[bx]      { Sampelwert laden                                }
    sub al,128          { ins PC - Format bringen                         }
    mul Notvol3         { Lautstrke berechnen                            }
    shr ax,6
    add right,ax
    jmp @Weiter_Stimme_3
@Ton_St3_loop:
    mov bx,ls3          { Position im Sampel auf Loop-Startwert setzen    }
    mov in3p,bx
    mov Inst3vk,bx      { VK der Instrumenten-Position auch !             }
    jmp @Alles_Normal3
@Weiter_Stimme_3:
    mov bx,Vk3          { Ganzzahlige Schrittweite nach bx                }
    add Inst3vk,bx      { VK der Instr.-Pos weitersetzen                  }
    add in3p,bx
    mov bl,Inst3nk      { Nachkomma - Position in bl laden                }
    mov dl,Nk3          { Nachkomma - Schritte in dl laden                }
    add bl,dl           { Nachkomma-Pos weitersetzen                      }
@CheckPermUp_3:
    cmp PermUp_3,0      { Weitermachen, wenn Portamento Up  (Wert <> 0    }
    je  @CheckPermDo_3
    inc nk3             { Nachkomma - Position erhhen                    }
    dec Dif3            { Dif = Anzahl der Bytes, um die noch erhht
                          werden mu                                      }
    jnz @ueberlauf_3    { Wenn nicht 0, dann Effekt weiterhin aktiv       }
    mov PermUp_3,0      { Dif = 0 => Effekt zu Ende, Flag setzen          }
    jmp @ueberlauf_3
@CheckPermDo_3:
    cmp PermDo_3,0      { Weitermachen, wenn Portamento Down  (Wert <> 0  }
    je  @ueberlauf_3
    dec nk3             { Nachkomma - Position herunterzhlen             }
    dec Dif3            { Dif = Anzahl der Bytes, um die noch
		                      decrementiert werden mu                        }
    jnz @ueberlauf_3    { Wenn nicht 0, dann Effekt weiterhin aktiv       }
    mov PermDo_3,0      { Dif = 0 => Effekt zu Ende, Flag setzen          }
@ueberlauf_3:
    cmp bl,100          { Wenn bl > 100, dann "berlauf"                  }
    jna @Inst3_weiter
    sub bl,100          { Wert - 100; NK 100 = VK 1                       }
    inc Inst3vk         { VK-Wert und Position um 1 weitersetzen          }
    inc in3p
    jmp @ueberlauf_3    { erneut prfen, da auch Werte > 200 mglich !    }
@Inst3_weiter:
    mov Inst3nk,bl      { Nachkomma-Wert zurck                           }

@Stimme_4:
    mov bx,in4l         { noch zu spielende Anzahl von Bytes ermitteln    }
    sub bx,in4p
    cmp bx,1
		ja  @Alles_Normal4
    cmp ll4,10          { Ist die Loop-Lnge > 10 ?                       }
    jae @Ton_St4_loop
    mov Vk4,0           { Bewegung auf 0  =  kein Ton !                   }
    mov Nk4,0
@Alles_Normal4:
    mov bx,i4.sgm       { Pointer auf Sample-Daten der Stimme             }
    mov es,bx
    mov bx,Inst4vk
    mov al,es:[bx]      { Sampelwert laden                                }
    sub al,128          { ins PC - Format bringen                         }
    mul Notvol4         { Lautstrke berechnen                            }
    shr ax,6
    add left,ax
    jmp @Weiter_Stimme_4
@Ton_St4_loop:
    mov bx,ls4          { Position im Sampel auf Loop-Startwert setzen    }
    mov in4p,bx
    mov Inst4vk,bx      { VK der Instrumenten-Position auch !             }
    jmp @Alles_Normal4
@Weiter_Stimme_4:
    mov bx,Vk4          { Ganzzahlige Schrittweite nach bx                }
    add Inst4vk,bx      { VK der Instr.-Pos weitersetzen                  }
    add in4p,bx
    mov bl,Inst4nk      { Nachkomma - Position in bl laden                }
    mov dl,Nk4          { Nachkomma - Schritte in dl laden                }
    add bl,dl           { Nachkomma-Pos weitersetzen                      }
@CheckPermUp_4:
    cmp PermUp_4,0      { Weitermachen, wenn Portamento Up  (Wert <> 0    }
    je  @CheckPermDo_4
    inc nk4             { Nachkomma - Position erhhen                    }
    dec Dif4            { Dif = Anzahl der Bytes, um die noch
		                      decrementiert werden mu                        }
    jnz @ueberlauf_4    { Wenn nicht 0, dann Effekt weiterhin aktiv       }
    mov PermUp_4,0      { Dif = 0 => Effekt zu Ende, Flag setzen          }
    jmp @ueberlauf_4
@CheckPermDo_4:
    cmp PermDo_4,0      { Weitermachen, wenn Portamento Down  (Wert <> 0  }
    je  @ueberlauf_4
    dec nk4             { Nachkomma - Position herunterzhlen             }
    dec Dif4            { Dif = Anzahl der Bytes, um die noch
		                      decrementiert werden mu                        }
    jnz @ueberlauf_4    { Wenn nicht 0, dann Effekt weiterhin aktiv       }
    mov PermDo_4,0      { Dif = 0 => Effekt zu Ende, Flag setzen          }
@ueberlauf_4:
    cmp bl,100          { Wenn bl > 100, dann "berlauf"                  }
    jna @Inst4_weiter
    sub bl,100          { Wert - 100; NK 100 = VK 1                       }
    inc Inst4vk         { VK-Wert und Position um 1 weitersetzen          }
    inc in4p
    jmp @ueberlauf_4    { erneut prfen, da auch Werte > 200 mglich !    }
@Inst4_weiter:
    mov Inst4nk,bl      { Nachkomma-Wert zurck                           }
@Weiter_Ziel:
    {$ifdef effects}    { Compiler switch, da Einflu auf Ausgabe-Quality }
    cmp playeffect,1    { Wenn kein Effekt gespielt werden soll, raus     }
    jne @effekt_ende
    mov bx,Effekt.sgm   { Pointer auf Sample-Daten der Stimme             }
    mov es,bx
    mov bx,Effistvk
    mov ah,0
    mov al,es:[bx]      { Effekt-Datenbyte laden                          }
    cmp converteff,1    { Wenn 1, dann bereits im richtigen Format ...    }
    jne @PC_Format
    sub al,128          { ... sonst ins PC-Format konvertieren !          }
@PC_Format:
    mul effectvolume    { Lautstrke berechnen                            }
		shr ax,6
    add left,ax         { Effekt in beide Kanle                          }
    add left,ax
    add right,ax
    add right,ax
    mov bx,effektgroesse
    sub bx,effektposi
    cmp bx,5            { Effektende erreicht ?                           }
    ja   @Sound_moves
    jmp  @Sound_raus
@Sound_moves:
    mov bx,Effvk        { Nachkomma - Behandlung wie in Stimmen ...       }
    add Effistvk,bx
    add Effektposi,bx
    mov bl,Effistnk
    mov dl,Effnk
    add bl,dl
@ueberlauf_E:
    cmp bl,100
    jna @Effekt_weiter
    sub bl,100
    inc Effistvk
    inc Effektposi
    jmp @ueberlauf_E
@effekt_weiter:
    mov Effistnk,bl
    mov bx,effektgroesse{ Effektende erreicht ?                           }
    sub bx,effektposi
    cmp bx,0
    ja  @Sound_raus
    mov playeffect,0    { Effekt-Berechnung ausschalten                   }
    jmp @Sound_raus
@effekt_Ende:
    {$endif}
@Sound_raus:
    mov ax,left         { Kanle ins ax & bx - Register (zum rechnen)     }
    mov bx,right
    shr bx,1            { Gefundene Werte auf 50% Lautstrke              }
    shr ax,1
    add left,bx         { Linker  Output = Linke Werte + 50% rechte Werte }
    add right,ax        { Rechter Output = rechte Werte + 50% linke Werte }
    {$ifdef Effects}
    shr left,3          { Mit Effekten : 4 Stimmen (4 wgn Stereo) + Eff.  }
    shr right,3         { = max. 8 Kanle   ==> Wert SHR 3  (= DIV 8)     }
    {$else}
    shr left,2          { 4 Stimmen (Mono: 2)  ==> Wert SHR 2             }
    shr right,2
    {$endif}
    mov bx,ziel.sgm     { Pointer laden                                   }
    mov es,bx
    mov bx,ziel.ofs
    mov ax,left
    mul outvolume       { Gesamtlautstrke anpassen                       }
    shr ax,6
    mov es:[bx],al      { Werte speichern                                 }
    inc ziel.ofs
    inc bx
    mov ax,right
    mul outvolume       { Gesamtlautstrke anpassen                       }
    shr ax,6
    mov es:[bx],al
    inc ziel.ofs

    pop cx              { Schleifenzhler zurckholen                     }
    dec cx
    cmp cx,0            { noch ein Durchlauf ???                          }
    ja  @Die_Schleife
end;

procedure innen_schleife_8; assembler;
{
 Hier erfolgt die eigentliche Vermischung der Daten. Der Puffer
 blk wird dabei mit den berechneten Daten gefllt. Dies ist die
 MONO-Version der Routine.
}
Var Output : word;
asm
  mov cx,Sound_Schleifen
@Die_Schleife:
    push cx
    xor ax,ax
    xor dx,dx
    mov Output,ax
    mov bx,in1l
    sub bx,in1p
    cmp bx,1
    ja  @Nochn_label1
    cmp ll1,10
    jae @Ton_St1_no
    mov Vk1,0
    mov Nk1,0
@Nochn_label1:
    mov bx,i1.sgm
    mov es,bx
    mov bx,Inst1vk
    mov al,es:[bx]
    sub al,128
    mul Notvol1
    shr ax,6
    jmp @Weiter_Stimme_1
@Ton_St1_no:
    mov ax,ls1
    mov in1p,ax
    mov ax,ll1
    sub Inst1vk,ax
    jmp @Nochn_label1
@Weiter_Stimme_1:
    mov bx,Vk1
    add Inst1vk,bx
    add in1p,bx
    mov bl,Inst1nk
    mov dl,Nk1
    add bl,dl
@CheckPermUp_1:
    cmp PermUp_1,0
    je  @CheckPermDo_1
    inc nk1
    dec Dif1
    jnz @ueberlauf_1
    mov PermUp_1,0
    jmp @ueberlauf_1
@CheckPermDo_1:
    cmp PermDo_1,0
    je  @ueberlauf_1
    dec nk1
    dec Dif1
    jnz @ueberlauf_1
    mov PermDo_1,0
@ueberlauf_1:
    cmp bl,100
    jna @Inst1_weiter
    sub bl,100
    inc Inst1vk
    inc in1p
    jmp @ueberlauf_1
@Inst1_weiter:
    mov Inst1nk,bl

@Stimme_2:
    mov Output,ax
    mov bx,in2l
    sub bx,in2p
    cmp bx,1
    ja  @Nochn_label2
    cmp ll2,10
    jae @Ton_St2_no
    mov Vk2,0
    mov Nk2,0
@Nochn_label2:
    mov bx,i2.sgm
    mov es,bx
    mov bx,Inst2vk
    mov al,es:[bx]
    sub al,128
    mul Notvol2
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_2
@Ton_St2_no:
    mov bx,ls2
    mov in2p,bx
    mov bx,ll2
    sub Inst2vk,bx
    jmp @Nochn_label2
@Weiter_Stimme_2:
    mov bx,Vk2
    add Inst2vk,bx
    add in2p,bx
    mov bl,Inst2nk
    mov dl,Nk2
    add bl,dl
@CheckPermUp_2:
    cmp PermUp_2,0
    je  @CheckPermDo_2
    inc nk2
    dec Dif2
    jnz @ueberlauf_2
    mov PermUp_2,0
    jmp @ueberlauf_2
@CheckPermDo_2:
    cmp PermDo_2,0
    je  @ueberlauf_2
    dec nk2
    dec Dif2
    jnz @ueberlauf_2
    mov PermDo_2,0
@ueberlauf_2:
    cmp bl,100
    jna @Inst2_weiter
    sub bl,100
    inc Inst2vk
    inc in2p
    jmp @ueberlauf_2
@Inst2_weiter:
    mov Inst2nk,bl

@Stimme_3:
    mov bx,in3l
    sub bx,in3p
    cmp bx,1
    ja  @Nochn_label3
    cmp ll3,10
    jae @Ton_St3_no
    mov Vk3,0
    mov Nk3,0
@Nochn_label3:
    mov bx,i3.sgm
    mov es,bx
    mov bx,Inst3vk
    mov al,es:[bx]
    sub al,128
    mul Notvol3
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_3
@Ton_St3_no:
    mov bx,ls3
    mov in3p,bx
    mov bx,ll3
    sub Inst3vk,bx
    jmp @Nochn_label3
@Weiter_Stimme_3:
    mov bx,Vk3
    add Inst3vk,bx
    add in3p,bx
    mov bl,Inst3nk
    mov dl,Nk3
    add bl,dl
@CheckPermUp_3:
    cmp PermUp_3,0
    je  @CheckPermDo_3
    inc nk3
    dec Dif3
    jnz @ueberlauf_3
    mov PermUp_3,0
    jmp @ueberlauf_3
@CheckPermDo_3:
    cmp PermDo_3,0
    je  @ueberlauf_3
    dec nk3
    dec Dif3
    jnz @ueberlauf_3
    mov PermDo_3,0
@ueberlauf_3:
    cmp bl,100
    jna @Inst3_weiter
    sub bl,100
    inc Inst3vk
    inc in3p
    jmp @ueberlauf_3
@Inst3_weiter:
    mov Inst3nk,bl

@Stimme_4:
    mov bx,in4l
    sub bx,in4p
    cmp bx,1
    ja  @Nochn_label4
    cmp ll4,10
    jae @Ton_St4_no
    mov Vk4,0
    mov Nk4,0
@Nochn_label4:
    mov bx,i4.sgm
    mov es,bx
    mov bx,Inst4vk
    mov al,es:[bx]
    sub al,128
    mul Notvol4
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_4
@Ton_St4_no:
    mov bx,ls4
    mov in4p,bx
    mov bx,ll4
    sub Inst4vk,bx
    jmp @Nochn_label4
@Weiter_Stimme_4:
    mov bx,Vk4
    add Inst4vk,bx
    add in4p,bx
    mov bl,Inst4nk
    mov dl,Nk4
    add bl,dl
@CheckPermUp_4:
    cmp PermUp_4,0
    je  @CheckPermDo_4
    inc nk4
    dec Dif4
    jnz @ueberlauf_4
    mov PermUp_4,0
    jmp @ueberlauf_4
@CheckPermDo_4:
    cmp PermDo_4,0
    je  @ueberlauf_4
    dec nk4
    dec Dif4
    jnz @ueberlauf_4
    mov PermDo_4,0
@ueberlauf_4:
    cmp bl,100
    jna @Inst4_weiter
    sub bl,100
    inc Inst4vk
    inc in4p
    jmp @ueberlauf_4
@Inst4_weiter:
    mov Inst4nk,bl

@Stimme_5:
    mov bx,in5l
    sub bx,in5p
    cmp bx,1
    ja  @Nochn_label5
    cmp ll5,10
    jae @Ton_St5_no
    mov Vk5,0
    mov Nk5,0
@Nochn_label5:
    mov bx,i5.sgm
    mov es,bx
    mov bx,Inst5vk
    mov al,es:[bx]
    sub al,128
    mul Notvol5
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_5
@Ton_St5_no:
    mov bx,ls5
    mov in5p,bx
    mov bx,ll5
    sub Inst5vk,bx
    jmp @Nochn_label5
@Weiter_Stimme_5:
    mov bx,Vk5
    add Inst5vk,bx
    add in5p,bx
    mov bl,Inst5nk
    mov dl,Nk5
    add bl,dl
@CheckPermUp_5:
    cmp PermUp_5,0
    je  @CheckPermDo_5
    inc nk5
    dec Dif5
    jnz @ueberlauf_5
    mov PermUp_5,0
    jmp @ueberlauf_5
@CheckPermDo_5:
    cmp PermDo_5,0
    je  @ueberlauf_5
    dec nk5
    dec Dif5
    jnz @ueberlauf_5
    mov PermDo_5,0
@ueberlauf_5:
    cmp bl,100
    jna @Inst5_weiter
    sub bl,100
    inc Inst5vk
    inc in5p
    jmp @ueberlauf_5
@Inst5_weiter:
    mov Inst5nk,bl

@Stimme_6:
    mov bx,in6l
    sub bx,in6p
    cmp bx,1
    ja  @Nochn_label6
    cmp ll6,10
    jae @Ton_St6_no
    mov Vk6,0
    mov Nk6,0
@Nochn_label6:
    mov bx,i6.sgm
    mov es,bx
    mov bx,Inst6vk
    mov al,es:[bx]
    sub al,128
    mul Notvol6
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_6
@Ton_St6_no:
    mov bx,ls6
    mov in6p,bx
    mov bx,ll6
    sub Inst6vk,bx
    jmp @Nochn_label6
@Weiter_Stimme_6:
    mov bx,Vk6
    add Inst6vk,bx
    add in6p,bx
    mov bl,Inst6nk
    mov dl,Nk6
    add bl,dl
@CheckPermUp_6:
    cmp PermUp_6,0
    je  @CheckPermDo_6
    inc nk6
    dec Dif6
    jnz @ueberlauf_6
    mov PermUp_6,0
    jmp @ueberlauf_6
@CheckPermDo_6:
    cmp PermDo_6,0
    je  @ueberlauf_6
    dec nk6
    dec Dif6
    jnz @ueberlauf_6
    mov PermDo_6,0
@ueberlauf_6:
    cmp bl,100
    jna @Inst6_weiter
    sub bl,100
    inc Inst6vk
    inc in6p
    jmp @ueberlauf_6
@Inst6_weiter:
    mov Inst6nk,bl

@Stimme_7:
    mov bx,in7l
    sub bx,in7p
    cmp bx,1
    ja  @Nochn_label7
    cmp ll7,10
    jae @Ton_St7_no
    mov Vk7,0
    mov Nk7,0
@Nochn_label7:
    mov bx,i7.sgm
    mov es,bx
    mov bx,Inst7vk
    mov al,es:[bx]
    sub al,128
    mul Notvol7
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_7
@Ton_St7_no:
    mov bx,ls7
    mov in7p,bx
    mov bx,ll7
    sub Inst7vk,bx
    jmp @Nochn_label7
@Weiter_Stimme_7:
    mov bx,Vk7
    add Inst7vk,bx
    add in7p,bx
    mov bl,Inst7nk
    mov dl,Nk7
    add bl,dl
@CheckPermUp_7:
    cmp PermUp_7,0
    je  @CheckPermDo_7
    inc nk7
    dec Dif7
    jnz @ueberlauf_7
    mov PermUp_7,0
    jmp @ueberlauf_7
@CheckPermDo_7:
    cmp PermDo_7,0
    je  @ueberlauf_7
    dec nk7
    dec Dif7
    jnz @ueberlauf_7
    mov PermDo_7,0
@ueberlauf_7:
    cmp bl,100
    jna @Inst7_weiter
    sub bl,100
    inc Inst7vk
    inc in7p
    jmp @ueberlauf_7
@Inst7_weiter:
    mov Inst7nk,bl

@Stimme_8:
    mov bx,in8l
    sub bx,in8p
    cmp bx,1
    ja  @Nochn_label8
    cmp ll8,10
    jae @Ton_St8_no
    mov Vk8,0
    mov Nk8,0
@Nochn_label8:
    mov bx,i8.sgm
    mov es,bx
    mov bx,Inst8vk
    mov al,es:[bx]
    sub al,128
    mul Notvol8
    shr ax,6
    add Output,ax
    jmp @Weiter_Stimme_8
@Ton_St8_no:
    mov bx,ls8
    mov in8p,bx
    mov bx,ll8
    sub Inst8vk,bx
    jmp @Nochn_label8
@Weiter_Stimme_8:
    mov bx,Vk8
    add Inst8vk,bx
    add in8p,bx
    mov bl,Inst8nk
    mov dl,Nk8
    add bl,dl
@CheckPermUp_8:
    cmp PermUp_8,0
    je  @CheckPermDo_8
    inc nk8
    dec Dif8
    jnz @ueberlauf_8
    mov PermUp_8,0
    jmp @ueberlauf_8
@CheckPermDo_8:
    cmp PermDo_8,0
    je  @ueberlauf_8
    dec nk8
    dec Dif8
    jnz @ueberlauf_8
    mov PermDo_8,0
@ueberlauf_8:
    cmp bl,100
    jna @Inst8_weiter
    sub bl,100
    inc Inst8vk
    inc in8p
    jmp @ueberlauf_8
@Inst8_weiter:
    mov Inst8nk,bl

@Weiter_Ziel:
    {$ifdef seffects}
    cmp playeffect,1
    jne @effekt_ende
    mov bx,Effekt.sgm
    mov es,bx
    mov bx,Effistvk
    mov ah,0
    mov al,es:[bx]
    cmp converteff,1
    jne @PC_Format
    sub al,128
@PC_Format:
    mul effectvolume
		shr ax,6
    add Output,ax
    add Output,ax
    add Output,ax
    add Output,ax
    add Output,ax
    add Output,ax
    add Output,ax
    add Output,ax
    shr Output,4
    mov bx,effektgroesse
    sub bx,effektposi
    cmp bx,5
    ja   @Sound_moves
    jmp  @Sound_raus
@Sound_moves:
    mov bx,Effvk
    add Effistvk,bx
    add Effektposi,bx
    mov bl,Effistnk
    mov dl,Effnk
    add bl,dl
@ueberlauf_E:
    cmp bl,100
    jna @Effekt_weiter
    sub bl,100
    inc Effistvk
    inc Effektposi
    jmp @ueberlauf_E
@effekt_weiter:
    mov Effistnk,bl
    mov bx,effektgroesse
    sub bx,effektposi
    cmp bx,0
    ja  @Sound_raus
    mov playeffect,0
    jmp @Sound_raus
@effekt_Ende:
    shr Output,4
    {$else}
    shr Output,3
    {$endif}
@Sound_raus:
    mov bx,ziel.sgm
    mov es,bx
    mov bx,ziel.ofs
    mov ax,Output
    mul outvolume
    shr ax,6
    mov es:[bx],al
    inc ziel.ofs

    pop cx
    dec cx
    cmp cx,0
    ja  @Die_Schleife
end;

procedure innen_schleife_8_stereo; assembler;
{
 Hier erfolgt die eigentliche Vermischung der Daten. Der Puffer
 blk wird dabei mit den berechneten Daten gefllt. Dies ist die
 Stereo-Version der Routine.
}
Var left,right : word;
asm
  mov cx,Sound_Schleifen
@Die_Schleife:
    push cx
    xor ax,ax
    xor dx,dx
    mov left,ax
    mov right,ax
    mov bx,in1l
    sub bx,in1p
    cmp bx,1
    ja  @Nochn_label1
    cmp ll1,10
    jae @Ton_St1_no
    mov Vk1,0
    mov Nk1,0
@Nochn_label1:
    mov bx,i1.sgm
    mov es,bx
    mov bx,Inst1vk
    mov al,es:[bx]
    sub al,128
    mul Notvol1
    shr ax,6
    jmp @Weiter_Stimme_1
@Ton_St1_no:
    mov ax,ls1
    mov in1p,ax
    mov ax,ll1
    sub Inst1vk,ax
    jmp @Nochn_label1
@Weiter_Stimme_1:
    mov bx,Vk1
    add Inst1vk,bx
    add in1p,bx
    mov bl,Inst1nk
    mov dl,Nk1
    add bl,dl
@CheckPermUp_1:
    cmp PermUp_1,0
    je  @CheckPermDo_1
    inc nk1
    dec Dif1
    jnz @ueberlauf_1
    mov PermUp_1,0
    jmp @ueberlauf_1
@CheckPermDo_1:
    cmp PermDo_1,0
    je  @ueberlauf_1
    dec nk1
    dec Dif1
    jnz @ueberlauf_1
    mov PermDo_1,0
@ueberlauf_1:
    cmp bl,100
    jna @Inst1_weiter
    sub bl,100
    inc Inst1vk
    inc in1p
    jmp @ueberlauf_1
@Inst1_weiter:
    mov Inst1nk,bl

@Stimme_2:
    mov left,ax
    mov bx,in2l
    sub bx,in2p
    cmp bx,1
    ja  @Nochn_label2
    cmp ll2,10
    jae @Ton_St2_no
    mov Vk2,0
    mov Nk2,0
@Nochn_label2:
    mov bx,i2.sgm
    mov es,bx
    mov bx,Inst2vk
    mov al,es:[bx]
    sub al,128
    mul Notvol2
    shr ax,6
    add left,ax
    jmp @Weiter_Stimme_2
@Ton_St2_no:
    mov bx,ls2
    mov in2p,bx
    mov bx,ll2
    sub Inst2vk,bx
    jmp @Nochn_label2
@Weiter_Stimme_2:
    mov bx,Vk2
    add Inst2vk,bx
    add in2p,bx
    mov bl,Inst2nk
    mov dl,Nk2
    add bl,dl
@CheckPermUp_2:
    cmp PermUp_2,0
    je  @CheckPermDo_2
    inc nk2
    dec Dif2
    jnz @ueberlauf_2
    mov PermUp_2,0
    jmp @ueberlauf_2
@CheckPermDo_2:
    cmp PermDo_2,0
    je  @ueberlauf_2
    dec nk2
    dec Dif2
    jnz @ueberlauf_2
    mov PermDo_2,0
@ueberlauf_2:
    cmp bl,100
    jna @Inst2_weiter
    sub bl,100
    inc Inst2vk
    inc in2p
    jmp @ueberlauf_2
@Inst2_weiter:
    mov Inst2nk,bl

@Stimme_3:
    mov bx,in3l
    sub bx,in3p
    cmp bx,1
    ja  @Nochn_label3
    cmp ll3,10
    jae @Ton_St3_no
    mov Vk3,0
    mov Nk3,0
@Nochn_label3:
    mov bx,i3.sgm
    mov es,bx
    mov bx,Inst3vk
    mov al,es:[bx]
    sub al,128
    mul Notvol3
    shr ax,6
    add right,ax
    jmp @Weiter_Stimme_3
@Ton_St3_no:
    mov bx,ls3
    mov in3p,bx
    mov bx,ll3
    sub Inst3vk,bx
    jmp @Nochn_label3
@Weiter_Stimme_3:
    mov bx,Vk3
    add Inst3vk,bx
    add in3p,bx
    mov bl,Inst3nk
    mov dl,Nk3
    add bl,dl
@CheckPermUp_3:
    cmp PermUp_3,0
    je  @CheckPermDo_3
    inc nk3
    dec Dif3
    jnz @ueberlauf_3
    mov PermUp_3,0
    jmp @ueberlauf_3
@CheckPermDo_3:
    cmp PermDo_3,0
    je  @ueberlauf_3
    dec nk3
    dec Dif3
    jnz @ueberlauf_3
    mov PermDo_3,0
@ueberlauf_3:
    cmp bl,100
    jna @Inst3_weiter
    sub bl,100
    inc Inst3vk
    inc in3p
    jmp @ueberlauf_3
@Inst3_weiter:
    mov Inst3nk,bl

@Stimme_4:
    mov bx,in4l
    sub bx,in4p
    cmp bx,10
    ja  @Nochn_label4
    cmp ll4,10
    jae @Ton_St4_no
    mov Vk4,0
    mov Nk4,0
@Nochn_label4:
    mov bx,i4.sgm
    mov es,bx
    mov bx,Inst4vk
    mov al,es:[bx]
    sub al,128
    mul Notvol4
    shr ax,6
    add right,ax
    jmp @Weiter_Stimme_4
@Ton_St4_no:
    mov bx,ls4
    mov in4p,bx
    mov bx,ll4
    sub Inst4vk,bx
    jmp @Nochn_label4
@Weiter_Stimme_4:
    mov bx,Vk4
    add Inst4vk,bx
    add in4p,bx
    mov bl,Inst4nk
    mov dl,Nk4
    add bl,dl
@CheckPermUp_4:
    cmp PermUp_4,0
    je  @CheckPermDo_4
    inc nk4
    dec Dif4
    jnz @ueberlauf_4
    mov PermUp_4,0
    jmp @ueberlauf_4
@CheckPermDo_4:
    cmp PermDo_4,0
    je  @ueberlauf_4
    dec nk4
    dec Dif4
    jnz @ueberlauf_4
    mov PermDo_4,0
@ueberlauf_4:
    cmp bl,100
    jna @Inst4_weiter
    sub bl,100
    inc Inst4vk
    inc in4p
    jmp @ueberlauf_4
@Inst4_weiter:
    mov Inst4nk,bl

@Stimme_5:
    mov bx,in5l
    sub bx,in5p
    cmp bx,10
    ja  @Nochn_label5
    cmp ll5,10
    jae @Ton_St5_no
    mov Vk5,0
    mov Nk5,0
@Nochn_label5:
    mov bx,i5.sgm
    mov es,bx
    mov bx,Inst5vk
    mov al,es:[bx]
    sub al,128
    mul Notvol5
    shr ax,6
    add right,ax
    jmp @Weiter_Stimme_5
@Ton_St5_no:
    mov bx,ls5
    mov in5p,bx
    mov bx,ll5
    sub Inst5vk,bx
    jmp @Nochn_label5
@Weiter_Stimme_5:
    mov bx,Vk5
    add Inst5vk,bx
    add in5p,bx
    mov bl,Inst5nk
    mov dl,Nk5
    add bl,dl
@CheckPermUp_5:
    cmp PermUp_5,0
    je  @CheckPermDo_5
    inc nk5
    dec Dif5
    jnz @ueberlauf_5
    mov PermUp_5,0
    jmp @ueberlauf_5
@CheckPermDo_5:
    cmp PermDo_5,0
    je  @ueberlauf_5
    dec nk5
    dec Dif5
    jnz @ueberlauf_5
    mov PermDo_5,0
@ueberlauf_5:
    cmp bl,100
    jna @Inst5_weiter
    sub bl,100
    inc Inst5vk
    inc in5p
    jmp @ueberlauf_5
@Inst5_weiter:
    mov Inst5nk,bl

@Stimme_6:
    mov bx,in6l
    sub bx,in6p
    cmp bx,1
    ja  @Nochn_label6
    cmp ll6,10
    jae @Ton_St6_no
    mov Vk6,0
    mov Nk6,0
@Nochn_label6:
    mov bx,i6.sgm
    mov es,bx
    mov bx,Inst6vk
    mov al,es:[bx]
    sub al,128
    mul Notvol6
    shr ax,6
    add right,ax
    jmp @Weiter_Stimme_6
@Ton_St6_no:
    mov bx,ls6
    mov in6p,bx
    mov bx,ll6
    sub Inst6vk,bx
    jmp @Nochn_label6
@Weiter_Stimme_6:
    mov bx,Vk6
    add Inst6vk,bx
    add in6p,bx
    mov bl,Inst6nk
    mov dl,Nk6
    add bl,dl
@CheckPermUp_6:
    cmp PermUp_6,0
    je  @CheckPermDo_6
    inc nk6
    dec Dif6
    jnz @ueberlauf_6
    mov PermUp_6,0
    jmp @ueberlauf_6
@CheckPermDo_6:
    cmp PermDo_6,0
    je  @ueberlauf_6
    dec nk6
    dec Dif6
    jnz @ueberlauf_6
    mov PermDo_6,0
@ueberlauf_6:
    cmp bl,100
    jna @Inst6_weiter
    sub bl,100
    inc Inst6vk
    inc in6p
    jmp @ueberlauf_6
@Inst6_weiter:
    mov Inst6nk,bl

@Stimme_7:
    mov bx,in7l
    sub bx,in7p
    cmp bx,1
    ja  @Nochn_label7
    cmp ll7,10
    jae @Ton_St7_no
    mov Vk7,0
    mov Nk7,0
@Nochn_label7:
    mov bx,i7.sgm
    mov es,bx
    mov bx,Inst7vk
    mov al,es:[bx]
    sub al,128
    mul Notvol7
    shr ax,6
    add left,ax
    jmp @Weiter_Stimme_7
@Ton_St7_no:
    mov bx,ls7
    mov in7p,bx
    mov bx,ll7
    sub Inst7vk,bx
    jmp @Nochn_label7
@Weiter_Stimme_7:
    mov bx,Vk7
    add Inst7vk,bx
    add in7p,bx
    mov bl,Inst7nk
    mov dl,Nk7
    add bl,dl
@CheckPermUp_7:
    cmp PermUp_7,0
    je  @CheckPermDo_7
    inc nk7
    dec Dif7
    jnz @ueberlauf_7
    mov PermUp_7,0
    jmp @ueberlauf_7
@CheckPermDo_7:
    cmp PermDo_7,0
    je  @ueberlauf_7
    dec nk7
    dec Dif7
    jnz @ueberlauf_7
    mov PermDo_7,0
@ueberlauf_7:
    cmp bl,100
    jna @Inst7_weiter
    sub bl,100
    inc Inst7vk
    inc in7p
    jmp @ueberlauf_7
@Inst7_weiter:
    mov Inst7nk,bl

@Stimme_8:
    mov bx,in8l
    sub bx,in8p
    cmp bx,1
    ja  @Nochn_label8
    cmp ll8,10
    jae @Ton_St8_no
    mov Vk8,0
    mov Nk8,0
@Nochn_label8:
    mov bx,i8.sgm
    mov es,bx
    mov bx,Inst8vk
    mov al,es:[bx]
    sub al,128
    mul Notvol8
    shr ax,6
    add left,ax
    jmp @Weiter_Stimme_8
@Ton_St8_no:
    mov bx,ls8
    mov in8p,bx
    mov bx,ll8
    sub Inst8vk,bx
    jmp @Nochn_label8
@Weiter_Stimme_8:
    mov bx,Vk8
    add Inst8vk,bx
    add in8p,bx
    mov bl,Inst8nk
    mov dl,Nk8
    add bl,dl
@CheckPermUp_8:
    cmp PermUp_8,0
    je  @CheckPermDo_8
    inc nk8
    dec Dif8
    jnz @ueberlauf_8
    mov PermUp_8,0
    jmp @ueberlauf_8
@CheckPermDo_8:
    cmp PermDo_8,0
    je  @ueberlauf_8
    dec nk8
    dec Dif8
    jnz @ueberlauf_8
    mov PermDo_8,0
@ueberlauf_8:
    cmp bl,100
    jna @Inst8_weiter
    sub bl,100
    inc Inst8vk
    inc in8p
    jmp @ueberlauf_8
@Inst8_weiter:
    mov Inst8nk,bl

@Weiter_Ziel:
    {$ifdef seffects}
    cmp playeffect,1
    jne @effekt_ende
    mov bx,Effekt.sgm
    mov es,bx
    mov bx,Effistvk
    mov ah,0
    mov al,es:[bx]
    cmp converteff,1
    jne @PC_Format
    sub al,128
@PC_Format:
    mul effectvolume
		shr ax,6
    add left,ax
    add left,ax
    add left,ax
    add left,ax
    add right,ax
    add right,ax
    add right,ax
    add right,ax
    mov bx,effektgroesse
    sub bx,effektposi
    cmp bx,5
    ja   @Sound_moves
    jmp  @Sound_raus
@Sound_moves:
    mov bx,Effvk
    add Effistvk,bx
    add Effektposi,bx
    mov bl,Effistnk
    mov dl,Effnk
    add bl,dl
@ueberlauf_E:
    cmp bl,100
    jna @Effekt_weiter
    sub bl,100
    inc Effistvk
    inc Effektposi
    jmp @ueberlauf_E
@effekt_weiter:
    mov Effistnk,bl
    mov bx,effektgroesse
    sub bx,effektposi
    cmp bx,0
    ja  @Sound_raus
    mov playeffect,0
    jmp @Sound_raus
    {$endif}
@effekt_Ende:
@Sound_raus:
    mov ax,left
    mov bx,right
    shr bx,1
    shr ax,1
    add left,bx
    add right,ax
    {$ifdef seffects}
    shr left,3
    shr right,3
    {$else}
    shr left,2
    shr right,2
    {$endif}
    mov bx,ziel.sgm
    mov es,bx
    mov bx,ziel.ofs
    mov ax,left
    mul outvolume
    shr ax,6
    mov es:[bx],al
    inc ziel.ofs
    inc bx
    mov ax,right
    mul outvolume
    shr ax,6
    mov es:[bx],al
    inc ziel.ofs

    pop cx
    dec cx
    cmp cx,0
    ja  @Die_Schleife
end;


{$F+}
procedure vermische_start_4;
var rdiff : real;
    dummy : byte;
begin;
asm
  mov ax,i1.ofs
  mov dx,in1p
  add ax,dx
  mov Inst1vk,ax
  mov Inst1nk,0

  mov ax,i2.ofs
  mov dx,in2p
  add ax,dx
  mov Inst2vk,ax
  mov Inst2nk,0

  mov ax,i3.ofs
  mov dx,in3p
  add ax,dx
  mov Inst3vk,ax
  mov Inst3nk,0

  mov ax,i4.ofs
  mov dx,in4p
  add ax,dx
  mov Inst4vk,ax
  mov Inst4nk,0
end;
 if note1 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,1,1] and $0F)*256+Rm_Song[mli,1,2];
   get_pctune(tonhoehe,vk1,nk1,difb1);
 end;
 dif1 := difb1 * Rm_Song[mli,1,4];
 rdiff := dif1 / 4;
 dif1 := trunc(rdiff);
 Pnk1 := Pnk1 + round((rdiff-dif1)*100);
 if Pnk1 > 100 then begin;
   inc(dif1);
   dec(Pnk1,100);
 end;

 if note2 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,2,1] and $0F)*256+Rm_Song[mli,2,2];
   get_pctune(tonhoehe,vk2,nk2,difb2);
 end;
 dif2 := difb2 * Rm_Song[mli,2,4];
 rdiff := dif2 / 4;
 dif2 := trunc(rdiff);
 Pnk2 := Pnk2 + round((rdiff-dif2)*100);
 if Pnk2 > 100 then begin;
   inc(dif2);
   dec(Pnk2,100);
 end;

 if note3 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,3,1] and $0F)*256+Rm_Song[mli,3,2];
   get_pctune(tonhoehe,vk3,nk3,difb3);
 end;
 dif3 := difb3 * Rm_Song[mli,3,4];
 rdiff := dif3 / 4;
 dif3 := trunc(rdiff);
 Pnk3 := Pnk3 + round((rdiff-dif3)*100);
 if Pnk3 > 100 then begin;
   inc(dif3);
   dec(Pnk3,100);
 end;

 if note4 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,4,1] and $0F)*256+Rm_Song[mli,4,2];
   get_pctune(tonhoehe,vk4,nk4,difb4);
 end;
 dif4 := difb4 * Rm_Song[mli,4,4];
 rdiff := dif4 / 4;
 dif4 := trunc(rdiff);
 Pnk4 := Pnk4 + round((rdiff-dif4)*100);
 if Pnk4 > 100 then begin;
   inc(dif4);
   dec(Pnk4,100);
 end;

 ls1 := loop_s[In_st1];
 ll1 := loop_l[In_st1];
 ls2 := loop_s[In_st2];
 ll2 := loop_l[In_st2];
 ls3 := loop_s[In_st3];
 ll3 := loop_l[In_st3];
 ls4 := loop_s[In_st4];
 ll4 := loop_l[In_st4];
 if ll1 > 30 then in1l := ll1+ls1;
 if ll2 > 30 then in2l := ll2+ls2;
 if ll3 > 30 then in3l := ll3+ls3;
 if ll4 > 30 then in4l := ll4+ls4;
end;
{$F-}

{$F+}
procedure vermische_start_8;
var rdiff : real;
begin;
asm
  mov ax,i1.ofs
  mov dx,in1p
  add ax,dx
  mov Inst1vk,ax
  mov Inst1nk,0

  mov ax,i2.ofs
  mov dx,in2p
  add ax,dx
  mov Inst2vk,ax
  mov Inst2nk,0

  mov ax,i3.ofs
  mov dx,in3p
  add ax,dx
  mov Inst3vk,ax
  mov Inst3nk,0

  mov ax,i4.ofs
  mov dx,in4p
  add ax,dx
  mov Inst4vk,ax
  mov Inst4nk,0

  mov ax,i5.ofs
  mov dx,in5p
  add ax,dx
  mov Inst5vk,ax
  mov Inst5nk,0

  mov ax,i6.ofs
  mov dx,in6p
  add ax,dx
  mov Inst6vk,ax
  mov Inst6nk,0

  mov ax,i7.ofs
  mov dx,in7p
  add ax,dx
  mov Inst7vk,ax
  mov Inst7nk,0

  mov ax,i8.ofs
  mov dx,in8p
  add ax,dx
  mov Inst8vk,ax
  mov Inst8nk,0
end;
 if note1 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,1,1] and $0F)*256+Rm_Song[mli,1,2];
   get_pctune(tonhoehe,vk1,nk1,difb1);
 end;
 dif1 := difb1 * Rm_Song[mli,1,4];
 rdiff := dif1 / 4;
 dif1 := trunc(rdiff);
 Pnk1 := Pnk1 + round((rdiff-dif1)*100);
 if Pnk1 > 100 then begin;
   inc(dif1);
   dec(Pnk1,100);
 end;

 if note2 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,2,1] and $0F)*256+Rm_Song[mli,2,2];
   get_pctune(tonhoehe,vk2,nk2,difb2);
 end;
 dif2 := difb2 * Rm_Song[mli,2,4];
 rdiff := dif2 / 4;
 dif2 := trunc(rdiff);
 Pnk2 := Pnk2 + round((rdiff-dif2)*100);
 if Pnk2 > 100 then begin;
   inc(dif2);
   dec(Pnk2,100);
 end;

 if note3 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,3,1] and $0F)*256+Rm_Song[mli,3,2];
   get_pctune(tonhoehe,vk3,nk3,difb3);
 end;
 dif3 := difb3 * Rm_Song[mli,3,4];
 rdiff := dif3 / 4;
 dif3 := trunc(rdiff);
 Pnk3 := Pnk3 + round((rdiff-dif3)*100);
 if Pnk3 > 100 then begin;
   inc(dif3);
   dec(Pnk3,100);
 end;

 if note4 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,4,1] and $0F)*256+Rm_Song[mli,4,2];
   get_pctune(tonhoehe,vk4,nk4,difb4);
 end;
 dif4 := difb4 * Rm_Song[mli,4,4];
 rdiff := dif4 / 4;
 dif4 := trunc(rdiff);
 Pnk4 := Pnk4 + round((rdiff-dif4)*100);
 if Pnk4 > 100 then begin;
   inc(dif4);
   dec(Pnk4,100);
 end;

 if note5 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,5,1] and $0F)*256+Rm_Song[mli,5,2];
   get_pctune(tonhoehe,vk5,nk5,difb5);
 end;
 dif5 := difb5 * Rm_Song[mli,1,4];
 rdiff := dif5 / 4;
 dif5 := trunc(rdiff);
 Pnk5 := Pnk5 + round((rdiff-dif5)*100);
 if Pnk5 > 100 then begin;
   inc(dif5);
   dec(Pnk5,100);
 end;

 if note6 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,6,1] and $0F)*256+Rm_Song[mli,6,2];
   get_pctune(tonhoehe,vk6,nk6,difb6);
 end;
 dif6 := difb6 * Rm_Song[mli,6,4];
 rdiff := dif6 / 4;
 dif6 := trunc(rdiff);
 Pnk6 := Pnk6 + round((rdiff-dif6)*100);
 if Pnk6 > 100 then begin;
   inc(dif6);
   dec(Pnk6,100);
 end;

 if note7 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,7,1] and $0F)*256+Rm_Song[mli,7,2];
   get_pctune(tonhoehe,vk7,nk7,difb7);
 end;
 dif7 := difb7 * Rm_Song[mli,7,4];
 rdiff := dif7 / 4;
 dif7 := trunc(rdiff);
 Pnk7 := Pnk7 + round((rdiff-dif7)*100);
 if Pnk7 > 100 then begin;
   inc(dif7);
   dec(Pnk7,100);
 end;

 if note8 <> 0 then begin;
   tonhoehe := (Rm_Song[mli,8,1] and $0F)*256+Rm_Song[mli,8,2];
   get_pctune(tonhoehe,vk8,nk8,difb8);
 end;
 dif8 := difb8 * Rm_Song[mli,8,4];
 rdiff := dif8 / 4;
 dif8 := trunc(rdiff);
 Pnk8 := Pnk8 + round((rdiff-dif8)*100);
 if Pnk8 > 100 then begin;
   inc(dif8);
   dec(Pnk8,100);
 end;
 ls1 := loop_s[In_st1];
 ll1 := loop_l[In_st1];
 ls2 := loop_s[In_st2];
 ll2 := loop_l[In_st2];
 ls3 := loop_s[In_st3];
 ll3 := loop_l[In_st3];
 ls4 := loop_s[In_st4];
 ll4 := loop_l[In_st4];
 ls5 := loop_s[In_st5];
 ll5 := loop_l[In_st5];
 ls6 := loop_s[In_st6];
 ll6 := loop_l[In_st6];
 ls7 := loop_s[In_st7];
 ll7 := loop_l[In_st7];
 ls8 := loop_s[In_st8];
 ll8 := loop_l[In_st8];
 if ll1 > 30 then in1l := ll1+ls1;
 if ll2 > 30 then in2l := ll2+ls2;
 if ll3 > 30 then in3l := ll3+ls3;
 if ll4 > 30 then in4l := ll4+ls4;
 if ll5 > 30 then in5l := ll5+ls5;
 if ll6 > 30 then in6l := ll6+ls6;
 if ll7 > 30 then in7l := ll7+ls7;
 if ll8 > 30 then in8l := ll8+ls8;
end;
{$F-}

function Notenvolumen(Stm : byte) : byte;
begin;
 Notenvolumen := Rm_Song[mli,Stm,4];
end;

procedure nmw_all_4;
var idx : byte;
begin;
   inc(mli);
   if mli > 64 then mli := 1;
   if mli = 1 then begin;
     inc(mlj);
     if mlj > Liedlaenge then begin;
       if mloop then begin;
         mlj := 1;
         Modp := Addr(Rm_Song);
         memmovew(pt(rm[lied[mlj]]),pt(Modp),1024);
       end else begin;
         asm
           call [periodisch_anhalten]
         end;
         music_aus := true;
         Mod_Zu_Ende := true;
       end;
     end else begin;
         Modp := Addr(Rm_Song);
         memmovew(pt(rm[lied[mlj]]),pt(Modp),1024);
     end;
   end;

  note1 := (Rm_Song[mli,1,1] AND $F0)+((Rm_Song[mli,1,3] AND $F0) shr 4);
  note2 := (Rm_Song[mli,2,1] AND $F0)+((Rm_Song[mli,2,3] AND $F0) shr 4);
  note3 := (Rm_Song[mli,3,1] AND $F0)+((Rm_Song[mli,3,3] AND $F0) shr 4);
  note4 := (Rm_Song[mli,4,1] AND $F0)+((Rm_Song[mli,4,3] AND $F0) shr 4);

  if note1 <> 0 then
   begin;
    Noten_Anschlag[1] := 500;
    In_St1  := note1;
    if XMS then begin;
      freemem(Sampel1,sagr1);
      getmem(Sampel1,Sam_l[In_St1]);
      sagr1 := Sam_l[In_St1];
      Xms_2_Ram(In_St1,Sam_l[In_St1],Sampel1);
      inst1  := Ptr(pt(Sampel1).sgm,pt(Sampel1).ofs);
    end else begin;
      sagr1 := Sam_l[In_St1];
      inst1  := Ptr(pt(Samp[In_St1]).sgm,pt(Samp[In_St1]).ofs);
    end;
    i1     := pt(inst1);
    in1l   := Sam_l[In_St1];
    in1p   := 0;
    notvol1 := inst_vol[in_St1];
    Pnk1   := 0;
  end;

  if note2 <> 0 then
   begin;
    Noten_Anschlag[2] := 500;
    In_St2  := note2;
    if XMS then begin;
      freemem(Sampel2,sagr2);
      getmem(Sampel2,Sam_l[In_St2]);
      sagr2 := Sam_l[In_St2];
      Xms_2_Ram(In_St2,Sam_l[In_St2],Sampel2);
      inst2  := Ptr(pt(Sampel2).sgm,pt(Sampel2).ofs);
    end else begin;
      sagr2 := Sam_l[In_St2];
      inst2  := Ptr(pt(Samp[In_St2]).sgm,pt(Samp[In_St2]).ofs);
    end;
    i2     := pt(inst2);
    in2l   := Sam_l[In_St2];
    in2p   := 0;
    notvol2 := inst_vol[in_St2];
    Pnk2   := 0;
  end;

  if note3 <> 0 then
   begin;
    Noten_Anschlag[3] := 500;
    In_St3  := note3;
    if XMS then begin
      freemem(Sampel3,sagr3);
      getmem(Sampel3,Sam_l[In_St3]);
      sagr3 := Sam_l[In_St3];
      Xms_2_Ram(In_St3,Sam_l[In_St3],Sampel3);
      inst3  := Ptr(pt(Sampel3).sgm,pt(Sampel3).ofs);
    end else begin;
      sagr3 := Sam_l[In_St3];
      inst3  := Ptr(pt(Samp[In_St3]).sgm,pt(Samp[In_St3]).ofs);
    end;
    i3     := pt(inst3);
    in3l   := Sam_l[In_St3];
    in3p   := 0;
    notvol3 := inst_vol[in_St3];
    Pnk3   := 0;
  end;

  if note4 <> 0 then
   begin;
    Noten_Anschlag[4] := 500;
    In_St4  := note4;
    if XMS then begin;
      freemem(Sampel4,sagr4);
      getmem(Sampel4,Sam_l[In_St4]);
      sagr4 := Sam_l[In_St4];
      Xms_2_Ram(In_St4,Sam_l[In_St4],Sampel4);
      inst4  := Ptr(pt(Sampel4).sgm,pt(Sampel4).ofs);
    end else begin;
      sagr4 := Sam_l[In_St4];
      inst4  := Ptr(pt(Samp[In_St4]).sgm,pt(Samp[In_St4]).ofs);
    end;
    i4     := pt(inst4);
    in4l   := Sam_l[In_St4];
    in4p   := 0;
    notvol4 := inst_vol[in_St4];
    Pnk4   := 0;
  end;

 if Rm_Song[mli,1,3] and $0F <= 15 then begin;
   Eff1 := 0;
   case (Rm_Song[mli,1,3] and $0F) of
      01 : begin;
             PermUp_1 := 1;
           end;
      02 : begin;
             PermDo_1 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,1,4];
			     end;
      12 : begin;
             notvol1 := Notenvolumen(1);
           end;
      14 : begin;
             case (Rm_Song[mli,1,4] shr 4) of
                12 : begin;
                       in1l    := 0;
                       notvol1 := 0;
                       in1p    := 0;
                       Pnk1    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,1,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

  if Rm_Song[mli,2,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,2,3] and $0F) of
      01 : begin;
             PermUp_2 := 1;
           end;
      02 : begin;
             PermDo_2 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,2,4];
			     end;
      12 : begin;
             notvol2 := Notenvolumen(2);
           end;
      14 : begin;
             case (Rm_Song[mli,2,4] shr 4) of
                12 : begin;
                       in2l    := 0;
                       notvol2 := 0;
                       in2p    := 0;
                       Pnk2    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,2,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

  if Rm_Song[mli,3,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,3,3] and $0F) of
      01 : begin;
             PermUp_3 := 1;
           end;
      02 : begin;
             PermDo_3 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,3,4];
			     end;
      12 : begin;
             notvol3 := Notenvolumen(3);
           end;
      14 : begin;
             case (Rm_Song[mli,3,4] shr 4) of
                12 : begin;
                       in3l    := 0;
                       notvol3 := 0;
                       in3p    := 0;
                       Pnk3    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,3,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

  if Rm_Song[mli,4,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,4,3] and $0F) of
      01 : begin;
             PermUp_4 := 1;
           end;
      02 : begin;
             PermDo_4 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,4,4];
			     end;
      12 : begin;
             notvol4 := Notenvolumen(4);
           end;
      14 : begin;
             case (Rm_Song[mli,4,4] shr 4) of
                12 : begin;
                       in4l    := 0;
                       notvol4 := 0;
                       in4p    := 0;
                       Pnk4    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,4,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;
end;

procedure nmw_all_8;
var idx : byte;
begin;
   inc(mli);
   if mli > 64 then mli := 1;

   if mli = 1 then begin;
     inc(mlj);
     if mlj > Liedlaenge then begin;
       if mloop then begin;
         mlj := 1;
         Modp := Addr(Rm_Song);
         memmovew(pt(rm[lied[mlj]]),pt(Modp),1024);
       end else begin;
         asm
           call [periodisch_anhalten]
         end;
         music_aus := true;
         Mod_zu_ende := true;
       end;
     end else begin;
         Modp := Addr(Rm_Song);
         memmovew(pt(rm[lied[mlj]]),pt(Modp),1024);
     end;
   end;

  note1 := (Rm_Song[mli,1,1] AND $F0)+((Rm_Song[mli,1,3] AND $F0) shr 4);
  note2 := (Rm_Song[mli,2,1] AND $F0)+((Rm_Song[mli,2,3] AND $F0) shr 4);
  note3 := (Rm_Song[mli,3,1] AND $F0)+((Rm_Song[mli,3,3] AND $F0) shr 4);
  note4 := (Rm_Song[mli,4,1] AND $F0)+((Rm_Song[mli,4,3] AND $F0) shr 4);
  note5 := (Rm_Song[mli,5,1] AND $F0)+((Rm_Song[mli,5,3] AND $F0) shr 4);
  note6 := (Rm_Song[mli,6,1] AND $F0)+((Rm_Song[mli,6,3] AND $F0) shr 4);
  note7 := (Rm_Song[mli,7,1] AND $F0)+((Rm_Song[mli,7,3] AND $F0) shr 4);
  note8 := (Rm_Song[mli,8,1] AND $F0)+((Rm_Song[mli,8,3] AND $F0) shr 4);

  if note1 <> 0 then
   begin;
    Noten_Anschlag[1] := 500;
    In_St1  := note1;
    if XMS then begin;
      freemem(Sampel1,sagr1);
      getmem(Sampel1,Sam_l[In_St1]);
      sagr1 := Sam_l[In_St1];
      Xms_2_Ram(In_St1,Sam_l[In_St1],Sampel1);
      inst1  := Ptr(pt(Sampel1).sgm,pt(Sampel1).ofs);
    end else begin;
      sagr1 := Sam_l[In_St1];
      inst1  := Ptr(pt(Samp[In_St1]).sgm,pt(Samp[In_St1]).ofs);
    end;
    i1     := pt(inst1);
    in1l   := Sam_l[In_St1];
    in1p   := 0;
    notvol1 := inst_vol[in_St1];
    Pnk1   := 0;
  end;

  if note2 <> 0 then
   begin;
    Noten_Anschlag[2] := 500;
    In_St2  := note2;
    if XMS then begin;
      freemem(Sampel2,sagr2);
      getmem(Sampel2,Sam_l[In_St2]);
      sagr2 := Sam_l[In_St2];
      Xms_2_Ram(In_St2,Sam_l[In_St2],Sampel2);
      inst2  := Ptr(pt(Sampel2).sgm,pt(Sampel2).ofs);
    end else begin;
      sagr2 := Sam_l[In_St2];
      inst2  := Ptr(pt(Samp[In_St2]).sgm,pt(Samp[In_St2]).ofs);
    end;
    i2     := pt(inst2);
    in2l   := Sam_l[In_St2];
    in2p   := 0;
    notvol2 := inst_vol[in_St2];
    Pnk2  := 0;
  end;

  if note3 <> 0 then
   begin;
    Noten_Anschlag[3] := 500;
    In_St3  := note3;
    if XMS then begin;
      freemem(Sampel3,sagr3);
      getmem(Sampel3,Sam_l[In_St3]);
      sagr3 := Sam_l[In_St3];
      Xms_2_Ram(In_St3,Sam_l[In_St3],Sampel3);
      inst3  := Ptr(pt(Sampel3).sgm,pt(Sampel3).ofs);
    end else begin;
      sagr3 := Sam_l[In_St3];
      inst3  := Ptr(pt(Samp[In_St3]).sgm,pt(Samp[In_St3]).ofs);
    end;
    i3     := pt(inst3);
    in3l   := Sam_l[In_St3];
    in3p   := 0;
    notvol3 := inst_vol[in_St3];
    Pnk3   := 0;
  end;

  if note4 <> 0 then
   begin;
    Noten_Anschlag[4] := 500;
    In_St4  := note4;
    if XMS then begin;
      freemem(Sampel4,sagr4);
      getmem(Sampel4,Sam_l[In_St4]);
      sagr4 := Sam_l[In_St4];
      Xms_2_Ram(In_St4,Sam_l[In_St4],Sampel4);
      inst4  := Ptr(pt(Sampel4).sgm,pt(Sampel4).ofs);
    end else begin;
      sagr4 := Sam_l[In_St4];
      inst4  := Ptr(pt(Samp[In_St4]).sgm,pt(Samp[In_St4]).ofs);
    end;
    i4     := pt(inst4);
    in4l   := Sam_l[In_St4];
    in4p   := 0;
    notvol4 := inst_vol[in_St4];
    Pnk4   := 0;
  end;

  if note5 <> 0 then
   begin;
    Noten_Anschlag[5] := 500;
    In_St5  := note5;
    if XMS then begin;
      freemem(Sampel5,sagr5);
      getmem(Sampel5,Sam_l[In_St5]);
      sagr5 := Sam_l[In_St5];
      Xms_2_Ram(In_St5,Sam_l[In_St5],Sampel5);
      inst5  := Ptr(pt(Sampel5).sgm,pt(Sampel5).ofs);
    end else begin;
      sagr5 := Sam_l[In_St5];
      inst5  := Ptr(pt(Samp[In_St5]).sgm,pt(Samp[In_St5]).ofs);
    end;
    i5     := pt(inst5);
    in5l   := Sam_l[In_St5];
    in5p   := 0;
    notvol5 := inst_vol[in_St5];
    Pnk5   := 0;
  end;

  if note6 <> 0 then
   begin;
    Noten_Anschlag[6] := 500;
    In_St6  := note6;
    if XMS then begin;
      freemem(Sampel6,sagr6);
      getmem(Sampel6,Sam_l[In_St6]);
      sagr6 := Sam_l[In_St6];
      Xms_2_Ram(In_St6,Sam_l[In_St6],Sampel6);
      inst6  := Ptr(pt(Sampel6).sgm,pt(Sampel6).ofs);
    end else begin;
      sagr6 := Sam_l[In_St6];
      inst6  := Ptr(pt(Samp[In_St6]).sgm,pt(Samp[In_St6]).ofs);
    end;
    i6     := pt(inst6);
    in6l   := Sam_l[In_St6];
    in6p   := 0;
    notvol6 := inst_vol[in_St6];
    Pnk6   := 0;
  end;

  if note7 <> 0 then
   begin;
    Noten_Anschlag[7] := 500;
    In_St7  := note7;
    if XMS then begin;
      freemem(Sampel7,sagr7);
      getmem(Sampel7,Sam_l[In_St7]);
      sagr7 := Sam_l[In_St7];
      Xms_2_Ram(In_St7,Sam_l[In_St7],Sampel7);
      inst7  := Ptr(pt(Sampel7).sgm,pt(Sampel7).ofs);
    end else begin;
      sagr7 := Sam_l[In_St7];
      inst7  := Ptr(pt(Samp[In_St7]).sgm,pt(Samp[In_St7]).ofs);
    end;
    i7     := pt(inst7);
    in7l   := Sam_l[In_St7];
    in7p   := 0;
    notvol7 := inst_vol[in_St7];
    Pnk7   := 0;
  end;

  if note8 <> 0 then
   begin;
    Noten_Anschlag[8] := 500;
    In_St8  := note8;
    if XMS then begin;
      freemem(Sampel8,sagr8);
      getmem(Sampel8,Sam_l[In_St8]);
      sagr8 := Sam_l[In_St8];
      Xms_2_Ram(In_St8,Sam_l[In_St8],Sampel8);
      inst8  := Ptr(pt(Sampel8).sgm,pt(Sampel8).ofs);
    end else begin;
      sagr8 := Sam_l[In_St8];
      inst8  := Ptr(pt(Samp[In_St8]).sgm,pt(Samp[In_St8]).ofs);
    end;
    i8     := pt(inst8);
    in8l   := Sam_l[In_St8];
    in8p   := 0;
    notvol8 := inst_vol[in_St8];
    Pnk8   := 0;
  end;

 if Rm_Song[mli,1,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,1,3] and $0F) of
      01 : begin;
             PermUp_1 := 1;
           end;
      02 : begin;
             PermDo_1 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,1,4];
			     end;
      12 : begin;
             notvol1 := Notenvolumen(1);
           end;
      14 : begin;
             case (Rm_Song[mli,1,4] shr 4) of
                12 : begin;
                       in1l    := 0;
                       notvol1 := 0;
                       in1p    := 0;
                       Pnk1    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,1,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

  if Rm_Song[mli,2,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,2,3] and $0F) of
      01 : begin;
             PermUp_2 := 1;
           end;
      02 : begin;
             PermDo_2 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,2,4];
			     end;
      12 : begin;
             notvol2 := Notenvolumen(2);
           end;
      14 : begin;
             case (Rm_Song[mli,2,4] shr 4) of
                12 : begin;
                       in2l    := 0;
                       notvol2 := 0;
                       in2p    := 0;
                       Pnk2    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,2,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

  if Rm_Song[mli,3,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,3,3] and $0F) of
      01 : begin;
             PermUp_3 := 1;
           end;
      02 : begin;
             PermDo_3 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,3,4];
			     end;
      12 : begin;
             notvol3 := Notenvolumen(3);
           end;
      14 : begin;
             case (Rm_Song[mli,3,4] shr 4) of
                12 : begin;
                       in3l    := 0;
                       notvol3 := 0;
                       in3p    := 0;
                       Pnk3    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,3,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

  if Rm_Song[mli,4,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,4,3] and $0F) of
      01 : begin;
             PermUp_4 := 1;
           end;
      02 : begin;
             PermDo_4 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,4,4];
			     end;
      12 : begin;
             notvol4 := Notenvolumen(4);
           end;
      14 : begin;
             case (Rm_Song[mli,4,4] shr 4) of
                12 : begin;
                       in4l    := 0;
                       notvol4 := 0;
                       in4p    := 0;
                       Pnk4    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,4,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

 if Rm_Song[mli,5,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,5,3] and $0F) of
      01 : begin;
             PermUp_5 := 1;
           end;
      02 : begin;
             PermDo_5 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,5,4];
			     end;
      12 : begin;
             notvol5 := Notenvolumen(5);
           end;
      14 : begin;
             case (Rm_Song[mli,5,4] shr 4) of
                12 : begin;
                       in5l    := 0;
                       notvol5 := 0;
                       in5p    := 0;
                       Pnk5    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,5,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

  if Rm_Song[mli,6,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,6,3] and $0F) of
      01 : begin;
             PermUp_6 := 1;
           end;
      02 : begin;
             PermDo_6 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,6,4];
			     end;
      12 : begin;
             notvol6 := Notenvolumen(6);
           end;
      14 : begin;
             case (Rm_Song[mli,6,4] shr 4) of
                12 : begin;
                       in6l    := 0;
                       notvol6 := 0;
                       in6p    := 0;
                       Pnk6    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,6,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

  if Rm_Song[mli,7,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,7,3] and $0F) of
      01 : begin;
             PermUp_7 := 1;
           end;
      02 : begin;
             PermDo_7 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,7,4];
			     end;
      12 : begin;
             notvol7 := Notenvolumen(7);
           end;
      14 : begin;
             case (Rm_Song[mli,7,4] shr 4) of
                12 : begin;
                       in7l    := 0;
                       notvol7 := 0;
                       in7p    := 0;
                       Pnk7    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,7,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;

  if Rm_Song[mli,8,3] and $0F <= 15 then begin;
   case (Rm_Song[mli,8,3] and $0F) of
      01 : begin;
             PermUp_8 := 1;
           end;
      02 : begin;
             PermDo_8 := 1;
           end;
      13 : begin;
			       mli := 64;
			     end;
      11 : begin;
			       mli := 64;
						 mlj := Rm_Song[mli,8,4];
			     end;
      12 : begin;
             notvol8 := Notenvolumen(8);
           end;
      14 : begin;
             case (Rm_Song[mli,8,4] shr 4) of
                12 : begin;
                       in8l    := 0;
                       notvol8 := 0;
                       in8p    := 0;
                       Pnk8    := 0;
                     end;
             end;
           end;
      15 : begin;
             idx := Rm_Song[mli,8,4];
             if idx < 32 then begin;
               Playspeed    := idx;
               modmultiply  := ModPara[idx].mult;
               Speed        := ModPara[idx].Speed;
               blockgroesse := ModPara[idx].bgr;
               Dma_abbruch  := ModPara[idx].Ab;
             end;
			     end;
    end;
  end;
end;

procedure initialisiere_vermischen;
begin;
  ziel := pt(blk);
  asm
    call [vermische_proc]
  end;
end;

FUNCTION ConvertString(Source : Pointer; Size : BYTE):String;
VAR
   WorkStr : String;
BEGIN
   Move(Source^,WorkStr[1],Size);
   WorkStr[0] := CHR(Size);
   ConvertString := WorkStr;
END;

function init_Song : boolean;
const kenn1 : string = 'FLT4';
      kenn2 : string = 'M.K.';
      kenn3 : string = '8CHN';
var rmod : file;
    sgr : word;                         { Gre eines Sampels        }
    inststart : longint; { Position in Datei, wo Sampledaten starten }
    datgr : longint;                    { Die Gre der MOD - Datei  }
    Mkg : array[1..4] of char;          { fr Modtyp - Erkennung     }
    hilfsp : ^byte;
    strptr : pointer;
    kennch : array[1..4] of char;
    kennstr : string;
    instanz : byte;
    idx : integer;
begin;
 In_St1 := 0;
 In_St2 := 0;
 In_St3 := 0;
 In_St4 := 0;
 In_St5 := 0;
 In_St6 := 0;
 In_St7 := 0;
 In_St8 := 0;
 getmem(blk,8000);            { Speicher fr Datenpuffer reservieren }
 fillchar(blk^,8000,127);
 for mlj := 0 to 128 do
   Lied[mlj] := 0;
 {$I-}
 assign(rmod,Mod_Name);
 reset(rmod,1);
 {$I+}
 if IOresult <> 0 then begin;
   init_song := false;
   exit;
 end;
 if moddatgroesse <> 0 then datgr := moddatgroesse else
 datgr := filesize(rmod);
 inststart := datgr;
 seek(rmod,1080);
 blockread(rmod,kennch,4);
 kennstr := kennch;
 if (kennstr <> kenn1) and (kennstr <> kenn2)
 and (kennstr <> kenn3) then begin;
   instanz := 15;
 end else begin;
   instanz := 31;
 end;

 if instanz = 31 then begin;  { 31 Stimmen ber Kennung ermittelt     }
 for mlj := 1 to 31 do begin;
  idx := mlj;
  seek(rmod,msp+42+(idx-1)*30);
  blockread(rmod,sgr,2);
  sgr := swap(sgr) * 2;
  if sgr <> 0 then inststart := inststart - sgr;
  Sam_l[idx] := sgr;
  seek(rmod,msp+45+(idx-1)*30);
  blockread(rmod,inst_vol[idx],1);
  blockread(rmod,loop_s[idx],2);
  blockread(rmod,loop_l[idx],2);
  loop_s[idx] := swap(loop_s[idx])*2;
  loop_l[idx] := swap(loop_l[idx])*2;
 end;

 seek(rmod,msp+1080);
 blockread(rmod,Mkg,4);
 if ((Mkg[1] = '8') AND (Mkg[2] = 'C'))
 AND ((Mkg[3] = 'H') AND (Mkg[4] = 'N')) then begin
 { 8- Stimmige MOD-Datei }
   Pattgroesse    := 2048;
   Stimmen        := 8;
   Vermische_Proc := @vermische_start_8;
   nmw_Proc       := @nmw_all_8;
   if stereo then
     innen_proc     := @innen_schleife_8_stereo
   else
     innen_proc     := @innen_schleife_8;
 end else begin;
 { 4-Stimmige MOD-Datei }
   Pattgroesse    := 1024;
   Stimmen        := 4;
   Vermische_Proc := @vermische_start_4;
   nmw_Proc       := @nmw_all_4;
   if stereo then
     innen_proc     := @innen_schleife_4_stereo
   else
     innen_proc     := @innen_schleife_4;
 end;

 seek(rmod,msp+inststart);
 for mlj := 1 to 31 do begin;
  idx := mlj;
   if XMS then begin;
     getmem(Samp[idx],Sam_l[idx]);
     getmem_Xms(idx,(sam_l[idx] DIV 1024)+1);
     blockread(rmod,Samp[idx]^,sam_l[idx]);
     Ram_2_Xms(Samp[idx],sam_l[idx],idx);
     freemem(Samp[idx],Sam_l[idx]);
   end else begin;
     getmem(Samp[idx],Sam_l[idx]);
     blockread(rmod,Samp[idx]^,sam_l[idx]);
   end;
 end;

 datgr := inststart - 1083;
 pat_anz := datgr div Pattgroesse;
 for mlj := 0 to pat_anz-1 do begin;
   getmem(rm[mlj],2048);
   fillchar(rm[mlj]^,2048,0);
   seek(rmod,msp+1084+mlj*Pattgroesse);
   hilfsp := ptr(seg(rm[mlj]^),ofs(rm[mlj]^));
   for mli := 0 to 63 do begin;
     hilfsp := ptr(seg(rm[mlj]^),ofs(rm[mlj]^)+mli*32);
  	 blockread(rmod,hilfsp^,Pattgroesse div 64);
   end;
 end;
 seek(rmod,msp+952);
 blockread(rmod,Lied,128);

 getmem(strptr,25);
 for i := 0 to 30 do begin;
   seek(rmod,msp+20+i*30);
   blockread(rmod,strptr^,22);
   instnamen[i+1] := convertstring(strptr,22);
 end;
 seek(rmod,msp);
 blockread(rmod,strptr^,20);
 songname := convertstring(strptr,20);
 freemem(strptr,25);

 seek(rmod,msp+950); { von 470}
 blockread(rmod,Liedlaenge,1);
 end else begin;
 for mlj := 1 to 15 do begin;
  seek(rmod,msp+42+(mlj-1)*30);
  blockread(rmod,sgr,2);
  sgr := swap(sgr) * 2;
  if sgr <> 0 then inststart := inststart - sgr;
  Sam_l[mlj] := sgr;
  seek(rmod,msp+45+(mlj-1)*30);
  blockread(rmod,inst_vol[mlj],1);
  blockread(rmod,loop_s[mlj],2);
  blockread(rmod,loop_l[mlj],2);
  loop_s[mlj] := swap(loop_s[mlj])*2;
  loop_l[mlj] := swap(loop_l[mlj])*2;
 end;

 for mlj := 16 to 31 do begin;
  Sam_l[mlj] := 0;
  loop_s[mlj] := 0;
  loop_l[mlj] := 0;
 end;

 Pattgroesse    := 1024;
 Stimmen        := 4;
 Vermische_Proc := @vermische_start_4;
 nmw_Proc       := @nmw_all_4;
 if stereo then
   innen_proc     := @innen_schleife_4_stereo
 else
   innen_proc     := @innen_schleife_4;

 seek(rmod,msp+inststart);
 for mlj := 1 to 15 do begin;
   if XMS then begin;
     getmem(Samp[mlj],Sam_l[mlj]);
     getmem_Xms(mlj,(sam_l[mlj] DIV 1024)+1);
     blockread(rmod,Samp[mlj]^,sam_l[mlj]);
     Ram_2_Xms(Samp[mlj],sam_l[mlj],mlj);
     freemem(Samp[mlj],Sam_l[mlj]);
   end else begin;
     getmem(Samp[mlj],Sam_l[mlj]);
     blockread(rmod,Samp[mlj]^,sam_l[mlj]);
   end;
 end;

 datgr := inststart - 603;
 pat_anz := datgr div Pattgroesse;
 for mlj := 0 to pat_anz-1 do begin;
   getmem(rm[mlj],2048);
   fillchar(rm[mlj]^,2048,0);
   seek(rmod,msp+1084+mlj*Pattgroesse);
   hilfsp := ptr(seg(rm[mlj]^),ofs(rm[mlj]^));
   for mli := 0 to 63 do begin;
     hilfsp := ptr(seg(rm[mlj]^),ofs(rm[mlj]^)+mli*32);
  	 blockread(rmod,hilfsp^,Pattgroesse div 64);
   end;
 end;
 seek(rmod,msp+472);
 blockread(rmod,Lied,128);

 getmem(strptr,25);
 for i := 0 to 14 do begin;
   seek(rmod,msp+20+i*30);
   blockread(rmod,strptr^,22);
   instnamen[i+1] := convertstring(strptr,22);
 end;

 for i := 15 to 30 do begin;
   instnamen[i+1] := '';
 end;
 seek(rmod,msp);
 blockread(rmod,strptr^,20);
 songname := convertstring(strptr,20);
 freemem(strptr,25);

 seek(rmod,msp+470);
 blockread(rmod,Liedlaenge,1);
 end;


 mlj := 0;
 mli := 0;
 close(rmod);
 init_song := true;
end;

procedure exit_song;
begin;
 Port[dsp_adr+$C] := $D3;
 halt(0);
end;

procedure Free_Soundmem;
{
 Reservierten Speicher wieder frei geben
}
begin;
 if music_played then begin;
 freemem(blk,8000);
 freemem(Sampel1,Sagr1);
 freemem(Sampel2,Sagr2);
 freemem(Sampel3,Sagr3);
 freemem(Sampel4,Sagr4);
 freemem(Sampel5,Sagr5);
 freemem(Sampel6,Sagr6);
 freemem(Sampel7,Sagr7);
 freemem(Sampel8,Sagr8);
 for mlj := 0 to pat_anz-1 do begin;
   freemem(rm[mlj],2048);
 end;
 end;
end;

procedure init_sbperiod(p : pointer);
begin;
  periodisch_anhalten := p;
end;

function xms_avail : integer;
{Funktion liefert den Wert 0, wenn XMS belegt werden konnte,
                          -1, wenn kein XMS vorhanden ist,
  ansonsten den freien XMS-Speicher in KB ... }
begin;
  XMSExists:=false;
  with XReg do
  begin
    ax:=$4300;   { Prfung, ob XMS installiert }
    MpxCall(XReg);
    if ax and $00FF = $80 then
    begin   { XMS ist installiert }
      ax:=$4310;   { XMS-Treiber-Einsprungpunkt ermitteln }
      MpxCall(XReg);
      XMSDrv:=Ptr(si,bx);   { Das ES-Register liefert MpxCall in SI zurck! }
      XMSExists:=true;
      { Treiberversion ermitteln }
      ax:=0;
      XMSCall(XReg);
      XMSVersion:=ax;
      XMMVersion:=bx;
      HMAExists:=dx=1;
    end;
  end;
 if not XmsExists then begin;
   xms_avail := -1;
 end else begin;
  XReg.ax:=$0800;
  XMSCall(XReg);
  if XReg.dx < MinXms then begin;
    xms_avail := XReg.dx;
  end else begin;
    XMSMaxFree := XReg.dx;
    xms_avail := 0;
  end;
 end;
end;

procedure getmem_XMS(Hdlidx : byte;groesse : word);
{
 Hdlidx = Index in Handles,  groesse in KB !
}
begin;
  XRegs.ax := $0900;
  XRegs.dx := groesse;
  XMSCall(XRegs);
  Handles[Hdlidx] := XRegs.dx;
end;

procedure dispose_XMS(Hdlidx : byte);
begin;
  XRegs.ax := $0A00;
  XRegs.dx := Handles[Hdlidx];
  XMSCall(XRegs);
end;

procedure Ram_2_XMS(Sorce : pointer;Laenge : longint;Hdlidx : byte);
begin;
  with EMBParam do begin;
    Blocklen := Laenge;
    SrcHandle := 0;      { Ram }
    SrcOffset := Sorce;
    DestHandle := Handles[Hdlidx];
    DestOffset := nil;
  end;
  XRegs.ax := $0B00;
  XRegs.si := OFS(EMBParam);
  XMSCall(XRegs);
end;

procedure XMS_2_Ram(Hdlidx : byte;Laenge : longint;Dest : pointer);
{
 Kopiert Laenge Bytes aus dem ber Handles indizierten XMS in das
 ber Dest bergebene Ziel
}
begin;
  with EMBParam do begin;
    Blocklen := Laenge;
    SrcHandle := Handles[Hdlidx];
    SrcOffset := nil;
    DestHandle := 0; { Ram }
    DestOffset := Dest;
  end;
  XRegs.ax := $0B00;
  XRegs.si := OFS(EMBParam);
  XMSCall(XRegs);
end;

function pruefe_Minxms(minw : word) : integer;
begin;
  MinXms := minw;
  pruefe_Minxms := Xms_avail;
end;

procedure mod_SetLoopflag(loopen : boolean);
begin;
 mloop := loopen;
end;

procedure mod_SetMultiply(msm : word);
begin;
 modmultiply := msm;
end;

procedure mod_SetLoop(msl : word);
begin;
 Sound_Schleifen := msl;
 loop3 := msl;
end;

procedure mod_SetSpeed(msp : word);
begin;
 speed := msp;
 Speed3 := msp;
end;

procedure mod_autodetect(what : boolean);
begin;
 if what then mautodet := true else mautodet := false;
end;

procedure mod_transpose(transposerwert : integer);
begin;
  tpw := transposerwert;
end;

procedure init_data;
Var i,j : integer;
begin;
 m_played := false;
 getmem(Sampel1,10);
 getmem(Sampel2,10);
 getmem(Sampel3,10);
 getmem(Sampel4,10);
 getmem(Sampel5,10);
 getmem(Sampel6,10);
 getmem(Sampel7,10);
 getmem(Sampel8,10);
 Sagr1 := 10;
 Sagr2 := 10;
 Sagr3 := 10;
 Sagr4 := 10;
 Sagr5 := 10;
 Sagr6 := 10;
 Sagr7 := 10;
 Sagr8 := 10;
 In_St1 := 0;
 In_St2 := 0;
 In_St3 := 0;
 In_St4 := 0;
 In_St5 := 0;
 In_St6 := 0;
 In_St7 := 0;
 In_St8 := 0;
 Note1 := 0;
 Note2 := 0;
 Note3 := 0;
 Note4 := 0;
 Note5 := 0;
 Note6 := 0;
 Note7 := 0;
 Note8 := 0;
 Noten_Anschlag[1] := 0;
 Noten_Anschlag[2] := 0;
 Noten_Anschlag[3] := 0;
 Noten_Anschlag[4] := 0;
 Noten_Anschlag[5] := 0;
 Noten_Anschlag[6] := 0;
 Noten_Anschlag[7] := 0;
 Noten_Anschlag[8] := 0;
 in1l := 0; in2l := 0; in3l := 0; in4l := 0;
 in5l := 0; in6l := 0; in7l := 0; in8l := 0;
 notvol1 := 0; notvol2 := 0; notvol3 := 0; notvol4 := 0;
 notvol5 := 0; notvol6 := 0; notvol7 := 0; notvol8 := 0;
 fillchar(Rm_Song,2048,0);
end;

procedure init_Paramtable;
var ls : byte;
    h : real;
begin;
  playspeed := 6;
  for ls := 1 to 31 do begin;
    if ls <= 3 then
      ModPara[ls].mult := 95
    else
      ModPara[ls].mult := 100;
    ModPara[ls].Speed := ls*ModPara[ls].mult div 10;
    ModPara[ls].bgr := ModPara[ls].Speed*Sound_Schleifen;
    h := Sampling_Frequenz / ModPara[ls].bgr;
    ModPara[ls].Ab := round((timer_per_second/h) * 0.9);
   end;
end;

procedure mod_Samplefreq(Rate : integer);
var h : real;
begin;
  case Rate of
     08 : begin;
            Sampling_Rate := 131;
            set_timeconst_sb16(131);
            mod_transpose(1);
            mod_SetLoop(15);
            blockgroesse := Speed * Sound_Schleifen;
            Sampling_Frequenz := 8000;
            h := Sampling_Frequenz / blockgroesse;
            Dma_abbruch := round((timer_per_second/h) * sensib);
            init_Paramtable;
          end;
     10 : begin;
            Sampling_Rate := 156;
            set_timeconst_sb16(156);
            mod_transpose(5);
            mod_SetLoop(19);
            blockgroesse := Speed * Sound_Schleifen;
            Sampling_Frequenz := 10000;
            h := Sampling_Frequenz / blockgroesse;
            Dma_abbruch := round((timer_per_second/h) * sensib);
            init_Paramtable;
          end;
     13 : begin;
            Sampling_Rate := 181;
            set_timeconst_sb16(181);
            mod_transpose(10);
            mod_SetLoop(25);
            blockgroesse := Speed * Sound_Schleifen;
            Sampling_Frequenz := 13333;
            h := Sampling_Frequenz / blockgroesse;
            Dma_abbruch := round((timer_per_second/h) * sensib);
            init_Paramtable;
          end;
     16 : begin;
            Sampling_Rate := 196;
            set_timeconst_sb16(196);
            mod_transpose(14);
            mod_SetLoop(32);
            blockgroesse := Speed * Sound_Schleifen;
            Sampling_Frequenz := 16666;
            h := Sampling_Frequenz / blockgroesse;
            Dma_abbruch := round((timer_per_second/h) * sensib);
            init_Paramtable;
          end;
     22 : begin;
            Sampling_Rate := 211;
            set_timeconst_sb16(211);
            mod_transpose(19);
            mod_SetLoop(42);
            blockgroesse := Speed * Sound_Schleifen;
            Sampling_Frequenz := 22222;
            h := Sampling_Frequenz / blockgroesse;
            Dma_abbruch := round((timer_per_second/h) * sensib);
            init_Paramtable;
          end;
   end;
end;

procedure gsreg; assembler;
asm
 mov gax,ax
 mov gbx,bx
 mov gcx,cx
 mov gdx,dx
 mov gsi,si
 mov gdi,di
 mov ax,es
 mov ges,ax
 mov ax,ds
 mov gds,ax
end;

procedure grreg; assembler;
asm
 mov bx,gbx
 mov cx,gcx
 mov dx,gdx
 mov si,gsi
 mov di,gdi
 mov ax,ges
 mov es,ax
 mov ax,gds
 mov ds,ax
 mov ax,gax
end;

{$F+}
procedure Sound_handler;
begin;
 if mycli <> 0 then exit;
 mycli := 1;
 inc(Loop_pos);
 if (Loop_pos > Speed) then begin;

   if phase_2 then begin;
     asm
       call [nmw_proc]
     end;
     Initialisiere_Vermischen;
     phase_2 := false;
     phase_1 := true;
     if outfading then
       if outvolume >= 5 then dec(outvolume,5);
   end;
 end else begin;
 if Noten_Anschlag[1] > 1 then dec(Noten_Anschlag[1]);
 if Noten_Anschlag[2] > 1 then dec(Noten_Anschlag[2]);
 if Noten_Anschlag[3] > 1 then dec(Noten_Anschlag[3]);
 if Noten_Anschlag[4] > 1 then dec(Noten_Anschlag[4]);
 if Noten_Anschlag[5] > 1 then dec(Noten_Anschlag[5]);
 if Noten_Anschlag[6] > 1 then dec(Noten_Anschlag[6]);
 if Noten_Anschlag[7] > 1 then dec(Noten_Anschlag[7]);
 if Noten_Anschlag[8] > 1 then dec(Noten_Anschlag[8]);
   asm
     call [innen_proc]
   end;
 end;
 mycli := 0;
end;
{$F-}

{$F+}
procedure calculate_music; assembler;
asm
 cmp mycli,0
 jne  @ende_stop
 cmp  music_aus,0
 jne   @ende_stop
 call gsreg
 call Sound_handler
 call grreg
 @ende_stop:
end;
{$F-}

procedure mod_waitretrace(num : byte);
var dl : integer;
begin;
 for dl := 1 to num do
    calculate_music;
 in_retrace := true;
asm
  push dx
@l1:
  mov dx,3dah
  in al,dx
  and al,8h
  jnz @l1
@l2:
  mov dx,3dah
  in al,dx
  and al,8h
  jz @l2
  pop dx
End;
 in_retrace := false;
end;

procedure StelleTimerEin(Proc : pointer; Freq : word);
var izaehler : word;
    oldv : pointer;
begin;
 asm cli end;
 izaehler := 1193180 DIV Freq;
 Port[$43] := $36;
 Port[$40] := Lo(IZaehler);
 Port[$40] := Hi(IZaehler);

 Getintvec(8,OldV);
 setintvec(OldTimerInt,OldV);
 SetIntVec(8,Proc);
 old_tZaehler := 1;
 seczaehler  := 0;
 Altintzaehler := 0;
 asm sti end;
end;

procedure StelleTimerAus;
var oldv : pointer;
begin;
  asm cli end;
  port[$43] := $36;
  Port[$40] := 0;
  Port[$40] := 0;
  GetIntVec(OldTimerInt,OldV);
  SetIntVec(8,OldV);
  asm sti end;
end;

procedure NeuerTimer; interrupt;
var dr : registers;
begin;
 syreg;
 inc(perfcount);

 inc(Seczaehler);
 inc(Altintzaehler);
 if Altintzaehler = 58 then begin;
   Altintzaehler := 0;
   intr(Oldtimerint,dr);
 end;
 if Seczaehler = timer_per_second then begin;
   Seczaehler := 0;
   inc(Laufsec);
   if Laufsec = 60 then begin;
     inc(Laufmin);
     Laufsec := 0;
   end;
 end;
 if not in_retrace then calculate_Music;
 Port[$20] := $20;
 ryreg;
end;

function Lade_Soundeffekt(s : string;var ef : effect_type) : integer;
Const Voice_Kenn : string = 'Creative Voice File';
var efi : file;
    kennarr : array[1..19] of char;
    Kennung : string;
    samrate : byte;
    realrate : word;
    realwert : real;
begin;
  assign(efi,s);
  reset(efi,1);
  {$I+}
  if doserror <> 0 then begin;
    {$I-}
     Lade_Soundeffekt := -1;            { Datei nicht gefunden       }
     exit;
	end;
  {$I-}
  blockread(efi,kennarr,19);
  Kennung := kennarr;
  if (Kennung = Voice_Kenn) or (Pos('.voc',s) <> 0) or (Pos('.VOC',s) <> 0)
	then begin;                           { VOC - File !               }
    seek(efi,30);
    blockread(efi,samrate,1);
    realrate := 1000000 DIV (256-samrate);
    ef.sr := realrate;
    seek(efi,32);
    ef.l := filesize(efi)-32;
  end else begin;
    ef.l := filesize(efi);
  end;
  if Maxavail < ef.l then begin;
     Lade_Soundeffekt := -2;            { Zuwenig Speicher !!!       }
     exit;
  end;
  getmem(ef.p,ef.l);
  blockread(efi,ef.p^,ef.l);
  close(efi);
  Playeffect := false;
  Lade_Soundeffekt := 0;
end;

procedure dispose_Soundeffekt(ef : effect_type);
begin;
  freemem(ef.p,ef.l);
end;

procedure Starte_Soundeffekt(ef:effect_type;frequenz,Vol,styp : word);
var realwert : real;
begin;
  effektgroesse := ef.l;
  if frequenz = DETECT then begin;
    frequenz := ef.sr;
  end;
  realwert := frequenz / Sampling_frequenz;
  Effvk    := trunc(realwert);
  Effnk    := round((realwert-Effvk)*100);
  Effekt   := pt(ef.p);
  Effistvk := Effekt.ofs;
  Effistnk := 0;
  Effektposi := 0;
  effectvolume := vol;
  converteff   := styp;
  Playeffect := true;
end;

procedure writexy(x,y : integer;s : string);
begin;
 gotoxy(x,y);
 write(s);
end;

function lade_moddatei(modname : string;ispeed,iloop : integer;freq : byte) : integer;
var df : file;
    sterreg : byte;
    fgr : longint;
begin;
 PLAYING_MOD := true;
 PLAYING_VOC := false;
 outfading := false;
 outvolume := 63;
 Mod_Name := modname;
 assign(df,Mod_name);
 reset(df,1);
 {$I+}
 if IOResult <> 0 then begin;
   {$I-}
   close(df);
   lade_moddatei := -1;                 { Datei nicht gefunden !     }
   exit;
 end;
 {$I-}
 fgr := filesize(df);
 close(df);
 music_played := true;
 music_aus := false;
 Mod_zu_ende := false;
 if (pruefe_MinXms(fgr DIV 1024) <> 0) or not xms then begin;
   if maxavail < fgr+30000 then begin;
     lade_moddatei := -2;
     exit;
   end;
 end;

 if ispeed <> AUTO then Speed3 := ispeed;
 if iloop <> AUTO then Loop3  := iloop;
 if force_mono then stereo := false;
 if force_sb then begin;
   if Sb16Detected then stereo := false;
   Sb16Detected := false;
 end;

 if SBProdetected then begin;
   if stereo then begin;
     sterreg := Read_Mixer($0e);
     write_Mixer($0e,sterreg OR 2);
   end else begin;
     sterreg := Read_Mixer($0e);
     write_Mixer($0e,sterreg AND $FD);
   end;
 end;
 init_data;
 if init_song then begin;
   phase_1 := false;
   phase_2 := true;
   mycli := 0;
   Speed := Speed3;
   Sound_Schleifen := loop3;
   asm call [nmw_proc] end;
   mod_Samplefreq(freq);
   set_timeconst_sb16(Sampling_Rate);
   Initialisiere_Vermischen;
   Laufsec := 0;
   Laufmin := 0;
   wr_dsp_sb16($D1);
   if sb16detected or sbprodetected then begin;
	   filter_Mid;
     Set_Balance(Balance);
     Set_Volume(Mastervolume);
   end;
   Lade_Moddatei := 0;
 end else begin;
   Lade_Moddatei := -3;  { Fehler beim Laden des Songs }
 end;
end;

procedure ende_mod;
var mlj : integer;
begin;
 Free_Soundmem;
 for mlj := 1 to 31 do begin;
  if XMS then begin;
    dispose_Xms(mlj);
  end else begin;
    freemem(Samp[mlj],Sam_l[mlj]);
  end;
 end;
 mod_terminated := true;
end;

Procedure periodisch_on;
Begin
 letzte_ausgabe := false;
 for Loop_pos := 1 to Speed do begin;
   asm
     call [innen_proc]
   end;
 end;
 dsp_block_sb16(blockgroesse,blk,true,false);
 Loop_pos := 0;
 asm
   call [nmw_proc]
 end;
 Initialisiere_Vermischen;

 init_sbperiod(@periodisch_off);
 music_played := true;
 StelleTimerEin(@NeuerTimer,timer_per_second);
End;

Procedure periodisch_off;
Begin
  letzte_ausgabe := true;
  StelleTimerAus;
End;

procedure Fade_Musix_out;
begin;
  outfading := true;
end;

{$F+}
procedure MODExitProc;
var mlj : byte;
 begin
 ExitProc := SaveExitProc;
{ if music_played then periodisch_off;}
 if not mod_terminated and music_played then ende_mod;
 Exit_Sb16;
end;
{$F-}

procedure dsp_int_sb16; interrupt;
{
 Diese Procedure wird durch den Interrupt angesprungen, der am Ende
 einer Blockbertragung generiert wird. Wenn nicht das Flag
 letzte_ausgabe gesetzt ist, wird eine neue Ausgabe gestartet
}
var h : byte;
begin;
  if interrupt_check then begin;
    IRQDetected := true;
  end else begin;
    if PLAYING_MOD then begin;
      h := port[dsp_adr+$E];
      dsp_rdy_sb16 := true;

      if not letzte_ausgabe then begin;
        dsp_block_sb16(blockgroesse,blk,true,false);
        phase_1 := false;
        phase_2 := true;
        Loop_pos := 0;
      end;
    end;

  end;
  Port[$20] := $20;
end;

procedure detect_sbIRQ;
{
 Diese Routine erkennt den IRQ der Soundblaster-Karte. Es werden dazu
 alle mglichen Interrupts durchgetestet. Dazu werden kurze Blocke
 via DMA ausgegeben. Wenn am Ende der Ausgabe der eingestellte Inter-
 rupt angesprungen wird, so ist der richtige gefunden
}
const moegliche_irqs : array[1..5] of byte = ($2,$3,$5,$7,$10);
var i : integer;
    h : byte;
begin;
 getintvec($8+dsp_irq,intback);         { Werte sichern !            }
 port21 := port[$21];
 getmem(blk,1200);
 fillchar(blk^,1200,127);
 set_Timeconst_sb16(211);
 wr_dsp_sb16($D3);                      { Lautsprecher aus           }
 i := 1;
 interrupt_check := true;
 while (i <= 5) and (not IRQDetected) do
   begin;
     dsp_irq := moegliche_irqs[i];      { zu Testender IRQ           }
     getintvec($8+dsp_irq,oldint);      { Interrupt Verbiegen        }
     setintvec($8+dsp_irq,@Dsp_Int_sb16);
     irqmsk := 1 shl dsp_irq;
     port[$21] := port[$21] and not irqmsk;
     Sampling_Rate := 211;
     blockgroesse := 1200;                { testweise Ausgabe          }
     dsp_block_sb16(blockgroesse,blk,true,false);
     delay(150);
     setintvec($8+dsp_irq,oldint);      { Interrupt wieder zurck    }
     port[$21] := Port[$21] or irqmsk;
     h := port[dsp_adr+$E];
     Port[$20] := $20;
     inc(i);
   end;
 interrupt_check := false;
 wr_dsp_sb16($D1);                      { Lautsprecher wieder ein    }
 freemem(blk,1200);
 setintvec($8+dsp_irq,intback);         { Alte Werte zurck !!!      }
 port[$21] := port21;
 dsp_rdy_sb16 := true;
end;

function Init_Sb16 : boolean;
{
 Diese Function initialisiert den Soundblaster. Sie liefert TRUE
 zurck, wenn die Initialisierung erfolgreich war, ansonsten FALSE.
 Der Lautsprecher fr Sampling-Ausgabe wird eingeschaltet. Der
 DMA-Ready Interrupt wird auf eine eigene Routine verbogen.
}
begin;
  if not detect_Reg_sb16 then begin;
    Init_Sb16 := false;
    exit;
  end;
{ Soundblaster gefunden      }
 if not force_irq then detect_sbIRQ;    { IRQ auto-detection         }
   test_uebertragung;
 if not force_irq then detect_sbIRQ;    { 2. Test fr SB ntig !     }
 if Detect_Mixer_sb16 then begin;
   SbProDetected := TRUE;               { SB Pro gefunden            }
 end;
 SbGetDspVersion;
 if SbVersMaj >= 4 then begin;                { SB 16 ASP gefunden         }
   Sb16Detected := true;
   SBProDetected := false;
 end;
 wr_dsp_sb16($D1);                      { Lautsprecher ein           }
 getintvec($8+dsp_irq,oldint);          { Alten Interrupt sichern,   }
 setintvec($8+dsp_irq,@dsp_int_sb16);   { auf eigene Routine setzen  }
 irqmsk := 1 shl dsp_irq;               { Interrupt einmaskieren     }
 port[$21] := port[$21] and not irqmsk;
end;

function init_The_Mod : boolean;
begin;
 mod_autodetect(on);  { Wenn true werden Speed-Angaben im Song erkannt      }
 mod_SetSpeed(66);
 mod_SetMultiply(11);
 mod_Setloopflag(ON); { Soll die Ausgabe wieder von Vorne beginnen, wenn am }
                      { Ende angekommen ?  (ON / OFF)                       }
 if not init_sb16 then             { Speaker einschalten, automatische Erkennung         }
   init_the_mod := false
 else begin;
   init_the_mod := true;
   mod_Samplefreq(Samfreq);
 end;
{ clrscr;}
end;

procedure init_sb;
begin;
  init_sb16;
end;

begin;
 SaveExitProc := ExitProc;
 ExitProc := @MODExitProc;
 dsp_rdy_sb16 := true;
 mod_terminated := false;
 music_played := false;
 mloop := true;
 mli := 0;
 mlj := 0;
 tpw := 5;
 In_St1 := 0;
 In_St2 := 0;
 In_St3 := 0;
 In_St4 := 0;
 In_St5 := 0;
 In_St6 := 0;
 In_St7 := 0;
 In_St8 := 0;
 loop_pos := 0;
 mautodet := true;
 modmultiply := 20;
 Sound_Schleifen := 10;
 Noten_Anschlag[1] := 0;
 Noten_Anschlag[2] := 0;
 Noten_Anschlag[3] := 0;
 Noten_Anschlag[4] := 0;
 Noten_Anschlag[5] := 0;
 Noten_Anschlag[6] := 0;
 Noten_Anschlag[7] := 0;
 Noten_Anschlag[8] := 0;
 getmem(blk1,2500);
 getmem(blk2,2500);
end.

