
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. PlayVOC1 : Ein Programm zum Abspielen von VOC-Dateien mit komfor-   }
{                  tablen Funktionen wie Anhalten der VOICE-Ausgabe, Laut-  }
{                  strkeregelung, Filtereinstellung u.a. Dieses Programm   }
{                  benutzt den Treiber CT-VOICE.                            }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : PLAYVOC1.PAS                                             }
{ entwickelt am  : 12.05.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.08                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM PlayVOC1;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$D-}                                        { keine Debugger-Informationen }
{$F+}                                                { FAR-Aufrufe erlauben }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

{$M 16384,131072,655360}       { 16 KB Stack, min. 128 KB Heap, max. 640 KB }

USES CRT, DOS, SBDrv;                 { CRT-, DOS- und SBDrv-Unit einbinden }

CONST

  BufSize = 60*1024;                                          { Puffergre }

  {-------------------------------------------------------------------------}
  { Tastaturcodes                                                           }
  {-------------------------------------------------------------------------}

  kb_Esc   = #27;
  kb_Space = #32;
  kb_l     = 'l';
  kbL      = 'L';
  kb_r     = 'r';
  kbR      = 'R';
  kb_f     = 'f';

TYPE

  IDString = ARRAY[0..$13] OF Char;                { Identifikations-String }

  {=========================================================================}
  { PVOCRec: Zeiger auf TVOCRec                                             }
  {=========================================================================}
  { TVOCRec: Struktur des VOC-Header                                        }
  {=========================================================================}

  PVOCRec = ^TVOCRec;
  TVOCRec = RECORD
    IDStr                : IDString;                        { Datei-Kennung }
    DataOffs, Ver, Check : Word;   { Datenblock-Offset, Version, Check-Code }
    Data                 : Byte;                                { Datenbyte }
  END;

VAR
  VOCName  : String;                                   { Name der VOC-Datei }
  VOCFile  : File;                                      { VOC-Dateivariable }
  VOCBuf   : PVOCRec;                           { Zeiger auf den VOC-Puffer }
  HelpPtr  : PVOCRec;                                     { ein Hilfszeiger }
  Status   : Word;                                    { Status des Treibers }
  VolLeft  : Word;                                { Lautstrke linker Kanal }
  VolRight : Word;                               { Lautstrke rechter Kanal }

{===========================================================================}
{ Prozedur ShowHelp: Hilfe zum Programm auf dem Bildschirm anzeigen.        }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE ShowHelp;

BEGIN
  WriteLn('Spielt eine VOC-Datei ab mit komfortablen Funktionen wie '+
    'Anhalten der');
  WriteLn('VOICE-Ausgabe, Lautstrkeregelung, Filtereinstellung u.a. '+
    'Das Programm');
  WriteLn('benutzt den Treiber CT-VOICE. Die Dateigre darf deshalb 60 KB '+
    'nicht');
  WriteLn('berschreiten.');
  WriteLn;
  WriteLn('Syntax: PLAYVOC1 [Dateiname].VOC');
END;

{===========================================================================}
{ Funktion UpperString: Wandelt einen String beliebiger Lnge in Gro-      }
{                       schreibung um und liefert ihn an den Aufrufer der   }
{                       Funktion zurck.                                    }
{===========================================================================}
{ Eingabe: S = String, der in Groschreibung umgewandelt werden soll        }
{ Ausgabe: String in Groschreibung                                         }
{---------------------------------------------------------------------------}

FUNCTION UpperString(S : String) : String;

VAR
  Count : Word;                                                { ein Zhler }
  Upper : String;                  { in Groschreibung umgewandelter String }

BEGIN
  UpperString := '';
  IF S <> '' THEN                               { Ist S kein leerer String? }
    BEGIN                                          { nein, S ist nicht leer }
      Upper := '';
      FOR Count := 1 TO Length(S) DO                     { String umwandeln }
        Upper := Upper+UpCase(S[Count]);
      UpperString := Upper;                      { neuen String zurckgeben }
    END;
END;

{===========================================================================}
{ Prozedur ShowKeysAndInfo: Zeigt die Tastenbelegung und Informationen wh- }
{                           rend des Abspielvorgangs auf dem Bildschirm an. }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE ShowKeysAndInfo;

VAR
  Count : Word;                                                { ein Zhler }

BEGIN
  GoToXY(18, 6);
  Write('Tastenbelegung:   [Esc]    VOICE-Ausgabe beenden');
  GoToXY(18, 7);
  Write('                  [Space]  Abspielen anhalten/fortsetzen');
  GoToXY(18, 8);
  Write('                  [l]      Lautstrke linker Kanal erniedrigen');
  GoToXY(18, 9);
  Write('                  [L]      Lautstrke linker Kanal erhhen');
  GoToXY(18, 10);
  Write('                  [r]      Lautstrke rechter Kanal erniedrigen');
  GoToXY(18, 11);
  Write('                  [R]      Lautstrke rechter Kanal erhhen');
  GoToXY(18, 12);
  Write('                  [f]      Ausgabefilter ein/aus');
  GotoXY(18, 16);
  Write('Info: STATUS -> VOICE-Ausgabe luft');
  GotoXY(18, 17);
  Write('      FILTER -> ein');
  TextColor(LightRed);
  IF NOT (GetBoardType IN [type_SBPro, type_SB16]) THEN
    FOR Count := 8 TO 12 DO
      BEGIN
        GoToXY(34, Count);
        Write('N');
      END;
  GoToXY(18, 24);
  Write('N ');
  TextColor(LightGray);
  Write('Funktion nicht verfgbar');
END;

{===========================================================================}
{ Prozedur VolumeBar: Liest die aktuell gesetzte Lautstrke aus und zeich-  }
{                     net die Lautstrkebalken fr den linken und rechten   }
{                     Kanal.                                                }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE VolumeBar;

VAR
  Count : Word;                                                { ein Zhler }

BEGIN
  IF GetBoardType IN [type_SBPro, type_SB16] THEN      { SB Pro oder SB 16? }
    BEGIN                              { ja, Abfrage der Lautstrke mglich }
      VolLeft := SendToDriver(0, sbd_GetVolume, 0, 1, 0, 0);
      VolRight := SendToDriver(0, sbd_GetVolume, 0, 2, 0, 0);
      IF (VolLeft <> $FFFF) AND (VolRight <> $FFFF) THEN    { Abfrage o.k.? }
        BEGIN                               { ja, Lautstrkebalken zeichnen }
          GoToXY(1, 6);
          Write('ͻ');
          GoToXY(1, 7);
          Write(' Lautstrke ');
          GoToXY(1, 8);
          Write('͹');
          FOR Count := 1 TO 15 DO
            BEGIN
              GoToXY(1, Count+8);
              Write('            ');
            END;
          GoToXY(1, 24);
          Write('ͼ');
          TextColor(Yellow);          { Farbe der Lautstrkebalken ist gelb }
          FOR Count := 23 DOWNTO 23-VolLeft+1 DO
            BEGIN
              GoToXY(4, Count);
              Write('');
            END;
          FOR Count := 23 DOWNTO 23-VolRight+1 DO
            BEGIN
              GoToXY(9, Count);
              Write('');
            END;
          TextColor(LightGray);                            { Textfarbe grau }
        END;
    END;
END;

{===========================================================================}
{ Prozedur HandleOutput: Verwaltet die VOICE-Ausgabe. Es wird permanent die }
{                        Tastatur abgefragt, um auf bestimmte Tasten eine   }
{                        Aktion auszulsen, zum Beispiel Vernderung der    }
{                        Lautstrke.                                        }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE HandleOutput;

VAR
  Done   : Boolean;          { TRUE, wenn das Abspielen beendet werden soll }
  Pause  : Boolean;                  { TRUE, wenn der Pausenmodus aktiv ist }
  Filter : Boolean;                { TRUE, wenn Eingabefilter eingeschaltet }
  Key    : Char;                                               { Tastencode }

BEGIN
  ClrScr;                                              { Bildschirm lschen }
  WriteLn(' DATA BECKERs Sound Blaster Superbuch  *  PLAYVOC1  *  (c) 1993 '+
    'by Arthur Burda');
  WriteLn(''+
    '');
  WriteLn('Name der VOC-Datei: '+VOCName);
  Filter := TRUE;
  IF GetBoardType IN [type_SBPro, type_SB16] THEN      { SB Pro oder SB 16? }
    BEGIN                                                              { ja }
      SendToDriver(1, sbd_SetFilterOnOff, 0, 0, 0, 0);         { Filter ein }
      SendToDriver(0, sbd_SetVolume,       { Lautstrke setzen linker Kanal }
        15, 1, 0, 0);
      SendToDriver(0, sbd_SetVolume, 15, 2, 0, 0);          { rechter Kanal }
    END;
  ShowKeysAndInfo;
  VolumeBar;                                    { Lautstrkebalken zeichnen }
  Done := FALSE;
  Pause := FALSE;
  REPEAT                                                  { Schleifenanfang }
    IF KeyPressed THEN                                    { Taste gedrckt? }
      BEGIN                                                            { ja }
        Key := ReadKey;                                 { Tastatur abfragen }
        IF Key = #0 THEN                          { erweiterter Tastencode? }
          Key := ReadKey                   { ja, Tastatur nochmals abfragen }
        ELSE                            { nein, eine normale Taste gedrckt }
          CASE Key OF
            kb_Space :                                { Leertaste bettigt? }
              BEGIN                { VOICE-Ausgabe anhalten bzw. fortsetzen }
                Pause := NOT Pause;
                IF Pause THEN                                   { anhalten? }
                  BEGIN                                                { ja }
                    HaltOutput;
                    GoToXY(34, 16);
                    Write('VOICE-Ausgabe angehalten');
                  END
                ELSE                                                 { nein }
                  BEGIN
                    ContinueOutput;                  { Abspielen fortsetzen }
                    GoToXY(34, 16);
                    Write('VOICE-Ausgabe luft     ');
                  END;
              END;
            kb_Esc :                                      { [Esc] gedrckt? }
              Done := TRUE;                     { ja, VOICE-Ausgabe beenden }
            kb_l :                                          { "l" gedrckt? }
              IF GetBoardType IN [type_SBPro, type_SB16] THEN          { ja }
                IF VolLeft > 0 THEN          { Lautstrke linker Kanal > 0? }
                  BEGIN                                                { ja }
                    Dec(VolLeft);
                    SendToDriver(0, sbd_SetVolume, VolLeft, 1, 0, 0);
                    VolumeBar;
                  END;
            kbL :                                           { "L" gedrckt? }
              IF GetBoardType IN [type_SBPro, type_SB16] THEN          { ja }
                IF VolLeft < 15 THEN        { Lautstrke linker Kanal < 15? }
                  BEGIN                                                { ja }
                    Inc(VolLeft);
                    SendToDriver(0, sbd_SetVolume, VolLeft, 1, 0, 0);
                    VolumeBar;
                  END;
            kb_r :                                          { "r" gedrckt? }
              IF GetBoardType IN [type_SBPro, type_SB16] THEN          { ja }
                IF VolRight > 0 THEN        { Lautstrke rechter Kanal > 0? }
                  BEGIN                                                { ja }
                    Dec(VolRight);
                    SendToDriver(0, sbd_SetVolume, VolRight, 2, 0, 0);
                    VolumeBar;
                  END;
            kbR :                                           { "R" gedrckt? }
              IF GetBoardType IN [type_SBPro, type_SB16] THEN          { ja }
                IF VolRight < 15 THEN      { Lautstrke rechter Kanal < 15? }
                  BEGIN                                                { ja }
                    Inc(VolRight);
                    SendToDriver(0, sbd_SetVolume, VolRight, 2, 0, 0);
                    VolumeBar;
                  END;
            kb_f :                                          { "f" gedrckt? }
              IF GetBoardType IN [type_SBPro, type_SB16] THEN          { ja }
                BEGIN
                  Filter := NOT Filter;
                  IF Filter THEN                     { Filter ein oder aus? }
                    BEGIN                                             { ein }
                      SendToDriver(1, sbd_SetFilterOnOff, 0, 0, 0, 0);
                      GoToXY(34, 17);
                      Write('ein');
                    END
                  ELSE                                                { aus }
                    BEGIN
                      SendToDriver(1, sbd_SetFilterOnOff, 1, 0, 0, 0);
                      GoToXY(34, 17);
                      Write('aus');
                    END;
                END;
          END;
      END;
    IF Status = 0 THEN                                   { Treiberstatus 0? }
      Done := TRUE;                     { Ja. Die VOC-Datei ist abgespielt. }
  UNTIL Done;                                               { Schleifenende }
END;

{===========================================================================}
{ Prozedur Play: Spielt die VOC-Datei ab.                                   }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE Play;

BEGIN

  { Basis-Addresse, Interrupt-Nummer und }
  { DMA-Kanal (nur bei SB Pro) setzen    }

  SetBaseAddress(SB_BaseAddress);
  SetInterrupt(SB_Interrupt);
  IF GetBoardType IN [type_SBPro, type_SB16] THEN
    SetDMAChannel(SB_DMAChannel);

  IF DriverInit(0) THEN                            { Treiber initialisiert? }
    BEGIN                                                              { ja }
      SpeakerOn;                                         { Lautsprecher ein }
      SendToDriver(0, sbd_SetStatusword, 0, 0, Seg(Status), Ofs(Status));
      SendToDriver(0, sbd_VoiceOutput, 0, 0, Seg(VOCBuf^), Ofs(VOCBuf^));
      HandleOutput;      { Routine zum Verwalten der VOICE-Ausgabe aufrufen }
      SendToDriver(0, sbd_StopInOutput, 0, 0, 0, 0);    { Abspielen beenden }
      DriverEnd;                                      { Treiber ausschalten }
      SpeakerOff;                                        { Lautsprecher aus }
    END
  ELSE                                     { Treiber-Initialisierungsfehler }
    BEGIN
      DriverEnd;                                       { Treiber abschalten }
      VOCBuf := HelpPtr;
      FreeMem(VOCBuf, BufSize);                          { Puffer freigeben }
      Close(VOCFile);                                 { VOC-Datei schlieen }
      WriteLn;
      WriteLn('Fehler: Treiber CT-VOICE konnte nicht initialisiert werden.');
      Halt;                                              { Programm beenden }
    END;
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

VAR
  Result : Integer;                                 { Fehlerstatus-Variable }
  Dir    : DirStr;                              { Verzeichnis der VOC-Datei }
  Name   : NameStr;                   { Name der VOC-Datei ohne Erweiterung }
  Ext    : ExtStr;                                       { Dateierweiterung }

BEGIN
  TextColor(LightGray);                                { Textfarbe hellgrau }
  WriteLn;
  WriteLn('PLAYVOC1  *  Version 1.08  *  (c) 1993 by Arthur Burda');
  WriteLn(''+
    '');
  IF ParamCount = 0 THEN                   { keine Kommandozeilenparameter? }
    BEGIN                 { nein, Fehlermeldung auf dem Bildschirm ausgeben }
      WriteLn;
      WriteLn('Fehler: Keine VOC-Datei zum Abspielen angegeben.');
      Halt;
    END
  ELSE
    IF ParamStr(1) = '/?' THEN                         { Hilfe angefordert? }
      ShowHelp                    { ja, Hilfetext auf dem Bildschirm zeigen }
    ELSE          { keine Hilfe, wahrscheinlich ein VOC-Dateiname angegeben }
      BEGIN
        InitSBDrv;                              { Unit SBDrv initialisieren }
        VOCName := UpperString(ParamStr(1));      { VOC-Dateinamen auslesen }
        FSplit(VOCName, Dir, Name, Ext);          { VOC-Dateinamen zerlegen }
        IF Ext = '' THEN
          VOCName := VOCName+'.VOC';
        Assign(VOCFile, VOCName);              { Datei mit Namen verknpfen }
        Reset(VOCFile, 1);                                   { Datei ffnen }
        Result := IOResult;                         { Fehlerstatus abfragen }
        IF Result = 0 THEN                            { Fehler aufgetreten? }
          BEGIN                                         { nein, also weiter }
            IF FileSize(VOCFile) <= BufSize THEN { Dateigre <= Puffergr.? }
              IF Load_CTVOICE = 0 THEN      { Treiber CT-VOICE.DRV geladen? }
                BEGIN                                                  { ja }
                  GetMem(VOCBuf, BufSize);         { VOC-Puffer reservieren }
                  BlockRead(VOCFile, VOCBuf^, FileSize(VOCFile));
                  Result := IOResult;
                  IF IOResult = 0 THEN      { VOC-Daten fehlerfrei gelesen? }
                    BEGIN                                 { ja, dann weiter }
                      IF $1233-VOCBuf^.Ver <> VOCBuf^.Check THEN
                        BEGIN
                          FreeMem(VOCBuf, BufSize);      { Puffer freigeben }
                          Close(VOCFile);             { VOC-Datei schlieen }
                          WriteLn;
                          WriteLn('Fehler: VOC-Dateifehler');
                          Halt;
                        END;
                      HelpPtr := VOCBuf;
                      VOCBuf := @VOCBuf^.Data;
                      Play;                              { Sample abspielen }
                      VOCBuf := HelpPtr;
                      FreeMem(VOCBuf, BufSize);
                      Close(VOCFile);                 { VOC-Datei schlieen }
                      ClrScr;                          { Bildschirm lschen }
                    END
                  ELSE
                    BEGIN  { nein, Daten wurden nicht fehlerfrei eingelesen }
                      IF DrvPtr <> NIL THEN          { Treiber im Speicher? }
                        FreeMem(DrvPtr, DrvSize);    { ja, Puffer freigeben }
                      FreeMem(VOCBuf, BufSize);
                      Close(VOCFile);
                      WriteLn;
                      WriteLn('Fehler: Lesefehler bei '+VOCName);
                      Halt;
                    END;
                END
              ELSE                     { Treiber CT-VOICE.DRV nicht geladen }
                BEGIN                              { Fehlermeldung anzeigen }
                  WriteLn;
                  WriteLn('Fehler: Treiber CT-VOICE.DRV konnte nicht '+
                    'geladen werden.');
                  Halt;
                END
            ELSE                                       { Dateigre > 60 KB }
              BEGIN                                         { Fehlermeldung }
                WriteLn;
                WriteLn('Fehler: Datei ist zu gro, um sie mit dem '+
                  'Treiber CT-VOICE abzuspielen.');
                Halt;
              END;
          END
        ELSE                      { leider ein Fehler beim ffnen der Datei }
          BEGIN                                    { Fehlermeldung ausgeben }
            WriteLn;
            WriteLn('Fehler: Datei '+VOCName+' konnte nicht geffnet '+
              'werden.');
            Halt;
          END;
      END;
END.
