// File        : HOOK_KB.C
// 
// Version     : 1/10/92
//
// Description :  This module contains three functions.  These
//                functions are designed to hook and unhook into
//                the keyboard BIOS vector address.  The function
//                keyboardHandler will determine if a keypress
//                has been made.  If it has then the flag
//                _ioStopFlag will be set to _TRUE.
//***************************************************************
//*    Copyright (c) 1992,  Covox, Inc.  All Rights Reserved    *
//***************************************************************

#include <dos.h>
#include "cvxdefs.h"

//***************************************************************
//   If Borland C is used to compile the library the interface
//   macros header  must be included.
//***************************************************************
#if defined(__TURBOC__)
#include "cvxbrlnd.h"
#endif

#define _KEYBOARD_INT 0x09

// This variable will contain the original address of the keyboard
// BIOS routine.
VOID (interrupt far * old_keyboard_vect)( );

// This function is the new keyboard interrupt handler routine.
VOID interrupt far keyboardHandler( VOID );

// This flag is defined in the play and record functions.  It will
// be used throughout all of the record and play functions to 
// determine if i/o should be terminated.
extern BYTE _ioStopFlag;

//
WORD head, tail;

// This function will save the original vector address of the
// keyboard BIOS routine and set up a new address to point to
// the function keyboardHandler.
VOID hookKeyboard( VOID )
{
   WORD i;

   // Save off original keyboard vector address.
   old_keyboard_vect = _dos_getvect( _KEYBOARD_INT );

   // Hook int 9h (keyboard interrupt).  This hook will set the 
   // flag _ioStopFlag when a key has been struck.
   _asm   cli
   _dos_setvect( _KEYBOARD_INT, keyboardHandler );
   _asm   sti

   _asm  mov   _ioStopFlag, 0

}


// This function will return the vector address for the keyboard
// back to its original state.
VOID unhookKeyboard( VOID )
{
   // reset original keyboard vector.
   _asm   cli
   _dos_setvect( _KEYBOARD_INT, old_keyboard_vect );
   _asm   sti
}


// New keyboard handler. This handler will set a flag to indicate
// that a keyboard hit has occured.
VOID interrupt far keyboardHandler( VOID )
{
   // Call original keyboard handler
   (*old_keyboard_vect)();

   _asm  xor   ax, ax
   _asm  mov   es, ax

   // Check head and tail pointers to see if they are equal.
   // Added by RH 4-12-91
   _asm   mov   ax, WORD PTR es:0x41A
   _asm   mov   head, ax
   _asm   mov   ax, WORD PTR es:0x41C
   _asm   mov   tail, ax

   if( head != tail )
   {
      _asm mov   _ioStopFlag, 1
   }
   
   _asm   mov   al, 20h
   _asm   out   20h, al

}


