// TSRFILES.C
// This program checks to see if TSRPLAY has been installed.
// If it has been installed then a new file list is sent
// to the resident copy of TSRPLAY.

#include <stdio.h>
#include <string.h>
#include "cvxdigi.h"

#define _FILE_COUNT   3
#define _FILE_1       "TEST1.V8"
#define _FILE_2       "TEST2.V8"
#define _FILE_3       "TEST3.V8"

VOID main( VOID )
{
   // Check to see if TSRPLAY is resident.
   if( tsrResident() )
   {
      printf( "Replacing files for resident %s\n",tsrGetProgramID() );

      // Setup 3 files in _tsrPlayInfo structure.
      _tsrPlayInfo.fileCount = _FILE_COUNT;

      // Put new file names into structure.
      strcpy(_tsrPlayInfo.fileName[ 0 ], _FILE_1);
      strcpy(_tsrPlayInfo.fileName[ 1 ], _FILE_2);
      strcpy(_tsrPlayInfo.fileName[ 2 ], _FILE_3);

      // Set 2nd file to repeat twice.
      _tsrPlayInfo.fileRepeat[ 1 ] = 2;

      // Make call into TSRPLAY to replace files.
      tsrSetupNewFiles();
   }
   else
      printf( "ERROR : %s not installed\n", tsrGetProgramID() );
}


