// PLAYANY.C
// This program uses the non-DMA playany() function. Memory is 
// allocated for the sound data. A file name TEST1.V2S is opened
// and its contents read into the buffer used with the call to
// playany(). Finally, the allocated memory is freed.

#include <stdio.h>
#include "cvxdigi.h"
#include "cvxutil.h"

#define _BUFFER_SIZE  0x8000
#define _SOUND_FILE   "TEST1.V2S"
#define _TREBLE_FLAG  _FALSE
#define _NOISE_FLAG   _TRUE

VOID main( VOID )
{
   HANDLE    fileHandle;
   LONG      bytesAvailable;
   LONG      bytesRead;
   LPSTR     playBuffer;

   // Allocate memory for playback buffer.
   playBuffer = cvxBufferAlloc( ( LONG )_BUFFER_SIZE, &bytesAvailable );

   if( playBuffer == _NULL )
      printf( "ERROR : Cannot Allocate Memory!!\n" );
   else
   {
      // Open the file containing sound data.
      if( cvxFileOpen( _SOUND_FILE, _OPEN_R_ONLY, &fileHandle ) )

         printf( "ERROR : %s not found.\n", _SOUND_FILE );
      else
      {
         // Read sound data from file.
         cvxFileRead( fileHandle, playBuffer, 
                      (LONG)_BUFFER_SIZE, &bytesRead );

         // Play a file of length bytesRead.
         playany( playBuffer, ( LONG )bytesRead, _CVX_RATE_DEFAULT,
                 _CVX_VM0, _TREBLE_FLAG, _NOISE_FLAG );

         // Close file containing sound data.
         cvxFileClose( fileHandle );
      }
      
      // Free memory used by buffer.
      if( cvxBufferFree( playBuffer ) )
         printf( "ERROR : Cannot Free Memory!!\n" );
   }
}




