/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Interface for CH374 **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* CH374 ļϵͳӿ */
/* ֧: FAT12/FAT16/FAT32 */

/* MCS-51ƬCԵUļдʾ, ATMEL/PHILIPS/SSTȾ˫DPTRĵƬ */
/* óUе/C51/CH374HFT.Cļеǰ600ַʾ,
   ҲԭļCH374HFT.C, ôóʾC51Ŀ¼CH374ͷļ,
   ҲC51Ŀ¼, ôóʾĿ¼µļ,
   󽫳ROMеһַдд½ļ"NEWFILE.TXT"
   ֽģʽдļҪļݻFILE_DATA_BUF,ֻܹҪ600ֽڵRAM
*/
/* CH374INT#ŲжϷʽ, ݸƷʽΪ"˫DPTR", ٶȽϿ, ATMEL/PHILIPS/SSTȾ˫DPTRĵƬ */


/* C51   CH374HFT.C */
/* LX51  CH374HFT.OBJ , CH374HF6.LIB, C51DPTR2.LIB */
/* OHX51 CH374HFT */

#include <reg52.h>
#include <stdio.h>
#include <string.h>

/* ¶ϸ˵뿴CH374HF6.Hļ */
#define LIB_CFG_INT_EN			1		/* CH374INT#ӷʽ,0Ϊ"ѯʽ",1Ϊ"жϷʽ" */
#define NO_DEFAULT_CH374_INT	1		/* ֹCH374HF6.HеĬжϴ,ʹбджϳ */

#define CH374_IDX_PORT_ADDR		0xBDF1	/* CH374˿ڵI/Oַ */
#define CH374_DAT_PORT_ADDR		0xBCF0	/* CH374ݶ˿ڵI/Oַ */
/* 62256ṩ32KBRAMΪ: 0000H-01FFHΪ̶д, 0200H-7FFFHΪļݻ */
#define	DISK_BASE_BUF_ADDR		0x0000	/* ⲿRAMĴݻʼַ,ӸõԪʼĻΪSECTOR_SIZE */

#define CH374_INT_NO			0		/* CH374жϺ, CH374жINT#ӵƬINT0 */
#define CH374_INT_FLAG			IE0		/* IE0,CH374жϱ־ */
#define CH374_INT_EN			EX0		/* EX0,CH374ж */

#define NO_DEFAULT_CH374_F_ENUM		1		/* δCH374FileEnumerʽֹԽԼ */
#define NO_DEFAULT_CH374_F_QUERY	1		/* δCH374FileQueryʽֹԽԼ */
#define NO_DEFAULT_CH374_RESET		1		/* δCH374ResetʽֹԽԼ */

#include "..\CH374HF6.H"

UINT8	process( void );

#ifdef NO_DEFAULT_CH374_INT			/* ӦóжNO_DEFAULT_CH374_INTԽֹĬϵжϴ,Ȼбдĳ */
void xQueryInterrupt( void )			/* ѯж״̬,ȴӲж */
{
#ifdef CH374_INT_WIRE					/* CH374ж */
	while ( CH374_INT_WIRE );  /* CH374жߵƽȴ */
#else									/* δCH374ж */
	while ( ( CH374_READ_REGISTER( REG_INTER_FLAG ) & ( BIT_IF_DEV_DETECT | BIT_IF_TRANSFER ) ) == 0 );  /* ѯжϱ־Ĵ */
#endif
}
/* ڽжϵȲ˷˵Ƭʱ,ʵЧжϷʽȲѯʽ */
/* ϽжϳдU,⵽U̲жϾִCH374DiskReadyԼFileOpenȿʼд,ڴʱ̫,ӰϴжϳждU */
void	CH374Interrupt( void ) interrupt CH374_INT_NO	/* CH374жϷ,ʹüĴ1,CH374INT#ĵ͵ƽ½شƬж */
{
	UINT8	s;
	s = CH374_READ_REGISTER( REG_INTER_FLAG );  /* жϱ־Ĵ */
	if ( s & BIT_IF_DEV_DETECT ) {  /* USB豸¼ */
		CH374DiskStatus = DISK_DISCONNECT;  /* ٶΪUSB豸Ͽ¼ */
#ifdef EN_HUB_DISK
		CH374vHubPortCount = 0;  /* ĬΪHUB */
#endif
		CH374_WRITE_REGISTER( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_DEV_DETECT | BIT_IF_TRANSFER );  /* жϱ־ */
		CH374_WRITE_REGISTER( REG_USB_SETUP, BIT_SETP_HOST_MODE );  /* USBģʽ,USB߿ */
		if ( s & BIT_IF_DEV_ATTACH ) {  /* USB豸¼ */
			CH374DiskStatus = DISK_CONNECT;  /* USB豸Ѿӻ߶Ͽ */
			process( );  /* Uдļ */
		}
	}
	else {  /* ж,Ӧ÷,Ϊ޸CH374жʹܼĴ */
		CH374_WRITE_REGISTER( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_INTER_FLAG );  /* жϱ־ */
	}
}
#endif

/* P1.4һLEDڼʾĽ,͵ƽLED,U̲ */
sbit P1_4  = P1^4;
#define LED_OUT_INIT( )		{ P1_4 = 1; }	/* P1.4 ߵƽ */
#define LED_OUT_ACT( )		{ P1_4 = 0; }	/* P1.4 ͵ƽLEDʾ */
#define LED_OUT_INACT( )	{ P1_4 = 1; }	/* P1.4 ͵ƽLEDʾ */
sbit P1_5  = P1^5;
/* P1.5һLEDڼʾĽ,͵ƽLED,U̲ʱ */
#define LED_RUN_ACT( )		{ P1_5 = 0; }	/* P1.5 ͵ƽLEDʾ */
#define LED_RUN_INACT( )	{ P1_5 = 1; }	/* P1.5 ͵ƽLEDʾ */
sbit P1_6  = P1^6;
/* P1.6һLEDڼʾĽ,͵ƽLED,Uдʱ */
#define LED_WR_ACT( )		{ P1_6 = 0; }	/* P1.6 ͵ƽLEDʾ */
#define LED_WR_INACT( )		{ P1_6 = 1; }	/* P1.6 ͵ƽLEDʾ */

/* ״̬,ʾ벢ͣ */
void	mStopIfError( UINT8 iError )
{
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
//	printf( "Error: %02X\n", (UINT16)iError );  /* ʾ */
/* ,Ӧ÷ԼCH374DiskStatus״̬,CH374DiskConnectѯǰUǷ,UѶϿôµȴU̲ٲ,
   Ĵ:
   1һCH374DiskReady,ɹ,Open,Read/Write,CH374DiskReadyлԶCH374DiskConnect
   2CH374DiskReadyɹ,ôǿнCH374DiskStatusΪDISK_CONNECT״̬,Ȼͷʼ(ȴUCH374DiskConnectCH374DiskReady) */
	while ( 1 ) {
		LED_OUT_ACT( );  /* LED˸ */
		CH374DelaymS( 100 );
		LED_OUT_INACT( );
		CH374DelaymS( 100 );
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

UINT8	process( void ) {  /* Uдļ */
	UINT8	i, c;
	UINT8	code *pCodeStr;
	LED_OUT_ACT( );  /* LED */
	CH374DelaymS( 100 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */
	for ( i = 0; i < 10; i ++ ) {  /* ȴʱ,10*50mS */
		CH374DelaymS( 50 );
//		printf( "Ready ?\n" );
		if ( CH374DiskReady( ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		if ( CH374DiskStatus < DISK_CONNECT ) {  /* ⵽Ͽ,¼Ⲣʱ */
//			printf( "Device gone\n" );
			return( ERR_DISK_DISCON );  /* µȴ */
		}
		if ( CH374DiskStatus >= DISK_MOUNTED && i > 5 ) break;  /* еUǷδ׼,Ժ,ֻҪ佨MOUNTEDҳ5*50mS */
	}
	if ( CH374DiskStatus < DISK_MOUNTED ) {  /* δ֪USB豸,USB̡ӡ */
//		printf( "Unknown device\n" );
		return( USB_INT_DISK_ERR );
	}
/* ѯ */
/*	printf( "DiskSize\n" );
	i = CH374DiskSize( );  
	mStopIfError( i );
	printf( "TotalSize = %u MB \n", (unsigned int)( mCmdParam.DiskSize.mDiskSizeSec >> 11 ) );  ʾΪMBΪλ
*/
	LED_RUN_ACT( );  /* ʼU */
/* ļ */
	LED_WR_ACT( );  /* д */
//	printf( "Create\n" );
	strcpy( mCmdParam.Create.mPathName, "/NEWFILE.TXT" );  /* ļ,ڸĿ¼,ļ */
	i = CH374FileCreate( );  /* ½ļ,ļѾɾ½ */
	mStopIfError( i );
//	printf( "Write\n" );
	pCodeStr = "Note: \xd\xaֽΪλUļд,ƬֻҪ600ֽڵRAM,жϷʽ,U̲Զд\xd\xa";
	while( 1 ) {  /* ֶдļ */
		for ( i=0; i<MAX_BYTE_IO; i++ ) {
			c = *pCodeStr;
			mCmdParam.ByteWrite.mByteBuffer[i] = c;
			if ( c == 0 ) break;  /* Դַ */
			pCodeStr++;
		}
		if ( i == 0 ) break;  /* Դַ,дļ */
		mCmdParam.ByteWrite.mByteCount = i;  /* дݵַ,ζдĳȲܳMAX_BYTE_IO,ڶεʱŸղŵд */
		i = CH374ByteWrite( );  /* ļд */
		mStopIfError( i );
	}
/*	printf( "Modify\n" );
	mCmdParam.Modify.mFileAttr = 0xff;   : µļ,Ϊ0FFH޸
	mCmdParam.Modify.mFileTime = 0xffff;   : µļʱ,Ϊ0FFFFH޸,ʹ½ļĬʱ
	mCmdParam.Modify.mFileDate = MAKE_FILE_DATE( 2004, 5, 18 );  : µļ: 2004.05.18
	mCmdParam.Modify.mFileSize = 0xffffffff;   : µļ,ֽΪλдļӦɳرļʱԶ³,Դ˴޸
	i = CH374FileModify( );   ޸ĵǰļϢ,޸
	mStopIfError( i );
*/
//	printf( "Close\n" );
	mCmdParam.Close.mUpdateLen = 1;  /* Զļ,ֽΪλдļ,óرļԱԶļ */
	i = CH374FileClose( );
	mStopIfError( i );

	LED_WR_INACT( );

	LED_RUN_INACT( );
//	printf( "Take out\n" );
	return( ERR_SUCCESS );
}

main( ) {
	UINT8	i;
	LED_OUT_INIT( );
	LED_OUT_ACT( );  /* LEDһʾ */
	CH374DelaymS( 100 );  /* ʱ100 */
	LED_OUT_INACT( );
	mInitSTDIO( );  /* Ϊüͨڼʾ */
	printf( "Start\n" );

	i = CH374LibInit( );  /* ʼCH374CH374оƬ,ɹ0 */
	mStopIfError( i );
	CH374_INT_EN = 1;  /* CH374ж */
/* ·ʼ */
	EA = 1;  /* ʼ,ж */

	while ( 1 ) {  /* жϷʽֻͨ־ж,κβѯ */
		printf( "Wait Udisk In\n" );
		while ( CH374DiskStatus < DISK_CONNECT );
		printf( "Wait Udisk Out\n" );
		while ( CH374DiskStatus >= DISK_CONNECT );
	}
}
