; Define for CH373 & CH374          */
; Website:  http://winchiphead.com  */
; Email:    tech@winchiphead.com    */
; Author:   W.ch 2005.10            */
; V1.3 for CH373/CH374              */

; ********************************************************************************************************************* */
; USBЭ㶨 */

; USBİʶPID, ʽõ */
DEF_USB_PID_NULL	EQU     00H							;PID, δ
DEF_USB_PID_SOF		EQU     05H
DEF_USB_PID_SETUP	EQU     0DH
DEF_USB_PID_IN		EQU     09H
DEF_USB_PID_OUT		EQU     01H
DEF_USB_PID_ACK		EQU     02H
DEF_USB_PID_NAK		EQU     0AH
DEF_USB_PID_STALL	EQU     0EH
DEF_USB_PID_DATA0	EQU     03H
DEF_USB_PID_DATA1	EQU     0BH
DEF_USB_PID_PRE		EQU     0CH

; ********************************************************************************************************************* */
; оƬ */

; Ĵ */

RAM_ENDP0_SIZE		EQU     008H		; ˵0Ļ */
RAM_ENDP0_TRAN		EQU     020H		; ˵0ͻʼַ */
RAM_ENDP0_RECV		EQU     028H		; ˵0ջʼַ */
RAM_ENDP1_SIZE		EQU     008H		; ˵1Ļ */
RAM_ENDP1_TRAN		EQU     030H		; ˵1ͻʼַ */
RAM_ENDP1_RECV		EQU     038H		; ˵1ջʼַ */
RAM_ENDP2_SIZE		EQU     040H		; ˵2Ļ */
RAM_ENDP2_TRAN		EQU     040H		; ˵2ͻʼַ */
RAM_ENDP2_RECV		EQU     0C0H		; ˵2ջʼַ */
RAM_ENDP2_EXCH		EQU     080H		; ˵2ûʼַ */
RAM_HOST_TRAN		EQU     040H		; ͻʼַ */
RAM_HOST_RECV		EQU     0C0H		; ջʼַ */
RAM_HOST_EXCH		EQU     080H		; ûʼַ */

REG_HUB_SETUP		EQU		002H		; USBʽ: ROOT-HUB */
REG_HUB_CTRL		EQU		003H		; USBʽ: ROOT-HUB */
REG_SYS_INFO		EQU     004H		; ϵͳϢ, ֻ */
REG_SYS_CTRL		EQU     005H		; ϵͳ, λӰ */
REG_USB_SETUP		EQU     006H		; USB */
REG_INTER_EN		EQU     007H		; жʹ */
REG_USB_ADDR		EQU     008H		; USB豸ַ */
REG_INTER_FLAG		EQU     009H		; жϱ־, ֻ, λд10 */
REG_USB_STATUS		EQU     00AH		; USB״̬, ֻ */
REG_USB_LENGTH		EQU     00BH		; USB, ΪǰUSBճ, 豸ʽдΪUSB˵2, ʽдΪUSBͳ */
REG_USB_ENDP0		EQU     00CH		; USB豸ʽ: USB˵0 */
REG_USB_ENDP1		EQU     00DH		; USB豸ʽ: USB˵1 */
REG_USB_H_PID		EQU     00DH		; USBʽ: USB */
REG_USB_ENDP2		EQU     00EH		; USB豸ʽ: USB˵2 */
REG_USB_H_CTRL		EQU     00EH		; USBʽ: USB */

; Ĵλú궨 */

BIT_HUB0_EN			EQU     001H		; HUB0˿ڵUSBʹ: 0-ֹ, 1- */
BIT_HUB0_RESET		EQU     002H		; HUB0˿ڵUSB߸λ: 0-λ, 1-λ */
BIT_HUB0_POLAR		EQU     004H		; HUB0˿ڵźżԿ: 0-/ȫ, 1-/ */
BIT_HUB0_ATTACH		EQU     008H		; HUB0˿ڵUSB豸״̬(ֻ): 0-δ/Ͽ/γ, 1-Ѿ/ */
BIT_HUB1_DX_IN		EQU     010H		; HUB1ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */
BIT_HUB2_DX_IN		EQU     020H		; HUB2ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */
BIT_HUB_PRE_PID		EQU     040H		; ǰðPRE PID: 0-ֹ, 1-(ⲿ豸USB-HUB) */
BIT_HUB_DISABLE		EQU     080H		; ֹROOT-HUB: 0-(USBʽ), 1-ֹ(Ĭ) */

BIT_HUB1_EN			EQU     001H		; HUB1˿ڵUSBʹ: 0-ֹ, 1- */
BIT_HUB1_RESET		EQU     002H		; HUB1˿ڵUSB߸λ: 0-λ, 1-λ */
BIT_HUB1_POLAR		EQU     004H		; HUB1˿ڵźżԿ: 0-/ȫ, 1-/ */
BIT_HUB1_ATTACH		EQU     008H		; HUB1˿ڵUSB豸״̬(ֻ): 0-δ/Ͽ/γ, 1-Ѿ/ */
BIT_HUB2_EN			EQU     010H		; HUB2˿ڵUSBʹ: 0-ֹ, 1- */
BIT_HUB2_RESET		EQU     020H		; HUB2˿ڵUSB߸λ: 0-λ, 1-λ */
BIT_HUB2_POLAR		EQU     040H		; HUB2˿ڵźżԿ: 0-/ȫ, 1-/ */
BIT_HUB2_ATTACH		EQU     080H		; HUB2˿ڵUSB豸״̬(ֻ): 0-δ/Ͽ/γ, 1-Ѿ/ */

BIT_INFO_HW_ID		EQU     003H		; Ӳʶλ: ǳ01, ˵Ӳ */
BIT_INFO_USB_DM		EQU     004H		; USBUD-ŵ߼ƽ״̬: 0-͵ƽ, 1-ߵƽ */
BIT_INFO_USB_DP		EQU     008H		; USBUD+ŵ߼ƽ״̬: 0-͵ƽ, 1-ߵƽ */
BIT_INFO_CLK_8KHZ	EQU		010H		; Ӳ8KHzʱλ */
BIT_INFO_SOF_PRES	EQU     020H		; Ӳ1mSʱ״̬,USB, 1˵ҪSOF */
BIT_INFO_WAKE_UP	EQU     040H		; оƬ״̬: 0-˯߻ѹ, 1-ѻ */
BIT_INFO_POWER_RST	EQU     080H		; Ӳϵ縴λ״̬: 0-ڸλ, 1-λ */

BIT_CTRL_OSCIL_OFF	EQU     001H		; ʱ: 0-, 1-ֹͣ */
BIT_CTRL_CLK_12MHZ	EQU		002H		; ʱƵѡ: 0-24MHz, 1-12MHz */
BIT_CTRL_USB_POWER	EQU     004H		; V3ŵUSBԴ: 0-, 1- */
BIT_CTRL_RESET_NOW	EQU     008H		; оƬλ: 0-λ, 1-λ */
BIT_CTRL_WATCH_DOG	EQU     010H		; RSTźRST#ŵĿŹλʹ: 0-, 1- */
BIT_CTRL_INT_PULSE	EQU     020H		; INT#ŵжʽ: 0-͵ƽж, 1-͵ƽж */
BIT_CTRL_OE_POLAR	EQU     040H		; UENŵUSBʹܼ: 0-ߵƽʹ, 1-͵ƽʹ */

BIT_SETP_TRANS_EN	EQU     001H		; USB豸ʽ: USB豸ʹ: 0-ֹ, 1- */
BIT_SETP_PULLUP_EN	EQU     002H		; USB豸ʽ: USB: 0-, 1- */
BIT_SETP_BUS_CTRL	EQU     003H		; USBʽ: USB״̬: 00-/, 01-D+D-(߸λ), 10-, 11-D+D-(߻ָ) */
;#define	M_SET_USB_BUS_FREE( old )		( (old) & ~ BIT_SETP_BUS_CTRL | 0x00 )		; USBʽ: USB߿ */
;#define	M_SET_USB_BUS_RESET( old )		( (old) & ~ BIT_SETP_BUS_CTRL | 0x01 )		; USBʽ: USB״̬/D+D-(߸λ) */
;#define	M_SET_USB_BUS_RESUME( old )		( (old) & ~ BIT_SETP_BUS_CTRL | 0x03 )		; USBʽ: USB״̬/D+D-(߻ָ) */
BIT_SETP_RAM_MODE	EQU     00CH		; ûӦ÷ʽ: 00-ñû, 01-ӽջ128ֽ, 10-ڷ͵ڶ, 11-ڽյڶ */
;#define	M_SET_RAM_MODE_OFF( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x00 )		; ûʽ/ñû */
;#define	M_SET_RAM_MODE_128( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x04 )		; ûʽ/ӽջ128ֽ */
;#define	M_SET_RAM_MODE_2TX( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x08 )		; ûʽ/ڷ͵ĵڶ,֧ */
;#define	M_SET_RAM_MODE_2RX( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x0C )		; ûʽ/ڽյĵڶ,֧ */
BIT_SETP_LOW_SPEED	EQU     020H		; USBߴٶ: 0-12Mbps, 1-1.5Mbps */
BIT_SETP_USB_SPEED	EQU     030H		; USB: 00-ȫģʽ/12Mbps, 11-ģʽ/1.5Mbps */
BIT_SETP_LED_ACT	EQU     040H		; USB豸ʽ: ACT#ŵ͵ƽļ¼: 0-շ, 1-USB */
BIT_SETP_AUTO_SOF	EQU     040H		; USBʽ: ԶSOFʹ: 0-ֹ, 1- */
BIT_SETP_HOST_MODE	EQU     080H		; USBӷʽѡ: 0-豸ʽ, 1-ʽ */

BIT_IE_TRANSFER		EQU     001H		; USBжʹ, 1Ч */
BIT_IE_BUS_RESET	EQU     002H		; USB豸ʽ: USB߸λжʹ, 1Ч */
BIT_IE_DEV_DETECT	EQU     002H		; USBʽ: USB豸жʹ, 1Ч */
BIT_IE_USB_SUSPEND	EQU     004H		; USB߹жʹ, 1Ч */
BIT_IE_USB_RESUME	EQU     008H		; USB߻ָ/жʹ, 1Ч, 0-ʹоƬж, 1-ʹUSB߻ָж */
BIT_IE_CLK_OUT_DIV	EQU     0F0H		; ɱʱӵķƵ: ƵΪ48MHz/(ֵ+1), : 0000-48MHz, 0001-24MHz, 0010-16MHz, 1111-3MHz */
;#define	M_SET_CLK_DIV( old, div )		( (old) & ~ BIT_IE_CLK_OUT_DIV | (div) << 4 )	; ʱƵ */

BIT_ADDR_USB_DEV	EQU     07FH		; 豸ʽΪΪUSB豸ĵַ, ʽΪǰUSB豸ַ */

BIT_IF_INTER_FLAG	EQU     00FH		; еUSBжϱ־ */
BIT_IF_TRANSFER		EQU     001H		; USBжϱ־, 1Ч, λд1־, λÿUSBɺԶ1 */
BIT_IF_BUS_RESET	EQU     002H		; USB豸ʽ: USB߸λжϱ־, 1Ч, λд1־, λڼ⵽USB߸λʱԶ1 */
BIT_IF_DEV_DETECT	EQU     002H		; USBʽ: USB豸μжϱ־, 1Ч, λд1־, λڼ⵽USB豸κԶ1 */
BIT_IF_USB_SUSPEND	EQU     004H		; USB߹жϱ־, 1Ч, λд1־, λڼ⵽USB߹ʱԶ1 */
BIT_IF_WAKE_UP		EQU     008H		; оƬжϱ־, 1Ч, λд1־, λоƬɺԶ1 */
BIT_IF_USB_RESUME	EQU     008H		; USB߻ָ/жϱ־, 1Ч, λд1־, λڼ⵽USB߻ָʱԶ1 */
BIT_IF_USB_PAUSE	EQU     010H		; USBͣ־, 1Ч, λд1־, λÿUSBɺԶ1 */
BIT_IF_DEV_ATTACH	EQU     020H		; USB豸״̬: 0-δ/Ͽ/γ, 1-һUSB豸Ѿ/ */
BIT_IF_USB_OE		EQU     040H		; UENŵUSBʹ״̬: 0-UENΪ͵ƽ, 1-UENΪߵƽ */
BIT_IF_USB_DX_IN	EQU     080H		; HUB0ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */
BIT_HUB0_DX_IN		EQU		080H		; HUB0ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */

BIT_STAT_THIS_ENDP	EQU     003H		; USB豸ʽ: USBĿĶ˵: 00-˵0, 01-˵1, 10-˵2, 11- */
BIT_STAT_THIS_PID	EQU     00CH		; USB豸ʽ: USB/PID: 00-OUT, 01-, 10-IN, 11-SETUP */
BIT_STAT_PID_ENDP	EQU     00FH		; USB豸ʽ: USBͶ˵,οUSB_INT_EP* */
BIT_STAT_DEV_RESP	EQU     00FH		; USBʽ: USB豸ӦPID: XX00=ʱ,ֵ-ͬPID,οUSB_INT_RET_* */
;M_IS_HOST_TIMEOUT( status )		( ( (status) & 0x03 ) == 0 )		; USB״̬ǷΪӦʱ/ */
;M_IS_HOST_IN_DATA( status )		( ( (status) & BIT_STAT_DEV_RESP & ~ ( DEF_USB_PID_DATA0 ^ DEF_USB_PID_DATA1 ) ) == ( DEF_USB_PID_DATA0 & DEF_USB_PID_DATA1 ) )	; Ƿ񷵻DATA0DATA1 */
BIT_STAT_TOG_MATCH	EQU     010H		; ָʾǰĴǷɹ/ǰյݰǷͬ: 0-ͬ, 1-ͬ */
BIT_STAT_BUS_RESET	EQU     020H		; ǰUSB߸λ״̬: 0-ûиλ, 1-ڸλ */
BIT_STAT_SUSPEND	EQU     040H		; ǰUSB߹״̬: 0-л, 1-߹ */
BIT_STAT_SIE_FREE	EQU     080H		; ǰUSBӿSIE״̬: 0=æ/ڴ, 1=/ȴ */

BIT_EP0_TRAN_RESP	EQU     00FH		; USB豸ʽ: ˵0Ӧ: 0000~1000-Ӧݳ0~8, 1110-ӦNAK, 1111-ӦSTALL,ֵ- */
;#define	M_SET_EP0_TRAN_ACK( old, len )	( (old) & ~ BIT_EP0_TRAN_RESP | (len) & 0x0F )	; USB豸ʽ: ˵0Ӧ/ӦACK */
;#define	M_SET_EP0_TRAN_NAK( old )		( (old) & ~ BIT_EP0_TRAN_RESP | 0x0E )		; USB豸ʽ: ˵0Ӧ/ӦNAK */
;#define	M_SET_EP0_TRAN_STA( old )		( (old) & ~ BIT_EP0_TRAN_RESP | 0x0F )		; USB豸ʽ: ˵0Ӧ/ӦSTALL */
BIT_EP0_RECV_RESP	EQU     030H		; USB豸ʽ: ˵0Ӧ: 00-ӦACK, 01-, 10-ӦNAK, 11-ӦSTALL */
;#define	M_SET_EP0_RECV_ACK( old )		( (old) & ~ BIT_EP0_RECV_RESP | 0x00 )		; USB豸ʽ: ˵0Ӧ/ӦACK */
;#define	M_SET_EP0_RECV_NAK( old )		( (old) & ~ BIT_EP0_RECV_RESP | 0x20 )		; USB豸ʽ: ˵0Ӧ/ӦNAK */
;#define	M_SET_EP0_RECV_STA( old )		( (old) & ~ BIT_EP0_RECV_RESP | 0x30 )		; USB豸ʽ: ˵0Ӧ/ӦSTALL */
BIT_EP0_TRAN_TOG	EQU     040H		; USB豸ʽ: ˵0ͬ־: 0-DATA0, 1-DATA1 */
BIT_EP0_RECV_TOG	EQU     080H		; USB豸ʽ: ˵0ͬ־: 0-DATA0, 1-DATA1 */

BIT_EP1_TRAN_RESP	EQU     00FH		; USB豸ʽ: ˵1Ӧ: 0000~1000-Ӧݳ0~8, 1110-ӦNAK, 1111-ӦSTALL,ֵ- */
;#define	M_SET_EP1_TRAN_ACK( old, len )	( (old) & ~ BIT_EP1_TRAN_RESP | (len) & 0x0F )	; USB豸ʽ: ˵1Ӧ/ӦACK */
;#define	M_SET_EP1_TRAN_NAK( old )		( (old) & ~ BIT_EP1_TRAN_RESP | 0x0E )		; USB豸ʽ: ˵1Ӧ/ӦNAK */
;#define	M_SET_EP1_TRAN_STA( old )		( (old) & ~ BIT_EP1_TRAN_RESP | 0x0F )		; USB豸ʽ: ˵1Ӧ/ӦSTALL */
BIT_EP1_RECV_RESP	EQU     030H		; USB豸ʽ: ˵1Ӧ: 00-ӦACK, 01-, 10-ӦNAK, 11-ӦSTALL */
;#define	M_SET_EP1_RECV_ACK( old )		( (old) & ~ BIT_EP1_RECV_RESP | 0x00 )		; USB豸ʽ: ˵1Ӧ/ӦACK */
;#define	M_SET_EP1_RECV_NAK( old )		( (old) & ~ BIT_EP1_RECV_RESP | 0x20 )		; USB豸ʽ: ˵1Ӧ/ӦNAK */
;#define	M_SET_EP1_RECV_STA( old )		( (old) & ~ BIT_EP1_RECV_RESP | 0x30 )		; USB豸ʽ: ˵1Ӧ/ӦSTALL */
BIT_EP1_TRAN_TOG	EQU     040H		; USB豸ʽ: ˵1ͬ־: 0-DATA0, 1-DATA1 */
BIT_EP1_RECV_TOG	EQU     080H		; USB豸ʽ: ˵1ͬ־: 0-DATA0, 1-DATA1 */

BIT_HOST_PID_ENDP	EQU     00FH		; USBʽ: ĿĶ˵: 0000~1111-˵0~15 */
BIT_HOST_PID_TOKEN	EQU     0F0H		; USBʽ: ָ/PID: 1101-SETUP, 0001-OUT, 1001-IN, 0101-SOF,ֵ- */
;M_MK_HOST_PID_ENDP( pid, endp )	( (pid) << 4 | (endp) & BIT_HOST_PID_ENDP )		; /PIDĿĶ˵USB */

BIT_EP2_TRAN_RESP	EQU     003H		; USB豸ʽ: ˵2Ӧ: 00-Ӧ, 01-ͬ/ʱ, 10-ӦNAK, 11-ӦSTALL */
;#define	M_SET_EP2_TRAN_ACK( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x00 )		; USB豸ʽ: ˵2Ӧ/ӦACK */
;#define	M_SET_EP2_TRAN_ISO( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x01 )		; USB豸ʽ: ˵2Ӧ/ͬ/ʱ/Ӧ */
;#define	M_SET_EP2_TRAN_NAK( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x02 )		; USB豸ʽ: ˵2Ӧ/ӦNAK */
;#define	M_SET_EP2_TRAN_STA( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x03 )		; USB豸ʽ: ˵2Ӧ/ӦSTALL */
BIT_EP2_RECV_RESP	EQU     030H		; USB豸ʽ: ˵2Ӧ: 00-ӦACK, 01-ͬ/ʱ, 10-ӦNAK, 11-ӦSTALL */
;#define	M_SET_EP2_RECV_ACK( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x00 )		; USB豸ʽ: ˵2Ӧ/ӦACK */
;#define	M_SET_EP2_RECV_ISO( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x10 )		; USB豸ʽ: ˵2Ӧ/ͬ/ʱ/Ӧ */
;#define	M_SET_EP2_RECV_NAK( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x20 )		; USB豸ʽ: ˵2Ӧ/ӦNAK */
;#define	M_SET_EP2_RECV_STA( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x30 )		; USB豸ʽ: ˵2Ӧ/ӦSTALL */
BIT_EP2_TRAN_TOG	EQU     040H		; USB豸ʽ: ˵2ͬ־: 0-DATA0, 1-DATA1 */
BIT_EP2_RECV_TOG	EQU     080H		; USB豸ʽ: ˵2ͬ־: 0-DATA0, 1-DATA1 */

BIT_HOST_TRAN_ISO	EQU     001H		; USBʽ: ͵Ĵ: 0-//жϴ, 1-ͬ/ʱ */
BIT_HOST_START		EQU     008H		; USBʽ: : 0-ͣ, 1-,ɺԶ0 */
BIT_HOST_RECV_ISO	EQU     010H		; USBʽ: յĴ: 0-//жϴ, 1-ͬ/ʱ */
BIT_HOST_TRAN_TOG	EQU     040H		; USBʽ: ͬ־: 0-DATA0, 1-DATA1 */
BIT_HOST_RECV_TOG	EQU     080H		; USBʽ: ͬ־: 0-DATA0, 1-DATA1 */

; ״̬ȳ */

CMD_SPI_374READ		EQU     0C0H		; SPI */
CMD_SPI_374WRITE	EQU     080H		; SPIд */

; ********************************************************************************************************************* */
; USB״̬ */

; ״̬USB豸ʽ */
;   λ4ָʾǰյݰǷͬ, 0=ͬ, 1-ͬ */
;   λ3-λ2ָʾǰ, 00=OUT, 10=IN, 11=SETUP */
;   λ1-λ0ָʾǰ˵, 00=˵0, 01=˵1, 10=˵2 */
USB_INT_EP0_SETUP	EQU     0CH							;USB˵0SETUP
USB_INT_EP0_OUT		EQU     00H							;USB˵0OUT
USB_INT_EP0_IN		EQU     08H							;USB˵0IN
USB_INT_EP1_OUT		EQU     01H							;USB˵1OUT
USB_INT_EP1_IN		EQU     09H							;USB˵1IN
USB_INT_EP2_OUT		EQU     02H							;USB˵2OUT
USB_INT_EP2_IN		EQU     0AH							;USB˵2IN

; ״̬USBʽ */
;   λ4ָʾǰյݰǷͬ, 0=ͬ, 1-ͬ */
;   λ3-λ0ָʾUSB豸Ӧ: 0010=ACK, 1010=NAK, 1110=STALL, 0011=DATA0, 1011=DATA1, XX00=Ӧ߳ʱӦ */
USB_INT_RET_ACK		EQU     DEF_USB_PID_ACK		; :OUT/SETUP񷵻ACK */
USB_INT_RET_NAK		EQU     DEF_USB_PID_NAK		; :NAK */
USB_INT_RET_STALL	EQU     DEF_USB_PID_STALL	; :STALL */
USB_INT_RET_DATA0	EQU     DEF_USB_PID_DATA0	; :IN񷵻DATA0 */
USB_INT_RET_DATA1	EQU     DEF_USB_PID_DATA1	; :IN񷵻DATA1 */
USB_INT_RET_TOUT	EQU     000H		; :Ӧ߳ʱӦ */
USB_INT_RET_TOUT1	EQU     004H		; :Ӧ߳ʱӦ */
USB_INT_RET_TOUT2	EQU     008H		; :Ӧ߳ʱӦ */
USB_INT_RET_TOUT3	EQU     00CH		; :Ӧ߳ʱӦ */


; ״̬1XHUSBʽĲ״̬, жֵ, ĶΪ˼CH375 */
USB_INT_SUCCESS		EQU     14H							;USBߴɹ
USB_INT_CONNECT		EQU     15H							;⵽USB豸¼
USB_INT_DISCONNECT	EQU     16H							;⵽USB豸Ͽ¼
USB_INT_BUF_OVER	EQU     17H							;USBƴ̫, 
USB_INT_DISK_READ	EQU     1DH							;USB洢ݿ, ݶ
USB_INT_DISK_WRITE	EQU     1EH							;USB洢дݿ, д
USB_INT_DISK_ERR	EQU     1FH							;USB洢ʧ

; ********************************************************************************************************************* */
; USBṹس */

; USB */
DEF_USB_REQ_READ	EQU     80H							;ƶ
DEF_USB_REQ_WRITE	EQU     00H							;д
DEF_USB_REQ_TYPE	EQU     60H							;
DEF_USB_REQ_STAND	EQU     00H							;׼
DEF_USB_REQ_CLASS	EQU     20H							;豸
DEF_USB_REQ_VENDOR	EQU     40H							;
DEF_USB_REQ_RESERVE	EQU     60H							;

; USB׼豸, RequestTypeλ6λ5=00(Standard) */
DEF_USB_CLR_FEATURE	EQU    01H
DEF_USB_SET_FEATURE	EQU    03H
DEF_USB_GET_STATUS	EQU    00H
DEF_USB_SET_ADDRESS	EQU    05H
DEF_USB_GET_DESCR	EQU    06H
DEF_USB_SET_DESCR	EQU    07H
DEF_USB_GET_CONFIG	EQU    08H
DEF_USB_SET_CONFIG	EQU    09H
DEF_USB_GET_INTERF	EQU    0AH
DEF_USB_SET_INTERF	EQU    0BH
DEF_USB_SYNC_FRAME	EQU    0CH

;  */
USB_DEVICE_DESCR_TYPE		EQU     001H
USB_CONFIG_DESCR_TYPE		EQU     002H
USB_STRING_DESCR_TYPE		EQU     003H
USB_INTERF_DESCR_TYPE		EQU     004H
USB_ENDP_DESCR_TYPE			EQU     005H
USB_POWER_DESCR_TYPE		EQU     006H
USB_HID_DESCR_TYPE			EQU     021H
USB_REPORT_DESCR_TYPE		EQU     022H
USB_PHYSIC_DESCR_TYPE		EQU     023H

; ˵ͺ */
USB_ENDP_DIR_MASK			EQU     080H
USB_ENDP_TYPE_MASK			EQU     003H
USB_ENDP_TYPE_CTRL			EQU     000H
USB_ENDP_TYPE_ISOCH			EQU     001H
USB_ENDP_TYPE_BULK			EQU     002H
USB_ENDP_TYPE_INTER			EQU     003H

; 豸 */
USB_DEV_CLASS_RESERVED		EQU     000H
USB_DEV_CLASS_AUDIO			EQU     001H
USB_DEV_CLASS_COMMUNIC		EQU     002H
USB_DEV_CLASS_HUMAN_IF		EQU     003H
USB_DEV_CLASS_MONITOR		EQU     004H
USB_DEV_CLASS_PHYSIC_IF		EQU     005H
USB_DEV_CLASS_POWER			EQU     006H
USB_DEV_CLASS_PRINTER		EQU     007H
USB_DEV_CLASS_STORAGE		EQU     008H
USB_DEV_CLASS_HUB			EQU     009H
USB_DEV_CLASS_VEN_SPEC		EQU     0FFH

DEFAULT_ENDP0_SIZE			EQU		08H				; ĬϵĶ˵0 */
