/*
; ƬUSBԹ̼  V1.0
; CH372CH375ĵƬм򵥵ĵԹ
; includeֱӰӦϵͳ,ӵĿ
;
; Website:  http://winchiphead.com
; Email:    tech@winchiphead.com
; @2004.08
;****************************************************************************
*/

/* MCS-51ƬC, KC7.0 */
/* ͵ƬӲԴͬʱ, óӦøҪоֲ޸ */

#include <reg52.h>

#include "CH375INC.H"

#ifdef __CX51__
#ifndef __C51__
#define __C51__		1
#endif
#endif

typedef unsigned char                UINT8;
typedef unsigned short               UINT16;
typedef unsigned long                UINT32;
#ifdef __C51__
typedef unsigned char  idata        *PUINT8;
#else
typedef unsigned char               *PUINT8;
#endif
#ifdef __C51__
typedef unsigned char  xdata        *PUINT8X;
#else
typedef unsigned char               *PUINT8X;
#endif
#ifdef __C51__
typedef unsigned char  code         *PUINT8C;
#else
typedef unsigned char               *PUINT8C;
#endif
#ifdef __C51__
#pragma NOAREGS
#endif

#ifndef MAX_DATA_SIZE
#define MAX_DATA_SIZE		16			/* ݳ,Чֵ156 */
#endif

typedef	struct	_USB_DOWN_PACKET {		/* ´ݰṹ,/д */
	UINT8	mCommand;					/* ,Ķ */
	UINT8	mCommandNot;				/* ķ,У´ݰ */
	union {
		UINT8	mByte[4];				/* ͨò */
		UINT16	mWord[2];				/* ͨò,ֽǰ,Little-Endian */
		UINT32	mDword;					/* ͨò,ֽǰ,Little-Endian */
		void	*mAddress;				/* дʼַ,ֽǰ,Little-Endian */
	} u;
	UINT8	mLength;					/* Ļĳ,дֽ */
	UINT8	mBuffer[ MAX_DATA_SIZE ];	/* ݻ */
}	USB_DOWN_PKT;

typedef	struct	_USB_UP_PACKET {		/* ϴݰṹ,״̬/ */
	UINT8	mStatus;					/* ״̬,Ķ */
	UINT8	mCommandNot;				/* ķ,Уϴݰ */
	UINT8	mReserved[4];
	UINT8	mLength;					/* Ļĳ,ֽ */
	UINT8	mBuffer[ MAX_DATA_SIZE ];	/* ݻ */
}	USB_UP_PKT;

typedef union	_USB_DATA_PACKET {		/* USBϴ´ݻ */
	USB_DOWN_PKT	down;
	USB_UP_PKT		up;
}	USB_DATA_PKT;

/* 붨,λ˵
   λ7Ϊ:  0=ʵض, 1=洢SFRд
   "ʵض":
       λ6-λ0Ϊľ, Ϊ00H-7FH, : 00H-3FHΪͨñ׼, 40H-7FHΪӦϵͳйصض
       Ŀǰ汾ͨñ׼:
           00H: ȡԹ̼İ汾,ȡδɵϴݿ
           10H: ȡǰӦϵͳİ汾˵ַ
   "洢SFRд":
       λ6Ϊݴ䷽:      0=/ϴ, 1=д/´
       λ5-λ4Ϊݶд:  00=ֽΪλ/8λ, 01=Ϊλ/16λ, 10=˫Ϊλ/32λ, 11=λΪλ/1λ
       λ1-λ0Ϊ洢ռ:    00=ȡSFR, 01=ȡڲRAM, 10=ȡⲿRAM, 11=ȡROM
       : 80HΪSFR, 83HΪROM, C1HΪдڲRAM, C2HΪдⲿRAM
   ״̬붨: 00HΪɹ, 080HΪ֧, 0FFHΪδĴ */

#define USB_CMD_GET_FW_INFO		0x00
#define USB_CMD_GET_APP_INFO	0x10

#define USB_CMD_MEM_ACCESS		0x80
#define USB_CMD_MEM_DIR_WR		0x40
#define USB_CMD_MEM_WIDTH		0x0C
#define USB_CMD_MEM_W_BYTE		0x00
#define USB_CMD_MEM_W_WORD		0x04
#define USB_CMD_MEM_W_DWORD		0x08
#define USB_CMD_MEM_W_BIT		0x0C
#define USB_CMD_MEM_SPACE		0x03
#define USB_CMD_MEM_S_SFR		0x00
#define USB_CMD_MEM_S_IRAM		0x01
#define USB_CMD_MEM_S_XRAM		0x02
#define USB_CMD_MEM_S_ROM		0x03

#define ERR_SUCCESS				0x00
#define ERR_PARAMETER			0x10
#define ERR_UNSUPPORT			0x80
#define ERR_UNDEFINED			0xFF

#define THIS_FIRMWARE_VER		0x10
#define THIS_APP_SYS_VER		0x09
#define THIS_APP_SYS_STR		"Example for USB DEBUG MCS51"


#define DELAY_START_VALUE		1	  /* ݵƬʱѡֵ,20MHzΪ0,30MHzΪ2 */
/*#define TEST_CH375_FIRST		1*/
/*#define MY_USB_VENDOR_ID		0x4348*/
/*#define MY_USB_PRODUCT_ID		0x5537*/
unsigned char volatile xdata CH375_CMD_PORT _at_ 0xBDF1;		/* CH375˿ڵI/Oַ */
unsigned char volatile xdata CH375_DAT_PORT _at_ 0xBCF0;		/* CH375ݶ˿ڵI/Oַ */


/* ʱ1΢,ȷ,ҪӲʵ */
void	Delay1us( )
{
#if DELAY_START_VALUE != 0
	UINT8 i;
	for ( i=DELAY_START_VALUE; i!=0; i-- );
#endif
}

/* ʱ2΢,ȷ,ҪӲʵ */
void	Delay2us( )
{
	UINT8 i;
	for ( i=DELAY_START_VALUE*2+1; i!=0; i-- );
}

/* CH372/CH375йصĻI/O */

void CH375_WR_CMD_PORT( UINT8 cmd ) {  /* CH375˿д,ڲС4uS,ƬϿʱ */
	Delay2us();
	CH375_CMD_PORT=cmd;
	Delay2us();
}

void CH375_WR_DAT_PORT( UINT8 dat ) {  /* CH375ݶ˿д,ڲС1.5uS,ƬϿʱ */
	CH375_DAT_PORT=dat;
	Delay1us();  /* MCS51Ƭ,,ʵʱ */
}

UINT8 CH375_RD_DAT_PORT( void ) {  /* CH375ݶ˿ڶ,ڲС1.5uS,ƬϿʱ */
	Delay1us();  /* MCS51Ƭ,,ʵʱ */
	return( CH375_DAT_PORT );
}

/* CH375ʼӳ */
void	CH375_Init( void ) {
	UINT8 i;

#ifdef TEST_CH375_FIRST
/* CH375뵥ƬǷԼǷ,ѡ,ͨҪ */
	UINT8 j;
	CH375_WR_CMD_PORT( CMD_CHECK_EXIST );  /* CH375Ƿ */
	CH375_WR_DAT_PORT( 0x55 );  /* д, */
	i = ~ 0x55;  /* Ӧǲȡ */
	if ( CH375_RD_DAT_PORT( ) != i ) {  /* CH375 */
		for ( i=80; i!=0; i-- ) {
			CH375_WR_CMD_PORT( CMD_RESET_ALL );  /* ظ,ִӲλ */
			CH375_RD_DAT_PORT( );
		}
		CH375_WR_CMD_PORT( 0 );
		for ( i=250; i!=0; i-- ) for( j=100; j!=0; j-- ) Delay2us( );  /* ʱ50mS */
	}
#endif

#ifdef MY_USB_VENDOR_ID
#ifdef MY_USB_PRODUCT_ID
/* ⲿԶUSB豸VIDPID,ѡ,ִиʹĬϵVIDPID,
   ʹԶID,ôINFװļе"USB\VID_4348&PID_5537"Ҫ޸ */
	CH375_WR_CMD_PORT( CMD_SET_USB_ID );  /* ⲿԶUSB豸VIDPID,ѡ */
	CH375_WR_DAT_PORT( (UINT8)MY_USB_VENDOR_ID );  /* д볧IDĵֽ */
	CH375_WR_DAT_PORT( (UINT8)(MY_USB_VENDOR_ID>>8) );  /* д볧IDĸֽ */
	CH375_WR_DAT_PORT( (UINT8)MY_USB_PRODUCT_ID );  /* дƷIDĵֽ */
	CH375_WR_DAT_PORT( (UINT8)(MY_USB_PRODUCT_ID>>8) );  /* дƷIDĸֽ */
#endif
#endif

/* USBģʽ, Ҫ */
	CH375_WR_CMD_PORT( CMD_SET_USB_MODE );
	CH375_WR_DAT_PORT( 2 );  /* Ϊʹù̼USB豸ʽ */
	for ( i=100; i!=0; i-- ) if ( CH375_RD_DAT_PORT( ) == CMD_RET_SUCCESS ) break;  /* ȴɹ,ͨҪȴ10uS-20uS */
/*	if ( i == 0 ) { CH372/CH375оƬڲӴӲ }; */

/* USBж,CH375INT#ſӵƬж,жΪ͵ƽЧ½Ч,
   ʹж,ôҲòѯʽ,ɵƬѯCH375INT#Ϊ͵ƽ */
	IT0 = 0;  /* ⲿźΪ͵ƽ */
	IE0 = 0;  /* жϱ־ */
	EX0 = 1;  /* CH375ж,ٶCH375INT#ӵƬINT0 */
}

/* CH375жϷ,ٶCH375INT#ӵƬINT0,ʹüĴ1 */
void	mCH375Interrupt( void ) interrupt 0 using 1 {
	UINT8			cnt;
	UINT8			dat;
	PUINT8			buf;
	PUINT8C			str;
	USB_DATA_PKT	udp;
#define	IntStatus		dat		/* Լһ洢Ԫ */
	CH375_WR_CMD_PORT( CMD_GET_STATUS );  /* ȡж״̬ȡж */
	IntStatus = CH375_RD_DAT_PORT( );  /* ȡж״̬ */
/*	IE0 = 0;  жϱ־,뵥ƬӲй,ӦINT0ж */
	if ( IntStatus == USB_INT_EP2_OUT ) {  /* ˵´ɹ,յ */
		CH375_WR_CMD_PORT( CMD_RD_USB_DATA );  /* ӵǰUSBжϵĶ˵㻺ȡݿ,ͷŻ */
		cnt = CH375_RD_DAT_PORT( );  /* ȶȡݳ */
		if ( cnt == 0 ) {  /* Ϊ0,û,ĳЩӦҲԽ0Ϊһ */
			CH375_WR_CMD_PORT( CMD_SET_ENDP7 );  /* USB˵2IN,Ҳϴ˵ */
			CH375_WR_DAT_PORT( 0x0E );  /* ͬλ,USB˵2INæ,NAK,ʵϴ */
			return;
		}
		buf = (PUINT8)&udp.down;  /* ָ */
		do {
			*buf = CH375_RD_DAT_PORT( );  /*  */
			buf ++;
		} while ( -- cnt );
		if ( udp.down.mCommand != (UINT8)( ~ udp.down.mCommandNot ) ) return;  /* У,´ */
		if ( udp.down.mCommand & USB_CMD_MEM_ACCESS ) {  /* :洢SFRд */
			if ( ( udp.down.mCommand & USB_CMD_MEM_WIDTH ) != USB_CMD_MEM_W_BYTE ) {  /* ĿǰMCS51ֻֽ֧Ϊλжд */
				udp.up.mLength = 0;
				udp.up.mStatus = ERR_UNSUPPORT;  /* ֧ */
			}
			else {  /* ֽΪλжд */
				for ( cnt = 0; cnt != udp.down.mLength; cnt ++ ) {  /* д */
					dat = udp.down.mBuffer[ cnt ];  /* ׼д */
					switch( udp.down.mCommand & USB_CMD_MEM_SPACE ) {  /* 洢ռ */
						case USB_CMD_MEM_S_SFR:
							switch ( udp.down.u.mByte[0] ) {  /* SFRַ */
								case 0x80:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) P0 = dat;
									else dat = P0;
									break;
								case 0x87:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) PCON = dat;
									else dat = PCON;
									break;
								case 0x88:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) TCON = dat;
									else dat = TCON;
									break;
								case 0x89:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) TMOD = dat;
									else dat = TMOD;
									break;
								case 0x90:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) P1 = dat;
									else dat = P1;
									break;
								case 0x98:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) SCON = dat;
									else dat = SCON;
									break;
								case 0x99:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) SBUF = dat;
									else dat = SBUF;
									break;
								case 0xA0:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) P2 = dat;
									else dat = P2;
									break;
								case 0xA8:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) IE = dat;
									else dat = IE;
									break;
								case 0xB0:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) P3 = dat;
									else dat = P3;
									break;
								case 0xB8:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) IP = dat;
									else dat = IP;
									break;
								case 0xC8:
									if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) T2CON = dat;
									else dat = T2CON;
									break;
								default:
									dat = 0;
									break;
							}
							break;
						case USB_CMD_MEM_S_IRAM:
							if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) *(PUINT8)udp.down.u.mByte[0] = dat;
							else dat = *(PUINT8)udp.down.u.mByte[0];
							break;
						case USB_CMD_MEM_S_XRAM:
							if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) *(PUINT8X)( udp.down.u.mByte[0] | (UINT16)udp.down.u.mByte[1] << 8 )= dat;
							else dat = *(PUINT8X)( udp.down.u.mByte[0] | (UINT16)udp.down.u.mByte[1] << 8 );
							break;
						case USB_CMD_MEM_S_ROM:
							if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) udp.up.mStatus = ERR_UNSUPPORT;  /* ֧ */
							else dat = *(PUINT8C)( udp.down.u.mByte[0] | (UINT16)udp.down.u.mByte[1] << 8 );
							break;
					}
					if ( ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) == 0 ) udp.up.mBuffer[ cnt ] = dat;  /* ض */
					udp.down.u.mByte[0] ++;
					if ( udp.down.u.mByte[0] == 0 ) udp.down.u.mByte[1] ++;
				}
				if ( udp.down.mCommand & USB_CMD_MEM_DIR_WR ) udp.up.mLength = 0;  /* д */
				udp.up.mStatus = ERR_SUCCESS;
			}
		}
		else switch ( udp.down.mCommand ) {  /* :ʵض, */
			case USB_CMD_GET_FW_INFO:  /* ȡԹ̼İ汾,ȡδɵϴݿ */
				udp.up.mBuffer[0] = THIS_FIRMWARE_VER;
				udp.up.mLength = 1;
				udp.up.mStatus = ERR_SUCCESS;
				CH375_WR_CMD_PORT( CMD_SET_ENDP7 );  /* USB˵2IN,Ҳϴ˵ */
				CH375_WR_DAT_PORT( 0x0E );  /* ͬλ,USB˵2INæ,NAK,ʵϴ */
				break;
			case USB_CMD_GET_APP_INFO:  /* ȡǰӦϵͳİ汾˵ַ */
				udp.up.mBuffer[0] = THIS_APP_SYS_VER;
				cnt = 0;
				str = THIS_APP_SYS_STR;
				while ( udp.up.mBuffer[ cnt ] = *str ) { cnt ++; str ++; }  /* ˵ַ */
				udp.up.mLength = 1 + sizeof( THIS_APP_SYS_STR );
				udp.up.mStatus = ERR_SUCCESS;
				break;
/* 			case MY_CMD_CH451: */
			default:  /* ֧ */
				udp.up.mLength = 0;
				udp.up.mStatus = ERR_UNSUPPORT;
				break;
		}
		CH375_WR_CMD_PORT( CMD_WR_USB_DATA7 );  /* USB˵2ķͻдݿ */
		cnt = udp.up.mLength + (UINT8)( & ( (USB_UP_PKT *)0 ) -> mBuffer );
		CH375_WR_DAT_PORT( cnt );  /* дݳ */
		buf = (PUINT8)&udp.up;  /* ָ״̬ */
		do {
			CH375_WR_DAT_PORT( *buf );  /* дݵCH375 */
			buf ++;
		} while ( -- cnt );
	}
	else if ( IntStatus == USB_INT_EP2_IN ) {  /* ݷͳɹ,״̬ѷ */
		CH375_WR_CMD_PORT( CMD_UNLOCK_USB );  /* ͷŵǰUSB,յϴɹжϺ,USB,Աշ */
	}
	else if ( IntStatus == USB_INT_EP1_IN ) {  /* жݷͳɹ,δõ */
		CH375_WR_CMD_PORT( CMD_UNLOCK_USB );  /* ͷŵǰUSB */
	}
/* ù̼USBʽ²Ӧóж״̬ */
}

/*
main( void ) {
	CH375_Init( );
	EA = 1;
	while ( 1 );
}
*/
