#include "stdafx.h"

extern TEXINFO texInfo;

extern "C" __declspec(dllexport)
void grTexMipMapMode(GrChipID_t tmu,
                     GrMipMapMode_t mode,
                     FxBool lodBlend)
{
	if(mode == GR_MIPMAP_DISABLE)
	{
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

      texInfo.magFilter = GL_LINEAR;
      texInfo.minFilter = GL_LINEAR;
	}

	if(mode == GR_MIPMAP_NEAREST)
	{
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST_MIPMAP_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_NEAREST);

      texInfo.magFilter = GL_NEAREST_MIPMAP_NEAREST;
      texInfo.minFilter = GL_NEAREST_MIPMAP_NEAREST;

      MessageBox(NULL, "grTexMipMapMode", "Notice", MB_APPLMODAL);
	}
	
	if(mode == GR_MIPMAP_NEAREST_DITHER)
	{
      MessageBox(NULL, "grTexMipMapMode", "Notice", MB_APPLMODAL);
	}

   //MessageBox(NULL, "grTexMipMapMode", "Notice", MB_APPLMODAL);
}