#include "stdafx.h"

extern "C" __declspec(dllexport)
void grBufferClear(GrColor_t color, GrAlpha_t alpha, FxU16 depth)
{
	GLfloat r = ((color >> 24) & 255) / 255.0f;
	GLfloat g = ((color >> 16) & 255) / 255.0f;
	GLfloat b = ((color >>  8) & 255) / 255.0f;
	GLfloat a = alpha / 255.0f;
	
	glClearColor(r, g, b, a);
   glClearDepth(depth / 65535.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   //MessageBox(NULL, "grBufferClear", "Notice", MB_APPLMODAL);
}
