#ifndef _SKIN_H_
#define _SKIN_H_

#include <stdint.h>
#include "palmosInternal.h"
#include "sbar.h"

#define SKIN_DB_TYPE					'skin'
#define SKIN_RES_SCREEN_REQ_TYPE		'sreq'

#define SKIN_RESID_SKIN_NAME			0		//STRING: skinname

#define SKIN_RESID_BASE					1000

#define SKIN_RESID_ADDED_INK			0		//ink color
#define SKIN_RESID_ADDED_BG				10		//generic background color
#define SKIN_RESID_ADDED_FG				20		//generic foreground color
#define SKIN_RESID_ADDED_ACT			30		//generic active foreground color

#define SKIN_RESID_OFST_BW				0		//XRGB8888: color for black and white modes
#define SKIN_RESID_OFST_COLOR			1		//XRGB8888: color for color modes


#define SKIN_RESID_ADDED_DIA			100		//added to base to get base for dia up state
#define SKIN_RESID_ADDED_SBAR			200		//added to base to get base for sbar-only state
#define SKIN_RESID_ADDED_FULL			300		//added to base to get base for fullscreen
#define SKIN_RESID_ADDED_DIA_CTL_DN		400		//BMPs: pins down button
#define SKIN_RESID_ADDED_DIA_CTL_UP		410		//BMPs: pins up button

#define SKIN_RESID_OFST_DIA_CTL_DIS		0		//dia control button, disabled
#define SKIN_RESID_OFST_DIA_CTL_ENA		1		//dia control button, enabled
#define SKIN_RESID_OFST_DIA_CTL_ACT		2		//dia control button, active

#define SKIN_RESID_OFST_NORMAL			0		//BMP: normal this dia state
#define SKIN_RESID_OFST_ACTIVE			1		//BMP: active this dia state
#define SKIN_RESID_OFST_ASLK			0		//ASLK: for this dia state



struct BitmapType;
struct PalmSilkscreenInfo;

//skin screen req res has an arrray of these
struct SbarSkinScreenReq {
	uint16_t width, height, density;
};

struct SbarSkinState {
	struct PalmSilkscreenInfo *aslk;
	struct BitmapType *nor;
	struct BitmapType *act;
};

struct SbarSkinDiaButtonState {
	struct BitmapType *ena;
	struct BitmapType *dis;
	struct BitmapType *act;
};

struct SbarSkin {
	
	//skin states
	struct SbarSkinState states[SBAR_STATE_NUMBER];
	
	//pins control button
	struct SbarSkinDiaButtonState diaDn, diaUp;
	
	//colors: ink
	uint32_t inkColor, inkBW;
	
	//colors: generic background
	uint32_t backColor, backBW;
	
	//colors: generic foreground
	uint32_t foreColor, foreBW;
	
	//colors: generic active foreground
	uint32_t foreActColor, foreActBW;
};

bool sbarPrvSkinLoad(struct SbarSkin* skin);





#endif
