#ifndef _REPALM_SBAR_PUBLIC_H_
#define _REPALM_SBAR_PUBLIC_H_

#include <stdbool.h>
#include <stdint.h>
#include "common.h"


#define REPALM_LAUNCH_CODE_BUTTON_CREATED		0x6ef0		//data is pointer to struct SbarNotifCreated (ALWAYS in 68k endinanness!)
#define REPALM_LAUNCH_CODE_BUTTON_DELETED		0x6ef1		//data is simply the abstract button handle
#define REPALM_LAUNCH_CODE_BUTTON_TAPPED		0x6ef2		//data is simply the abstract button handle
#define REPALM_LAUNCH_CODE_BUTTON_HELD			0x6ef3		//data is simply the abstract button handle
#define REPALM_LAUNCH_CODE_BUTTON_NEEDS_DRAW	0x6ef4		//data is pointer to struct SbarNotifDrawReq (ALWAYS in 68k endinanness!). draw window is set, its clip is set for button. Use WinGetClip if to find where your button is


#define REPALM_BTN_GROUP_LEFT			0
#define REPALM_BTN_GROUP_CENTER			1
#define REPALM_BTN_GROUP_RIGHT			2
#define REPALM_BTN_GROUP_NUM			3

#define REPALM_SBAR_BUTTON_HEIGHT		12		//in standard coords!

struct BitmapType;
struct SbarNotifStateDescr {
	struct BitmapType *normalImg;
	struct BitmapType *activeImg;	//optional
};

struct SbarNotifCreated {
	void *buttonHandle;
	void *userData;
};

struct SbarNotifDrawReq {
	void *buttonHandle;
	uint8_t state;
	bool isActive;
};


#define sysLibTrapSbarNotifCreate			(sysLibTrapCustom + 0)
#define sysLibTrapSbarNotifDestroy			(sysLibTrapCustom + 1)
#define sysLibTrapSbarNotifSetState			(sysLibTrapCustom + 2)
#define sysLibTrapSbarNotifRequestRedraw	(sysLibTrapCustom + 3)
#define sysLibTrapSbarNotifGetColor			(sysLibTrapCustom + 4)

#define RepalmSbarLibName 					MY_DB_NAME
#define RepalmSbarLibCreator				MODULE_CRID
#define RepalmSbarLibType					MODULE_TYPE

#define SbarColorInkColor					0		//ink color for color modes
#define SbarColorInkBW						1		//ink color for B&W modes
#define SbarColorBackgroundColor			2		//approx sbar background for color modes
#define SbarColorBackgroundBW				3		//approx sbar background for B&W modes
#define SbarColorForeNormalColor			4		//approx sbar fore color for color modes
#define SbarColorForeNormalBW				5		//approx sbar fore color for B&W modes
#define SbarColorForeActiveColor			6		//approx sbar active fore color for color modes
#define SbarColorForeActiveBW				7		//approx sbar active fore color for B&W modes


//returns handle or NULL, width must be even, is supplied in standard coords
void* sbarNotifCreate(LocalID handlerApp, uint8_t numStates, const struct SbarNotifStateDescr *states, uint8_t group, int32_t order, uint16_t width, bool holdSupported, bool manualDraw, void* userData /* passed to button created clalback so it knows which button it is */);
bool sbarNotifDestroy(void *handle);
bool sbarNotifSetState(void *handle, uint8_t state);	//will redraw if state changed
bool sbarNotifRequestRedraw(void *handle);
uint32_t sbarNotifGetColor(uint16_t which);				//color is returned as XRGB8888

//68k interface



Err SbarNotifLibOpen(uint16_t refNo)
	SYS_TRAP(sysLibTrapOpen);

Err SbarNotifLibClose(uint16_t refNo, uint16_t *numAppsP)
	SYS_TRAP(sysLibTrapClose);

//returns handle or NULL, width must be even, is supplied in standard coords
void* SbarNotifCreate(uint16_t refNo, LocalID handlerApp, uint8_t numStates, const struct SbarNotifStateDescr *states, uint8_t group, int32_t order, uint16_t width, bool holdSupported, bool manualDraw, void* userData /* passed to button created clalback so it knows which button it is */)
	SYS_TRAP(sysLibTrapSbarNotifCreate);

bool SbarNotifDestroy(uint16_t refNo, void *handle)
	SYS_TRAP(sysLibTrapSbarNotifDestroy);

bool SbarNotifSetState(uint16_t refNo, void *handle, uint8_t state)	//will redraw if state changed
	SYS_TRAP(sysLibTrapSbarNotifSetState);

bool SbarNotifRequestRedraw(uint16_t refNo, void *handle)
	SYS_TRAP(sysLibTrapSbarNotifRequestRedraw);

uint32_t SbarNotifGetColor(uint16_t refNo, uint16_t which)
	SYS_TRAP(sysLibTrapSbarNotifGetColor);

#endif
