#ifndef _MODULES_H_
#define _MODULES_H_

#include <stdint.h>
#include <stdbool.h>
#include <PalmTypes.h>



struct RalModuleDescr {
	uint32_t		initedDataSz;	//sizeof(res 'amdd')	- size of compressed inited data and relocs
	const void*		initedDataPtr;	//ptr(res 'amdd')		- compressed inited data and relocs
	const void*		infoPtr;		//ptr(res 'amdi')		- module info
	const void*		codePtr;		//ptr(res 'amdc')		- the module code;
	LocalID			dbH;			//LocalID (aka MemHandle) of the module database file
};

struct RalModuleInfo {
	uint32_t		refNo;			//library ref no
	uint32_t		neededMem;		//how much me mit needs ot be loaded (zero if already loaded)
	uint32_t		revision;		//from code resource
	uint32_t		numEntrypts;
	uint8_t			isApp;			//1 if moduleId is RAL_MODULE_ID_APP, 0 else
};


#define RAL_CMD_GET_PACE_ENTRY					0x7FFD
#define RAL_CMD_LOAD							0x7FFE
#define RAL_CMD_UNLOAD							0x7FFF
#define RAL_CMD_DAL_FIRST_BOOT					0x10000	//impossible normally, that's the point...
typedef uint32_t (*ModuleEntryPoint)(uint16_t cmd, void *cmdPBP, uint16_t flags);

#define RAL_MODULE_ID_DAL						0			//this one is very special (we are IN it, data is in our ".data", it has no RalLinkClient tables)
#define RAL_MODULE_ID_BOOT						1			//this one is somewhat special (we load it ourselves and data lives in hal static memory, it has no RalLinkClient tables)
#define RAL_MODULE_ID_UI						2			//this one is slightly special (it has no RalLinkClient tables)
#define RAL_MODULE_ID_TAL						3			//same as ui
#define RAL_MODULE_ID_APP						0x5F		//reserved for apps that need not be libraries and shared among them all
#define RAL_MAX_MODULE_ID						0x400		//actually limit. this id itsel is invalid

#define RAL_ENTRYPT_NUM_MAIN_ENTRY				0xFFFFFFFFUL	//used to get main entry point via RALGetEntryAddresses

#define RAL_REF_NO_NO_GLOBALS					0xFFFFFFFEUL	//the thing you wanted was loaded but with no globals

#define RAL_ERROR_NO_GLOBALS					0xF201	//only used for loading RAL_MODULE_ID_APP when another app is running
#define RAL_ERROR_INVALID_MODULE_ID				0xF202	//module id in a file was invalid
#define RAL_ERROR_TOO_MANY_ENTRIES				0xF203	//some modules have  alimit. It was exceeded
#define RAL_ERROR_MODULE_NOT_LOADED				0xF204	//unloading a module that is not loaded
#define RAL_ERROR_MODULE_CANNOT_UNLOAD			0xF204	//you cannot unload this module
#define RAL_ERROR_NONEXISTENT_ENTRY				0xF205	//trying to use somehow (eg: patch) a nonexistent entry or invalid entry number in some other way
#define RAL_ERROR_MODULE_CANNOT_BE_LINKED_WITH	0xF206	//some modules cnanot be linked with via RalLinkClient. If you try, you'll get this
#define RAL_ERROR_NO_MODE_MODULES_TO_UNLOAD		0xF207	//RALUnloadNext returns this when no more modules left to auto-unload
#define RAL_ERROR_INTERNAL_ERR					0xF20F	//something else

#define RAL_AMDC_FLAGS_MASK_REPALM				0xFF00
#define RAL_AMDC_FLAGS_VAL_REPALM				0x6900

bool ralInit(void);		//init the ral. do this early as before this R9 points nowhere
void ralMemMgrAvail(void);	//tell ral that MemMgr is avail

Err RALGetModuleInfo(const struct RalModuleDescr *descr, struct RalModuleInfo* nfo);
Err RALLoadModule(const struct RalModuleDescr *descr, void* dataArea, const void **entryPtAddrP, uint32_t *refNoP);
Err RALGetEntryAddresses(uint32_t refNo, uint32_t firstEntryPtOfInterest, UInt32 lastEntryPtOfInterest, const void **addrsP);
Err RALLinkClient(UInt32 refNo, UInt32 clientId, void **dispatchTblP);
Err RALUnloadModule(uint32_t refNo, struct RalModuleDescr *descrOutP, void **dataAreaToFreeP);
Err RALUnloadNext(uint32_t *refNo /* in and out */, struct RalModuleDescr *descrP /* out */, void **dataAreaToFreeP);
Err RALPatchEntry(uint32_t refNo, uint32_t entryptNo, const void *replacementFunc, const void **oldFuncP);
uint64_t RALCallWithNewStack(void *func, void *param, void *spVal);		//return val form func is passed. declared uint64_t to preserve return in both r0 and r1 as expected

#ifdef RAL_EXPORT_SOME_RAW_RAL_FUNCS
	Err impl_RALGetModuleInfo(const struct RalModuleDescr *descr, struct RalModuleInfo* nfo);
	Err impl_RALPatchEntry(uint32_t refNo, uint32_t entryptNo, void *replacementFunc, void **oldFuncP);
	
	Err impl_RALLoadModule(const struct RalModuleDescr *descr, void* dataArea, const void **entryPtAddrP, uint32_t *refNoP);
#endif


uint32_t ralSetSafeR9(void);	//returns old state you need to restore using ralRestoreR9()
void ralRestoreR9(uint32_t state);

//re palm table exported funcs, some only avail on certain hardware
bool ralSetRePalmTabFunc(uint32_t idx, void* func);


#endif
