#define _ASSEMBLY
#define MY_LIB_ID 0
#define LIB_SLOT_IN_GLOBALS 0x10
.syntax unified
.globl SysLinkerStub  //required to exist
.type LinkerStubCall_v6m, %function
.globl LinkerStubCall_v6m
.weak LinkerStubCall_v6m
.section .text.LinkerStubCall_v6m
.balign 4 //life is easier when aligned to a 4-byte-boundary :)
.func
LinkerStubCall_v6m:
	//lr = (descr + 1), stack has [proper_lr] [@{u32 self_lib_id, lib_slot_in_globals, &stubfunc - &past_this_struct + 1} + 1 !!!]
	push  {r0-r3}
	ldr   r3, [sp, #0x14]  //get info struct pointer
	ldmia r3!, {r0-r2}     //load it
	add   r2, r3           //calc addr of the stub func + 1
	str   r2, [sp, #0x14]  //replace it on stack with re-jump address
	mov   r3, r9           //get pointer to where table shall go into r3
	ldr   r3, [r3]
	ldr   r3, [r3, r0]
	adds  r3, r1
	adds  r2, r3, #1        //param #3: table write loc (lower bit tells linker stub that we cna handle thumb addrs directly (rePalm special)
	lsrs  r1, r0, #2        //param #2: module ID
	mov   r0, lr            //param #1: lib descriptor
  subs  r0, #1
	bl    SysLinkerStub
	ldr   r0, [sp, #0x10]   //get LR
	mov   lr, r0
	pop   {r0-r3}
	add   sp, #4
	pop   {pc}
.endfunc
.type Llib_load_stub, %function
.section .text.Llib_load_stub
.balign 4 //life is easier when aligned to a 4-byte-boundary :)
.func
Llib_load_stub:
	//bl sets lr to point to data - cool
	bl   LinkerStubCall_v6m //lr was pushed by stub func, so bl is safe
	.balign 4 // the data needs to be word-aligned
1:
	.word 0x6c696272 // type (libr)
	.word 0x6136386b // creator (a68k)
	.word 1
	.word 53
	.word 0x616d6464 // res type for data (amdd)
	.word 0x616d6469 // res type for info (amdi)
	.word 0x616d6463 // res type for code (amdc)
	.hword 0 // res id for data
	.hword 0 // res id for info
	.hword 0 // res id for code
	.hword 0 // reserved
.endfunc
.macro libentry name idx
	.type \name, %function
	.globl \name
	.section .text.\name
	.balign 4 //life is easier when aligned to a 4-byte-boundary :)
	.func
	\name:
	1:
		push    {r0, r1, lr}
		mov     r0, r9
		ldr     r0, [r0]
		ldr     r1, 3f //MY_LIB_ID
		ldr     r0, [r0, r1]
		ldr     r1, 4f //LIB_SLOT_IN_GLOBALS
		ldr     r0, [r0, r1]
		cmp     r0, #0
		beq     2f
		adds    r0, #4 * \idx		//biger range
		ldr     r0, [r0]
		str     r0, [sp, #8]
		pop     {r0, r1, pc}
	2:
		adr     r1, 3f	//make it easy
		str     r1, [sp, #8]
		pop     {r0, r1}
		push    {lr}	//pre-push LR for lib_load_stub, so we can corrupt it now
		bl      Llib_load_stub
		.balign 4
	3:
		.word	MY_LIB_ID
	4:
		.word	LIB_SLOT_IN_GLOBALS
	5:
		.word   1b - 6f + 1
	6:
	.endfunc
.endm
libentry PceInitializePACE 0
libentry PceReadInt8From68KStack 1
libentry PceReadInt16From68KStack 2
libentry PceReadInt32From68KStack 3
libentry PceReadVarArgsFrom68KStack 4
libentry PceReadStructureFrom68KStack 5
libentry PceWriteInt8To68KStack 6
libentry PceWriteInt16To68KStack 7
libentry PceWriteInt32To68KStack 8
libentry PceWriteStructureTo68KStack 9
libentry PceReadInt8From68KMemory 10
libentry PceReadInt16From68KMemory 11
libentry PceReadInt32From68KMemory 12
libentry PceReadVarArgsFrom68KMemory 13
libentry PceReadStructureFrom68KMemory 14
libentry PceWriteInt8To68KMemory 15
libentry PceWriteInt16To68KMemory 16
libentry PceWriteInt32To68KMemory 17
libentry PceWriteStructureTo68KMemory 18
libentry PceSet68KInt8ReturnResult 19
libentry PceSet68KInt16ReturnResult 20
libentry PceSet68KInt32ReturnResult 21
libentry PceSet68KPtrReturnResult 22
libentry PceGet68KInt8ReturnResult 23
libentry PceGet68KInt16ReturnResult 24
libentry PceGet68KInt32ReturnResult 25
libentry PceGet68KPtrReturnResult 26
libentry PceReverseBitFieldsInInt16 27
libentry PceGetCurrentAppEmulState 28
libentry PceGetSystemEmulState 29
libentry PceCall68KRoutine 30
libentry PceCall68KLibRoutine 31
libentry PceSysLibFind68KLibrary 32
libentry PceSysLibLoad68KLibrary 33
libentry PceSysLibLoadARMLibrary 34
libentry PceSysLibRemoveLibrary 35
libentry PceSysLibGetNativeRefNum 36
libentry PceReadExgSocketFrom68KMemory 37
libentry PceWriteExgSocketTo68KMemory 38
libentry PceReadEventFrom68KMemory 39
libentry PceWriteEventTo68KMemory 40
libentry PceAllocPseudo68KCallAddr 41
libentry PceFreePseudo68KCallAddr 42
libentry PceGetPseudo68KCallAddrInfo 43
libentry PceDbgBreak 44
libentry PceLaunchConsole 45
libentry PceGet68KTrapHandler 46
libentry PceSet68KTrapHandler 47
libentry PceNativeFormDeleted 48
libentry Pce68KAppIsDebuggable 49
libentry PceDbgBreakOnNextInstr 50
libentry PceConvert68KBitmap 51
libentry PrvPceSleepWakeNotification 52
