#ifndef _RESPRING_VISOR_COMMS_PROTO_H_
#define _RESPRING_VISOR_COMMS_PROTO_H_

#include <stdint.h>


#define MSG_S_NOT_UNDERSTOOD		0		//S=>V . message not understood
#define MSG_S_SHABBAT				1		//V=>S . expect shalom reply
#define MSG_S_SHALOM				2		//S=>V . reply to shabbat
#define MSG_S_CODE_SIZE				3		//V=>S . expect reply for download code size in inhalfwords
#define MSG_S_CODE_DATA				4		//V=>S . expect halfword of code. called repeatedly till all code downloaded
#define MSG_S_MAINBOX_INFO_0		5		//V=>S . expect reply of where V=>S mailbox starts in halfwords from mem start
#define MSG_S_MAINBOX_INFO_1		6		//V=>S . expect reply of V=>S mailbox size in halfwords
#define MSG_S_MAINBOX_INFO_2		7		//V=>S . expect reply of where S=>V mailbox starts in halfwords from mem start
#define MSG_S_MAINBOX_INFO_3		8		//V=>S . expect reply of S=>V mailbox size in halfwords

#define MSG_C_NOP					0x20	//V=>S . no data
#define MSG_C_CONTINUE_BOOT			0x21	//V=>S . struct MsgContinueBoot (once at boot). NOP reply mandated, no reply data allowed!
#define MSG_C_PEN_INFO				0x22	//V=>S . struct MsgPenEvt (async)
#define MSG_C_BUTTON_INFO			0x23	//V=>S . struct MsgButtonEvt (async)
#define MSG_C_BATTERY_INFO			0x24	//V=>S . struct MsgBatteryInfo (by request)
#define MSG_C_SER_OP_REPLY			0x25	//V=>S . struct MsgSerOp, reply to MSG_C_SER_OP
#define MSG_C_SER_DATA_RX			0x26	//V=>S . struct MsgSerialData  RXed from the world
#define MSG_C_SER_DATA_TX_REPLY		0x27	//V=>S . struct MsgSerialDataTxReply

#define MSG_C_ACK					0x40	//S=>V . acknowlege with no further info
#define MSG_C_GET_BATT_INFO			0x41	//S=>V . request a MSG_C_BATTERY_INFO message from the visor
#define MSG_C_SET_BRIGHTNESS		0x42	//S=>V . struct MsgSingleWord. set brightness
#define MSG_C_SET_CONTRAST			0x43	//S=>V . struct MsgSingleWord. set contrast
#define MSG_C_SET_SCREEN_DEPTH		0x44	//S=>V . struct MsgSingleWord. set screen depth
#define MSG_C_SET_CLUT				0x45	//S=>V . set clut
#define MSG_C_SCREEN_IMAGE			0x46	//S=>V . screen image data
#define MSG_C_UPDATE				0x47	//S=>V . begin update process (irrevocable)
#define MSG_C_SER_OP				0x48	//S=>V . struct MsgSerOp
#define MSG_C_SER_DATA_TX			0x49	//S=>V . struct MsgSerialData  for TX to the world -> MSG_C_SER_DATA_TX_REPLY
#define MSG_C_LED_CONTROL			0x4a	//S=>V . struct MsgLedControl
#define MSG_C_SET_BACKLIGHT			0x4b	//S=>V . struct MsgSingleWord. set backlight on/off

#define MSG_MRK_REQUEST				0xb00b	//this mark means simple message arrived
#define MSG_MRK_REPLY				0xf00d	//this mark means simple message reply ready

//structs are only guaranteed to work if made of uint16_t members!

//both
	struct MsgSerialData {
		uint16_t bytesAndFlags;		//nBytes in top 9 bits, bitmask of serLineError* in bottom 7
		uint16_t data[];			//high byte is first byte to send, low byte is second byte to send
		
		#define MSD_BYTES_AND_FLAGS_BYTES_MASK	0xFF80
		#define MSD_BYTES_AND_FLAGS_BYTES_SHIFT	7
		
		#define MSD_BYTES_AND_FLAGS_FLAGS_MASK	0x007F	//serLineError* for RX, 
		#define MSD_BYTES_AND_FLAGS_FLAGS_SHIFT	0
		
		#define MSD_FLAG_AUTOTX					0x0001	//for tx only this flag is defined
		
	};
	
	struct MsgSerOp {
		uint16_t op;		//enum SerOpType
		union {
			struct {
				uint16_t port;				//eg:  serPortLocalHotSync or serPortDefault
				uint16_t baudHi;			//uint32
				uint16_t baudLo;
			} open;
			struct {
				uint16_t baudHi;			//uint32
				uint16_t baudLo;
				uint16_t flags;				//bitfield of serSettingsFlag*
				uint16_t ctsTimeoutHi;		//uint32
				uint16_t ctsTimeoutLo;
				
				#define SER_FLAG_IR_MODE		0x8000	//only on "SET"
				#define SER_FLAG_IR_RX_ON		0x4000
			} settings;
			struct {
				uint16_t ctsOn;				//bool
				uint16_t dsrOn;				//bool
				uint16_t errors;			//errors as is form SerGetStatus()
			} state;
			struct {
				uint16_t selector;
				uint16_t err;
				uint16_t valHi;				//uint32, in/out as needed
				uint16_t valLo;
			} control;
		} data;
	};

	enum SerOpType {
		//requests
		SerOpOpen,			//"open" => SerOpSuccess / SerOpFailure
		SerOpClose,			//no params
		SerOpSetSettings,	//"settings"
		SerOpGetSettings,	//no params
		SerOpGetState,		//no params
		SerOpControl,		//"control"
		SerOpSendWait,		//no params
		
		
		//replies
		SerOpSuccess,		//no params
		SerOpFailure,		//no params
		SerOpCurSettings,	//"settings"
		SerOpCurState,		//"state"
		SerOpControlReply	//"control"
	};

//from visor:
	struct MsgPenEvt {
		int16_t x;				//-1 if up
		int16_t y;				//-1 if up
	};
	
	struct MsgButtonEvt {
		uint16_t keysState;		//keyBit* mask
	};
	
	struct MsgBatteryInfo {
		uint16_t centivolts;
		uint16_t flags;
		
		#define BATT_INFO_PERCENT_MASK		0x7F
		#define BATT_INFO_PERCENT_SHIFT		0
		
		#define BATT_INFO_PLUGGED_IN_MASK	0x80
		#define BATT_INFO_PLUGGED_IN_SHIFT	7
		
		#define BATT_INFO_KIND_MASK			0xff00
		#define BATT_INFO_KIND_SHIFT		8
		
	};
	
	struct MsgContinueBoot {
		uint16_t dispW;
		uint16_t dispH;
		uint16_t supportedDepths;
		uint16_t curDepth;
		uint16_t hwrMiscFlags;
		uint16_t hwrMiscExtFlags;
		uint16_t miscBits;
		
		#define MISC_BIT_LED_SUPPORTED		0x0001
		#define MISC_BIT_BACKLIGHT_ON		0x0002
	};
	
	struct MsgSerialDataTxReply {
		uint16_t sentBytesHi;
		uint16_t sentBytesLo;
		uint16_t errVal;
	};

//from module:
	struct MsgClut {
		uint16_t numEntries;
		struct ClutColor {	//designed so that 68k can copy directly
			uint16_t idx_r;	//index in top, r in bottom
			uint16_t g_b;	//g in top, b in bottom
		} colors[256];
	};
	
	struct MsgSingleWord {	//used for brightness, contrast, and depth setting
		uint16_t value;
	};
	
	struct MsgScreenData {
		uint16_t sz;		//in bytes, top bit means done
		uint16_t ofst;		//for error checking in missed frames
		uint16_t data[];
	};

	struct MsgLedControl {
		uint16_t patternHi;
		uint16_t patternLo;
		uint16_t csecPerPiece;			//centisecs
		uint16_t csecBetween;			//centisecs
		uint16_t numTimes;				//zero for off
	};



//todo: serial ports, dock status
//todo: backlight support when no bright ness regulation possible
//todo: expose if display support contrast or bri or both
//for low power we'll need HALDisplay{Wake,Doze,Sleep}, HALGetHwrWakeUp, HALPowerSleepReady

#endif
