#ifndef _RP2040_CPU_ATOMIC_H_
#define _RP2040_CPU_ATOMIC_H_

#include "cpu.h"

#define LOCK0		(*(volatile uint32_t*)(SIO_BASE + SIO_SPINLOCK0_OFFSET))

//we care for both: other core doing something to the variable and our core interrupting us and doing something to the variable
//the former is solvable with locks, the latter with irq disablement

static inline void atomicAdd8(volatile uint8_t *valP, uint8_t valToAdd)
{
	while(!LOCK0);
	irq_state_t sta = irqsAllOff();
	(*valP) += valToAdd;
	irqsRestoreState(sta);
	LOCK0 = 0;
}

static inline void atomicLogicOp32(volatile uint32_t *valP, uint32_t andWith, uint32_t orrIn)
{
	while(!LOCK0);
	irq_state_t sta = irqsAllOff();
	*valP = ((*valP) & andWith) | orrIn;
	irqsRestoreState(sta);
	LOCK0 = 0;
}

static inline bool atomicTestAndSet32(volatile uint32_t *valP, uint32_t expectedVal, uint32_t setVal)
{
	while(!LOCK0);
	irq_state_t sta = irqsAllOff();
	bool ret = false;
	
	if (*valP == expectedVal) {
		*valP = setVal;
		ret = true;
	}
	
	irqsRestoreState(sta);
	LOCK0 = 0;
	return ret;
}

static inline void atomicSwap32(uint32_t *valOutP, uint32_t *valP, uint32_t newVal)	//*valOutP = *valP; *valP = newVal, ATOMICALLY
{
	while(!LOCK0);
	irq_state_t sta = irqsAllOff();
	*valOutP = *valP;
	*valP = newVal;
	irqsRestoreState(sta);
	LOCK0 = 0;
}

static inline void atomicSwap8(uint8_t *valOutP, uint8_t *valP, uint8_t newVal)	//*valOutP = *valP; *valP = newVal, ATOMICALLY
{
	while(!LOCK0);
	irq_state_t sta = irqsAllOff();
	*valOutP = *valP;
	*valP = newVal;
	irqsRestoreState(sta);
	LOCK0 = 0;
}

#endif