#ifndef _SOUND_IFACE_H_
#define _SOUND_IFACE_H_

//as basic DAC with a built-in DMA
//only supports S16 48k audio out, ping-pong buffers


#define SOUND_UNIT_BASE			0x40004000UL
#define SOUND_UNIT_SIZE			0x00000030UL

#define SOUND_OUT_IRQ_NO		4					//sent when a buffer needs filling
#define SOUND_IN_IRQ_NO			5



#define SOUND_OFST_OUT_CTRL			0x00			//RW, SOUND_CTRL_BIT_*
#define SOUND_OFST_OUT_STA			0x04			//RO, number of samples per playback buffer. one sample is {L + R}
#define SOUND_OFST_OUT_BUF_0		0x08			//RW, pointer to first output buffer
#define SOUND_OFST_OUT_BUF_1		0x0c			//RW, pointer to second output buffer
#define SOUND_OFST_OUT_CUR_BUF		0x10			//RW, says which buffer is being used by the hw now
#define SOUND_OFST_OUT_NATIVE_RATE	0x14			//RO, in hz, top bit set if stereo

#define SOUND_OFST_IN_CTRL			0x18			//RW, SOUND_CTRL_BIT_*
#define SOUND_OFST_IN_STA			0x1C			//RO, number of samples per recording buffer
#define SOUND_OFST_IN_BUF_0			0x20			//RW, pointer to first input buffer
#define SOUND_OFST_IN_BUF_1			0x24			//RW, pointer to second input buffer
#define SOUND_OFST_IN_CUR_BUF		0x28			//RW, says which buffer is being used by the hw now
#define SOUND_OFST_IN_RATE			0x2c			//RW, in hz, sampling rate


//applies to IN and OUT CTRL regs
#define SOUND_CTRL_BIT_ON			0x00000001		//RW, enable out or disable it
#define SOUND_CTRL_BIT_AVAIL		0x00010000		//RO, set if it is available

#endif
