#include "machSpecific.h"
#include "remoteioComms.h"
#include "printf.h"
#include "input.h"
#include "cpu.h"
#include "kal.h"
#include "ral.h"
#include "dal.h"


static DrvInputKeyCbk mKeyCbk = NULL;
static DrvInputBtnCbk mBtnCbk = NULL;
static DrvInputPenCbk mPenCbk = NULL;
static uint32_t mPrevKeyState = 0;

static void drvInputVisorCommsButtonStateCbk(uint32_t state)
{
	if (!mBtnCbk)
		return;
	
	if (mPrevKeyState != state) {
		
		uint32_t diff = mPrevKeyState ^ state;
		uint32_t newlyPressed = state & diff;
		uint32_t newlyReleased = mPrevKeyState & diff;
		
		while (newlyPressed) {
			uint32_t bit = newlyPressed - (newlyPressed & (newlyPressed - 1));
			newlyPressed &=~ bit;
			mBtnCbk(bit, true);
		}
		while (newlyReleased) {
			uint32_t bit = newlyReleased - (newlyReleased & (newlyReleased - 1));
			newlyReleased &=~ bit;
			mBtnCbk(bit, false);
		}
		
		mPrevKeyState = state;
	}
}

static void drvInputVisorCommsPenStateCbk(int16_t x, int16_t y)
{
	uint32_t scale;
	
	#ifdef FAKE_HI_RES
		scale = 2;
	#else
		scale = 1;
	#endif
	
	if (mPenCbk)
		mPenCbk(x * scale, y * scale);
}

kstatus_t drvInputInit(DrvInputKeyCbk keyCbk, DrvInputBtnCbk btnCbk, DrvInputPenCbk penCbk)
{
	
	mKeyCbk = keyCbk;
	mBtnCbk = btnCbk;
	mPenCbk = penCbk;
	
	remoteioCommsSetInputHandlers(&drvInputVisorCommsButtonStateCbk, &drvInputVisorCommsPenStateCbk);

	return KERN_STATUS_OK;
}

kstatus_t drvInputPreSleep(void)
{
	return KERN_STATUS_OK;
}

kstatus_t drvInputPostWake(void)
{
	return KERN_STATUS_OK;
}
