#include <stdbool.h>
#include <stdint.h>
#include "msioComms.h"
#include "vibAndLed.h"
#include "printf.h"
#include "boot.h"

static uint32_t mEndTime = 0;

bool vibAndLedHwIsSupported(bool led)
{
	const struct MsioPktBootParams *bp = msioCommsWaitForContinueBoot();
	
	if (led)
		return !!(bp->miscBits & MISC_BIT_LED_SUPPORTED);
	else
		return !!(bp->miscBits & MISC_BIT_VIB_SUPPORTED);
}

void vibAndLedHwStart(bool led, const struct HwVibAndLedConfig* cfg)
{
	uint32_t csecPerPieceRounded = (cfg->csecPerPattern + 16) / 32;
	uint32_t totalTime = 0;

	if (csecPerPieceRounded < 1)
		csecPerPieceRounded = 1;
	
	if (cfg->numTimes)
		totalTime += (cfg->numTimes - 1) * cfg->csecBetween;
		
	totalTime += cfg->numTimes * 32 * csecPerPieceRounded;
	
	msioCommsVibAndLedControl(led, cfg->pattern, csecPerPieceRounded, cfg->csecBetween, cfg->numTimes);
	mEndTime = TimGetTicks() + totalTime;
}

void vibAndLedHwStop(bool led)
{
	msioCommsVibAndLedControl(led, 0, 0, 0, 0);
	mEndTime = 0;
}

bool vibAndLedHwIsActive(bool led)
{
	return led && TimGetTicks() >= mEndTime;
}
