#include "machSpecific.h"
#include "msioComms.h"
#include "printf.h"
#include "input.h"
#include "cpu.h"
#include "kal.h"
#include "ral.h"
#include "dal.h"


static DrvInputKeyCbk mKeyCbk = NULL;
static DrvInputBtnCbk mBtnCbk = NULL;
static DrvInputPenCbk mPenCbk = NULL;
static uint32_t mPrevKeyState = 0;

static void drvInputMsioCommsButtonStateCbk(uint32_t state, const uint16_t *keyboardStates)
{
	#warning "keyboardStates not yet used"
	
	if (mPrevKeyState != state) {
		
		uint32_t diff = mPrevKeyState ^ state;
		uint32_t newlyPressed = state & diff;
		uint32_t newlyReleased = mPrevKeyState & diff;
		
		while (newlyPressed) {
			uint32_t bit = newlyPressed - (newlyPressed & (newlyPressed - 1));
			newlyPressed &=~ bit;
			if (mBtnCbk)
				mBtnCbk(bit, true);
		}
		while (newlyReleased) {
			uint32_t bit = newlyReleased - (newlyReleased & (newlyReleased - 1));
			newlyReleased &=~ bit;
			if (mBtnCbk)
				mBtnCbk(bit, false);
		}
		
		mPrevKeyState = state;
	}
}

static void drvInputMsioCommsPenStateCbk(int16_t x, int16_t y)
{
	if (mPenCbk)
		mPenCbk(x, y);
}

kstatus_t drvInputInit(DrvInputKeyCbk keyCbk, DrvInputBtnCbk btnCbk, DrvInputPenCbk penCbk)
{
	mKeyCbk = keyCbk;
	mBtnCbk = btnCbk;
	mPenCbk = penCbk;
	
	msioCommsSetInputHandlers(&drvInputMsioCommsButtonStateCbk, &drvInputMsioCommsPenStateCbk);

	return KERN_STATUS_OK;
}

kstatus_t drvInputPreSleep(void)
{
	return KERN_STATUS_OK;
}

kstatus_t drvInputPostWake(void)
{
	return KERN_STATUS_OK;
}

uint32_t drvInputReadKeysEarly(void)
{
	return mPrevKeyState;
}


