#ifndef _K_HEAP_H_
#define _K_HEAP_H_

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>	//for NULL

//will alloc from static mem if heap isnt up yet


#define MEM_ANY					0x00	//ORR these
#define MEM_USABLE_AS_STACK		0x01
#define MEM_USABLE_FOR_DMA		0x02
#define MEM_USABLE_FOR_EXEC		0x04
#define MEM_FAST				0x08	//try fast memory first (there may not be much of it and no promises are made)
#define MEM_NO_OS_HEAP			0x10
#define MEM_UNCACHED			0x20	//only used if requested. fails if requested and no such heap exists

//heaps are considered in order they were added. palmos allocator is always considered last is MEM_FAST is used, else first
void kheapRegisterHeap(uint32_t start, uint32_t size, uint32_t attributes);	//attributes are the above flags

void kheapInit(void);

void* __attribute__((malloc)) kheapAllocEx(uint32_t sz, uint32_t intendedUse);
void kheapFree(void* ptr);

bool kheapIsInOurHeaps(void *ptr);
uint32_t kheapGetChunkSize(void *ptr);	//may be slightly over original size

static void* __attribute__((malloc))  kheapAlloc(uint32_t sz)
{
	return kheapAllocEx(sz, MEM_ANY);
}



#endif
