#include <stdint.h>
#include "memmap.h"
#include "printf.h"
#include "entry.h"
#include "ral.h"


/*
	note that not only do later OSs add calls, but
	a bit of a snafu happened between OS5.0 and 5.1+
	Sony made it worse, of course :)
	
	Namely, here are the differences
	
	FUNCTION					================== OFFSET IN EACH DAL ================== 
	NAME						DAL 5.0		Sony 5.0 (as per NX60)				DAL 5.2+
	HALDraw_Bitmap				0x2EC		0x2F0								0x2F8
	HALDRaw_FindIndexes			0x2F0		0x2F8								0x2FC
	HALDraw_GetPixel			0x2F4		0x2FC								0x300
	HALDraw_Chars				0x2F8		0x2F4								0x304
	HALDraw_Line				0x2FC		0x300								0x308
	HALDraw_Rectangle			0x300		0x308								0x30C
	HALDraw_Pixels				0x304		0x304								0x310
	
*/

#ifdef BUILDING_FOR_BIG_ARM
#pragma GCC target ("arm")
#endif

void __attribute__((used)) unknownFuncCalled(const char *name)
{
	//someone called a func we do not yet implement
	fatal("Unimplemented function called '%s' from 0x%08x\n", name, __builtin_return_address(0));
}

void __attribute__((used)) neverImplFuncCalled(const char *name)
{
	//someone called a func we never implement. we should call reset after logging it
	fatal("Never implementeed function called '%s' from 0x%08x\n", name, __builtin_return_address(0));
}



#define PLACEHOLDERIMPL(nm, fncToCall)												\
	void __attribute__((noreturn, used, naked)) impl_ ## nm(void)					\
	{																				\
		asm volatile("mov r0, %0\nb " #fncToCall "\n"::"r"(#nm):"memory","cc");		\
	}

#define DEFAULTIMPL(nm)	PLACEHOLDERIMPL(nm, unknownFuncCalled)
#define NEVERIMPL(nm)	PLACEHOLDERIMPL(nm, neverImplFuncCalled)




DEFAULTIMPL(HALDbgBreak)
DEFAULTIMPL(HALBatteryGetValidKinds)
DEFAULTIMPL(HALBatterySetInfo)
DEFAULTIMPL(HALDelay)
DEFAULTIMPL(HALDisplayGetPalette)
DEFAULTIMPL(HALDisplayLock)
DEFAULTIMPL(HALDisplayUnlock)
DEFAULTIMPL(HALDrawInit)
NEVERIMPL(HALDrawCopyRectangle)
NEVERIMPL(HALDrawGetPixel)
NEVERIMPL(HALDrawChars)
NEVERIMPL(HALDrawLine)
NEVERIMPL(HALDrawRectangle)
NEVERIMPL(HALDrawSetPixel)
NEVERIMPL(HALDrawSetPixels)
NEVERIMPL(HALFlpDoubleToLongDouble)
NEVERIMPL(HALFlpFloatToLongDouble)
NEVERIMPL(HALFlpLongDoubleToDouble)
NEVERIMPL(HALFlpLongDoubleToFloat)
DEFAULTIMPL(HALMemoryValidateArea)
DEFAULTIMPL(HALPenGetPosition)
DEFAULTIMPL(HALSetHwrMiscFlags)
DEFAULTIMPL(HALTimeGetSystemTimerInterval)
DEFAULTIMPL(HwrCalcDynamicHeapSize)
DEFAULTIMPL(HwrCalcDynamicRAMSize)
DEFAULTIMPL(KALEventGroupGetInfo)
DEFAULTIMPL(KALMailboxGetInfo)
DEFAULTIMPL(KALMutexGetInfo)
DEFAULTIMPL(KALSemaphoreGetInfo)
DEFAULTIMPL(KALTaskExit)
DEFAULTIMPL(KALTimerGetInfo)
NEVERIMPL(HALTable02F0)
NEVERIMPL(HALTable02F4)
DEFAULTIMPL(HALSoundDispose)
DEFAULTIMPL(OEMReserved1)
DEFAULTIMPL(OEMReserved2)
DEFAULTIMPL(OEMReserved3)
DEFAULTIMPL(OEMReserved4)
DEFAULTIMPL(OEMReserved5)
DEFAULTIMPL(OEMReserved6)
DEFAULTIMPL(OEMReserved7)
DEFAULTIMPL(OEMReserved8)
DEFAULTIMPL(OEMReserved9)
DEFAULTIMPL(OEMReserved10)
DEFAULTIMPL(OEMReserved11)
DEFAULTIMPL(OEMReserved12)
DEFAULTIMPL(OEMReserved13)
DEFAULTIMPL(OEMReserved14)
DEFAULTIMPL(OEMReserved15)
DEFAULTIMPL(OEMReserved16)
DEFAULTIMPL(OEMReserved17)
DEFAULTIMPL(OEMReserved18)
DEFAULTIMPL(OEMReserved19)
DEFAULTIMPL(OEMReserved20)
DEFAULTIMPL(OEMReserved21)
DEFAULTIMPL(OEMReserved22)
DEFAULTIMPL(OEMReserved23)
DEFAULTIMPL(OEMReserved24)
DEFAULTIMPL(OEMReserved25)
DEFAULTIMPL(OEMReserved26)
DEFAULTIMPL(OEMReserved27)
DEFAULTIMPL(OEMReserved28)
DEFAULTIMPL(OEMReserved29)
DEFAULTIMPL(OEMReserved30)
DEFAULTIMPL(OEMReserved31)
DEFAULTIMPL(OEMReserved32)


#ifdef SUPPORT_ZODIAC
	DEFAULTIMPL(TwUnknown054)
	DEFAULTIMPL(TwUnknown058)
	DEFAULTIMPL(TwUnknown060)
	DEFAULTIMPL(TwUnknown064)
	DEFAULTIMPL(TwUnknown068)
	DEFAULTIMPL(TwUnknown06c)
	DEFAULTIMPL(TwUnknown070)
	DEFAULTIMPL(TwUnknown3c0)
	DEFAULTIMPL(TwUnknown3c4)
	DEFAULTIMPL(TwUnknown3c8)
	DEFAULTIMPL(TwUnknown3cc)
	DEFAULTIMPL(TwUnknown3d0)
	DEFAULTIMPL(TwUnknown3d4)
	DEFAULTIMPL(TwUnknown3d8)
	DEFAULTIMPL(TwUnknown3dc)
	DEFAULTIMPL(TwUnknown3e0)
	DEFAULTIMPL(TwUnknown3e4)
	DEFAULTIMPL(TwUnknown3e8)
	DEFAULTIMPL(TwUnknown3ec)
	DEFAULTIMPL(TwUnknown3f0)
	DEFAULTIMPL(TwUnknown3f4)
	DEFAULTIMPL(TwUnknown3f8)
	DEFAULTIMPL(TwUnknown3fc)
	DEFAULTIMPL(TwUnknown400)
	DEFAULTIMPL(TwUnknown404)
	DEFAULTIMPL(TwUnknown408)
	DEFAULTIMPL(TwGfxTransformBlt)
	DEFAULTIMPL(TwGfxDrawLines)
	DEFAULTIMPL(TwGfxDrawLineSegments)
	DEFAULTIMPL(TwGfxStretchBlt)
	DEFAULTIMPL(TwGfxTileBlt)
	DEFAULTIMPL(TwGfxMaskBlt)
	DEFAULTIMPL(TwGfxAsyncBlt)
	DEFAULTIMPL(TwGfxStretchBlt2)
	DEFAULTIMPL(TwUnknown500)
	DEFAULTIMPL(TwUnknown504)
	DEFAULTIMPL(TwUnknown508)
	DEFAULTIMPL(TwUnknown50c)
	DEFAULTIMPL(TwUnknown510)
	DEFAULTIMPL(TwUnknown514)
	DEFAULTIMPL(TwUnknown518)
	DEFAULTIMPL(TwUnknown51c)
	DEFAULTIMPL(TwUnknown520)
	DEFAULTIMPL(TwUnknown524)
	DEFAULTIMPL(TwUnknown528)
	DEFAULTIMPL(TwUnknown52c)
	DEFAULTIMPL(TwUnknown530)
	DEFAULTIMPL(TwUnknown534)
	DEFAULTIMPL(TwUnknown538)
	DEFAULTIMPL(TwUnknown53c)
	DEFAULTIMPL(TwUnknown540)
	DEFAULTIMPL(TwUnknown544)
	DEFAULTIMPL(TwUnknown548)
	DEFAULTIMPL(TwUnknown54c)
	DEFAULTIMPL(TwUnknown550)
	DEFAULTIMPL(TwUnknown558)
	DEFAULTIMPL(TwUnknown55c)
	DEFAULTIMPL(TwUnknown560)
	DEFAULTIMPL(TwSecGetFunctions_ARM)
	DEFAULTIMPL(TwSecCheckForDevAccessApp)
	DEFAULTIMPL(TwSecFailureReset)
	DEFAULTIMPL(TwSecGetFunctions_68k)
	DEFAULTIMPL(TwUnknown580)
	DEFAULTIMPL(TwUnknown584)
	DEFAULTIMPL(TwUnknown588)
	DEFAULTIMPL(TwUnknown58c)
	DEFAULTIMPL(TwUnknown590)
	DEFAULTIMPL(TwUnknown594)
	DEFAULTIMPL(TwUnknown598)
	DEFAULTIMPL(TwUnknown59c)
	DEFAULTIMPL(TwGetHwrResetReason)
	DEFAULTIMPL(TwUnknown5ac)
	DEFAULTIMPL(TwUnknown5b0)
	DEFAULTIMPL(TwUnknown5b4)
	DEFAULTIMPL(TwUnknown5b8)
	DEFAULTIMPL(TwDisableHwWatchdogTimer)
#endif


extern void __stack_top();
extern void __ram_data_data();
extern void __ram_data_start();
extern void __ram_data_end();
extern void __bss_start();
extern void __bss_end();
extern void __ramcode_start();
extern void __ramcode_end();
extern void __ramcode_data();

extern uint32_t _entry(uint32_t cmd, void* cmdPBP, uint16_t flags);
uint32_t __attribute__((used)) __entry(uint32_t cmd, void* cmdPBP, uint16_t flags)
{
	volatile uint32_t *dst, *src, *end;		//"volatile" is so that we do not end up with a call to memcpy
	
	if (cmd == RAL_CMD_DAL_FIRST_BOOT) {
	
		//copy data
		dst = (volatile uint32_t*)&__ram_data_start;
		src = (volatile uint32_t*)&__ram_data_data;
		end = (volatile uint32_t*)&__ram_data_end;
		while (dst != end)
			*dst++ = *src++;
		
		//copy code
		dst = (volatile uint32_t*)&__ramcode_start;
		src = (volatile uint32_t*)&__ramcode_data;
		end = (volatile uint32_t*)&__ramcode_end;
		while (dst != end)
			*dst++ = *src++;
	
		//init bss
		dst = (volatile uint32_t*)&__bss_start;
		end = (volatile uint32_t*)&__bss_end;
		while (dst != end)
			*dst++ = 0;
		
		machInit(STAGE_SOMEWHAT_EARLY_INIT, NULL);
	}
	
	return _entry(cmd, cmdPBP, flags);
}

void __attribute__((naked,used,section(".vectors"))) vecs(void)
{
	asm volatile(
	
		#if defined(BUILD_FOR_THUMB_1) && !defined(HAVE_v8M_BASE)
			#define JEXPORT	"JEXPORT"
			".macro JEXPORT lbl	\n\t"
			"	B tramp_\\lbl	\n\t"
			"	nop				\n\t"
			".endm				\n\t"
			#define B			"B"
		#elif !defined(BUILDING_FOR_BIG_ARM)
			#define JEXPORT		"B.W"
			#define B			"B.W"
		#else
			#define JEXPORT		"B"
			#define B			"B"
		#endif
	
		".syntax unified		\n\t"
		"1:						\n\t"	//for offset calc
	
	#if defined(BUILD_FOR_THUMB_1) && !defined(HAVE_v8M_BASE)
		B" ___entry_is_m0		\n\t"
	#else
		B" ___entry				\n\t"
	#endif
		".balign 4				\n\t"	//make sure this starts at 4
		".word	1f - 1b			\n\t"	//exported funcs offset
		".word	0x00			\n\t"	//ID (lo16) and somethign else (hi16)
		".word	0x02			\n\t"	//flags?
	#ifdef SUPPORT_ZODIAC
		".word  0x176			\n\t"
	#else
		".word	0xF1			\n\t"	//num exported funcs
	#endif
		".word	0x72737263		\n\t"	//type 'rsrc'
		".word	0x7064616C		\n\t"	//creator 'pdal'
		".word	0x616D6463		\n\t"	//resource type 'amdc' (seems weird but this is right)
		".word	0x70000			\n\t"	//flags

#if defined(BUILD_FOR_THUMB_1) && !defined(HAVE_v8M_BASE)
	
		"___entry_is_m0:						\n\t"
		"	mov r12, lr							\n\t"
		"	bl  ___entry_from_m0				\n\t"
	
		"99:									\n\t"
		"	str  r0, [sp, #4]					\n\t"
		"	pop  {r0, pc}						\n\t"
		
	
		".macro m0_trampoline lbl				\n\t"
		"	tramp_\\lbl:						\n\t"
		"	push {r0, lr}						\n\t"
		"	ldr  r0, =\\lbl						\n\t"
		"	b    99b							\n\t"
		".endm									\n\t"
	
		"m0_trampoline impl_DALGetGlobalsPtr					\n\t"
		"m0_trampoline impl_HALDbgBreak					\n\t"
		"m0_trampoline impl_HALDbgMessage					\n\t"
		"m0_trampoline impl_HALAttnGetLEDAttributes					\n\t"
		"m0_trampoline impl_HALAttnGetVibrateAttributes					\n\t"
		"m0_trampoline impl_HALAttnSetLEDAttributes					\n\t"
		"m0_trampoline impl_HALAttnSetVibrateAttributes					\n\t"
		"m0_trampoline impl_HALBatteryGetInfo					\n\t"
		"m0_trampoline impl_HALBatteryGetValidKinds					\n\t"
		"m0_trampoline impl_HALBatterySetInfo					\n\t"
		"m0_trampoline impl_HALDelay					\n\t"
		"m0_trampoline impl_HALDisplayGetAttributes					\n\t"
		"m0_trampoline impl_HALDisplayGetPalette					\n\t"
		"m0_trampoline impl_HALDisplaySetAttributes					\n\t"
		"m0_trampoline impl_HALDisplaySetPalette					\n\t"
		"m0_trampoline impl_HALDisplayDoze					\n\t"
		"m0_trampoline impl_HALDisplayWake					\n\t"
		"m0_trampoline impl_HALDisplayLock					\n\t"
		"m0_trampoline impl_HALDisplayUnlock					\n\t"
		"m0_trampoline impl_HALDockStatus					\n\t"
		"m0_trampoline impl_HALDrawInit					\n\t"
		
		#ifndef SUPPORT_ZODIAC
		
			"m0_trampoline impl_HALDrawCopyRectangle						\n\t"
			"m0_trampoline impl_HALDrawFindIndexes						\n\t"
			"m0_trampoline impl_HALDrawGetPixel							\n\t"
			"m0_trampoline impl_HALDrawChars								\n\t"
			"m0_trampoline impl_HALDrawLine								\n\t"
			"m0_trampoline impl_HALDrawRectangle							\n\t"
			"m0_trampoline impl_HALDrawSetPixel							\n\t"
			"m0_trampoline impl_HALDrawSetPixels							\n\t"
		#else
			"m0_trampoline impl_TwUnknown054								\n\t"
			"m0_trampoline impl_TwUnknown058								\n\t"
			"m0_trampoline impl_TwGetInterfaceFuncs						\n\t"
			"m0_trampoline impl_TwUnknown060								\n\t"
			"m0_trampoline impl_TwUnknown064								\n\t"
			"m0_trampoline impl_TwUnknown068								\n\t"
			"m0_trampoline impl_TwUnknown06c								\n\t"
			"m0_trampoline impl_TwUnknown070								\n\t"
		#endif
		
		"m0_trampoline impl_HALErrDisplay					\n\t"
		"m0_trampoline impl_HALEventPost					\n\t"
		"m0_trampoline impl_HALEventRegisterCallBack					\n\t"
		"m0_trampoline impl_HALFlpAddDouble					\n\t"
		"m0_trampoline impl_HALFlpAddFloat					\n\t"
		"m0_trampoline impl_HALFlpCompareDoubleEqual					\n\t"
		"m0_trampoline impl_HALFlpCompareDoubleLessThan					\n\t"
		"m0_trampoline impl_HALFlpCompareFloatEqual					\n\t"
		"m0_trampoline impl_HALFlpCompareFloatLessThan					\n\t"
		"m0_trampoline impl_HALFlpDivDouble					\n\t"
		"m0_trampoline impl_HALFlpDivFloat					\n\t"
		"m0_trampoline impl_HALFlpDoubleToFloat					\n\t"
		"m0_trampoline impl_HALFlpDoubleToInt32					\n\t"
		"m0_trampoline impl_HALFlpDoubleToLongDouble					\n\t"
		"m0_trampoline impl_HALFlpDoubleToLongLong					\n\t"
		"m0_trampoline impl_HALFlpDoubleToUInt32					\n\t"
		"m0_trampoline impl_HALFlpDoubleToULongLong					\n\t"
		"m0_trampoline impl_HALFlpFloatToDouble					\n\t"
		"m0_trampoline impl_HALFlpFloatToInt32					\n\t"
		"m0_trampoline impl_HALFlpFloatToLongDouble					\n\t"
		"m0_trampoline impl_HALFlpFloatToLongLong					\n\t"
		"m0_trampoline impl_HALFlpFloatToUInt32					\n\t"
		"m0_trampoline impl_HALFlpFloatToULongLong					\n\t"
		"m0_trampoline impl_HALFlpInt32ToDouble					\n\t"
		"m0_trampoline impl_HALFlpInt32ToFloat					\n\t"
		"m0_trampoline impl_HALFlpLongDoubleToDouble					\n\t"
		"m0_trampoline impl_HALFlpLongDoubleToFloat					\n\t"
		"m0_trampoline impl_HALFlpLongLongToDouble					\n\t"
		"m0_trampoline impl_HALFlpLongLongToFloat					\n\t"
		"m0_trampoline impl_HALFlpMulDouble					\n\t"
		"m0_trampoline impl_HALFlpMulFloat					\n\t"
		"m0_trampoline impl_HALFlpNegDouble					\n\t"
		"m0_trampoline impl_HALFlpNegFloat					\n\t"
		"m0_trampoline impl_HALFlpSubDouble					\n\t"
		"m0_trampoline impl_HALFlpSubFloat					\n\t"
		"m0_trampoline impl_HALFlpUInt32ToDouble					\n\t"
		"m0_trampoline impl_HALFlpUInt32ToFloat					\n\t"
		"m0_trampoline impl_HALFlpULongLongToDouble					\n\t"
		"m0_trampoline impl_HALFlpULongLongToFloat					\n\t"
		"m0_trampoline impl_HALGetHwrMiscFlags					\n\t"
		"m0_trampoline impl_HALGetHwrMiscFlagsExt					\n\t"
		"m0_trampoline impl_HALGetHwrWakeUp					\n\t"
		"m0_trampoline impl_HALInterruptAllSetStatus					\n\t"
		"m0_trampoline impl_HALInterruptAllGetStatus					\n\t"
		"m0_trampoline impl_HALInterruptGetHandler					\n\t"
		"m0_trampoline impl_HALInterruptSetHandler					\n\t"
		"m0_trampoline impl_HALInterruptSetState					\n\t"
		"m0_trampoline impl_HALKeyGetRates					\n\t"
		"m0_trampoline impl_HALKeyGetState					\n\t"
		"m0_trampoline impl_HALKeyResetDoubleTap					\n\t"
		"m0_trampoline impl_HALKeySetMask					\n\t"
		"m0_trampoline impl_HALKeySetRates					\n\t"
		"m0_trampoline impl_HALMemoryGetMemoryMap					\n\t"
		"m0_trampoline impl_HALMemoryGetStorageAreaProtectionState					\n\t"
		"m0_trampoline impl_HALMemorySetStorageAreaProtectionState					\n\t"
		"m0_trampoline impl_HALMemoryValidateArea					\n\t"
		"m0_trampoline impl_HALMemoryGetAreaSize					\n\t"
		"m0_trampoline impl_HALPenCalibrate					\n\t"
		"m0_trampoline impl_HALPenRawToScreen					\n\t"
		"m0_trampoline impl_HALPenResetCalibration					\n\t"
		"m0_trampoline impl_HALPenGetPosition					\n\t"
		"m0_trampoline impl_HALPenScreenToRaw					\n\t"
		"m0_trampoline impl_HALPowerGetAutoOffEvtTime					\n\t"
		"m0_trampoline impl_HALPowerGetAutoOffSeconds					\n\t"
		"m0_trampoline impl_HALPowerSetAutoOffEvtTime					\n\t"
		"m0_trampoline impl_HALPowerSetAutoOffSeconds					\n\t"
		"m0_trampoline impl_HALPowerSleepReady					\n\t"
		"m0_trampoline impl_HALProcessorID					\n\t"
		"m0_trampoline impl_HALRandomGetBits					\n\t"
		"m0_trampoline impl_HALRandomInitializeSeed					\n\t"
		"m0_trampoline impl_HALReset					\n\t"
		"m0_trampoline impl_HALScreenDefaultPalette					\n\t"
		"m0_trampoline impl_HALScreenDrawNotify					\n\t"
		"m0_trampoline impl_HALScreenGetColortable					\n\t"
		"m0_trampoline impl_HALScreenInit					\n\t"
		"m0_trampoline impl_HALScreenLock					\n\t"
		"m0_trampoline impl_HALScreenPalette					\n\t"
		"m0_trampoline impl_HALScreenSendUpdateArea					\n\t"
		"m0_trampoline impl_HALScreenUnlock					\n\t"
		"m0_trampoline impl_HALScreenUpdateBitmap					\n\t"
		"m0_trampoline impl_HALSetInitStage					\n\t"
		"m0_trampoline impl_HALSetHwrMiscFlags					\n\t"
		"m0_trampoline impl_HALSilkscreenGetID					\n\t"
		"m0_trampoline impl_HALSoundOff					\n\t"
		"m0_trampoline impl_HALSoundPlay					\n\t"
		"m0_trampoline impl_HALTimeGetAlarm					\n\t"
		"m0_trampoline impl_HALTimeGetSeconds					\n\t"
		"m0_trampoline impl_HALTimeGetSystemTime					\n\t"
		"m0_trampoline impl_HALTimeGetSystemTimerInterval					\n\t"
		"m0_trampoline impl_HALTimeSetAlarm					\n\t"
		"m0_trampoline impl_HALTimeSetSeconds					\n\t"
		"m0_trampoline impl_HALTraceInit					\n\t"
		"m0_trampoline impl_HALTraceClose					\n\t"
		"m0_trampoline impl_HALTraceOutputT					\n\t"
		"m0_trampoline impl_HALTraceOutputTL					\n\t"
		"m0_trampoline impl_HALTraceOutputVT					\n\t"
		"m0_trampoline impl_HALTraceOutputVTL					\n\t"
		"m0_trampoline impl_HALTraceOutputB					\n\t"
		"m0_trampoline impl_HALOEMGetCompanyID					\n\t"
		"m0_trampoline impl_HALOEMGetHALID					\n\t"
		"m0_trampoline impl_HALOEMGetDeviceID					\n\t"
		"m0_trampoline impl_HwrCalcDynamicHeapSize					\n\t"
		"m0_trampoline impl_HwrCalcDynamicRAMSize					\n\t"
		"m0_trampoline impl_HALDisplayDrawBootScreen					\n\t"
		"m0_trampoline impl_HALGetROMToken					\n\t"
		"m0_trampoline impl_KALEventGroupClear					\n\t"
		"m0_trampoline impl_KALEventGroupCreate					\n\t"
		"m0_trampoline impl_KALEventGroupDelete					\n\t"
		"m0_trampoline impl_KALEventGroupRead					\n\t"
		"m0_trampoline impl_KALEventGroupSignal					\n\t"
		"m0_trampoline impl_KALEventGroupWait					\n\t"
		"m0_trampoline impl_KALEventGroupGetInfo					\n\t"
		"m0_trampoline impl_KALMailboxCreate					\n\t"
		"m0_trampoline impl_KALMailboxDelete					\n\t"
		"m0_trampoline impl_KALMailboxSend					\n\t"
		"m0_trampoline impl_KALMailboxWait					\n\t"
		"m0_trampoline impl_KALMailboxGetInfo					\n\t"
		"m0_trampoline impl_KALMutexCreate					\n\t"
		".ltorg		\n\t"
		
#endif






		"1:						\n\t"	//for offset calc


		JEXPORT" impl_DALGetGlobalsPtr							\n\t"
		JEXPORT" impl_HALDbgBreak								\n\t"
		JEXPORT" impl_HALDbgMessage								\n\t"
		JEXPORT" impl_HALAttnGetLEDAttributes					\n\t"
		JEXPORT" impl_HALAttnGetVibrateAttributes				\n\t"
		JEXPORT" impl_HALAttnSetLEDAttributes					\n\t"
		JEXPORT" impl_HALAttnSetVibrateAttributes				\n\t"
		JEXPORT" impl_HALBatteryGetInfo							\n\t"
		JEXPORT" impl_HALBatteryGetValidKinds					\n\t"
		JEXPORT" impl_HALBatterySetInfo							\n\t"
		JEXPORT" impl_HALDelay									\n\t"
		JEXPORT" impl_HALDisplayGetAttributes					\n\t"
		JEXPORT" impl_HALDisplayGetPalette						\n\t"
		JEXPORT" impl_HALDisplaySetAttributes					\n\t"
		JEXPORT" impl_HALDisplaySetPalette						\n\t"
		JEXPORT" impl_HALDisplayDoze							\n\t"
		JEXPORT" impl_HALDisplayWake							\n\t"
		JEXPORT" impl_HALDisplayLock							\n\t"
		JEXPORT" impl_HALDisplayUnlock							\n\t"
		JEXPORT" impl_HALDockStatus								\n\t"
		JEXPORT" impl_HALDrawInit								\n\t"
	#ifndef SUPPORT_ZODIAC
		
		JEXPORT" impl_HALDrawCopyRectangle						\n\t"
		JEXPORT" impl_HALDrawFindIndexes						\n\t"
		JEXPORT" impl_HALDrawGetPixel							\n\t"
		JEXPORT" impl_HALDrawChars								\n\t"
		JEXPORT" impl_HALDrawLine								\n\t"
		JEXPORT" impl_HALDrawRectangle							\n\t"
		JEXPORT" impl_HALDrawSetPixel							\n\t"
		JEXPORT" impl_HALDrawSetPixels							\n\t"
	#else
		JEXPORT" impl_TwUnknown054								\n\t"
		JEXPORT" impl_TwUnknown058								\n\t"
		JEXPORT" impl_TwGetInterfaceFuncs						\n\t"
		JEXPORT" impl_TwUnknown060								\n\t"
		JEXPORT" impl_TwUnknown064								\n\t"
		JEXPORT" impl_TwUnknown068								\n\t"
		JEXPORT" impl_TwUnknown06c								\n\t"
		JEXPORT" impl_TwUnknown070								\n\t"
	#endif
		
		JEXPORT" impl_HALErrDisplay								\n\t"
		JEXPORT" impl_HALEventPost								\n\t"
		JEXPORT" impl_HALEventRegisterCallBack					\n\t"
		JEXPORT" impl_HALFlpAddDouble							\n\t"
		JEXPORT" impl_HALFlpAddFloat							\n\t"
		JEXPORT" impl_HALFlpCompareDoubleEqual					\n\t"
		JEXPORT" impl_HALFlpCompareDoubleLessThan				\n\t"
		JEXPORT" impl_HALFlpCompareFloatEqual					\n\t"
		JEXPORT" impl_HALFlpCompareFloatLessThan				\n\t"
		JEXPORT" impl_HALFlpDivDouble							\n\t"
		JEXPORT" impl_HALFlpDivFloat							\n\t"
		JEXPORT" impl_HALFlpDoubleToFloat						\n\t"
		JEXPORT" impl_HALFlpDoubleToInt32						\n\t"
		JEXPORT" impl_HALFlpDoubleToLongDouble					\n\t"
		JEXPORT" impl_HALFlpDoubleToLongLong					\n\t"
		JEXPORT" impl_HALFlpDoubleToUInt32						\n\t"
		JEXPORT" impl_HALFlpDoubleToULongLong					\n\t"
		JEXPORT" impl_HALFlpFloatToDouble						\n\t"
		JEXPORT" impl_HALFlpFloatToInt32						\n\t"
		JEXPORT" impl_HALFlpFloatToLongDouble					\n\t"
		JEXPORT" impl_HALFlpFloatToLongLong						\n\t"
		JEXPORT" impl_HALFlpFloatToUInt32						\n\t"
		JEXPORT" impl_HALFlpFloatToULongLong					\n\t"
		JEXPORT" impl_HALFlpInt32ToDouble						\n\t"
		JEXPORT" impl_HALFlpInt32ToFloat						\n\t"
		JEXPORT" impl_HALFlpLongDoubleToDouble					\n\t"
		JEXPORT" impl_HALFlpLongDoubleToFloat					\n\t"
		JEXPORT" impl_HALFlpLongLongToDouble					\n\t"
		JEXPORT" impl_HALFlpLongLongToFloat						\n\t"
		JEXPORT" impl_HALFlpMulDouble							\n\t"
		JEXPORT" impl_HALFlpMulFloat							\n\t"
		JEXPORT" impl_HALFlpNegDouble							\n\t"
		JEXPORT" impl_HALFlpNegFloat							\n\t"
		JEXPORT" impl_HALFlpSubDouble							\n\t"
		JEXPORT" impl_HALFlpSubFloat							\n\t"
		JEXPORT" impl_HALFlpUInt32ToDouble						\n\t"
		JEXPORT" impl_HALFlpUInt32ToFloat						\n\t"
		JEXPORT" impl_HALFlpULongLongToDouble					\n\t"
		JEXPORT" impl_HALFlpULongLongToFloat					\n\t"
		JEXPORT" impl_HALGetHwrMiscFlags						\n\t"
		JEXPORT" impl_HALGetHwrMiscFlagsExt						\n\t"
		JEXPORT" impl_HALGetHwrWakeUp							\n\t"
		JEXPORT" impl_HALInterruptAllSetStatus					\n\t"
		JEXPORT" impl_HALInterruptAllGetStatus					\n\t"
		JEXPORT" impl_HALInterruptGetHandler					\n\t"
		JEXPORT" impl_HALInterruptSetHandler					\n\t"
		JEXPORT" impl_HALInterruptSetState						\n\t"
		JEXPORT" impl_HALKeyGetRates							\n\t"
		JEXPORT" impl_HALKeyGetState							\n\t"
		JEXPORT" impl_HALKeyResetDoubleTap						\n\t"
		JEXPORT" impl_HALKeySetMask								\n\t"
		JEXPORT" impl_HALKeySetRates							\n\t"
		JEXPORT" impl_HALMemoryGetMemoryMap						\n\t"
		JEXPORT" impl_HALMemoryGetStorageAreaProtectionState	\n\t"
		JEXPORT" impl_HALMemorySetStorageAreaProtectionState	\n\t"
		JEXPORT" impl_HALMemoryValidateArea						\n\t"
		JEXPORT" impl_HALMemoryGetAreaSize						\n\t"
		JEXPORT" impl_HALPenCalibrate							\n\t"
		JEXPORT" impl_HALPenRawToScreen							\n\t"
		JEXPORT" impl_HALPenResetCalibration					\n\t"
		JEXPORT" impl_HALPenGetPosition							\n\t"
		JEXPORT" impl_HALPenScreenToRaw							\n\t"
		JEXPORT" impl_HALPowerGetAutoOffEvtTime					\n\t"
		JEXPORT" impl_HALPowerGetAutoOffSeconds					\n\t"
		JEXPORT" impl_HALPowerSetAutoOffEvtTime					\n\t"
		JEXPORT" impl_HALPowerSetAutoOffSeconds					\n\t"
		JEXPORT" impl_HALPowerSleepReady						\n\t"
		JEXPORT" impl_HALProcessorID							\n\t"
		JEXPORT" impl_HALRandomGetBits							\n\t"
		JEXPORT" impl_HALRandomInitializeSeed					\n\t"
		JEXPORT" impl_HALReset									\n\t"
		JEXPORT" impl_HALScreenDefaultPalette					\n\t"
		JEXPORT" impl_HALScreenDrawNotify						\n\t"
		JEXPORT" impl_HALScreenGetColortable					\n\t"
		JEXPORT" impl_HALScreenInit								\n\t"
		JEXPORT" impl_HALScreenLock								\n\t"
		JEXPORT" impl_HALScreenPalette							\n\t"
		JEXPORT" impl_HALScreenSendUpdateArea					\n\t"
		JEXPORT" impl_HALScreenUnlock							\n\t"
		JEXPORT" impl_HALScreenUpdateBitmap						\n\t"
		JEXPORT" impl_HALSetInitStage							\n\t"
		JEXPORT" impl_HALSetHwrMiscFlags						\n\t"
		JEXPORT" impl_HALSilkscreenGetID						\n\t"
		JEXPORT" impl_HALSoundOff								\n\t"
		JEXPORT" impl_HALSoundPlay								\n\t"
		JEXPORT" impl_HALTimeGetAlarm							\n\t"
		JEXPORT" impl_HALTimeGetSeconds							\n\t"
		JEXPORT" impl_HALTimeGetSystemTime						\n\t"
		JEXPORT" impl_HALTimeGetSystemTimerInterval				\n\t"
		JEXPORT" impl_HALTimeSetAlarm							\n\t"
		JEXPORT" impl_HALTimeSetSeconds							\n\t"
		JEXPORT" impl_HALTraceInit								\n\t"
		JEXPORT" impl_HALTraceClose								\n\t"
		JEXPORT" impl_HALTraceOutputT							\n\t"
		JEXPORT" impl_HALTraceOutputTL							\n\t"
		JEXPORT" impl_HALTraceOutputVT							\n\t"
		JEXPORT" impl_HALTraceOutputVTL							\n\t"
		JEXPORT" impl_HALTraceOutputB							\n\t"
		JEXPORT" impl_HALOEMGetCompanyID						\n\t"
		JEXPORT" impl_HALOEMGetHALID							\n\t"
		JEXPORT" impl_HALOEMGetDeviceID							\n\t"
		JEXPORT" impl_HwrCalcDynamicHeapSize					\n\t"
		JEXPORT" impl_HwrCalcDynamicRAMSize						\n\t"
		JEXPORT" impl_HALDisplayDrawBootScreen					\n\t"
		JEXPORT" impl_HALGetROMToken							\n\t"
		JEXPORT" impl_KALEventGroupClear						\n\t"
		JEXPORT" impl_KALEventGroupCreate						\n\t"
		JEXPORT" impl_KALEventGroupDelete						\n\t"
		JEXPORT" impl_KALEventGroupRead							\n\t"
		JEXPORT" impl_KALEventGroupSignal						\n\t"
		JEXPORT" impl_KALEventGroupWait							\n\t"
		JEXPORT" impl_KALEventGroupGetInfo						\n\t"
		JEXPORT" impl_KALMailboxCreate							\n\t"
		JEXPORT" impl_KALMailboxDelete							\n\t"
		JEXPORT" impl_KALMailboxSend							\n\t"
		JEXPORT" impl_KALMailboxWait							\n\t"
		JEXPORT" impl_KALMailboxGetInfo							\n\t"
		JEXPORT" impl_KALMutexCreate							\n\t"
		JEXPORT" impl_KALMutexDelete							\n\t"
		JEXPORT" impl_KALMutexRelease							\n\t"
		JEXPORT" impl_KALMutexReserve							\n\t"
		JEXPORT" impl_KALMutexGetInfo							\n\t"
		JEXPORT" impl_KALSemaphoreCreate						\n\t"
		JEXPORT" impl_KALSemaphoreDelete						\n\t"
		JEXPORT" impl_KALSemaphoreSignal						\n\t"
		JEXPORT" impl_KALSemaphoreWait							\n\t"
		JEXPORT" impl_KALSemaphoreGetInfo						\n\t"
		JEXPORT" impl_KALTaskCreate								\n\t"
		JEXPORT" impl_KALTaskDelay								\n\t"
		JEXPORT" impl_KALTaskDelete								\n\t"
		JEXPORT" impl_KALTaskGetCurrentID						\n\t"
		JEXPORT" impl_KALTaskGetInfo							\n\t"
		JEXPORT" impl_KALTaskResume								\n\t"
		JEXPORT" impl_KALTaskSuspend							\n\t"
		JEXPORT" impl_KALTaskStart								\n\t"
		JEXPORT" impl_KALTaskSwitching							\n\t"
		JEXPORT" impl_KALTaskWait								\n\t"
		JEXPORT" impl_KALTaskWaitClr							\n\t"
		JEXPORT" impl_KALTaskWake								\n\t"
		JEXPORT" impl_KALTaskExit								\n\t"
		JEXPORT" impl_KALTimerCreate							\n\t"
		JEXPORT" impl_KALTimerDelete							\n\t"
		JEXPORT" impl_KALTimerSet								\n\t"
		JEXPORT" impl_KALTimerGetInfo							\n\t"
		JEXPORT" impl_RALCallWithNewStack						\n\t"
		JEXPORT" impl_RALGetEntryAddresses						\n\t"
		JEXPORT" impl_RALGetModuleInfo							\n\t"
		JEXPORT" impl_RALGetStaticBase							\n\t"
		JEXPORT" impl_RALLinkClient								\n\t"
		JEXPORT" impl_RALLoadModule								\n\t"
		JEXPORT" impl_RALPatchEntry								\n\t"
		JEXPORT" impl_RALSetA5									\n\t"
		JEXPORT" impl_RALUnloadModule							\n\t"
		JEXPORT" impl_RALUnloadNext								\n\t"
		JEXPORT" impl_DALSetDbgLockout							\n\t"
		JEXPORT" impl_HALKeyGetDoubleTapDelay					\n\t"
		JEXPORT" impl_HALKeySetDoubleTapDelay					\n\t"
		JEXPORT" impl_HALInvalidateICache						\n\t"
		JEXPORT" impl_HALHandleReset							\n\t"
		JEXPORT" impl_HALTable02F0								\n\t"
		JEXPORT" impl_HALTable02F4								\n\t"
		JEXPORT" impl_HALDraw_Bitmap							\n\t"
		JEXPORT" impl_HALDraw_FindIndexes						\n\t"
		JEXPORT" impl_HALDraw_GetPixel							\n\t"
		JEXPORT" impl_HALDraw_Chars								\n\t"
		JEXPORT" impl_HALDraw_Line								\n\t"
		JEXPORT" impl_HALDraw_Rectangle							\n\t"
		JEXPORT" impl_HALDraw_Pixels							\n\t"
		JEXPORT" impl_HALSoundOpen								\n\t"
		JEXPORT" impl_HALSoundClose								\n\t"
		JEXPORT" impl_HALSoundRead								\n\t"
		JEXPORT" impl_HALSoundWrite								\n\t"
		JEXPORT" impl_HALSoundIoctl								\n\t"
		JEXPORT" impl_HALSoundInitialize						\n\t"
		JEXPORT" impl_HALSoundDispose							\n\t"
		JEXPORT" impl_dprintf									\n\t"
		JEXPORT" impl_HALDraw_GetSupportedDensity				\n\t"
		JEXPORT" impl_HALPlaySmf								\n\t"
	
	#ifndef SUPPORT_ZODIAC
	
		JEXPORT" impl_OEMReserved1								\n\t"		//Treo680: HALAccessSharedLibrary
		JEXPORT" impl_OEMReserved2								\n\t"		//Treo680: HALSupressDbgLockout
		JEXPORT" impl_OEMReserved3								\n\t"		
		JEXPORT" impl_OEMReserved4								\n\t"
		JEXPORT" impl_OEMReserved5								\n\t"
		JEXPORT" impl_OEMReserved6								\n\t"		//Treo 680: HALAttrGet
		JEXPORT" impl_OEMReserved7								\n\t"		//Treo 680: HALAttrSet
		JEXPORT" impl_HALDisplaySleep							\n\t"
		JEXPORT" impl_OEMReserved8								\n\t"		//Treo 680: HALIndicatorState
		JEXPORT" impl_OEMReserved9								\n\t"		//Treo 680: HALIoDir
		JEXPORT" impl_OEMReserved10								\n\t"		//Treo 680: HALIoSet
		JEXPORT" impl_OEMReserved11								\n\t"		//Treo 680:	HALIoGet
		JEXPORT" impl_OEMReserved12								\n\t"		//Treo 680:	HALIoIrqSetHandler
		JEXPORT" impl_OEMReserved13								\n\t"		//Treo 680:	HALIoIrqGetHandler
		JEXPORT" impl_OEMReserved14								\n\t"		//Treo 680:	HALIoIrqSetState
		JEXPORT" impl_OEMReserved15								\n\t"		//Treo 680:	HALIoIrqGetState
		JEXPORT" impl_OEMReserved16								\n\t"
		JEXPORT" impl_OEMReserved17								\n\t"		//Treo 680:	HALKeysPressed
		JEXPORT" impl_OEMReserved18								\n\t"		//Treo 680:	HALKeyEnableKey
		JEXPORT" impl_OEMReserved19								\n\t"		//Treo 680:	HALKeyChrCodeToKeyCode
		JEXPORT" impl_OEMReserved20								\n\t"		//Treo 680:	HALKeyKeyCodeToChrCode
		JEXPORT" impl_OEMReserved21								\n\t"		//Treo 680:	HALKeyLight
		JEXPORT" impl_OEMReserved22								\n\t"		//Treo 680:	HALKeyStop
		JEXPORT" impl_OEMReserved23								\n\t"		//Treo 680:	HsHALSoundExt
		JEXPORT" impl_OEMReserved24								\n\t"		//Treo 680:	DALRadioAttrGet
		JEXPORT" impl_OEMReserved25								\n\t"		//Treo 680:	DALRadioAttrSet
		JEXPORT" impl_OEMReserved26								\n\t"		//Treo 680:	HALAddressConvertVirtualToPhysical
		JEXPORT" impl_OEMReserved27								\n\t"		//Treo 680:	HALCrashLogGetLast
		JEXPORT" impl_OEMReserved28								\n\t"
		JEXPORT" impl_OEMReserved29								\n\t"
		JEXPORT" impl_OEMReserved30								\n\t"
		JEXPORT" impl_OEMReserved31								\n\t"		//Treo 680:	HALCrashTraceGetCrashId
		JEXPORT" impl_OEMReserved32								\n\t"
		JEXPORT" impl_HALRedrawInputArea						\n\t"
		
	#else	//zodiac
	
		JEXPORT" impl_OEMReserved1								\n\t"
		JEXPORT" impl_OEMReserved2								\n\t"
		JEXPORT" impl_OEMReserved3								\n\t"		
		JEXPORT" impl_OEMReserved4								\n\t"
		JEXPORT" impl_OEMReserved5								\n\t"
		JEXPORT" impl_OEMReserved6								\n\t"
		JEXPORT" impl_OEMReserved7								\n\t"
		JEXPORT" impl_HALDisplaySleep							\n\t"
		JEXPORT" impl_OEMReserved8								\n\t"
		JEXPORT" impl_OEMReserved9								\n\t"
		JEXPORT" impl_OEMReserved10								\n\t"
		JEXPORT" impl_OEMReserved11								\n\t"
		JEXPORT" impl_OEMReserved12								\n\t"
		JEXPORT" impl_OEMReserved13								\n\t"
		JEXPORT" impl_OEMReserved14								\n\t"
		JEXPORT" impl_OEMReserved15								\n\t"
		JEXPORT" impl_OEMReserved16								\n\t"
		JEXPORT" impl_OEMReserved17								\n\t"
		JEXPORT" impl_OEMReserved18								\n\t"
		JEXPORT" impl_OEMReserved19								\n\t"
		JEXPORT" impl_OEMReserved20								\n\t"
		JEXPORT" impl_OEMReserved21								\n\t"
		JEXPORT" impl_OEMReserved22								\n\t"
		JEXPORT" impl_OEMReserved23								\n\t"
		JEXPORT" impl_OEMReserved24								\n\t"
		JEXPORT" impl_OEMReserved25								\n\t"
		JEXPORT" impl_OEMReserved26								\n\t"
		JEXPORT" impl_OEMReserved27								\n\t"
		JEXPORT" impl_TwSetUserDispAreaBounds					\n\t"
		JEXPORT" impl_TwGetUserDispAreaBounds					\n\t"
		JEXPORT" impl_TwGetMicroSeconds							\n\t"
		JEXPORT" impl_OEMReserved31								\n\t"
		JEXPORT" impl_OEMReserved32								\n\t"
		JEXPORT" impl_TwUnknown3c0								\n\t"
		JEXPORT" impl_TwUnknown3c4								\n\t"
		JEXPORT" impl_TwUnknown3c8								\n\t"
		JEXPORT" impl_TwUnknown3cc								\n\t"
		JEXPORT" impl_TwUnknown3d0								\n\t"
		JEXPORT" impl_TwUnknown3d4								\n\t"
		JEXPORT" impl_TwUnknown3d8								\n\t"
		JEXPORT" impl_TwUnknown3dc								\n\t"
		JEXPORT" impl_TwUnknown3e0								\n\t"
		JEXPORT" impl_TwUnknown3e4								\n\t"
		JEXPORT" impl_TwUnknown3e8								\n\t"
		JEXPORT" impl_TwUnknown3ec								\n\t"
		JEXPORT" impl_TwUnknown3f0								\n\t"
		JEXPORT" impl_TwUnknown3f4								\n\t"
		JEXPORT" impl_TwUnknown3f8								\n\t"
		JEXPORT" impl_TwUnknown3fc								\n\t"
		JEXPORT" impl_TwUnknown400								\n\t"
		JEXPORT" impl_TwUnknown404								\n\t"
		JEXPORT" impl_TwUnknown408								\n\t"
		JEXPORT" impl_TwNavResetCalibration						\n\t"
		JEXPORT" impl_TwNavCalibrate							\n\t"
		JEXPORT" impl_TwInputOpen								\n\t"
		JEXPORT" impl_TwInputClose								\n\t"
		JEXPORT" impl_TwInputActivate							\n\t"
		JEXPORT" impl_TwInputDeactivate							\n\t"
		JEXPORT" impl_TwInputGetPeriod							\n\t"
		JEXPORT" impl_TwInputSetPeriod							\n\t"
		JEXPORT" impl_TwInputGetCapacity						\n\t"
		JEXPORT" impl_TwInputSetCapacity						\n\t"
		JEXPORT" impl_TwInputGetFormat							\n\t"
		JEXPORT" impl_TwInputSetFormat							\n\t"
		JEXPORT" impl_TwInputPeek								\n\t"
		JEXPORT" impl_TwInputRead								\n\t"
		JEXPORT" impl_TwInputPoll								\n\t"
		JEXPORT" impl_TwInputControl							\n\t"
		JEXPORT" impl_TwDeviceOpen								\n\t"
		JEXPORT" impl_TwDeviceClose								\n\t"
		JEXPORT" impl_TwDeviceRead								\n\t"
		JEXPORT" impl_TwDeviceWrite								\n\t"
		JEXPORT" impl_TwDeviceGetProperty						\n\t"
		JEXPORT" impl_TwDeviceSetProperty						\n\t"
		JEXPORT" impl_TwDeviceControl							\n\t"
		JEXPORT" impl_TwGfxOpen									\n\t"
		JEXPORT" impl_TwGfxClose								\n\t"
		JEXPORT" impl_TwGfxGetInfo								\n\t"
		JEXPORT" impl_TwGfxGetMemoryUsage						\n\t"
		JEXPORT" impl_TwGfxGetDisplaySurface					\n\t"
		JEXPORT" impl_TwGfxInVBlank								\n\t"
		JEXPORT" impl_TwGfxWaitForVBlank						\n\t"
		JEXPORT" impl_TwGfxAllocSurface							\n\t"
		JEXPORT" impl_TwGfxFreeSurface							\n\t"
		JEXPORT" impl_TwGfxSetClip								\n\t"
		JEXPORT" impl_TwGfxGetClip								\n\t"
		JEXPORT" impl_TwGfxGetSurfaceInfo						\n\t"
		JEXPORT" impl_TwGfxLockSurface							\n\t"
		JEXPORT" impl_TwGfxUnlockSurface						\n\t"
		JEXPORT" impl_TwGfxReadSurface							\n\t"
		JEXPORT" impl_TwGfxWriteSurface							\n\t"
		JEXPORT" impl_TwGfxIsSurfaceReady						\n\t"
		JEXPORT" impl_TwGfxBitBlt								\n\t"
		JEXPORT" impl_TwGfxTransformBlt							\n\t"
		JEXPORT" impl_TwGfxDrawPoints							\n\t"
		JEXPORT" impl_TwGfxDrawColorPoints						\n\t"
		JEXPORT" impl_TwGfxDrawLines							\n\t"
		JEXPORT" impl_TwGfxDrawLineSegments						\n\t"
		JEXPORT" impl_TwGfxDrawRect								\n\t"
		JEXPORT" impl_TwGfxFillRect								\n\t"
		JEXPORT" impl_TwGfxDrawSpans							\n\t"
		JEXPORT" impl_TwGfxDrawBitmap							\n\t"
		JEXPORT" impl_TwGfxGetPalmDisplaySurface				\n\t"
		JEXPORT" impl_TwGfxWriteSurfaceRegion					\n\t"
		JEXPORT" impl_TwGfxReadSurfaceRegion					\n\t"
		JEXPORT" impl_TwGfxBlendBlt								\n\t"
		JEXPORT" impl_TwGfxStretchBlt							\n\t"
		JEXPORT" impl_TwGfxTileBlt								\n\t"
		JEXPORT" impl_TwGfxMaskBlendBlt							\n\t"
		JEXPORT" impl_TwGfxMaskBlt								\n\t"
		JEXPORT" impl_TwGfxTransparentBlt						\n\t"
		JEXPORT" impl_TwGfxAsyncBlt								\n\t"
		JEXPORT" impl_TwGfxStretchBlt2							\n\t"
		JEXPORT" impl_TwUnknown500								\n\t"
		JEXPORT" impl_TwUnknown504								\n\t"
		JEXPORT" impl_TwUnknown508								\n\t"
		JEXPORT" impl_TwUnknown50c								\n\t"
		JEXPORT" impl_TwUnknown510								\n\t"
		JEXPORT" impl_TwUnknown514								\n\t"
		JEXPORT" impl_TwUnknown518								\n\t"
		JEXPORT" impl_TwUnknown51c								\n\t"
		JEXPORT" impl_TwUnknown520								\n\t"
		JEXPORT" impl_TwUnknown524								\n\t"
		JEXPORT" impl_TwUnknown528								\n\t"
		JEXPORT" impl_TwUnknown52c								\n\t"
		JEXPORT" impl_TwUnknown530								\n\t"
		JEXPORT" impl_TwUnknown534								\n\t"
		JEXPORT" impl_TwUnknown538								\n\t"
		JEXPORT" impl_TwUnknown53c								\n\t"
		JEXPORT" impl_TwUnknown540								\n\t"
		JEXPORT" impl_TwUnknown544								\n\t"
		JEXPORT" impl_TwUnknown548								\n\t"
		JEXPORT" impl_TwUnknown54c								\n\t"
		JEXPORT" impl_TwUnknown550								\n\t"
		JEXPORT" impl_TwHALSoundNumActiveStreams				\n\t"
		JEXPORT" impl_TwUnknown558								\n\t"
		JEXPORT" impl_TwUnknown55c								\n\t"
		JEXPORT" impl_TwUnknown560								\n\t"
		JEXPORT" impl_TwSecGetFunctions_ARM						\n\t"
		JEXPORT" impl_TwSecVerifyCurrentAppEx					\n\t"
		JEXPORT" impl_TwSecCheckForDevAccessApp					\n\t"
		JEXPORT" impl_TwSecFailureReset							\n\t"
		JEXPORT" impl_TwSecGetFunctions_68k						\n\t"
		JEXPORT" impl_TwSecVerifyDatabase						\n\t"
		JEXPORT" impl_TwSecDoesAppHaveSigResource				\n\t"
		JEXPORT" impl_TwUnknown580								\n\t"
		JEXPORT" impl_TwUnknown584								\n\t"
		JEXPORT" impl_TwUnknown588								\n\t"
		JEXPORT" impl_TwUnknown58c								\n\t"
		JEXPORT" impl_TwUnknown590								\n\t"
		JEXPORT" impl_TwUnknown594								\n\t"
		JEXPORT" impl_TwUnknown598								\n\t"
		JEXPORT" impl_TwUnknown59c								\n\t"
		JEXPORT" impl_TwSetApiCalledFromAddr					\n\t"
		JEXPORT" impl_TwGetApiCalledFromAddr					\n\t"
		JEXPORT" impl_TwGetHwrResetReason						\n\t"
		JEXPORT" impl_TwUnknown5ac								\n\t"
		JEXPORT" impl_TwUnknown5b0								\n\t"
		JEXPORT" impl_TwUnknown5b4								\n\t"
		JEXPORT" impl_TwUnknown5b8								\n\t"
		JEXPORT" impl_TwDeviceRegister							\n\t"
		JEXPORT" impl_TwDeviceUnregister						\n\t"
		JEXPORT" impl_TwDisableHwWatchdogTimer					\n\t"
		JEXPORT" impl_TwSystemSelfVerifyNow						\n\t"
		JEXPORT" impl_TwReadTombstoneStruct						\n\t"
		JEXPORT" impl_TwWriteRombstoneStruct					\n\t"
		JEXPORT" impl_TwSetCurRunningDb							\n\t"
		
	#endif
	
	
	#if defined(BUILD_FOR_THUMB_1) && !defined(HAVE_v8M_BASE)
		"___entry_from_m0:							\n\t"
		"	mov lr, r12								\n\t"		//restore lr to proper place
		//fallthrough
	#endif
	
		"___entry:									\n\t"
	#ifdef MACH_TYPE_VIRTUAL
	
			// on virtual HW we need to restore SP on return, param is hyper pointer and it is always >= 0x8000 so we check for that
			"	CMP   R0, #0x8000					\n\t"
			"	BLE   not_first_entry				\n\t"
			"	MOV   R3, SP						\n\t"
			"	LDR   SP, =__stack_top				\n\t"
			"	STMFD SP!, {R3, LR}					\n\t"
			"	mov   r1, r0						\n\t"	//hypercbk
			"	ldr   r0, =0x10000					\n\t"	//impossible cmd to signal first boot
			"	BL    __entry						\n\t"
			"	MOV   R3, SP						\n\t"
			"	LDMFD R3, {r3, LR}					\n\t"
			"	MOV	  SP, R3						\n\t"
			"	bx    lr							\n\t"
			
			"not_first_entry:						\n\t"
			"	LDR   r3, =__entry					\n\t"
			"	bx    r3							\n\t"
		
	#else
	
		#ifndef BUILDING_FOR_BIG_ARM	//cortex
	
			//on real HW, the initial SP is set to 0xff000000 to tell us this is initial entry
			//this code should work on v6m please
			"	LDR   r3, =0xff000000				\n\t"
			"	CMP   SP, r3						\n\t"
			"	BNE   not_first_entry				\n\t"
		
		#else
			
			"	MRS   r3, CPSR						\n\t"	//first entry is in svc mode, all others we expect in sys or usr
			"	AND   r3, #0x1f						\n\t"
			"	CMP   r3, #0x13						\n\t"
			"	BNE   not_first_entry				\n\t"
			
		#endif
		
			"first_entry:							\n\t"
			"	LDR   r3, =__stack_top				\n\t"
			"	MOV   sp, r3						\n\t"
			
		//begin early setup code
			"	MOV   r4, r0						\n\t"
			"	BL    mpuEarlyInit					\n\t"	//on legacy, after this we're in MMU land
			"	MOVS  r0, %[earlyInitStageNum]		\n\t"
			"	MOVS  r1, #0						\n\t"
			"	BL    machInit						\n\t"
			"	MOV   r0, r4						\n\t"
		//end early setup code
			"	ldr   r0, =0x10000					\n\t"	//impossible cmd to signal first boot
		
			"not_first_entry:						\n\t"
			
		#if defined(BUILD_FOR_THUMB_1) && !defined(HAVE_v8M_BASE)	//no chance at efficient PIC code, but not needed
			"	LDR r3, =__entry					\n\t"
			"	BX  r3								\n\t"
		#else
			
			"	B   __entry							\n\t"
			
		#endif
		
	#endif
	
		".ltorg										\n\t"
	
		
	#if defined(BUILD_FOR_THUMB_1) && !defined(HAVE_v8M_BASE)
	
		"99:									\n\t"				//trampoline for these ones
		"	str  r0, [sp, #4]					\n\t"
		"	pop  {r0, pc}						\n\t"
		
		"m0_trampoline impl_KALMutexDelete					\n\t"
		"m0_trampoline impl_KALMutexRelease					\n\t"
		"m0_trampoline impl_KALMutexReserve					\n\t"
		"m0_trampoline impl_KALMutexGetInfo					\n\t"
		"m0_trampoline impl_KALSemaphoreCreate					\n\t"
		"m0_trampoline impl_KALSemaphoreDelete					\n\t"
		"m0_trampoline impl_KALSemaphoreSignal					\n\t"
		"m0_trampoline impl_KALSemaphoreWait					\n\t"
		"m0_trampoline impl_KALSemaphoreGetInfo					\n\t"
		"m0_trampoline impl_KALTaskCreate					\n\t"
		"m0_trampoline impl_KALTaskDelay					\n\t"
		"m0_trampoline impl_KALTaskDelete					\n\t"
		"m0_trampoline impl_KALTaskGetCurrentID					\n\t"
		"m0_trampoline impl_KALTaskGetInfo					\n\t"
		"m0_trampoline impl_KALTaskResume					\n\t"
		"m0_trampoline impl_KALTaskSuspend					\n\t"
		"m0_trampoline impl_KALTaskStart					\n\t"
		"m0_trampoline impl_KALTaskSwitching					\n\t"
		"m0_trampoline impl_KALTaskWait					\n\t"
		"m0_trampoline impl_KALTaskWaitClr					\n\t"
		"m0_trampoline impl_KALTaskWake					\n\t"
		"m0_trampoline impl_KALTaskExit					\n\t"
		"m0_trampoline impl_KALTimerCreate					\n\t"
		"m0_trampoline impl_KALTimerDelete					\n\t"
		"m0_trampoline impl_KALTimerSet					\n\t"
		"m0_trampoline impl_KALTimerGetInfo					\n\t"
		"m0_trampoline impl_RALCallWithNewStack					\n\t"
		"m0_trampoline impl_RALGetEntryAddresses					\n\t"
		"m0_trampoline impl_RALGetModuleInfo					\n\t"
		"m0_trampoline impl_RALGetStaticBase					\n\t"
		"m0_trampoline impl_RALLinkClient					\n\t"
		"m0_trampoline impl_RALLoadModule					\n\t"
		"m0_trampoline impl_RALPatchEntry					\n\t"
		"m0_trampoline impl_RALSetA5					\n\t"
		"m0_trampoline impl_RALUnloadModule					\n\t"
		"m0_trampoline impl_RALUnloadNext					\n\t"
		"m0_trampoline impl_DALSetDbgLockout					\n\t"
		"m0_trampoline impl_HALKeyGetDoubleTapDelay					\n\t"
		"m0_trampoline impl_HALKeySetDoubleTapDelay					\n\t"
		"m0_trampoline impl_HALInvalidateICache					\n\t"
		"m0_trampoline impl_HALHandleReset					\n\t"
		"m0_trampoline impl_HALTable02F0					\n\t"
		"m0_trampoline impl_HALTable02F4					\n\t"
		"m0_trampoline impl_HALDraw_Bitmap					\n\t"
		"m0_trampoline impl_HALDraw_FindIndexes					\n\t"
		"m0_trampoline impl_HALDraw_GetPixel					\n\t"
		"m0_trampoline impl_HALDraw_Chars					\n\t"
		"m0_trampoline impl_HALDraw_Line					\n\t"
		"m0_trampoline impl_HALDraw_Rectangle					\n\t"
		"m0_trampoline impl_HALDraw_Pixels					\n\t"
		"m0_trampoline impl_HALSoundOpen					\n\t"
		"m0_trampoline impl_HALSoundClose					\n\t"
		"m0_trampoline impl_HALSoundRead					\n\t"
		"m0_trampoline impl_HALSoundWrite					\n\t"
		"m0_trampoline impl_HALSoundIoctl					\n\t"
		"m0_trampoline impl_HALSoundInitialize					\n\t"
		"m0_trampoline impl_HALSoundDispose					\n\t"
		"m0_trampoline impl_dprintf					\n\t"
		"m0_trampoline impl_HALDraw_GetSupportedDensity					\n\t"
		"m0_trampoline impl_HALPlaySmf					\n\t"
		".ltorg		\n\t"
		
		
		#ifndef SUPPORT_ZODIAC
	
			"m0_trampoline impl_OEMReserved1								\n\t"		//Treo680: HALAccessSharedLibrary
			"m0_trampoline impl_OEMReserved2								\n\t"		//Treo680: HALSupressDbgLockout
			"m0_trampoline impl_OEMReserved3								\n\t"		
			"m0_trampoline impl_OEMReserved4								\n\t"
			"m0_trampoline impl_OEMReserved5								\n\t"
			"m0_trampoline impl_OEMReserved6								\n\t"		//Treo 680: HALAttrGet
			"m0_trampoline impl_OEMReserved7								\n\t"		//Treo 680: HALAttrSet
			"m0_trampoline impl_HALDisplaySleep								\n\t"
			"m0_trampoline impl_OEMReserved8								\n\t"		//Treo 680: HALIndicatorState
			"m0_trampoline impl_OEMReserved9								\n\t"		//Treo 680: HALIoDir
			"m0_trampoline impl_OEMReserved10								\n\t"		//Treo 680: HALIoSet
			"m0_trampoline impl_OEMReserved11								\n\t"		//Treo 680:	HALIoGet
			"m0_trampoline impl_OEMReserved12								\n\t"		//Treo 680:	HALIoIrqSetHandler
			"m0_trampoline impl_OEMReserved13								\n\t"		//Treo 680:	HALIoIrqGetHandler
			"m0_trampoline impl_OEMReserved14								\n\t"		//Treo 680:	HALIoIrqSetState
			"m0_trampoline impl_OEMReserved15								\n\t"		//Treo 680:	HALIoIrqGetState
			"m0_trampoline impl_OEMReserved16								\n\t"
			"m0_trampoline impl_OEMReserved17								\n\t"		//Treo 680:	HALKeysPressed
			"m0_trampoline impl_OEMReserved18								\n\t"		//Treo 680:	HALKeyEnableKey
			"m0_trampoline impl_OEMReserved19								\n\t"		//Treo 680:	HALKeyChrCodeToKeyCode
			"m0_trampoline impl_OEMReserved20								\n\t"		//Treo 680:	HALKeyKeyCodeToChrCode
			"m0_trampoline impl_OEMReserved21								\n\t"		//Treo 680:	HALKeyLight
			"m0_trampoline impl_OEMReserved22								\n\t"		//Treo 680:	HALKeyStop
			"m0_trampoline impl_OEMReserved23								\n\t"		//Treo 680:	HsHALSoundExt
			"m0_trampoline impl_OEMReserved24								\n\t"		//Treo 680:	DALRadioAttrGet
			"m0_trampoline impl_OEMReserved25								\n\t"		//Treo 680:	DALRadioAttrSet
			"m0_trampoline impl_OEMReserved26								\n\t"		//Treo 680:	HALAddressConvertVirtualToPhysical
			"m0_trampoline impl_OEMReserved27								\n\t"		//Treo 680:	HALCrashLogGetLast
			"m0_trampoline impl_OEMReserved28								\n\t"
			"m0_trampoline impl_OEMReserved29								\n\t"
			"m0_trampoline impl_OEMReserved30								\n\t"
			"m0_trampoline impl_OEMReserved31								\n\t"		//Treo 680:	HALCrashTraceGetCrashId
			"m0_trampoline impl_OEMReserved32								\n\t"
			"m0_trampoline impl_HALRedrawInputArea							\n\t"
			".ltorg		\n\t"
			
		#else	//zodiac
		
			"m0_trampoline impl_OEMReserved1								\n\t"
			"m0_trampoline impl_OEMReserved2								\n\t"
			"m0_trampoline impl_OEMReserved3								\n\t"		
			"m0_trampoline impl_OEMReserved4								\n\t"
			"m0_trampoline impl_OEMReserved5								\n\t"
			"m0_trampoline impl_OEMReserved6								\n\t"
			"m0_trampoline impl_OEMReserved7								\n\t"
			"m0_trampoline impl_HALDisplaySleep								\n\t"
			"m0_trampoline impl_OEMReserved8								\n\t"
			"m0_trampoline impl_OEMReserved9								\n\t"
			"m0_trampoline impl_OEMReserved10								\n\t"
			"m0_trampoline impl_OEMReserved11								\n\t"
			"m0_trampoline impl_OEMReserved12								\n\t"
			"m0_trampoline impl_OEMReserved13								\n\t"
			"m0_trampoline impl_OEMReserved14								\n\t"
			"m0_trampoline impl_OEMReserved15								\n\t"
			"m0_trampoline impl_OEMReserved16								\n\t"
			"m0_trampoline impl_OEMReserved17								\n\t"
			"m0_trampoline impl_OEMReserved18								\n\t"
			"m0_trampoline impl_OEMReserved19								\n\t"
			"m0_trampoline impl_OEMReserved20								\n\t"
			"m0_trampoline impl_OEMReserved21								\n\t"
			"m0_trampoline impl_OEMReserved22								\n\t"
			"m0_trampoline impl_OEMReserved23								\n\t"
			"m0_trampoline impl_OEMReserved24								\n\t"
			"m0_trampoline impl_OEMReserved25								\n\t"
			"m0_trampoline impl_OEMReserved26								\n\t"
			"m0_trampoline impl_OEMReserved27								\n\t"
			"m0_trampoline impl_TwSetUserDispAreaBounds						\n\t"
			"m0_trampoline impl_TwGetUserDispAreaBounds						\n\t"
			"m0_trampoline impl_TwGetMicroSeconds							\n\t"
			"m0_trampoline impl_OEMReserved31								\n\t"
			"m0_trampoline impl_OEMReserved32								\n\t"
			"m0_trampoline impl_TwUnknown3c0								\n\t"
			"m0_trampoline impl_TwUnknown3c4								\n\t"
			"m0_trampoline impl_TwUnknown3c8								\n\t"
			"m0_trampoline impl_TwUnknown3cc								\n\t"
			"m0_trampoline impl_TwUnknown3d0								\n\t"
			"m0_trampoline impl_TwUnknown3d4								\n\t"
			"m0_trampoline impl_TwUnknown3d8								\n\t"
			"m0_trampoline impl_TwUnknown3dc								\n\t"
			"m0_trampoline impl_TwUnknown3e0								\n\t"
			"m0_trampoline impl_TwUnknown3e4								\n\t"
			"m0_trampoline impl_TwUnknown3e8								\n\t"
			"m0_trampoline impl_TwUnknown3ec								\n\t"
			"m0_trampoline impl_TwUnknown3f0								\n\t"
			"m0_trampoline impl_TwUnknown3f4								\n\t"
			"m0_trampoline impl_TwUnknown3f8								\n\t"
			"m0_trampoline impl_TwUnknown3fc								\n\t"
			"m0_trampoline impl_TwUnknown400								\n\t"
			"m0_trampoline impl_TwUnknown404								\n\t"
			"m0_trampoline impl_TwUnknown408								\n\t"
			"m0_trampoline impl_TwNavResetCalibration						\n\t"
			"m0_trampoline impl_TwNavCalibrate								\n\t"
			"m0_trampoline impl_TwInputOpen									\n\t"
			"m0_trampoline impl_TwInputClose								\n\t"
			"m0_trampoline impl_TwInputActivate								\n\t"
			"m0_trampoline impl_TwInputDeactivate							\n\t"
			"m0_trampoline impl_TwInputGetPeriod							\n\t"
			"m0_trampoline impl_TwInputSetPeriod							\n\t"
			"m0_trampoline impl_TwInputGetCapacity							\n\t"
			"m0_trampoline impl_TwInputSetCapacity							\n\t"
			"m0_trampoline impl_TwInputGetFormat							\n\t"
			"m0_trampoline impl_TwInputSetFormat							\n\t"
			"m0_trampoline impl_TwInputPeek									\n\t"
			"m0_trampoline impl_TwInputRead									\n\t"
			"m0_trampoline impl_TwInputPoll									\n\t"
			"m0_trampoline impl_TwInputControl								\n\t"
			"m0_trampoline impl_TwDeviceOpen								\n\t"
			"m0_trampoline impl_TwDeviceClose								\n\t"
			"m0_trampoline impl_TwDeviceRead								\n\t"
			"m0_trampoline impl_TwDeviceWrite								\n\t"
			"m0_trampoline impl_TwDeviceGetProperty							\n\t"
			"m0_trampoline impl_TwDeviceSetProperty							\n\t"
			"m0_trampoline impl_TwDeviceControl								\n\t"
			"m0_trampoline impl_TwGfxOpen									\n\t"
			"m0_trampoline impl_TwGfxClose									\n\t"
			"m0_trampoline impl_TwGfxGetInfo								\n\t"
			"m0_trampoline impl_TwGfxGetMemoryUsage							\n\t"
			"m0_trampoline impl_TwGfxGetDisplaySurface						\n\t"
			"m0_trampoline impl_TwGfxInVBlank								\n\t"
			"m0_trampoline impl_TwGfxWaitForVBlank							\n\t"
			"m0_trampoline impl_TwGfxAllocSurface							\n\t"
			"m0_trampoline impl_TwGfxFreeSurface							\n\t"
			"m0_trampoline impl_TwGfxSetClip								\n\t"
			"m0_trampoline impl_TwGfxGetClip								\n\t"
			"m0_trampoline impl_TwGfxGetSurfaceInfo							\n\t"
			"m0_trampoline impl_TwGfxLockSurface							\n\t"
			"m0_trampoline impl_TwGfxUnlockSurface							\n\t"
			"m0_trampoline impl_TwGfxReadSurface							\n\t"
			"m0_trampoline impl_TwGfxWriteSurface							\n\t"
			"m0_trampoline impl_TwGfxIsSurfaceReady							\n\t"
			"m0_trampoline impl_TwGfxBitBlt									\n\t"
			"m0_trampoline impl_TwGfxTransformBlt							\n\t"
			"m0_trampoline impl_TwGfxDrawPoints								\n\t"
			"m0_trampoline impl_TwGfxDrawColorPoints						\n\t"
			"m0_trampoline impl_TwGfxDrawLines								\n\t"
			"m0_trampoline impl_TwGfxDrawLineSegments						\n\t"
			"m0_trampoline impl_TwGfxDrawRect								\n\t"
			"m0_trampoline impl_TwGfxFillRect								\n\t"
			"m0_trampoline impl_TwGfxDrawSpans								\n\t"
			"m0_trampoline impl_TwGfxDrawBitmap								\n\t"
			"m0_trampoline impl_TwGfxGetPalmDisplaySurface					\n\t"
			"m0_trampoline impl_TwGfxWriteSurfaceRegion						\n\t"
			"m0_trampoline impl_TwGfxReadSurfaceRegion						\n\t"
			"m0_trampoline impl_TwGfxBlendBlt								\n\t"
			"m0_trampoline impl_TwGfxStretchBlt								\n\t"
			"m0_trampoline impl_TwGfxTileBlt								\n\t"
			"m0_trampoline impl_TwGfxMaskBlendBlt							\n\t"
			"m0_trampoline impl_TwGfxMaskBlt								\n\t"
			"m0_trampoline impl_TwGfxTransparentBlt							\n\t"
			"m0_trampoline impl_TwGfxAsyncBlt								\n\t"
			"m0_trampoline impl_TwGfxStretchBlt2							\n\t"
			"m0_trampoline impl_TwUnknown500								\n\t"
			"m0_trampoline impl_TwUnknown504								\n\t"
			"m0_trampoline impl_TwUnknown508								\n\t"
			"m0_trampoline impl_TwUnknown50c								\n\t"
			"m0_trampoline impl_TwUnknown510								\n\t"
			"m0_trampoline impl_TwUnknown514								\n\t"
			"m0_trampoline impl_TwUnknown518								\n\t"
			"m0_trampoline impl_TwUnknown51c								\n\t"
			"m0_trampoline impl_TwUnknown520								\n\t"
			"m0_trampoline impl_TwUnknown524								\n\t"
			"m0_trampoline impl_TwUnknown528								\n\t"
			"m0_trampoline impl_TwUnknown52c								\n\t"
			"m0_trampoline impl_TwUnknown530								\n\t"
			"m0_trampoline impl_TwUnknown534								\n\t"
			"m0_trampoline impl_TwUnknown538								\n\t"
			"m0_trampoline impl_TwUnknown53c								\n\t"
			"m0_trampoline impl_TwUnknown540								\n\t"
			"m0_trampoline impl_TwUnknown544								\n\t"
			"m0_trampoline impl_TwUnknown548								\n\t"
			"m0_trampoline impl_TwUnknown54c								\n\t"
			"m0_trampoline impl_TwUnknown550								\n\t"
			"m0_trampoline impl_TwHALSoundNumActiveStreams					\n\t"
			"m0_trampoline impl_TwUnknown558								\n\t"
			"m0_trampoline impl_TwUnknown55c								\n\t"
			"m0_trampoline impl_TwUnknown560								\n\t"
			"m0_trampoline impl_TwSecGetFunctions_ARM						\n\t"
			"m0_trampoline impl_TwSecVerifyCurrentAppEx						\n\t"
			"m0_trampoline impl_TwSecCheckForDevAccessApp					\n\t"
			"m0_trampoline impl_TwSecFailureReset							\n\t"
			"m0_trampoline impl_TwSecGetFunctions_68k						\n\t"
			"m0_trampoline impl_TwSecVerifyDatabase							\n\t"
			"m0_trampoline impl_TwSecDoesAppHaveSigResource					\n\t"
			"m0_trampoline impl_TwUnknown580								\n\t"
			"m0_trampoline impl_TwUnknown584								\n\t"
			"m0_trampoline impl_TwUnknown588								\n\t"
			"m0_trampoline impl_TwUnknown58c								\n\t"
			"m0_trampoline impl_TwUnknown590								\n\t"
			"m0_trampoline impl_TwUnknown594								\n\t"
			"m0_trampoline impl_TwUnknown598								\n\t"
			"m0_trampoline impl_TwUnknown59c								\n\t"
			"m0_trampoline impl_TwSetApiCalledFromAddr						\n\t"
			"m0_trampoline impl_TwGetApiCalledFromAddr						\n\t"
			"m0_trampoline impl_TwGetHwrResetReason							\n\t"
			"m0_trampoline impl_TwUnknown5ac								\n\t"
			"m0_trampoline impl_TwUnknown5b0								\n\t"
			"m0_trampoline impl_TwUnknown5b4								\n\t"
			"m0_trampoline impl_TwUnknown5b8								\n\t"
			"m0_trampoline impl_TwDeviceRegister							\n\t"
			"m0_trampoline impl_TwDeviceUnregister							\n\t"
			"m0_trampoline impl_TwDisableHwWatchdogTimer					\n\t"
			"m0_trampoline impl_TwSystemSelfVerifyNow						\n\t"
			"m0_trampoline impl_TwReadTombstoneStruct						\n\t"
			"m0_trampoline impl_TwWriteRombstoneStruct						\n\t"
			"m0_trampoline impl_TwSetCurRunningDb							\n\t"
			".ltorg		\n\t"
			
		#endif
		
		
		
	#endif
	
		:
		:[earlyInitStageNum] "I"(STAGE_INIT_EARLY)
	);
}


#ifdef NO_CRT_MEMCPY

	//nothing
	
#elif defined(BUILD_FOR_THUMB_1)
	//we need our own memcpy because GCC has no good one for v6m
	//copy may be forward, in reverse, or partially both. this is ok since memcpy never allows overlap
	
	void* __attribute__((naked)) memcpy(void* dstP, const void* srcP, size_t sz)
	{
		asm volatile(
			".syntax unified					\n\t"
			"	mov   r12, r0					\n\t"
			//see if they are aligned
			"	mov   r3, r0					\n\t"
			"	orrs  r3, r1					\n\t"
			"	lsls  r3, #30					\n\t"
			"	bne   bytewise					\n\t"
			"wordwise:							\n\t"
			"	subs  r2, #4					\n\t"
			"	bmi   words_over				\n\t"
			"	ldmia r1!, {r3}					\n\t"
			"	stmia r0!, {r3}					\n\t"
			"	bne   wordwise					\n\t"
			"out:								\n\t"
			"	mov   r12, r0					\n\t"
			"	bx    lr						\n\t"
			"words_over:						\n\t"
			"	adds  r2, #4					\n\t"
			"bytewise:							\n\t"
			"	subs  r2, #1					\n\t"
			"	bmi   out						\n\t"
			"	ldrb  r3, [r1,r2]				\n\t"
			"	strb  r3, [r0,r2]				\n\t"
			"	b     bytewise					\n\t"
		);
	}
	
#elif defined(BUILDING_FOR_BIG_ARM)				//ARM

	void* __attribute__((naked)) memcpy(void* dstP, const void* srcP, size_t sz)
	{
		asm volatile(
			"											\n\t"
			"		STMFD		SP!, {R0,R4,R5,LR}		\n\t"
			"		ORR		R3, R0,	R1		\n\t"
			"		TST		R3, #3		\n\t"
			"		MOVEQ		R3, #0x200		\n\t"
			"		MOVNE		R3, #0x80		\n\t"
			"		CMP		R2, R3		\n\t"
			"		BHI		loc_841082A8		\n\t"
			"		CMP		R2, #8		\n\t"
			"		BLT		loc_84108250		\n\t"
			"		ANDS		R3, R0,	#3		\n\t"
			"		BEQ		loc_84107F68		\n\t"
			"		RSB		R3, R3,	#4		\n\t"
			"		LDRB		R4, [R1],#1		\n\t"
			"		CMP		R3, #2		\n\t"
			"		STRB		R4, [R0],#1		\n\t"
			"		LDRGEB		R5, [R1],#1		\n\t"
			"		LDRGTB		R4, [R1],#1		\n\t"
			"		SUB		R2, R2,	R3		\n\t"
			"		STRGEB		R5, [R0],#1		\n\t"
			"		STRGTB		R4, [R0],#1		\n\t"
			"											\n\t"
			"loc_84107F68:		\n\t"
			"		TST		R1, #1		\n\t"
			"		BNE		loc_841080B0		\n\t"
			"		TST		R1, #2		\n\t"
			"		BNE		loc_84107FEC		\n\t"
			"		SUBS		R2, R2,	#0x20		\n\t"
			"		BLT		loc_84107F98		\n\t"
			"											\n\t"
			"loc_84107F80:		\n\t"
			"		LDMIA		R1!, {R3-R5,LR}		\n\t"
			"		STMIA		R0!, {R3-R5,LR}		\n\t"
			"		LDMIA		R1!, {R3-R5,LR}		\n\t"
			"		SUBS		R2, R2,	#0x20		\n\t"
			"		STMIA		R0!, {R3-R5,LR}		\n\t"
			"		BGE		loc_84107F80		\n\t"
			"											\n\t"
			"loc_84107F98:		\n\t"
			"		ADDS		R2, R2,	#0x10		\n\t"
			"		LDMGEIA		R1!, {R3-R5,LR}		\n\t"
			"		STMGEIA		R0!, {R3-R5,LR}		\n\t"
			"		BEQ		locret_84107FE8		\n\t"
			"		SUBGTS		R2, R2,	#0x10		\n\t"
			"		ADDS		R2, R2,	#8		\n\t"
			"		LDMGEIA		R1!, {R3,R4}		\n\t"
			"		SUBGE		R2, R2,	#8		\n\t"
			"		STMGEIA		R0!, {R3,R4}		\n\t"
			"		ADDS		R2, R2,	#4		\n\t"
			"		LDRGE		R3, [R1],#4		\n\t"
			"		STRGE		R3, [R0],#4		\n\t"
			"		ADDLTS		R2, R2,	#4		\n\t"
			"		BEQ		locret_84107FE8		\n\t"
			"		LDR		R3, [R1],#4		\n\t"
			"		CMP		R2, #2		\n\t"
			"		STRGEH		R3, [R0],#2		\n\t"
			"		STRLTB		R3, [R0],#1		\n\t"
			"		MOVGT		R3, R3,LSR#16		\n\t"
			"		STRGTB		R3, [R0],#1		\n\t"
			"											\n\t"
			"locret_84107FE8:		\n\t"
			#ifdef HAVE_ARM_v5
				"		LDMFD		SP!, {R0,R4,R5,PC}		\n\t"
			#else
				"		LDMFD		SP!, {R0,R4,R5,LR}		\n\t"
				"		BX			LR						\n\t"
			#endif
			"											\n\t"
			"											\n\t"
			"loc_84107FEC:		\n\t"
			"		LDRH		R3, [R1],#2		\n\t"
			"		SUBS		R2, R2,	#0x20		\n\t"
			"		BLT		loc_84108050		\n\t"
			"											\n\t"
			"loc_84107FF8:		\n\t"
			"		LDMIA		R1!, {R4,R5,R12,LR}		\n\t"
			"		ORR		R3, R3,	R4,LSL#16		\n\t"
			"		MOV		R4, R4,LSR#16		\n\t"
			"		ORR		R4, R4,	R5,LSL#16		\n\t"
			"		MOV		R5, R5,LSR#16		\n\t"
			"		ORR		R5, R5,	R12,LSL#16		\n\t"
			"		MOV		R12, R12,LSR#16		\n\t"
			"		ORR		R12, R12, LR,LSL#16		\n\t"
			"		STMIA		R0!, {R3-R5,R12}		\n\t"
			"		MOV		R3, LR,LSR#16		\n\t"
			"		LDMIA		R1!, {R4,R5,R12,LR}		\n\t"
			"		ORR		R3, R3,	R4,LSL#16		\n\t"
			"		MOV		R4, R4,LSR#16		\n\t"
			"		ORR		R4, R4,	R5,LSL#16		\n\t"
			"		MOV		R5, R5,LSR#16		\n\t"
			"		ORR		R5, R5,	R12,LSL#16		\n\t"
			"		MOV		R12, R12,LSR#16		\n\t"
			"		ORR		R12, R12, LR,LSL#16		\n\t"
			"		STMIA		R0!, {R3-R5,R12}		\n\t"
			"		SUBS		R2, R2,	#0x20		\n\t"
			"		MOV		R3, LR,LSR#16		\n\t"
			"		BGE		loc_84107FF8		\n\t"
			"											\n\t"
			"loc_84108050:		\n\t"
			"		ADDS		R2, R2,	#0x18		\n\t"
			"		BLT		loc_84108078		\n\t"
			"											\n\t"
			"loc_84108058:		\n\t"
			"		LDMIA		R1!, {R4,R5}		\n\t"
			"		ORR		R3, R3,	R4,LSL#16		\n\t"
			"		MOV		R4, R4,LSR#16		\n\t"
			"		ORR		R4, R4,	R5,LSL#16		\n\t"
			"		STMIA		R0!, {R3,R4}		\n\t"
			"		SUBS		R2, R2,	#8		\n\t"
			"		MOV		R3, R5,LSR#16		\n\t"
			"		BGE		loc_84108058		\n\t"
			"											\n\t"
			"loc_84108078:		\n\t"
			"		ADDS		R2, R2,	#4		\n\t"
			"		BLT		loc_84108090		\n\t"
			"		LDR		R4, [R1],#4		\n\t"
			"		ORR		R3, R3,	R4,LSL#16		\n\t"
			"		STR		R3, [R0],#4		\n\t"
			"		MOV		R3, R4,LSR#16		\n\t"
			"											\n\t"
			"loc_84108090:		\n\t"
			"		ADDLTS		R2, R2,	#4		\n\t"
			"		BEQ		locret_841080AC		\n\t"
			"		CMP		R2, #2		\n\t"
			"		STRLTB		R3, [R0],#1		\n\t"
			"		LDRGTB		R4, [R1],#1		\n\t"
			"		STRGEH		R3, [R0],#2		\n\t"
			"		STRGTB		R4, [R0],#1		\n\t"
			"											\n\t"
			"locret_841080AC:		\n\t"
			#ifdef HAVE_ARM_v5
				"		LDMFD		SP!, {R0,R4,R5,PC}		\n\t"
			#else
				"		LDMFD		SP!, {R0,R4,R5,LR}		\n\t"
				"		BX			LR						\n\t"
			#endif
			"											\n\t"
			"											\n\t"
			"loc_841080B0:		\n\t"
			"		TST		R1, #2		\n\t"
			"		BEQ		loc_84108180		\n\t"
			"		LDRB		R3, [R1],#1		\n\t"
			"		SUBS		R2, R2,	#0x20		\n\t"
			"		BLT		loc_8410811C		\n\t"
			"											\n\t"
			"loc_841080C4:		\n\t"
			"		LDMIA		R1!, {R4,R5,R12,LR}		\n\t"
			"		ORR		R3, R3,	R4,LSL#8		\n\t"
			"		MOV		R4, R4,LSR#24		\n\t"
			"		ORR		R4, R4,	R5,LSL#8		\n\t"
			"		MOV		R5, R5,LSR#24		\n\t"
			"		ORR		R5, R5,	R12,LSL#8		\n\t"
			"		MOV		R12, R12,LSR#24		\n\t"
			"		ORR		R12, R12, LR,LSL#8		\n\t"
			"		STMIA		R0!, {R3-R5,R12}		\n\t"
			"		MOV		R3, LR,LSR#24		\n\t"
			"		LDMIA		R1!, {R4,R5,R12,LR}		\n\t"
			"		ORR		R3, R3,	R4,LSL#8		\n\t"
			"		MOV		R4, R4,LSR#24		\n\t"
			"		ORR		R4, R4,	R5,LSL#8		\n\t"
			"		MOV		R5, R5,LSR#24		\n\t"
			"		ORR		R5, R5,	R12,LSL#8		\n\t"
			"		MOV		R12, R12,LSR#24		\n\t"
			"		ORR		R12, R12, LR,LSL#8		\n\t"
			"		STMIA		R0!, {R3-R5,R12}		\n\t"
			"		SUBS		R2, R2,	#0x20		\n\t"
			"		MOV		R3, LR,LSR#24		\n\t"
			"		BGE		loc_841080C4		\n\t"
			"											\n\t"
			"loc_8410811C:		\n\t"
			"		ADDS		R2, R2,	#0x18		\n\t"
			"		BLT		loc_84108144		\n\t"
			"											\n\t"
			"loc_84108124:		\n\t"
			"		LDMIA		R1!, {R4,R5}		\n\t"
			"		ORR		R3, R3,	R4,LSL#8		\n\t"
			"		MOV		R4, R4,LSR#24		\n\t"
			"		ORR		R4, R4,	R5,LSL#8		\n\t"
			"		STMIA		R0!, {R3,R4}		\n\t"
			"		SUBS		R2, R2,	#8		\n\t"
			"		MOV		R3, R5,LSR#24		\n\t"
			"		BGE		loc_84108124		\n\t"
			"											\n\t"
			"loc_84108144:		\n\t"
			"		ADDS		R2, R2,	#4		\n\t"
			"		BLT		loc_8410815C		\n\t"
			"		LDR		R4, [R1],#4		\n\t"
			"		ORR		R3, R3,	R4,LSL#8		\n\t"
			"		STR		R3, [R0],#4		\n\t"
			"		MOV		R3, R4,LSR#24		\n\t"
			"											\n\t"
			"loc_8410815C:		\n\t"
			"		ADDLTS		R2, R2,	#4		\n\t"
			"		BEQ		locret_8410817C		\n\t"
			"		CMP		R2, #2		\n\t"
			"		LDRGEH		R4, [R1],#2		\n\t"
			"		STRB		R3, [R0],#1		\n\t"
			"		STRGEB		R4, [R0],#1		\n\t"
			"		MOVGT		R4, R4,LSR#8		\n\t"
			"		STRGTB		R4, [R0],#1		\n\t"
			"											\n\t"
			"locret_8410817C:		\n\t"
			#ifdef HAVE_ARM_v5
				"		LDMFD		SP!, {R0,R4,R5,PC}		\n\t"
			#else
				"		LDMFD		SP!, {R0,R4,R5,LR}		\n\t"
				"		BX			LR						\n\t"
			#endif
			"											\n\t"
			"											\n\t"
			"loc_84108180:		\n\t"
			"		LDRB		R3, [R1],#1		\n\t"
			"		LDRH		R4, [R1],#2		\n\t"
			"		SUBS		R2, R2,	#0x20		\n\t"
			"		ORR		R3, R3,	R4,LSL#8		\n\t"
			"		BLT		loc_841081EC		\n\t"
			"											\n\t"
			"loc_84108194:		\n\t"
			"		LDMIA		R1!, {R4,R5,R12,LR}		\n\t"
			"		ORR		R3, R3,	R4,LSL#24		\n\t"
			"		MOV		R4, R4,LSR#8		\n\t"
			"		ORR		R4, R4,	R5,LSL#24		\n\t"
			"		MOV		R5, R5,LSR#8		\n\t"
			"		ORR		R5, R5,	R12,LSL#24		\n\t"
			"		MOV		R12, R12,LSR#8		\n\t"
			"		ORR		R12, R12, LR,LSL#24		\n\t"
			"		STMIA		R0!, {R3-R5,R12}		\n\t"
			"		MOV		R3, LR,LSR#8		\n\t"
			"		LDMIA		R1!, {R4,R5,R12,LR}		\n\t"
			"		ORR		R3, R3,	R4,LSL#24		\n\t"
			"		MOV		R4, R4,LSR#8		\n\t"
			"		ORR		R4, R4,	R5,LSL#24		\n\t"
			"		MOV		R5, R5,LSR#8		\n\t"
			"		ORR		R5, R5,	R12,LSL#24		\n\t"
			"		MOV		R12, R12,LSR#8		\n\t"
			"		ORR		R12, R12, LR,LSL#24		\n\t"
			"		STMIA		R0!, {R3-R5,R12}		\n\t"
			"		SUBS		R2, R2,	#0x20		\n\t"
			"		MOV		R3, LR,LSR#8		\n\t"
			"		BGE		loc_84108194		\n\t"
			"											\n\t"
			"loc_841081EC:		\n\t"
			"		ADDS		R2, R2,	#0x18		\n\t"
			"		BLT		loc_84108214		\n\t"
			"											\n\t"
			"loc_841081F4:		\n\t"
			"		LDMIA		R1!, {R4,R5}		\n\t"
			"		ORR		R3, R3,	R4,LSL#24		\n\t"
			"		MOV		R4, R4,LSR#8		\n\t"
			"		ORR		R4, R4,	R5,LSL#24		\n\t"
			"		STMIA		R0!, {R3,R4}		\n\t"
			"		SUBS		R2, R2,	#8		\n\t"
			"		MOV		R3, R5,LSR#8		\n\t"
			"		BGE		loc_841081F4		\n\t"
			"											\n\t"
			"loc_84108214:		\n\t"
			"		ADDS		R2, R2,	#4		\n\t"
			"		BLT		loc_84108230		\n\t"
			"		LDR		R4, [R1],#4		\n\t"
			"		ORR		R3, R3,	R4,LSL#24		\n\t"
			"		STR		R3, [R0],#4		\n\t"
			"		BEQ		locret_8410824C		\n\t"
			"		MOV		R3, R4,LSR#8		\n\t"
			"											\n\t"
			"loc_84108230:		\n\t"
			"		ADDLTS		R2, R2,	#4		\n\t"
			"		BEQ		locret_8410824C		\n\t"
			"		CMP		R2, #2		\n\t"
			"		STRLTB		R3, [R0],#1		\n\t"
			"		STRGEH		R3, [R0],#2		\n\t"
			"		MOVGT		R3, R3,LSR#16		\n\t"
			"		STRGTB		R3, [R0],#1		\n\t"
			"											\n\t"
			"locret_8410824C:		\n\t"
			#ifdef HAVE_ARM_v5
				"		LDMFD		SP!, {R0,R4,R5,PC}		\n\t"
			#else
				"		LDMFD		SP!, {R0,R4,R5,LR}		\n\t"
				"		BX			LR						\n\t"
			#endif
			"											\n\t"
			"											\n\t"
			"loc_84108250:		\n\t"
			"		CMP		R2, #4		\n\t"
			"		BLT		loc_8410827C		\n\t"
			"		LDRB		R3, [R1],#1		\n\t"
			"		SUB		R2, R2,	#4		\n\t"
			"		LDRB		R4, [R1],#1		\n\t"
			"		LDRB		R5, [R1],#1		\n\t"
			"		LDRB		LR, [R1],#1		\n\t"
			"		STRB		R3, [R0],#1		\n\t"
			"		STRB		R4, [R0],#1		\n\t"
			"		STRB		R5, [R0],#1		\n\t"
			"		STRB		LR, [R0],#1		\n\t"
			"											\n\t"
			"loc_8410827C:		\n\t"
			"		CMP		R2, #0		\n\t"
			"		LDMEQFD		SP!, {R0,R4,R5,PC}		\n\t"
			"		LDRB		R3, [R1],#1		\n\t"
			"		CMP		R2, #2		\n\t"
			"		STRB		R3, [R0],#1		\n\t"
			"		BLT		locret_841082A4		\n\t"
			"		LDRGEB		R4, [R1],#1		\n\t"
			"		LDRGTB		R5, [R1],#1		\n\t"
			"		STRGEB		R4, [R0],#1		\n\t"
			"		STRGTB		R5, [R0],#1		\n\t"
			"											\n\t"
			"locret_841082A4:		\n\t"
			#ifdef HAVE_ARM_v5
				"		LDMFD		SP!, {R0,R4,R5,PC}		\n\t"
			#else
				"		LDMFD		SP!, {R0,R4,R5,LR}		\n\t"
				"		BX			LR						\n\t"
			#endif
			"											\n\t"
			"											\n\t"
			"loc_841082A8:		\n\t"
			"		ADD		SP, SP,	#0x10		\n\t"
			"		STMFD		SP!, {R0,R4-R11,LR}		\n\t"
			"		MOV		R5, R1		\n\t"
			"		BIC		R5, R5,	#3		\n\t"
			#ifdef HAVE_ARM_v5_DSP_EXTS
				"		PLD		[R5]		\n\t"
				"		PLD		[R5,#0x20]		\n\t"
				"		PLD		[R5,#0x40]		\n\t"
			#endif
			"		CMP		R2, #4		\n\t"
			"		BLS		loc_84108C18		\n\t"
			"		RSB		R4, R0,	#0		\n\t"
			"		ANDS		R4, R4,	#2		\n\t"
			"		LDRNEB		R5, [R1],#1		\n\t"
			"		LDRNEB		R6, [R1],#1		\n\t"
			"		SUBNE		R2, R2,	#2		\n\t"
			"		STRNEB		R5, [R0],#1		\n\t"
			"		STRNEB		R6, [R0],#1		\n\t"
			"		ANDS		R4, R0,	#1		\n\t"
			"		LDRNEB		R5, [R1],#1		\n\t"
			"		SUBNE		R2, R2,	#1		\n\t"
			"		STRNEB		R5, [R0],#1		\n\t"
			"		AND		R3, R1,	#3		\n\t"
			"		CMP		R3, #3		\n\t"
			"		BEQ		loc_841089B0		\n\t"
			"		CMP		R3, #2		\n\t"
			"		BEQ		loc_84108710		\n\t"
			"		CMP		R3, #1		\n\t"
			"		BEQ		loc_84108470		\n\t"
			"		AND		R4, R0,	#0x1C		\n\t"
			"		RSB		R4, R4,	#0x20		\n\t"
			"		AND		R5, R2,	#0x1C		\n\t"
			"		CMP		R4, R2		\n\t"
			"		MOVHI		R4, R5		\n\t"
			"		CMP		R4, #0		\n\t"
			"		BEQ		loc_8410838C		\n\t"
			"		RSB		R3, R4,	#0x20		\n\t"
			"		AND		R3, R3,	#0x1C		\n\t"
			"		SUB		R2, R2,	R4		\n\t"
			"		ADR		R12, loc_84108344		\n\t"
			"		ADD		PC, R12, R3		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108344:		\n\t"
			"		LDR		R4, [R1],#4		\n\t"
			"		LDR		R5, [R1],#4		\n\t"
			"		LDR		R6, [R1],#4		\n\t"
			"		LDR		R7, [R1],#4		\n\t"
			"		LDR		R8, [R1],#4		\n\t"
			"		LDR		R9, [R1],#4		\n\t"
			"		LDR		R10, [R1],#4		\n\t"
			"		LDR		R11, [R1],#4		\n\t"
			"		ADR		R12, loc_8410836C		\n\t"
			"		ADD		PC, R12, R3		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_8410836C:		\n\t"
			"		STR		R4, [R0],#4		\n\t"
			"		STR		R5, [R0],#4		\n\t"
			"		STR		R6, [R0],#4		\n\t"
			"		STR		R7, [R0],#4		\n\t"
			"		STR		R8, [R0],#4		\n\t"
			"		STR		R9, [R0],#4		\n\t"
			"		STR		R10, [R0],#4		\n\t"
			"		STR		R11, [R0],#4		\n\t"
			"											\n\t"
			"loc_8410838C:		\n\t"
			"		CMP		R2, #0x80		\n\t"
			"		BMI		loc_841083B4		\n\t"
			#ifdef HAVE_ARM_v5_DSP_EXTS
				"		PLD		[R1,#0x60]		\n\t"
				"		PLD		[R1,#0x80]		\n\t"
			#endif
			"		LDMIA		R1!, {R4-R11}		\n\t"
			"		STMIA		R0!, {R4-R11}		\n\t"
			"		LDMIA		R1!, {R4-R11}		\n\t"
			"		STMIA		R0!, {R4-R11}		\n\t"
			"		SUB		R2, R2,	#0x40		\n\t"
			"		B		loc_8410838C		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841083B4:		\n\t"
			"		CMP		R2, #0x80		\n\t"
			"		BLS		loc_841083C0		\n\t"
			#ifdef HAVE_ARM_v5_DSP_EXTS
				"		PLD		[R1,#0x80]		\n\t"
			#endif
			"											\n\t"
			"loc_841083C0:		\n\t"
			"		CMP		R2, #0x20		\n\t"
			"		BMI		loc_841083D8		\n\t"
			"		LDMIA		R1!, {R4-R11}		\n\t"
			"		STMIA		R0!, {R4-R11}		\n\t"
			"		SUB		R2, R2,	#0x20		\n\t"
			"		B		loc_841083C0		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841083D8:		\n\t"
			"		ANDS		R3, R2,	#0x1C		\n\t"
			"		BEQ		loc_84108C18		\n\t"
			"		SUB		R2, R2,	R3		\n\t"
			"		RSB		R3, R3,	#0x20		\n\t"
			"		ADR		R12, loc_841083F0		\n\t"
			"		ADD		PC, R12, R3		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841083F0:		\n\t"
			"		LDR		R4, [R1],#4		\n\t"
			"		LDR		R5, [R1],#4		\n\t"
			"		LDR		R6, [R1],#4		\n\t"
			"		LDR		R7, [R1],#4		\n\t"
			"		LDR		R8, [R1],#4		\n\t"
			"		LDR		R9, [R1],#4		\n\t"
			"		LDR		R10, [R1],#4		\n\t"
			"		LDR		R11, [R1],#4		\n\t"
			"		ADR		R12, loc_84108418		\n\t"
			"		ADD		PC, R12, R3		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108418:		\n\t"
			"		STR		R4, [R0],#4		\n\t"
			"		STR		R5, [R0],#4		\n\t"
			"		STR		R6, [R0],#4		\n\t"
			"		STR		R7, [R0],#4		\n\t"
			"		STR		R8, [R0],#4		\n\t"
			"		STR		R9, [R0],#4		\n\t"
			"		STR		R10, [R0],#4		\n\t"
			"		STR		R11, [R0],#4		\n\t"
			"		RSB		R2, R2,	#4		\n\t"
			"		ADR		R12, loc_84108444		\n\t"
			"		ADD		PC, R12, R2,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108444:		\n\t"
			"		LDRB		R3, [R1],#1		\n\t"
			"		LDRB		R4, [R1],#1		\n\t"
			"		LDRB		R5, [R1],#1		\n\t"
			"		LDRB		R6, [R1],#1		\n\t"
			"		ADR		R12, loc_8410845C		\n\t"
			"		ADD		PC, R12, R2,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_8410845C:		\n\t"
			"		STRB		R3, [R0],#1		\n\t"
			"		STRB		R4, [R0],#1		\n\t"
			"		STRB		R5, [R0],#1		\n\t"
			"		STRB		R6, [R0],#1		\n\t"
			"		LDMFD		SP!, {R0,R4-R11,PC}		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108470:		\n\t"
			"		BIC		R3, R1,	#3		\n\t"
			"		LDR		LR, [R3],#4		\n\t"
			"		MOV		LR, LR,LSR#8		\n\t"
			"		AND		R4, R0,	#0x1C		\n\t"
			"		RSB		R4, R4,	#0x20		\n\t"
			"		AND		R5, R2,	#0x1C		\n\t"
			"		CMP		R4, R2		\n\t"
			"		MOVHI		R4, R5		\n\t"
			"		CMP		R4, #0		\n\t"
			"		BEQ		loc_8410852C		\n\t"
			"		RSB		R6, R4,	#0x20		\n\t"
			"		AND		R6, R6,	#0x1C		\n\t"
			"		SUB		R2, R2,	R4		\n\t"
			"		ADR		R12, loc_841084AC		\n\t"
			"		ADD		PC, R12, R6,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841084AC:		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"											\n\t"
			"loc_8410852C:		\n\t"
			"		CMP		R2, #0xA0		\n\t"
			"		BMI		loc_841085D4		\n\t"
			#ifdef HAVE_ARM_v5_DSP_EXTS
				"		PLD		[R3,#0x60]		\n\t"
				"		PLD		[R3,#0x80]		\n\t"
			#endif
			"		LDMIA		R3!, {R4-R11}		\n\t"
			"		ORR		R1, LR,	R4,LSL#24		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		ORR		R4, LR,	R5,LSL#24		\n\t"
			"		MOV		LR, R5,LSR#8		\n\t"
			"		ORR		R5, LR,	R6,LSL#24		\n\t"
			"		MOV		LR, R6,LSR#8		\n\t"
			"		ORR		R6, LR,	R7,LSL#24		\n\t"
			"		MOV		LR, R7,LSR#8		\n\t"
			"		ORR		R7, LR,	R8,LSL#24		\n\t"
			"		MOV		LR, R8,LSR#8		\n\t"
			"		ORR		R8, LR,	R9,LSL#24		\n\t"
			"		MOV		LR, R9,LSR#8		\n\t"
			"		ORR		R9, LR,	R10,LSL#24		\n\t"
			"		MOV		LR, R10,LSR#8		\n\t"
			"		ORR		R10, LR, R11,LSL#24		\n\t"
			"		MOV		LR, R11,LSR#8		\n\t"
			"		STMIA		R0!, {R1,R4-R10}		\n\t"
			"		LDMIA		R3!, {R4-R11}		\n\t"
			"		ORR		R1, LR,	R4,LSL#24		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		ORR		R4, LR,	R5,LSL#24		\n\t"
			"		MOV		LR, R5,LSR#8		\n\t"
			"		ORR		R5, LR,	R6,LSL#24		\n\t"
			"		MOV		LR, R6,LSR#8		\n\t"
			"		ORR		R6, LR,	R7,LSL#24		\n\t"
			"		MOV		LR, R7,LSR#8		\n\t"
			"		ORR		R7, LR,	R8,LSL#24		\n\t"
			"		MOV		LR, R8,LSR#8		\n\t"
			"		ORR		R8, LR,	R9,LSL#24		\n\t"
			"		MOV		LR, R9,LSR#8		\n\t"
			"		ORR		R9, LR,	R10,LSL#24		\n\t"
			"		MOV		LR, R10,LSR#8		\n\t"
			"		ORR		R10, LR, R11,LSL#24		\n\t"
			"		MOV		LR, R11,LSR#8		\n\t"
			"		STMIA		R0!, {R1,R4-R10}		\n\t"
			"		SUB		R2, R2,	#0x40		\n\t"
			"		B		loc_8410852C		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841085D4:		\n\t"
			"		CMP		R2, #0x80		\n\t"
			"		BLS		loc_841085E0		\n\t"
			#ifdef HAVE_ARM_v5_DSP_EXTS
				"		PLD		[R3,#0x80]		\n\t"
			#endif
			"											\n\t"
			"loc_841085E0:		\n\t"
			"		CMP		R2, #0x20		\n\t"
			"		BMI		loc_84108638		\n\t"
			"		LDMIA		R3!, {R4-R11}		\n\t"
			"		ORR		R1, LR,	R4,LSL#24		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		ORR		R4, LR,	R5,LSL#24		\n\t"
			"		MOV		LR, R5,LSR#8		\n\t"
			"		ORR		R5, LR,	R6,LSL#24		\n\t"
			"		MOV		LR, R6,LSR#8		\n\t"
			"		ORR		R6, LR,	R7,LSL#24		\n\t"
			"		MOV		LR, R7,LSR#8		\n\t"
			"		ORR		R7, LR,	R8,LSL#24		\n\t"
			"		MOV		LR, R8,LSR#8		\n\t"
			"		ORR		R8, LR,	R9,LSL#24		\n\t"
			"		MOV		LR, R9,LSR#8		\n\t"
			"		ORR		R9, LR,	R10,LSL#24		\n\t"
			"		MOV		LR, R10,LSR#8		\n\t"
			"		ORR		R10, LR, R11,LSL#24		\n\t"
			"		MOV		LR, R11,LSR#8		\n\t"
			"		STMIA		R0!, {R1,R4-R10}		\n\t"
			"		SUB		R2, R2,	#0x20		\n\t"
			"		B		loc_841085E0		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108638:		\n\t"
			"		ANDS		R6, R2,	#0x1C		\n\t"
			"		SUBEQ		R1, R3,	#3		\n\t"
			"		BEQ		loc_84108C18		\n\t"
			"		SUB		R2, R2,	R6		\n\t"
			"		RSB		R6, R6,	#0x20		\n\t"
			"		ADR		R12, loc_84108654		\n\t"
			"		ADD		PC, R12, R6,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108654:		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#24		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#8		\n\t"
			"		SUB		R1, R3,	#3		\n\t"
			"		RSB		R2, R2,	#4		\n\t"
			"		ADR		R12, loc_841086E4		\n\t"
			"		ADD		PC, R12, R2,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841086E4:		\n\t"
			"		LDRB		R3, [R1],#1		\n\t"
			"		LDRB		R4, [R1],#1		\n\t"
			"		LDRB		R5, [R1],#1		\n\t"
			"		LDRB		R6, [R1],#1		\n\t"
			"		ADR		R12, loc_841086FC		\n\t"
			"		ADD		PC, R12, R2,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841086FC:		\n\t"
			"		STRB		R3, [R0],#1		\n\t"
			"		STRB		R4, [R0],#1		\n\t"
			"		STRB		R5, [R0],#1		\n\t"
			"		STRB		R6, [R0],#1		\n\t"
			"		LDMFD		SP!, {R0,R4-R11,PC}		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108710:		\n\t"
			"		BIC		R3, R1,	#3		\n\t"
			"		LDR		LR, [R3],#4		\n\t"
			"		MOV		LR, LR,LSR#16		\n\t"
			"		AND		R4, R0,	#0x1C		\n\t"
			"		RSB		R4, R4,	#0x20		\n\t"
			"		AND		R5, R2,	#0x1C		\n\t"
			"		CMP		R4, R2		\n\t"
			"		MOVHI		R4, R5		\n\t"
			"		CMP		R4, #0		\n\t"
			"		BEQ		loc_841087CC		\n\t"
			"		RSB		R6, R4,	#0x20		\n\t"
			"		AND		R6, R6,	#0x1C		\n\t"
			"		SUB		R2, R2,	R4		\n\t"
			"		ADR		R12, loc_8410874C		\n\t"
			"		ADD		PC, R12, R6,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_8410874C:		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"											\n\t"
			"loc_841087CC:		\n\t"
			"		CMP		R2, #0xA0		\n\t"
			"		BMI		loc_84108874		\n\t"
			#ifdef HAVE_ARM_v5_DSP_EXTS
				"		PLD		[R3,#0x60]		\n\t"
				"		PLD		[R3,#0x80]		\n\t"
			#endif
			"		LDMIA		R3!, {R4-R11}		\n\t"
			"		ORR		R1, LR,	R4,LSL#16		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		ORR		R4, LR,	R5,LSL#16		\n\t"
			"		MOV		LR, R5,LSR#16		\n\t"
			"		ORR		R5, LR,	R6,LSL#16		\n\t"
			"		MOV		LR, R6,LSR#16		\n\t"
			"		ORR		R6, LR,	R7,LSL#16		\n\t"
			"		MOV		LR, R7,LSR#16		\n\t"
			"		ORR		R7, LR,	R8,LSL#16		\n\t"
			"		MOV		LR, R8,LSR#16		\n\t"
			"		ORR		R8, LR,	R9,LSL#16		\n\t"
			"		MOV		LR, R9,LSR#16		\n\t"
			"		ORR		R9, LR,	R10,LSL#16		\n\t"
			"		MOV		LR, R10,LSR#16		\n\t"
			"		ORR		R10, LR, R11,LSL#16		\n\t"
			"		MOV		LR, R11,LSR#16		\n\t"
			"		STMIA		R0!, {R1,R4-R10}		\n\t"
			"		LDMIA		R3!, {R4-R11}		\n\t"
			"		ORR		R1, LR,	R4,LSL#16		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		ORR		R4, LR,	R5,LSL#16		\n\t"
			"		MOV		LR, R5,LSR#16		\n\t"
			"		ORR		R5, LR,	R6,LSL#16		\n\t"
			"		MOV		LR, R6,LSR#16		\n\t"
			"		ORR		R6, LR,	R7,LSL#16		\n\t"
			"		MOV		LR, R7,LSR#16		\n\t"
			"		ORR		R7, LR,	R8,LSL#16		\n\t"
			"		MOV		LR, R8,LSR#16		\n\t"
			"		ORR		R8, LR,	R9,LSL#16		\n\t"
			"		MOV		LR, R9,LSR#16		\n\t"
			"		ORR		R9, LR,	R10,LSL#16		\n\t"
			"		MOV		LR, R10,LSR#16		\n\t"
			"		ORR		R10, LR, R11,LSL#16		\n\t"
			"		MOV		LR, R11,LSR#16		\n\t"
			"		STMIA		R0!, {R1,R4-R10}		\n\t"
			"		SUB		R2, R2,	#0x40		\n\t"
			"		B		loc_841087CC		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108874:		\n\t"
			"		CMP		R2, #0x80		\n\t"
			"		BLS		loc_84108880		\n\t"
			#ifdef HAVE_ARM_v5_DSP_EXTS
				"		PLD		[R3,#0x80]		\n\t"
			#endif
			"											\n\t"
			"loc_84108880:		\n\t"
			"		CMP		R2, #0x20		\n\t"
			"		BMI		loc_841088D8		\n\t"
			"		LDMIA		R3!, {R4-R11}		\n\t"
			"		ORR		R1, LR,	R4,LSL#16		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		ORR		R4, LR,	R5,LSL#16		\n\t"
			"		MOV		LR, R5,LSR#16		\n\t"
			"		ORR		R5, LR,	R6,LSL#16		\n\t"
			"		MOV		LR, R6,LSR#16		\n\t"
			"		ORR		R6, LR,	R7,LSL#16		\n\t"
			"		MOV		LR, R7,LSR#16		\n\t"
			"		ORR		R7, LR,	R8,LSL#16		\n\t"
			"		MOV		LR, R8,LSR#16		\n\t"
			"		ORR		R8, LR,	R9,LSL#16		\n\t"
			"		MOV		LR, R9,LSR#16		\n\t"
			"		ORR		R9, LR,	R10,LSL#16		\n\t"
			"		MOV		LR, R10,LSR#16		\n\t"
			"		ORR		R10, LR, R11,LSL#16		\n\t"
			"		MOV		LR, R11,LSR#16		\n\t"
			"		STMIA		R0!, {R1,R4-R10}		\n\t"
			"		SUB		R2, R2,	#0x20		\n\t"
			"		B		loc_84108880		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841088D8:		\n\t"
			"		ANDS		R6, R2,	#0x1C		\n\t"
			"		SUBEQ		R1, R3,	#2		\n\t"
			"		BEQ		loc_84108C18		\n\t"
			"		SUB		R2, R2,	R6		\n\t"
			"		RSB		R6, R6,	#0x20		\n\t"
			"		ADR		R12, loc_841088F4		\n\t"
			"		ADD		PC, R12, R6,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841088F4:		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#16		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#16		\n\t"
			"		SUB		R1, R3,	#2		\n\t"
			"		RSB		R2, R2,	#4		\n\t"
			"		ADR		R12, loc_84108984		\n\t"
			"		ADD		PC, R12, R2,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108984:		\n\t"
			"		LDRB		R3, [R1],#1		\n\t"
			"		LDRB		R4, [R1],#1		\n\t"
			"		LDRB		R5, [R1],#1		\n\t"
			"		LDRB		R6, [R1],#1		\n\t"
			"		ADR		R12, loc_8410899C		\n\t"
			"		ADD		PC, R12, R2,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_8410899C:		\n\t"
			"		STRB		R3, [R0],#1		\n\t"
			"		STRB		R4, [R0],#1		\n\t"
			"		STRB		R5, [R0],#1		\n\t"
			"		STRB		R6, [R0],#1		\n\t"
			"		LDMFD		SP!, {R0,R4-R11,PC}		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841089B0:		\n\t"
			"		BIC		R3, R1,	#3		\n\t"
			"		LDR		LR, [R3],#4		\n\t"
			"		MOV		LR, LR,LSR#24		\n\t"
			"		AND		R4, R0,	#0x1C		\n\t"
			"		RSB		R4, R4,	#0x20		\n\t"
			"		AND		R5, R2,	#0x1C		\n\t"
			"		CMP		R4, R2		\n\t"
			"		MOVHI		R4, R5		\n\t"
			"		CMP		R4, #0		\n\t"
			"		BEQ		loc_84108A6C		\n\t"
			"		RSB		R6, R4,	#0x20		\n\t"
			"		AND		R6, R6,	#0x1C		\n\t"
			"		SUB		R2, R2,	R4		\n\t"
			"		ADR		R12, loc_841089EC		\n\t"
			"		ADD		PC, R12, R6,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_841089EC:		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"											\n\t"
			"loc_84108A6C:		\n\t"
			"		CMP		R2, #0xA0		\n\t"
			"		BMI		loc_84108B14		\n\t"
			#ifdef HAVE_ARM_v5_DSP_EXTS
				"		PLD		[R3,#0x60]		\n\t"
				"		PLD		[R3,#0x80]		\n\t"
			#endif
			"		LDMIA		R3!, {R4-R11}		\n\t"
			"		ORR		R1, LR,	R4,LSL#8		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		ORR		R4, LR,	R5,LSL#8		\n\t"
			"		MOV		LR, R5,LSR#24		\n\t"
			"		ORR		R5, LR,	R6,LSL#8		\n\t"
			"		MOV		LR, R6,LSR#24		\n\t"
			"		ORR		R6, LR,	R7,LSL#8		\n\t"
			"		MOV		LR, R7,LSR#24		\n\t"
			"		ORR		R7, LR,	R8,LSL#8		\n\t"
			"		MOV		LR, R8,LSR#24		\n\t"
			"		ORR		R8, LR,	R9,LSL#8		\n\t"
			"		MOV		LR, R9,LSR#24		\n\t"
			"		ORR		R9, LR,	R10,LSL#8		\n\t"
			"		MOV		LR, R10,LSR#24		\n\t"
			"		ORR		R10, LR, R11,LSL#8		\n\t"
			"		MOV		LR, R11,LSR#24		\n\t"
			"		STMIA		R0!, {R1,R4-R10}		\n\t"
			"		LDMIA		R3!, {R4-R11}		\n\t"
			"		ORR		R1, LR,	R4,LSL#8		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		ORR		R4, LR,	R5,LSL#8		\n\t"
			"		MOV		LR, R5,LSR#24		\n\t"
			"		ORR		R5, LR,	R6,LSL#8		\n\t"
			"		MOV		LR, R6,LSR#24		\n\t"
			"		ORR		R6, LR,	R7,LSL#8		\n\t"
			"		MOV		LR, R7,LSR#24		\n\t"
			"		ORR		R7, LR,	R8,LSL#8		\n\t"
			"		MOV		LR, R8,LSR#24		\n\t"
			"		ORR		R8, LR,	R9,LSL#8		\n\t"
			"		MOV		LR, R9,LSR#24		\n\t"
			"		ORR		R9, LR,	R10,LSL#8		\n\t"
			"		MOV		LR, R10,LSR#24		\n\t"
			"		ORR		R10, LR, R11,LSL#8		\n\t"
			"		MOV		LR, R11,LSR#24		\n\t"
			"		STMIA		R0!, {R1,R4-R10}		\n\t"
			"		SUB		R2, R2,	#0x40		\n\t"
			"		B		loc_84108A6C		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108B14:		\n\t"
			"		CMP		R2, #0x80		\n\t"
			"		BLS		loc_84108B20		\n\t"
			#ifdef HAVE_ARM_v5_DSP_EXTS
				"		PLD		[R3,#0x80]		\n\t"
			#endif
			"											\n\t"
			"loc_84108B20:		\n\t"
			"		CMP		R2, #0x20		\n\t"
			"		BMI		loc_84108B78		\n\t"
			"		LDMIA		R3!, {R4-R11}		\n\t"
			"		ORR		R1, LR,	R4,LSL#8		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		ORR		R4, LR,	R5,LSL#8		\n\t"
			"		MOV		LR, R5,LSR#24		\n\t"
			"		ORR		R5, LR,	R6,LSL#8		\n\t"
			"		MOV		LR, R6,LSR#24		\n\t"
			"		ORR		R6, LR,	R7,LSL#8		\n\t"
			"		MOV		LR, R7,LSR#24		\n\t"
			"		ORR		R7, LR,	R8,LSL#8		\n\t"
			"		MOV		LR, R8,LSR#24		\n\t"
			"		ORR		R8, LR,	R9,LSL#8		\n\t"
			"		MOV		LR, R9,LSR#24		\n\t"
			"		ORR		R9, LR,	R10,LSL#8		\n\t"
			"		MOV		LR, R10,LSR#24		\n\t"
			"		ORR		R10, LR, R11,LSL#8		\n\t"
			"		MOV		LR, R11,LSR#24		\n\t"
			"		STMIA		R0!, {R1,R4-R10}		\n\t"
			"		SUB		R2, R2,	#0x20		\n\t"
			"		B		loc_84108B20		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108B78:		\n\t"
			"		ANDS		R6, R2,	#0x1C		\n\t"
			"		SUBEQ		R1, R3,	#1		\n\t"
			"		BEQ		loc_84108C18		\n\t"
			"		SUB		R2, R2,	R6		\n\t"
			"		RSB		R6, R6,	#0x20		\n\t"
			"		ADR		R12, loc_84108B94		\n\t"
			"		ADD		PC, R12, R6,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"loc_84108B94:		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		LDR		R4, [R3],#4		\n\t"
			"		ORR		R12, LR, R4,LSL#8		\n\t"
			"		STR		R12, [R0],#4		\n\t"
			"		MOV		LR, R4,LSR#24		\n\t"
			"		SUB		R1, R3,	#1		\n\t"
			"											\n\t"
			"loc_84108C18:		\n\t"
			"		RSB		R2, R2,	#4		\n\t"
			"		ADR		R12, sub_84108C24		\n\t"
			"		ADD		PC, R12, R2,LSL#2		\n\t"
			"											\n\t"
			"											\n\t"
			"sub_84108C24:		\n\t"
			"		LDRB		R3, [R1],#1		\n\t"
			"		LDRB		R4, [R1],#1		\n\t"
			"		LDRB		R5, [R1],#1		\n\t"
			"		LDRB		R6, [R1],#1		\n\t"
			"		ADR		R12, sub_84108C3C		\n\t"
			"		ADD		PC, R12, R2,LSL#2		\n\t"
			"											\n\t"
			"sub_84108C3C:		\n\t"
			"		STRB		R3, [R0],#1				\n\t"
			"		STRB		R4, [R0],#1				\n\t"
			"		STRB		R5, [R0],#1				\n\t"
			"		STRB		R6, [R0],#1				\n\t"
			"		LDMFD		SP!, {R0,R4-R11,PC}		\n\t"

		);
		
		return dstP;	//not reached
	}

#else	//Cortex

	//we need our own memcpy because GCC fucks it up
	//it uses unaligned accesses even if we do not ask for them (via flags)
	
	void* __attribute__((naked)) memcpy(void* dstP, const void* srcP, size_t sz)
	{
		asm volatile(
			"	mov     r12, r0						\n\t"
			"	orrs    r3, r0, r1					\n\t"
			"	lsls    r3, #30						\n\t"
			"	bne     not_word_aligned			\n\t"
			"										\n\t"
			"is_word_aligned:						\n\t"	// see if long copy is worth it
			"	lsrs    r3, r2, #5					\n\t"
			"	beq     wordwise_copy				\n\t"
			"	and     r2, #31						\n\t"
			"	push    {r4-r7}						\n\t"
			"1:										\n\t"
			"	ldmia   r1!, {r4-r7}				\n\t"
			"	stmia   r0!, {r4-r7}				\n\t"
			"	ldmia   r1!, {r4-r7}				\n\t"
			"	stmia   r0!, {r4-r7}				\n\t"
			"	subs    r3, #1						\n\t"
			"	bne     1b							\n\t"
			"	pop     {r4-r7}						\n\t"
			"										\n\t"
			"wordwise_copy:							\n\t"
			"	subs    r2, #4						\n\t"
			"	bmi     wordwise_too_far			\n\t"
			"	ldr     r3, [r1], #4				\n\t"
			"	str     r3, [r0], #4				\n\t"
			"	bne     wordwise_copy				\n\t"
			"	b       out							\n\t"
			"										\n\t"
			"wordwise_too_far:						\n\t"	//r2 is now -1 (0b1...111), -2(0b1...110), -3(0b1...101), or -4(0b1...100)
			"	lsls    r2, #31						\n\t"
			"	itt     cs							\n\t"
			"	ldrhcs  r3, [r1], #2				\n\t"
			"	strhcs  r3, [r0], #2				\n\t"
			"	itt     mi							\n\t"
			"	ldrbmi  r3, [r1]					\n\t"	//no postincrement since we're done
			"	strbmi  r3, [r0]					\n\t"
			"										\n\t"
			"out:									\n\t"
			"	mov     r0, r12						\n\t"
			"	bx      lr							\n\t"
			"										\n\t"
			"not_word_aligned:						\n\t"	//maybe we're lucky and they are misaligned in the same way?
			"	eor     r3, r0, r1					\n\t"
			"	tst     r3, #3						\n\t"
			"	bne     hopeless_bytewise_copy		\n\t"
			"	cmp     r2, #8						\n\t"	//do not bother with realignment for small copies
			"	bcc     hopeless_bytewise_copy		\n\t"
			"										\n\t"
			"realign:								\n\t"
			"	subs    r2, #1						\n\t"
			"	ldrb    r3, [r1], #1				\n\t"
			"	strb    r3, [r0], #1				\n\t"
			"	lsls    r3, r0, #30					\n\t"
			"	beq     is_word_aligned				\n\t"
			"										\n\t"
			"hopeless_bytewise_copy:				\n\t"
			"	subs    r2, #1						\n\t"
			"	bmi     out							\n\t"
			"	ldrb    r3, [r1], #1				\n\t"
			"	strb    r3, [r0], #1				\n\t"
			"	b       hopeless_bytewise_copy		\n\t"
		);
		
		return dstP;
	}

#endif
