#ifndef _MATH_LIB_H_
#define _MATH_LIB_H_

#include <ErrorBase.h>

#ifdef BUILDING_MATHLIB
	#define MATH_LIB_EXPORT(x)	impl_ ## x
#else
	#define MATH_LIB_EXPORT(x)	x
#endif


Err MATH_LIB_EXPORT(MathLibACos)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibASin)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibATan)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibATan2)(double y, double x, double *result);
Err MATH_LIB_EXPORT(MathLibCos)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibSin)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibTan)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibSinCos)(double x, double *sinx, double *cosx);
Err MATH_LIB_EXPORT(MathLibCosH)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibSinH)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibTanH)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibACosH)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibASinH)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibATanH)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibExp)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibFrExp)(double x, double *fraction, int16_t *exponent);
Err MATH_LIB_EXPORT(MathLibLdExp)(double x, int16_t exponent, double *result);
Err MATH_LIB_EXPORT(MathLibLog)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibLog10)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibModF)(double x, double *intpart, double *fracpart);
Err MATH_LIB_EXPORT(MathLibExpM1)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibLog1P)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibLogB)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibLog2)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibPow)(double x, double y, double *result);
Err MATH_LIB_EXPORT(MathLibSqrt)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibHypot)(double x, double y, double *result);
Err MATH_LIB_EXPORT(MathLibCbrt)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibCeil)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibFAbs)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibFloor)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibFMod)(double x, double y, double *result);
Err MATH_LIB_EXPORT(MathLibIsInf)(double x, int16_t *result);
Err MATH_LIB_EXPORT(MathLibFinite)(double x, int16_t *result);
Err MATH_LIB_EXPORT(MathLibScalBN)(double x, int16_t exponent, double *result);
Err MATH_LIB_EXPORT(MathLibDRem)(double x, double y, double *result);
Err MATH_LIB_EXPORT(MathLibSignificand)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibCopySign)(double x, double y, double *result);
Err MATH_LIB_EXPORT(MathLibIsNaN)(double x, int16_t *result);
Err MATH_LIB_EXPORT(MathLibILogB)(double x, int16_t *result);
Err MATH_LIB_EXPORT(MathLibRInt)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibNextAfter)(double x, double y, double *result);
Err MATH_LIB_EXPORT(MathLibRemainder)(double x, double y, double *result);
Err MATH_LIB_EXPORT(MathLibScalB)(double x, double exponent, double *result);
Err MATH_LIB_EXPORT(MathLibRound)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibTrunc)(double x, double *result);
Err MATH_LIB_EXPORT(MathLibSignBit)(double x, uint32_t *result);




#endif
