#include <stdint.h>
#include <stdio.h>
#include <ErrorBase.h>
#include "ftl.h"

uint32_t PilotMain(uint16_t cmd, void* cmdPBP, uint16_t flags)
{
	if (cmd == 0x7FFD)
		*(void**)cmdPBP = NULL;
	
	return errNone;
}


MemHandle impl_ftlInit(const struct NandSpec *spec, struct NandFuncs *funcs)
{
	return ftlInit(spec, funcs);
}

void impl_ftlFree(MemHandle ftlH)
{
	return ftlFree(ftlH);
}

bool impl_ftlMount(MemHandle ftlH)
{
	return ftlMount(ftlH);
}

void impl_ftlUnmount(MemHandle ftlH, bool allowWrite)
{
	return ftlUnmount(ftlH, allowWrite);
}

bool impl_ftlSleepNotify(MemHandle ftlH)
{
	return ftlSleepNotify(ftlH);
}

bool impl_ftlLowLevelFormat(MemHandle ftlH)
{
	return ftlLowLevelFormat(ftlH);
}

uint64_t impl_ftlGetInfo(MemHandle ftlH, enum FtlDataType which)
{
	return ftlGetInfo(ftlH, which);
}

bool impl_ftlRead(MemHandle ftlH, uint32_t secNum, void* buf)
{
	return ftlRead(ftlH, secNum, buf);
}

bool impl_ftlWrite(MemHandle ftlH, uint32_t secNum, const void* buf)	//pass null to write zeroes
{
	return ftlWrite(ftlH, secNum, buf);
}

bool impl_ftlTrim(MemHandle ftlH, uint32_t secNum)
{
	return ftlTrim(ftlH, secNum);
}

//optimized for size, not speed
uint64_t __attribute__((used)) __aeabi_uldivmod(uint64_t num, uint64_t denom)
{
	uint64_t ret = 0, mask = 1;
	
	while (!(denom >> 63)) {
		
		denom <<= 1;
		mask <<= 1;
	}
	
	do {
		
		if (num >= denom) {
			
			ret += mask;
			num -= denom;
		}
		denom >>= 1;
	} while (mask >>= 1);
	
	return ret;
}

