#ifndef _FTL_H_
#define _FTL_H_

#include <stdbool.h>
#include <stdint.h>
#include <MemoryMgr.h>
#include "nand.h"



enum FtlDataType {
	FtlVersion,
	FtlNandGeometry,				//bytes per page in lower 16 bits, pages per block in next 16 bits, blocks per device in next 32 bits
	FtlGeometry,					//bytes per sector in lower 16 bits, num sectors in top 32
	FtlLifetimeSectorsRead,
	FtlLifetimeSectorsWritten,
	FtlLifetimePagesWritten,
	FtlLifetimeBlocksErased,
	FtlNumTrimmedSectors,			//how many VAs currently map to no PA, approximate
	FtlAverageBlockCleanliness,		//in ppm
	FtlAverageBlockWear,			//num erases the average block has seen
	FtlNumBadBlocks,
	FtlGetLifetimeLeft,				//in ppm
	FtlLifetimeSectorsTrimmed,
	FtlLifetimeSectorsRelocated,		//how many read-disturbed oages were relocated on read
};


MemHandle ftlInit(const struct NandSpec *spec, struct NandFuncs *funcs);

bool ftlMount(MemHandle ftlH);
void ftlUnmount(MemHandle ftlH, bool allowWrite);
bool ftlLowLevelFormat(MemHandle ftlH);
bool ftlSleepNotify(MemHandle ftlH);
void ftlFree(MemHandle ftlH);

//CAN and DOES assume the buffers are 4-byte aligned
bool ftlRead(MemHandle ftlH, uint32_t secNum, void* buf);
bool ftlWrite(MemHandle ftlH, uint32_t secNum, const void* buf);	//pass null to write zeroes
bool ftlIsSecTrimmed(MemHandle ftlH, uint32_t secNum);

bool ftlTrim(MemHandle ftlH, uint32_t secNum);
	
uint64_t ftlGetInfo(MemHandle ftlH, enum FtlDataType which);


#endif
