#include "partitions.h"
#include "printf.h"
#include "util.h"




struct PartitionEntry {
	uint8_t active;
	uint8_t chsStart[3];
	uint8_t type;
	uint8_t chsEnd[3];
	uint32_t lbaStart;
	uint32_t lbaLen;
} __attribute__((packed));

struct Mbr {
	uint8_t crap[0x1be];
	struct PartitionEntry part[4];
	uint16_t sig;	//aa55
} __attribute__((packed));




bool partMgrFindBootPartition(PartMgrDiskBlockRead readF, void *readD, void *buf512, uint32_t *startSecP, uint32_t *numSecP)
{
	struct Mbr *mbr = (struct Mbr*)buf512;
	int_fast8_t foundIdx = -1;
	uint_fast8_t i;

	if (!readF(readD, mbr, 0))
		fatal("Failed to read MBR\n");
	else {
	
			if (mbr->sig != 0xaa55)
				fatal("MBR sig missing\n");
				else {
			
			for (i = 0; i < 4; i++) {
				
				//we are looking for a partition.
				
				//must be active
				if (mbr->part[i].active != 0x80)
					continue;
				
				//must have type 0x0e (fat16)
				if (mbr->part[i].type != 0x0e)
					continue;
				
				//must have a sane size (1MB+)
				if (mbr->part[i].lbaLen < 1024 * 1024 / 512)
					continue;
				
				//must be the only one
				if (foundIdx < 0)
					foundIdx = i;
				else
					fatal("More than one candidate boot partition found\n");
				
				if (startSecP)
					*startSecP = mbr->part[i].lbaStart;
				if (numSecP)
					*numSecP = mbr->part[i].lbaLen;
			}
		}
	}
	if (foundIdx < 0)
		fatal("No candidate boot partition found\n");
	
	return foundIdx >= 0;
}

