/* 12/30/09 */

/* Viewscreen, to display, zoom, and scroll images */

#include "viewscrn.h"


void VsDisplayZoomedSize(float zoom, int x, int y)
{
	char SizeDisplayStr[18];
	char TempStr[5];
	int zw, zh;
	float temp;

	temp=VsImageW*zoom*.01;
	zw=temp;
	temp=VsImageH*zoom*.01;
	zh=temp;

	if(y==566) rectfill(screen,x,560,x+70,586,LILAC);

	if(y==566) strcpy(SizeDisplayStr,"(");
		else strcpy(SizeDisplayStr,"");
	itoa(zw,TempStr,10);
	strcat(SizeDisplayStr,TempStr);
	strcat(SizeDisplayStr," X ");
	itoa(zh,TempStr,10);
	strcat(SizeDisplayStr,TempStr);
	if(y==566) strcat(SizeDisplayStr,")");
	PutsLuna(x,y,BLACK,LILAC, SizeDisplayStr);
}

void VsDisplayZoomFactor(int percent)
{
	char ZoomStr[6];
	int len;

	itoa(percent,ZoomStr,10);
	strcat(ZoomStr,"%");
	rectfill(screen,325,560,355,586,LILAC);
	len=StrLenLuna(ZoomStr);
	PutsLuna(355-len,566,BLACK,LILAC,ZoomStr);
}
void VsImageService(char Mode)
{
	int h,w;
	int ex,ey,ex2,ey2;
	float zoom;
	BITMAP *scrncpy;
	BITMAP *bmp;
	PALETTE pal;
	char savemessage[80]="SAVED AS ";
	int Result;
	char filespec[80];

	zoom = VsZoom*.01;
	h=VsImageH * zoom;
	w=VsImageW * zoom;

	ex=(800-(VsImageW*zoom))/2;
	ey=(600-(VsImageH*zoom))/2;
	ex2=ex+VsImageW*zoom;
	ey2=ey+VsImageH*zoom;

	if(Mode==0) SmoothBlitX(ex,ey,w,h);
	if(Mode==1) SmoothBlitY(screen,ex,ey,w,h);
	if(Mode==2) GrayArea(ex,ey,w,h);

	if(Mode==3) {  /* SAVE AS */
		/* get filename input */
		scrncpy = create_bitmap(800,600);
		clear_bitmap(scrncpy);
		blit(screen, scrncpy, 0, 0, 0, 0, 800, 600);
		Result=FileMenu("bmp");
		blit(scrncpy, screen, 0, 0, 0, 0, 800, 600);
		destroy_bitmap(scrncpy);

		if(Result==0) {
		/* create and save, enforcing bmp extension */
			get_palette(pal);
			bmp=create_sub_bitmap(screen, ex, ey, w, h);
			strcpy(filespec,replace_extension(filespec,PathName,"bmp",80));
			save_bitmap(filespec,bmp,pal);
			destroy_bitmap(bmp);

		/* notify the user */
			rectfill(screen,400,13,700,39,LILAC);
			strcat(savemessage, PathName);
			PutsLuna(400,20,BLACK,LILAC, savemessage);
		}
	}
}

void VsZoomRefresh()
{
	int h, w, lh, lw, sw, sh;
	int ex,ey,ex2,ey2;
	float zoom, prevzoom;

	zoom = VsZoom*.01;
	h=VsImageH * zoom;
	w=VsImageW * zoom;

	clear_to_color(VsBuf,BLACK);
	blit(VsImage,VsBuf,VsOffsetX,VsOffsetY,0,0,718,500);

/* small image file, not to scroll through */
/* If the image is smaller than before, draw it first, then erase
	only the residual portion of the previous image for best effect. */

	if( /*VsZoom < 100 && */  w <= 706 && h <= 500) {
		if(VsPrevZoom > VsZoom) { /* erase around it */
			prevzoom = VsPrevZoom*.01;
			ex=(800-(VsImageW*prevzoom))/2;
			ey=(600-(VsImageH*prevzoom))/2;
			ex2=ex+VsImageW*prevzoom;
			ey2=ey+VsImageH*prevzoom;
			rectfill(screen,ex,ey,ex2,(600-h)/2,BLACK);
			rectfill(screen,ex,((600-h)/2)+h,ex2,ey2,BLACK);
			rectfill(screen,ex,ey,(800-w)/2,ey2,BLACK);
			rectfill(screen,((800-w)/2)+w,ey,ex2,ey2,BLACK);
		}
		stretch_blit(VsBuf,screen,0,0,VsImageW,VsImageH,(800-w)/2, (600-h)/2, w, h);
		return;
	} else {  /* larger image file, to scroll through */
		if(w > 706) w=706;
		if(h > 500) h=500;
		sw=706;
		if(VsImageW < 706) sw=VsImageW;
		sh=500;
		if(VsImageH < 500) sh=VsImageH;

		stretch_blit(VsBuf,screen,0,0,sw,sh,47,50, 706, 500);
		return;
	}

	lw=VsImageW*zoom;
	if(lw > 718) lw=718;
	lh=VsImageH*zoom;
	if(lh > 500) lh=500;

}
void VsRefresh()
{
	if(VsImageW<718 || VsImageH<500) clear_to_color(VsBuf,BLACK);

	blit(VsImage,VsBuf,VsOffsetX,VsOffsetY,0,0,718,500);


	if(VsZoom>1) stretch_blit(VsBuf,screen,0,0,718/2,500/2,41,50,718,500);
		else blit(VsBuf,screen,0,0,41,50,718,500);

/*
Experimental, still
	if(VsZoom>1) SmoothBlit2x(VsBuf,screen,0,0,41,50,718/2,500/2);
		else blit(VsBuf,screen,0,0,41,50,718,500);
*/

}

void VsIndication()
{
	if(VsImageW > 706 && VsImageH > 500) {
		VsScroll=TRUE;
		PutsLuna(178,566, BLACK,LILAC, "SCROLL:");
		LeftArrowSymbol(228,566,BLACK);
		RightArrowSymbol(228+30,566,BLACK);
		UpArrowSymbol(228+60,566,BLACK);
		DownArrowSymbol(228+90,566,BLACK);
	} else {
		PutsLuna(178,566, BLACK,LILAC, "ZOOM -/+");
		UpArrowSymbol(248, 566, BLACK);
		PutsLuna(248+20,566,BLACK,LILAC,"/");
		DownArrowSymbol(248+30, 566, BLACK);
	}
}
int VsLoadImageFile(char *filespec)
{

	MarsF(400-((StrLenMars(3,"LOADING"))*.5), 244, 3, MANGO, BLACK, "LOADING");
	if(strnicmp( "BMP", get_extension(filespec),3)==0) {
		VsImage=load_bitmap(filespec, VsPalette);
		set_palette(VsPalette);
		goto done;
	}
	if(strnicmp( "JPG", get_extension(filespec),3)==0) {
		VsImage = load_jpg(filespec, VsPalette);
		set_palette(VsPalette);
		goto done;
	}
	if(strnicmp( "GIF", get_extension(filespec),3)==0) {
		VsImage=load_gif(filespec, 0);
		set_palette(VsPalette);
		goto done;
	}
done:
	rectfill(screen,0,50,800,550,BLACK);
	if (!VsImage) return(86);
	VsBuf=create_bitmap(718,500);
	clear_to_color(VsBuf,BLACK);
	VsImageW=VsImage->w;
	VsImageH=VsImage->h;
	return(0);
}

void ViewscreenFrame()
{
	int capX;

	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	capX=ColorTitle("VIEWSCREEN",LAVENDER);
	PutsLuna(capX,20, BLACK,LILAC, MakeDisplayName(CurrentFile));
}
void VsScrollLeft(int Amount)
{

	if(VsOffsetX == 0) return;
	VsOffsetX -= Amount;
	if(VsOffsetX <= 0) VsOffsetX = 0;
	VsRefresh();

}
void VsScrollRight(int Amount)
{

	VsOffsetX += Amount;
	if(VsOffsetX >= VsImageW-718/VsZoom) VsOffsetX = VsImageW-718/VsZoom;
	VsRefresh();

}
void VsScrollUp(int Amount)
{
	if(VsOffsetY == 0) return;
	VsOffsetY -= Amount;
	if(VsOffsetY <= 0) VsOffsetY = 0;
	VsRefresh();
}
void VsScrollDown(int Amount)
{
	VsOffsetY += Amount;
	if(VsOffsetY >= VsImageH-500/VsZoom) VsOffsetY = VsImageH-500/VsZoom;
	VsRefresh();
}
int VsImageZoomWindow()
{
	int h, w;
	float zoom;
	int capX;

	VsZoom=100;
	VsPrevZoom=100;
	VsScroll=FALSE;
	PopsicleSticks(LILAC);
	capX=ColorTitle("IMAGE ZOOM",LAVENDER);
	PutsLuna(capX,20, BLACK,LILAC, MakeDisplayName(CurrentFile));
	PutsLuna(68,566, BLACK,LILAC, "SAVE AS: F1");
	PutsLuna(193,566,BLACK,LILAC, "ZOOM:");
	LeftArrowSymbol(228, 566, BLACK);
	RightArrowSymbol(253, 566, BLACK);
	DownArrowSymbol(278, 566, BLACK);
	UpArrowSymbol(303, 566, BLACK);
	VsDisplayZoomFactor(VsZoom);
	VsDisplayZoomedSize(VsZoom,600,20);
	VsDisplayZoomedSize(VsZoom,362,566);
	PutsLuna(457,566, BLACK,LILAC, "GRAY: F7");
	PutsLuna(520,566, BLACK,LILAC, "BLEND X: F8");
	PutsLuna(600,566, BLACK,LILAC, "BLEND Y: F9");
	PutsLuna(679,566, BLACK,LILAC, "CLOSE: F12");
	VsZoomRefresh();

	SecondsCounter=0;

loopback:

	do {
		if(AutorunTimer()==TRUE) return(32);
	} while(!keypressed());

	c = GetKey();
	switch( c )
		{
		case F1: 	VsImageService(3);
				goto loopback;
		case F7: 	VsImageService(2);
				goto loopback;
		case F8: 	VsImageService(0);
				goto loopback;
		case F9: 	VsImageService(1);
				goto loopback;
		case LEFTARROW: VsPrevZoom=VsZoom;
				VsZoom -= 1;
				if(VsZoom < 10) VsZoom=10;
				VsDisplayZoomFactor(VsZoom);
				VsDisplayZoomedSize(VsZoom,362,566);
				VsZoomRefresh();
				goto loopback;
		case RIGHTARROW:   VsPrevZoom=VsZoom;
				VsZoom += 1;
				zoom = VsZoom*.001;
				h=VsImageH * zoom;
				w=VsImageW * zoom;
				if(w >= 706 || h >= 500) VsZoom=VsPrevZoom;
				if(VsZoom > 800) VsZoom=VsPrevZoom;
				if(VsImageH==500 && VsZoom==VsPrevZoom) {
					VsZoom=100; /* special case */
					VsPrevZoom=100;
				}
				if(VsImageW==706 && VsZoom==VsPrevZoom) {
					VsZoom=100; /* special case */
					VsPrevZoom=100;
				}
				VsDisplayZoomFactor(VsZoom);
				VsDisplayZoomedSize(VsZoom,362,566);
				VsZoomRefresh();
				goto loopback;
		case UPARROW:   VsPrevZoom=VsZoom;
				VsZoom += 10;
				zoom = VsZoom*.01;
				h=VsImageH * zoom;
				w=VsImageW * zoom;
				if(w >= 706 || h >= 500) VsZoom=VsPrevZoom;
				if(VsZoom > 800) VsZoom=VsPrevZoom;
				if(VsImageH==500 && VsZoom==VsPrevZoom) {
					VsZoom=100; /* special case */
					VsPrevZoom=100;
				}
				if(VsImageW==706 && VsZoom==VsPrevZoom) {
					VsZoom=100; /* special case */
					VsPrevZoom=100;
				}
				VsDisplayZoomFactor(VsZoom);
				VsDisplayZoomedSize(VsZoom,362,566);
				VsZoomRefresh();
				goto loopback;
		case DOWNARROW: VsPrevZoom=VsZoom;
				VsZoom -= 10;
				if(VsZoom < 10) VsZoom=10;
				VsDisplayZoomFactor(VsZoom);
				VsDisplayZoomedSize(VsZoom,362,566);
				VsZoomRefresh();
				goto loopback;
		case 27:	if(SlideshowActive==FALSE) goto loopback;
				return(27);
		case 32:	if(SlideshowActive==FALSE) goto loopback;
				return(32);
		case BS:	if(SlideshowActive==FALSE) goto loopback;
				return(BS);
		case F12:	return(F12);
		case 350: 	Screenshot792("ImgZoom8.bmp");
				goto loopback;
		case 351: 	Screenshot1024("ImgZoom.bmp");
				goto loopback;
		default: 	goto loopback;
	} while(1);
}
int VsImageScrollWindow()
{
	int capX;
	char SizeDisplayStr[16];
	char HeightStr[5];

	VsZoom=1;
	VsPrevZoom=1;
	VsScroll=TRUE;
	PopsicleSticks(LILAC);
	capX=ColorTitle("IMAGE SCROLL",PURPLE);
	PutsLuna(capX,20, BLACK,LILAC, MakeDisplayName(CurrentFile));
	PutsLuna(178,566, BLACK,LILAC, "SCROLL:");
	LeftArrowSymbol(228,566,BLACK);
	RightArrowSymbol(228+25,566,BLACK);
	UpArrowSymbol(228+50,566,BLACK);
	DownArrowSymbol(228+75,566,BLACK);
	PutsLuna(448,566, BLACK,LILAC, "ZOOM: F2");
	PutsLuna(679,566, BLACK,LILAC, "CLOSE: F12");
	itoa(VsImageW,SizeDisplayStr,10);
	strcat(SizeDisplayStr," X ");
	itoa(VsImageH,HeightStr,10);
	strcat(SizeDisplayStr,HeightStr);
	PutsLuna(600,20,BLACK,LILAC, SizeDisplayStr);

	PopPutTime(0);
	VsRefresh();

	SecondsCounter=0;

loopback:

	do {
		if(AutorunTimer()==TRUE) return(32); 
		PopPutTime(0);
	} while(!keypressed());

	c = GetKey();
	switch( c )
		{
		case F2: if(VsZoom==1) {
				VsZoom=2;
				VsOffsetX += 180;
				VsOffsetY += 125;
				PutsLuna(528,566, BLACK,LILAC, "ENHANCE: F9");

			} else {
				VsZoom=1;
				VsOffsetX -= 180;
				VsOffsetY -= 125;
				rectfill(screen,528,560,600,586,LILAC);
			}
			if(VsOffsetX<0) VsOffsetX=0;
			if(VsOffsetY<0) VsOffsetY=0;
	if(VsOffsetX >= VsImage->w-718/VsZoom) VsOffsetX = VsImage->w-718/VsZoom;
	if(VsOffsetY >= VsImage->h-500/VsZoom) VsOffsetY = VsImage->h-500/VsZoom;

			VsRefresh();
			PanelBeep();
			goto loopback;
		case F9: if(VsZoom==1) goto loopback;
			SmoothBlit2x(VsBuf,screen,0,0,41,50,718/2,500/2);
			SmoothBlitY(screen,41, 50, 716, 498);
			rectfill(screen,528,560,600,586,LILAC);
			PutsLuna(528,566, BLACK,LILAC, "NORMAL: F10");
			goto loopback;
		case F10: if(VsZoom==1) goto loopback;
			VsRefresh();
			goto enhance_message;
		case LEFTARROW: VsScrollLeft(64/VsZoom);
			goto enhance_message;
		case RIGHTARROW: VsScrollRight(64/VsZoom);
			goto enhance_message;
		case UPARROW: VsScrollUp(64/VsZoom);
			goto enhance_message;
		case DOWNARROW: VsScrollDown(64/VsZoom);
			goto enhance_message;
		case PGUPKEY:	VsScrollUp(256/VsZoom);
			goto enhance_message;
		case PGDNKEY:	VsScrollDown(256/VsZoom);
			goto enhance_message;
		case HOMEKEY:	VsScrollLeft(256/VsZoom);
			goto enhance_message;
		case ENDKEY:	 VsScrollRight(256/VsZoom);
			goto enhance_message;
		case 27:	if(SlideshowActive==FALSE) goto loopback;
				return(27);
		case 32:	if(SlideshowActive==FALSE) goto loopback;
				return(32);
		case BS:	if(SlideshowActive==FALSE) goto loopback;
				return(BS);
		case F12:	return(F12);
		case 350:	Screenshot792("ImgScrl8.bmp");
				goto loopback;
		case 351:	Screenshot1024("ImgScrl.bmp");
				goto loopback;
		default:	goto loopback;
	} while(1);

enhance_message:
	if(VsZoom==1) goto loopback;
	rectfill(screen,528,560,600,586,LILAC);
	PutsLuna(528,566, BLACK,LILAC, "ENHANCE: F9");
	goto loopback;
}

void ViewscreenInit()
{
	VsOffsetX = 0; /* was 380 */
	VsOffsetY = 0;
	min_old=70;
}
int Viewscreen(char *filespec)
{
	int Result;
	BITMAP *bmp;

/* save calling screen */
	bmp = create_bitmap(800,600);
	clear_to_color(bmp,BLACK);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);

	ViewscreenInit();
	strcpy(CurrentFile,filespec);

	ViewscreenFrame();
	if(VsLoadImageFile(filespec) !=0) {
		NormalLoadError(filespec);
		Result=86;
		goto out;
	}
	PanelBeep();
	if(VsImageW <= 706 && VsImageH <= 500) Result=VsImageZoomWindow();
		else Result=VsImageScrollWindow();
	destroy_bitmap(VsImage);
	destroy_bitmap(VsBuf);
/* restore calling screen */
out:	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
	return(Result);
}

