/*	 Stardate.c, to calculate the stardate and return it as a string.
	If you call GetStarDate(), the current stardate will be placed
	in the string StarDate. This converts a 21st-century date to a
	negative value using the formula applied in Star Trek: Voyager to
	convert late 24th-century Gregorian dates to stardates, but with
	opposite rounding, since we haven't yet reached the year 2323.
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "stardate.h"

int CalcStardate(int M, int D, double Y, int Hr, int Mn)
{
	int SD;

SD = (Y*1000)+((((1461*(Y+4800+(M-14)/12))/4+(367*(M-2-12*((M-14)/12)))/12
-(3*((Y+4900+(M-14)/12)/100))/4+D-32075)+1
-((1461*(Y+4800+(1-14)/12))/4+(367*(1-2-12*((1-14)/12)))/12
-(3*((Y+4900+(1-14)/12)/100))/4+1-32075))*2.7378)-2323001.5;

	return SD;
}
void GetStarDate()
{
	time_t x;
	struct tm *t;
	char Temp[10];
	int M,D,Hr,Mn;
	double Y;
	int raw;
	float Startime;
	unsigned int ch;

	time(&x);
	t = localtime(&x);

	M = t->tm_mon+1;
	D = t->tm_mday;
	Y = t->tm_year+1900;
	Hr = t->tm_hour;
	Mn = t->tm_min;

	raw=CalcStardate(M, D, Y, Hr, Mn);
	sprintf(Temp, "%d", raw);

	memcpy(StarDate, Temp, 7);

	Startime = (((Hr*60)+Mn)*.0006944444);

	sprintf(Temp,"%f\n", Startime);
	ch='.';
	StarDate[7]=(ch);
	ch=Temp[2];
	StarDate[8]=(ch);
}
/* eof */

