/*	Library.c, menu for selecting and opening library files
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "library.h"

void LbDebugInfo(int val)
{
	char ValStr[8];

	rectfill(screen,440,13,520,27+12,LILAC);
	PutsLuna(450,8+12,BLACK,LILAC, "VAL:");
	itoa(val,ValStr,10);
	PutsLuna(480,8+12,BLACK,LILAC, ValStr);
}

int LibraryRefresh(char col)
{
	int Color,bottom,z,x;
	int head,tail,listlength, partial;
	char TruncateStr[80]; /* to prevent Windows from displaying
				 a long filename */

	if(col==1) {
		Color=MANGO;
		head=0;
		tail=LbListEnd[0]-1;
	}
	if(col==2) {
		Color=PALEBLUE;
		head=LbListEnd[0];
		tail=LbListEnd[1]-1;
	}
	if(col==3) {
		Color=NAPLES;
		head=LbListEnd[1];
		tail=LbListEnd[2]-1;
	}
	if(col==4) {
		Color=DARKGRAY;
		head=LbListEnd[2];
		tail=LbListEnd[3]-1;
	}
	x=15+((col)*175);

	rectfill(screen,x-176,112,x,550, BLACK);
	listlength=tail-head+1;
	bottom=listlength;
	if(bottom>18) bottom=18;
	partial=listlength-LbOffset[col-1];
	if(partial < 18) bottom=partial;

/* LbDebugInfo(partial); */

	for(z=1;z<=bottom;++z) {
		strcpy(TruncateStr, strupr(Ln[z+head+LbOffset[col-1]]));
		TruncateStr[12]=(null);
		RightPutsFont19(x,88+(z*24),Color,TruncateStr);
	}
	return(listlength);
}

void LibraryScreen()
{
	int capX;

	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	capX=ColorTitle(strupr("SELECT FILE"),ORANGE);
	PutsLuna(capX,20,BLACK,LILAC,"LCARS 24 LIBRARY");
	min_old=70;
	PePutTime(ORANGE);
	LeftArrowSymbol(228, 566, BLACK);
	RightArrowSymbol(253, 566, BLACK);
	DownArrowSymbol(278, 566, BLACK);
	UpArrowSymbol(303, 566, BLACK);
	PutsLuna(679,566, BLACK,LILAC, "CLOSE: ESC");
}

void LbSort(int Start, int End)
{
	char bag [LINELENGTH];
	int f;
	int r = 0;
	char done,ch;
	int z,i;

	for(z=Start; z<End; ++z) {
		for( i=0; i<LINELENGTH; ++i) {
				ch=Ln[z][i];
				if( ch !=(null) ) ch=toupper(ch);
				Ln[z][i]=ch;
		}
	}
	do {
	done = TRUE;
		for (f=Start+1; f<End; ++f) {
			r = strcmp(Ln[f],Ln[f+1]);
			if( r > 0 )	 {
				strcpy(bag,Ln[f]);
				strcpy(Ln[f],Ln[f+1]);
				strcpy(Ln[f+1],bag);
				done = FALSE;
			}
		}
	} while ( done == FALSE );
}

void LibraryLoadLists()
{
	struct al_ffblk fblock;
	int Found, z;
	char mask[80];

	for(z = 0; z < LINECOUNT; ++z) memset(Ln[z], (null), LINELENGTH);

	LbListEnd[0] = 0;
	strcpy(mask, LcarsPath);
	strcat(mask, "\\DATA\\*.SFM");
	Found = al_findfirst(mask, &fblock, FA_ARCH);
	while ( !Found ) {
		LbListEnd[0]++;
		strcpy(Ln[LbListEnd[0]], fblock.name);
		Found = al_findnext( &fblock );
	}
	al_findclose( &fblock );
	strcpy(mask, LcarsPath);
	strcat(mask, "\\DATA\\*.MSD");
	Found = al_findfirst(mask, &fblock, FA_ARCH);
	while ( !Found ) {
		LbListEnd[0]++;
		strcpy(Ln[LbListEnd[0]], fblock.name);
		Found = al_findnext( &fblock );
	}
	al_findclose( &fblock );
	LbListStart[0]=0;
	LbListLength[0]=LbListEnd[0];
	LbSort(0, LbListEnd[0]);

	LbListEnd[1]=LbListEnd[0];
	strcpy(mask, LcarsPath);
	strcat(mask, "\\DATA\\*.TXT");
	Found = al_findfirst(mask, &fblock, FA_ARCH);
	while ( !Found ) {
		LbListEnd[1]++;
		strcpy(Ln[LbListEnd[1]], fblock.name);
		Found = al_findnext( &fblock );
	}
	al_findclose( &fblock );
	LbListStart[1]=LbListEnd[0];
	LbListLength[1]=LbListEnd[1]-LbListEnd[0];
	LbSort(LbListEnd[0], LbListEnd[1]);

	LbListEnd[2]=LbListEnd[1];
	strcpy(mask, LcarsPath);
	strcat(mask, "\\DATA\\*.BMP");
	Found = al_findfirst(mask, &fblock, FA_ARCH);
	while ( !Found ) {
		LbListEnd[2]++;
		strcpy(Ln[LbListEnd[2]], fblock.name);
		Found = al_findnext( &fblock );
	}
	al_findclose( &fblock );
	strcpy(mask, LcarsPath);
	strcat(mask, "\\DATA\\*.JPG");
	Found = al_findfirst(mask, &fblock, FA_ARCH);
	while ( !Found ) {
		LbListEnd[2]++;
		strcpy(Ln[LbListEnd[2]], fblock.name);
		Found = al_findnext( &fblock );
	}
	al_findclose( &fblock );
	strcpy(mask, LcarsPath);
	strcat(mask, "\\DATA\\*.GIF");
	Found = al_findfirst(mask, &fblock, FA_ARCH);
	while ( !Found ) {
		LbListEnd[2]++;
		strcpy(Ln[LbListEnd[2]], fblock.name);
		Found = al_findnext( &fblock );
	}
	al_findclose( &fblock );
	LbListStart[2]=LbListEnd[1];
	LbListLength[2]=LbListEnd[2]-LbListEnd[1];
	LbSort(LbListEnd[1], LbListEnd[2]);

	LbListEnd[3]=LbListEnd[2];
	strcpy(mask, LcarsPath);
	strcat(mask, "\\DATA\\*.HTM");
	Found = al_findfirst(mask, &fblock, FA_ARCH);
	while ( !Found ) {
		LbListEnd[3]++;
		strcpy(Ln[LbListEnd[3]], fblock.name);
		Found = al_findnext( &fblock );
	}
	al_findclose( &fblock );
	LbListStart[3]=LbListEnd[2];
	LbListLength[3]=LbListEnd[3]-LbListEnd[2];
	LbSort(LbListEnd[2], LbListEnd[3]);
}

void LbCursor(char cx, char cy, char cmd)
{
	int gx,gy;

	gx=206+((cx-1)*175);
	gy=90+(cy*24);
	if(cmd==0) EnterSymbol(gx,gy,1,BLACK);
		else EnterSymbol(gx,gy,1,WHITE);
}

int LibraryWindowActive()
{
	char label[24];
	int filecount;
	char filecountstr[8];
	int c,OffsetHolder;
	int cx,cy;

	LbOffset[0]=0;
	LbOffset[1]=0;
	LbOffset[2]=0;
	LbOffset[3]=0;
	LibraryScreen();
	LibraryLoadLists();
	filecount=LibraryRefresh(1);
	itoa(filecount,filecountstr,10);
	strcpy(label, "SFML: ");
	strcat(label, filecountstr);
	OfflineType4(60,60, MANGO, label);
	filecount=LibraryRefresh(2);
	itoa(filecount,filecountstr,10);
	strcpy(label, "TEXT: ");
	strcat(label, filecountstr);
	OfflineType4(60+175,60, PALEBLUE, label);
	filecount=LibraryRefresh(3);
	itoa(filecount,filecountstr,10);
	strcpy(label, "IMAGE: ");
	strcat(label, filecountstr);
	OfflineType4(60+(175*2),60, NAPLES, label);
	filecount=LibraryRefresh(4);
	itoa(filecount,filecountstr,10);
	strcpy(label, "HTML (OFF): ");
	strcat(label, filecountstr);
	OfflineType4(60+(175*3),60, DARKGRAY, label);

	cx=cy=1;
	LbOffset[cx-1]=0;
	c=0;
	LbCursor(1,1,1);
	c=PanelBeep();

newcx:
	cy=1;
	LbOffset[cx-1]=0;

loopback:
	do {
		PePutTime(ORANGE); 
	} while(!keypressed());
	c = GetKey();
	switch( c )
	{
		case ESC: 	return(27);
		case 13:  	FileNum=LbListStart[cx-1]+cy;
				return(1);
		case HOMEKEY: 	if(cy==1) goto loopback;
                                OffsetHolder = LbOffset[cx-1];
				LbCursor(cx,cy-LbOffset[cx-1],0);
				cy=1;
				LbOffset[cx-1]=0;
				LbCursor(cx,cy-LbOffset[cx-1],1);
				if(LbOffset[cx-1] != OffsetHolder) LibraryRefresh(cx);
				goto loopback;
		case ENDKEY: 	if(cy==LbListEnd[cx-1]) goto loopback;
                                OffsetHolder = LbOffset[cx-1];
				LbCursor(cx,cy-LbOffset[cx-1],0);
				cy=LbListLength[cx-1];
				LbOffset[cx-1]=LbListEnd[cx-1]-10;
				if(cy < 15) LbOffset[cx-1]=0;
				LbCursor(cx,cy-LbOffset[cx-1],1);
				if(LbOffset[cx-1] != OffsetHolder) LibraryRefresh(cx);
				goto loopback;
		case PGUPKEY: 	if(cy==1) goto loopback;
                                OffsetHolder = LbOffset[cx-1];
				LbCursor(cx,cy-LbOffset[cx-1],0);
				cy-=17;
				LbOffset[cx-1]-=17;
				if(cy < 1) {
					cy=1;
                                        LbOffset[cx-1]=0;
				}
				if(cy > LbListLength[cx-1]) cy=LbListLength[cx-1];
				LbCursor(cx,cy-LbOffset[cx-1],1);
				if(LbOffset[cx-1] != OffsetHolder) LibraryRefresh(cx);
				goto loopback;
		case PGDNKEY: 	if(cy >= LbListLength[cx-1]) goto loopback;
/*				if(LbListLength[cx-1]<18) goto loopback; */
				OffsetHolder = LbOffset[cx-1];
				LbCursor(cx,cy-LbOffset[cx-1],0);
				cy+=17;
				LbOffset[cx-1]+=17;
				if(cy>=LbListEnd[cx-1]-17) {
					cy=LbListEnd[cx-1];
					LbOffset[cx-1]=LbListEnd[cx-1]-13;
				}
				if(cy > LbListLength[cx-1]) {
					LbOffset[cx-1]-=cy-LbListLength[cx-1];
  					cy=LbListLength[cx-1];
				}
				if(cy < 19) LbOffset[cx-1]=0;
				LbCursor(cx,cy-LbOffset[cx-1],1);
				if(LbOffset[cx-1] != OffsetHolder) LibraryRefresh(cx);
				goto loopback;
		case UPARROW: 	if(cy==1) goto loopback;
				LbCursor(cx,cy-LbOffset[cx-1],0);
				--cy;
				if(cy-LbOffset[cx-1] < 1) {
					--LbOffset[cx-1];
					LibraryRefresh(cx);
				}
				LbCursor(cx,cy-LbOffset[cx-1],1);
				goto loopback;
		case DOWNARROW: if( cy >= LbListLength[cx-1]) goto loopback;
				LbCursor(cx,cy-LbOffset[cx-1],0);
				++cy;
				if(cy-LbOffset[cx-1] > 18) {
					++LbOffset[cx-1];
					LibraryRefresh(cx);
				}
				LbCursor(cx,cy-LbOffset[cx-1],1);
				goto loopback;
		case LEFTARROW:
				if(cx==1) goto loopback;
				LbCursor(cx,cy-LbOffset[cx-1],0);
				OffsetHolder = LbOffset[cx-1];
				LbOffset[cx-1] = 0;
				if(OffsetHolder !=0) LibraryRefresh(cx);
				cx--;
				cy=1;
				LbCursor(cx,cy-LbOffset[cx-1],1);
				LbOffset[cx-1]=0;
				goto newcx;
		case RIGHTARROW:
				if(cx==3) goto loopback;
				LbCursor(cx,cy-LbOffset[cx-1],0);
				OffsetHolder = LbOffset[cx-1];
				LbOffset[cx-1] = 0;
				if(OffsetHolder !=0) LibraryRefresh(cx);
				cx++;
				cy=1;
				LbCursor(cx,cy-LbOffset[cx-1],1);
				LbOffset[cx-1]=0;
				goto newcx;
		case CTRL_F1: 	Screenshot792("Lib8.bmp");
				c=PanelBeep();
				goto loopback;
		case CTRL_F2: 	Screenshot1024("Lib10.bmp");
				c=PanelBeep();
				goto loopback;
		default: 	c=ScoldUser();
				goto loopback;
	}

}

