/* 12/25/09 */

/* Jigsaw puzzle app for LCARS 24 */

/* Cursor slowdown at target enhanced with blitted refresh */
/* Basic play perfect */
/* Extra making of cursor erase buffer added to case 13 */
/* Start animation added */

#include "jigsaw.h"

int JgsRefresh()
{
	int p, z;

	rectfill(JgsBackscreen,0,40,800,559,BLACK);
	JgsDrawPuzzleGrid(JgsBackscreen);
	for(z=0; z<48; z++) {
		p=JgsPriority[z];
		if(p != JgsDragging) JgsPlaceOnePiece(JgsBackscreen,p);
	}
	blit(JgsBackscreen,screen,0,0,0,0,800,559);
	blit(JgsBackscreen,screen,130,560,130,560,670,40);

	MakeCursorEraseBmp(45+(JgsX*15),30+(JgsY*15));
	min_old=70;
	PePutTime(ORANGE);
	JgsShowPiecesRemaining();
	return(0);
}
void JgsLoadPuzzleNum()
{
	PACKFILE *Fp;

	strcpy(CurrentFile, LcarsPath);
	strcat(CurrentFile, "\\LC24APPS\\JIGSAW\\PUZZNUM.LC");

	if ( ( Fp=pack_fopen(CurrentFile, "rb" ))==NULL ) {
		return;
	} else{
		JgsPuzzleNum=pack_getc(Fp);
	}
	pack_fclose( Fp );
}
void JgsSavePuzzleNum()
{
	PACKFILE *Fp;

	strcpy(CurrentFile, LcarsPath);
	strcat(CurrentFile, "\\LC24APPS\\JIGSAW\\PUZZNUM.LC");

	if ( ( Fp=pack_fopen(CurrentFile, "wb" ))==NULL ) {
		return;
	} else{
		if(JgsPuzzleNum > NumOfFiles) JgsPuzzleNum=0;
		pack_putc( JgsPuzzleNum, Fp);
	}
	pack_fclose( Fp );
}
int JgsMakeFileList()
{
	struct al_ffblk fblock;
	int Found;
	char mask[80];

	strcpy(mask, LcarsPath);
	strcat(mask, "\\LC24APPS\\JIGSAW\\*.JPG");
	NumOfFiles = 0;
	Found = al_findfirst(mask, &fblock, FA_ARCH);
	if( Found ) {
		return(1);	 /* no puzzle files found */
	}
	while ( !Found ) {
		strcpy(CommonFileArray[NumOfFiles], fblock.name);
		Found = al_findnext( &fblock );
		++NumOfFiles;
	}
	--NumOfFiles;
	al_findclose( &fblock );
	return(0);
}
void JgsShowPiecesRemaining()
{
	char str[5];

	if(JgsPiecesRemaining==0) {
		rectfill(screen,600,13,720,39,LAVENDER);
		return;
	}
	PutsLuna(600,20,BLACK,LAVENDER, "PIECES REMAINING:");

	rectfill(screen,698,13,720,39,LAVENDER);
	itoa(JgsPiecesRemaining,str,10);
	PutsLuna(700,20,BLACK,LAVENDER, str);
}
void JgsPieceLockedMessage(char mode)
{
	if(mode==1) {
		rectfill(screen,500,13,518+StrLenLuna("PIECE LOCKED"),39,BLACK);
		rectfill(screen,506,13,512+StrLenLuna("PIECE LOCKED"),39,ORANGE);
		PutsLuna(510,20,BLACK,ORANGE, "PIECE LOCKED");
		JgsLockedFlag=1;
		JgsPiecesRemaining--;
		JgsShowPiecesRemaining();
	} else {
		rectfill(screen,500,13,599,39,LAVENDER);
		JgsLockedFlag=0;
	}
}
void JgsInfoxy(int x, int y, int pos)
{
	char xstr[5];
	char ystr[5];

return;
	rectfill(screen,pos,13,pos+100,39,LAVENDER);

	itoa(x,xstr,10);
	PutsLuna(pos,20,BLACK,LAVENDER, xstr);

	itoa(y,ystr,10);
	PutsLuna(pos+50,20,BLACK,LAVENDER, ystr);
}
void JgsTopPriority(int level)
{
	int temp,z;

	temp=JgsPriority[level];
	for(z=level; z < 47; z++) JgsPriority[z]=JgsPriority[z+1];
	JgsPriority[47]=temp;
}
void JgsBottomPriority(int level)
{
	int temp,z;

	temp=JgsPriority[level];
	for(z=47; z > 0; z--) JgsPriority[z]=JgsPriority[z-1];
	JgsPriority[0]=temp;
}
void JgsFillOnePiece(int p)
{
	int px,py,sx,sy;

	px=p % 6;
	py=p / 6;
	sx=px*120;
	sy=py*120;

	JgsPiece[p].mapx=sx+60;
	JgsPiece[p].mapy=sy+60;

	/* copy one square of screen to snapshot */
	blit(screen,JgsSegment,210+(60*px)-30,60+(60*py)-30,0,0,120,120);

	/* overlay mask on snapshot, leaving piece inside pink square */
	blit(JgsPieceMap,JgsSegmentMask,sx,sy,0,0,120,120);
	/* switch what masks what */
	floodfill(JgsSegmentMask,32,32,makecol(255,0,255));
	floodfill(JgsSegmentMask,1,1,BLACK);
	/* then hand it off */
	masked_blit(JgsSegmentMask,JgsSegment,0,0,0,0,120,120);
	/* one more mask to set */
	floodfill(JgsSegment,1,1,makecol(255,0,255));
	/* copy piece image to the piece map (the source of the above mask!) */
	masked_blit(JgsSegment,JgsPieceMap,0,0,sx,sy,120,120);
}
void JgsPlaceOnePiece(BITMAP *bmp, int p)
{
	int px,py,sx,sy;

	px=p % 6;
	py=p / 6;
	sx=px*120;
	sy=py*120;

	if(JgsPiece[p].slant == 0) {
		masked_blit(JgsPieceMap,bmp,sx,sy,JgsPiece[p].x-60,JgsPiece[p].y-60,120,120);
	} else {
		clear_to_color(JgsSlantBmp,makecol(255,0,255));
		blit(JgsPieceMap,JgsHandoffBmp,sx,sy,0,0,120,120);
		rotate_sprite(JgsSlantBmp,JgsHandoffBmp,0,0,itofix(JgsPiece[p].slant));
		masked_blit(JgsSlantBmp,bmp,0,0,JgsPiece[p].x-60,JgsPiece[p].y-60,120,120);
	}
}
void JgsHomeOnePiece(BITMAP *bmp, int p)
{
	int px,py,sx,sy;

	px=p % 6;
	py=p / 6;
	sx=(px*120);
	sy=(py*120);

	masked_blit(JgsPieceMap,bmp,sx,sy,JgsPiece[p].homex-60,JgsPiece[p].homey-60,120,120);
}
int JgsLoadPieceMap()
{
	PALETTE the_palette;

	strcpy(CurrentFile, LcarsPath);
	strcat(CurrentFile, "\\LC24APPS\\JIGSAW\\JSMASK48.BMP");
	
	JgsPieceMap=load_bitmap(CurrentFile, the_palette);
	if(!JgsPieceMap) {
		NormalLoadError(CurrentFile);
		return(86);
	}
	JgsPieceMapLoaded=1;
	return(0);
}
void JgsInitPieces()
{
	int sx,sy,p,x,y,z;

	int xlist[48] = {
	 1, 43,  5, 46,  8, 42,  4,  1,  2, 42,  7, 41,  2, 44,  6, 42,
	 2, 42,  7, 43,  2, 41,  3, 42,  1, 43,  5, 41,  8, 42,  4, 40,
	 7, 41,  6, 43,  8, 44,  1, 42,  2, 41,  7, 40,  8, 46,  7, 40
	};
	int ylist[48] = {
	28, 29,  30,  30,  5,  5,  7,  7,  9,  9, 11, 11, 13, 13, 15, 15,
	17, 17, 19, 19, 21, 21, 23, 23, 25, 25, 27, 27, 12, 14, 16, 18,
	28, 29,  31,  31,  5,  5,  7,  7, 25, 25, 27, 27,  6,  8, 29 , 10
	};

	int piece_order[48] = {
	30,24,35,13,27,16,37,29,36,17,12,
	14,19,38,23,34,32,33,25,15,18,31,
	26,40,41,42,43,20,21,22,45,46,47,
	0, 1, 2, 3,
	4,  5, 6, 7, 8, 9,10,11,28,39,44
	};

	int slant;

	sy=90;
	slant=2;
	for(y=0; y<8; y++) {
		sx=240;
		for(x=0; x<6; x++) {
			p=(y*6)+x;
			JgsPiece[p].locked=0;
			JgsPiece[p].homex=sx;
			JgsPiece[p].homey=sy;
			JgsPiece[p].slant=slant;
			JgsPiece[p].x=45+(xlist[p]*15);
			JgsPiece[p].y=30+(ylist[p]*15);
			sx+=60;
			slant+=2;
			if(slant == 26) slant=232;
			if(slant > 254) slant=2;
		}
		sy+=60;
	}

	for(z=0; z < 48; z++) {
		JgsPriority[z]=piece_order[z];
		JgsPiece[z].priority=JgsPriority[z];
	}
}
void JgsMakeCursor()
{
	BITMAP *bmp;
	int dark;

	dark=makecol(24,24,24);

	bmp=create_bitmap(15,21);
	clear_to_color(bmp,makecol(255,0,255));

	line(bmp,0,13,7,6,dark);
	line(bmp,0,12,6,6,dark);

	line(bmp,0,13,7,20,dark);
	line(bmp,0,14,6,20,dark);

	line(bmp,8,6,8,11,dark);
	line(bmp,8,15,8,20,dark);
	line(bmp,10,0,10,11,dark);
	line(bmp,9,15,13,15,dark);
	line(bmp,11,0,13,0,dark);
	line(bmp,14,0,14,15,dark);
	putpixel(bmp,9,11,dark);
	floodfill(bmp,5,13,NAPLES);

	JgsCursorSprite = get_rle_sprite(bmp);
	destroy_bitmap(bmp);
}
int JgsLoadJpeg(char *filespec)
{
	BITMAP *jigsaw_image;
	PALETTE the_palette;

	jigsaw_image=load_jpg(filespec, the_palette);
	if (!jigsaw_image) return(86);
	if(DepthFound > 8) set_palette(the_palette);
	blit(jigsaw_image, screen, 0, 0, 130, 60, 360, 480);
	destroy_bitmap(jigsaw_image);
	return(0);
}
void JgsDisplayFilename()
{
	rectfill(screen,160,1+12,548,39,LAVENDER);
	PutsLuna(160,20,BLACK,LAVENDER,MakeDisplayName(CurrentFile));
}
void JgsPuzzleCompleteMessage()
{
	MarsF(130, 414, 2, ORANGE,BLACK,"PUZZLE COMPLETE");
}
void JgsDrawPuzzleGrid(BITMAP *bmp)
{
	rectfill(bmp,210,60,570,540,makecol(51,51,51));
}
int JgsDisplayCursor(int x, int y)
{
	draw_rle_sprite(screen,JgsCursorSprite,x,y);
	return(0);
}
int JgsEraseCursor(int x, int y)
{
	blit(JgsCursorBackbmp,screen,0,0,x,y,15,21);
	return(0);
}
int MakeCursorEraseBmp(int x, int y)
{
	blit(screen,JgsCursorBackbmp,x,y,0,0,15,21);
	return(0);
}
void JgsBuildJgsDragEraseBmp(int bx, int by, int p)
{

	/* Get a snapshot of whatever is underneath a piece to be dragged,
	   before start of dragging */
	clear_to_color(JgsDragEraseBmp,BLACK);
	JgsRefresh();
	blit(screen,JgsDragEraseBmp,bx,by,0,0,120,120);
}
void JgsCheckLock()
{
	int cx,cy,pointx,pointy,p;

	cx=45+(JgsX*15);
	cy=30+(JgsY*15);
	pointx=cx+1;   	/* tip of the pointer's arrow */
	pointy=cy+13;

	p=JgsDragging;
	pointx=JgsPiece[p].x;
	pointy=JgsPiece[p].y;

	if(pointx > JgsPiece[p].homex-8 &&
	   pointx < JgsPiece[p].homex+8 &&
	   pointy > JgsPiece[p].homey-8 &&
	   pointy < JgsPiece[p].homey+8   ) {

		JgsPiece[p].x=JgsPiece[p].homex;
		JgsPiece[p].y=JgsPiece[p].homey;
		JgsPlaceOnePiece(screen,p);
		JgsPiece[p].locked=1;
		JgsDragging= -1;
		JgsRefresh();
		JgsPieceLockedMessage(1);
		JgsLockedFlag=1;
	}
}
void JgsPickUpPiece()
{
	int cx,cy,pointx,pointy,p,level,done;

	cx=45+(JgsX*15);
	cy=30+(JgsY*15);
	pointx=cx+1;   	/* tip of the pointer's arrow */
	pointy=cy+13;

	done=0;
	level=47;
	do {
		if(level==0) done=1;
		p=JgsPriority[level];
		if(pointx > JgsPiece[p].x-30 &&
		   pointx < JgsPiece[p].x+30 &&
		   pointy > JgsPiece[p].y-30 &&
		   pointy < JgsPiece[p].y+30   ) done=2;
		if(done==0) level--;
	} while(done==0);

	if(done==2) {
		if(JgsPiece[p].locked) {
			JgsRefresh();
			return;
		}
		JgsDragging=p;
		JgsPiece[p].slant=0;
		blit(JgsPieceMap,JgsDragBmp,JgsPiece[p].mapx-60,JgsPiece[p].mapy-60,0,0,120,120);

		JgsBuildJgsDragEraseBmp(JgsPiece[p].x-60,JgsPiece[p].y-60,p);
		masked_blit(JgsDragBmp,screen,0,0,JgsPiece[p].x-60,JgsPiece[p].y-60,120,120);
	}
}
int JgsDrawCursor()
{
	int cx,cy,prevcx,prevcy,p;

	cx=45+(JgsX*15);
	cy=30+(JgsY*15);
	prevcx=45+(JgsPrevX*15);
	prevcy=30+(JgsPrevY*15);

        p=JgsDragging;

	if(JgsDragging != -1) {

		if(cy==JgsPiece[p].homey && JgsCursorRepeat==1 || JgsCursorRepeat==2) {
			if(cx==JgsPiece[p].homex-15 || cx==JgsPiece[p].homex+15) cx=JgsPiece[p].homex;
		}
		if(cx==JgsPiece[p].homex && JgsCursorRepeat==3 || JgsCursorRepeat==4) {
			if(cy==JgsPiece[p].homey-15 || cy==JgsPiece[p].homey+15) cy=JgsPiece[p].homey;
		}

		/* erase */
		blit(JgsDragEraseBmp,screen,0,0,JgsPiece[p].x-60,JgsPiece[p].y-60,120,120);
		/* update erase bmp */
		blit(screen,JgsDragEraseBmp,cx-60,cy-60,0,0,120,120); /* snapshot new background */
		/* show moving piece */
		masked_blit(JgsDragBmp,screen,0,0,cx-60,cy-60,120,120);
		/* kill artifact bug */
		MakeCursorEraseBmp(cx,cy);
		JgsPiece[JgsDragging].x=cx;
		JgsPiece[JgsDragging].y=cy;
JgsInfoxy(JgsPiece[p].homex, JgsPiece[p].homey, 400);
JgsInfoxy(JgsPiece[p].x, JgsPiece[p].y, 600);
		goto bypass;
	}
	JgsEraseCursor(prevcx,prevcy);
	MakeCursorEraseBmp(cx,cy);
bypass:
	JgsDisplayCursor(cx,cy);
	JgsPrevX=JgsX;
	JgsPrevY=JgsY;
	return(0);
}
void JgsCursorLeft()
{
	JgsX--;
	if(JgsCursorRepeat==1) JgsX--;
	if(JgsX < 0) JgsX=0;
	JgsCursorRepeat=1;
	if(JgsX < 0) JgsX=0;
}
void JgsCursorRight()
{
	JgsX++;
	if(JgsCursorRepeat==2) JgsX++;
	if(JgsX > 47) JgsX=47;
	JgsCursorRepeat=2;
}
void JgsCursorUp()
{
	JgsY--;
	if(JgsCursorRepeat==3) JgsY--;
	if(JgsY < 0) JgsY=0;
	JgsCursorRepeat=3;
}
void JgsCursorDown()
{
	JgsY++;
	if(JgsCursorRepeat==4) JgsY++;
	if(JgsY > 32) JgsY=32;
	JgsCursorRepeat=4;
}
void JgsSaveGameInProgress()
{
}
void JgsSetPieces()
{
	int x,y,z,p;

	JgsSegment=create_bitmap(120,120);
	JgsSegmentMask=create_bitmap(120,120);

	for(y=0; y<8; y++) {
		for(x=0; x<6; x++) {
			p=(y*6)+x;
			JgsFillOnePiece(p);
			JgsHomeOnePiece(screen,p);
		}
	}

	JgsDrawPuzzleGrid(screen);

/* strew the pieces */
	for(z=0; z<48; z++) JgsPlaceOnePiece(screen,JgsPriority[z]);


	destroy_bitmap(JgsSegment);
	destroy_bitmap(JgsSegmentMask);
}
void JgsDisplayPictureTitle(char *filespec)
{
	char dest[120];

	replace_extension(dest,filespec,"TXT",120);
	strcpy(CurrentFile,dest);
	LoadTextFile();
	rectfill(screen,559,101,753,181,BLACK);
	PutsLuna(561,101, MANGO, BLACK, Ln[0]);
	PutsLuna(561,121, MANGO, BLACK, Ln[1]);
	PutsLuna(561,141, SEABLUE, BLACK, Ln[2]);
	PutsLuna(561,161, SEABLUE, BLACK, Ln[3]);
}
void JgsScreen()
{
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LAVENDER);
	Title("JIGSAW");

	PutsLuna(172,566, BLACK,LAVENDER, "MOVE CURSOR: ARROW KEYS");
	PutsLuna(378,566, BLACK,LAVENDER, "PICK UP/DROP: ENTER KEY");
	PutsLuna(679,566, BLACK,LAVENDER, "CLOSE: F12");
	PePutTime(ORANGE);

}

int JgsSelectionScreen()
{
	int z;

	if(JgsPiecesRemaining==0) {
		JgsScreen();
		strcpy(CurrentFile, LcarsPath);
		strcat(CurrentFile, "\\LC24APPS\\JIGSAW\\");
		strcat(CurrentFile, CommonFileArray[JgsPuzzleNum]);
		PutsScorpio(561,197, ORANGE, "PUZZLE COMPLETE");
	}

	ButtonType4(543, 96+(4*47), PALEBLUE, "PREV", "F8", BRICK);
	ButtonType4(543, 96+(5*47), SKYBLUE, "NEXT", "F9", SEABLUE);
	ButtonType4(543, 96+(6*47), BIGBLUE, "START", "ENTER", NAPLES);
	ButtonType4(543, 96+(7*47), PALEBLUE, "CLOSE", "F12", ORANGE);

	blit(screen,JgsBackscreen,0,0,0,0,800,600);
	JgsLoadJpeg(CurrentFile);

	blit(screen,JgsBackscreen,110,60,110,60,380,480);
	JgsDisplayFilename();
	JgsDisplayPictureTitle(CurrentFile);

loopback:
	do {
		PePutTime(ORANGE);
	} while(!keypressed());
	c = GetKey();
	switch( c )
		{
			case 13: 	rectfill(screen,520,96,800,500,BLACK);
					for(z=0; z<4; z++) {
						blit(JgsBackscreen,screen,110,60,130+(z*20),60,380,480);
					}
					rectfill(JgsBackscreen,0,40,800,559,BLACK);
					JgsDrawPuzzleGrid(JgsBackscreen);
					return(1);
			case  F8:	JgsPuzzleNum--;
					if(JgsPuzzleNum < 0 ) JgsPuzzleNum=NumOfFiles;
					strcpy(CurrentFile, LcarsPath);
					strcat(CurrentFile, "\\LC24APPS\\JIGSAW\\");
					strcat(CurrentFile, CommonFileArray[JgsPuzzleNum]);
					JgsLoadJpeg(CurrentFile);
					blit(screen,JgsBackscreen,110,60,110,60,380,480);
					JgsDisplayFilename();
					JgsDisplayPictureTitle(CurrentFile);
					rectfill(screen,559,197,753,224,BLACK);
					goto loopback;
			case  F9:	JgsPuzzleNum++;
					if(JgsPuzzleNum > NumOfFiles) JgsPuzzleNum=0;
					strcpy(CurrentFile, LcarsPath);
					strcat(CurrentFile, "\\LC24APPS\\JIGSAW\\");
					strcat(CurrentFile, CommonFileArray[JgsPuzzleNum]);
					JgsLoadJpeg(CurrentFile);
					blit(screen,JgsBackscreen,110,60,110,60,380,480);
					JgsDisplayFilename();
					JgsDisplayPictureTitle(CurrentFile);
					rectfill(screen,559,197,753,224,BLACK);
					goto loopback;
			case F12:
					return(0);
			case CTRL_F1: Screenshot792("Jigsaw8.bmp");
					goto loopback;
			case CTRL_F2: Screenshot1024("Jigsaw10.bmp");
					goto loopback;
			default:        goto loopback;
		}
	return(0);
}

int JgsWindowActive()
{

NextPuzz:
	rectfill(screen,0,40,800,559,BLACK);
	clear_to_color(JgsCursorBackbmp,BLACK);
	if(JgsSelectionScreen()==0) return(0);
	if(JgsLoadPieceMap() !=0) return(1);
	JgsX=30;
	JgsY=25;
	JgsPrevX=30;
	JgsPrevY=25;
	JgsCursorRepeat=0;
	JgsPiecesRemaining=48;
	JgsShowPiecesRemaining();
	JgsInitPieces();
	JgsSetPieces();
	JgsDragging = -1;
	MakeCursorEraseBmp(45+(JgsX*15),30+(JgsY*15));
loopback:
	if(JgsPiecesRemaining==0) goto NextPuzz;

	JgsDrawCursor();
loopback2:
	do {
		PePutTime(ORANGE);
	} while(!keypressed());
	c = GetKey();
	switch( c )
		{
			case F1:        JgsPiecesRemaining=0;
					goto NextPuzz;
			case 27:	JgsRefresh();
				/*	JgsPuzzleCompleteMessage(); */
					goto loopback;
			case 13:        if(JgsDragging != -1) {
						JgsCursorRepeat=0;
						JgsCheckLock();
						JgsDragging = -1;
						goto loopback;
					}
					JgsPickUpPiece();
					JgsCursorRepeat=0;
/* ## */				MakeCursorEraseBmp(45+(JgsX*15),30+(JgsY*15));
					goto loopback;
			case F10:
					goto loopback;
			case F12:

					return(0);
			case LEFTARROW: JgsCursorLeft();
					goto clear_message;
			case RIGHTARROW: JgsCursorRight();
					goto clear_message;
			case PGUPKEY:
			case UPARROW: 	JgsCursorUp();
					goto clear_message;
			case PGDNKEY:
			case DOWNARROW: JgsCursorDown();
					goto clear_message;
			case CTRL_F1: Screenshot792("Jigsaw8.bmp");
					goto loopback;
			case CTRL_F2: Screenshot1024("Jigsaw10.bmp");
					goto loopback;
			default:        goto loopback;
		}
clear_message:
	if(JgsLockedFlag==1) JgsPieceLockedMessage(0);
	goto loopback;
	return(0);
}
void JgsInit()
{
	min_old=70;
	JgsActivity=0;
	JgsPuzzleNum=0;
}
int JigsawMode()
{
	int Result;
	char IsWIP;

	IsWIP=FALSE;
	JgsPieceMapLoaded=0;

	JgsInit();
	JgsScreen();

	if(JgsMakeFileList()) {
		rest(100);
		NormalLoadError("\\LC24APPS\\JIGSAW\\*.JPG");
		return(86);
	}
	CommonSortFiles();
	JgsLoadPuzzleNum();

	strcpy(CurrentFile, LcarsPath);
	strcat(CurrentFile, "\\LC24APPS\\JIGSAW\\");
	strcat(CurrentFile, CommonFileArray[JgsPuzzleNum]);
	JgsDisplayFilename();


	JgsPiecesRemaining=48;
	JgsMakeCursor();
	JgsCursorBackbmp=create_bitmap(15,21);

	JgsDragBmp=create_bitmap(120,120);
	JgsDragEraseBmp=create_bitmap(120,120);
	JgsSlantBmp=create_bitmap(120,120);
	JgsHandoffBmp=create_bitmap(120,120);
	JgsBackscreen=create_bitmap(800,600);

	Result = JgsWindowActive();

	if(JgsPieceMapLoaded==1) destroy_bitmap(JgsPieceMap);
	destroy_rle_sprite(JgsCursorSprite);
	destroy_bitmap(JgsCursorBackbmp);

	destroy_bitmap(JgsDragBmp);
	destroy_bitmap(JgsDragEraseBmp);
	destroy_bitmap(JgsSlantBmp);
	destroy_bitmap(JgsHandoffBmp);
	destroy_bitmap(JgsBackscreen);

	JgsSavePuzzleNum();
	return(Result);
}


