#ifndef FILES24_H
#define FILES24_H

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "lcars24.h"
#include "lccolor.h"
#include "parts.h"
#include "getkey.h"
#include "brack1.h"
#include "headline.h"
#include "playwav.h"
#include "elbows.h"
#include "standby.h"
#include "progedit.h"
#include "sfml.h"
#include "htmview.h"
#include "alarm.h"

char LongLine[30][120];
char F24FolderArray[1000][16];
char F24FileArray[1000][128];
char F24W1Folders[1000][16];
char F24W3Folders[1000][16];

char F24W1FullPath[1000][128]; /* experimental */
char F24W3FullPath[1000][128]; /* experimental */
int F24W1CurrentPathElement;
int F24W3CurrentPathElement;


int F24W1Info[1000][5];
int F24W3Info[1000][5];	/* 0: Num of direct files,
				1: Status	0: Contains no subfolders
					1: Expanded one level (-)
					2: Can be expanded	 (+)
				2: Folder's level within nest (displayed shifted)
				3: Files displayed and folder highlighted or not
					0: Not highlighted
					1: Highlighted		*/
char Content[5];
char F24W1ListTitle[128];
char F24W3ListTitle[128];
char F24W2Path[128];
char F24W4Path[128];
char FileClipboard[128];
char F24W2PastePath[128];
char F24W4PastePath[128];
char SourceFilename[14]; /* to confirm wish to overwrite with this file */
char ImageSizeStr[24];
int MaxX,MaxY,MinX,MinY;
int OldF1x;
int OldF1y;
int F1x;
int F1y;
int OldF2y;
int F2x;
int F2y;
int OldF3x;
int OldF3y;
int F3x,F3y;
int OldF4y;
int F4x;
int F4y;
int dy;
int Olddy;
int F24W1Offset;
int F24W2Offset;
int F24W3Offset;
int F24W4Offset;
int F24W1Current;
int F24W3Current;
int OffsetHolder;
int MidY;
int ActiveWindow;
char F24W2List[1000][128];
int F24W1EndList,F24W2EndList,F24W3EndList,F24W4EndList;
char F24W4List[1000][128];
int NumOfFolders;
char DisplayEmptyRecycle;
char DrivesActive;
char DriveCurrent;
char F24W2Open;
char F24W4Open;
char F24W2MoveOK;
char F24W4MoveOK;
int F24InputPos;
int F24InputY;


/* functions in files24a.c */

void LoadLyricsFile(char *filespec);
int DisplayLyrics(char *LyricsFilespec, char *MidiFilespec);
int F24PlayMidi(char *Song);
int DoMidi(char *Song);
int F24MpxPlay(char *Song);
int F24PlayWav(char *Song);
void F24DisplayGif(char *filespec);
void F24DisplayJpeg(char *filespec);
void F24DisplayBmp(char *filespec);
int ImageView(char *filespec);
void F24Bumpers();
void F24NeElbow();
void F24SeElbow();
void F24NwElbow();
void F24SwElbow();
void F24EraseUpperElbows();
void F24EraseLowerElbows();
void UpperSwitchBox();
void LowerSwitchBox();
void F24EraseUpperSwitchBox();
void F24EraseLowerSwitchBox();
void F24Reinit(char ActiveWindow);
int F24FileView(char *filespec);
int F24Help();
void F24GetNameCursor();
void F24GetNameDisplayInputString();
void F24GetNameCursorLeft();
void F24GetNameCursorRight();
void F24GetNameDel();
void F24GetNameBS();
void F24GetNameDisplayChar();
int F24GetKeyboardInput();
void F24SelectFolder(int x, int y, char *Label, int Hue);
void F24DrawOffline(int x,int y, char *Label);
void F24DrawFolder(int x,int y, char *Label, char Status);
void F24SortFiles();
void F24FindFiles(char *mask);
void F24SortFolders();
int F24FolderExists(char *mask);
void F24ShowFolders();
void F24InspectOneFolder(char *mask);
void F24W1SilentExpand(int treepos);
void F24W3SilentExpand(int treepos);
void F24UpdateAll();
int SaveReport();
void F24RecursiveFolderRename(char *old, char *new);
int F24Dialog(int x, int y, char *Str, char *Str2);
void F24CopyError(int errnum);
int F24Box(int Hue,int Pos,char *Label1,char *Label2,char *Label3,char *Label4);
int F24SmallBox(int Hue,int Pos,char *Label1,char *Label2);
int F24EraseLowerMessageBoxes();
void F24UpperMessageBoxes();
void F24LowerMessageBoxes();

/* functions in files24b.c */

void DrawF24W1();
void F24W1Cursor();
int F24W1FindParent(int Level);
void F24W1Open();
void F24W1Contract( int Level);
void F24W1Expand();
void F24DeleteOneFolder(char *folderspec);
void F24DeleteAllFoldersFromRecycleBin();
void F24W1Nest();
void F24W1Init();
void F24W1Refresh();
void F24MakeFolder();
void F24RenamingProhibitedMessage();
void F24DeletionProhibitedMessage();
void F24RecycleProhibitedMessage();
int F24RenamingProhibitedCheck(char *Str);
void F24W1Rename();
void F24W1DeleteFolder();
int F24W1Active();
void DrawF24W2();
void F24W2Cursor();
void F24W2Refresh();
void F24W2Up();
void F24W2Dn();
void F24W2Clipboard();
void F24W2Delete();
void F24W2Move();
void F24W2Paste();
void F24W2Clear();
void F24W2EmptyRecycle();
void F24W2CopyAll();
int F24W2Active();
void DrawF24W3();
void F24DrivesCursor();
void F24W3Cursor();
int F24W3FindParent(int Level);
void F24Unhighlight();
void F24W3Open();
void F24W3Contract( int Level);
void F24W3Expand();
void F24W3Nest();
void F24W3InitA();
void F24W3InitC();
void F24W3Init();
int F24FileSize(char *mask);
unsigned long F24FloppyDiskSpace();
int F24DriveA();
void F24DriveC();
void F24W3Refresh();
int F24FloppyReady();
int F24CheckFloppy();
int F24Drives();
void F24W3Rename();
void F24W3DeleteFolder();
int F24W3Active();
void DrawF24W4();
void F24W4Cursor();
void F24W4Up();
void F24W4Dn();
void F24W4Clipboard();
void F24W4Delete();
void F24W4Move();
void F24W4Paste();
void F24W4Clear();
void F24W4EmptyRecycle();
void F24W4CopyAll();
void F24W4Refresh();
int F24W4Active();
void F24Screen1();
void F24Circus(int Active);
void F24Init();
int Files24Mode();


#endif

