/* 12/20/09 */
/* Go game for LCARS 24 */


#include "go.h"
#include "goai.h"

void GoDebugControl()
{
	min_old=70;
	PePutTime(ORANGE); 

loopback:
	do {
		PePutTime(BIGBLUE); 
	} while(!keypressed());
	c=GetKey();
	switch( c )
	{
		case 27: 	return;
		default: 	goto loopback;
	}
}


int GoLoadGame()
{
	int MoveNum;

	SetCurrentFile("\\LC24APPS\\GO\\Gogame.txt");
	if( ! exists(CurrentFile)) return(-1);
	LoadTextFile();

	for(y=0; y<19; y++) {
		for(x=0; x<19; x++) {
			if(Ln[y][x]=='X') wallyboard[x][y]=BLACKSIDE;
			if(Ln[y][x]=='O') wallyboard[x][y]=WHITESIDE;
			if(Ln[y][x]=='.') wallyboard[x][y]=EMPTY;
		}
	}
	MoveNum=atoi(Ln[19]);
	debugattack=atoi(Ln[20]);
	thegame.kox=atoi(Ln[21]);
	thegame.koy=atoi(Ln[22]);
	thegame.qpa=atoi(Ln[23]);
	lex=atoi(Ln[24]);
	ley=atoi(Ln[25]);
	return(MoveNum);
}

void GoSaveGame(int MoveNum)
{
	char OutStr[8];

	for(y = 0; y < 32; ++y) memset(Ln[y],0,LINELENGTH);

	for(y=0; y<19; y++) {
		for(x=0; x<19; x++) {
			if(wallyboard[x][y]==BLACKSIDE) Ln[y][x]='X';
			if(wallyboard[x][y]==WHITESIDE) Ln[y][x]='O';
			if(wallyboard[x][y]==EMPTY) Ln[y][x]='.';
		}
	}
	itoa(MoveNum,OutStr,10);
	strcpy(Ln[19],OutStr);

	itoa(debugattack,OutStr,10);
	strcpy(Ln[20],OutStr);

	itoa(thegame.kox,OutStr,10);
	strcpy(Ln[21],OutStr);

	itoa(thegame.koy,OutStr,10);
	strcpy(Ln[22],OutStr);

	itoa(thegame.qpa,OutStr,10);
	strcpy(Ln[23],OutStr);

	itoa(lex,OutStr,10);
	strcpy(Ln[24],OutStr);

	itoa(ley,OutStr,10);
	strcpy(Ln[25],OutStr);

	SetCurrentFile("\\LC24APPS\\GO\\Gogame.txt");
	EndText=26;
	SaveTextFile();
}

void GoPlaceStone(int x, int y, int turn)
{
	int cx,cy;

	cx=69+(x*25);
	cy=74+(y*25);

	if(turn==2) {
		masked_blit(blackstone, screen, 0,0, cx-11, cy-11, blackstone->w, blackstone->h);
		return;
	} else {
	masked_blit(whitestone, screen, 0,0, cx-11, cy-11, whitestone->w, whitestone->h);
		return;
	}
}

void GoRemoveStone(int x, int y)
{
	int cx,cy,Dark;

	cx=69+(x*25);
	cy=74+(y*25);

	Dark=makecol(72,48,23);

	rectfill(screen,cx-11,cy-11,cx+11,cy+13,GoGridColor);

/* redraw erased intersection lines, horiz then vert */
	if(x>0 && y>0 && x<18 && y<18) {  /* typical intesection */
		if(y%3==0) rectfill(screen,cx-11,cy-1,cx+11,cy+2,Dark);
		if(x%3==0) rectfill(screen,cx-1,cy-11,cx+2,cy+13,Dark);
		rectfill(screen,cx-11,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy+13,BLACK);
		return;
	}
	if(x==0 && y==0) {   /* NW corner */
		rectfill(screen,cx,cy-1,cx+11,cy+2,Dark);
		rectfill(screen,cx-1,cy,cx+2,cy+13,Dark);
		rectfill(screen,cx,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy,cx+1,cy+13,BLACK);
		return;
	}
	if(x==0 && y==18) {  /* SW corner */
		rectfill(screen,cx-1,cy-11,cx+2,cy+1,Dark);
		rectfill(screen,cx,cy-1,cx+11,cy+2,Dark);
		rectfill(screen,cx,cy-11,cx+1,cy+1,BLACK);
		rectfill(screen,cx,cy,cx+11,cy+1,BLACK);
		return;
	}
	if(x==18 && y==0) {   /* NE corner */
		rectfill(screen,cx-11,cy-1,cx,cy+2,Dark);
		rectfill(screen,cx-1,cy,cx+2,cy+13,Dark);
		rectfill(screen,cx-11,cy,cx,cy+1,BLACK);
		rectfill(screen,cx,cy,cx+1,cy+13,BLACK);
		return;
	}
	if(x==18 && y==18) {  /* SE corner */
		rectfill(screen,cx-11,cy-1,cx+1,cy+2,Dark);
		rectfill(screen,cx-1,cy-11,cx+2,cy,Dark);
		rectfill(screen,cx-11,cy,cx+1,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy,BLACK);
		return;
	}
	if(y==0) {  /* top */
		rectfill(screen,cx-11,cy-1,cx+11,cy+2,Dark);
		if(x%3==0) rectfill(screen,cx-1,cy,cx+2,cy+13,Dark);
		rectfill(screen,cx-11,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy,cx+1,cy+13,BLACK);
		return;
	}
	if(y==18) {  /* bottom */
		rectfill(screen,cx-11,cy-1,cx+11,cy+2,Dark);
		if(x%3==0) rectfill(screen,cx-1,cy-11,cx+2,cy,Dark);
		rectfill(screen,cx-11,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy,BLACK);
		return;
	}
	if(x==0) {  /* left */
		if(y%3==0) rectfill(screen,cx,cy-1,cx+11,cy+2,Dark);
		rectfill(screen,cx-1,cy-11,cx+2,cy+13,Dark);
		rectfill(screen,cx,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy+13,BLACK);
		return;
	}
	if(x==18) {  /* right */
		if(y%3==0) rectfill(screen,cx-11,cy-1,cx,cy+2,Dark);
		rectfill(screen,cx-1,cy-11,cx+2,cy+13,Dark);
		rectfill(screen,cx-11,cy,cx,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy+13,BLACK);
		return;
	}
}

void GoRefreshBoard()
{
	int x, y;

	for(y=0; y<19; y++) {
		for(x=0; x<19; x++) {
			if(wallyboard[x][y]==BLACKSIDE) GoPlaceStone(x,y,2);
			if(wallyboard[x][y]==WHITESIDE) GoPlaceStone(x,y,1);
			if(wallyboard[x][y]==EMPTY) GoRemoveStone(x,y);
		}
	}
}

void GoWarning(int v)
{
	if(v==1) {
		PutsFont21(561,101, RED, "ILLEGAL MOVE");
		PutsFont21(561,133, RED, "POSITION OCCUPIED");
		GoMessageFlag=1;
		return;
	}
	if(v==2) {
		PutsFont21(561,101, RED, "ILLEGAL MOVE");
		PutsFont21(561,133, RED, "RULE OF KO");
		GoMessageFlag=1;
		return;
	}
	if(v==3) {
		PutsFont21(571,167, RED, "ATARI");
		GoMessageFlag=1;
		return;
	}
	if(v==7) {
		PutsFont21(561,101, RED, "BLACK PASSES");
		GoMessageFlag=1;
		return;
	}

}

void GoEraseWarning()
{
	rectfill(screen,559,101,753,260,BLACK);
	GoMessageFlag=0;
}

void GoTurnMessage(int w)
{
	GoMessageFlag=w;
	rectfill(screen,559,52,753,260,BLACK);

	switch( w )
		{
		case 0:         return;
		case 1: 	PutsScorpio(561,52, SEABLUE, "WHITE'S MOVE");
				return;
		case 2: 	PutsScorpio(561,52, SEABLUE, "BLACK'S MOVE");
				return;
		default:	return;
	}
}

int GoGetRand(int d, int prev)
{
	int Result;

	srand( (unsigned int)time( NULL ) );
	Result = rand() % d;
	if( Result == prev ) ++ Result;
	if( Result > d-1 ) Result = 0;
	return(Result);
}

void GoDisplayCaption()
{
	rectfill(screen,130,1+12,548,39,LAVENDER);
	PutsLuna(130,20,BLACK,LAVENDER,"AI: WALLY 2.1 BY BILL NEWMAN");

	PutsLuna(350,20,BLACK,LAVENDER,"COMPUTER: BLACK");
	PutsLuna(500,20,BLACK,LAVENDER,"PLAYER: WHITE");
	PutsLuna(650,20,BLACK,LAVENDER,"MOVE");
}

void GoDrawEmptyBoard()
{
	int z, Dark;

	Dark=makecol(72,48,23);

	LeftBumper26(73, 52, GoGridColor);
	LeftBumper26(73, 521, GoGridColor);

	RightBumper26(516, 52, GoGridColor);
	RightBumper26(516, 521, GoGridColor);

	rectfill(screen, 47, 65, 542, 532, GoGridColor);
	rectfill(screen, 73, 52, 516, 547, GoGridColor);

	for( z = 0; z < 19; z+=3) {
		line(screen,69,73+(z*25),520,73+(z*25),Dark);
		line(screen,69,76+(z*25),520,76+(z*25),Dark);
	}
	for( z = 0; z < 19; z+=3) {
		line(screen,68+(z*25),74,68+(z*25),525,Dark);
		line(screen,71+(z*25),74,71+(z*25),525,Dark);
	}

	for( z = 0; z < 19; ++z) {
		line(screen,69,74+(z*25),520,74+(z*25),BLACK);
		line(screen,69,75+(z*25),520,75+(z*25),BLACK);
	}
	for( z = 0; z < 19; ++z) {
		line(screen,69+(z*25),74,69+(z*25),525,BLACK);
		line(screen,70+(z*25),74,70+(z*25),525,BLACK);
	}
}

void GoDrawCursor()
{
	int cx,cy;

	cx=69+(GoX*25);
	cy=74+(GoY*25);

	if(getpixel(screen,cx,cy) != SEABLUE) rectfill(screen,cx-6, cy-6, cx+7, cy+7, SEABLUE);
		else {
			if(wallyboard[GoX][GoY]==WHITESIDE) GoPlaceStone(GoX,GoY,1);
			if(wallyboard[GoX][GoY]==BLACKSIDE) GoPlaceStone(GoX,GoY,2);
			if(wallyboard[GoX][GoY]==EMPTY) GoRemoveStone(GoX,GoY);
		}
}

void GoCursorLeft()
{
	--GoX;
	if(GoX < 0) GoX=0;
	if(GoMessageFlag) GoTurnMessage(1);
}

void GoCursorRight()
{
	++GoX;
	if(GoX > 18) GoX=18;
	if(GoMessageFlag) GoTurnMessage(1);
}

void GoCursorUp()
{
	--GoY;
	if(GoY < 0) GoY=0;
	if(GoMessageFlag) GoTurnMessage(1);
}

void GoCursorDown()
{
	++GoY;
	if(GoY > 18) GoY=18;
	if(GoMessageFlag) GoTurnMessage(1);
}

void GoDisplayMoveNum(int i)
{
	char MoveNumStr[4];

	rectfill(screen,680,13,720,39,LAVENDER);
	itoa(i,MoveNumStr,10);
	PutsLuna(680,20,BLACK,LAVENDER, MoveNumStr);
}

void GoDisplayScore()
{
	char ScoreStr[4];

	rectfill(screen,559,52,753,260,BLACK);

	PutsScorpio(561,52, MANGO, "BLACK:");
	PutsScorpio(561,94, MANGO, "WHITE:");

	GoAiScore();
	itoa(BlackScore,ScoreStr,10);
	PutsScorpio(630,52, MANGO, ScoreStr);
	itoa(WhiteScore,ScoreStr,10);
	PutsScorpio(630,94, MANGO, ScoreStr);
}

int GoWindowActive()
{
	int v, MoveNum, Handicap;
	char HelpPath[80];

	GoDrawEmptyBoard();
	Handicap=2;
	GoAiInitGame(Handicap);
	MoveNum=GoLoadGame();
	if(MoveNum == -1) goto NewGame;
	GoRefreshBoard();
	GoX=12;
	GoY=8;
	GoTurn=1;
	v=0;
	GoDisplayMoveNum(MoveNum);
	GoTurnMessage(GoTurn);

loopback:
	GoDrawCursor();
	do {
		PePutTime(ORANGE);
	} while(!keypressed());
	c = GetKey();
	GoDrawCursor();
	switch( c )
		{
			case 13:        if(wallyboard[GoX][GoY] !=EMPTY) {
						GoWarning(1);
						goto loopback;
					}
					if(v==BOTHPASS) goto loopback;
					v=GoAiHumanMove(GoX, GoY, 0);
					GoRefreshBoard();
					GoTurnMessage(2);
					MoveNum++;
					GoDisplayMoveNum(MoveNum);
					AtariWarning=0;
					v=GoAiComputerMove();
					GoRefreshBoard();
					GoTurnMessage(1);
					GoX=ComputerMoveX;
					GoY=ComputerMoveY;
					if(v==7) GoWarning(7);
					if(AtariWarning==1) GoWarning(3);
					MoveNum++;
					if(v==BOTHPASS) GoDisplayScore();
					goto loopback;
			case 27: 	GoTurnMessage(GoTurn+1);
					GoTurn=!GoTurn;
					goto loopback;
			case F8:        Handicap--;
					if(Handicap < 0) Handicap=2;
			case F9:	goto NewGame;
			case F10:	GoDisplayScore();
					goto loopback;
			case F11:	strcpy(HelpPath, LcarsPath);
					strcat(HelpPath,"\\LC24APPS\\PROGEDIT\\PEHELP.TXT");
					OpenHelp(HelpPath);
					min_old=70;
					goto loopback;
			case F12:       GoSaveGame(MoveNum); 
					return(0);
			case LEFTARROW: GoCursorLeft();
					goto loopback;
			case RIGHTARROW: GoCursorRight();
					goto loopback;
			case PGUPKEY:
			case UPARROW: 	GoCursorUp();
					goto loopback;
			case PGDNKEY:
			case DOWNARROW: GoCursorDown();
					goto loopback;
			case CTRL_F1: Screenshot792("Go8.bmp");
					goto loopback;
			case CTRL_F2: Screenshot1024("Go10.bmp");
					goto loopback;
			default:        goto loopback;
		}
NewGame:
	GoDrawEmptyBoard();
	GoAiInitGame(Handicap);
	GoRefreshBoard();
	GoX=12;
	GoY=8;
	GoTurn=1;
	MoveNum=1;
	GoDisplayMoveNum(MoveNum);
	GoTurnMessage(GoTurn);
	v=0;
	goto loopback;
}

void GoScreen()
{
	int top=87;

	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LAVENDER);
	Title("GO");

	PutsLuna(172,566, BLACK,LAVENDER, "MOVE CURSOR: ARROW KEYS");
	PutsLuna(378,566, BLACK,LAVENDER, "PLACE STONE: ENTER KEY");

	ButtonType4(543, top+(4*47), LILAC, "PASS", "ESC", MANGO);
	ButtonType4(543, top+(5*47), BIGBLUE, "HANDICAP", "F8", KHAKI);
	ButtonType4(543, top+(6*47), LILAC, "NEW GAME", "F9", BRICK);
	ButtonType4(543, top+(7*47), BIGBLUE, "SCORE", "F10", SEABLUE);
	ButtonType4(543, top+(8*47), LILAC, "HELP", "F11", TAN);
	ButtonType4(543, top+(9*47), BIGBLUE, "CLOSE", "F12", ORANGE);
}

void GoInit()
{
	min_old=70;
	GoGridColor = makecol(0x99,0x66,0x33);;
}

int GoMode()
{
	int Result;

	GoInit();

	SetCurrentFile("\\LC24APPS\\GO\\WHITESTN.BMP");
	whitestone=load_bitmap(CurrentFile, the_palette);
	if (!whitestone) {
		NormalLoadError(CurrentFile);
		return(86);
	}
	SetCurrentFile("\\LC24APPS\\GO\\BLACKSTN.BMP");
	blackstone=load_bitmap(CurrentFile, the_palette);
	if (!blackstone) {
		NormalLoadError(CurrentFile);
		destroy_bitmap(whitestone);
		return(86);
	}

	GoScreen();
	GoDisplayCaption(); 
	Result = GoWindowActive(); 
	destroy_bitmap(whitestone);
	destroy_bitmap(blackstone);
	return(Result);
}
