/* Prog Edit, the LCARS 24 monospaced, nonwrapping program editor */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "filemenu.h"
#include "text24.h"
#include "sfml.h"
#include "playwav.h"

int capX;
int F2F3Disabled;


void PeClearAllBottomLabels()
{
	rectfill(screen,130,560,752,586, BLACK);
}

void PeBottomLabels()
{
	int bx=0;
	int sp=78;

	rectfill(screen,130,560,752,586, LILAC);
	PutsLuna(135+bx,566, BLACK,LILAC, "SAVE: F1");
	bx+=sp;
	if(F2F3Disabled==TRUE) PutsLuna(135+bx,566, BLACK,LILAC, "COLORS: F2");
		else PutsLuna(135+bx,566, BLACK,LILAC, "OPEN: F2");
	bx+=sp;
	if(F2F3Disabled==TRUE) PutsLuna(135+bx,566, BLACK,LILAC, "GUIDE: F3");
		else PutsLuna(135+bx,566, BLACK,LILAC, "NEW: F3");
	bx+=sp;
	PutsLuna(135+bx,566, BLACK,LILAC, "SAVE AS: F4");
	bx+=sp;
	bx+=sp;
	PutsLuna(135+bx,566, BLACK,LILAC, "MATH: F10");
	bx+=sp;
	PutsLuna(135+bx,566, BLACK,LILAC, "HELP: F11");
	bx+=sp;
	PutsLuna(135+bx,566, BLACK,LILAC, "CLOSE: F12");
}
int PeSafety()
{
	int bx;
	int sp=78;

	bx=sp*2;

	PeClearAllBottomLabels();
	rectfill(screen,130+bx,560,752-(sp*3),586, LILAC);

	PutsLuna(135+bx,566, BLACK,LILAC, "ABANDON: F7");
	bx+=sp;
	PutsLuna(135+bx,566, BLACK,LILAC, "CANCEL: F8");
	bx+=sp;
	PutsLuna(135+bx,566, BLACK,LILAC, "SAVE: F9");

loopback:
	do {
		PePutTime(BIGBLUE);
	} while(!kbhit());
	c=GetKey();
	switch( c )
	{
		case F7: PeBottomLabels();
				return(1);
		case F8:
		case 27: PeBottomLabels();
				return(2);
		case F9: PeBottomLabels();
				return(3);
		default: 	goto loopback;
	}
}
void PeScreen1()
{
	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	capX=ColorTitle(ustrupr("Edit Program"),BIGBLUE);
	PePutTime(BIGBLUE); /* first time, so draws button, too */
	PeBottomLabels();
}

void PeColorChart()
{
	int y=107;
	int t1=21+128;
	int t2=21+211;
	int t3=21+373;
	int t4=21+540;
	char TempEndgame;


	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	capX=ColorTitle(ustrupr("SFML COLOR OUTPUT"),BIGBLUE);


	PutsLuna(679,566, BLACK,LILAC, "CLOSE: ESC");

	TempEndgame=Endgame;
	if(Endgame !=0) {
		PutsLuna(capX,20, BLACK,LILAC, "CURRENT MODE: ENDGAME");
		Endgame=0;
		LcarsColors();
	} else 	PutsLuna(capX,20, BLACK,LILAC, "CURRENT MODE: STANDARD");

	PutsFont21(t1,y-32,BORG,"Endgame Mode");
	PutsFont21(t2+67,y-32,ORANGE,"Standard");
	PutsFont21(t3,y-32,ORANGE,"Standard");
	PutsFont21(t4,y-32,BORG,"Endgame Mode");

	rectfill(screen,t1,y,t1+91,y+36,makecol(0xff,0x99,0x33));
	OfflineType4(t2,y,ORANGE, "ORANGE");
	OfflineType2(t3,y,MANGO, "MANGO");
	PutsFont19(t4, y+13, MANGO, "same");
	y+=47;
	rectfill(screen,t1,y,t1+91,y+36,makecol(0xff,0xcc,0xff));
	OfflineType4(t2,y,LILAC, "LILAC");
	OfflineType2(t3,y,PURPLE, "VIOLET");
	rectfill(screen,t4,y,t4+91,y+36,makecol(0x99,0x66,0x99));
	y+=47;
	rectfill(screen,t1,y,t1+91,y+36,makecol(0xff,0x66,0x66));
	OfflineType4(t2,y,BRICK, "BRICK");
	OfflineType2(t3,y,NAPLES, "NAPLES");
	PutsFont19(t4, y+13, NAPLES, "same");
	y+=47;
	rectfill(screen,t1,y,t1+91,y+36,makecol(0x33,0xff,0xcc));
	OfflineType4(t2,y,SKYBLUE, "SKYBLUE");
	OfflineType2(t3,y,PALEBLUE, "PALEBLUE");
	rectfill(screen,t4,y,t4+91,y+36,makecol(0x33,0xcc,0x99));
	y+=47;
	PutsFont19(t1+57, y+13, BIGBLUE, "same");
/*	rectfill(screen,t1,y,t1+91,y+36,makecol(0xff,0xcc,0x66)); */
	OfflineType4(t2,y,BIGBLUE, "BIGBLUE");
	OfflineType2(t3,y,TAN, "TAN");
	rectfill(screen,t4,y,t4+91,y+36,makecol(0xff,0x00,0x66));
	y+=47;
	PutsFont19(t1+57, y+13, LAVENDER, "same");
	OfflineType4(t2,y,LAVENDER, "LAVENDER");
	OfflineType2(t3,y,BORG, "BORG");
	PutsFont19(t4, y+13, BORG, "same");
	y+=47;
	PutsFont19(t1+57, y+13, SEABLUE, "same");
	OfflineType4(t2,y,SEABLUE, "SEABLUE");
	OfflineType2(t3,y,KHAKI, "KHAKI");
	PutsFont19(t4, y+13, KHAKI, "same");
	y+=47;
	PutsFont19(t1+57, y+13, RED, "same");
	OfflineType4(t2,y,RED, "RED");
	OfflineType2(t3,y,DARKRED, "DARKRED");
	PutsFont19(t4, y+13, DARKRED, "same");
	y+=47;
	PutsFont19(t1+57, y+13, WHITE, "same");
	OfflineType4(t2,y,WHITE, "WHITE");
	OfflineType2(t3,y,OLIVE, "OLIVE");
	PutsFont19(t4, y+13, OLIVE, "same");

	Endgame=TempEndgame;
	if(Endgame !=0) LcarsColors();

loopback:
	do {
	} while(!kbhit());
	c=GetKey();
	switch( c )
	{

		case 27: PeScreen1();
			T24RefreshAll();
			return;
		case 350: Screenshot792("Colnames.bmp");
			goto loopback;
		default: 	goto loopback;
	}
}

void PeInfoxy()
{
	char LineNum[8];
	char ColNum[4];

	if( y < 0 ) y=0;
	rectfill(screen,440,13,520,39,LILAC);
	PutsLuna(450,20,BLACK,LILAC, "LINE");
	itoa(y+1,LineNum,10);
	PutsLuna(480,20,BLACK,LILAC, LineNum);
	rectfill(screen,520,13,600,39,LILAC);
	PutsLuna(520,20,BLACK,LILAC, "COL");
	itoa(x,ColNum,10);
	PutsLuna(550,20,BLACK,LILAC, ColNum);
}

void PeDisplayFilename()
{
	rectfill(screen,capX,13,600,39,LILAC);
	PutsLuna(capX,20,BLACK,LILAC,MakeDisplayName(CurrentFile));
}
void PeDisplayFrameTop()
{
	rectfill(screen,47,13,MaxX-12-126,39,LILAC);
	capX=ColorTitle(ustrupr("Edit Program"),BIGBLUE);
	PeDisplayFilename();
}

int PePick(char MenuMode[10])
{
	int Result;

	strcpy(Mode,MenuMode);

	if(strcmp(Mode,"NEW")==0) {
		strcpy( CurrentFile, PathName);
		PeDisplayFrameTop();
		LoadSourceCode();	 /* ?? */
		x=1;
		y=0;
		Offset=0;
		T24RefreshAll();
		ShiftSelectOff();
		return(0);
	}
	Result=FileMenu(get_extension(CurrentFile));
	rectfill(screen,0,0,800,600,BLACK);
	PeScreen1();
	if(strcmp(Mode,"OPEN")==0) {
		strcpy( CurrentFile, PathName);
		PeDisplayFrameTop();
		LoadSourceCode();
		x=1;
		y=0;
		Offset=0;
		T24RefreshAll();
		ShiftSelectOff();
		return(0);
	}
	if(strcmp(Mode,"ESC")==0) {
		PeDisplayFrameTop();
		T24RefreshAll();
		return(0);
	}
	if(strcmp(Mode,"SAVE AS")==0) {
		strcpy( CurrentFile, PathName);
		PeDisplayFrameTop();
		T24RefreshAll();
		SaveTextFile();
		Action=0;
		SavedAs=TRUE;
		return(0);
	}
	return(0);
}

void PeDoSave()
{
	rectfill(screen,130,560,190,586, ORANGE);
	rectfill(screen,184,560,190,586, BLACK);
	PutsLuna(135,566, BLACK,ORANGE, "SAVING");

	SaveTextFile();
	PanelBeep();
	rectfill(screen,130,560,190,586, LILAC);
	PutsLuna(135,566, BLACK,LILAC, "SAVE: F1");
	Action=0;
}
int PeDoOpen()
{
	if(Action!=0) {
		Result=PeSafety();
			if(Result==1) {
			PePick("OPEN");
			Action=0;
			goto out;
		}
		if(Result==2) {
			PeDisplayFrameTop();
			return(0);
		}
		if(Result==3) {
			SaveTextFile();
			PePick("OPEN");
			Action=0;
			goto out;
		}
	} else {
		PePick("OPEN");
		Action=0;
	}
out:
	if(load_abort==TRUE) {
		T24ClearWindow();
		strcpy(CurrentFile,"NAMELESS.TXT");
		PeDisplayFrameTop();
		load_abort=FALSE;
		file_too_long=FALSE;
	}
	return(0);
}

int PeDoNew()
{
	if(Action!=0) {
		Result=PeSafety();
			if(Result==1) {
				T24ClearWindow();
				strcpy(CurrentFile,"NAMELESS.TXT");
				PeDisplayFrameTop();
				return(0);
			}
			if(Result==2) {
				PeDisplayFrameTop();
				return(0);
			}
			if(Result==3) {
/*				T24Box(NAPLES, 1, "SAVING", ""); */
				SaveTextFile();
				Action=0;
/*				T24Box(MANGO, 1, "SAVE (S)","F1"); */
				T24ClearWindow();
				strcpy(CurrentFile,"NAMELESS.TXT");
				PeDisplayFrameTop();
				return(0);
			}
		} else {
			T24ClearWindow();
			strcpy(CurrentFile,"NAMELESS.TXT");
			PeDisplayFrameTop();
			return(0);
	}
	return(1);
}

void PeDoSaveAs()
{
	PePick("SAVE AS");
}

void PeDoFind()
{
	if(EndText >1) T24Find();
	if(NoFind==FALSE) MarkWord=1;
	PeDisplayFrameTop();
}
void PeDoFindAndReplace()
{
	if(EndText >1) T24FindAndReplace();
	PeDisplayFrameTop();
}
void PeDoNext()
{
	if(NoFind==FALSE) {
		WordRight();
		T24NextFind();
	}
	if(NoFind==FALSE) MarkWord=1;
	if(FindMode==2) MarkWord=0;
	PeDisplayFrameTop();
}
void PeDoHelp()
{
	OpenHelp("C:\\LCARS24\\LC24APPS\\PROGEDIT\\PEHELP.TXT");
	min_old=70;
}
void PeDoGuide()
{
	OpenHelp("C:\\LCARS24\\DATA\\SFML.TXT");
	min_old=70;
}
void PeDoMath()
{  /* saves the screen then restores it after Math module closes */
	BITMAP *bmp = create_bitmap(800,600);

	clear_bitmap(bmp);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	MathMode();
	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
}
void PeClearWindow()
{
	for (y=0; y < LINECOUNT-1; ++y) {
		memset(Ln[y],(null),LINELENGTH);
	}
	y=0;
	x=1;
	EndText=1;
	Offset=0;
	Action=0;
	rectfill(screen,0, 50, 800, 549,BLACK);
}
void PePutOneChar()
{
	unsigned int q,z;

	if( c < 32 && c != 9) return;

	q=StrLenFont21(Ln[y]);
	k=strlen( Ln[y] );
	if(k > LINELENGTH-9) return; /* with LINELENGTH of 96 */
	if(x > LINELENGTH-8) return;
	if(x <= k) for(z=k; z >= x; --z) Ln[y][z]=Ln[y][z-1];
	Ln[y][x-1] =( c );
	Ln[y][k+1]=(null);
	if( c==9 || x <k) T24DisplayString();
		else T24DisplayRight();
	CursorRight();
}
void PeDisplayPreviewLabel()
{
	if(F2F3Disabled==FALSE) return; /* not SFML */
	PutsLuna(667,20,BLACK,LILAC, "PREVIEW: ESC");
}
void PePreviewSFML()
{
char LoadedFile[80];

	if(F2F3Disabled==FALSE) return; /* not SFML */

/* If the SFML page called a text file, temporarily save this buffer */
	if(SfmIndexLoaded==TRUE) {
		strcpy(LoadedFile, CurrentFile);
		strcpy(CurrentFile, "C:\\lcars24\\system\\temp.txt");
		SaveTextFile();
	}

	OpenSfml("*"); /* false filename to signal no load */

/* Restore buffer if temporarily saved above, as well as orginal filename */
	if(SfmIndexLoaded==TRUE) {
		strcpy(CurrentFile, "C:\\lcars24\\system\\temp.txt");
		LoadSourceCode();
		strcpy(CurrentFile, LoadedFile);
	}
/* No need to redisplay if reloading, since at this point the screen
display was taken from a screenshot taken before previewing */


/* debugging aides for preview of an SFML page that loads a text file */
/*
rectfill(screen,250,13,600,39,SEABLUE);
PutsLuna(260,20,BLACK,SEABLUE,CurrentFile);
rectfill(screen,550,13,770,39,BORG);
PutsLuna(560,20,BLACK,BORG,LoadedFile);
*/
}
int PeEdit()
{
	int Result;
	int Saved=0;

	PeDisplayPreviewLabel();
	x=1;
	y=0;
	T24DrawCursor();
	SavedAs=FALSE;

loopback:
	PeInfoxy();
	T24DrawCursor();
	do {
		PePutTime(BIGBLUE);
	} while(!kbhit());
	c=GetKey();
	T24DrawCursor();
	switch( c )
	{
		case 1:  SelectAll();
			goto loopback;
		case 3:  T24DoCopy();
			goto loopback;
		case 4:	HighlightWord();
			goto loopback;
		case 6:  PeDoFind();
			goto loopback;
		case 8:  if(ControlKeyStatus() != 0) PeDoFindAndReplace();
				else Backspace();
			Action=1;
			goto loopback;
		case 9:	Tab();
			Action=1;
			goto loopback;
		case 12: PeDoNext();
			Action=1;
			goto loopback;
		case 13: Xreturn();
				Action=1;
				goto loopback;
		case 20: T24DoTextColor();
				goto loopback;
		case 21: CtrlU();
				goto loopback;
		case 22: T24DoPaste();
				goto loopback;
		case 24: T24DoCut();
				goto loopback;
		case 25: CtrlY();
				Action=1;
				goto loopback;
		case 27:	PePreviewSFML();
				goto loopback;
		case LEFTARROW: if(ShiftKeyStatus() != 0) SelectLeft();
					else CursorLeft();
				goto loopback;
		case RIGHTARROW: if(ShiftKeyStatus() != 0) SelectRight();
					else CursorRight();
				goto loopback;
		case CTRLUPARROW:
		case UPARROW:  if(ShiftKeyStatus() != 0) SelectUp();
					else CursorUp();
				goto loopback;
		case CTRLDOWNARROW:
		case DOWNARROW: if(ShiftKeyStatus() != 0) SelectDown();
					else CursorDown();
				goto loopback;
		case DELKEY: DelKey();
				Action=1;
				goto loopback;
		case PGUPKEY: PageUp();
				goto loopback;
		case PGDNKEY: PageDown();
				goto loopback;
		case HOMEKEY: CursorBOL();
				goto loopback;
		case ENDKEY: CursorEOL();
				goto loopback;
		case CTRLLEFTARROW: WordLeft();
				goto loopback;
		case CTRLRIGHTARROW: if(ShiftKeyStatus() != 0) SelectWordRight();
						else WordRight();
				goto loopback;
		case CTRLHOMEKEY: TopOfFile();
				goto loopback;
		case CTRLENDKEY: BottomOfFile();
				goto loopback;
		case F1:
		case 19: PeDoSave();
				Saved=1;
				goto loopback;
		case F2: if(F2F3Disabled==TRUE) {
				PeColorChart();
				goto loopback;
			 } else {
				PeDoOpen();
				goto loopback;
			 }
		case 15: if(F2F3Disabled==TRUE) goto loopback;
                		else PeDoOpen();
				goto loopback;
		case F3: if(F2F3Disabled==TRUE) {
				PeDoGuide();
				goto loopback;
			 } else {
				PeDoNew();
				goto loopback;
			 }
		case F4: PeDoSaveAs();
				Saved=1;
				goto loopback;
		case F10: PeDoMath();
				goto loopback;
		case F11:	PeDoHelp();
				PanelBeep();
				goto loopback;
		case F12: if(Action!=0) {
				Result=PeSafety();
				if(Result==1) return(Saved);
				if(Result==2) {
					goto loopback;
				}
				if(Result==3) {
					SaveTextFile();
					Saved=1;
					NoEdit=FALSE;
					return(Saved);
				}
			} else {
					NoEdit=FALSE;
					return(Saved);
			}
		case 350: Screenshot792("Proged8.bmp");
			goto loopback;
		case 351: Screenshot1024("Proged10.bmp");
			goto loopback;
		default: if( c > 31 && c < 126) {
				PePutOneChar();
				Action=1;
			}
		goto loopback; /* unreachable safety net */
	}
}
int ProgEditMode(char *filespec)
{
	int Result,z;

	T24Init();
	min_old=70;
	MonoType=1;
	lp=24;
	NumLns=21;
	min_old=70;
	PeScreen1();
	strcpy(CurrentFile, filespec);
	PeDisplayFilename();
	T24buf=create_bitmap(784,504);
	T24linebuf=create_bitmap(784,lp);
	T24ClearWindow();
	AutoCorrectOff=TRUE;
	F2F3Disabled=FALSE;
	if(memicmp(CurrentFile,"NAMELESS.TXT",12) != 0) {
		strcpy( CurrentFile, filespec);
		if( LoadSourceCode() !=0) PeScreen1();
		PeDisplayFilename();
		if(strnicmp("SFM",get_extension(filespec),3)==0) {
			F2F3Disabled=TRUE;
			PeBottomLabels();
		}
		if(strnicmp("MSD",get_extension(filespec),3)==0) {
			F2F3Disabled=TRUE;
			PeBottomLabels();
		}
	}
	T24RefreshAll();
	T24DrawCursor();
	PanelBeep();
	Result=PeEdit();
	destroy_bitmap(T24buf);
	destroy_bitmap(T24linebuf);
	MonoType=0;
	F2F3Disabled=FALSE;
	return(Result);
}
int OpenProgEdit(char *filespec)
{	/* saves the screen then restores it when the editor closes */
	/* for calling the monotype program editor with a filename to open */

	BITMAP *bmp = create_bitmap(800,600);
	int Result;

	clear_bitmap(bmp);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	Result=ProgEditMode(filespec);

	if( strnicmp("BAT", get_extension(filespec),3 )==0 ) Result=0;
	if( strnicmp( "CPP", get_extension(filespec),3 )==0 ) Result=0;
	if( strnicmp( "PAS", get_extension(filespec),3 )==0 ) Result=0;
	if( stricmp("C", get_extension(filespec))==0) Result=0;
	if( stricmp("H", get_extension(filespec))==0) Result=0;
	if( stricmp("CONFIG.SYS", get_filename(filespec))==0) Result=0;
	if( strnicmp( "KK8", get_extension(filespec),3 )==0 ) Result=0;
	if( strnicmp( "SDK", get_extension(filespec),3 )==0 ) Result=0;
	if( strnicmp( "XWD", get_extension(filespec),3 )==0 ) Result=0;

	if(Result==0) {
		rectfill(screen,0,0,800,600, BLACK);
		blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	}
	destroy_bitmap(bmp);
	return(Result);
}


